{$G+}

Unit M13HUtil;

Interface

Uses
  M13HP;

Procedure FadeIn  ( Palette : PaletteStyle );
Procedure FadeOut ( Palette : PaletteStyle );
Procedure Dither  ( Palette : PaletteStyle );
Procedure Chaos   ( Page : PageStyle; Time   : Word; Mode : Byte );
Procedure Mosaic  ( Page : PageStyle; ZoomIO : Boolean );
Procedure ESPShow ( Page : PageStyle; Mode   : Byte );

Const
  ZoomIn  = True;
  ZoomOut = False;

Implementation

Procedure FadeIn;

Var
  Loop1 : Word;
  Loop2 : Byte;
  Red   : Byte;
  Green : Byte;
  Blue  : Byte;

Begin
  Port [ $3C8 ] := 0;
  For Loop1 := 0 To 1024 Do
    For Loop2 := 0 To 255 Do
      Begin
        Red   := ( Palette [ Loop2, 0 ] * Loop1 ) Shr 10;
        Green := ( Palette [ Loop2, 1 ] * Loop1 ) Shr 10;
        Blue  := ( Palette [ Loop2, 2 ] * Loop1 ) Shr 10;
        Port [ $3C9 ] := Red;
        Port [ $3C9 ] := Green;
        Port [ $3C9 ] := Blue;
      End
End;


Procedure FadeOut;

Var
  Loop1 : Word;
  Loop2 : Byte;
  Red   : Byte;
  Green : Byte;
  Blue  : Byte;

Begin
  Port [ $3C8 ] := 0;
  For Loop1 := 1024 DownTo 0 Do
    For Loop2 := 0 To 255 Do
      Begin
        Red   := ( Palette [ Loop2, 0 ] * Loop1 ) Shr 10;
        Green := ( Palette [ Loop2, 1 ] * Loop1 ) Shr 10;
        Blue  := ( Palette [ Loop2, 2 ] * Loop1 ) Shr 10;
        Port [ $3C9 ] := Red;
        Port [ $3C9 ] := Green;
        Port [ $3C9 ] := Blue;
      End
End;


Procedure Dither;

  Function Average ( R, G, B : Word ) : Word; Assembler;

  Asm
    MOV   AX,   R
    MOV   DX,  30
    MUL   DX
    MOV   BX,  AX
    MOV   AX,   G
    MOV   DX,  59
    MUL   DX
    ADD   BX,  AX
    MOV   AX,   B
    MOV   DX,  11
    MUL   DX
    ADD   AX,  BX
    MOV   DL, 100
    DIV   DL
    XOR   AH,  AH
  End;

Var
  PS    : Array [ 0..255, 0..2 ] of Integer;
  Loop1 : Byte;
  Loop2 : Byte;
  Ave   : Byte;
  Red   : Byte;
  Green : Byte;
  Blue  : Byte;

Begin
  For Loop1 := 0 To 255 Do
    Begin
      Ave := Average ( Palette [ Loop1, 0 ],
                       Palette [ Loop1, 1 ],
                       Palette [ Loop1, 2 ]  );
      PS [ Loop1, 0 ] := Ave - Palette [ Loop1, 0 ];
      PS [ Loop1, 1 ] := Ave - Palette [ Loop1, 1 ];
      PS [ Loop1, 2 ] := Ave - Palette [ Loop1, 2 ]
    End;
  Port [ $3C8 ] := 0;
  For Loop1 := 0 To 255 Do
    For Loop2 := 0 To 255 Do
      Begin
        Red   := Palette [ Loop2, 0 ] +
                 ( ( PS [ Loop2, 0 ] * Loop1 ) Div 255 );
        Green := Palette [ Loop2, 1 ] +
                 ( ( PS [ Loop2, 1 ] * Loop1 ) Div 255 );
        Blue  := Palette [ Loop2, 2 ] +
                 ( ( PS [ Loop2, 2 ] * Loop1 ) Div 255 );
        Port [ $3C9 ] := Red;
        Port [ $3C9 ] := Green;
        Port [ $3C9 ] := Blue
      End
End;


Procedure Chaos;

Const
  ModeTable : Array [ 1 .. 14 ] of Word =
    ( 13477,    65,   337,   129,   257,   513,   769,
       1025,   481,  4097,  5121,   177, 16385, 16897   );

Var
  X, Y  : Word;
  Loop  : Word;
  Value : Word;
  Count : Word;
  Clock : LongInt Absolute $0040:$006C;
  RTime : LongInt;
  Cmpt  : Real;
  CptXY : Word;

Begin
  RTime := Clock;
  Count := 0;
  CptXY := 0;
  If ( Mode < 1 ) or ( Mode > 14 )
    Then Exit;
  Value := ModeTable [ Mode ];
  Cmpt := ( 0.0182 * Time ) / 64000;
  For Loop := 0 To 65535 Do
    Begin
      Asm
        XOR DX, DX
        MOV AX, CptXY
        MOV BX, 0140H
        DIV BX
        MOV X,  DX
        MOV Y,  AX
      End;
      If ( Y <= $C8 )
        Then PutPixel ( Screen, X, Y, Page^ [ Y, X ] );
      Asm
        MOV AX, CptXY
        MUL Value
        INC AX
        MOV CptXY, AX
      End;
    Inc ( Count );
    While ( Clock < ( RTime + Count * Cmpt ) ) Do Begin End
  End
End;


Procedure Mosaic; Assembler;

Var
  X           : Word;
  Y           : Word;
  SizeX       : Word;
  SizeY       : Word;
  Count       : Word;
  VRamOffset  : Word;
  ImageOffset : Word;

Asm
  CLD
  PUSH            DS
  LDS             SI,          Page
  MOV             AX,    SEG Screen
  MOV             ES,            AX
  MOV             DI, OFFSET Screen
  MOV             AX,     ES:[DI+2]
  MOV             DX,       ES:[DI]
  MOV             ES,            AX
  MOV             DI,            DX
  MOV     VRamOffset,            DI
  MOV    ImageOffset,            SI
  XOR             AX,            AX
  MOV              X,            AX
  MOV              Y,            AX
  MOV          Count,         0050H
  CMP         ZoomIO,            AL
  JNZ        @Mosaic
  MOV          Count,         0002H
@Mosaic :
  MOV             AX,         Count
  MOV          SizeX,            AX
  MOV          SizeY,            AX
@CheckSizeX :
  MOV             AX,         SizeX
  ADD             AX,             X
  MOV             DX,         0140H
  CMP             AX,            DX
  JB     @CheckSizeY
  SUB             DX,             X
  MOV          SizeX,            DX
@CheckSizeY :
  MOV             AX,         SizeY
  ADD             AX,             Y
  MOV             DX,         00C8H
  CMP             AX,            DX
  JB  @SetVRamOffset
  SUB             DX,             Y
  MOV          SizeY,            DX
@SetVRamOffset :
  MOV             DI,    VRamOffset
  MOV             SI,   ImageOffset
  MOV             AX,         0140H
  MUL              Y
  ADD             AX,             X
  ADD             SI,            AX
  ADD             DI,            AX
  LODSB
  MOV             AH,            AL
  MOV             DX,         0140H
  SUB             DX,         SizeX
  SHR          SizeX,           01H
  MOV             BX,         SizeY
@Loop :
  MOV             CX,         SizeX
  REP          STOSW
  TEST            DX,           01H
  JZ @Next
  STOSB
@Next :
  ADD             DI,            DX
  DEC             BX
  JNZ          @Loop
  MOV             AX,         Count
  ADD              X,            AX
  MOV             AX,         0140H
  CMP              X,            AX
  JB         @Mosaic
  MOV             AX,         Count
  ADD              Y,            AX
  MOV             AX,         00C8H
  CMP              Y,            AX
  MOV              X,           00H
  JB         @Mosaic
  CMP         ZoomIO,           00H
  JZ         @ZoomIn
  DEC          Count
  MOV              Y,         0000H
  CMP          Count,         0001H
  JNZ        @Mosaic
  JMP      @LastView
@ZoomIn :
  INC          Count
  MOV              Y,         0000H
  CMP          Count,         0050H
  JB         @Mosaic
  JMP          @Exit
@LastView :
  MOV             DI,    VRamOffset
  MOV             SI,   ImageOffset
  MOV             CX,         7D00H
  REP          MOVSW
@Exit :
  POP             DS
End;


Procedure ESPShow;

Var
  LoopX, LoopY : Word;

Begin
  Case Mode of
    1 :
      For LoopY := 0 To 199 Do
        For LoopX := 0 To 319 Do
          DrawVLine ( Screen,
                      LoopX, LoopY, 199,
                      Page^ [ LoopY, LoopX ] );
    2 :
      For LoopY := 199 DownTo 0 Do
        For LoopX := 0 To 319 Do
          DrawVLine ( Screen,
                      LoopX, 0, LoopY,
                      Page^ [ LoopY, LoopX ] );
    3 :
      For LoopX := 0 To 319 Do
        For LoopY := 0 To 199 Do
          DrawHLine ( Screen,
                      LoopX, 319, LoopY,
                      Page^ [ LoopY, LoopX ] );
    4 :
      For LoopX := 319 DownTo 0 Do
        For LoopY := 0 To 199 Do
          DrawHLine ( Screen,
                      0, LoopX, LoopY,
                      Page^ [ LoopY, LoopX ] );
    5 :
      For LoopY := 0 To 99 Do
        For LoopX := 0 To 319 Do
          Begin
            DrawVLine ( Screen,
                        LoopX, LoopY, 99,
                        Page^ [ LoopY, LoopX ] );
            DrawVLine ( Screen,
                        LoopX, 100, 199 - LoopY,
                        Page^ [ 199 - LoopY, LoopX ] );
          End;
    6 :
      For LoopY := 99 DownTo 0 Do
        For LoopX := 0 To 319 Do
          Begin
            DrawVLine ( Screen,
                        LoopX, 0, LoopY,
                        Page^ [ LoopY, LoopX ] );
            DrawVLine ( Screen,
                        LoopX, 199 - LoopY, 199,
                        Page^ [ 199 - LoopY, LoopX ] );
          End;
    7 :
      For LoopX := 0 To 159 Do
        For LoopY := 0 To 199 Do
          Begin
            DrawHLine ( Screen,
                        LoopX, 159, LoopY,
                        Page^ [ LoopY, LoopX ] );
            DrawHLine ( Screen,
                        160, 319 - LoopX, LoopY,
                        Page^ [ LoopY, 319 - LoopX ] );
          End;
    8 :
      For LoopX := 159 DownTo 0 Do
        For LoopY := 0 To 199 Do
          Begin
            DrawHLine ( Screen,
                        0, LoopX, LoopY,
                        Page^ [ LoopY, LoopX ] );
            DrawHLine ( Screen,
                        319 - LoopX, 319, LoopY,
                        Page^ [ LoopY, 319 - LoopX ] );
          End
  End
End;

End.
