{$G+}

Unit Mouse;

Interface

Procedure M_Init ( Var Status , Buttons : ShortInt );
Procedure M_Show_Cursor;
Procedure M_Hide_Cursor;
Procedure M_Get_Status ( Var X , Y : Word ; Var B_Status : Byte );
Procedure M_Set_Position ( X , Y : Word );
Procedure M_Set_X_Range ( MinX , MaxX : Word );
Procedure M_Set_Y_Range ( MinY , MaxY : Word );
Procedure M_Set_Soft_Cursor ( SMV , CMV : Word );
Procedure M_Set_Hard_Cursor ( SLS , SLE : Word );
Procedure M_Conditional_OFF ( X1 , Y1 , X2 , Y2 : Word );

Implementation

Procedure M_Init; Assembler;

Asm
  Mov AX , 0
  Int 33H
  Les DI , Status
  Mov ES:[DI] , AL
  Les DI , Buttons
  Mov ES:[DI] , BL
End;


Procedure M_Show_Cursor; Assembler;

Asm
  Mov AX , 1
  Int 33H
End;


Procedure M_Hide_Cursor; Assembler;

Asm
  Mov AX , 2
  Int 33H
End;


Procedure M_Get_Status; Assembler;

Asm
  Mov AX , 3
  Int 33H
  Les DI , X
  Mov ES:[DI] , CX
  Les DI , Y
  Mov ES:[DI] , DX
  Les DI , B_Status
  Mov ES:[DI] , BL
End;


Procedure M_Set_Position; Assembler;

Asm
  Mov AX , 4
  Mov CX , X
  Mov DX , Y
  Int 33H
End;


Procedure M_Set_X_Range; Assembler;

Asm
  Mov AX , 7
  Mov CX , MinX
  Mov DX , MaxX
  Int 33H
End;


Procedure M_Set_Y_Range; Assembler;

Asm
  Mov AX , 8
  Mov CX , MinY
  Mov DX , MaxY
  Int 33H
End;


Procedure M_Set_Soft_Cursor; Assembler;

Asm
  Mov AX , 10
  Mov BX , 0
  Mov CX , SMV
  Mov DX , CMV
  Int 33H
End;


Procedure M_Set_Hard_Cursor; Assembler;

Asm
  Mov AX , 10
  Mov BX , 1
  Mov CX , SLS
  Mov DX , SLE
  Int 33H
End;


Procedure M_Conditional_OFF; Assembler;

Asm
  Mov AX , 16
  Mov CX , X1
  Mov DX , Y1
  Mov SI , X2
  Mov DI , Y2
  Int 33H
End;


End.
