{$G+}

Unit PCXUnit;

Interface

Uses
  M13HP;

Type
  PCXType = Record
              Palette : PaletteStyle;
              Picture : PageType
            End;
  PCXStyle = ^PCXType;

Procedure MakePlace ( Var Where : PCXStyle; Var OK : Boolean );
Procedure DelPlace  ( Var Where : PCXStyle );
Procedure ReadPCX   ( Var Where : PCXStyle; FileName : String;
                      Var OK    : Boolean );
Procedure ViewPCX   ( Where     : PCXStyle );
Procedure ShowPCX   ( FileName  : String );
Procedure WriteIMG  ( Where     : PCXStyle; FileName  : String );

Implementation

Procedure MakePlace;

Begin
  IF ( MaxAvail < SizeOf ( PCXType ) )
    Then OK := False
    Else
      Begin
        New ( Where );
        OK := True
      End
End;


Procedure DelPlace;

Begin
  Dispose ( Where )
End;


Procedure ReadPCX;

VAR
  F                        : File;
  ScreenOffset,Count,Size  : Word;
  N                        : Byte;
  PP                       : Pointer;
  I                        : Byte;

Begin
  Assign ( F, FileName );
  {$I-}
  Reset ( F, 1 );
  {$I+}
  IF ( IOResult <> 0 )
    Then
      Begin
        OK := False;
        Exit
      End;
  Size := FileSize ( F ) - 896;
  GetMem ( PP, Size );
  Seek ( F, 128 );
  BlockRead ( F, Mem [ Seg ( PP^ ) : Ofs ( PP^ ) ], Size );
  Seek ( F, Size + 128 );
  BlockRead ( F, Where^.Palette, 768 );
  For I := 0 To 255 Do
    Begin
      Where^.Palette [ I, 0 ] := Where^.Palette [ I, 0 ] Shr 2;
      Where^.Palette [ I, 1 ] := Where^.Palette [ I, 1 ] Shr 2;
      Where^.Palette [ I, 2 ] := Where^.Palette [ I, 2 ] Shr 2
    End;
  ScreenOffset := 0;
  Count := 0;
  Repeat
    IF ( Mem [ Seg ( PP^ ) : Ofs ( PP^ ) + Count ] > 192 )
      Then
        Begin
          N := Mem [ Seg ( PP^ ) : Ofs ( PP^ ) + Count ];
          Inc  ( Count );
          For I:= 0 To ( N - 193 ) Do
            Begin
              Mem [ Seg ( Where^.Picture ) : Ofs ( Where^.Picture ) + ScreenOffset ]
                := Mem [ Seg ( PP^ ) : Ofs ( PP^ ) + Count ];
              Inc ( ScreenOffset )
            End
        End
      Else
        Begin
          Mem [ Seg ( Where^.Picture ) : Ofs ( Where^.Picture ) + ScreenOffset ]
            := Mem [ Seg ( PP^ ) : Ofs ( PP^ ) + Count ];
          Inc ( ScreenOffset )
        End;
    Inc ( Count );
  Until ( ScreenOffset > 64000 );
  FreeMem ( PP, Size );
  Close ( F );
  OK := True
End;


Procedure ViewPCX;

Var
  PCXPointer : PageStyle;

Begin
  SetAllPalette ( Where^.Palette );
  PCXPointer := Addr ( Where^.Picture );
  PageCopy ( PCXPointer, Screen )
End;


Procedure ShowPCX;

Var
  Where : PCXStyle;
  OK    : Boolean;

Begin
  MakePlace ( Where, OK );
  IF ( OK = False )
    Then
      Begin
        WriteLN ( ' Not Enough Free Memory !!!'#7 );
        Halt
      End;
  ReadPCX ( Where, FileName, OK );
  IF ( OK = False )
    Then
      Begin
        WriteLN ( ' File Not Found !!! '#7 );
        Halt
      End;
  ViewPCX ( Where );
  DelPlace ( Where )
End;


Procedure WriteIMG;

Var
  FPal : File;
  FPic : File;

Begin
  Assign ( FPal, FileName + '.PAL' );
  {$I-}
  ReWrite ( FPal, 1 );
  {$I+}
  IF IOResult <> 0 Then Exit;
  Assign ( FPic, FileName + '.IMG' );
  {$I-}
  ReWrite ( FPic, 1 );
  {$I+}
  IF IOResult <> 0 Then Exit;
  BlockWrite ( FPal, Where^.Palette,   768 );
  BlockWrite ( FPic, Where^.Picture, 64000 );
  Close ( FPal );
  Close ( FPic )
End;

End.
