{$G+}

Unit Rotate;

Interface

Uses
  M13HP;

Procedure DrawRotate ( SPage : PageStyle; TPage : PageStyle;
                       X1, Y1, X2, Y2, CenterX, CenterY, Angle : Integer );

Implementation

Procedure SinTable; Assembler;

Asm
  DD 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
  DD 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
  DD 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
  DD 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
  DD 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
  DD 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
  DD 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
  DD 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
  DD 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
  DD 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
  DD 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00
  DD 00, 00, 00, 00
End;


Procedure InitSinTable;

Type
  SinTT = Array [ 0..359 ] of Integer;

Var
  Loop : Integer;
  SinT : ^SinTT;

Begin
  SinT := @SinTable;
  For Loop := 0 To 359 Do
    SinT^ [ Loop ] := Round ( Sin ( Loop * PI / 180 ) * 65 )
End;


Procedure DrawRotate; Assembler;

Var
  SinA, CosA : Integer;
  RotX, RotY : Integer;
  LX  , LY   : Integer;
  SizX, SizY : Integer;

Asm
  CLD
  PUSH            DS
  CMP             X1,         0140H
  JB           @NCX1
  MOV             X1,         013FH
@NCX1 :
  CMP             Y1,         00C8H
  JB           @NCY1
  MOV             Y1,         00C7H
@NCY1 :
  CMP             X2,         0140H
  JB           @NCX2
  MOV             X2,         013FH
@NCX2 :
  CMP             Y2,         00C8H
  JB           @NCY2
  MOV             Y2,         00C7H
@NCY2 :
  CLD
  MOV             DX,            X2
  CMP             X1,            DX
  JLE          @NECX
  MOV             AX,            X1
  MOV             X1,            DX
  MOV             X2,            AX
@NECX :
  MOV             DX,            Y2
  CMP             Y1,            DX
  JLE          @NECY
  MOV             AX,            Y1
  MOV             Y1,            DX
  MOV             Y2,            AX
@NECY :
  MOV             AX,            X2
  SUB             AX,            X1
  INC             AX
  MOV           SizX,            AX
  MOV             AX,            Y2
  SUB             AX,            Y1
  INC             AX
  MOV           SizY,            AX
  LES             DI,         TPage
  MOV             AX,            Y1
  XCHG            AH,            AL
  ADD             DI,            AX
  SHR             AX,           02H
  ADD             DI,            AX
  ADD             DI,            X1
  MOV             AX,       CenterX
  SUB             X1,            AX
  MOV             AX,       CenterY
  SUB             Y1,            AX
  MOV             BX,         Angle
  ADD             BX,           5AH
  CMP             BX,         0168H
  JB         @Label1
  SUB             BX,         0168H
@Label1 :
  SHL             BX,           01H
  MOV             AX, CS:[ OFFSET SinTable + BX ]
  MOV           CosA,            AX
  IMUL   WORD PTR X1
  MOV             CX,            AX
  MOV             BX,         Angle
  SHL             BX,           01H
  MOV             AX, CS:[ OFFSET SinTable + BX ]
  MOV           SinA,            AX
  IMUL   WORD PTR Y1
  ADD             AX,            CX
  MOV           RotX,            AX
  MOV             LX,            AX
  MOV             AX,          SinA
  IMUL   WORD PTR X1
  NEG             AX
  MOV             CX,            AX
  MOV             AX,          CosA
  IMUL   WORD PTR Y1
  ADD             AX,            CX
  MOV           RotY,            AX
  MOV             LY,            AX
  MOV             BX,          SizY
  MOV             CX,          SizX
@Repeat :
  MOV             AX,          RotX
  SAR             AX,           06H
  ADD             AX,       CenterX
  MOV             DX,            AX
  CMP             AX,         0000H
  JL         @Label2
  CMP             AX,         013FH
  JG         @Label2
  MOV             AX,          RotY
  SAR             AX,           06H
  ADD             AX,       CenterY
  CMP             AX,         0000H
  JL         @Label2
  CMP             AX,         00C7H
  JG         @Label2
  LDS             SI,         SPage
  XCHG            AH,            AL
  ADD             SI,            AX
  SHR             AX,           02H
  ADD             SI,            AX
  ADD             SI,            DX
  MOVSB
  JMP        @Label3
@Label2 :
  XOR             AX,            AX
  STOSB
@Label3 :
  MOV             AX,          CosA
  ADD           RotX,            AX
  MOV             AX,          SinA
  SUB           RotY,            AX
  DEC             CX
  JNZ        @Repeat
  ADD             DI,         0140H
  SUB             DI,          SizX
  MOV             AX,          SinA
  ADD             LX,            AX
  MOV             AX,            LX
  MOV           RotX,            AX
  MOV             AX,          CosA
  ADD             LY,            AX
  MOV             AX,            LY
  MOV           RotY,            AX
  MOV             CX,          SizX
  DEC             BL
  JNZ        @Repeat
  POP             DS
End;


Begin
  InitSinTable;
End.
