// phong shading & textue mapping
// with 4-vertex polygon
//
// by lee jong whan (himem 1st)
//    hongik university Mechanicl Engineering 92'
//    hongik computer research club
//
// date: Friday,August 22,1997
//       Sunday,August 24,1997
//       Monday,August 25,1997
//       Wednesday,August 27,1997 : script & hidden face removal
// e-mail: leejw51@planet.eon.net / leejw51@hitel.net
// compile : gcc a.cpp -o a.exe -lallegro
// library : allegro 2.0
// compiler: djgpp v2

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <math.h>
#include <io.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>
#include <allegro.h>
/*
rotation:
Matrix for rotation around the X axis :
   [     1         0                   0     ]    [  x ]
   [     0       Cos (a)   -Sin (a)    0     ]  . [  y ]
   [     0       Sin (a)    Cos (a)    0     ]    [  z ]
   [     0         0          0        1     ]    [  1 ]

Matrix for rotation around the Y axis :
   [  Cos (a)      0       -Sin (a)    0     ]    [  x ]
   [     0         1          0        0     ]  . [  y ]
   [  Sin (a)      0        Cos (a)    0     ]    [  z ]
   [     0         0          0        1     ]    [  1 ]
Matrix for rotation around the Z axis :
   [  Cos (a)   -Sin (a)      0        0     ]    [  x ]
   [  Sin (a)    Cos (a)      0        0     ]  . [  y ]
   [     0         0          1        0     ]    [  z ]
   [     0         0          0        1     ]    [  1 ]
projection:
	   px =  ((256*x) / (z-Zoff)) + Xoff;
	   py =  ((256*y) / (z-Zoff)) + Yoff;
*/


class Vector {
public:
float x,y,z;
};

class Pixel {
public:
float x,y;
};

class Vertex {
public:
Vector  v;
Vector  vr;//rotated
Pixel  vrp;//projected

Vector  n;//normal vector
};

class Polygon {
public:
Vertex * p[4];
Pixel t[4]; //texel
float z;//depth
};

void read_script(Vector a[],int b[][4]);
//VERTEX & POLYGON SYSTEM
#define MAX_VERTEX 50
#define MAX_POLYGON 50
int VERTEX_NUM=0;
int POLYGON_NUM=0;
Vertex G_VERTEX[MAX_VERTEX]; //vertex
Polygon G_POLYGON[MAX_POLYGON]; //make face with vertexes

//3D to 2D ROTATION & PROJECTION SYSTEM
Vector EYE_VECTOR={320,340,-50}; // values for projection
Vector ROTATION_ANGLE={10,40,45};  // angles for rotation

//EDGE DETECT SYSTEM
class Edge{
public:
    float x;
    Vector n;
    Pixel t; //texture pointer
};
Edge R_EDGE[480]; //2d-polygon display
Edge L_EDGE[480];
int Y_MIN, Y_MAX;

//shading system
Vector LIGHT={0.5,0.5,1};
Vector VIEW={   0,0,-1};

//texture
int TEXTURE_SIZE_X= 100;//default value
int TEXTURE_SIZE_Y= 100;
BITMAP* TEXTURE;
char TEXTURE_NAME[200];


//convert
void rotate(Vector p,Vector& q)
{
    Vector t;

    float px,py;

	t.x=p.x;
    t.y=cos(ROTATION_ANGLE.x)*p.y-sin(ROTATION_ANGLE.x)*p.z;//x rotation
    t.z=sin(ROTATION_ANGLE.x)*p.y+cos(ROTATION_ANGLE.x)*p.z;
	p=t;

    t.x=cos(ROTATION_ANGLE.y)*p.x-sin(ROTATION_ANGLE.y)*p.z;//y rotation
	t.y=p.y;
    t.z=sin(ROTATION_ANGLE.y)*p.x+cos(ROTATION_ANGLE.y)*p.z;
	p=t;

    t.x=cos(ROTATION_ANGLE.z)*p.x -sin(ROTATION_ANGLE.z)*p.y;//z rotation
    t.y=sin(ROTATION_ANGLE.z)*p.x+cos(ROTATION_ANGLE.z)*p.y;
	t.z=p.z;
	p=t;

    q=p;
}
void project(Vector p,Pixel& q,float sx,float sy)
{
    float px,py;
	//projection
    if (p.z-EYE_VECTOR.z!=0) {
    px=sx*p.x/(p.z-EYE_VECTOR.z) + EYE_VECTOR.x;
    py=sy*p.y/(p.z-EYE_VECTOR.z) + EYE_VECTOR.y;

    q.x=(int)px,q.y=(int)py;}

}

void check_edge(Vertex a1,Vertex b1,Pixel e,Pixel f)
{
    Vertex t; //swap
    Pixel t2;
    if (a1.vrp.y > b1.vrp.y) {
        t=a1,a1=b1,b1=t;
        t2=e,e=f,f=t2;
    }

    //linear(2d) interpolation
    Pixel a=a1.vrp, b=b1.vrp;
    float x= a.x;
    float dx;
    if (a.y==b.y) return;
    else dx= (b.x- a.x) / (b.y-a.y);
    int y;
    //normal vector interpolation
    Vector & c=a1.n, d=b1.n;
    Vector n= c;
    float nx=(d.x-c.x)/(b.y-a.y);
    float ny=(d.y-c.y)/(b.y-a.y);
    float nz=(d.z-c.z)/(b.y-a.y);
    //printf("check %f %f %f, %f %f %f \n",c.x,c.y,c.z,
    //d.x, d.y, d.z);
    Pixel te=e;//texture pointer
    float tex=(f.x-e.x)/(b.y-a.y);
    float tey=(f.y-e.y)/(b.y-a.y);

    
    //interpolating
    for (y=(int)a.y;y<(int)b.y;y++) {

    x+=dx;//increase
    n.x+=nx, n.y+=ny, n.z+=nz;
    te.x+=tex, te.y+=tey;

    if (y>Y_MAX) Y_MAX=y;
    if (y<Y_MIN) Y_MIN=y;
    if (x<L_EDGE[y].x) {L_EDGE[y].x=(int)x, L_EDGE[y].n=n; L_EDGE[y].t=te;}
    if (x>R_EDGE[y].x) {R_EDGE[y].x=(int)x, R_EDGE[y].n=n; R_EDGE[y].t=te;}
    }
}

//sorting
int polygon_compare(const void* e1,const void* e2)
{
    Polygon *a1=(Polygon*) e1;
    Polygon *a2=(Polygon*) e2;
    return int(-a1->z+ a2->z);
}
void polygon_sort(Polygon a[],int n)
{
    qsort(a,n,sizeof(Polygon),polygon_compare);
}


void normalize(Vector& a)
{
    float s=sqrt(a.x*a.x+ a.y*a.y+ a.z*a.z);
    if ( s==0) return;
        a.x/=s, a.y/=s, a.z/=s;
}
float dot_product(Vector a,Vector b)
{
    return a.x*b.x+ a.y*b.y+ a.z*b.z;
}
void draw_polygon(Polygon b,int phong)
{




    //find edge
    Y_MAX=-1;
    Y_MIN=480;
    int i;
    for (i=0;i<480;i++) { //set each edge's value
        L_EDGE[i].x=480.0;
        R_EDGE[i].x=-1.0;
        }
 
    check_edge(*(b.p[0]), *(b.p[1]) ,b.t[0], b.t[1] );
    check_edge(*(b.p[1]), *(b.p[2]) ,b.t[1], b.t[2]);
    check_edge(*(b.p[2]), *(b.p[3]) ,b.t[2], b.t[3]);
    check_edge(*(b.p[3]), *(b.p[0]) ,b.t[3], b.t[0]);

    int y;    //2d
    float x,lx;

    Vector n,h; //shading, h vector is light vector + view vector
                // h vector is for hightling (phong shading)
    Vector n1;  //normal vector for shaing
    Vector dn; //shading interpolation
    float diffuse,specular,intensity;

    Pixel te;     //texture mapping pointer
    Pixel ten;    //texture interpolating

    int color; //for shading and texture mapping

    h.x=(LIGHT.x+ VIEW.x)/2;//find H vector
    h.y=(LIGHT.y+ VIEW.y)/2;
    h.z=(LIGHT.z+ VIEW.z)/2;
    normalize(LIGHT);
    normalize(h);

    for (y=Y_MIN;y<=Y_MAX;y++) {
        n=L_EDGE[y].n;
        te=L_EDGE[y].t;
        lx=R_EDGE[y].x-L_EDGE[y].x;

        if ( lx !=0) {
        dn.x=(R_EDGE[y].n.x- L_EDGE[y].n.x)/lx;
        dn.y=(R_EDGE[y].n.y- L_EDGE[y].n.y)/lx;
        dn.z=(R_EDGE[y].n.z- L_EDGE[y].n.z)/lx;

        ten.x=(R_EDGE[y].t.x- L_EDGE[y].t.x)/lx;
        ten.y=(R_EDGE[y].t.y- L_EDGE[y].t.y)/lx;
        }
        for (x=L_EDGE[y].x;x<=R_EDGE[y].x;x++) {
        putpixel(screen,(int)x,y,color);

        n.x+=dn.x, n.y+=dn.y, n.z+=dn.z;
        te.x+=ten.x, te.y+=ten.y;

        n1=n;
        normalize(n1);//find N vector
        diffuse=225*dot_product(n1,LIGHT);
        specular=25*pow(dot_product(n1,h),200);
        intensity=10+diffuse+specular;
        if (diffuse<0) intensity=10;
        if (phong) {
        color=(int)intensity; }
        else {
        color=getpixel(TEXTURE,
        ((int)te.x)%TEXTURE_SIZE_X,
        ((int) te.y)%TEXTURE_SIZE_Y);}
        }

    }

}
void get_normal_vector(Vector a,Vector b,Vector c,Vector& n)
{
    Vector u,v;
    u.x=a.x-b.x, u.y=a.y-b.y, u.z=a.z-b.z;
    v.x=-b.x+c.x, v.y=-b.y+c.y, v.z=-b.z+c.z;
    //cross product
    //(u.x, u.y, u.z) X (v.x, v.y. v.z) =
    //(u.y*v.z-u.z*v.y,u.z*v.x-u.x*v.z,u.x*v.y-u.y*v.x)
    n.x=u.y*v.z-u.z*v.y;
    n.y=u.z*v.x-u.x*v.z;
    n.z=u.x*v.y-u.y*v.x;

}


void make_cube(void)
{
    //make a cubic
    Vector a[MAX_VERTEX];
    int b[MAX_POLYGON][4];
    read_script(a,b);

    int i,j;
    for (i=0;i<VERTEX_NUM;i++) {
    G_VERTEX[i].v=a[i]; //read the 3d point
    rotate(G_VERTEX[i].v,  G_VERTEX[i].vr); //convert 3D to 2D
    project(G_VERTEX[i].vr, G_VERTEX[i].vrp,400,400); //project
    G_VERTEX[i].n.x=0, G_VERTEX[i].n.y=0, G_VERTEX[i].n.z=0;
    //set normal vector as zero
                                       //because we need plane normal
                                       //vectors to make vertex's normal
                                       //vector.
                                       //it's average value.
    }

    //make faces
    for (i=0;i<POLYGON_NUM;i++) {
        for (j=0;j<4;j++) {
        G_POLYGON[i].p[j]=& G_VERTEX[ b[i][j] ]; //share the vertexes
        }
     }

    //3d -> 2d screen
    Vector no; //temporary vector to store normal vector
    int k;
    for (i=0;i<POLYGON_NUM;i++) {
    G_POLYGON[i].z=0; //calculation verage depth
    //get a plane's normal vector
    //there are 4 vertexs.but we need only three points
    get_normal_vector(G_POLYGON[i].p[2]->v ,
    G_POLYGON[i].p[1]->v , G_POLYGON[i].p[0]->v , no);

    for (j=0;j<4;j++) {
    G_POLYGON[i].z+=G_POLYGON[i].p[j]->vr.z;//add each point's depth
                            //vr.z is v.z's rotated value

    Vector& cu=(G_POLYGON[i].p[j]->n);
    //G_POLYGON[i].p[j]-> is current vertex's normal vector
    cu.x+= no.x; //add plane's normal vector to vertex's normal vector
    cu.y+= no.y; //because we need average normal vector for vertexes
    cu.z+= no.z;

    Pixel& texel=(G_POLYGON[i].t[j]); //texture pointer's location
    if (j==0) {texel.x=0,texel.y=0;} //each vertexes has
    else if (j==1) {texel.x=TEXTURE_SIZE_X,texel.y=0;}
     //typical boundary values
    else if (j==2) {texel.x=TEXTURE_SIZE_X,texel.y=TEXTURE_SIZE_Y;}
    else if (j==3) {texel.x=0,texel.y=TEXTURE_SIZE_Y;}
    }
    G_POLYGON[i].z/=4; //average depth of a 3d polygon
    }

    //complete creaing a cubic..

}

void draw_polygon(void)
{
    int i;
  // painter's algorithm
    polygon_sort(G_POLYGON,POLYGON_NUM);

    //draw polygon
    int co;
    for (co=1;co>=0;co--) {
        //make palette
    {
    PALETTE palette;
    if (co) {
   palette[0].r=63;
   palette[0].g=63;
   palette[0].b=63;
    int i;
    for (i=1;i<=225;i++) {
    palette[i].r=(i*40/225+20)/2;
    palette[i].g=(i*40/225+20)/2;
    palette[i].b=i*40/225+20;
    }

    for (i=225;i<=255;i++) {
    palette[i].r=((i-225)*20/30+40);
    palette[i].g=((i-225)*20/30+40);
    palette[i].b=(i-225)*20/30+40;
    }
    }
    else {
    TEXTURE=load_pcx(TEXTURE_NAME,palette);
    }
    set_palette(palette);
    clear_to_color(screen,0);
    }


    Vector te;
    for (i=0;i<POLYGON_NUM;i++) {
    get_normal_vector(G_POLYGON[i].p[2]->vr ,
    G_POLYGON[i].p[1]->vr , G_POLYGON[i].p[0]->vr , te);
    if (te.z>0) draw_polygon(G_POLYGON[i],co);
    }
    readkey();
    }
}



//read the script

void error(char*a)
{
	puts(a);
	exit(-1);
}
int same(char* a, char* b) {
	int l,i;
	l=strlen(a);
	for (i=0;i<l;i++) {
	if (*(a+i)!=*(b+i)) return 0;
	}
	return 1;

}

void read_script(Vector a[],int b[][4])
{
	int h;
	char* n;
	int l;
	float f[10];
	int d[10];
	clrscr();

	if ( (h=open("a.p",O_TEXT))==-1) error("cannot open");
	l=filelength(h);
	if ( (n=(char*)malloc(l+10))==NULL) error("cannot seize memory");
    if ( (read(h,n,l))==-1) error("cannot read");
	int i,j;
	for (i=0;i<l;i++) {
        if (same("EXIT",n+i)) break;

		//read vertexes
		if (same("VERTEX",n+i)) {
			puts("VERTEX");
			for (j=i;j<l;j++) {
			if (same("END",n+j)) break;
			if (same(":",n+j)) {sscanf(n+j+1,"%f %f %f",
                &f[0],&f[1],&f[2]);
            printf("%2d: %7.3f %7.3f %7.3f \n",VERTEX_NUM,
            f[0],f[1],f[2]);
            a[VERTEX_NUM].x=f[0];
            a[VERTEX_NUM].y=f[1];
            a[VERTEX_NUM].z=f[2];
            VERTEX_NUM++;
             }
             } //end of for
		 } //end of if
 
         //read polygon
        if (same("POLYGON",n+i)) {
			puts("POLYGON");
			for (j=i;j<l;j++) {
			if (same("END",n+j)) break;
			if (same(":",n+j)) {sscanf(n+j+1,"%d %d %d %d",
			&d[0],&d[1],&d[2],&d[3]);
            printf("%2d: %7d %7d %7d %7d\n",POLYGON_NUM,
            d[0],d[1],d[2],d[3]);
            b[POLYGON_NUM][0]=d[0];
            b[POLYGON_NUM][1]=d[1];
            b[POLYGON_NUM][2]=d[2];
            b[POLYGON_NUM][3]=d[3];
            POLYGON_NUM++;
            }
			}
 
		}//end of if
        static int d=0;
        if (same("TEXTURE",n+i)) {
            puts("TEXTURE");
			for (j=i;j<l;j++) {
			if (same("END",n+j)) break;
            if (same(":",n+j)) {sscanf(n+j+1,"%s %d %d",
            TEXTURE_NAME,&TEXTURE_SIZE_X, &TEXTURE_SIZE_Y);
            printf("name:%s  width:%d  height:%d \n",TEXTURE_NAME,
            TEXTURE_SIZE_X,TEXTURE_SIZE_Y);

            }
			}
 
        }//end of if
 
	} //end of for
 
}


void main(void)
{
 
    allegro_init();
    install_keyboard();
    
    make_cube();
    readkey();

    set_gfx_mode(GFX_AUTODETECT,640,480,0,0);
    draw_polygon();
    textout_centre(screen,font,"3D putpixel",200,10,1);

    readkey();
    exit(0);
}
