#include    <conio.h>
#include    <stdio.h>
#include    "rag.h"
#include    "ragutil.h"
#include    "map.h"
#include    "util.h"

cMAP    *Map = NULL;
char    *Dongo[10];
sSPR0   *Dongo0[10];
sSPR0   *Korea;
sSPR0   *Gundam, *GundamR;

short **map;
char   *tile;

char    xb, yb;
int     x=0, y=0, frame=0;
int     MAP_XSIZE, MAP_YSIZE;

void    Main()
{
    static  int     task = 0;

    #define LOADING 1
    #define LOOP    2
    #define QUIT    3

    switch(task) {
        case 0 :
            task = LOADING;
            break;

        case LOADING :
        {
            FILE    *fp;
            short   xs, ys, n;
            char   *palette;

            //
            sIMAGE  *gundam = LoadBMP("gundam.bmp");
            if (gundam == NULL)
            {
                task = QUIT;
                break;
            }
            Gundam = Encode(gundam->data, gundam->xs, gundam->ys, (char)253);
            GundamR = EncodeR(gundam->data, gundam->xs, gundam->ys, (char)253);
            delete  gundam;

            //
            sIMAGE  *korea = LoadBMP("korea.bmp");
            if (korea == NULL)
            {
                task = QUIT;
                break;
            }
            Korea = Encode(korea->data, korea->xs, korea->ys, (char)254);
            delete  korea;

            //
            fp = fopen("dongo.bin", "rb");
            for(int i=0; i<10; i++)
            {
                Dongo[i] = new char [51*62];
                fread(Dongo[i], 51, 62, fp);
                Dongo0[i] = Encode(Dongo[i], 51, 62, 0);
            }
            fclose(fp);

            //
            fp = fopen("palette.bin", "rb");
            if (fp == NULL)
            {
                task = QUIT;
                break;
            }
            palette = new char [768];
            fread(palette, 3, 256, fp);
            gfxdev->SetPalette(palette);
            delete  palette;
            fclose(fp);

            //
            fp = fopen("tile.bin", "rb");
            if (fp == NULL)
            {
                task = QUIT;
                break;
            }
            xb = fgetc(fp);
            yb = fgetc(fp);
            fread(&n, 2, 1, fp);
            tile = new char [n*(1<<(xb+yb))];
            fread(tile, 1<<(xb+yb), n, fp);
            fclose(fp);

            //
            fp = fopen("map.bin", "rb");
            if (fp == NULL)
            {
                task = QUIT;
                break;
            }
            fread(&xs, 2, 1, fp);
            fread(&ys, 2, 1, fp);
            map = (short**)new char [sizeof(short*)*ys + sizeof(short)*xs*ys];
            //map = new short* [ys];
            for(i=0; i<ys; i++)
            {
            //    map[i] = new short [xs];
                map[i] = (short*)((char*)map + sizeof(short*)*ys + sizeof(short)*xs*i);
                fread(map[i], 2, xs, fp);
            }
            fclose(fp);

            MAP_XSIZE = xs << xb;
            MAP_YSIZE = ys << yb;

            x = (MAP_XSIZE-gfxdev->nWIDTH)/2;
            y = (MAP_YSIZE-gfxdev->nHEIGHT)/2;

            //
            Map = new cMAP(gfxdev->nWIDTH, gfxdev->nHEIGHT, map, tile, xb, yb);

            task = LOOP;
            break;
        }

        case LOOP :
        {
            int     mx = inpdev->State(MOS_X), my = inpdev->State(MOS_Y);

            if (inpdev->State(KEY_LEFT)) x = Max(x-3, 1<<xb);
            if (inpdev->State(KEY_RIGHT)) x = Min(x+3, MAP_XSIZE-gfxdev->nWIDTH-(1<<xb));
            if (inpdev->State(KEY_UP)) y = Max(y-3, 1<<yb);
            if (inpdev->State(KEY_DOWN)) y = Min(y+3, MAP_YSIZE-gfxdev->nHEIGHT-(1<<yb));

            frame = (frame+1)%10;

            if (inpdev->State(KEY_ESC)!=0)
                task = QUIT;

            static  int     n = 0;
            n = (n+1)%(gfxdev->nWIDTH*2);

            // clear
            gfxdev->Reset();

            // background
            Map->Move(x, y);
            for(int i=0; i<gfxdev->nHEIGHT; i++)
                gfxdev->PutImage(0, i, Map->Offset(), gfxdev->nWIDTH, 1, 0);

            // gundam
            gfxdev->PutSprite(((n>=gfxdev->nWIDTH) ? gfxdev->nWIDTH*2-n:n) - GundamR->xs/2, 0, GundamR, 100);
            gfxdev->PutSprite(gfxdev->nWIDTH - ((n>=gfxdev->nWIDTH) ? (gfxdev->nWIDTH*2-n):n) - Gundam->xs/2, 0, Gundam, 1);

            // korea is
            gfxdev->PutSprite(gfxdev->nWIDTH-Korea->xs-5, gfxdev->nHEIGHT-Korea->ys-5, Korea, 127);

            // image
            gfxdev->PutImage(50, 50, Dongo[frame], 51, 62, 50);

            // sprite
            for(i=-3; i<=3; i++)
                for(int j=-1; j<=1; j++)
                    gfxdev->PutSprite(mx-25+i*60, my-30+j*70, Dongo0[frame], 50+i);

            gfxdev->Display();

            break;
        }

        case QUIT :
        {
            if (Map != NULL)
            {
                delete  Map;
                delete  Gundam;
                delete  GundamR;
                delete  Korea;

                for(int i=0; i<10; i++)
                {
                    delete  Dongo[i];
                    delete  Dongo0[i];
                }
                delete  map;
                delete  tile;
            }

            Exit();
            break;
        }
    }
}
