#include    <string.h>
#include    "util.h"
#include    "map.h"

    cMAP :: cMAP(int xs, int ys, short **map, char *tile, char xb, char yb)

{
    TILE_XSIZE = 1<<xb;
    TILE_YSIZE = 1<<yb;

    nXB     = xb;
    nYB     = yb;
    nXNUM   = (xs + TILE_XSIZE-1) / TILE_XSIZE + 1;
    nYNUM   = (ys + TILE_YSIZE-1) / TILE_YSIZE + 1;
    nWIDTH  = nXNUM << xb;
    nHEIGHT = nYNUM << yb;
    nOFFSET = 0;
    nSIZE   = nWIDTH * nHEIGHT;
    pVRAM   = new char [nSIZE + nHEIGHT];
    pTILE   = tile;
    pMAP    = map;
    nX      = 0;
    nY      = 0;

    for(int x=0; x<nXNUM; x++) {
        char   *buffer = pVRAM + (x<<nXB);
        for(int y=0; y<nYNUM; y++) {
            char    *data = pTILE + (pMAP[y][x]<<(nXB+nYB));

            for(int i=0; i<TILE_YSIZE; i++, buffer+=nWIDTH, data+=TILE_XSIZE)
                memcpy(buffer, data, TILE_XSIZE);
        }
    }
}

    void
    cMAP :: Move(int x, int y)

{
    nOFFSET = (y*nWIDTH + x) % nSIZE;

    x >>= nXB;
    y >>= nYB;

    for(nX=Max((x-nXNUM), nX); nX<x; nX++) PutVLine(nX+nXNUM, nY);
    for(nX=Min((x+nXNUM), nX); nX>x; nX--) PutVLine(nX-1, nY);

    for(nY=Max((y-nYNUM), nY); nY<y; nY++) PutHLine(nX, nY+nYNUM);
    for(nY=Min((y+nYNUM), nY); nY>y; nY--) PutHLine(nX, nY-1);
}

    void
    cMAP :: PutHLine(int x, int y)

{
    int     offset = ((y<<nYB)*nWIDTH + (x<<nXB)) % nSIZE;
    short  *map = pMAP[y];

    for(int i=0, m=nSIZE-(nWIDTH<<nYB); i<nXNUM; i++, offset+=TILE_XSIZE, x++) {
        char    *data = pTILE + (map[x]<<(nXB+nYB));

        if (offset < m) {
            for(int n=0, j=offset; n<TILE_YSIZE; n++, j+=nWIDTH, data+=TILE_XSIZE)
                memcpy(pVRAM + j, data, TILE_XSIZE);
        } else {
            for(int n=0, j=offset; j<nSIZE; n++, j+=nWIDTH, data+=TILE_XSIZE)
                memcpy(pVRAM + j, data, TILE_XSIZE);

            for(j-=nSIZE; n<TILE_YSIZE; n++, j+=nWIDTH, data+=TILE_XSIZE)
                memcpy(pVRAM + j, data, TILE_XSIZE);

            int     cross = j%nWIDTH;

            if (cross > nWIDTH-TILE_XSIZE)
                memcpy(pVRAM, pVRAM+nSIZE, TILE_XSIZE-(nWIDTH-cross));
            else
                memcpy(pVRAM+nSIZE+cross, pVRAM+cross, TILE_XSIZE);
        }
    }
}

    void
    cMAP :: PutVLine(int x, int y)

{
    int     offset = ((y<<nYB)*nWIDTH + (x<<nXB)) % nSIZE;

    for(int i=0, m=nSIZE-(nWIDTH<<nXB); i<nYNUM; i++) {
        char    *data = pTILE + (pMAP[y+i][x]<<(nXB+nYB));

        if (offset < m) {
            for(int n=0; n<TILE_YSIZE; n++, offset+=nWIDTH, data+=TILE_XSIZE)
                memcpy(pVRAM + offset, data, TILE_XSIZE);
        } else {
            for(int n=0; offset<nSIZE; n++, offset+=nWIDTH, data+=TILE_XSIZE)
                memcpy(pVRAM + offset, data, TILE_XSIZE);

            for(offset-=nSIZE; n<TILE_YSIZE; n++, offset+=nWIDTH, data+=TILE_XSIZE)
                memcpy(pVRAM + offset, data, TILE_XSIZE);

            int     cross = offset%nWIDTH;

            if (cross > nWIDTH-TILE_XSIZE)
                memcpy(pVRAM, pVRAM+nSIZE, TILE_XSIZE-(nWIDTH-cross));
            else
                memcpy(pVRAM+nSIZE+cross, pVRAM+cross, TILE_XSIZE);
        }
    }
}
