// rAG
// gRAPHICS
//

#include    "raggfx.h"
#include    "ragutil.h"

#ifdef __WATCOMC__

#include    <dos.h>
#include    <string.h>
#include    <conio.h>
#include    <stdlib.h>

    cMCGA :: cMCGA() : cLSP(320, 200)

{
    union   REGS  r;

    r.h.ah = 0xf;
    int386(0x10, &r, &r) ;
    nPREMODE = r.h.al;

    r.w.ax = 0x13;
    int386(0x10, &r, &r) ;
}

    cMCGA :: ~cMCGA()

{
    union   REGS  r;
    r.w.ax = nPREMODE;
    int386(0x10, &r, &r) ;
}

    void
    cMCGA :: SetPalette(char *palette)

{
    outp(0x3c8, 0);
    for(int i=0; i<768; i++)
        outp(0x3c9, palette[i]>>2);
}

    void
    cMCGA :: Display()

{
    char    *video = (char*)0xa0000;

    //while(inp(0x3da)&8);
    //while(!(inp(0x3da)&8));
    //while(!(inp(0x3da)&1));

    for(int y=0; y<200; y++, video+=320)
    {
        sLSP    *node = pLINENODE[y];
        for(int x=0; x<320; node=node->next)
        {
            memcpy(video+x, node->address, node->x2-x);
            x = node->x2;
        }
    }
}

#define     RP_SEG(A) ((unsigned)A>>4)
#define     RP_OFF(A) ((unsigned)A&15)

    void*
    AllocDosmem(int size) ;

#pragma  aux    AllocDosmem=     \
      " shr     ebx,4           "\
      " inc     ebx             "\
      " mov     ax, 0100h       "\
      " int     31h             "\
      " mov     ebx,0           "\
      " mov     bx,ax           "\
      " shl     ebx,4           "\
      " mov     [ebx],dx        "\
      " add     ebx,2           "\
        modify [eax edx]         \
        value  [ebx]             \
        parm   [ebx] ;

    void
    FreeDosmem(void *mem) ;

#pragma  aux    FreeDosmem =     \
      " sub     ebx, 2          "\
      " mov     dx, [ebx]       "\
      " mov     ax, 0101h       "\
      " int     31h             "\
        modify [dx ax]           \
        parm   [ebx];

    static
    void
    int386xemul(int num, union REGS *in, union REGS *out, struct SREGS *ad)

{
    union    REGS  r;
    struct   SREGS sr;
    segread(&sr);

    struct {
        long    edi, esi, ebp, reserved, ebx, edx, ecx, eax;
        short   flags, es, ds, fs, gs, ip, cs, sp, ss;
    }   RMI ;

    memset(&RMI, 0, sizeof(RMI));

    RMI.eax = in->w.ax;
    RMI.ebx = in->w.bx;
    RMI.ecx = in->w.cx;
    RMI.edx = in->w.dx;
    RMI.edi = in->w.di;
    RMI.esi = in->w.si;
    RMI.es = ad->es;
    RMI.ds = ad->ds;

    r.w.ax = 0x0300;
    r.h.bl = num;               // interrupt number
    r.h.bh = 0;                 // flags
    r.w.cx = 0;                 // number of words to copy from protected mode to real mode stack
    sr.es = FP_SEG (&RMI);      // segment of real mode call structure
    r.x.edi = FP_OFF (&RMI);    // offset of real mode call structure
    int386x (0x31, &r, &r, &sr);

    out->w.ax = RMI.eax;
    out->w.bx = RMI.ebx;
    out->w.cx = RMI.ecx;
    out->w.dx = RMI.edx;
    out->w.si = RMI.esi;
    out->w.di = RMI.edi;
}

struct  VesaForm {
    char    VESASignature[4];
    short   VESAVersion;
    void   *OEMStringPtr;
    char    Capabilities[4];
    void   *VideoModePtr;
    short   TotalMemory;
    char    reserved[236];
};

struct  ModeInfo {
    short   ModeAttributes;
    char    WinAAttributes, WinBAttributes;
    short   WinGranularity, WinSize, WinASegment, WinBSegment;
    int     WinFuncPtr;
    short   BytesPerScanLine, XResolution, YResolution;
    char    XCharSize, YCharSize, NumberOfPlanes, BitsPerPixel, NumberOfBanks;
    char    MemoryModel, BankSize, NumberOfImagePages, res1;
    char    RedMaskSize, RedFieldPosition, GreenMaskSize, GreenFieldPosition;
    char    BlueMaskSize, BlueFieldPosition, RsvdMaskSize, RsvdFieldPosition;
    char    DirectColorModeInfo, res2[216];
};

static  int     BANK_SIZE=65536;

static  struct {
    int     shift, write, read;
    int     pre[2];
}   Bank = { 0, };

    void
    cVESA :: InitMode(int videomode)

{
    union       REGS  r;
    struct      SREGS sr;
    segread(&sr);

    VesaForm   *form = (VesaForm*)AllocDosmem(sizeof(VesaForm));

    r.w.ax = 0x4f00;
    sr.es = RP_SEG(form);
    r.x.edi = RP_OFF(form);
    int386xemul(0x10, &r, &r, &sr);

    if (memcmp(form->VESASignature,"VESA",4) != 0) {
        r.w.ax = 0x3;
        int386(0x10, &r, &r) ;
        exit(-1);
    }

    FreeDosmem(form);

    ModeInfo   *mode = (ModeInfo*) AllocDosmem(sizeof(ModeInfo));

    r.w.ax = 0x4f01;
    r.w.cx = videomode;
    sr.es = RP_SEG(mode);
    r.x.edi = RP_OFF(mode);
    int386xemul(0x10, &r, &r, &sr);

    if ((mode->WinAAttributes&3) == 3) Bank.read = 0 ;
    if ((mode->WinAAttributes&5) == 5) Bank.write = 0 ;
    if ((mode->WinBAttributes&3) == 3) Bank.read = 1 ;
    if ((mode->WinBAttributes&5) == 5) Bank.write = 1 ;

    for(Bank.shift=0; (64>>Bank.shift) != mode->WinGranularity; Bank.shift++) ;

    BANK_SIZE = mode->WinSize*1024;

    r.w.ax = 0x4f02;
    r.w.bx = videomode;
    int386(0x10, &r, &r);
    if (r.h.ah==1) {
        r.w.ax = 0x3;
        int386(0x10, &r, &r) ;
        exit(-1);
    }
}

    void
    SwitchBank(int bank, int num, int *address);

#pragma aux SwitchBank= \
     " cmp     edx, dword ptr [esi]    "\
     " je      quit                    "\
     " mov     dword ptr [esi], edx    "\
     " mov     eax, 4f05h              "\
     " int     10h                     "\
     " quit :                          "\
       parm [ edx ] [ ebx ] [ esi ]     \
       modify [ eax ];

    inline
    void
    WriteBank(int bank)

{
    SwitchBank(bank << Bank.shift, Bank.write, Bank.pre + Bank.write);
}

    inline
    void
    ReadBank(int bank)

{
    SwitchBank(bank << Bank.shift, Bank.read, Bank.pre + Bank.read);
}

    inline
    int
    GetBank()

{
    return Bank.pre[Bank.write];
}

    cVESA :: cVESA(int xs, int ys) : cLSP(xs, ys)

{
    struct  {
        int     xs, ys, mode;
    }   mode[] = {
        640, 480, 0x101,
        800, 600, 0x103,
        1024, 768, 0x105,
        1280, 1024, 0x107,
        0,0,
    } ;

    for(int i=0; xs>mode[i].xs || ys>mode[i].ys; i++);

    nOFFSET = ((mode[i].ys-ys)/2)*mode[i].xs + ((mode[i].xs-xs)/2);

    InitMode(mode[i].mode);

    union REGS  r;
    r.w.ax = 0x7;
    r.w.cx = 0;
    r.w.dx = (nWIDTH-1)*2;
    int386(0x33, &r, &r);
    r.w.ax = 0x8;
    r.w.cx = 0;
    r.w.dx = nHEIGHT-1;
    int386(0x33, &r, &r);
}

    void
    cVESA :: Display()

{
    char    bank = nOFFSET/BANK_SIZE;
    int     offset = nOFFSET%BANK_SIZE;

    //while(inp(0x3da)&8);
    //while(!(inp(0x3da)&8));
    //while(!(inp(0x3da)&1));

    WriteBank(bank++);

    for(int y=0; y<nHEIGHT; y++, offset+=nWIDTH) {
        sLSP    *node = pLINENODE[y];
        for(int x=0; x<nWIDTH; node=node->next) {
            if (offset+node->x2 >= BANK_SIZE) {
                int     left = BANK_SIZE - (offset+x);

                memcpy((char*)0xa0000+offset+x, node->address, left);

                WriteBank(bank++);

                if (left != node->x2-x)
                    memcpy((char*)0xa0000, node->address+left, (node->x2-x)-left);

                offset -= BANK_SIZE;
            } else
                memcpy((char*)0xa0000 + offset + x, node->address, node->x2-x);

            x = node->x2;
        }
    }
}

#endif

#ifdef _WIN32

#include    <windows.h>
#include    <ddraw.h>

extern  HINSTANCE   Inst;

    cDIB :: cDIB(int xs, int ys, char *title) : cLSP((xs+3)&(~3), (ys+3)&(~3))

{
    pINFO     = (BITMAPINFOHEADER*) new char [sizeof(BITMAPINFOHEADER)+256*sizeof(PALETTEENTRY)+nWIDTH*nHEIGHT];
    pPALETTE  = (PALETTEENTRY*) ((char*)pINFO+sizeof(BITMAPINFOHEADER));
    pVRAM     = (char*)pINFO + 256*sizeof(PALETTEENTRY) + sizeof(BITMAPINFOHEADER);
    pHPALETTE = NULL;

    pINFO->biSize     = sizeof(BITMAPINFOHEADER);
    pINFO->biWidth    = nWIDTH;
    pINFO->biHeight   = -nHEIGHT;
    pINFO->biPlanes   = 1;
    pINFO->biBitCount = 8;

    RECT    rc = { 0, 0, nWIDTH, nHEIGHT };
    AdjustWindowRectEx(&rc, WS_CAPTION, NULL, NULL);

    pHWND = CreateWindow (
        "nIAKAmEDIA",
        title,
        WS_CAPTION|WS_MINIMIZEBOX|WS_SYSMENU,
        CW_USEDEFAULT, CW_USEDEFAULT,
        rc.right-rc.left,
        rc.bottom-rc.top,
        HWND_DESKTOP,
        NULL,
        Inst, NULL);

    ShowWindow(pHWND, SW_RESTORE);
    UpdateWindow(pHWND);
}

    cDIB :: ~cDIB()

{
    CloseWindow(pHWND);
    delete  pINFO;
}

    void
    cDIB :: SetPalette(char *palette)

{
    for(int i=0; i<256; i++, palette+=3) {
        pPALETTE[i].peRed   = palette[2];
        pPALETTE[i].peGreen = palette[1];
        pPALETTE[i].peBlue  = palette[0];
        pPALETTE[i].peFlags = NULL;
    }

    struct   tagLOGPALETTE {
        short        palVersion;
        short        palNumEntries;
        PALETTEENTRY palPalEntry[256];
    }   logpalette = { 0x300, 256, };

    memcpy(logpalette.palPalEntry, pPALETTE, sizeof(PALETTEENTRY)*256);

    if (pHPALETTE != NULL)
        delete pHPALETTE;

    pHPALETTE = CreatePalette(&logpalette);

    Refresh();
}

    void
    cDIB :: Refresh()

{
    InvalidateRect(pHWND, NULL, FALSE);
    UpdateWindow(pHWND);
}

    void
    cDIB :: Remark()

{
    PAINTSTRUCT ps;
    HDC         dc = BeginPaint(pHWND, &ps);
    HPALETTE    palette;

    if (pHPALETTE != NULL)
        palette = SelectPalette(dc, pHPALETTE, FALSE);

    RealizePalette(dc);                 // Color Mapping Processing

    SetDIBitsToDevice(dc,
        0, 0,                           // coordinate of upper-left corner of dest. rect.
        nWIDTH, nHEIGHT,                // source rectangle width, height
        0, nHEIGHT,                     // coordinate of lower-left corner of source rect.
        nHEIGHT,                        // first scan line in array
        nHEIGHT,                        // number of scan lines
        pVRAM,                          // address of array with DIB bits
        (BITMAPINFO*)pINFO,             // address of structure with bitmap info.
        DIB_RGB_COLORS);

    if (pHPALETTE != NULL)
        SelectPalette(dc, palette, FALSE);

    EndPaint(pHWND, &ps);
}

    void
    cDIB :: Display()

{
    char    *video = pVRAM;

    for(int y=0; y<nHEIGHT; y++, video+=nWIDTH)
    {
        sLSP    *node = pLINENODE[y];

        for(int x=0; x<nWIDTH; node=node->next)
        {
            memcpy(video+x, node->address, node->x2-x);
            x = node->x2;
        }
    }

    Refresh();
}

    cDDRAW :: cDDRAW(int xs, int ys, char *title) : cLSP(xs, ys)

{
    pHWND = CreateWindow (
        "nIAKAmEDIA",
        title,
        WS_POPUP,
        0, 0,
        GetSystemMetrics(SM_CXSCREEN),
        GetSystemMetrics(SM_CYSCREEN),
        HWND_DESKTOP,
        NULL,
        Inst, NULL);

    ShowWindow(pHWND, SW_RESTORE);
    UpdateWindow(pHWND);

    DirectDrawCreate(NULL, &pDRAW, NULL);
    pDRAW->SetCooperativeLevel(pHWND, DDSCL_EXCLUSIVE|DDSCL_FULLSCREEN);
    pDRAW->SetDisplayMode(nWIDTH, nHEIGHT, 8);

    DDSURFACEDESC   ddsd;
    DDSCAPS         ddscaps;

    memset(&ddsd, 0, sizeof(DDSURFACEDESC));

    ddsd.dwSize     = sizeof(DDSURFACEDESC);
    ddsd.dwFlags    = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
    ddsd.ddsCaps.dwCaps    = DDSCAPS_PRIMARYSURFACE | DDSCAPS_FLIP | DDSCAPS_COMPLEX;
    ddsd.dwBackBufferCount = 1;

    pDRAW->CreateSurface(&ddsd, &pPRIMARY, NULL);

    ddscaps.dwCaps         = DDSCAPS_BACKBUFFER;

    pPRIMARY->GetAttachedSurface(&ddscaps, &pSECONDARY);
}

    cDDRAW :: ~cDDRAW()

{
    pPRIMARY->Release();
    pDRAW->Release();
    CloseWindow(pHWND);
}

    void
    cDDRAW :: SetPalette(char *palette)

{
    LPDIRECTDRAWPALETTE DDrawPal;
    PALETTEENTRY        pe[256];

    for(int i = 0; i < 256; i++, palette+=3) {
        pe[i].peRed   = palette[0];
        pe[i].peGreen = palette[1];
        pe[i].peBlue  = palette[2];
        pe[i].peFlags = 0;
    }

    pDRAW->CreatePalette(DDPCAPS_8BIT, pe, &DDrawPal, NULL);
    pPRIMARY->SetPalette(DDrawPal);
}

    void
    cDDRAW :: Display()

{
    DDSURFACEDESC       DDSDesc;
    char    *video;

    if (pPRIMARY->IsLost() == DDERR_SURFACELOST)
        pPRIMARY->Restore();

    DDSDesc.dwSize = sizeof(DDSURFACEDESC);

    pSECONDARY->Lock(NULL, &DDSDesc, DDLOCK_WRITEONLY|DDLOCK_WAIT, NULL);

    video = (char*) DDSDesc.lpSurface;

    for(int y=0; y<nHEIGHT; y++, video+=nWIDTH)
    {
        sLSP    *node = pLINENODE[y];

        for(int x=0; x<nWIDTH; node=node->next)
        {
            memcpy(video+x, node->address, node->x2-x);
            x = node->x2;
        }
    }

    pSECONDARY->Unlock(NULL);

    pPRIMARY->Flip(NULL, DDFLIP_WAIT);
}

#endif
