#ifndef ragGFX_
#define ragGFX_

#include    "raglsp.h"

#ifdef __WATCOMC__

class   cMCGA : virtual public cLSP {
    public :
                cMCGA();
               ~cMCGA();
        void    SetPalette(char *palette);
        void    Display();

    private :
        int     nPREMODE;
} ;

class   cVESA : public cMCGA {
    public :
                cVESA(int xs, int ys);

        void    Display();

    private :
        void    InitMode(int videomode);
        int     nOFFSET;
} ;

#endif

#ifdef _WIN32

#include    <windows.h>

class   cDIB : public cLSP {
    public :
                cDIB(int xs, int ys, char *title="nOERROR");
               ~cDIB();

        void    SetPalette(char *palette);
        void    Display();
        void    Remark();

    private :
        void    Refresh();

        char    *pVRAM;

        HWND                pHWND;
        HPALETTE            pHPALETTE;
        BITMAPINFOHEADER    *pINFO;
        PALETTEENTRY        *pPALETTE;
} ;

#include    <ddraw.h>

class   cDDRAW : public cLSP {
    public :
                cDDRAW(int xs, int ys, char *title="nOERROR");
               ~cDDRAW();

        void    SetPalette(char *palette);
        void    Display();

    private :
        LPDIRECTDRAWSURFACE     pPRIMARY;
        LPDIRECTDRAWSURFACE     pSECONDARY;
        LPDIRECTDRAW            pDRAW;

        HWND    pHWND;
} ;

#endif

#endif
