// rAG
// lSP
//

#include    <string.h>
#include    "raglsp.h"
#include    "ragutil.h"
#include    "util.h"

    cLSP :: cLSP(int xs, int ys)

{
    nWIDTH    = xs;
    nHEIGHT   = ys;
    pLINENODE = new sLSP* [nHEIGHT];
    pITEM     = new cITEM <sLSP>;

    #ifdef __WATCOMC__  // I don't know, why its allocation' nodes causes problems later at watcom.
                        // It is a fatal fake.
    pITEM->Reset();
    for(int i=0; i<10000; i++)
        pITEM->Alloc();

    #endif

    Reset();
}

    cLSP :: ~cLSP()

{
    delete  pLINENODE;
    delete  pITEM;
}

    void
    cLSP :: Reset()

{
    static  char    dumb[1024] = { 'w','H','A','T',' ','t','H','E',' ','f','U','C','K',' ','i','S',' ','i','T',' ','?', 0};

    pITEM->Reset();

    for(int i=0; i<nHEIGHT; i++) {
        pLINENODE[i]          = pITEM->Alloc();
        pLINENODE[i]->x1      = 0;
        pLINENODE[i]->x2      = nWIDTH;
        pLINENODE[i]->layer   = 0;
        pLINENODE[i]->address = dumb;
        pLINENODE[i]->next    = NULL;
    }
}

    void
    cLSP :: PutImage(int y, int x1, int x2, char *image, char layer)

{
    sLSP   *prev, *next;
    int     xa, xb=0;

    prev = next = pLINENODE[y];

    for(; prev->x1 > x1 || x1 >= prev->x2; prev=prev->next) ;

    for(; xb < x2; prev=next) {
        for(; prev->layer>layer && prev->x2<x2; prev=prev->next) ;

        if (prev->layer > layer) return;

        for(next=prev; next->x2<x2 && next->layer<=layer; next=next->next);

        xa = Max(prev->x1, x1);
        xb = (next->layer <= layer) ? Min(next->x2, x2) : next->x1;

        if (prev == next) {
            sLSP    *att, *node;

            att  = pITEM->Alloc();

            memcpy(att, prev, sizeof(sLSP));

            if (prev->x1 != xa) {
                node = pITEM->Alloc();

                prev->x2      = xa;
                prev->next    = node;
            } else
                node = prev;

            node->x1      = xa;
            node->x2      = xb;
            node->layer   = layer;
            node->address = image + xa - x1;
            node->next    = att;

            att->x1       = xb;
            att->address += xb - prev->x1;
        } else {
            sLSP    *node;

            if (prev->x1 != xa) {
                node = pITEM->Alloc();

                prev->x2      = xa;
                prev->next    = node;
            } else
                node = prev;

            node->x1      = xa;
            node->x2      = xb;
            node->layer   = layer;
            node->address = image + xa - x1;
            node->next    = next;

            next->address+= xb - next->x1;
            next->x1      = xb;
        }
    }
}

    void
    cLSP :: PutImage(int x, int y, char *image, short xs, short ys, char layer)

{
    int     x1, y1, x2, y2;

    x1 = Max(x, 0);
    y1 = Max(y, 0);
    x2 = Min(nWIDTH, x+xs);
    y2 = Min(nHEIGHT, y+ys);

    if (x2 <= x1 || y2 <= y1) return;

    for(image+=(x1-x)+(y1-y)*xs; y1<y2; y1++, image+=xs)
        PutImage(y1, x1, x2, image, layer);
}

    void
    cLSP :: PutSprite(int x, int y, sSPR0 *spr, char layer)

{
    int     x1, y1, x2, y2;
    char    *data;

    x1 = Max(x, 0);
    y1 = Max(y, 0);
    x2 = Min(nWIDTH, x+spr->xs);
    y2 = Min(nHEIGHT, y+spr->ys);

    if (x2 <= x1 || y2 <= y1) return;

    for(; y1<y2; y1++)
    {
        data = spr->data[y1-y];

        for(int offset=x; offset<x2; )
        {
            short   skipbyte, putbyte;

            skipbyte = *(short*)(data);
            putbyte  = *(short*)(data+2);
            offset  += skipbyte + putbyte;

            if (putbyte != 0)
            {
                short   xa, xb;

                xa = Max(0, offset-putbyte);
                xb = Min(offset, nWIDTH);

                if (xb > xa)
                    PutImage(y1, xa, xb, data+4+(xa-(offset-putbyte)), layer);

                data += 4 + putbyte;
            }
        }
    }
}
