#ifndef ragLSP_
#define ragLSP_

#include    "rag.h"

#pragma pack(4)

struct  sLSP {
    short   x1, x2;
    char    layer;
    char   *address;
    sLSP   *next;
} ;

#pragma pack()

template <class TYPE> class  cITEM;

class   cLSP : public cVIDEO {
    public :
                cLSP(int xs, int ys);
        virtual ~cLSP();

        void    Reset();
        void    PutImage(int x, int y, char *data, short xs, short ys, char layer);
        void    PutSprite(int x, int y, sSPR0 *spr, char layer);

        virtual void    SetPalette(char *palette) {}
        virtual void    Display() = 0;

    protected :
        void    PutImage(int y, int x1, int x2, char *data, char layer);

        sLSP  **pLINENODE;

    private :
        cITEM <sLSP> *pITEM;
} ;

#define LAYER_BOTTOM  0

#endif
