#include <STDIO.H>
#include <MEM.H>
#include <MATH.H>
#include <ALLOC.H>

#define  FALSE  0
#define  TRUE   !FALSE
#define  YUI_X  159
#define  YUI_Y  141

typedef unsigned char byte;
typedef unsigned int  word;
typedef byte TPalette[256][3];
typedef byte AByte[35000];

AByte    image;
TPalette palette;
char     SCAN_CODE;
byte    *buffer;

int KeyPressed()
{
   int flag = TRUE;

   asm	mov  ah, 1
   asm	int  16h
   asm	jnz  KEY_PRESSED
   asm	mov  flag, FALSE
KEY_PRESSED:

   return flag;
}

char readKey()
{
   char result;
   int  i;

   if (SCAN_CODE > 0) {
	  result = SCAN_CODE;
	  SCAN_CODE = 0;
	  return result;
   }

RK_MAIN_LOOP:
   asm	mov  ah, 1
   asm	int  16h
   asm	jz   RK_MAIN_LOOP
   asm	mov  ah, 0
   asm	int  16h
   asm	cmp  al, 0
   asm	jne  RK_JUMP00
   asm	mov  SCAN_CODE, ah
RK_JUMP00:
   asm	mov  result, al

   return result;
}


void initGraph()
{
   asm  mov  ax, 13h
   asm  int 10h
}

void closeGraph()
{
   asm  mov ax, 03h
   asm  int 10h
}

void setRGB(byte Color, byte Red, byte Green, byte Blue)
{
   asm  mov  dx, 3C8h
   asm	mov  al, Color
   asm	out  dx, al
   asm  inc  dx
   asm  mov  al, Red
   asm  out  dx, al
   asm  mov  al, Green
   asm  out  dx, al
   asm  mov  al, Blue
   asm	out  dx, al
}

void moveRight()
{
   byte *pbuffer;

   pbuffer = buffer;

   asm  push ds
   asm  lds  si, pbuffer
   asm  les  di, pbuffer
   asm  inc  di
   asm  mov  cx, 320*200/4
   asm  db   66h
   asm  rep  movsw
   asm  pop  ds
}

void flipPage()
{
   byte *pbuffer;

   pbuffer = buffer;

   asm   push ds
   asm   lds  si, pbuffer
   asm   mov  ax, 0A000h
   asm   mov  es, ax
   asm   mov  di, 0
   asm   mov  cx, 320*200/4
   asm   db   66h
   asm   rep  movsw
   asm   pop  ds

   asm   les  di, pbuffer
   asm   mov  ax, 0A000h
   asm   mov  cx, 320*200
   asm   xor  ah, ah
FP_LOOP1:
   asm   mov  al, es:[di]
   asm   cmp  al, 00h
   asm   je   FP_LOOP2
   asm   add  al, 16
   asm   jc   FP_LOOP3
   asm   mov  es:[di], al
   asm   inc  di
   asm   loop FP_LOOP1
   asm   jmp  FP_END
FP_LOOP2:
   asm	  inc di
   asm   loop FP_LOOP1
   asm   jmp  FP_END
FP_LOOP3:
   asm   xor  ax, ax
   asm   mov  es:[di], al
   asm   inc  di
   asm   loop FP_LOOP1
FP_END:
}

void putImage(word x, word y, word x_size, word y_size, byte *image, byte skip_bit)
{
   byte *pbuffer;

   pbuffer = buffer;

   asm  push ds
   asm  lds  si, image
   asm  les  di, pbuffer
   asm  mov  ax, y
   asm  shl  ax, 2
   asm  add  ax, y
   asm  shl  ax, 6
   asm  add  ax, x
   asm  add  di, ax
   asm	mov  cx, y_size
PI_MAIN_LOOP:
   asm	push cx
   asm	mov  cx, x_size
PI_SUB_LOOP:
   asm	mov  al, ds:[si]
   asm	cmp  al, skip_bit
   asm	jz   PI_SKIP
   asm	mov  es:[di], al
PI_SKIP:
   asm	inc  si
   asm	inc  di
   asm	loop PI_SUB_LOOP
   asm	add  di, 320
   asm	sub  di, x_size
   asm	pop  cx
   asm	loop PI_MAIN_LOOP
   asm	pop  ds
}

void getImage(char *file_name)
{
   FILE *f;
   int  i, j;
   long curpos, length;

   if ((f = fopen(file_name,"rb")) == NULL) return;  /* ERROR !! */
   fread(&palette,sizeof(palette),1,f);

   curpos = ftell(f);
   fseek(f,0L,SEEK_END);
   length = ftell(f);
   fseek(f,curpos,SEEK_SET);

   fread(&image,length - ftell(f),1,f);
   fclose(f);

   for (j = 0; j < 16; j++) {
	  for (i = 0; i < 16; i++) {
		 setRGB(j*16+i,palette[i][0] * (15-j) / 15,
					   palette[i][1] * (15-j) / 15,
					   palette[i][2] * (15-j) / 15);
	  }
   }
}

void main()
{
   int i, j, flag;

   if ((buffer = (byte *)malloc(60004)) == NULL) return;
   memset(buffer,0,64004);

   initGraph();

   getImage("YUI.IMG");

   flag = 0;
   do {
	  while (KeyPressed()) readKey();
	  while (!KeyPressed()) {
		 if (!flag) {
			putImage(10,word(sin(i*0.05)*25)+25,
					 YUI_X,YUI_Y,image,0xFF);
		 } else {
			putImage(100+word(cos(i*0.05)*25),word(sin(i*0.05)*30)+30,
					 YUI_X,YUI_Y,image,0xFF);
		 }
		 flipPage();
		 moveRight();
		 i++;
	  }
	  flag = 1 - flag;
   } while (readKey() != 27);

   closeGraph();
   free(buffer);

}
