const
   YUI_X    = 159;
   YUI_Y    = 141;
type
   TBuffer  = array[0..320*200+3] of byte;
   TPalette = array[0..255,0..2] of byte;
   AByte    = array[0..34000] of byte;
var
   image     : AByte;
   palette   : TPalette;
   SCAN_CODE : char;
   buffer    : ^TBuffer;


function KeyPressed : boolean;
var
   flag : boolean;
begin
   flag := TRUE;
   asm
      mov ah, 1
      int $16
      jnz @KEY_PRESSED
      mov flag, 0
   @KEY_PRESSED:
   end;
   KeyPressed := flag;
end;

function readKey : char;
var
   i : integer;
begin
   if SCAN_CODE > #0 then begin
      readKey := SCAN_CODE;
      SCAN_CODE := #0;
      exit;
   end;
   asm
@MAIN_LOOP:
      mov ah, 1
      int $16
      jz  @MAIN_LOOP
      mov ah, 0
      int $16
      cmp al, 0
      jne @JUMP00
      mov SCAN_CODE, ah
@JUMP00:
      mov @RESULT, al
   end;

end;

procedure initGraph; assembler;
asm
      mov ax, 13h
      int 10h
end;

procedure closeGraph; assembler;
asm
      mov ax, 03h
      int 10h
end;

procedure setRGB(Color, Red, Green, Blue : byte); assembler;
asm
      mov dx,$3c8;
      mov al,Color;
      out dx,al;
      inc dx;
      mov al,Red;
      out dx,al;
      mov al,Green;
      out dx,al;
      mov al,Blue;
      out dx,al;
end;

procedure moveRight;
var
   pbuffer : pointer;
begin
   pbuffer := buffer;
   asm
      push ds
      lds si, pbuffer
      les di, pbuffer
      inc di
      mov cx, 320*200/4
      db  66h
      rep movsw
      pop ds
   end;
end;

procedure flipPage;
var
   pbuffer : pointer;
begin
   pbuffer := buffer;
   asm
      push ds
      lds si, pbuffer
      mov ax, 0A000h
      mov es, ax
      mov di, 0
      mov cx, 320*200/4
      db  66h
      rep movsw
      pop ds

      les di, pbuffer
      mov ax, 0A000h
      mov cx, 320*200
      xor ah, ah
@@LOOP1:
      mov al, es:[di]
      cmp al, 00h
      je  @@LOOP2
      add al, 16
      jc  @@LOOP3
      mov es:[di], al
      inc di
      loop @@LOOP1
      jmp @@END
@@LOOP2:
      inc di
      loop @@LOOP1
      jmp @@END
@@LOOP3:
      xor ax, ax
      mov es:[di], al
      inc di
      loop @@LOOP1
@@END:
   end;
end;

procedure putImage(x,y,x_size,y_size : word; var image; skip_bit : byte);
var
   pbuffer : pointer;
begin
   pbuffer := buffer;
   asm
      push ds
      lds si, image
      les di, pbuffer
      mov ax, y
      shl ax, 2
      add ax, y
      shl ax, 6
      add ax, x
      add di, ax
      mov cx, y_size
   @MAIN_LOOP:
      push cx
      mov cx, x_size
   @SUB_LOOP:
      mov al, ds:[si]
      cmp al, skip_bit
      jz  @SKIP
      mov es:[di], al
   @SKIP:
      inc si
      inc di
      loop @SUB_LOOP
      add di, 320
      sub di, x_size
      pop cx
      loop @MAIN_LOOP
      pop ds
   end;
end;

procedure getImage(file_name : string);
var
   f : file;
   i, j : integer;
begin
   assign(f,file_name);
   reset(f,1);
   BlockRead(f,palette,sizeof(palette));
   BlockRead(f,image,FileSize(f) - FilePos(f));
   close(f);
   for j := 0 to 15 do begin
      for i := 0 to 15 do begin
         setRGB(j*16+i,palette[i,0] * (15-j) div 15,
                       palette[i,1] * (15-j) div 15,
                       palette[i,2] * (15-j) div 15);
      end;
   end;
end;

var
   i, j, flag : integer;
begin

   new(buffer);
   fillChar(buffer^,sizeof(buffer^),#0);

   initGraph;

   getImage('YUI.IMG');

   flag := 0;
   repeat
      while KeyPressed do readKey;
      while not KeyPressed do begin
         if flag = 0 then begin
            putimage(10,round(sin(i*0.05)*25)+25,
                     YUI_X,YUI_Y,image,$FF);
         end else begin
            putimage(100+round(cos(i*0.05)*25),round(sin(i*0.05)*30)+30,
                     YUI_X,YUI_Y,image,$FF);
         end;
         flipPage;
         moveRight;
         inc(i);
      end;
      flag := 1 - flag;
   until readKey = #27;

   closeGraph;
   dispose(buffer);

end.
