
/*==========================================================*/
void read_font()
{

    FILE *fp;


   fp = fopen("hangul.fnt", "rb");
   if(fp==NULL) {
      printf("Font file not found\n");
      exit(0);
   }


    fread((void *)first, 5120, 1, fp);            /*  5120 = 8 x 20 x 32 */
    fread((void *)mid, 2816, 1, fp);              /*  2816 = 4 x 22 x 32 */
    fread((void *)endtable, 3584, 1, fp);         /*  3584 = 4 x 28 x 32 */


    fclose(fp);                         /*     11520 byte  */

    fp = fopen("english.fnt", "rb");
    fread(english, 4096, 1, fp);
    fclose(fp);
}

/*===================================================================*/
char far *load_cel(char *name, WORD *xsize, WORD *ysize)
{
	int j;
	char far *pal;
	char far *data;
	WORD _xsize, _ysize;
	FILE *fp;
	fp = fopen(name, "rb");
	if(!fp)
	{
		printf("%s file not found\n.", name);
		exit(0);
	}
	fseek(fp, 2L,SEEK_SET);
	fread(&_xsize, 2,1, fp);
	fread(&_ysize, 2,1, fp);
	data = farmalloc(_xsize * _ysize);
	if (!data)
	{
		printf("momory allocation error data !!!\n");
		exit(0);
	}
	pal = farmalloc(768);
	if (!pal)
	{
		printf("memory allocation error pal \n");
		exit(0);
	}

	fseek(fp,32L,SEEK_SET);
	fread((void *) pal,768,1,fp);
	fread((void *) data, _xsize, _ysize,fp);
	*xsize = _xsize; *ysize = _ysize;
	fclose(fp);

	palette_setm(pal);
	farfree(pal);
	return(data);
}
/*=================================================================*/
char far *read_pcx(char *name)
{
	FILE *fp;
	int i, x = 0, y =0, mx, my;
	BYTE pal[768];
	BYTE far *mem;
	BYTE ch, data;

	mem = farmalloc(64000);
	memset(mem, 0,64000);
	fp = fopen(name, "rb");
	if(!fp)
	{
		printf("%s file not found\n.", name);
		exit(0);
	}
	fread(&header, 128, 1, fp);

	fseek(fp, -768, SEEK_END);
	fread(pal, 768, 1, fp);
	for(i=0;i<768; i++) pal[i] = pal[i] >> 2;
	palette_setm(pal);

	fseek(fp, 128, SEEK_SET);

	mx = header.x2;
	if (mx > 319) mx = 320;
	my = header.y2;
	if (my > 199) my = 200;

	while(1)
	{
		ch = fgetc(fp);
		if ((ch & 0xc0) == 0xc0)
		{
			data = getc(fp);
			for(i=0; i < (ch & 0x3f) ; i++)
			{
				mem[(y*320)+ x++] = data;
			}
		}
		else mem[(y*320) + x++] = ch;

		if (x > mx)
		{
			x=0;
			y +=1;
		}
		if (y > my) break;
	}
	fclose(fp);
	return(mem);
}
/*=================================================================*/
void put_image_clip(int x, int y, char far *dat, int _xsize, int _ysize, WORD vseg)
{
   char far *video;
   char far *start_si;
   char far *xx;
   char far *si;
   int i,j,k,plane,start_di,yy, getsu, di, plane_cnt;

   int temp, tempbx, tempcx;
   int l,r,t,b,startx,starty,r_y,xsize,ysize;

   l=r=t=b=0;
   di=0;

   startx=x;
   if (x<0) l=l-x;

   if ((x+_xsize) > 320) r=(x+_xsize)-320;

   starty=y;
   if (y<0) t=t-0;

   if (400 < (y+ _ysize))        /* y  Ёwa 400 a        */
      b=(y+ _ysize)-400;         /*  iϷ ១i aᴡ ea. */


   r_y=_xsize;

   xsize = _xsize - l - r;

   if (xsize<=0) return;

   ysize = _ysize - t - b;
   if (ysize<=0) return;

   startx=startx+l;
   temp = ((starty+t)*80) + (startx>>2);

   di=di+temp;
   start_di=di;


   temp = t * _xsize + l;

   si=dat;
   si=si+temp;

   start_si=si;

   plane_cnt = xsize & 3;

   outportb(SC_INDEX, 2);

   plane=1<<(startx&3);

   xx=si;
   yy=di;


   for (i=4; i>0; i--)
   {
     getsu=xsize>>2;
     if ((plane_cnt + i) >= 5) getsu++;
     startx=getsu;
     if (getsu==0) return;
     xx++;
     outportb(SC_INDEX+1, plane);

     for (k=0; k<ysize; k++)
     {

	 video = MK_FP(vseg,di);

		for (j=0; j<getsu; j++)
		{
			*video=*si;
			si+=4;
			di++;
			FP_OFF(video) = di;
			/*video = MK_FP(vseg,di); */
		 }

	si=start_si=start_si+r_y;
	di=start_di=start_di+80;
     }
     plane=plane<<1;

    if (plane>8)
    {
	plane=1;
	yy++;
     }

    si=start_si=xx;
    di=start_di=yy;
  }

}
/*=================================================================*/
void put_image_clip2(int x, int y, char far *dat, int _xsize, int _ysize, WORD vseg)
{
   char far *video;
   char far *start_si;
   char far *xx;
   char far *si;
   int i,j,k,h,plane,start_di,yy, getsu, di, plane_cnt;

   int temp, tempbx, tempcx;
   int l,r,t,b,startx,starty,r_y,xsize,ysize;

   l=r=t=b=0;
   di=0;

   startx=x;
   if (x<0) l=l-x;

   if ((x+_xsize) > 320) r=(x+_xsize)-320;

   starty=y;
   if (y<0) t=t-0;

   if (400 < (y+ _ysize))        /* y  Ёwa 400 a        */
      b=(y+ _ysize)-400;         /*  iϷ ១i aᴡ ea. */


   r_y=_xsize;

   xsize = _xsize - l - r;

   if (xsize<=0) return;

   ysize = _ysize - t - b;
   if (ysize<=0) return;

   startx=startx+l;
   temp = ((starty+t)*80) + (startx>>2);

   di=di+temp;
   start_di=di;


   temp = t * _xsize + l;

   si=dat;
   si=si+temp;

   start_si=si;

   plane_cnt = xsize & 3;

   outportb(SC_INDEX, 2);

   plane=1<<(startx&3);

   xx=si;
   yy=di;


   for (i=4; i>0; i--)
   {
     getsu=xsize>>2;
     if ((plane_cnt + i) >= 5) getsu++;
     startx=getsu;
     if (getsu==0) return;
     xx++;
     outportb(SC_INDEX+1, plane);

     for (k=0; k<ysize; k++)
     {

	 video = MK_FP(vseg,di);
		for (h=0; h<2 ; h++)
		{

			for (j=0; j<getsu; j++)
			{
				*video=*si;
				si+=4;
				di++;
				FP_OFF(video) = di;
				/*video = MK_FP(vseg,di); */
			 }
		   }
	si=start_si=start_si+r_y;
	di=start_di=start_di+160;
     }
     plane=plane<<1;

    if (plane>8)
    {
	plane=1;
	yy++;
     }

    si=start_si=xx;
    di=start_di=yy;
  }

}

/*================================================================*/
void put_sprite_clip(int x, int y, char far *dat, int _xsize, int _ysize, WORD vseg)
{
   char far *video;
   char far *start_si;
   char far *xx;
   char far *si;
   int i,j,k,plane,start_di,yy, getsu, di, plane_cnt;

   int temp, tempbx, tempcx;
   int l,r,t,b,startx,starty,r_y,xsize,ysize;

   l=r=t=b=0;
   di=0;

   startx=x;
   if (x<0) l=l-x;

   if ((x+_xsize) > 320) r=(x+_xsize)-320;

   starty=y;
   if (y<0) t=t-0;

   if (400 < (y+ _ysize))        /* y  Ёwa 400 a        */
      b=(y+ _ysize)-400;         /*  iϷ ១i aᴡ ea. */


   r_y=_xsize;

   xsize = _xsize - l - r;

   if (xsize<=0) return;

   ysize = _ysize - t - b;
   if (ysize<=0) return;

   startx=startx+l;
   temp = ((starty+t)*80) + (startx>>2);

   di=di+temp;
   start_di=di;


   temp = t * _xsize + l;

   si=dat;
   si=si+temp;

   start_si=si;

   plane_cnt = xsize & 3;

   outportb(SC_INDEX, 2);

   plane=1<<(startx&3);

   xx=si;
   yy=di;


   for (i=4; i>0; i--)
   {
     getsu=xsize>>2;
     if ((plane_cnt + i) >= 5) getsu++;
     startx=getsu;
     if (getsu==0) return;
     xx++;
     outportb(SC_INDEX+1, plane);

     for (k=0; k<ysize; k++)
     {

	 video = MK_FP(vseg,di);

		for (j=0; j<getsu; j++)
		{
			if(*si!=0) *video=*si;
			si+=4;
			di++;
			FP_OFF(video) = di;
			/*video = MK_FP(vseg,di); */
		 }

	si=start_si=start_si+r_y;
	di=start_di=start_di+80;
     }
     plane=plane<<1;

    if (plane>8)
    {
	plane=1;
	yy++;
     }

    si=start_si=xx;
    di=start_di=yy;
  }

}
/*========================================================================*/
void put_sprite_clip2(int x, int y, char far *dat, int _xsize, int _ysize, WORD vseg)
{
   char far *video;
   char far *start_si;
   char far *xx;
   char far *si;
   int i,j,k,h,plane,start_di,yy, getsu, di, plane_cnt;

   int temp, tempbx, tempcx;
   int l,r,t,b,startx,starty,r_y,xsize,ysize;

   l=r=t=b=0;
   di=0;

   startx=x;
   if (x<0) l=l-x;

   if ((x+_xsize) > 320) r=(x+_xsize)-320;

   starty=y;
   if (y<0) t=t-0;

   if (400 < (y+ _ysize))        /* y  Ёwa 400 a        */
      b=(y+ _ysize)-400;         /*  iϷ ១i aᴡ ea. */


   r_y=_xsize;

   xsize = _xsize - l - r;

   if (xsize<=0) return;

   ysize = _ysize - t - b;
   if (ysize<=0) return;

   startx=startx+l;
   temp = ((starty+t)*80) + (startx>>2);

   di=di+temp;
   start_di=di;


   temp = t * _xsize + l;

   si=dat;
   si=si+temp;

   start_si=si;

   plane_cnt = xsize & 3;

   outportb(SC_INDEX, 2);

   plane=1<<(startx&3);

   xx=si;
   yy=di;


   for (i=4; i>0; i--)
   {
     getsu=xsize>>2;
     if ((plane_cnt + i) >= 5) getsu++;
     startx=getsu;
     if (getsu==0) return;
     xx++;
     outportb(SC_INDEX+1, plane);

     for (k=0; k<ysize; k++)
     {

	 video = MK_FP(vseg,di);
		for (h=0;h<2;h++)
		{
			for (j=0; j<getsu; j++)
			{
				if(*si!=0) *video=*si;
				si+=4;
				di++;
				FP_OFF(video) = di;
				/*video = MK_FP(vseg,di); */
			 }
		 }
	si=start_si=start_si+r_y;
	di=start_di=start_di+160;
     }
     plane=plane<<1;

    if (plane>8)
    {
	plane=1;
	yy++;
     }

    si=start_si=xx;
    di=start_di=yy;
  }

}

/*================================================================*/
void view_page(char mode)
{
	if (mode == 1)
	{
		outportb(0x3d4,0x0c); outportb(0x3d5, 0x7d);
		PAGE_MODE = 1;
	}
	else {
		outportb(0x3d4,0x0c); outportb(0x3d5, 0x00);
		PAGE_MODE =0;
		}
}
/*================================================================*/
void view_page_auto_change(void)
{
	if (PAGE_MODE == 0)
	{
			outportb(0x3d4,0x0c); outportb(0x3d5, 0x7d);
			PAGE_MODE = 1;
	}
	else {
		outportb(0x3d4,0x0c); outportb(0x3d5, 0x00);
		PAGE_MODE = 0;
		}
}
/*================================================================*/
WORD memory_page_select(void)
{
	WORD mem;
	if (PAGE_MODE ==1)
	{
		mem = 0xa000;
	}
	else {
		mem = 0xa7d0;
		}
	return(mem);
}

/*================================================================*/
/*iai e Ǳ*/
void convert1(BYTE *dest, int chars)
  {
   int i;
   for(i=0; i != chars ; i++) dest[i] = ~dest[i];
  }
/*-------------------------------------------------*/
/*A¬e b Ǳ*/
void convert2(BYTE *dest, int chars)
  {
   int i;
   char temp[32];
   memcpy(temp, dest, chars);
   for(i=0;i<chars;i++){
           dest[i] |= temp[i] >> 1;
           dest[i] |= temp[i] << 1;
           }
   if (chars == 16)
          {
           for(i=0; i<= 14; i++) dest[i+1] |= temp[i];
           for(i=0; i<= 15; i++) dest[i-1] |= temp[i];
           for(i=0; i<= 14; i++) dest[i]   ^=  temp[i];
          }
    else  {
           for(i=0; i<= 29 ; i++) dest[i+2] |= temp[i];
           for(i=0; i<= 31 ; i++) dest[i-2] |= temp[i];
           for(i=0; i<= 31 ; i++) dest[i]  ^= temp[i];
          }
  }
/*-------------------------------------------------*/
/*aa b*/
void convert3(BYTE *dest, int chars)
 {
  int i;
   char temp[32];
   memcpy(temp , dest, chars);

   if (chars == 16)
       {
	for(i=0; i< 16; i++) dest[i]   |= temp[i] >> 1;
	for(i=0; i< 15; i++) dest[i+1] |= temp[i];
	for(i=0; i< 16; i++) dest[i]   ^= temp[i];
       }
    else {
	   for(i=0; i< 32; i++) dest[i]   |= temp[i] >> 1;
	   for(i=0; i< 30; i++) dest[i+2] |= temp[i];
	   for(i=0; i< 32; i++) dest[i]   ^= temp[i];
	  }
 }
/*-------------------------------------------------*/
void or_image(char *src,char *dest,int lens)
  {
   int i;
   for(i=0; i < lens; i++) dest[i] |= src[i];
  }
/*-------------------------------------------------*/
void htextxy(char cho, char jung,char jong,int f,char color, WORD vesg)
 {
  int t1, t2, t3;
  unsigned h1,h2,h3;

  h1 = hantable[0][cho];
  h2 = hantable[1][jung];
  h3 = hantable[2][jong];


  t1 = h3 ? cho_tb_yes[h2] : cho_tb_no[h2];
  t2 = ((h1 == 0 || h1 == 1 || h1 == 16) ? 0 : 1) + (h3 ? 2 : 0);
  t3 = jong_tb[h2];

  if (h1)  memcpy(han_mem, first[t1][h1], 32);
  else memset(han_mem, 0, 32);

  if (h2)  or_image( mid[t2][h2], han_mem, 32);
  if (h3)  or_image( endtable[t3][h3], han_mem, 32);


 switch (f)
  {
   case 1 : convert1(han_mem, 32); break;
   case 2 : convert2(han_mem, 32); break;
   case 3 : convert3(han_mem, 32); break;
  }
  put16_16(_x,_y,han_mem,color, vesg);
  _x+=16;
  }

/*-------------------------------------------------*/
void textxy(char text,int f, char color, WORD vesg)
{
  memset(eng_mem, 0, 16);
  memmove(eng_mem, &english[text][0], 16);

   switch (f)
  {
   case 1 : convert1(eng_mem, 16); break;
   case 2 : convert2(eng_mem, 16); break;
   case 3 : convert3(eng_mem, 16); break;
  }
 put8_16(_x ,_y, eng_mem,color,vesg);
 _x +=8;
 }
/*-------------------------------------------------*/
void graphputs(int x,int y,int f,char color, char *st, WORD vesg)
 {
  BYTE data1, data2;
  BYTE cho, jung,jong;
  int t1,t2,t3,i;
  _x=x; _y=y;

  for(i=0; i<strlen(st); i++)
    {
      data1 = *(st+i);
      if (data1 > 127) {
                         i++;
                         data2 = *(st+i);
                         cho  = (data1 & 124) >> 2;
                         jung = (data1 & 3) * 8 + (data2 >> 5);
                         jong = (data2 & 31);

			 htextxy(cho,jung,jong,f,color, vesg);

                       }
	   else  {
		  textxy(data1,f,color,vesg);
		  }
   }
 }
/********************** scroll routin ******************************/
/*=================================================================*/
void V_Sync(void)
{
	while(inp(0x3da) & (char) 8);
	while((inp(0x3da) & (char) 8) == (char)0);
}
/*=================================================================*/
void start_addr(WORD i)
{
	BYTE shigh;
	BYTE slow;
	shigh=(i>>8) & 0xff;
	slow = i & 0xff;

	while((inp(0x3da) & (char)8) == (char)0);

	outportb(0x3d4, 0x0c); outportb(0x3d5, shigh);
	outportb(0x3d4, 0x0d); outportb(0x3d5, slow);
}
/*================================================================*/
void pelpan(WORD x)
{
	WORD offset,xoffset;

	xoffset = (x % 4) << 1;
	offset = x/4;

	start_addr(offset);
	inportb(0x3d4);
	V_Sync();
	inportb(0x3da);
	outportb(0x3c0, 0x33);
	outportb(0x3c0, xoffset);
}
/*================================================================*/
void scroll_up(WORD gan)
{
	WORD ad, i;
	ad = 0x7d00;
	for(i=ad;i>0;i-=gan)
	{
		start_addr(i);
	}
}
/*================================================================*/
void scroll_down(WORD gan)
{
	WORD ad,i;
	ad = 0x7d00;
	for(i=0;i<ad;i+=gan)
	{
		start_addr(i);
	}
	/*copy_so_ta(0,0,PAGE1,0,0,PAGE0,320,400);
	view_page(1);      */
}
/*================================================================*/
void page_source_target_move(WORD source, WORD target)
{
	set_write_mode(1);
	set_plane_enable();
	copy_page(source, target);
	set_write_mode(0);
}
/*================================================================*/
void y_line_copy(WORD so_x, WORD pa_so, WORD ta_x, WORD pa_ta)
{
	set_write_mode(1);
	set_plane_enable();
	yline_memory_move(so_x,pa_so,ta_x, pa_ta);
	set_write_mode(0);
}
/*================================================================*/
void scroll_left(void)
{
	WORD i,j=0;
	for(i=0;i<80;i+=2)
	{
        	pelpan(j);
		y_line_copy(i,PAGE1,78+i,PAGE0);
		y_line_copy(i+1,PAGE1,79+i,PAGE0);
		j +=8;
	}
}

/*================================================================*/
void scroll_right(void)
{
	WORD i, j=320;
	for(i=80; i>0; i-=2)
	{
		pelpan(j);
		y_line_copy(i-1,PAGE1,i-79,PAGE0);
		y_line_copy(i-2,PAGE1,i-80,PAGE0);
		j -=8;
	}
}
/*=================================================================*/
void copy_so_ta(int p1_x, int p1_y, WORD source, int p2_x, int p2_y, WORD target, int w, int h)
{
	set_write_mode(1);
	set_plane_enable();
	copy_page1_page2(p1_x, p1_y, source, p2_x, p2_y, target, w, h);
	set_write_mode(0);
}
/*======================================================================*/
void palette_setm(BYTE far *p)
{
	WORD i;
	palete_set(p);
	for(i=0; i<768; i ++)
	{
		PALETTE[i] = *p;
		p++;
	}
}
/*=====================================================================*/
void fade_run( int p )
{
    int i;
    BYTE r, g, b;

    outportb( 0x03C8, 0 );

    for ( i = 0; i < 768; i += 3 )
    {
	 r = (PALETTE[i  ] * p)/100; outportb( 0x03C9, r );
	 g = (PALETTE[i+1] * p)/100; outportb( 0x03C9, g );
	 b = (PALETTE[i+2] * p)/100; outportb( 0x03C9, b );
    }
}
/*=====================================================================*/
void fade_in(int dely)
{
	WORD i;
	for (i=100; i>0; i--)
	{
		V_Sync();
		fade_run(i);
		delay(dely);
	}
}
/*=====================================================================*/
void fade_out(int dely)
{
	WORD i;
	for (i=0; i<100; i++)
	{
		V_Sync();
		fade_run(i);
		delay(dely);
	}
}
/*=====================================================================*/
void gray_run(WORD delayy)
{
    BYTE data[768];
    int i, ff = 0, co=1;
    BYTE r, g, b, gray;

    memcpy( data, PALETTE, 768 );
    outportb( 0x3C8, 0 );

    while (co)
    {
	ff = 0;
        V_Sync();
        for ( i = 0; i < 768; i += 3 )
	{
	    r = PALETTE[i+0];
	    g = PALETTE[i+1];
	    b = PALETTE[i+2];

            gray = ( (r * 30) + (g * 59) + (b * 11) ) / 100;

            if ( data[i+0] > gray ) data[i+0]--;
            if ( data[i+0] < gray ) data[i+0]++;
            if ( data[i+1] > gray ) data[i+1]--;
            if ( data[i+1] < gray ) data[i+1]++;
            if ( data[i+2] > gray ) data[i+2]--;
            if ( data[i+2] < gray ) data[i+2]++;

            if ( data[i+0] == gray ) ff++;
            if ( data[i+1] == gray ) ff++;
            if ( data[i+2] == gray ) ff++;

            outportb( 0x3C9, data[i+0] );
            outportb( 0x3C9, data[i+1] );
            outportb( 0x3C9, data[i+2] );
	}
	if (ff == 768) co =0;
	delay( delayy );
    }
}
/*=====================================================================*/

