;=======================================
;   vga 320x400 256color libarly ver0.1
;=======================================
;   moon sung chul
;=======================================
dosseg
.model large,c
;------------------------------------------
.data
;------------------------------------------
; put_dot
xm    dw 10
ym    dw 10
cm    db 120
pam   dw 0a000h

; m_line data
xdelta dw 0
ydelta dw 0
xstep  dw 1
ystep  dw 1
change dw 0

; put16_16
i        dw ?
j        dw ?
start_di dw ?
t        dw 0
b        dw 0
t_end    dw 0
b_end    dw 400
start_plane db ?

; put8_16
i1        dw ?
j1        dw ?
start_di1 dw ?
t1        dw 0
b1        dw 0
t_end1    dw 0
b_end1    dw 400
start_plane1 db ?




;------------------------------------------
.code
public set320by400mode
public put_dot
public vga320x200
public vga720x350
public m_line
public clear_screen
public put16_16
public put8_16
public copy_page
public set_plane_enable
public set_write_mode
public yline_memory_move
public copy_page1_page2
public get_image
public put_image
public copy_so_ta_far
public block_copy_far

public vga_pset
public vga_get
public linex
public liney
public palete_set
;=================================================
;     320 x 400 mode set
;     void set320by400mode(void)
;=================================================
set320by400mode proc
                uses si,di,ds
                mov ax,13h
                int 10h

                mov dx,3c4h
                mov al,4
                out dx,al
                inc dx
                in al,dx
                and al,not 08h
                or al,4
                out dx,al

                mov dx,3ceh
                mov al,5
                out dx,al
                inc dx
                in al,dx
                and al, not 10h
                out dx,al

                dec dx
                mov al,6
                out dx,al
                inc dx
                in al,dx
                and al, not 2
                out dx, al

                mov dx,3c4h
                mov al, 2
                mov ah, 0fh
                out dx, ax
                mov ax, 0a000h

                mov es, ax
                xor di,di
                mov ax,di
                mov cx,8000h
                cld
                rep stosw

                mov dx, 3d4h
                mov al, 9
                out dx, al
                inc dx
                in al,dx
                and al, 0e0h
                out dx, al

                mov dx, 3d4h
                mov al, 14h
                out dx, al
                inc dx
                in al, dx
                and al, not 40h
                out dx, al
                dec dx
                mov al, 17h
                out dx, al
                inc dx
                in al, dx
                or al, 40h
                out dx, al
                ret
set320by400mode endp
;*************************************************************
; put_dotm
; xm, ym, cm, pam
;*************************************************************
put_dotm proc nolanguage

         mov al,2
         mov dx,3c4h
         out dx,al

         mov cx, word ptr ds:xm
         and cx,3
         mov al,1
         shl al,cl
         mov dx,3c5h
         out dx,al

         mov ax,word ptr ds:pam
         mov es,ax

         mov ax,word ptr ds:xm
         mov cl,2
         shr ax,cl
         mov bx,ax

         mov ax,word ptr ds:ym
         mov dx,80
         mul dx

         add bx,ax

         mov dl,byte ptr ds:cm
         mov byte ptr es:[bx], dl


         ret

put_dotm endp
;************************************************************

;============================================================
; dot print
; put_dot(int x, int y, unsigned char c, unsigned int pa)
;============================================================
put_dot proc
        arg x:word, y:word, c:byte, pa:word
        uses si,di,ds,es

        mov al,2
        mov dx,3c4h
        out dx,al

        mov cx,x
        and cx,3
        mov al,1
        shl al,cl
        mov dx,3c5h
        out dx,al

        mov ax,pa
        mov es,ax

        mov ax,x
        mov cl,2
        shr ax,cl
        mov bx,ax

        mov ax,y
        mov dx,80
        mul dx

        add bx,ax

        mov dl,c
        mov byte ptr es:[bx], dl

        ret

put_dot endp
;=========================================================================
; m_line(int x1, int y1, int x2, int y2, unsigned char color, unsigned pa1)
;==========================================================================

m_line proc
       arg x1:word, y1:word, x2:word, y2:word, color:byte, pa1:word
       uses si,di,ds,es

       mov word ptr xstep,1
       mov word ptr ystep,1
       mov ax,x1
       mov bx,x2
       cmp ax,bx
       ja loopm1

       mov ax,x2
       sub ax,x1
       mov word ptr xdelta, ax
       jmp loopm2

loopm1:
       mov ax,x1
       sub ax,x2
       mov word ptr xdelta, ax
       mov al,-1
       cbw
       mov word ptr xstep, ax

loopm2:
       mov ax,y1
       mov bx,y2
       cmp ax,bx
       ja loopm3
       mov ax,y2
       sub ax,y1
       mov word ptr ydelta, ax
       jmp loopm4

loopm3:
       mov ax,y1
       sub ax,y2
       mov word ptr ydelta, ax
       mov al,-1
       cbw
       mov word ptr ystep, ax

loopm4:
       mov ax,x1
       mov word ptr xm, ax
       mov ax,y1
       mov word ptr ym, ax
       mov al,color
       mov byte ptr cm, al
       mov ax,pa1
       mov word ptr pam, ax
       call put_dotm

       mov ax, xdelta
       mov bx, ydelta
       cmp ax, bx
       ja loopm12
       mov ax, ydelta
       shr ax, 1
       mov change, ax

loopm5:
       mov ax,y1
       mov bx,y2
       cmp ax,bx
       je loopm80


       mov ax,x1
       mov word ptr xm, ax
       mov ax,y1
       mov word ptr ym, ax
       mov al,color
       mov byte ptr cm, al
       mov ax,pa1
       mov word ptr pam, ax
       call put_dotm

       mov ax,y1
       mov bx,ystep
       add ax,bx
       mov word ptr y1, ax

       mov ax, change
       mov bx, xdelta
       add ax, bx
       mov word ptr change, ax
       mov ax,change
       mov bx,ydelta
       cmp ax, bx
       ja loopm6
       jmp loopm5

loopm6:
       mov ax,x1
       add ax,xstep
       mov word ptr x1,ax

       mov ax, change
       sub ax, ydelta
       mov word ptr change, ax
       jmp loopm5

loopm80: jmp loopm8

loopm12:
        mov ax,xdelta
        shr ax,1
        mov word ptr change, ax

        mov ax,x1
        mov bx,x2
        cmp ax,bx
        je loopm8

       mov ax,x1
       mov word ptr xm, ax
       mov ax,y1
       mov word ptr ym, ax
       mov al,color
       mov byte ptr cm, al
       mov ax,pa1
       mov word ptr pam, ax
       call put_dotm

       mov ax,x1
       add ax,xstep
       mov word ptr x1,ax

       mov ax, change
       add ax, ydelta
       mov word ptr change, ax

       mov ax,change
       mov bx,xdelta
       cmp ax, bx
       ja loopm13
       jmp loopm12

loopm13:
        mov ax,y1
        add ax, ystep
        mov word ptr y1,ax

        mov ax, change
        sub ax, xdelta
        mov word ptr change, ax

loopm14: jmp loopm12

loopm8: ret

        endp
;========================================================================
; clear_screen(unsigned char c, unsigned int pa2)
;========================================================================
clear_screen proc
            arg c:byte, pa2:word
            uses es,di,si

            mov dx, 3c4h
            mov al, 2
            mov ah, 0fh
            out dx, ax
            mov ax, word ptr pa2
            mov es, ax
            mov di, 0
            mov ah, c
            mov al, c
            mov cx, 16000
            cld
            rep stosw

            ret
            endp
;===========================================================
;void palete_set(char far *pal)
;===========================================================
palete_set proc
           arg pal:dword
           uses si,di,ds,es
           mov ah,10h
           mov al,12h
           mov bx,0
           mov cx,256
           les dx,pal
           int 10h
           ret
           endp
;======================================================================
;void put16_16(int x, int y, char fat *f, int color, unsigned int vesg)
;=======================================================================
put16_16 proc
         arg x:word, y:word, f:dword, color:word, vesg:word
         uses es,di,si

        mov     ax, word ptr vesg
        mov     es, ax
        lds     si, f

        mov     t, 0
        mov     b, 0

        mov     ax, t_end
        sub     ax, y
        jc      aa                         ; t=0
        mov     t, ax
        cmp     ax, 16
        jb      aa
        ret
aa:
        mov     ax, y
        add     ax, 16
        sub     ax, b_end
        jc      bb                        ; t=0
        mov     b, ax
        cmp     ax, 16
        jb      bb
        ret
bb:
        mov     ax, 80                    ; one line size
        mov     bx, y
        add     bx, t
        mul     bx
        mov     bx, x
        shr     bx, 1
        shr     bx, 1                     ; bx/4
        add     ax, bx
        mov     di, ax                     ; start address of video memory
        mov     start_di, ax

        mov     ax, t
        shl     ax, 1
        add     si, ax

        mov     dx, 3c4h                   ; sequencer register
        mov     al, 2                      ; color plane write enable index
        out     dx, al
        inc     dx                        ; data port
        mov     al, 11h
        mov     cx, x
        and     cl, 3
        rol     al, cl
        mov     start_plane, al           ; Calc. start plane

        mov     bx, color
        mov     cx, 16
        sub     cx, t
        sub     cx, b
y_loop:
        push    cx
        mov     cx, 8
        mov     bh, [si]
        mov     ah, [si+1]
x_loop:
        out     dx, al                    ; set write plane
        shl     bh, 1
        jnc     Ff
        mov     es:[di], bl
Ff:
        shl     ah, 1
        jnc     Fg
        mov     es:[di+2], bl
Fg:
        rol     al, 1
        cmp     al, 11h
        jne     Fhh
        inc     di                        ; next video addr
Fhh:
        loop    x_loop
        add     start_di, 80
        mov     di, start_di
        mov     al, start_plane
        add     si, 2
        pop     cx
        loop    y_loop
done:
        ret
        endp

;=======================================================================
;void put8_16(int x,int y, char far *buf, int color, unsigned int vesg1)
;=======================================================================
put8_16 proc
        arg x:word, y:word, buf:dword, color:word, vesg1:word
        uses es,di,si

        mov     ax, word ptr vesg1
        mov     es, ax
        lds     si, buf


        mov     t1, 0
        mov     b1, 0

        mov     ax, t_end1
        sub     ax, y
        jc      qq                        ; t=0
        mov     t1, ax
        cmp     ax, 16
        jb      qq
        ret
qq:
        mov     ax, y
        add     ax, 16
        sub     ax, b_end1
        jc      ww                        ; t=0
        mov     b1, ax
        cmp     ax, 16
        jb      ww
        ret
ww:
        mov     ax, 80                    ; one line size
        mov     bx, y
        add     bx, t1
        mul     bx
        mov     bx, x
        shr     bx, 1
        shr     bx, 1                     ; bx/4
        add     ax, bx
        mov     di, ax                    ; start address of video memory
        mov     start_di1, ax

        add     si, t1

        mov     dx, 3c4h                  ; sequencer register
        mov     al, 2                     ; color plane write enable index
        out     dx, al
        inc     dx                        ; data port
        mov     al, 11h
        mov     cx, x
        and     cl, 3
        rol     al, cl
        mov     start_plane1, al           ; Calc. start plane

        mov     bx, color
        mov     cx, 16
        sub     cx, t1
        sub     cx, b1

y_loop1:
        push    cx
        mov     cx, 8
        mov     bh, [si]
x_loop1:
        out     dx, al                    ; set write plane
        shl     bh, 1
        jnc     offffff
        mov     es:[di], bl

offffff:
        rol     al, 1
        cmp     al, 11h
        jne     Aaaaaaa
        inc     di                        ; next video addr

Aaaaaaa:
        loop    x_loop1

        add     start_di1, 80
        mov     di, start_di1
        mov     al, start_plane1
        inc     si
        pop     cx
        loop    y_loop1
        ret
        endp
;========================================================================
; copy_page(unsigned int source, unsigned int target)
;========================================================================
copy_page proc
          arg source:word, target:word
          uses ds,es,si,di

          mov ax, word ptr source
          mov ds, ax
          mov si, 0
          mov ax, word ptr target
          mov es, ax
          mov di, 0
          mov cx, 32000
          cld
          rep movsb

          ret
          endp
;======================================================================
;void set_plane_enable(void)
;======================================================================
set_plane_enable proc
                uses ds,es,di,si

                mov dx, 3c4h
                mov al, 2
                mov ah, 0fh
                out dx, ax
                ret
                endp
;========================================================================
;void set_write_mode(char vm)
;========================================================================
set_write_mode proc
               arg vm:byte
               uses ds, es, di, si

               mov dx, 3ceh
               mov al, 5
               out dx, al
               inc dx
               in al, dx
               and al, 0fch
               or al, vm
               out dx, al

               ret
               endp

;========================================================================
;void yline_memory_move(unsigned int source_x, unsigned int page_source,
;                       unsigned int target_x, unsigned int page_target)
;========================================================================
yline_memory_move proc
                  arg source_x:word, page_source:word, target_x:word, page_target:word
                  uses ds, es, si, di

                  mov ax, page_source
                  mov ds, ax
                  mov ax, page_target
                  mov es, ax
                  mov si, source_x
                  mov di, target_x
                  mov cx, 0

         loopm21: cmp cx, 400
                  ja loopm22
                  mov bl, byte ptr ds:[si]
                  mov es:[di], bl
                  add si, 80
                  add di, 80
                  inc cx
                  jmp loopm21
         loopm22:
                  ret
                  endp
;==============================================================================
;void copy_page1_page2(int p1_x, int p1_y, unsigned page1,
;                      int p2_x, int p2_y, unsigned page1,int w, lint h)
;==============================================================================
copy_page1_page2 proc
arg p1_x:word,p1_y:word,page1:word, p2_x:word,p2_y:word,page2:word, w:word,h:word
           uses ds, es, si, di

           mov ax, 80
           mul p1_y
           add ax, p1_x
           mov bx, ax

           mov ax, 80
           mul p2_y
           add ax, p2_x
           mov dx, ax


loopm3_1:
           cmp h, 0
           je loopm3_2

           mov si, bx
           mov di, dx

           mov cx, w
           push ds
           mov ax, page1
           mov ds, ax
           mov ax, word ptr page2
           mov es, ax
           cld
           rep movsb
           pop ds

           add bx, 80
           add dx, 80
           dec h
           jmp loopm3_1

loopm3_2:
           ret
           endp


;==============================================================================
;void copy_so_ta_far(BYTE far *source, BYTE far *target, WORD count)
;==============================================================================
copy_so_ta_far proc
               arg source:dword, target:dword, count:word
               uses ds, es, si, di
               lds si, source
               les di, target
               cld
               mov cx, count
               rep movsw
               ret
               endp
;==============================================================================
;void block_copy(int x1, int y1, int x2, int y2, BYTE far *sor, BYTE far *tar)
;==============================================================================
block_copy_far proc
               arg x1:word, y1:word, x2:word, y2:word, sor:dword, tar:dword
               uses ds, es, si, di

               mov ax,x2
               sub ax,x1
               inc ax
               mov x2,ax

               mov ax, y2
               sub ax,y1
               inc ax
               mov y2,ax

               mov bx,320
               sub bx,x2

               lds si, sor
               les di, tar

               mov ax,320
               mov dx,y1
               mul dx
               add ax, x1
               cld
               mov cx,y2
loopm4_1:
               push cx
               mov cx, x2
               rep movsb
               add di, bx
               pop cx
               loop loopm4_1
               ret
               endp
;==============================================================================
;void put_image(int x, int y, int x1, int y1, BYTE far *sor, WORD vgas)
;==============================================================================
put_image proc
         arg x:word, y:word, x1:word, y1:word, sor:dword, vgas:word
         uses ds, es, di, si

         mov ax,x1
         sub ax,x
         inc ax
         mov x1,ax

         mov ax, y1
         sub ax,y
         inc ax
         mov y1,ax

         mov bx,320
         sub bx,x1
         lds si, sor
         mov es, vgas
         mov di, 320
         mov ax,y
         mul di
         add ax, x
         mov di, ax
         cld
         mov cx,y1
loopm5_1:
         push cx
         mov cx, x1
         rep movsb
         add di, bx
         pop cx
         loop loopm5_1
         ret
         endp
;==============================================================================
;void get_image(int x, int y, int x1, int y1, BYTE far *tar, WORD vgas)
;==============================================================================
get_image proc
          arg x:word, y:word, x1:word, y1:word, tar:dword, vgas:word
          uses ds,es,di,si

          mov ax,x1
          sub ax,x
          inc ax
          mov x1, ax

          mov ax,y1
          sub ax,y
          inc ax
          mov y1, ax

          mov bx,320
          sub bx,x1

          les di,tar
          mov ax,vgas
          mov ds,ax
          mov ax,y
          mov si,320
          mul si
          add ax,x
          mov si, ax
          cld
          mov cx,y1
loopm6_1:
          push cx
          mov cx,y1
          rep movsb
          add si,bx
          pop cx
          loop loopm6_1
          ret
          endp

; vga320x200 256color mode set
; c type: void vga320x200(void)


vga320x200 proc
           uses si,di,ds
           mov al,19
           mov ah,00h
           int 10h
           ret
           endp
; vga720x350 text mode set
; c type: viod vga720x350(void)
vga720x350 proc
           uses si,di,ds
           mov ax,3
           int 10h
           ret
           endp

; vga_x,vga_y print color_256 pixel
; c type: void vga_pset(int vga_x,int vga_y,char color_256)
vga_pset proc
         arg vga_x:word,vga_y:word,color_256:byte
         uses si,di,ds,es
         mov cl,color_256
         mov ax,vga_y
         mov bx,vga_x
         mov dx,320
         mul dx
         add bx,ax
         mov ax,0a000h
         mov es,ax
         mov es:[bx],cl
         ret
         endp

; vga_x,vga_y,input color_256 pixel
; c type: unsigned vga_get(int vga_x,int vga_y)
vga_get proc
        arg vga_x:word,vga_y:word
        uses si,di,ds,es
        mov ax,vga_y
        mov bx,vga_x
        mov dx,320
        mul dx
        add bx,ax
        mov ax,0a000h
        mov es,ax
        mov al,es:[bx]
        xor ah,ah
        ret
        endp

;c:type : void linex(unsigned x1,unsigned y1,unsigned x2,unsigned y1,char color_c)
linex proc
      arg x1:word,y1:word,x2:word,y2:word,color_c:byte
      uses si,di,ds,es
      mov si,x1
      mov cl,color_c
      mov ax,y1
      mov bx,x1
loop1:
      mov dx,320
      mul dx
      add bx,ax
      mov ax,0a000h
      mov es,ax
      mov es:[bx],cl
      inc x1
      mov bx,x1
      mov ax,y1
      mov di,x2
      cmp bx,di
      ja loop2
      jmp loop1
loop2:
      inc y1
      mov ax,y1
      mov di,y2
      cmp ax,di
      ja loop3
      mov x1,si
      mov bx,x1
      jmp loop1
loop3:
      ret
      endp

;c:type: void liny(unsigned x1,unsigned y1,unsigned x2,unsigned y2,char color_c);
liney proc
      arg x1:word,y1:word,x2:word,y2:word,color_c:byte
      uses si,di,ds,es
      mov si,y1
      mov cl,color_c
      mov ax,y1
      mov bx,x1
loop4:
      mov dx,320
      mul dx
      add bx,ax
      mov ax,0a000h
      mov es,ax
      mov es:[bx],cl
      inc y1
      mov ax,y1
      mov bx,x1
      mov di,y2
      cmp ax,di
      ja loop5
      jmp loop4
loop5:
      inc x1
      mov bx,x1
      mov di,x2
      cmp bx,di
      ja loop6
      mov y1,si
      mov ax,y1
      jmp loop4
loop6:
      ret
      endp
      end





; vga320x200 256color mode set
; c type: void vga320x200(void)

vga320x200 proc
           uses si,di,ds
           mov al,19
           mov ah,00h
           int 10h
           ret
           endp
; vga720x350 text mode set
; c type: viod vga720x350(void)
vga720x350 proc
           uses si,di,ds
           mov al,7
           mov ah,00h
           int 10h
           ret
           endp

; vga_x,vga_y print color_256 pixel
; c type: void vga_pset(int vga_x,int vga_y,char color_256)
vga_pset proc
         arg vga_x:word,vga_y:word,color_256:byte
         uses si,di,ds,es
         mov cl,color_256
         mov ax,vga_y
         mov bx,vga_x
         mov dx,320
         mul dx
         add bx,ax
         mov ax,0a000h
         mov es,ax
         mov es:[bx],cl
         ret
         endp

; vga_x,vga_y,input color_256 pixel
; c type: unsigned vga_get(int vga_x,int vga_y)
vga_get proc
        arg vga_x:word,vga_y:word
        uses si,di,ds,es
        mov ax,vga_y
        mov bx,vga_x
        mov dx,320
        mul dx
        add bx,ax
        mov ax,0a000h
        mov es,ax
        mov al,es:[bx]
        xor ah,ah
        ret
        endp

;c:type : void linex(unsigned x1,unsigned y1,unsigned x2,unsigned y1,char color_c)
linex proc
      arg x1:word,y1:word,x2:word,y2:word,color_c:byte
      uses si,di,ds,es
      mov si,x1
      mov cl,color_c
      mov ax,y1
      mov bx,x1
loop1:
      mov dx,320
      mul dx
      add bx,ax
      mov ax,0a000h
      mov es,ax
      mov es:[bx],cl
      inc x1
      mov bx,x1
      mov ax,y1
      mov di,x2
      cmp bx,di
      ja loop2
      jmp loop1
loop2:
      inc y1
      mov ax,y1
      mov di,y2
      cmp ax,di
      ja loop3
      mov x1,si
      mov bx,x1
      jmp loop1
loop3:
      ret
      endp

;c:type: void liny(unsigned x1,unsigned y1,unsigned x2,unsigned y2,char color_c);
liney proc
      arg x1:word,y1:word,x2:word,y2:word,color_c:byte
      uses si,di,ds,es
      mov si,y1
      mov cl,color_c
      mov ax,y1
      mov bx,x1
loop4:
      mov dx,320
      mul dx
      add bx,ax
      mov ax,0a000h
      mov es,ax
      mov es:[bx],cl

      inc y1
      mov ax,y1
      mov bx,x1
      mov di,y2
      cmp ax,di
      ja loop5
      jmp loop4
loop5:
      inc x1
      mov bx,x1
      mov di,x2
      cmp bx,di
      ja loop6
      mov y1,si
      mov ax,y1
      jmp loop4
loop6:
      ret
      endp
      end




