
/* ===================================== */
/* vga 320x400 graphics lib header       */
/* ====== moon sung chul =============== */
#include <stdio.h>
#include <dos.h>
#include <alloc.h>
#include <stdlib.h>
#include <time.h>

#define SC_INDEX 0x3c4
#define GC_INDEX 0x3ce
#define PAGE0 0xa000
#define PAGE1 0xa7d0

typedef unsigned int WORD;
typedef unsigned char BYTE;

char PAGE_MODE = 0;
BYTE PALETTE[768];
struct pcx_header {
	char maker;
	char ver;
	char code;
	char bit;
	int x1, y1, x2, y2,mx, my;
	char palette[48], mode,plane;
	int nubi, info, hres, vres;
	char extra[54];
} header;

const char hantable[3][32]={
{ 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,
  15,16,17,18,19,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
{ 0, 0, 0, 1, 2, 3, 4, 5, 0, 0, 6, 7, 8, 9,10,11,
  0, 0,12,13,14,15,16,17, 0, 0,18,19,20,21, 0, 0 },
{ 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,
 15,16, 0,17,18,19,20,21,22,23,24,25,26,27, 0, 0 } };

static char cho_tb_yes[]={
  5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 7, 7, 7, 6, 6, 7, 7, 7, 6, 6, 7, 5
  };

static char cho_tb_no[]={
  0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 3, 3, 3, 1, 2, 4, 4, 4, 2, 1, 3, 0
  };

static char jong_tb[]={
  0, 0, 2, 0, 2, 1, 2, 1, 2, 3, 0, 2, 1, 3, 3, 1, 2, 1, 3, 3, 1, 1
  };

char first[8][20][32];    /* ei  */
char mid[4][22][32];     /* ei  */
char endtable[4][28][32];     /* ei  */

char english[256][16];   /* w */
char han_mem[32];        /* hangul  memory  */
char eng_mem[16];        /* english memory */

int _x=0,_y=0,b,font=0;


extern void set320by400mode(void);
extern void vga720x350(void);
extern void put_dot(int x, int y, BYTE c, WORD pa);
extern void m_line(int x1, int y1, int x2, int y2, BYTE color, WORD pa);
extern void clear_screen(BYTE c, WORD pa2);
extern void palete_set(char far *pal);
extern void put16_16(int x, int y, char far *buf, int color, WORD vesg);
extern void put8_16(int x, int y, char far *buf, int color, WORD vesg1);
extern void copy_page(WORD source, WORD target);
extern void set_plane_enable(void);
extern void set_write_mode(char vm);
extern void yline_memory_move(WORD source_x, WORD page_source,WORD target_x, WORD page_target);
extern void copy_page1_page2(int p1_x, int p1_y, WORD page1,int p2_x, int p2_y, WORD page2,int w, int h);
extern void put_image(int x, int y, int x1, int y1, BYTE far *sor, WORD vags);
extern void get_image(int x, int y, int x1, int y1, BYTE far *tar, WORD vags);
extern void copy_so_ta_far(BYTE far *source, BYTE far *target, WORD count);
extern void block_copy_far(int x1, int y1, int x2, int y2, BYTE far *sor, BYTE far *tar);

void linem(int x1, int y1, int x2, int y2, BYTE color, unsigned pa1);
void view_page(char mode);
void view_page_auto_charge(void);
char far *load_cel(char *name, WORD *xsize, WORD *ysize);
char far *read_pcx(char *name);
WORD memory_page_selet(void);
void put_image_clip(int x, int y, char far *dat, int _xsize, int _ysize, WORD vseg);
void put_image_clip2(int x, int y, char far *dat, int _xsize, int _ysize, WORD vseg);
void put_sprite_clip(int x, int y, char far *dat, int _xsize, int _ysize,WORD vseg);
void put_sprite_clip2(int x, int y, char far *dat, int _xsize, int _ysize,WORD vseg);
void copy_so_ta(int p1_x, int p1_y, WORD source, int p2_x, int p2_y, WORD target, int w, int h);

/*----------------- hangul routin -----------------*/
void read_font(void);
void convert1(BYTE *dest, int chars);
void convert2(BYTE *dest, int chars);
void convert3(BYTE *dest, int chars);
void or_image(char *src, char *dest,int lens);
void htextxy(char cho, char jung, char jong, int f, char color, WORD vesg);
void text(char text, int f, char color,WORD vesg);
void graphputs(int x, int y, int f, char color, char *st, WORD vesg);
/*----------------- scroll routin -----------------*/
void V_Sync(void);
void start_addr(WORD i);
void pelpan(WORD x);
void scroll_up(WORD gan);
void scroll_down(WORD gan);
void page_source_target_move(WORD source, WORD target);
void y_line_copy(WORD so_x, WORD pa_so, WORD ta_x, WORD pa_ta);
void scroll_left(void);
void scroll_right(void);
/*---------------------------------------------------*/
void palette_setm(BYTE far *p);
void fade_run(int p);
void fade_in(int delay);
void fade_out(int delay);
void ray_run(WORD delayy);
