#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <conio.h>
#include <malloc.h>
#include <time.h>
#include <string.h>
#include <ctype.h>

#include "han.h"
#include "keydef.h"

#define RANDOM(u) ( rand() % ( ((u) )  ) )
#define DLGRAY 24

void logo(void);
void sel_print(void);
void out_demo(void);
void winout_demo(void);
void attrib_demo(void);
void zput_demo(void);
void inp_demo(void);
void graphic_demo(void);
void win_gr_demo(void);
void page_demo(void);
void pal_demo(void);
void vdesk_demo(void);
void win_demo(void);
void scroll_demo(void);

void main(void)
{
   short ch;

   printf("Font loading......\n");

   enable_extfont();

   if (hsetfont("HMJ.FNT", "EMJ.FNT", "IHANJA.FNT", "GRAPHIC.FNT") != 0 ||
       hsetfont24("HMJ24.FNT", "EG24.FNT", "IHANJA24.FNT", "GRAPH24.FNT") != 0)
   {
      printf("Font loading failed!!!\n");
      exit(-1);
   }

   if (InitHan(VESA640x480) != 0)
   {
      printf("VESA init failed!!!\n");
      exit(-1);
   }

   hsetinputmode(INP_HAN);      // ei b a 

   hsettextcolor(ctc(WHITE, 151));
   hsetcolor(ctc(WHITE, LGRAY));
   _clrscr(GraphbgColor);

   hinitboxputs(BOX_DOUBLE, CYAN, ctc(WHITE, DGRAY), 2);

   logo();

   while (1)
   {
      sel_print();
      ch = hgetkey(0);

      _clrscr(GraphbgColor);

      switch (ch)
      {
         case '0' : case '1' : case '2' : case '3' : case '4' :
         case '5' : case '6' : case '7' : case '8' : case '9' :
            CloseGraph();
            if (InitGraph(atoi((char*)&ch)) != 0)
            {
               InitGraph(1);
               hmsgbox("a ge aa!", YELLOW, BLUE);
            }
            break;
         case 'A': case 'a' :
            out_demo();
            hsetoutmode(OVERLAP);
            out_demo();
            hsetoutmode(OVERWRITE);
            break;
         case 'B': case 'b' :
            winout_demo();
            hsetoutmode(OVERLAP);
            winout_demo();
            hsetoutmode(OVERWRITE);
            break;
         case 'C': case 'c' :
            attrib_demo();
            hsetoutmode(OVERLAP);
            attrib_demo();
            hsetoutmode(OVERWRITE);
            break;
         case 'D': case 'd' :
            zput_demo();
            hsetoutmode(OVERLAP);
            zput_demo();
            hsetoutmode(OVERWRITE);
            break;
         case 'E': case 'e' :
            inp_demo();
            break;
         case 'F': case 'f' :
            graphic_demo();
            break;
         case 'G': case 'g' :
            win_gr_demo();
            break;
         case 'H': case 'h' :
            page_demo();
            break;
         case 'I': case 'i' :
            vdesk_demo();
            break;
         case 'j': case 'J':
            pal_demo();
            break;
         case 'k': case 'K':
            win_demo();
            break;
         case 'l': case 'L':
            scroll_demo();
            break;
         case 'x': case 'X': case ESC :
            CloseHan();
            exit(0);
      }
      _clrscr(GraphbgColor);
   }
}

void logo(void)
{
   HWINDOW w;

   hinitwin("", 160, 120, 480, 360, 17,
            ctc(BLUE, LGRAY), ctc(WHITE, DGRAY), BLUE, 4, 0, 0, &w);
   hopenwin(&w);

   hsettextcolor(ctc(YELLOW, BLUE));
   hwzcputsxy24(60,  16, "[aɡ]", ctc(LGREEN, BLUE), HORIZ | VERT);
   hwzcputsxy24(42,  72, "ei", ctc(YELLOW, BLUE), HORIZ);
   hwcputsxy24(150,  72, "aa១", ctc(YELLOW, BLUE));
   hwzcputsxy24(90,  104, "A ", ctc(LMAGENTA, BLUE), HORIZ);
   hwcprintfxy(64,  144, ctc(YELLOW, BLUE), " A : %dK", getvideomem());
   hwcputsxy(90,  166, "Aba : w", ctc(WHITE, BLUE));
   hwcputsxy(10,  184, "eb : aI, a ID 0040429", ctc(WHITE, BLUE));

   getch();
   hclosewin(&w);
}

void sel_print(void)
{
   int l, r;

   l = hmaxx() / 2 - 160;
   r = hmaxx() / 2 + 10;
   hsettextcolor(ctc(WHITE, CYAN));
   hboxputs24(hmaxx()/2-200, 10, "aɡ 32a ei aa១ A");
   hboxputs(l,  75, "0.  640 x  400");
   hboxputs(l, 100, "1.  640 x  480");
   hboxputs(l, 125, "2.  800 x  600");
   hboxputs(l, 150, "3. 1024 x  768");
   hboxputs(l, 175, "4. 1280 x 1024");
   hboxputs(l, 200, "5.  320 x  200");
   hboxputs(l, 225, "6.  320 x  240");
   hboxputs(l, 250, "7.  400 x  300");
   hboxputs(l, 275, "8.  512 x  384");
   hboxputs(l, 300, "9.  640 x  350");

   hboxputs(r,  50, "A. ai        b");
   hboxputs(r,  75, "B. 啡 ai b");
   hboxputs(r, 100, "C. ai    b");
   hboxputs(r, 125, "D. ai    b");
   hboxputs(r, 150, "E. ai        b");
   hboxputs(r, 175, "F. aϢ        A");
   hboxputs(r, 200, "G. 啡 aϢ A");
   hboxputs(r, 225, "H. A        A");
   hboxputs(r, 250, "I. aw   e   A");
   hboxputs(r, 275, "J. iAa        A");
   hboxputs(r, 300, "K. 啡        A");
   hboxputs(r, 325, "L. aa        A");
   hboxputs(r, 350, "Xa ESC. {      ");
}

printstr(char *str, int fontsize)
{
   int i, step, limit;
   static int k = 0;

   step = fontsize == H24 ? 24 : 16;
   limit = hmaxy() / step;

   for (i = 0; i <= limit; i++)
   {
      if (fontsize == H24)
         hcputsxy24(0, i * step, str, ctc(k, k + 5));
      else
         hcputsxy(0, i * step, str, ctc(k, k + 5));
      k++;
   }
}

void out_demo(void)
{
   char *str = "ai b A. z  This is string print demo. YZ[\]ٷٸٹٺٻټٽپٿ\0";

   hmsgbox("16x16 a b A", WHITE, CYAN);
   _clrscr(GraphbgColor);
   printstr(str, 16);
   hgetkey(FALSE);

   hmsgbox("24x24 b A", WHITE, CYAN);
   _clrscr(GraphbgColor);
   printstr(str, 24);
   hgetkey(FALSE);
}

win_printstr(char *str, int fontsize)
{
   int i, step, limit;
   static int k = 0;

   step = fontsize == H24 ? 24 : 16;
   limit = hwmaxy() / step;

   for (i = 0; i <= limit; i++)
   {
      if (fontsize == H24)
         hwcputsxy24(0, i * step, str, ctc(k, k + 5));
      else
         hwcputsxy(0, i * step, str, ctc(k, k + 5));
      k++;
   }
}

void winout_demo(void)
{
   int i, j;
   char *str = "ai b A. z  This is string print demo. YZ[\]ٷٸٹٺٻټٽپٿ\0";
   HWINDOW w;

   // w w g 啡e a
   hinitwin("啡 b q A", 0, 0, hmaxx(), hmaxy(),
            19, ctc(BLUE, LGRAY), ctc(WHITE, DLGRAY), i % 256, 3, 0, 0, &w);
   hopenwin(&w);

   _wclrscr(GraphbgColor);
   hmsgbox("16x16 a b A", WHITE, CYAN);
   win_printstr(str, 16);
   hgetkey(FALSE);

   hmsgbox("24x24 b A", WHITE, CYAN);
   _wclrscr(GraphbgColor);
   win_printstr(str, 24);
   hgetkey(FALSE);
   hclosewin(&w);
}

void attrib_demo(void)
{
   _clrscr(GraphbgColor);

   hsettextcolor(ctc(LBLUE, YELLOW));

   hsettextcolor(ctc(BLUE, YELLOW));
   hprintfxy(0, 0 * H16, "a  b : ɷ ");
   hsettextattr(SHADOW);
   hprintfxy(0, 1 * H16, "a  b : aa");
   hsettextattr(UNDER);
   hprintfxy(0, 2 * H16, "a  b : ");
   hsettextattr(OUTLINE);
   hprintfxy(0, 3 * H16, "a  b : A¬");
   hsettextattr(REVERSE);
   hprintfxy(0, 4 * H16, "a  b : bw");
   hsettextattr(THREED);
   hprintfxy(0, 5 * H16, "a  b : A");
   hsettextattr(BOLD);
   hprintfxy(0, 6 * H16, "a  b : aA");

   hsettextattr(NORMAL);
   hprintfxy24(0, 5 * H24, "a  b : ɷ ");
   hsettextattr(SHADOW | UNDER);
   hprintfxy24(0, 6 * H24, "a  b : qw + ");
   hsettextattr(UNDER | BOLD);
   hprintfxy24(0, 7 * H24, "a  b :  + aA");
   hsettextattr(OUTLINE | UNDER | REVERSE);
   hprintfxy24(0, 8 * H24, "a  b : A¬ +  + bw");
   hsettextattr(REVERSE | THREED);
   hprintfxy24(0, 9 * H24, "a  b : bw + A");
   hsettextattr(THREED | OUTLINE);
   hprintfxy24(0, 10 * H24, "a  b : A + A¬");
   hsettextattr(BOLD | SHADOW);
   hprintfxy24(0, 11 * H24, "a  b : aA + qw");

   hsettextattr(REVERSE);
   hzputsxy(0, 18 * H16, "a  b : bw", HORIZ);
   hsettextattr(OUTLINE);
   hzputsxy(0, 19 * H16, "a  b : A¬", VERT);
   hsettextattr(THREED);
   hzputsxy(0, 21 * H16, "a  b : A", VERT | HORIZ);

   hsettextattr(BOLD);
   hzputsxy24(0, 16 * H24, "a  b : aA", HORIZ);
   hsettextattr(UNDER);
   hzputsxy24(0, 17 * H24, "a  b : ", VERT);
   hsettextattr(SHADOW);
   hzputsxy24(0, 19 * H24, "a  b : qw", VERT | HORIZ);

   hsettextattr(NORMAL);

   hgetkey(FALSE);
   hrestoretextcolor();
}

void zput_demo(void)
{
   hsettextcolor(ctc(YELLOW, BLUE));
   _clrscr(GraphbgColor);

   hcputsxy(0, 16 * 1, "16x16 ͥa ", ctc(LGREEN, BLUE));
   hzputsxy(0, 16 * 3, "a  Ԩԯ ...HORIZ", HORIZ);
   hzputsxy(0, 16 * 4, "A  Ԩ ...VERT", VERT);
   hzputsxy(0, 16 * 6, "a,A  Ԩ ...HORIZ|VERT", VERT | HORIZ);

   hcputsxy24(0, 8 * 24, "24x24 ͥa ", ctc(LGREEN, BLUE));
   hzputsxy24(0, 10 * 24, "a  Ԩԯ ...HORIZ", HORIZ);
   hzputsxy24(0, 11 * 24, "A  Ԩ ...VERT", VERT);
   hzputsxy24(0, 13 * 24, "a,A  Ԩ ...HORIZ|VERT", VERT | HORIZ);
   hgetkey(FALSE);
   hrestoretextcolor();
}

void InputString(void)
{
   char s[31] = " , ei b, ԏ}";

   _clrscr(LGRAY);
   hprintfxy(10, 0, "F9 : ea b, F6 : aϢ a b, ALT-F6 : aϢ a Ȃ");
   hprintfxy(40, 40, "ai b Aaa");
   hgetstr(5 * 8, 5 * 16, s, 31, TRUE);

   hprintfxy(20, 150, "bE ai : ");

   for (int i = 0; i < 10; i++)
      hcprintfxy(200, 150 + i * 16, ctc(i % 256, BLUE), s);

   hgetkey(FALSE);
}

void inp_demo(void)
{
   hsettextcolor(ctc(LBLUE, YELLOW));
   hmsgbox("16x16 ai b A", WHITE, CYAN);
   InputString();               /* 16x16 ai b Aaa    */

   hmsgbox("24x24 ai b A", WHITE, CYAN);
   enable_input24();

   InputString();               /* 24x24 ai b Aaa    */
   disable_input24();
   hrestoretextcolor();
}

void graphic_demo(void)
{
   int i = 0, j;
   srand((int) time(NULL) | 1);

   _clrscr(0);
   hmsgbox(" ", WHITE, CYAN);
   while (!kbhit())
      putpixel(RANDOM(hmaxx()+1), RANDOM(hmaxy()+1), i = ++i % 255);
   getch();

   _clrscr(0);
   hmsgbox(" u", WHITE, CYAN);
   while (!kbhit())
      line(RANDOM(hmaxx()+1), RANDOM(hmaxy()+1),
           RANDOM(hmaxx()+1), RANDOM(hmaxy()+1), i = ++i % 255);
   getch();

   _clrscr(0);
   hmsgbox("abw a", WHITE, CYAN);
   while (!kbhit())
      rect(RANDOM(hmaxx()), RANDOM(hmaxy()), RANDOM(hmaxx()+1), RANDOM(hmaxy()+1), i = ++i % 255);
   getch();

   _clrscr(0);
   hmsgbox("éЁ abw a", WHITE, CYAN);
   while (!kbhit())
      bar(RANDOM(hmaxx()), RANDOM(hmaxy()), RANDOM(hmaxx()+1), RANDOM(hmaxy()+1), i = ++i % 255);
   getch();

   _clrscr(0);
   hmsgbox("a a", WHITE, CYAN);
   while (!kbhit())
      ellipse(RANDOM(hmaxx()+1) / 2 + hmaxx() / 4,
              RANDOM(hmaxy()+1) / 2 + hmaxy() / 4, RANDOM(hmaxx()) / 4 + 1,
	      RANDOM(hmaxy()) / 4 + 1, i = ++i % 255);
   getch();

   _clrscr(0);
   hmsgbox("éЁ a a", WHITE, CYAN);
   while (!kbhit())
      ellipsef(RANDOM(hmaxx()+1) / 2 + (hmaxx()+1) / 4,
               RANDOM(hmaxy()+1) / 2 + (hmaxy()+1) / 4, RANDOM(hmaxx()) / 4 + 1,
	       RANDOM(hmaxy()) / 4 + 1, i = ++i % 255);
   getch();

   _clrscr(0);
   for (j = 0, i = 0; i < hmaxx() / 2; i += 4)
      ellipse((hmaxx()+1) / 2, (hmaxy()+1) / 2, i, hmaxx() / 2 - i, j++);
   getch();

   _clrscr(0);
   for (j = 0, i = 0; i < hmaxx() / 2; i += 4)
      ellipsef((hmaxx()+1) / 2, (hmaxy()+1) / 2, i, hmaxx() / 2 - i, j++);
   getch();
   _clrscr(0);
}

void win_gr_demo(void)
{
   int i = 0, j;
   srand((int) time(NULL) | 1);
   HWINDOW w;

   hinitwin("啡 aϢ q A", 0, 0, hmaxx(), hmaxy(),
            19, ctc(BLUE, LGRAY), ctc(WHITE, DLGRAY), i % 256, 3, 0, 0, &w);
   hopenwin(&w);

   _wclrscr(LGRAY);
   hmsgbox(" ", WHITE, CYAN);
   while (!kbhit())
      wputpixel(RANDOM(hwmaxx()+1), RANDOM(hwmaxy()+1), i = ++i % 255);
   getch();

   _wclrscr(LGRAY);
   hmsgbox(" u", WHITE, CYAN);
   while (!kbhit())
      wline(RANDOM(hwmaxx()+1), RANDOM(hwmaxy()+1),
            RANDOM(hwmaxx()+1), RANDOM(hwmaxy()+1), i = ++i % 255);
   getch();

   _wclrscr(LGRAY);
   hmsgbox("abw a", WHITE, CYAN);
   while (!kbhit())
      wrect(RANDOM(hwmaxx()+1), RANDOM(hwmaxy()+1), RANDOM(hwmaxx()+1), RANDOM(hwmaxy()+1), i = ++i % 255);
   getch();

   _wclrscr(LGRAY);
   hmsgbox("éЁ abw a", WHITE, CYAN);
   int x, y;
   while (!kbhit())
   {
      x = RANDOM(hwmaxx()+1);
      y = RANDOM(hwmaxy()+1);
      wbar(x, y, RANDOM(hwmaxx()+1), RANDOM(hwmaxy()+1), i = ++i % 255);
   }
   getch();

   _wclrscr(LGRAY);
   hmsgbox("a a", WHITE, CYAN);
   while (!kbhit())
      wellipse(RANDOM(hwmaxx()+1) / 2 + (hwmaxx()+1) / 4,
               RANDOM(hwmaxy()+1) / 2 + (hwmaxy()+1) / 4, RANDOM(hwmaxx()) / 4 + 1,
               RANDOM(hwmaxy()) / 4 + 1, i = ++i % 255);
   getch();


   _wclrscr(LGRAY);
   hmsgbox("éЁ a a", WHITE, CYAN);
   while (!kbhit())
      wellipsef(RANDOM(hwmaxx()+1) / 2 + (hwmaxx()+1) / 4,
              RANDOM(hwmaxy()+1) / 2 + (hwmaxy()+1) / 4, RANDOM(hwmaxx()) / 4 + 1,
                RANDOM(hwmaxy()) / 4 + 1, i = ++i % 255);
   getch();

   _wclrscr(LGRAY);
   for (j = 0, i = 0; i < hwmaxx() / 2; i += 4)
      wellipse((hwmaxx()+1) / 2, (hwmaxy()+1) / 2, i, hwmaxx() / 2 - i, j++);
   getch();

   _wclrscr(LGRAY);
   for (j = 0, i = 0; i < hwmaxx() / 2; i += 4)
      wellipsef((hwmaxx()+1) / 2, (hwmaxy()+1) / 2, i, hwmaxx() / 2 - i, j++);
   getch();

   hclosewin(&w);
}

void page_demo(void)
{
   int page, i=0;
   int mx, my, x=0, y=0;
   int c1 = YELLOW, c2 = LGREEN, c3 = LMAGENTA, c4 = LBLUE;

   page = GetPageNum();
   if (page < 2)
   {
      hmsgbox("Aa aa cA sa.", WHITE, CYAN);
      return;
   }

   _clrscr(0);

   mx = hmaxx();
   my = hmaxy();

   hsettextcolor(ctc(WHITE, BLACK));
   while (!kbhit())
   {
      SetActivePage(0, i);
      _clrscr(BLACK);

      hprintfxy(10, 10, "e A %2d\/%2d", i+1, page);
      line(x, 0, mx-x, my, c1);
      line(mx-x, 0, x, my, c2);
      vline(x, 0, my, c1);
      vline(mx-x, 0, my, c2);
      line(0, y, mx, my-y, c3);
      line(0, my-y, mx, y, c4);
      hline(0, y, mx, c3);
      hline(0, my-y, mx, c4);
      rect(0, 0, mx, my, WHITE);

      WaitForVRetrace();
      SetVisualPage(0, i);

      x+=2;
      if (x >= mx)
      {
         x=0;
         SWAP(c1, c2);
      }

      y+=2;
      if (y >= my)
      {
         y = 0;
         SWAP(c3, c4);
      }
      i++;
      if (i == page)
         i = 0;
   }
   SetActivePage(0, 0);
   SetVisualPage(0, 0);
   hrestoretextcolor();
}

void scroll(int xstep, int ystep)
{
   int x, y, flag, ylimit;
   short ch;

   ylimit = (int) ((getvideomem() * 1024L) / sc_length);
   x = 0;
   y = 0;
   flag = 1;
   while (flag)
   {
      ch = hgetkey(!(0 & 1));

      switch (ch)
      {
         case LEFT:
            if ((x - xstep) >= 0)
               x -= xstep;
            if (x < 0)
               x = 0;
            SetDisplayStart(x, y);
            break;
         case RIGHT:
            if ((x + xstep) < sc_length - hmaxx())
               x += xstep;
            SetDisplayStart(x, y);
            break;
         case UP:
            if ((y - ystep) >= 0)
               y -= ystep;
            if (y < 0)
               y = 0;
            if (y > 0 && (y - ystep) < 0)
               y = 0;
            SetDisplayStart(x, y);
            break;
         case DOWN:
            if ((y + ystep) < ylimit - (hmaxy()+1))
               y += ystep;
            if ((y < (ylimit - (hmaxy()+1))) && ((y + ystep) > (ylimit - (hmaxy()+1))))
               y = ylimit - (hmaxy()+1);
            SetDisplayStart(x, y);
            break;
         case ESCAPE:
         case ESC:
         case ENTER:
            flag = 0;
            break;
      }
   }
   SetDisplayStart(0, 0);
}

void vdesk_demo(void)
{
   int i, j;

   SetScanlineLength(1280);
   VirtualDeskOn();
   _clrscr(151);

   hsettextcolor(ctc(YELLOW, LGRAY));

   hputsxy24(hmaxx() / 2 - 162, hpmaxy() / 2, "UP   :   , DOWN  : a  ");
   hputsxy24(hmaxx() / 2 - 162, hpmaxy() / 2 - 40, "LEFT : E, RIGHT : e");
   hprintfxy24(hmaxx() / 2 - 200, hpmaxy() / 2 + 40, "a e͢ : %d, a e : %d", hpmaxx()+1, hpmaxy()+1);
   hprintfxy24(hmaxx() / 2 - 200, hpmaxy() / 2 + 80, "aw e͢ : %d, aw e : %d", hmaxx()+1, hmaxy()+1);

   char *buff = "wa e iaaabcde.....";

   for (i = 0; i <= hmaxy() / 100; i++)
      hline(0, 100 * i, hmaxx(), YELLOW);

   for (i = 0; i < hmaxx() / 100; i++)
      vline(100 * i, 0, hmaxy(), CYAN);

   for (i = -255, j = 0; i <= 0; i += 2, j++)
      hputsxy24(i, j * 24, buff);

   for (i = hmaxx() - 124, j = 0; i >= hmaxx() - 2 - 480; i -= 3, j++)
      hputsxy24(i, j * 24, buff);

   VirtualDeskOff();
   scroll(40, 40);

   VirtualDeskOn();
   _clrscr(151);

   hputsxy24(hmaxx() / 2 - 162, hpmaxy() / 2, "UP   :   , DOWN  : a  ");
   hputsxy24(hmaxx() / 2 - 162, hpmaxy() / 2 - 40, "LEFT : E, RIGHT : e");
   hprintfxy24(hmaxx() / 2 - 200, hpmaxy() / 2 + 40, "a e͢ : %d, a e : %d", hpmaxx()+1, hpmaxy()+1);
   hprintfxy24(MaxX / 2 - 200, hpmaxy() / 2 + 80, "aw e͢ : %d, aw e : %d", hmaxx()+1, hmaxy()+1);

   for (i = 0; i <= hmaxy() / 100; i++)
      hline(0, 100 * i, hmaxx(), YELLOW);

   for (i = 0; i < hmaxx() / 100; i++)
      vline(100 * i, 0, hmaxy(), CYAN);

   for (i = -255, j = 0; i <= 0; i += 2, j++)
      hputsxy(i, j * 16, buff);

   for (i = hmaxx() - 25, j = 0; i >= hmaxx() - 2 - 288; i -= 2, j++)
      hputsxy(i, j * 16, buff);

   VirtualDeskOff();
   scroll(40, 40);

   SetScanlineLength(hpmaxx()+1);
   hrestoretextcolor();
   _clrscr(GraphbgColor);
}

void pal_demo(void)
{
   char pallete[256][3], temp_pal[256][3];
   char temp[3];
   int c, c2 = 1;

   GetPal((unsigned char *) &(temp_pal[0][0]));
   SetPalBlack();

   int i = hmaxy();
   for (c = 0; c <= hmaxy() / 2; c++)
   {
      hline(0, c, hmaxx(), c % 256);
      hline(0, i, hmaxx(), c % 256);
      i--;
   }

   c = hmaxy() / 2 / 2 - 1;
   for (; c > 0; c--)
   {
      circlef(hmaxx() / 2 - hmaxx() / 2 / 2, hmaxy() / 2 - hmaxy() / 2 / 2, c, c + 64);
      circlef(hmaxx() / 2 + hmaxx() / 2 / 2, hmaxy() / 2 - hmaxy() / 2 / 2, c, c2++);
      circlef(hmaxx() / 2 - hmaxx() / 2 / 2, hmaxy() / 2 + hmaxy() / 2 / 2, c, c2 + 64);
      circlef(hmaxx() / 2 + hmaxx() / 2 / 2, hmaxy() / 2 + hmaxy() / 2 / 2, c, c);
   }

   for (c = 0; c < 64; c++)
   {
      pallete[c][0] = c;
      pallete[c][1] = 0;
      pallete[c][2] = 0;
   }
   for (c = 64; c < 128; c++)
   {
      pallete[c][0] = 127 - c;
      pallete[c][1] = c - 64;
      pallete[c][2] = 0;
   }
   for (c = 128; c < 192; c++)
   {
      pallete[c][0] = 0;
      pallete[c][1] = 191 - c;
      pallete[c][2] = c - 128;
   }
   for (c = 192; c < 256; c++)
   {
      pallete[c][0] = 0;
      pallete[c][1] = 0;
      pallete[c][2] = 255 - c;
   }

   while (!kbhit())
   {
      temp[0] = pallete[255][0];
      temp[1] = pallete[255][1];
      temp[2] = pallete[255][2];
      for (c = 255; c > 0; c--)
      {
         pallete[c][0] = pallete[c - 1][0];
         pallete[c][1] = pallete[c - 1][1];
         pallete[c][2] = pallete[c - 1][2];
      }
      pallete[0][0] = temp[0];
      pallete[0][1] = temp[1];
      pallete[0][2] = temp[2];
      SetPal((unsigned char *) &(pallete[0][0]));
   }
   _clrscr(0);

   SetPal((unsigned char *) &(temp_pal[0][0]));
   getch();
}

void win_demo(void)
{
   int i, tmp, x1, y1, x2, y2;
   char buf[20];
   HWINDOW w[20];

   hmsgbox("啡i sa!", WHITE, CYAN);

   for (i = 0; i < 20; i++)
   {
      x1 = RANDOM(hmaxx());
      x2 = RANDOM(hmaxx());
      y1 = RANDOM(hmaxy());
      y2 = RANDOM(hmaxy());
      x1 = (x1 > hmaxx()) ? hmaxx() : x1;
      x2 = (x2 > hmaxx()) ? hmaxx() : x2;
      y1 = (y1 > hmaxy()) ? hmaxy() : y1;
      y2 = (y2 > hmaxy()) ? hmaxy() : y2;

      if (x1 > x2)
         SWAP(x1, x2);

      if (y1 > y2)
         SWAP(y1, y2);

      sprintf(buf, "w %2d", i);
      hinitwin(buf, x1, y1, x2, y2, 19, ctc(i % 256, LGRAY), ctc(WHITE, DLGRAY), i % 256, 3, 0, 1, &(w[i]));
      tmp = hopenwin(&(w[i]));

      if (tmp == -1)
      {
         hmsgbox("Aa sa.", WHITE, CYAN);
         i--;
         break;
      }
      if (tmp == -2)
         --i;

      delay(50);
   }

   hmsgbox("啡i hsa!", WHITE, CYAN);

   for (; i > 0; i--)
   {
      hclosewin(&(w[i-1]));
      delay(50);
   }
}

void scroll_demo(void)
{
   char *str = "ai b A. z  This is string print demo. YZ[\]ٷٸٹٺٻټٽپٿ\0";

   hmsgbox("e aa", WHITE, CYAN);
   printstr(str, 24);
   hscroll(0, 0, hmaxx()+1, hmaxy()+1, 30, UP);
   hscroll(0, 0, hmaxx()+1, hmaxy()+1, 30, DOWN);
   hscroll(0, 0, hmaxx()+1, hmaxy()+1, 30, LEFT);
   hscroll(0, 0, hmaxx()+1, hmaxy()+1, 30, RIGHT);

   HWINDOW w;
   hmsgbox("啡 aa", WHITE, CYAN);
   hinitwin("啡 aa q A", 0, 0, hmaxx(), hmaxy(),
            19, ctc(BLUE, LGRAY), ctc(WHITE, DLGRAY), LGRAY, 3, 0, 0, &w);
   hopenwin(&w);

   win_printstr(str,24);
   hwscroll(0, 0, hwmaxx()+1, hwmaxy()+1, 30, UP);
   hwscroll(0, 0, hwmaxx()+1, hwmaxy()+1, 30, DOWN);
   hwscroll(0, 0, hwmaxx()+1, hwmaxy()+1, 30, LEFT);
   hwscroll(0, 0, hwmaxx()+1, hwmaxy()+1, 30, RIGHT);
   getch();
   hclosewin(&w);
}
