#ifndef __HAN__
#define __HAN__

//----------------------  ew  ---------------------------------//

typedef unsigned char  BYTE;
typedef BYTE           BOOL;
typedef unsigned short WORD;
typedef unsigned int   DWORD;


//-----------------------------------------------------------------------//
//                           w 
//-----------------------------------------------------------------------//

#define TRUE  1
#define FALSE 0

#define NULL   0

#define MAX(a,b)            ( ((a) > (b)) ? (a) : (b) )
#define MIN(a,b)            ( ((a) > (b)) ? (b) : (a) )

#define SGN(a)              ( (a < 0) ? -1 : 1 )
#define ABS(a)              ( ((a) < 0) ? -(a) : (a) )

#define SWAP(a,b)           { a ^= b; b ^= a; a ^= b; }

#ifdef DJGPP
   #define PACKED  __attribute__ ((packed))
#endif

//------------------ e a ------------------------------------//
#define VESA640x400     0
#define VESA640x480     1
#define VESA800x600     2
#define VESA1024x768    3
#define VESA1280x1024   4
#define VESA320x200     5      // mode 13Ha a Aa a
#define VESA320x240     6
#define VESA400x300     7
#define VESA512x384     8
#define VESA640x350     9


//------------------- ͥa ŝe w ------------------------------//
#define H16            16        // ei ͥa 췡
#define H24            24
#define E16             8        // w ͥa 췡
#define E24            12        // ei ͥa e I aae 12x24a xe
                                 // byte eᝡ wae
                                 // 2byte x 24 = 16x24a A .
#define HORIZ           1        // a 
#define VERT            2        // A 


//-------------------- ai b  ---------------------------//
#define NORMAL       0x00        // ɷ
#define REVERSE      0x01        // bw
#define SHADOW       0x02        // aa
#define BOLD         0x04        // aA
#define OUTLINE      0x08        // A¬
#define UNDER        0x10        // 
#define THREED       0x20        //


//------------------- ai b  a ---------------------------//
#define OVERWRITE       0       //  a
#define OVERLAP         1       // sa a


//------------------------ ba  ------------------------------//
#define BOX_NORMAL      0
#define BOX_SHADE       1
#define BOX_DOUBLE      2


//-------------------- b wȁ ----------------------------------//
#define INP_ENG     0
#define INP_HAN     1


//---------------------- s q ------------------------------//
#define ctc(f,b)            ( (b)<<8|((f)&0xff) )
#define ShiftReverse(color) ( ((color) >> 8) | ((color) << 8) )


//---------------------- aϢ a  a --------------------//
#ifdef __WATCOMC__
   #define isgraphic(c1,c2)  (((c1)==0xd4 && (c2)>=0x80) || ((c1)>=0xd9 && (c1)<=0xde && (c2) >=0x31))
#endif


//---------------------------- A -------------------------------//
#define VBE_NOT_INSTALLED       -1
#define VBE20_NOT_INSTALLED     -2
#define VBE_MODE_SET_FAILED     -3
#define VBE_MODE_NOT_AVAILABLE  -4
#define PHYSICAL_MAP_FAILED     -5


//--------------------- w ͥa q  -----------------------//
#define H_MYUNG  han_MYUNG       // wA
#define H_GOTHIC han_GOTHIC      // A
#define H_PILGI  han_PILGI       // ϩA
#define H_SAM    han_SAM         // A
#define H_IYAGI  han_IYAGI       // A
#define H_GUNG   han_GUNG        // A
#define H_BRUSH  han_BRUSH       // iA
#define H_MOVIE  han_MOVIE       // wA

#define E_MYUNG  eng_MYUNG       // wA
#define E_GOTHIC eng_GOTHIC      // A
#define E_ITALIC eng_ITALIC      // ȉA
#define E_PILGI  eng_PILGI       // ϩA
#define E_BIG    eng_BIG         // eiA
#define E_SMALL  eng_SMALL       // beiA

#define H24_MYUNG  han24_MYUNG   // wA
#define H24_GOTHIC han24_GOTHIC  // A
#define H24_PILGI  han24_PILGI   // ϩA
#define H24_SAM    han24_SAM     // A
#define H24_GUNG   han24_GUNG    // A

#define E24_MYUNG  eng24_MYUNG   // wA
#define E24_GOTHIC eng24_GOTHIC  // A
#define E24_ITALIC eng24_ITALIC  // ȉA


//-------------- ei ea w b ͥa  --------------------//
#define H_FNTNUM      360
#define HJ_FNTNUM    4888
#define E_FNTNUM      256


//-------------------- ͥa a ----------------------------------//
#define H_FNTSIZE16    32
#define H_FNTSIZE24    72

#define HJ_FNTSIZE16   32
#define HJ_FNTSIZE24   72

#define E_FNTSIZE16    16
#define E_FNTSIZE24    48


//--------------------- ei b ŝe ----------------------------//
#define HI_NOWAIT 1
#define HI_EONLY   2

#pragma pack(1)

enum HANINPRESULTS
{
        HR_NOKEY,
        HR_ASC,
        HR_HANST,
        HR_HANIN,
        HR_HANEND,
        HR_HANBS,
        HR_NOHAN
};

enum { BULSIK2, BULSIK3 };

#pragma pack()

#define CK_ASC  0       // wa
#define CK_HAN1 1       // ei 弁 aa
#define CK_HAN2 2       // ei 弁 aa


//-----------------------------------------------------------------//
#define MAXBUF  50    // buffer size for save screen

#pragma pack(1)

typedef struct
{
   int x1, y1, x2, y2;
   char *buf;
} HSCREEN;


//---------------------- 啡 A ----------------------------//
typedef struct
{
   char *caption;   // ai
   int  sx, sy,     // a
        ex, ey;
   int  theight;    // ai a 
   int  tcolor;     // ai ai i
   int  bdcolor;    // 啡 w
   int  bgcolor;    // 啡 w
   int  bdwidth;   // 啡 w 췡
   char button;     // 啡 b weA ei a
   char save;       // wi wi a?
   char *scrbuf;    // w w 
} HWINDOW;

typedef struct
{
   int sx, sy,
       ex, ey;
   int color;
} HVIEWPORT;

typedef struct
{
   int type;        // box 
   int bgcolor;     // w
   int bdcolor;     // ᬂ
   int bdwidth;     //  A
} BOXPUT;

#pragma pack()


//---------------------- w  --------------------------------//
#define BLACK        0
#define BLUE         1
#define GREEN        2
#define CYAN         3
#define RED          4
#define MAGENTA      5
#define BROWN        6
#define LGRAY        7
#define DGRAY        8
#define LBLUE        9
#define LGREEN      10
#define LCYAN       11
#define LRED        12
#define LMAGENTA    13
#define YELLOW      14
#define WHITE       15



//-----------------------------------------------------------------------//
//                      A e 
//-----------------------------------------------------------------------//

extern char han_MYUNG[], han_GOTHIC[], han_PILGI[], han_SAM[],
            han_IYAGI[], han_GUNG[],   han_BRUSH[], han_MOVIE[],
            eng_MYUNG[], eng_GOTHIC[], eng_ITALIC[],
            eng_PILGI[], eng_BIG[],    eng_SMALL[];

extern char han24_MYUNG[], han24_GOTHIC[], han24_PILGI[], han24_SAM[],
            han24_GUNG[], eng24_MYUNG[], eng24_GOTHIC[], eng24_ITALIC[];

extern int   GraphfgColor, GraphbgColor; // aϢ i
extern int   TextfgColor, TextbgColor;   // ai w/w
extern int   TextAttrib, PrevTextAttr;   // ai  e
                                         //  ai 
extern int   StX, StY;                   // A b a
extern int   MaxX, MaxY;                 // e A a
extern int   PMaxX, PMaxY;               // a e A a
extern int   sc_length;                  // Scanline length

extern DWORD Image[18];                  // ͥa s 

extern int   VideoMemSize;               //  A a

#ifdef __WATCOMC__
   extern char far *VRAM;                //  A
#endif

#ifdef DJGPP
   extern char *VRAM;
#endif

extern int   CurX, CurY;                 // a b á

extern DWORD *H_FONT, *H_FONT24,
             *E_FONT, *E_FONT24;
extern BYTE  *HJ_FONT,   *GRP_FONT,
             *HJ_FONT24, *GRP_FONT24;    // ͥa 

extern DWORD *CHO, *JUNG, *JONG,
             *CHO24, *JUNG24, *JONG24;

extern int   HanExtOn, EngExtOn;         // A ͥa 

extern int   HanInState;                 // ei b wȁ
extern int   HanInType;                  // ei ae 鯢(2/3)

extern int   USE_INP16;
extern int   OUTMODE;

extern HVIEWPORT _cw;



//-----------------------------------------------------------------------//
//                          q 
//-----------------------------------------------------------------------//

//---------------------  VESA Function  ---------------------------//
int  SetMode(int xres, int yres);

void GetDisplayStart(int *x, int *y);
int  SetDisplayStart(int x, int y);
int  GetScanlineLength(void);
int  SetScanlineLength(int width);
void SetVMaxX(int);

//------------------------  q  ---------------------------//
int  InitGraph(int);
void CloseGraph(void);
int  InitHan(int mode);
int  CloseHan(void);
void hsetkbd2(void);
void hsetkbd3(void);
void hsetoutmode(int);
void hsetinputmode(int);
int  hgetinputmode(void);


//----------------------  ͥa  q  --------------------------//
void enable_extfont(void);  // ei/w A ͥa aw
void disable_extfont(void); //          ЁA

void enable_exthan(void);   // ei A ͥa aw
void disable_exthan(void);  //        ЁA

void enable_exteng(void);   // w A ͥa aw
void disable_exteng(void);  //        ЁA

void hset_infont(char *, char *);
void hset_infont24(char *, char *);


//-------------------  A ͥa  q  -----------------------//
int LoadHanFont(char *HanFont);
int LoadEngFont(char *EngFont);
int LoadHanjaFont(char *HanjaFont);
int LoadGraphFont(char *HanjaFont);
int LoadHan24Font(char *HanFont);
int LoadEng24Font(char *EngFont);
int LoadHanja24Font(char *HanjaFont);
int LoadGraph24Font(char *HanjaFont);


//-------------------  ͥa s  q  -----------------------//
int  hsetfont(char *hfname, char *efname, char *hjfname, char *grpfname);
int  hsetfont24(char *hfname, char *efname, char *hjfname, char *grpfname);


//---------------------   aϢ q  ------------------------//
void clrblk(int x, int y, int w, int h, int color);
void _clrblk(int sx, int sy, int ex, int ey, int color);
void _clrscr(int color);
int  getpixel(int x, int y);
void putpixel(int x, int y, int color);
void hline(int x, int y, int length, int color);
void vline(int x, int y, int length, int color);
void line(int x1, int y1, int x2, int y2, int color);
void circle(int cx, int cy, int radius, int color);
void circlef(int cx, int cy, int radius, int color);
void ellipse(int cx, int cy, int xradius, int yradius, int color);
void ellipsef(int xc, int yc, int xl, int yl, int color);
void bar(int x1, int y1, int x2, int y2, int color);
void rect(int x1, int y1, int x2, int y2, int color);

void wclrblk(int x1, int y1, int w, int h, int color);
void _wclrscr(int color);
int  wgetpixel(int x, int y);
void wputpixel(int x, int y, int color);
void whline(int x, int y, int length, int color);
void wvline(int x, int y, int length, int color);
void wline(int x1, int y1, int x2, int y2, int color);
void wcirclef(int cx, int cy, int radius, int color);
void wcircle(int cx, int cy, int radius, int color);
void wellipse(int cx, int cy, int xradius, int yradius, int color);
void wellipsef(int xc, int yc, int xl, int yl, int color);
void wbar(int x1, int y1, int x2, int y2, int color);
void wrect(int x1, int y1, int x2, int y2, int color);

void hsetcolor(int color);
void hrestorecolor(void);
void hsetgcolor(int color);
void hrestoregcolor(void);

void draw_upper(int x1, int y1, int x2, int y2, int color);
void draw_lower(int x1, int y1, int x2, int y2, int color);

void bar3d(int x1, int y1, int x2, int y2, int fcolor, int color);
void box(int type, int x1, int y1, int x2, int y2, int depth, int fcolor, int color);


//----------------   w/ q  ------------------------//
long imagesize(int x1, int y1, int x2, int y2);

void hgetimg(int x1, int y1, int x2, int y2, char *buff);
extern void (*hputimg)(int x1, int y1, int x2, int y2, char *buff);
void putimg(int x1, int y1, int x2, int y2, char *buff);
void xputimg(int x1, int y1, int x2, int y2, char *buff);

void hwgetimg(int x1, int y1, int x2, int y2, char *buff); // 啡 q
extern void (*hwputimg)(int x1, int y1, int x2, int y2, char *buff);
void wputimg(int x1, int y1, int x2, int y2, char *buff);
void wxputimg(int x1, int y1, int x2, int y2, char *buff);


//----------------------  啡 q ----------------------------//
void hsetviewport(int, int, int, int);
int  hsetwindow(int, int, int, int);
int  hprevwindow(void);

void hinitwin(char *, int, int, int, int, int, int,
                        int, int, int, int, int, HWINDOW *);
int  hopenwin(HWINDOW *);
void hclosewin(HWINDOW *);


//----------------------  aa q  ---------------------------//
void hscroll(int x1, int y1, int x2, int y2, int num, int mode);
void hwscroll(int x1, int y1, int x2, int y2, int num, int mode);


//--------------------  ͥa s q  ----------------------------//
void han_make(BYTE data1, BYTE data2);
void eng_make(int code);
void graph_make(BYTE b1, BYTE b2);

void han_make24(BYTE data1, BYTE data2);
void eng_make24(int code);
void graph_make24(BYTE b1, BYTE b2);


//------------------  ͥa b q  -----------------------------//
void hputfont(int x, int y, int W, int H, char *buffer);
void hputfont16(int x, int y, int H, WORD *buffer);
void eputfont(int x, int y, int W, int H, char *buffer);

void hwputfont(int x, int y, int W, int H, char *buffer);
void hwputfont16(int x, int y, int H, WORD *buffer);
void ewputfont(int x, int y, int W, int H, char *buffer);


//--------------------  ͥa   q  ----------------------//
void hmakeattr(int img_length, int ch);

void hsetattrib(int attr);
void hsettextattr(int attr);
void hrestoretextattr(void);

void scale_img(int xbyte, int flag, char *src, char *dest);
void hscale_img24(int xbyte, int flag, char *src, char *dest);
void escale_img24(int xbyte, int flag, char *src, char *dest);


//----------------------  ͥa  q  -------------------------//
void reverse_img(DWORD * dest, int num);
void shadow_img(BYTE * dest, int num, int CurChar);
void bold_img(BYTE * dest, int num);
void outline_img(BYTE * dest, int num);
void underline_img(BYTE * dest, int num);
void threed_img(BYTE * dest, int num, int CurChar);


//------------------ a ew q -----------------------------//
void hsettextcolor(int color);
void hrestoretextcolor(void);
void hreversetextcolor(void);


//----------------- ei ai b q -------------------------//
void houttextxy(int x, int y, char *s);
void houttextxy24(int x, int y, char *s);

void houttext(char *s);
void houttext24(char *s);

void hwouttextxy(int x, int y, char *s);
void hwouttextxy24(int x, int y, char *s);

void hputsxy(int x, int y, char *s);
void hcputsxy(int x, int y, char *s, int color);
void haputsxy(int x, int y, char *s, int attr);
void hcaputsxy(int x, int y, char *s, int color, int attr);

void hwputsxy(int x, int y, char *s);
void hwcputsxy(int x, int y, char *s, int color);
void hwaputsxy(int x, int y, char *s, int attr);
void hwcaputsxy(int x, int y, char *s, int color, int attr);

void hputsxy24(int x, int y, char *s);
void hcputsxy24(int x, int y, char *s, int color);
void haputsxy24(int x, int y, char *s, int attr);
void hcaputsxy24(int x, int y, char *s, int color, int attr);

void hwputsxy24(int x, int y, char *s);
void hwcputsxy24(int x, int y, char *s, int color);
void hwaputsxy24(int x, int y, char *s, int attr);
void hwcaputsxy24(int x, int y, char *s, int color, int attr);

void hprintfxy(int x, int y, char *format,...);
void hcprintfxy(int x, int y, int color, char *format,...);
void haprintfxy(int x, int y, int attr, char *format,...);
void hcaprintfxy(int x, int y, int color, int attr, char *format,...);

void hwprintfxy(int x, int y, char *format,...);
void hwcprintfxy(int x, int y, int color, char *format,...);
void hwaprintfxy(int x, int y, int attr, char *format,...);
void hwcaprintfxy(int x, int y, int color, int attr, char *format,...);

void hprintfxy24(int x, int y, char *format,...);
void hcprintfxy24(int x, int y, int color, char *format,...);
void haprintfxy24(int x, int y, int attr, char *format,...);
void hcaprintfxy24(int x, int y, int color, int attr, char *format,...);

void hwprintfxy24(int x, int y, char *format,...);
void hwcprintfxy24(int x, int y, int color, char *format,...);
void hwaprintfxy24(int x, int y, int attr, char *format,...);
void hwcaprintfxy24(int x, int y, int color, int attr, char *format,...);

//------------------ ei eia b q ------------------------//
void hputch(void *ch);
void hputch24(void *ch);

void hputchxy(int x, int y, void *ch);
void hputchxy24(int x, int y, void *ch);

void hwputch(void *ch);
void hwputch24(void *ch);

void hwputchxy(int x, int y, void *ch);
void hwputchxy24(int x, int y, void *ch);

//------------------ w eia b q ------------------------//
void eputch(char ch);
void eputch24(char ch);

void eputchxy(int x, int y, char ch);
void eputchxy24(int x, int y, char ch);

void ewputch(char ch);
void ewputch24(char ch);

void ewputchxy(int x, int y, char ch);
void ewputchxy24(int x, int y, char ch);

//------------------ ai  b q ------------------------//
void hzouttextxy(int x, int y, char *s, int flag);
void hzouttextxy24(int x, int y, char *s, int flag);

void hwzouttextxy(int x, int y, char *s, int flag);
void hwzouttextxy24(int x, int y, char *s, int flag);

void hzputsxy(int x, int y, char *s, int flag);
void hzcputsxy(int x, int y, char *s, int color, int flag);
void hzaputsxy(int x, int y, char *s, int attr, int flag);
void hzcaputsxy(int x, int y, char *s, int color, int attr, int flag);

void hwzputsxy(int x, int y, char *s, int flag);
void hwzcputsxy(int x, int y, char *s, int color, int flag);
void hwzaputsxy(int x, int y, char *s, int attr, int flag);
void hwzcaputsxy(int x, int y, char *s, int color, int attr, int flag);

void hzputsxy24(int x, int y, char *s, int flag);
void hzcputsxy24(int x, int y, char *s, int color, int flag);
void hzaputsxy24(int x, int y, char *s, int attr, int flag);
void hzcaputsxy24(int x, int y, char *s, int color, int attr, int flag);

void hwzputsxy24(int x, int y, char *s, int flag);
void hwzcputsxy24(int x, int y, char *s, int color, int flag);
void hwzaputsxy24(int x, int y, char *s, int attr, int flag);
void hwzcaputsxy24(int x, int y, char *s, int color, int attr, int flag);

void hzprintfxy(int x, int y, int flag, char *format,...);
void hzcprintfxy(int x, int y, int flag, int color, char *format,...);
void hzaprintfxy(int x, int y, int flag, int attr, char *format,...);
void hzcaprintfxy(int x, int y, int flag, int color, int attr, char *format,...);

void hwzprintfxy(int x, int y, int flag, char *format,...);
void hwzcprintfxy(int x, int y, int flag, int color, char *format,...);
void hwzaprintfxy(int x, int y, int flag, int attr, char *format,...);
void hwzcaprintfxy(int x, int y, int flag, int color, int attr, char *format,...);

void hzprintfxy24(int x, int y, int flag, char *format,...);
void hzcprintfxy24(int x, int y, int flag, int color, char *format,...);
void hzaprintfxy24(int x, int y, int flag, int attr, char *format,...);
void hzcaprintfxy24(int x, int y, int flag, int color, int attr, char *format,...);

void hwzprintfxy24(int x, int y, int flag, char *format,...);
void hwzcprintfxy24(int x, int y, int flag, int color, char *format,...);
void hwzaprintfxy24(int x, int y, int flag, int attr, char *format,...);
void hwzcaprintfxy24(int x, int y, int flag, int color, int attr, char *format,...);


//------------------ ei eia b q ------------------------//
void hzputch(void *ch, int flag);
void hzputch24(void *ch, int flag);

void hzputchxy(int x, int y, void *ch, int flag);
void hzputchxy24(int x, int y, void *ch, int flag);

void hwzputch(void *ch, int flag);
void hwzputch24(void *ch, int flag);

void hwzputchxy(int x, int y, void *ch, int flag);
void hwzputchxy24(int x, int y, void *ch, int flag);

//------------------ w eia b q ------------------------//
void ezputch(char ch, int flag);
void ezputch24(char ch, int flag);

void ezputchxy(int x, int y, char ch, int flag);
void ezputchxy24(int x, int y, char ch, int flag);

void ewzputch(char ch, int flag);
void ewzputch24(char ch, int flag);

void ewzputchxy(int x, int y, char ch, int flag);
void ewzputchxy24(int x, int y, char ch, int flag);


//------------------ b q ------------------------------------//
#ifdef __WATCOMC__
   short hgetkey(int inphan);
   void  hputkey(short key);
   short InKeyBuf(void);
#endif

#ifdef DJGPP
   WORD hgetkey(int inphan);
   void hputkey(WORD key);
   WORD InKeyBuf(void);
#endif

void enable_input24(void);
void disable_input24(void);

#ifdef __WATCOMC__
   short hgetchxy(int x, int y, int inpmode, short *ch, short bch);
   short hgetstr(int x, int y, char *str, int maxlen, int inphan);
#endif

#ifdef DJGPP
   WORD hgetchxy(int x, int y, int inpmode, WORD *ch, WORD bch);
   int  hgetstr(int x, int y, char *str, int maxlen, int inphan);
#endif

//------------------  aϢ a ŝe q  ----------------------//
#ifdef DJGPP
   int isgraphic(BYTE c1, BYTE c2);
#endif

//--------------------- ea ŝe q ----------------------------//
BOOL ishanja(WORD hj);
void hanja_make(BYTE byte1, BYTE byte2);
void hanja_make24(BYTE byte1, BYTE byte2);


//------------------  e w/ q  ------------------------//
int hsavescr(int x, int y, int xnum, int ynum);
int hrestorescr(void);


//------------------  eǡ w q  ---------------------------//
int  hregkeyfunc(short keynum, void (*keyfunc) ());
void *hclearkeyfunc(DWORD keynum);
void hkeyfuncon(void);
void hkeyfuncoff(void);


//------------------- aw e q ------------------------------//
void VirtualDeskOn(void);
void VirtualDeskOff(void);


//-------------------  A q --------------------------------//
int  SetActivePage(int x, int page);
int  SetVisualPage(int x, int page);
int  GetPageNum(void);


//-------------------- iAa q --------------------------------//
void SetPal(BYTE *dummy);
void GetPal(BYTE *dummy);
void WaitForVRetrace(void);
void Same2Pal(BYTE *pal1, BYTE *pal2);
void SetGrayPal(BYTE *src, BYTE *dest);
void SetColorLevel(BYTE *src, BYTE *dest, int r, int g, int b);
void SetRgb(int index, char r, char g, char b);
void GetRgb(int index, char *r, char *g, char *b);
void FadeIn(BYTE *palette);
void FadeOut(BYTE *palette);
void SetPalBlack(void);
void SetPalWhite(void);
int  LoadPal(char *filename, char *pal);
int  LoadPalIco(char *filename, char *pal);
int  LoadPalPcx(char *filename, char *pal);


//-----------------------  a q  -----------------------------//
int hmaxx(void);
int hmaxy(void);
int hwmaxx(void);
int hwmaxy(void);
int hpmaxx(void);
int hpmaxy(void);

int getvideomem(void);

void hmsgbox(char *s, int tcolor, int bgcolor);
void hmsgbox24(char *s, int tcolor, int bgcolor);

void hinitboxputs(int, int, int, int);
void hboxputs(int x, int y, char *str);
void hboxputs24(int x, int y, char *str);

#endif
