VERSION 5.00
Begin VB.Form frmStarFld 
   AutoRedraw      =   -1  'True
   Caption         =   "DirectDraw StarField Sample"
   ClientHeight    =   3195
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   4680
   LinkTopic       =   "Form1"
   MousePointer    =   99  'Custom
   ScaleHeight     =   3195
   ScaleWidth      =   4680
   StartUpPosition =   2  'CenterScreen
   Visible         =   0   'False
   WindowState     =   2  'Maximized
End
Attribute VB_Name = "frmStarFld"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' DirectDraw Starfield Sample

Option Compare Text
Option Explicit

Private Declare Function SetPixel Lib "gdi32" (ByVal hdc As Long, ByVal x As Long, ByVal y As Long, ByVal crColor As Long) As Long
Private Declare Function ShowCursor Lib "user32" (ByVal bShow As Long) As Long

Const NumberOfStars = 400   ' Number of stars
Const ResolutionX = 640     ' Width for the display mode
Const ResolutionY = 480     ' Height for the display mode

Dim dd As DirectDraw2               ' DirectDraw object
Dim ddsdFront As DDSURFACEDESC      ' Front surface description
Dim ddsFront As DirectDrawSurface2  ' Front buffer
Dim ddsBack As DirectDrawSurface2   ' Back buffer

Dim ddCaps As DDSCAPS               ' Capabilities for search
Dim lhdc As Long                    ' hDC for back buffer

Dim i As Long
Dim fx As DDBLTFX

Dim blnEnd As Boolean

Private Type TStar
    x As Single     ' x !
    y As Single     ' y !
    Color As Byte   ' Color (intensity)
End Type

Dim aStars(1 To NumberOfStars) As TStar

Private Sub Form_Load()
    ' Initial stars
    Dim i As Long
    For i = 1 To NumberOfStars
        With aStars(i)
            .x = Rnd * ResolutionX \ 2 - ResolutionX \ 4
            .y = Rnd * ResolutionY \ 2 - ResolutionY \ 4
            .Color = Rnd * 20 + 50
        End With
    Next
    ' Create the DirectDraw object
    DirectDrawCreate ByVal 0&, dd, Nothing
    ' This app is full screen and will change the display mode
    dd.SetCooperativeLevel Me.hWnd, DDSCL_EXCLUSIVE Or DDSCL_FULLSCREEN
    ' Set the display mode
    dd.SetDisplayMode ResolutionX, ResolutionY, 8, 0, 0
    
    ' Fill front buffer description structure...
    With ddsdFront
        ' Structure size
        .dwSize = Len(ddsdFront)
        ' Use DDSD_CAPS and BackBufferCount
        .dwFlags = DDSD_CAPS Or DDSD_BACKBUFFERCOUNT
        ' Primary, flipable surface
        .DDSCAPS.dwCaps = DDSCAPS_PRIMARYSURFACE Or DDSCAPS_FLIP Or DDSCAPS_COMPLEX Or DDSCAPS_SYSTEMMEMORY
        ' One back buffer (you can try 2)
        .dwBackBufferCount = 1
    End With
    ' Create front buffer
    dd.CreateSurface ddsdFront, ddsFront, Nothing
    
    ' Retrieve the back buffer object
    ddCaps.dwCaps = DDSCAPS_BACKBUFFER
    ddsFront.GetAttachedSurface ddCaps, ddsBack
    
    'Render loop
    While Not blnEnd
        DrawNextFrame
        DoEvents
    Wend
    Unload Me
    
End Sub

' Draw next frame
Private Sub DrawNextFrame()
    Dim t As RECT
    On Error Resume Next
    
    ' Clear the back buffer
    With fx
        .dwSize = Len(fx)
        .dwFillColor = RGB(0, 0, 0)
    End With
    t.Top = 0
    t.Left = 0
    t.bottom = ResolutionY
    t.Right = ResolutionX
    ddsBack.Blt t, Nothing, t, DDBLT_COLORFILL, fx
    
    ' Plot the stars (get and release the backbuffer DC)
    ddsBack.GetDC lhdc
    If Err = 0 Then
        For i = 1 To NumberOfStars
            With aStars(i)
                SetPixel lhdc, ResolutionX \ 2 + .x, ResolutionY \ 2 + .y, RGB(.Color, .Color, .Color)
            End With
        Next
        ddsBack.ReleaseDC lhdc
    End If
    
    ' Flip the buffers
    Do
        ddsFront.Flip Nothing, 0
        If Err = DDERR_SURFACELOST Then ddsFront.Restore
    Loop Until Err = 0
    
    ' Prepare the stars for the next frame
    For i = 1 To NumberOfStars
        With aStars(i)
            .x = .x * 1.2
            .y = .y * 1.2
            .Color = .Color * 1.2
            If Abs(.x) > ResolutionX \ 2 Or Abs(.y) > ResolutionY \ 2 Then
                .x = Rnd * ResolutionX \ 2 - ResolutionX \ 4
                .y = Rnd * ResolutionY \ 2 - ResolutionY \ 4
                .Color = Rnd * 20 + 50
            End If
        End With
    Next
    Exit Sub
'DrawNextFrame_Error:
'    ' If surface lost, try to restore it
'    If Err = DDERR_SURFACELOST Then
'        ddsFront.Restore
'        Resume
'    End If
'    ' If still drawing, try again
'    If Err = DDERR_WASSTILLDRAWING Then
'        Resume
'    End If
'    Resume Next
End Sub
' Unload the form
Private Sub Form_KeyPress(KeyAscii As Integer)
    blnEnd = True
End Sub
' Release DirectDraw objects
Private Sub Form_Unload(Cancel As Integer)
    dd.FlipToGDISurface
    dd.RestoreDisplayMode
    dd.SetCooperativeLevel 0, DDSCL_NORMAL
    Set ddsBack = Nothing
    Set ddsFront = Nothing
    Set dd = Nothing
    ShowCursor 1
End Sub
