extern "C" {
#include <conio.h>
#include <dos.h>
#include <time.h>
#include <stdlib.h>
#include <bios.h>
#include <string.h>
#include <dir.h>
}

#include <fstream.h>

#define BYTE unsigned char
#define BOOL BYTE
#define TRUE 1
#define FALSE 0

// define key codes
#define 	RETURN		13
#define		SPACE		32
#define		BS		8
#define		LEFT		331
#define		RIGHT		333
#define		UP		328
#define		DOWN		336
#define 	ESC		27

#define		F1		315
#define		F2		316
#define		F3		317
#define		F4		318
#define		F5		319
#define		F6		320
#define 	F7		321
#define 	F8		322
#define		F9		323
#define		F10		324

typedef struct {
    char num;
    char *list;
} BLOCK;

// function declare
void putchxy(int x, int y, char c, BYTE color = 7);
void putstr(int x, int y, char *str, BYTE color = 7);
void drawBOX(int left, int top, int right, int bottom, BYTE color = 7);
void hexxy(int x, int y, char hex, BYTE color = 7);
int inkey(void);
void clearKeyBuffer(void);

// classes
class OBJECT {
public:
    BYTE left;
    BYTE top;
    BYTE width;
    BYTE height;
    BYTE edge_color;
    BYTE *back_buffer;

    OBJECT() { edge_color = 9;}
    void clear(void);

    void Show(void) {
        back_buffer = new BYTE [(width +1) *(height +1) *2];
        gettext(left, top, left +width, top +height, back_buffer);
        drawBOX(left, top, left +width, top +height, edge_color);
        clear();
    }
    void Hide(void) {
        puttext(left, top, left +width, top +height, back_buffer);
        delete back_buffer;
    }
};

class WINDOW : public OBJECT {
public:
    char *title;
    char visual;
    BYTE title_color;
    WINDOW() { edge_color = 9; title_color = 11; }
    void Show(void) {
        OBJECT::Show();
        putstr(OBJECT::left +1, OBJECT::top, title, title_color);
    }
};

class LABEL : public OBJECT {
public:
    char *caption;
    BYTE caption_color;
    LABEL() { edge_color = 15; caption_color = 3; OBJECT::width = 10; OBJECT::height = 2; }
    void Show(void)
    {
        OBJECT::Show();
        putstr(OBJECT::left +1, OBJECT::top +1, caption, caption_color);
    }
};

class NEMO : public OBJECT {
public:
    char *map;
    char *user_map;
    BOOL map_allocated;

    int oldx, oldy;
    BLOCK *xblocks;
    BLOCK *yblocks;
    BYTE color;
    char pointChar;
    WINDOW helpWIN;

    NEMO() { oldx = 0; oldy = 0; edge_color = 15; color = 11; map_allocated = 0;}

    void readXblock(char *map, BLOCK &block, int pos);
    void readYblock(char *map, BLOCK &block, int pos);


    void Show(void) {
        back_buffer = new BYTE [(width +2) *(height +2) *2];
        gettext(left, top, left +width +1, top +height +1, back_buffer);
        drawBOX(left, top, left +width +1, top +height +1, edge_color);
        clear();
    }
    void Hide(void) {
        puttext(left, top, left +width +1, top +height +1, back_buffer);
        delete back_buffer;
    }

    void move_idcursor(int x, int y);
    void editmode(void);
    void gamemode(void);
    int save(void);
    int load(void);
    void preprocess(void);
    int isCompleted(void);
    int countPoint(void);
    void HideNuminfo(void);
    void ViewNuminfo(void);
    void done(void);
    void editHELP(void);
    void gameHELP(void);
};

class CURSOR {
    BOOL visible;
    BOOL saved;
    int x, y;
public:
    CURSOR() { visible = FALSE; Hide(); x = wherex(); y = wherey(); }
    ~CURSOR() { Normal(); gotoxy(x ,y);}

    void Hide(void)
    {
        union REGS r;
        r.h.ah = 1;
        r.h.ch = 0xc;
        r.h.cl = 0x20;
        int86(0x10, &r, &r);
        visible = FALSE;
    }

    void Show(void)
    {
        union REGS r;
        r.h.ah = 1;
        r.h.ch = 2;
        r.h.cl = 13;
        int86(0x10, &r, &r);
        visible = TRUE;
    }

    void save(void) { saved = visible; }

    void restore(void)
    {
        if (saved) Show();
        else Hide();
    }

    void Normal(void)
    {
        union REGS r;
        r.h.ah = 1;
        r.h.ch = 5;
        r.h.cl = 6;
        int86(0x10, &r, &r);
    }
};

class FILEBOX : public WINDOW {
    char list[100][14];
    void putFN(int y, char str[], BYTE color = 7); 

public:
    int count;

    FILEBOX() { width = 13; height = 10;}

    void makelist(void);
    void select(char *s);
};

// global variable
CURSOR cursor;
char lefttopChar;
char righttopChar;
char leftbotChar;
char rightbotChar;
char horizonalChar;
char verticalChar;

// functions
void putchxy(int x, int y, char c, BYTE color)
{
    char far *vram = (char far *)0xB8000000L; 

    if ((x < 1) || (x > 80) || (y < 1) || (y > 25)) return;
    x--; y--;

    *(vram+ 160 *y + (x << 1)) = c;
    *(vram+ 160 *y + (x << 1) +1) = color ;
}

void putstr(int x, int y, char *str, BYTE color)
{
    int i = -1;

    while (*(str + ++i))
       putchxy(x +i, y, *(str +i), color);
}

void drawBOX(int left, int top, int right, int bottom, BYTE color)
{
    putchxy(left , top , lefttopChar, color);
    putchxy(right, top , righttopChar, color);
    putchxy(left , bottom, leftbotChar, color);
    putchxy(right, bottom, rightbotChar, color);

    for( int j = top +1; j < bottom; j++) {
        putchxy(left, j, verticalChar, color);
        putchxy(right, j, verticalChar, color);
    }

    for ( int i = left +1; i < right; i++) {
        putchxy(i, top, horizonalChar, color);
        putchxy(i, bottom, horizonalChar, color);
    }
}

void hexxy(int x, int y, char hex, BYTE color)
{
    if (hex >= 10) putchxy(x, y, hex +55, color);
    else putchxy(x, y, hex +48, color);
}

int inkey(void)
{
    int ch;
    while (!bioskey(1));
    if ((ch = getch()) == 0) return (256 +getch());
    return(ch);
}

void input(char str[], int limit = 10, BYTE color = 7, int x = wherex(), int y = wherey())
{
    char *temp_str;
    int ch;
    int length = 0;

    cursor.save();
    cursor.Show();

    temp_str = new char [100];
    memset(temp_str, NULL, 100);

    gotoxy(x ,y);

    do {
        ch = inkey();
        if (ch == BS) {
            if (length > 0) {
                length--;
                temp_str[length] = NULL;
                putchxy(x +length, y, ' ', color);
            }
        }
        else {
            if ((ch > 33) && (ch < 126)) {
                if (length <= limit) {
                    putchxy(x +length, y, ch, color);
                    temp_str[length++] = ch;
                }
            }
        }
        gotoxy(x +length, y);
        if (ch == ESC) { str[0] = NULL; delete temp_str; cursor.restore(); return; }
    } while(ch != RETURN);

    cursor.restore();
    temp_str[length +1] = NULL;
    memcpy(str, temp_str, length +1);
    delete temp_str;
}

void inputWindow(char out[] ,char in[])
{
    WINDOW win;

    win.left = 30;
    win.width = 20;
    win.top = 5;
    win.height = 3;
    win.title = out;
    win.Show();
    input(in, 8, 0x0B, 35, 6);
    win.Hide();
}

int ynWindow(char out[] , int width = 25)
{
    WINDOW win;

    cursor.save();
    cursor.Hide();
    win.left = 30;
    win.width = width;
    win.top = 5;
    win.height = 4;
    win.title = out;
    win.Show();


    putstr(35, 7, "Yes");


    int ch;
    int YN = 0;
    putstr(30 +width -5, 7, "No", 0x1E);

    do {
        ch = inkey();
        if ((ch == LEFT) || (ch == RIGHT)) {
            YN = YN ^1;
            if (YN) {
                putstr(35, 7, "Yes", 0x1E);
                putstr(30 +width -5, 7, "No");
            }
            else {
                putstr(35, 7, "Yes");
                putstr(30 +width -5, 7, "No", 0x1E);
            }
        }
        if (ch == ESC) { YN = 0; break;}
    } while (ch != RETURN);

    cursor.restore();
    win.Hide();
    return YN;
}

void clearKeyBuffer(void)
{
    while (kbhit()) getch();
}

// methods
void FILEBOX::putFN(int y, char str[], BYTE color) 
{
    int i, len;
    putstr(left +1, top +1 +y, str, color);
    len = strlen(str);
    for (i = 0; i < width -len -1; i++) putchxy(left +1 +len +i, top +1 +y, 0, 0);
}

void FILEBOX::makelist(void) {
    ffblk f;
    ifstream test;
    char header[3];

    memset(list , 0, 1400);
    count = 0;
    int done = findfirst("*.nmp", &f, FA_ARCH|FA_RDONLY);

    while (!done)
    {
        test.open(f.ff_name);
        test.read(header, 3);
        if ((header[0] == 'N') && (header[1] == 'M') && (header[2] == 'P'))
            memcpy(list[count++], f.ff_name, 14);

        test.close();
        done = findnext(&f);
    }
}

void FILEBOX::select(char *s) 
{
    OBJECT::Show();

    int i = 1;
    int cursor_y = 0, box_y = 0;

    putFN(0, list[0], 0x1E);

    while (list[i][0] != 0) {
        putFN(i, list[i]);

        if (++i > height -2) break;
    }

    int ch;

    do {
        ch = inkey();
        switch (ch) {
            case UP:
                if (cursor_y == 0) {
                    if (box_y > 0) {
                        box_y--;

                        putFN(0, list[box_y], 0x1E);


                        i = 1;
                        while (list[box_y +i][0] != 0) {
                            putFN(i, list[box_y +i]);
                            if (++i > height -2) break;
                        }
                    }
                }
                else {
                    putFN(cursor_y, list[cursor_y +box_y]);
                    cursor_y--;
                    putFN(cursor_y, list[cursor_y +box_y], 0x1E);
                }
                break;
           case DOWN:
                if (cursor_y == height -2) {
                    if (box_y +height < count +1) {
                        box_y++;

                        i = 0;
                        while (list[box_y +i][0] != 0) {
                            putFN(i, list[box_y +i]);
                            if (++i > height -3) break;
                        }
                        putFN(height -2, list[box_y +height -2], 0x1E);
                    }
                }
                else if (cursor_y +1 < count) {
                    putFN(cursor_y, list[cursor_y +box_y]);
                    cursor_y++;
                    putFN(cursor_y, list[cursor_y +box_y], 0x1E);
                }
                break;
           case ESC:
                s[0] = NULL;
                OBJECT::Hide();
                return;
        }
    } while (ch != RETURN);
    memcpy(s ,list[cursor_y +box_y], 14);
    OBJECT::Hide();
}

void OBJECT::clear(void) 
{
    for (int i = left +1; i < left +width; i++)
        for (int j = top +1; j < top +height; j++)
            putchxy(i, j, 32);
}

// methods of class NEMO
void NEMO::move_idcursor(int x, int y)
{
        int i;
        BLOCK idx;
        BLOCK idy;

        readXblock(user_map, idx, x);
        readYblock(user_map, idy, y);
        gotoxy(left +x +1, top +y +1);

        // normal
        for (i = 0; i < xblocks[oldx].num; i++)
            hexxy(left +oldx +1, top -xblocks[oldx].num +i, xblocks[oldx].list[i]);

        for (i = 0; i < yblocks[oldy].num; i++)
            hexxy(left -yblocks[oldy].num +i, top +oldy +1, yblocks[oldy].list[i]);

        // draw cursor
        for (i = 0; i < xblocks[x].num; i++) {
            if ((idx.num > xblocks[x].num) || (idx.num <= i)) {
                hexxy(left +x +1, top -xblocks[x].num +i, xblocks[x].list[i], 0x0E);
                continue;
            }
            if (idx.list[i] == xblocks[x].list[i]) hexxy(left +x +1, top -xblocks[x].num +i, xblocks[x].list[i], 0x0A);
            else hexxy(left +x +1, top -xblocks[x].num +i, xblocks[x].list[i], 0x04);
        }

        for (i = 0; i < yblocks[y].num; i++) {
            if ((idy.num > yblocks[y].num) || (idy.num <= i)) {
                hexxy(left -yblocks[y].num +i, top +y +1, yblocks[y].list[i], 0x0E);
                continue;
            }
            if (idy.list[i] == yblocks[y].list[i]) hexxy(left -yblocks[y].num +i, top +y +1, yblocks[y].list[i], 0x0A);
            else hexxy(left -yblocks[y].num +i, top +y +1, yblocks[y].list[i], 0x04);
        }
        oldx = x;
        oldy = y;
}

void NEMO::readXblock(char *map, BLOCK &block, int pos)
{
    int block_flag, block_count;
    char temp[100];

    block.num = 0;
    block.list = NULL;
    block_flag = 0;
    block_count = 0;

    for (int j = 0; j < height; j++ ) {
        if (map[j *width +pos] == 1) {
            block_count++;
            if (block_flag == 0) block_flag = 1;
        }
        else {
            if (block_flag == 1) {
                block.num++;
                temp[block.num -1] = block_count;
                block_count = 0;
                block_flag = 0;
            }
        }
    }

    if (block_flag == 1) {
        block.num++;
        temp[block.num -1] = block_count;
    }

    if (block.num > 0) {
        block.list = new char[block.num];
        memcpy(block.list, temp, block.num);
    }
}

void NEMO::readYblock(char *map, BLOCK &block, int pos)
{
    int block_flag, block_count;
    char temp[100];

    block.num = 0;
    block.list = NULL;
    block_flag = 0;
    block_count = 0;

    for (int j = 0; j < width; j++ ) {
        if (map[pos *width +j] == 1) {
            block_count++;
            if (block_flag == 0) block_flag = 1;
        }
        else {
            if (block_flag == 1) {
                block.num++;
                temp[block.num -1] = block_count;
                block_count = 0;
                block_flag = 0;
            }
        }
    }

    if (block_flag == 1) {
        block.num++;
        temp[block.num -1] = block_count;
    }

    if (block.num > 0) {
        block.list = new char[block.num];
        memcpy(block.list, temp, block.num);
    }
}



int NEMO::save(void)
{
    ofstream saveFILE;
    char s[10];

    inputWindow("[Save MAP]", s);

    if (s[0] == 0) return -1;

    int pos = 0;
    while (1) {
        if (s[pos] == '.') break;
        if (s[pos] == 0) {
            pos = strlen(s);
            break;
        }
        pos++;
    }

    s[pos] = '.';
    s[pos +1] = 'n';
    s[pos +2] = 'm';
    s[pos +3] = 'p';
    s[pos +4] = 0;

    ffblk f;
    int exist = !(findfirst(s, &f, FA_ARCH|FA_RDONLY));
    if (exist) if (!ynWindow("File exists. overwrite it?", 30)) return -1;

    saveFILE.open(s, ios::binary | ios::out);
    saveFILE.write("NMP", 3);
    saveFILE.write(&width, 1);
    saveFILE.write(&height, 1);
    saveFILE.write(map, width *height);
    saveFILE.close();
    return 1;
}

void NEMO::editHELP(void)
{
    helpWIN.left = 1;
    helpWIN.top = 18;
    helpWIN.width = 24;
    helpWIN.height = 6;
    helpWIN.title = "<HELP>";
    helpWIN.Show();
    putstr(2, 19, " Arrow keys : Move ");
    putstr(2, 20, " Space      : Mark ");
    putstr(2, 21, " 's'        : Save ");
    putstr(2, 22, " 'l'        : Load ");
    putstr(2, 23, " ESC        : Quit ");
}

void NEMO::gameHELP(void)
{
    helpWIN.left = 1;
    helpWIN.top = 18;
    helpWIN.width = 24;
    helpWIN.height = 4;
    helpWIN.title = "<HELP>";
    helpWIN.Show();
    putstr(2, 19, " Arrow keys : Move ");
    putstr(2, 20, " Space      : Mark ");
    putstr(2, 21, " ESC        : Quit ");
}


int NEMO::isCompleted(void)
{
    for (int i = 0; i < width *height; i++)
        if (map[i] != user_map[i])
            if (user_map[i] != 2) return 0;

    return 1;
}

void NEMO::editmode(void)
{
    int ch;
    int curx = 0,cury =0;
    char modified = 0;

    char str[4];

    cursor.Show();

    inputWindow("Enter width(5..15)", str);
    width = atoi(str);
    if (str[0] == 0) width = 10;
    else if (width < 5) width = 5;
    else if (width > 15) width = 15;

    inputWindow("Enter height(5..15)", str);
    height = atoi(str);

    if (str[0] == 0) height = 10;
    else if (height < 5) height = 5;
    else if (height > 15) height = 15;

    left = 25 +(55 -width) /2;
    top = (25 -height) /2;

    map = new char [width *height];
    map_allocated = 1;
    memset(map, 0, width *height);

    editHELP();
    Show();

    do {
        gotoxy(curx +left +1,cury +top +1);
        ch = inkey();
        switch (ch) {
            case RIGHT : {
                if (curx < width -1) curx++;
                break;
            }
            case LEFT : {
                if (curx > 0) curx--;
                break;
            }

            case UP : {
                if (cury > 0) cury--;
                break;
            }

            case DOWN : {
                if (cury < height -1) cury++;
                break;
            }
            case SPACE : {
                if (!modified) {
                    modified = 1;
                    putchxy(left +2 , top +height +1, 15, 14);
                }

                map[(cury ) *width +curx ] = map[(cury )*width +curx] ^1 ;
                if (map[(cury) *width +curx ])
                    putchxy(curx +left +1, cury +top +1, pointChar, color);
                else
                    putchxy(curx +left +1, cury +top +1, 0, color);
                break;
            }
            case 's':
                if (save() != -1) {
                    modified = 0;
                    putchxy(left +2 , top +height +1, 205, edge_color);
                }
                break;
            case 'l':
                if (modified) if (ynWindow("Save changes?")) if (save() == -1) break;

                Hide();
                if (load() != -1) {
                    Show();
                    for (int i = 0; i < width *height; i++)
                        if (map[i]) putchxy(left +1 +(i % width), top +1 +(i / width), pointChar, color);
                }
                else Show();
            case ESC:
                if (modified) if (!ynWindow("Quit without saving?")) ch = 0;

        }

    } while (ch != ESC);
    if (map_allocated) {
        delete map;
        map_allocated = 0;
    }
    cursor.Hide();
    helpWIN.Hide();
    Hide();
}

int NEMO::load(void)
{
    ifstream loadFILE;
    FILEBOX load;

    char s[14] ;

    load.title = "Load MAP";
    load.left = 30;
    load.top = 5;
    load.makelist();
    if (load.count != 0) load.select(s);
    else {
        LABEL msg;
        clock_t last;
        msg.left = 30;
        msg.top = 5;
        msg.width = 20;
        msg.height = 2;
        msg.caption = " No file to load";
        msg.Show();
        last = clock();

        while ((!bioskey(1)) && (clock() -last < 1000)) ;
        msg.Hide();
        return -1;
    }


    if (s[0] == NULL) return -1;

    loadFILE.open(s, ios::binary | ios::in);

    loadFILE.seekg(3);
    loadFILE.read(&width, 1);
    loadFILE.read(&height, 1);
    if (map_allocated) {
        delete map;
        map_allocated = 0;
    }
    map = new char[width *height];
    map_allocated = 1;
    loadFILE.read(map, width *height);
    loadFILE.close();
    return 1;
}

void NEMO::preprocess(void)
{
    int i;
    xblocks = new BLOCK[width];
    yblocks = new BLOCK[height];

    for (i = 0; i < width; i++) readXblock(map, xblocks[i], i);
    for (i = 0; i < height; i++) readYblock(map, yblocks[i], i);
}

int NEMO::countPoint(void)
{
    int count = 0;

    for (int i = 0; i < width *height; i++)
        if (map[i]) count++;

    return count;
}

void NEMO::ViewNuminfo(void)
{
    int i,j;
    for (i = 0; i < width; i++)
        for (j = 0; j < xblocks[i].num; j++)
            hexxy(left +i +1, top -xblocks[i].num +j, xblocks[i].list[j]);

    for (i = 0; i < height; i++)
        for (j = 0; j < yblocks[i].num; j++)
            hexxy(left -yblocks[i].num +j, top +i +1, yblocks[i].list[j]);
}

void NEMO::HideNuminfo(void)
{
    int i,j;
    for (i = 0; i < width; i++)
        for (j = 0; j < xblocks[i].num; j++)
             putchxy(left +i +1, top -xblocks[i].num +j, 0);

    for (i = 0; i < height; i++)
        for (j = 0; j < yblocks[i].num; j++)
             putchxy(left -yblocks[i].num +j, top +i +1, 0);
}

void NEMO::done(void)
{
    LABEL succeed;
    int ch;

    succeed.width = 15;
    succeed.left = left -succeed.width -1;
    succeed.height = 2;
    succeed.caption = " You DID it !";

    clock_t last = clock();
    clock_t last2 = clock();

    double g = 9.8 ;
    int v0 = 15;

    double t = 0;
    int oldtop, _top;

    oldtop = succeed.top =  -((v0 *t -((g *t *t)/2)) ) +21;
    succeed.Show();

    int finished = 0;
    int i = 0;
    int keyenabled = 0;

    while (1) {
        if (!keyenabled && (clock() -last2 > 500)) {
            keyenabled = 1;
            clearKeyBuffer();
        }
        if (bioskey(1)) if (keyenabled) break;

        if (clock() -last > 1) {
            if (!finished) {
                if (user_map[i] == 1) putchxy(left +1 + i % width, top +1 +i /width, 0, 0x99);
                if (user_map[i] == 2) putchxy(left +1 + i % width, top +1 +i /width, 0, 0);
                if (++i == width *height) finished = 1;
            }

            _top = -((v0 *t -((g *t *t)/2)) ) +21;
            if (_top > 21) {
                t = 0;
                if (v0 > 0) v0 -= 1;
                else v0 = 0;

               _top = -((v0 *t -((g *t *t)/2))) +21;
            }
            if (oldtop != _top) {
                succeed.Hide();
                succeed.top = _top;
                oldtop = _top;
                succeed.Show();
            }
            last = clock();
            t += 0.25;
        }
    }
    succeed.Hide();
}

void NEMO::gamemode(void)
{
    int i;
    if (load() == -1) return;
    preprocess();

    int xadd = 0, yadd = 0;

    for (i = 0; i < width; i++)
        if (yadd < xblocks[i].num) yadd = xblocks[i].num;
    for (i = 0; i < height; i++)
        if (xadd < yblocks[i].num) xadd = yblocks[i].num;


    OBJECT panel;
    panel.width = width +xadd +3;
    panel.height = height +yadd +3;

    panel.left = (55 -panel.width) /2 +25;
    panel.top = (25 -panel.height) /2 +1;
    panel.Show();

    left = panel.left +xadd +1;
    top = panel.top +yadd +1;
    Show();
    gameHELP();

    cursor.Show();
    user_map = new char [width *height];



    memset(user_map, 0, width *height);
    int numofPoint = countPoint();
    int PointDrawn = 0;


    int ch;
    int curx = 0,cury =0;

    ViewNuminfo();

    while(1) {
        move_idcursor(curx, cury);

        ch = inkey();
        switch (ch) {
            case RIGHT :
                if (curx < width -1) curx++;
                break;

            case LEFT :
                if (curx > 0) curx--;
                break;


            case UP :
                if (cury > 0) cury--;
                break;


            case DOWN :
                if (cury < height -1) cury++;
                break;

            case SPACE :
                switch (user_map[cury *width +curx]) {
                    case 0: PointDrawn++;
                            user_map[cury *width +curx] = 1;
                            putchxy(curx +left +1, cury +top +1, pointChar, color);
                            break;

                    case 1: PointDrawn--;
                            user_map[cury *width +curx] = 2;
                            putchxy(curx +left +1, cury +top +1, 'X', color);
                            break;

                    case 2: user_map[cury *width +curx] = 0;
                            putchxy(curx +left +1, cury +top +1, 0, color);

                }


                if (PointDrawn == numofPoint)
                    if (isCompleted()) {
                        cursor.Hide();
                        HideNuminfo();
                        done();

                        goto end;
                    }

                break;
            case ESC:
                    if (ynWindow("Exit Game?")) {
                        HideNuminfo();
                        goto end;
                    }
        }

    };

end:
    Hide();
    panel.Hide();
    cursor.Hide();
    if (map_allocated) {
        delete map;
        map_allocated = 0;
    }
    delete user_map;
    delete xblocks;
    delete yblocks;
    helpWIN.Hide();
    clearKeyBuffer();
}

void main(int argc, char *argv[])
{
    NEMO nemo;
    WINDOW menu;
    LABEL playgame;
    LABEL editmap;
    LABEL exitgame;

    putstr(1, 24,"Nemo-Nemo LOGIC v1.0   (c) Kim Do-wan ['97 SUNIN 20912]");
    putstr(1, 25,"Hitel ID: Falcon80  Please mail me.");
    putstr(11, 25, "Falcon80", 0xB);

    if ((argc > 0) && (!strcmp(argv[1], "/ks"))) {
            nemo.pointChar = 8;
            lefttopChar = 1;
            righttopChar = 2;
            leftbotChar = 3;
            rightbotChar = 4;
            verticalChar = 5;
            horizonalChar = 6;
    }
    else {
            nemo.pointChar = 177;
            lefttopChar = 201;
            righttopChar = 187;
            leftbotChar = 200;
            rightbotChar = 188;
            horizonalChar = 205;
            verticalChar = 186;
    }

    playgame.caption = "F1 : PLAY GAME";
    playgame.width = strlen(playgame.caption) +1;
    playgame.left = 5;
    playgame.top = 3;

    editmap.caption = "F2 : EDIT MAP ";
    editmap.width = strlen(editmap.caption) +1;
    editmap.left = 5;
    editmap.top = 7;


    exitgame.caption = "ESC: EXIT GAME";
    exitgame.width = strlen(exitgame.caption) +1;
    exitgame.left = 5;
    exitgame.top = 11;


    menu.left = 1;
    menu.width = 24;
    menu.top = 1;
    menu.height = 15;
    menu.title = "[Nemo-Nemo LOGIC]";
    menu.Show();
    playgame.Show();
    exitgame.Show();
    editmap.Show();

    int ch;
    do {
        ch = inkey();
        switch (ch) {
            case F1:{
                nemo.gamemode();

                break;

            }
            case F2 : {
                nemo.editmode();

                break;

            }
        }
    } while (ch != 27);


    playgame.Hide();
    editmap.Hide();
    exitgame.Hide();
    menu.Hide();

}



