import java.lang.*;
import java.util.Random;

public class GameEngine {
    // ------------Constants--------------------
    static final char Up = 'U';
    static final char Down = 'D';
    static final char Right = 'R';
    static final char Left = 'L';
    static final char UpLeft = 'A';
    static final char UpRight = 'B';
    static final char DownLeft = 'C';
    static final char DownRight = 'E';
    
    // ------------Data-------------------------
    Random NumberGenerator;     // The random number generator    
    // Store the current location.
    private int CurX, CurY;
    // Store the playing field information.
    private int SizeX, SizeY;
    private char PlayingField[][];
    private int AmountDone;    
    private boolean GameOver;

    // ----------------Procedures------------------    
    // Constructors functions
    private void InitializeEngine(int AssignX, int AssignY) {
        NumberGenerator = new Random(); // Create the random number generator
        
        GameOver = false;                               // New Game set to false.
        AmountDone = 1;                                 // Set the amount done to 0
        SizeX = AssignX; SizeY = AssignY;               // Initalize the values.
        // Pick a random location.
        CurX = Math.abs(NumberGenerator.nextInt() % SizeX);
        CurY = Math.abs(NumberGenerator.nextInt() % SizeY);
        
        PlayingField = new char[SizeX][SizeY];
        FillNumbers();
        PlayingField[CurX][CurY] = '*';
    }
    
    GameEngine(int AssignX, int AssignY) {
        super();
        InitializeEngine(AssignX, AssignY);   // Default use a 100 X 100 grid
    }
    
    GameEngine() {
        super();
        InitializeEngine(80, 25);   // Default use a 100 X 100 grid
    }

    // Game Functions
    // Returns false if game is over. true if move is successful.
    public boolean MakeMove(char WhichWay) {
        // 0 don't move, -1 move toward origin, +1 move away from origin.
        int XDirection = 0, YDirection = 0;
        char CurrentPosition;

        int MoveThisMuch = AmountToMove(WhichWay);

        // Make the move depending on which way we have to go.
        if (MoveThisMuch != 0 && GameOver == false) {   // Check to see if we are going to move out of bounds.
            switch (WhichWay) {
                case Up:
                    YDirection = -1;
                    break;
                case Down:
                    YDirection = +1;
                    break;
                case Left:
                    XDirection = -1;
                    break;
                case Right:
                    XDirection = +1;
                    break;
                case UpLeft:
                    YDirection = -1;
                    XDirection = -1;
                    break;
                case UpRight:
                    YDirection = -1;
                    XDirection = +1;
                    break;
                case DownRight:
                    YDirection = +1;
                    XDirection = +1;
                    break;
                case DownLeft:
                    YDirection = +1;
                    XDirection = -1;
                    break;
            }

            // Fill in MoveThisMuch amount of squares. Stop under two conditions:
            // 1) We hit the boundries of the playing field
            // 2) Gave is over because we hit ourselves
            for(int i = 0; i < MoveThisMuch; i++) {
                // First check to see if we hit the boundries.
                if (CurX + XDirection < 0 || CurX + XDirection > SizeX - 1)
                    return true;
                else if (CurY + YDirection < 0 || CurY + YDirection > SizeY - 1)
                    return true;

                // Now check to make sure that we did not run into ourselves
                CurrentPosition = PlayingField[CurX + XDirection][CurY + YDirection];
                if (CurrentPosition == '*') {
                    AmountDone++;   // Give them this position.
                    GameOver = true;
                    return false;
                }
                else {  // Play the position
                    PlayingField[CurX + XDirection][CurY + YDirection] = '*';
                    CurX += XDirection; CurY += YDirection;
                    AmountDone++;
                }
            }
        }
        else if (GameOver == true)  // Now check if the game is over.
            return false;
     
     // We finished moving! Let us us return true to indicate the move was a success.
    return true;
    }
        
    //--------------Get Status information functions------------------
    public char GetPlayingField(int x, int y) {
        return PlayingField[x][y];
    }    
    public int GetAmountDone() {
        return AmountDone;
    }
    public char[][] GetBoard() {
        return PlayingField;
    }    
    public int GetXPosition()  {
        return CurX;
    }    
    public int GetYPosition() {
        return CurY;
    }    
    public boolean IsGameOver() {
        return GameOver;
    }
    public int GetXSize() {
        return SizeX;
    }
    public int GetYSize() {
        return SizeY;
    }
    
    // Private functions
    private void FillNumbers() {
        int RandomNumber;
        char RandomCharacter;
        
        // This procedure fill the array with random numbers between 1 and 9
        for (int i=0; i < SizeX; i++)
            for (int j=0; j < SizeY; j++) {
                RandomNumber = (NumberGenerator.nextInt() % 9);
                RandomNumber = Math.abs(RandomNumber);
                RandomCharacter = (char)(RandomNumber + (int)'1');
                PlayingField[i][j] = RandomCharacter;
            }
    }

    // Return the amount to move given a direction. This simply returns the number in that direction.
    public int AmountToMove(char WhichWay) {
        // Return true if direction is legal
        int MoveAmount = 0;;
        char CharAmount = 'Z';  // Z if no moves available

        switch (WhichWay) {
            case Up:
                if (CurY - 1 >= 0)
                    CharAmount = PlayingField[CurX][CurY - 1];
                break;
            case Down:
                if (CurY + 1 <= SizeY - 1)
                    CharAmount = PlayingField[CurX][CurY + 1];
                break;
            case Left:
                if (CurX - 1 >= 0)
                    CharAmount = PlayingField[CurX - 1][CurY];
                break;
            case Right:
                if (CurX + 1 <= SizeX - 1)
                    CharAmount = PlayingField[CurX + 1][CurY];
                break;
            case UpRight:
                if ((CurY - 1 >= 0) && (CurX + 1 <= SizeX -1))
                    CharAmount = PlayingField[CurX + 1][CurY - 1];
                break;
            case UpLeft:
                if ((CurY - 1 >= 0) && (CurX - 1 >= 0))
                    CharAmount = PlayingField[CurX - 1][CurY - 1];
                break;
            case DownRight:
                if ((CurY + 1 <= SizeY - 1) && (CurX + 1 <= SizeX - 1))
                    CharAmount = PlayingField[CurX + 1][CurY + 1];
                break;
            case DownLeft:
                if ((CurY + 1 <= SizeY - 1) && (CurX - 1 >= 0))
                    CharAmount = PlayingField[CurX - 1][CurY + 1];
                break;
        }

        // Convert the character into a move amount.
        if (CharAmount != 'Z' && CharAmount != '*')
            MoveAmount = (int)CharAmount - (int)'0';
        else if  (CharAmount == '*') // Is GameOver?
        {
            MoveAmount = -1;
            GameOver = true;
        }

        return MoveAmount;
    }
}