/*
    My first Java program. A Version of my famous Snake program.
*/

import java.awt.*;
import java.applet.*;
import symantec.itools.awt.*;

public class SnakeWindow extends Applet {
    
	void btnPieGraph_Clicked(Event event) {
	    int Percent;
	    Percent = (int)((float)myGameEngine.GetAmountDone() / (float)(myGameEngine.GetXSize() * (float)myGameEngine.GetYSize()) * 100.0);
	    if (myPieChart == null) {
		    myPieChart = new frmPieChart();		    
		    myPieChart.setAmount(Percent);
		    myPieChart.show();
		}
		else {
		    myPieChart.setAmount(Percent);
		    myPieChart.show();
		}
	}

	public boolean keyDown(Event evt, int key) {
	    switch (key) {
	        case 49:    // 1 key
	            PlayMove(GameEngine.DownLeft);
	            break;
	        case 50:    // 2 key
	            PlayMove(GameEngine.Down);
	            break;
	        case 51:    // 3 key
	            PlayMove(GameEngine.DownRight);
	            break;
	        case 52:    // 4 key
	            PlayMove(GameEngine.Left);
	            break;
	        case 54:    // 6 key
	            PlayMove(GameEngine.Right);
	            break;  
	        case 55:    // 7 key
	            PlayMove(GameEngine.UpLeft);
	            break;  
	        case 56:    // 8 key
	            PlayMove(GameEngine.Up);
	            break;
	        case 57:    // 9 key
	            PlayMove(GameEngine.UpRight);
	            break;
	        case 76:    // L key
	        case 108:   // Fire locate event.
	            deliverEvent(new Event(btnLocate, Event.ACTION_EVENT, null));
	            break;
	        case 83:    // S key
	        case 115:
	            deliverEvent(new Event(btnStartNew, Event.ACTION_EVENT, null));
	            break;
	        case 65:    // A key
	        case 97:
	            deliverEvent(new Event(btnAbout, Event.ACTION_EVENT, null));
	            break;
	        case 80:    // P key
	        case 112:
	            deliverEvent(new Event(btnPieGraph, Event.ACTION_EVENT, null));
	            break;	        
	    }	    
	    return true;
	}
	
	void btnAbout_Clicked(Event event) {
		// to do: place event handler code here.
		if (myAboutBox == null) {
		    myAboutBox = new AboutBox("About JSnake");
		    myAboutBox.show();
		}
		else
		    myAboutBox.show();		
	}

    private GameEngine myGameEngine;    // The GameEngine
    private DrawEngine MyDrawEngine;    // My graphics engine.
    private AboutBox myAboutBox;        // Pointer to an about box.
    private frmPieChart myPieChart;     // Pointer to a pie chart.
    
    // Dialog boxes
    private frmGetSettings GetSettingsDialog;   // Get Settings dialog;
    public AudioClip auWelcome, auLoser;
    
	//----------Movement actions---------------------
	void PlayMove(char WhichWay) {
	    boolean MoveOK;	    
	    
	    // Check to see that the game isn't over.
	    if (myGameEngine.IsGameOver() == false) {
	        // ----------Begin Fast Redraw------------------------ 
	        MyDrawEngine.FastRedraw = true;
	        MyDrawEngine.WhichWay = WhichWay;
	        int MoveAmount = myGameEngine.AmountToMove(WhichWay);
	        
	        switch (WhichWay) {
	            case (GameEngine.Up):
	                MyDrawEngine.X = myGameEngine.GetXPosition();
	                MyDrawEngine.Y = myGameEngine.GetYPosition() - MoveAmount;
	                MyDrawEngine.FdrawWidth = 0;
	                MyDrawEngine.FdrawHeight = MoveAmount;	                
	                break;
	            case (GameEngine.Down):
	                MyDrawEngine.X = myGameEngine.GetXPosition();
	                MyDrawEngine.Y = myGameEngine.GetYPosition();
	                MyDrawEngine.FdrawWidth = 0;
	                MyDrawEngine.FdrawHeight = MoveAmount;	                
	                break;
	            case (GameEngine.Right):	                
	                MyDrawEngine.X = myGameEngine.GetXPosition();
	                MyDrawEngine.Y = myGameEngine.GetYPosition();
	                MyDrawEngine.FdrawWidth = MoveAmount; 
	                MyDrawEngine.FdrawHeight =0;
	                break;
	            case (GameEngine.Left):
	                MyDrawEngine.X = myGameEngine.GetXPosition() - MoveAmount;
	                MyDrawEngine.Y = myGameEngine.GetYPosition();	                
	                MyDrawEngine.FdrawWidth = MoveAmount; 
	                MyDrawEngine.FdrawHeight = 0;
	                break;
	            case (GameEngine.UpRight):
	                MyDrawEngine.X = myGameEngine.GetXPosition();
	                MyDrawEngine.Y = myGameEngine.GetYPosition() - MoveAmount;	                
	                MyDrawEngine.FdrawWidth = MoveAmount; 
	                MyDrawEngine.FdrawHeight = MoveAmount;	            
	                break;
	            case (GameEngine.UpLeft):
	                MyDrawEngine.X = myGameEngine.GetXPosition() - MoveAmount;
	                MyDrawEngine.Y = myGameEngine.GetYPosition() - MoveAmount;
	                MyDrawEngine.FdrawWidth = MoveAmount;
	                MyDrawEngine.FdrawHeight = MoveAmount;	            
	                break;
	            case (GameEngine.DownRight):
	                MyDrawEngine.X = myGameEngine.GetXPosition();
	                MyDrawEngine.Y = myGameEngine.GetYPosition();
	                MyDrawEngine.FdrawWidth = MoveAmount;
	                MyDrawEngine.FdrawHeight = MoveAmount;	            
	                break;
	            case (GameEngine.DownLeft):
	                MyDrawEngine.X = myGameEngine.GetXPosition() - MoveAmount;
	                MyDrawEngine.Y = myGameEngine.GetYPosition();
	                MyDrawEngine.FdrawWidth = MoveAmount;
	                MyDrawEngine.FdrawHeight = MoveAmount;	            
	                break;
	        }
	        
	        //-------------End Fast Redraw
	        
            MoveOK = myGameEngine.MakeMove(WhichWay);        
		    		    
		    int AmountDone = myGameEngine.GetAmountDone();		    
		    int Total = myGameEngine.GetXSize() * myGameEngine.GetYSize();
		    float PercentDone = (float)(((double)AmountDone / (double)Total) * 100.0);
		    Float StringVersion = new Float(PercentDone);
            txtAmountDone.setText(Integer.toString(AmountDone, 10));
		    txtPercent.setText(StringVersion.toString());

  		    // If the guy lost, pop up a message box telling that he lost.
		    // Also tell him verbally he lost.
		    if (!MoveOK && PercentDone < 99.9) {
		        lblLostMessage.setText("You have lost!! Start a new game!");
		        lblLostMessage.show();
		        auLoser.play();
		    }
		    else if (!MoveOK && PercentDone >= 99.9) {
		        lblLostMessage.setText("You have won! Start a new game.");		   
		        lblLostMessage.show();
		    }
		    
		    if (myPieChart != null)
		        myPieChart.setAmount((int)PercentDone);   // Update the pie chart..
		    
		    MyDrawEngine.repaint();
		}
	}
	void dirDown_Action(Event event) {
		PlayMove(GameEngine.Down);
	}	    
	void dirUp_Action(Event event) {
		PlayMove(GameEngine.Up);
	}
	void dirLeft_Action(Event event) {
		PlayMove(GameEngine.Left);
	}
	void dirRight_Action(Event event) {
		PlayMove(GameEngine.Right);
	}
	void dirUpLeft_Action(Event event) {
		PlayMove(GameEngine.UpLeft);
	}
    void dirUpRight_Action(Event event) {
		PlayMove(GameEngine.UpRight);
	}
	void dirDownRight_Action(Event event) {
		PlayMove(GameEngine.DownRight);
	}
	void dirDownLeft_Action(Event event) {
		PlayMove(GameEngine.DownLeft);
	}
	
	void btnLocate_Clicked(Event event) {
		//We should scroll to the current position
		int CurX = myGameEngine.GetXPosition() * MyDrawEngine.MaxWidth;
		int CurY = myGameEngine.GetYPosition() * MyDrawEngine.MaxHeight;
		Dimension dimensionMyDrawEngine = scrPlayingViewport.size();
		scrPlayingViewport.scrollHorizontalAbsolute(CurX - dimensionMyDrawEngine.width / 2);
		scrPlayingViewport.scrollVerticalAbsolute(CurY - dimensionMyDrawEngine.height / 2);
    }

	void btnStartNew_Clicked(Event event) {
		//{{CONNECTION
		// Create and show the Frame with a title...
		if (GetSettingsDialog == null) {
		    GetSettingsDialog = new frmGetSettings(this, "Adjust playing field");
		    GetSettingsDialog.show();		    
		}
		else
		    GetSettingsDialog.show();
		//}}
	}

	public void init() {
		super.init();

		// Take out this line if you don't use symantec.itools.net.RelativeURL
        symantec.itools.lang.Context.setDocumentBase(getDocumentBase());

		//{{INIT_CONTROLS
		setLayout(null);
		addNotify();
		resize(604,474);
		setBackground(new Color(32832));
		btnStartNew = new java.awt.Button("Start New Game");
		btnStartNew.reshape(10,380,144,38);
		btnStartNew.setFont(new Font("Dialog", Font.PLAIN, 12));
		add(btnStartNew);
		dirLeft = new symantec.itools.awt.DirectionButton();
		dirLeft.reshape(300,400,30,30);
		add(dirLeft);
		dirUp = new symantec.itools.awt.DirectionButton();
		dirUp.reshape(340,360,30,30);
		add(dirUp);
		dirUp.setDirection(symantec.itools.awt.DirectionButton.UP);
		dirDown = new symantec.itools.awt.DirectionButton();
		dirDown.reshape(340,440,30,30);
		add(dirDown);
		dirDown.setDirection(symantec.itools.awt.DirectionButton.DOWN);
		dirRight = new symantec.itools.awt.DirectionButton();
		dirRight.reshape(380,400,30,30);
		add(dirRight);
		dirRight.setDirection(symantec.itools.awt.DirectionButton.RIGHT);
		lblDirection = new java.awt.Label("Movement Buttons",Label.CENTER);
		lblDirection.reshape(140,360,149,20);
		add(lblDirection);
		scrPlayingViewport = new MyScrollingPanel();
		scrPlayingViewport.setLayout(null);
		scrPlayingViewport.reshape(10,50,576,300);
		scrPlayingViewport.setBackground(new Color(16777215));
		add(scrPlayingViewport);
		scrPlayingViewport.setMinimumWidth(324);
		scrPlayingViewport.setMinimumHeight(504);
		scrPlayingViewport.setScrollLineIncrement(15);
		lblAmountDone = new java.awt.Label("Amount Done:",Label.RIGHT);
		lblAmountDone.reshape(10,10,108,34);
		lblAmountDone.setFont(new Font("Dialog", Font.PLAIN, 12));
		add(lblAmountDone);
		txtAmountDone = new java.awt.TextField();
		txtAmountDone.setEditable(false);
		txtAmountDone.reshape(130,10,60,34);
		txtAmountDone.setFont(new Font("Dialog", Font.PLAIN, 12));
		txtAmountDone.setForeground(new Color(16776960));
		add(txtAmountDone);
		btnLocate = new java.awt.Button("Locate Position");
		btnLocate.reshape(430,380,120,38);
		btnLocate.setFont(new Font("Dialog", Font.PLAIN, 12));
		add(btnLocate);
		btnAbout = new java.awt.Button("About JSnake");
		btnAbout.reshape(10,430,143,38);
		btnAbout.setFont(new Font("Dialog", Font.PLAIN, 12));
		add(btnAbout);
		lblLostMessage = new java.awt.Label("You have lost!! Start a new game!");
		lblLostMessage.hide();
		lblLostMessage.reshape(360,10,240,24);
		lblLostMessage.setFont(new Font("Dialog", Font.BOLD, 12));
		add(lblLostMessage);
		dirUpLeft = new symantec.itools.awt.DiagonalDirectionButton();
		dirUpLeft.reshape(300,360,30,30);
		add(dirUpLeft);
		dirUpRight = new symantec.itools.awt.DiagonalDirectionButton();
		dirUpRight.reshape(380,360,30,30);
		add(dirUpRight);
		dirUpRight.setDirection(symantec.itools.awt.DiagonalDirectionButton.UPRIGHT);
		dirDownRight = new symantec.itools.awt.DiagonalDirectionButton();
		dirDownRight.reshape(380,440,30,30);
		add(dirDownRight);
		dirDownRight.setDirection(symantec.itools.awt.DiagonalDirectionButton.DOWNRIGHT);
		dirDownLeft = new symantec.itools.awt.DiagonalDirectionButton();
		dirDownLeft.reshape(300,440,30,30);
		add(dirDownLeft);
		dirDownLeft.setDirection(symantec.itools.awt.DiagonalDirectionButton.DOWNLEFT);
		btnPieGraph = new java.awt.Button("Pie Graph");
		btnPieGraph.reshape(170,380,84,38);
		btnPieGraph.setFont(new Font("Dialog", Font.PLAIN, 12));
		add(btnPieGraph);
		txtPercent = new java.awt.TextField();
		txtPercent.setEditable(false);
		txtPercent.reshape(280,10,72,34);
		txtPercent.setFont(new Font("Dialog", Font.PLAIN, 12));
		txtPercent.setForeground(new Color(16776960));
		add(txtPercent);
		lblPercent = new java.awt.Label("Percent",Label.RIGHT);
		lblPercent.reshape(200,10,60,24);
		lblPercent.setFont(new Font("Dialog", Font.PLAIN, 12));
		add(lblPercent);
		//}}
		// Set the Game and draw engines
		setGame(100, 100);

		// Load intro
		try {
		    auWelcome = getAudioClip(getCodeBase(), "Intro.au");
		    auLoser = getAudioClip(getCodeBase(), "Loser.au");
		}
		catch (Throwable te) {
		    // Forget it if we couldn't do it
		    ;
	    }
	}

	public void start() {	    
	    // Play intro
	    
	    if (auWelcome != null)
	        auWelcome.play();
	}
	
	public void setGame(int NumRows, int NumColumns) {
	    myGameEngine = new GameEngine(NumColumns,NumRows);	    
	    MyDrawEngine = new DrawEngine(scrPlayingViewport, myGameEngine, "Courier", 10); // Create my drawing engine.
	    scrPlayingViewport.removeAll();         // Take out the old canvas.
	    scrPlayingViewport.add(MyDrawEngine);   // Add our Canvas to the viewport
	    lblLostMessage.hide();      // Turn off the loser message!
	    txtAmountDone.setText(Integer.toString(1, 10)); // Set Amount to 1
	    txtPercent.setText("0");
	    scrPlayingViewport.scrollHorizontalAbsolute(0);
	    scrPlayingViewport.scrollVerticalAbsolute(0);

	    int AmountDone = myGameEngine.GetAmountDone();		    
	    int Total = myGameEngine.GetXSize() * myGameEngine.GetYSize();
	    float PercentDone = (float)(((double)AmountDone / (double)Total) * 100.0);
	    
        if (myPieChart != null)
		    myPieChart.setAmount((int)PercentDone);   // Update the pie chart..

	    MyDrawEngine.repaint();
	}

	public boolean handleEvent(Event event) {
		if (event.target == btnStartNew && event.id == Event.ACTION_EVENT) {
			btnStartNew_Clicked(event);
			return true;
		}
		if (event.target == btnLocate && event.id == Event.ACTION_EVENT) {
			btnLocate_Clicked(event);
			return true;
		}
		if (event.target == dirUp && event.id == Event.ACTION_EVENT) {
			dirUp_Action(event);
			return true;
		}
		if (event.target == btnAbout && event.id == Event.ACTION_EVENT) {
			btnAbout_Clicked(event);
			return true;
		}
		if (event.target == dirDown && event.id == Event.ACTION_EVENT) {
			dirDown_Action(event);
			return true;
		}
		if (event.target == dirLeft && event.id == Event.ACTION_EVENT) {
			dirLeft_Action(event);
			return true;
		}
		if (event.target == dirRight && event.id == Event.ACTION_EVENT) {
			dirRight_Action(event);
			return true;
		}
		if (event.target == dirUpLeft && event.id == Event.ACTION_EVENT) {
			dirUpLeft_Action(event);
			return true;
		}
		if (event.target == dirUpRight && event.id == Event.ACTION_EVENT) {
			dirUpRight_Action(event);
			return true;
		}
		if (event.target == dirDownRight && event.id == Event.ACTION_EVENT) {
			dirDownRight_Action(event);
			return true;
		}
		if (event.target == dirDownLeft && event.id == Event.ACTION_EVENT) {
			dirDownLeft_Action(event);
			return true;
		}
		if (event.target == btnPieGraph && event.id == Event.ACTION_EVENT) {
			btnPieGraph_Clicked(event);
			return true;
		}
		return super.handleEvent(event);
	}

	//{{DECLARE_CONTROLS
	java.awt.Button btnStartNew;
	symantec.itools.awt.DirectionButton dirLeft;
	symantec.itools.awt.DirectionButton dirUp;
	symantec.itools.awt.DirectionButton dirDown;
	symantec.itools.awt.DirectionButton dirRight;
	java.awt.Label lblDirection;
	MyScrollingPanel scrPlayingViewport;
	java.awt.Label lblAmountDone;
	java.awt.TextField txtAmountDone;
	java.awt.Button btnLocate;
	java.awt.Button btnAbout;
	java.awt.Label lblLostMessage;
	symantec.itools.awt.DiagonalDirectionButton dirUpLeft;
	symantec.itools.awt.DiagonalDirectionButton dirUpRight;
	symantec.itools.awt.DiagonalDirectionButton dirDownRight;
	symantec.itools.awt.DiagonalDirectionButton dirDownLeft;
	java.awt.Button btnPieGraph;
	java.awt.TextField txtPercent;
	java.awt.Label lblPercent;
	//}}
}

// The purpose of this class is to draw physical representation of the board.
class DrawEngine extends Canvas {
    // For faster redraw, let's expose this information to the public
    // and redraw only what's needed
    public boolean FastRedraw;
    public int X, Y;
    public int FdrawWidth, FdrawHeight;
    public char WhichWay;
    
    private Font DrawFont;
    private FontMetrics FontStats;
    private GameEngine DrawGame;
    private Image offScreenImage;
    private Graphics gpad;
    private Color Darkgreen;
    private MyScrollingPanel scrContainedHere;
    
    public int theWidth, theHeight;    // Store the width of the drawing area.
    public int MaxWidth, MaxHeight;

    DrawEngine(MyScrollingPanel scrInHere, GameEngine SetThisEngine, String FontName, int Size) {
        super();
        // Create all objects that we need
        FastRedraw = false;
        DrawFont = new Font(FontName, Font.BOLD, Size);
        FontStats = getFontMetrics(DrawFont);
        SetGame(SetThisEngine);
        theWidth = DrawGame.GetXSize() * (FontStats.charWidth('9') + 2);
        theHeight = (DrawGame.GetYSize() + 1) * FontStats.getHeight();
        this.reshape(0, 0, theWidth, theHeight);
        
        Darkgreen = new Color(32832);   // Make a new color.
        scrContainedHere = scrInHere;   // We are contained in this scroll panel here.
    }

    public void SetGame(GameEngine SetThisGame) {
        DrawGame = SetThisGame;
        repaint();
    }

    public void paint (Graphics g) {
        char CurrentChar[] = new char[1];
        MaxHeight = FontStats.getHeight();
        MaxWidth = FontStats.charWidth('9') + 2; //Put some margin in between each character.
        int theXSize = DrawGame.GetXSize();
        int theYSize = DrawGame.GetYSize();
        StringBuffer CreateBuffer;
        
        int SetY = 0, SetX = 0;
        if (offScreenImage == null || gpad == null) {
            offScreenImage = createImage(theWidth, theHeight);
            gpad = offScreenImage.getGraphics();
        }        

        if (FastRedraw) {
            FastRedraw = false;
            SetY = (Y < 0) ? (0) :(Y);
            SetX = (X < 0) ? (0) :(X);
            theXSize = (SetX + FdrawWidth + 1) > theXSize ? (theXSize) : (SetX + FdrawWidth + 1);
            theYSize = (SetY + FdrawHeight + 1) > theYSize ? (theYSize) : (SetY + FdrawHeight + 1);
            gpad.clearRect(SetX * MaxWidth, SetY * MaxHeight, Math.abs(SetX - theXSize) * MaxWidth, Math.abs(SetY - theYSize) * MaxHeight);            
        }         
        else {   // Let's figure out what's showing and redraw that only.
            gpad.clearRect(0, 0, theXSize * MaxWidth, theYSize * MaxHeight);
            int xCoord = scrContainedHere.getxCoord();
            int yCoord = scrContainedHere.getyCoord();
            Dimension EngineSize = scrContainedHere.size();            
            SetY = Math.abs(yCoord / MaxHeight);
            SetX = Math.abs(xCoord / MaxWidth);
            int CheckYSize = SetY + EngineSize.height / MaxHeight;
            int CheckXSize = SetX + EngineSize.width / MaxWidth;            
            theYSize = (CheckYSize > theYSize) ? theYSize : CheckYSize;
            theXSize = (CheckXSize > theXSize) ? theXSize : CheckXSize;
        }

        CreateBuffer = new StringBuffer(1); CreateBuffer.append('a');// Create and allocate.
        // Draw each line
        for (int i = SetY; i < theYSize; i++) {
            // For each line, construct a string
            for (int j = SetX; j < theXSize; j++) {
                CurrentChar[0] = DrawGame.GetPlayingField(j, i);
                // We have to select the color
                if (CurrentChar[0] == '*')
                    if (DrawGame.GetXPosition() == j && DrawGame.GetYPosition() == i)
                        gpad.setColor(Darkgreen);
                    else
                        gpad.setColor(Color.orange);
                else
                    gpad.setColor(Color.red);
                gpad.drawChars(CurrentChar, 0, 1, MaxWidth * j, MaxHeight * i + MaxHeight);
            }
        }
        // Draw the image.
        g.drawImage(offScreenImage, 0, 0, this);
    }

    public void update(Graphics g) {
        paint(g);
    }
}