/*
    A basic extension of the java.awt.Frame class
 */

import java.awt.*;

public class frmGetSettings extends Frame {    
    SnakeWindow ParentPanel;
    
	void btnOK_Clicked(Event event) {
	    // First convert what we are looking at into integers.
	    Integer NewRows, NewColumns;
	    
	    // In case the user types in an invalid response
	    try {
	        NewRows = new Integer(txtRows.getText());
	        NewColumns = new Integer(txtColumns.getText());	        
	        
	        if (NewRows.intValue() > 400 || NewColumns.intValue() > 400)
	            throw new NumberFormatException();
	        else
	            ParentPanel.auWelcome.play();   // Play the welcome message.
	    }
	    catch (NumberFormatException e) {
	        ;   // Do nothing
	        hide();
	        return;
	    }
	    
	    ParentPanel.setGame(NewRows.intValue(), NewColumns.intValue());
		hide();
	}

	void btnCancel_Clicked(Event event) {
		// let's hide us from view
		hide();		
	}

	public frmGetSettings(SnakeWindow SetParent) {
	    ParentPanel = SetParent;

		//{{INIT_CONTROLS
		setLayout(null);
		addNotify();
		resize(insets().left + insets().right + 323,insets().top + insets().bottom + 161);
		setBackground(new Color(12632256));
		myKeyPress = new symantec.itools.awt.KeyPressManagerPanel();
		myKeyPress.setLayout(null);
		myKeyPress.reshape(insets().left + 10,insets().top + 10,290,144);
		add(myKeyPress);
		lblColumns = new java.awt.Label("Number of &Columns:",Label.RIGHT);
		lblColumns.reshape(-10,50,158,22);
		myKeyPress.add(lblColumns);
		lblRows = new java.awt.Label("Number of &Rows:",Label.RIGHT);
		lblRows.reshape(0,10,146,22);
		myKeyPress.add(lblRows);
		btnCancel = new java.awt.Button("Cancel");
		btnCancel.reshape(190,90,86,38);
		btnCancel.setBackground(new Color(16777215));
		myKeyPress.add(btnCancel);
		txtRows = new java.awt.TextField();
		txtRows.setText("25");
		txtRows.reshape(160,0,72,35);
		myKeyPress.add(txtRows);
		txtColumns = new java.awt.TextField();
		txtColumns.setText("80");
		txtColumns.reshape(160,40,72,35);
		myKeyPress.add(txtColumns);
		btnOK = new java.awt.Button("OK");
		btnOK.reshape(50,90,84,34);
		btnOK.setBackground(new Color(16777215));
		myKeyPress.add(btnOK);
		setTitle("Adjust Playing Board");
		setResizable(false);
		//}}
        // Set Cancel and OK buttons;
        myKeyPress.setCancelButton(btnCancel);
        myKeyPress.setDefaultButton(btnOK);
		//{{INIT_MENUS
		//}}
	}

	public frmGetSettings(SnakeWindow SetParent, String title) {
	    this(SetParent);
	    setTitle(title);
	}

    public synchronized void show() {
    	move(50, 50);
    	super.show();
    }

	public boolean handleEvent(Event event) {
    	if (event.id == Event.WINDOW_DESTROY) {
            hide();         // hide the Frame
            return true;
    	}
		if (event.target == btnCancel && event.id == Event.ACTION_EVENT) {
			btnCancel_Clicked(event);
			return true;
		}
		if (event.target == btnOK && event.id == Event.ACTION_EVENT) {
			btnOK_Clicked(event);
			return true;
		}
		return super.handleEvent(event);
	}

	//{{DECLARE_CONTROLS
	symantec.itools.awt.KeyPressManagerPanel myKeyPress;
	java.awt.Label lblColumns;
	java.awt.Label lblRows;
	java.awt.Button btnCancel;
	java.awt.TextField txtRows;
	java.awt.TextField txtColumns;
	java.awt.Button btnOK;
	//}}

	//{{DECLARE_MENUS
	//}}
}
