/*
    A basic extension of the java.awt.Frame class
 */

import java.awt.*;

public class frmPieChart extends Frame {
	
	void btnClose_Clicked(Event event) {
		this.hide();
	}

	public void setAmount(int SetAmount) {
	    DrawPie.setAmount(SetAmount);
	}

	public frmPieChart() {

		//{{INIT_CONTROLS
		setLayout(null);
		addNotify();
		resize(insets().left + insets().right + 319,insets().top + insets().bottom + 349);
		setBackground(new Color(12632256));
		keyPressfrmPieChart = new symantec.itools.awt.KeyPressManagerPanel();
		keyPressfrmPieChart.setLayout(null);
		keyPressfrmPieChart.reshape(insets().left + 60,insets().top + 280,200,25);
		add(keyPressfrmPieChart);
		btnClose = new java.awt.Button("Close");
		btnClose.reshape(40,0,108,19);
		keyPressfrmPieChart.add(btnClose);
		lblLeft = new java.awt.Label("Amount Left");
		lblLeft.reshape(insets().left + 10,insets().top + 240,99,23);
		lblLeft.setFont(new Font("Dialog", Font.PLAIN, 12));
		add(lblLeft);
		lblDone = new java.awt.Label("Amount Done");
		lblDone.reshape(insets().left + 160,insets().top + 240,99,23);
		lblDone.setFont(new Font("Dialog", Font.PLAIN, 12));
		add(lblDone);
		sqrDone = new symantec.itools.awt.shape.Square();
		sqrDone.reshape(insets().left + 280,insets().top + 240,23,23);
		sqrDone.setBackground(new Color(16762880));
		add(sqrDone);
		sqrLeft = new symantec.itools.awt.shape.Square();
		sqrLeft.reshape(insets().left + 120,insets().top + 240,23,23);
		sqrLeft.setBackground(new Color(16711680));
		add(sqrLeft);
		setTitle("Pie Chart");
		setResizable(false);
		//}}
        DrawPie = new PieGraphEngine(0);
        DrawPie.reshape(insets().left + 45,insets().top, 275, 175);
        add(DrawPie);

        keyPressfrmPieChart.setCancelButton(btnClose);
        keyPressfrmPieChart.setDefaultButton(btnClose);
		//{{INIT_MENUS
		//}}
	}

	public frmPieChart(String title) {
	    this();
	    setTitle(title);
	}

    public synchronized void show() {
    	move(50, 50);
    	super.show();
    }

	public boolean handleEvent(Event event) {
    	if (event.id == Event.WINDOW_DESTROY) {
            hide();         // hide the Frame
            return true;
    	}
		if (event.target == btnClose && event.id == Event.ACTION_EVENT) {
			btnClose_Clicked(event);
			return true;
		}
		return super.handleEvent(event);
	}

	//{{DECLARE_CONTROLS
	symantec.itools.awt.KeyPressManagerPanel keyPressfrmPieChart;
	java.awt.Button btnClose;
	java.awt.Label lblLeft;
	java.awt.Label lblDone;
	symantec.itools.awt.shape.Square sqrDone;
	symantec.itools.awt.shape.Square sqrLeft;
	//}}

	PieGraphEngine DrawPie;

	//{{DECLARE_MENUS
	//}}
}

class PieGraphEngine extends Canvas {

    private int AmountGraph;    // Graph how much out of 100?
    private Rectangle TheBounds;    // Store the dimensions of this component

    Image offScreenImage;
    Graphics gpad;

    PieGraphEngine(int SetAmount) {
        AmountGraph = SetAmount;
    }

    PieGraphEngine() {
        this(10);
    }

    public void setAmount(int SetAmount) {
        AmountGraph = SetAmount;
        this.repaint();
    }
    
    public void paint(Graphics g) {
        int X1, Y1, X2, Y2;
        // Let's repaint the amount
        TheBounds = bounds();
        X1 = TheBounds.x;
        Y1 = TheBounds.y;
        X2 = TheBounds.width;
        Y2 = TheBounds.height;

        int Degrees = (int)((float)AmountGraph / 100.0 * 360.0);
        
        // First draw an entire not done amount, then draw the done amount over it.
        // Use double buffer to avoid flicker.
        if (offScreenImage == null || gpad == null) {
            offScreenImage = createImage(TheBounds.width, TheBounds.height);
            gpad = offScreenImage.getGraphics();
        }

        gpad.setColor(new Color(12632256));
        gpad.fillRect(0, 0, TheBounds.width, TheBounds.height);
        
        // We want a circle that fills the of the component
        int SmallestDimension = (TheBounds.height < TheBounds. width) ? TheBounds. width : TheBounds.height;
        SmallestDimension = SmallestDimension / 2;
        gpad.setColor(Color.red);
        gpad.fillOval(X1, Y1, SmallestDimension, SmallestDimension);
        // Now draw the part that's done.
        gpad.setColor(Color.orange);
        gpad.fillArc(X1, Y1, SmallestDimension, SmallestDimension, 90, -Degrees);

        g.drawImage(offScreenImage, 0, 0, this);
    }
    
    public void update(Graphics g) {
          paint(g);
    }
}