
// ######################################################################
// #                                                                    #
// #         ##   ####   ##   ##   ####   ##  ##   ####   ##  #####     #
// #         ##  ##  ##  ##   ##  ##  ##  ### ##  ##  ##  ##  ##  ##    #
// #         ##  ##  ##   ## ##   ##  ##  ######  ##  ##  ##  ##  ##    #
// #     ##  ##  ######   ## ##   ######  ## ###  ##  ##  ##  ##  ##    #
// #      ####   ##  ##    ###    ##  ##  ##  ##   ####   ##  #####     #
// #                                                                    #
// #    [][][][] - A BLOCK BREAKER APPLET BY REMI FAITOUT - [][][][]    #
// #    [][]  []                                            [][]  []    #
// #        o             VERSION 1.45 08/07/1997               o       #
// #      o==o                                                o==o      #
// #                                                                    #
// # Changes since V1.44 :                                              #
// #   - Stop() method in javanoid class                                #
// #   - Applet string in jnstatus class                                #
// ######################################################################

// ## IMPORTS ###########################################################
import java.lang.*;
import java.applet.*;
import java.io.*;
import java.awt.*;
import java.awt.image.*;
import java.awt.peer.*;
import java.net.*;

// ## JAVANOID : THE MAIN CLASS #########################################
// Here are the thread, the events and the paint method ...

public class javanoid extends Applet implements Runnable {

	static String title = "Javanoid V1.45";

	// idle time during the run loop
	protected int animationDelay = 10;

	// width & height for the game & the control panel
	final static int gameWidth = 320;
	final static int gameHeight = 300;
	final static int panelWidth = 100;
	
	// References
	Dimension minSize;
	jnimageserver imgServer;
	jnsoundserver sndServer;
	jngame game;
	Thread myThread;
	
	// User interface
	Panel panel;
	Checkbox soundCheck;
	Choice speedChoice;
	
  // javanoid initialization
	public void init() {
		
		// Game construction (image server, sound server & the game itself)
		imgServer = new jnimageserver(this); imgServer.init();
		sndServer = new jnsoundserver(this); sndServer.init();
		game = new jngame(this, imgServer, sndServer, gameWidth, gameHeight);

		// User interface construction
		panel = new Panel();
		panel.setBackground(Color.lightGray);
		panel.resize(panelWidth, gameHeight);
		panel.setLayout(new GridLayout(0, 1));
		panel.add(new Button("START"));
		panel.add(new Button("DEMO"));
		panel.add(new Button("PAUSE"));
		panel.add(new Button("RESUME")); 
		panel.add(soundCheck = new Checkbox("SOUND"));
		panel.add(new Label("SPEED", Label.CENTER));
		panel.add(speedChoice = new Choice());
		speedChoice.addItem("MAXIMUM");
		speedChoice.addItem("FAST");
		speedChoice.addItem("AVERAGE");
		speedChoice.addItem("SLOW");
		speedChoice.addItem("MINIMUM");
		speedChoice.select(2);
		panel.add(new Label("SPECIAL", Label.CENTER));
		panel.add(new Button("UNLOCK"));
		panel.add(new Button("NEXT"));
		
		setBackground(Color.lightGray);
		setLayout(new BorderLayout()); 
		add("West", game);
		add("East", panel);

		// Game init & Demo initialization
		game.startGame(true); 
		
		// Thread launch
		start();
		}

	// Start & stop methods
	public void stop() {
		if (myThread!=null) myThread.stop();
		myThread=null;
		}	
	public void start() { 
		if (myThread == null) {
			myThread = new Thread(this); 
			myThread.setPriority(Thread.MIN_PRIORITY);
			myThread.start(); 
			}
		}

	// Run method
	public synchronized void run() {
		while (Thread.currentThread()==myThread) {
			try { 
				if (game!=null) { game.live(); game.repaint(); } 
				if (sndServer!=null) sndServer.iterate();
				Thread.sleep(animationDelay); 
				} 
			catch (InterruptedException e) { break; }
			}
		}

	// Event handler (panel)
	public boolean action(Event evt, Object arg)	{
		if (evt.target==speedChoice) { 
			animationDelay = 5 * speedChoice.getSelectedIndex(); 
			}
		else if (evt.target==soundCheck) { 
			if (sndServer!=null) sndServer.toggle(); 
			}
		else if ("START".equals(arg)) { 
			if (game!=null) { game.stopGame(); game.startGame(false); } 
			}
		else if ("DEMO".equals(arg)) { 
			if (game!=null) { game.stopGame(); game.startGame(true); } 
			}
		else if ("PAUSE".equals(arg)) stop();
		else if ("RESUME".equals(arg)) start();
		else if ("UNLOCK".equals(arg)) { 
			if (game!=null) game.unlock(); 
			}
		else if ("NEXT".equals(arg)) { 
			if (game!=null) game.jumpNext(); 
			}
		return true;
		}			

	// Applet information methods
	public String getAppletInfo() { return "Applet " + title + " by Rmi FAITOUT"; }	
	}
	

// ## JAVANOID GAME CLASS ###############################################
// This is the most important class of javanoid : It creates and deletes 
// all the geme objects, manages their lives ans collisions, and traducts 
// on the game both the user and game events (user moves, bullets, pills 
// & balls throws, next level, ...). It's also the player during demo mode.  

final class jngame extends jnbuffer {

	final static int nbPills = 4;				// game default attributes
	final static int nbBullets = 8;
	final static int nbBalls = 3;
	final static int displayAlt = 100;
	final static int paddleAlt = 40;
	final static int scoreAlt = 20;
	final static int nbPillValues = 6;
	
	protected boolean goToNext = false;		// flags for game state
	protected boolean demoMode = false;
	protected boolean fireMode = false;
	
	// Javanoid objects !!!
	protected jnlevel level;
	protected jnpill pills[] = new jnpill[nbPills];
	protected jnbullet bullets[] = new jnbullet[nbBullets];
	protected jnball balls[] = new jnball[nbBalls];
	protected jnpaddle paddle;
	
	// References
	Applet applet; 
	jnimageserver imageSrv;
	jnsoundserver soundSrv;
	jnstatus status;
	
	// Constructor
	public jngame (Applet a, jnimageserver i, jnsoundserver s, int w, int h) {
		// Canvas init
		super(a, w, h);
		imageSrv = i; soundSrv = s; 
		// Status init	
		status = new jnstatus(this, imageSrv, scoreAlt, displayAlt);
		}
		
	// Start in demo or game mode
	void startGame(boolean d) {

		demoMode = d; goToNext = false; fireMode = false;
		
		// Level init
		level = new jnlevel(imageSrv, soundSrv, this, status);
		// Paddle init
		paddle = new jnpaddle(imageSrv, soundSrv, this, paddleAlt, true);
		// Ball init
		balls[0] = new jnball(imageSrv, soundSrv, this, level, paddle);
		// Status init
		status.reset();
		
		// Automatic start or level name display
		if (demoMode) { status.showHiScore(); balls[0].launch(); }
		else status.showName(level.getName());
		}

	// End level
	void stopGame() {
		level = null; paddle = null;
		for (int i=0;i<nbBalls;i++) balls[i] = null;
		for (int i=0;i<nbPills;i++) pills[i] = null;
		for (int i=0;i<nbBullets;i++) bullets[i] = null;
		}
	
	// Ball launch
	public void launchBall() { 
		if (!demoMode) {
			if (fireMode) throwBullet(paddle.getX() + paddle.getWidth() / 2, paddle.getY());
			else { 
				status.hideName(); 
				for (int i=0;i<nbBalls;i++) { 
					if ((balls[i]!=null) && (!balls[i].isLaunched())) balls[i].launch(); 
					}
				}
			}
		}

	// Jump to next level
	public void jumpNext	()	{ if (demoMode) goToNext = true; }

	// Paddle move
	public void movePaddle (int x) { if ((!demoMode) && (paddle!=null)) paddle.followMouse(x); }

	// Pill events
	public void pillEvent (int v) {
		// Reseting objects	
		paddle.setNormal(); fireMode = false;
		for (int i=0;i<nbBalls;i++) { 
			if (balls[i]!=null) {
				balls[i].setKiller(false);
				balls[i].setGlue(false);
				if (!balls[i].isLaunched()) { balls[i].launch(); }
				}
			}
		switch(v) {
			// Set multi-ball mode		
			case 0: throwMultiBall(); 
				break;
			// Set fire mode
			case 1: paddle.setFire(); fireMode = true; 
				break;
			// Set glue mode
			case 2: for (int i=0;i<nbBalls;i++) { if (balls[i]!=null) balls[i].setGlue(!demoMode); } 
				break;
			// Set big paddle				
			case 3: paddle.setBig(); 
				break;
			// Set small paddle
			case 4: paddle.setSmall(); 
				break;
			// Add bonus life, bonus score or gives super ball !
			case 5: switch((int)(4 * Math.random())) {
				case 0: status.addLife(); 	
					break;
				case 1: for (int i=0;i<nbBalls;i++) { if (balls[i]!=null) balls[i].setKiller(true); } 
					break;
				default: status.addBonus(); 
					break;
				}
				break;											
			}
		}

	// Next level
	void nextLevel() {
		for (int i=0;i<nbPills;i++) pills[i] = null;
		for (int i=0;i<nbBullets;i++) bullets[i] = null;
		for (int i=0;i<nbBalls;i++) balls[i] = null;
		level.next(); goToNext = false;
		// New ball & paddle reset
		balls[0] = new jnball(imageSrv, soundSrv, this, level, paddle); 
		paddle.setNormal(); fireMode = false; 
		// Automatic start or level name display whether demo or not
		if (demoMode) balls[0].launch();
		else status.showName(level.getName());
		}

	// Ball lost
	void ballLost(int j) {
		balls[j]=null;
		if (j==0) {
			boolean found = false;
			for (int i=1;i<nbBalls;i++) {
				if ((balls[i]!=null) && (!found)) { balls[0]=balls[i]; balls[i]=null; found = true; }
				}
			if (!found) {
				for (int i=0;i<nbPills;i++) pills[i] = null;
				for (int i=0;i<nbBullets;i++) bullets[i] = null;
				status.removeLife();
				// Back to demo mode...
				if (status.getLives() < 0) { stopGame(); startGame(true); }
				// Another chance !
				else {
					balls[0] = new jnball(imageSrv, soundSrv, this, level, paddle);
					paddle.setNormal(); fireMode = false;
					}
				}
			}
		}

	// Pill throwing
	void throwPill(int x, int y) {
		int i = 0; int v = (int)(nbPillValues * Math.random());
		while ((i<nbPills) && (pills[i]!=null)) i++; 
		if (i<nbPills) pills[i] = new jnpill(imageSrv, soundSrv, this, v, x, y, paddle);
		}

	// Bullet throwing
	void throwBullet(int x, int y) {
		int i = 0; 
		while ((i<nbBullets) && (bullets[i]!=null)) i++; 
		if (i<nbBullets) bullets[i] = new jnbullet(imageSrv, soundSrv, this, x, y, level);
		}

	// MultiBallThrowing
	void throwMultiBall() {
		for (int i=1;i<nbBalls;i++) {
			if (balls[i]==null) {
				balls[i] = new jnball(imageSrv, soundSrv, this, level, paddle, balls[0], i);
				}
			}
		}

	// Main part of javanoid ! Controls objects' life & death !
	public void live() { 

		// Level is cleared
		if (((level!=null) && (level.isEmpty())) || goToNext) nextLevel();
		// Paddle move
		if (paddle != null) {
			if (demoMode) { paddle.followBall(balls[0].getX() + balls[0].getWidth() / 2); }	
			paddle.live();	
			}
		// Ball move
		for (int i=0;i<nbBalls;i++) { 	
			if (balls[i] != null) {
				if (balls[i].isAlive()) balls[i].live();
				else ballLost(i);
				}
			}
 		// Pills move
		for (int i=0;i<nbPills;i++) {
			if (pills[i] != null) {
				if (pills[i].isAlive()) pills[i].live();
				else pills[i]=null;
				}
			}
		// Bullets move
		for (int i=0;i<nbBullets;i++) {
			if (bullets[i] != null) {
				if (bullets[i].isAlive()) bullets[i].live();
				else bullets[i]=null;
				}
			}
		}
		
	// Unlock balls when no solutions
	public void unlock() {
		for (int i=0;i<nbBalls;i++) { if (balls[i]!=null) balls[i].setRandomDX(); }
		}

	// Mouse down & move events
	public boolean mouseMove(Event evt, int x, int y) { 
		movePaddle(x); return true; 
		}
	public boolean mouseDown(Event evt, int x, int y) {
		requestFocus(); 
		if (demoMode) { stopGame(); startGame(false); }
		else launchBall();
		return true;
		}
	}

// ## JAVANOID STATUS CLASS #############################################
// This class maintains and displays the state of the game (score, lives 
// & level). It the specialist for string displays. It may be extended for 
// displays such as game loading or instructions.

final class jnstatus {

	// strings for display
	final static String appletString1 = "JAVANOID V1.45";
	final static String appletString2 = "by Rmi Faitout";
	final static String scoreString = "SCORE : ";
	final static String levelString = "LEVEL : ";
	final static String livesString = "LIVES : ";
	final static String hiScoreString = "HIGH SCORE :";
	// default game settings
	final static int nbLives = 2;	
	final static int maxLives = 5;
	final static int lifeSize = 12;
	final static int hitScore = 10;
	final static int bonusScore = 100;
	final static int levelScore = 500;
	// status values
	protected int hiScore = 1000; 
	protected int score = 0;
	protected int lives = 0;
	protected int level = 0;
	// String positions	
	protected int scoreX, scoreXX, livesX, livesXX, levelX, namesX;
	protected int statusY, textY, namesY;
	protected int width, height;	
	protected int livesWidth, scoreWidth, levelWidth;
	// display the level name or not	
	protected boolean nameDisplay;
	
	jnbuffer buffer;
	jnimageserver imageSrv;
	
	// Constructor
	public jnstatus(jnbuffer c, jnimageserver i, int alt1, int alt2 ) {
		buffer = c;
		imageSrv = i;
		width = buffer.getWidth();
		height = buffer.getStringHeight();
		
		livesX = 1 * width / 18; 
		levelX = 8 * width / 18; 
		scoreX = 13 * width / 18; 
		namesX = width / 2;
		livesXX = livesX + buffer.getStringWidth(livesString);
		scoreXX = scoreX + buffer.getStringWidth(scoreString);
		statusY = buffer.getHeight() - alt1;
		namesY = buffer.getHeight() - alt2;
		nameDisplay = false;
		}
			
	// Actions on the status : add or remove
	public void addLife() { 
		if (lives<maxLives) buffer.drawPermanentImage(imageSrv.ballImage(0), livesXX + lives * lifeSize, statusY); 
		lives++;  
		}
	public void removeLife() { lives--; set();}
	public void addLevel() { level++; score+=levelScore; set();}
	public void addScore() { score+=hitScore; setScore();}
	public void addBonus() { score+=bonusScore; set(); }

	// hiding or showing the level name
	public void showName(String s) {
		nameDisplay = true;
		buffer.drawPermanentString(s, namesX - buffer.getStringWidth(s) / 2, namesY + height);
		}
	public void hideName() {
		if (nameDisplay) buffer.clearPermanentImage(0, namesY, width, height);
		}
	public void showHiScore() {
		String s1 = appletString1;
		String s2 = appletString2; 
		String s3 = hiScoreString + hiScore;
		int h = (int)(height/2);
		buffer.drawPermanentString(s1, namesX - buffer.getStringWidth(s1) / 2, namesY - 2*h);
		buffer.drawPermanentString(s2, namesX - buffer.getStringWidth(s2) / 2, namesY + h);
		buffer.drawPermanentString(s3, namesX - buffer.getStringWidth(s3) / 2, namesY + 5*h);		
		}

	// reset & set (partial or not) : Draw the status on the buffer
	public void reset() { 
		if (score > hiScore) hiScore = score;
		lives = nbLives; level = 1; score = 0; set();
		}
	void set() {
		buffer.clearPermanentImage(0, statusY, width, height);
		buffer.drawPermanentString(livesString, livesX, statusY + height);
		for (int i=0;i<lives;i++) { 
			if (i<maxLives) buffer.drawPermanentImage(imageSrv.ballImage(0), livesXX + i * lifeSize, statusY); 
			}
		buffer.drawPermanentString(levelString + level, levelX, statusY + height);
		buffer.drawPermanentString(scoreString + score, scoreX, statusY + height);
		}
	void setScore() {
		buffer.clearPermanentImage(scoreXX, statusY, width - scoreXX, height);
		buffer.drawPermanentString(String.valueOf(score), scoreXX, statusY + height);
		}

	public int getLives() { return lives; }
	}

// ## JAVANOID LEVEL CLASS ##############################################
// The aim of this class is to define the map level and to give fast 
// access to a particular block with its (x,y) coordinates. It's both a 
// level builder and a level map

final class jnlevel {

	// default attributes
	final static int nbRow = 8;
	final static int nbCol = 10;
	final static int nbLevel = 20;
	final static int colWidth = 32;
	final static int rowHeight = 20;

	// level names	
	final static String names[] = 
		{"CLASSIC LEVEL N1", "GHOST LEVEL", "COFFEE CUP LEVEL", "BEE LEVEL",
		 "CLASSIC LEVEL N2", "BUBBLE BOBBLE LEVEL", "SUPER SPRINT LEVEL", "ARKANOID LEVEL",
		 "CLASSIC LEVEL N3", "PACMAN LEVEL", "R-TYPE LEVEL", "ASTEROIDS LEVEL",
		 "CLASSIC LEVEL N4", "CHUCK YEAGER LEVEL", "COMMANDO LEVEL", "UMBRELLA LEVEL",
		 "CLASSIC LEVEL N5", "TIE-FIGHTER LEVEL", "CENTIPEDE LEVEL", "BLACK BOX LEVEL"};	
	// level definitions		
  final static String blockLevel[][] = {
	 	// Level 01 : Classic 1
		{"FFFFFFFFFF", "FFFFFFFFFF", "AAAAAAAAAA", "6666666666", 
		 "3333333333", "2222222222", "0000000000", "FFFFFFFFFF"},
		// Level 02 : Ghost
		{"FF77777FFF", "F7777777FF", "F7227227FF", "F7297297FF",
		 "F7297297FF", "F7777777FF", "F7A7A7A7FF", "FAFAFAFAFF"},
		// Level 03 : Coffee cup (!)
		{"FAA9A9AFFF", "FFA9AAFFFF", "FFFA9FFFFF", "F444444FFF", 
		 "F45556444F", "F455564F4F", "F4666644FF", "FF4444FFFF"},
		// Level 04 : Bee
		{"F555FFFFFB", "44445FFFBF", "444445F99F", "F244445909",
		 "9292929999", "929292999F", "F2A2A2AFFF", "FFAFAFFAFF"},
  	// Level 05 : Classic 2 (squares)
		{"FFFFFFFFFF", "FAAAFFAAAF", "F012FF678F", "F120FF786F",
		 "F201FF867F", "F012FF678F", "F120FF786F", "FAAAFFAAAF"},
		// Level 06 : Bubble Bobble
		{"FF1F1F1F1F", "F1B1B1B1FF", "1B3333553F", "F13333593F",
		 "1B3333333F", "F13333399F", "1B3333333F", "F1AAAAAAAF"},
  	// Level 07 : Super Sprint
		{"FF000000FF", "F99000099F", "F99044099F", "FF045540FF",
		 "FF000000FF", "F990AA099F", "F9A2222A9F", "F9A2222A9F"},
		// Level 08 : Arkanoid
		{"FFFFFFFFFF", "FFFFFFA9FF", "FFFFFF99FF", "FFFFFFFFFF",
		 "FB1AAAAB1F", "B104444100", "100AAAA100", "F00999900F"},
		// Level 09 : Classic 3 (gold lines)
		{"FFFFFFFFFF", "F01234567F", "FBBBBBBBBF", "FFFFFFFFFF",
		 "F01234567F", "FBBBBBBBBF", "FFFFFFFFFF", "AAAAAAAAAA"},
 		// Level 10 : Pacman
		{"FFFBBBBBFF", "FFB19911BF", "FB119911FF", "FB11111FFF",
		 "FB11111FFF", "FB111111FF", "FFB11111BF", "FFFBBBBBFF"},
		// Level 12 : R-Type
		{"FFFF555FFF", "FAAA66655F", "ABBA666665", "AAAA666665",
		 "ABBBB66665", "AAAAAA666F", "F9AAA9AFFF", "9F9FF999BF"},
		// Level 12 : Asteroids
		{"F3FFA9FF3F", "FAFFA9FFAF", "FFFAA99FFF", "FFFAA99FFF",
		 "FFAA1199FF", "FFA1BB19FF", "FFFA119FFF", "FFFFA9FFFF"},
 		// Level 13 : Classic 4 (staggered rows)
 		{"8F7F6F4F3F", "AFAFAFAFAF", "F8F7F6F4F3", "FAFAFAFAFA",
		 "0F8F7F6F4F", "BFBFBFBFBF", "F0F8F7F6F4", "FBFBFBFBFB"},
		// Level 14 : Chuck Yeager
		{"FFFFAAFFFF", "FFF995AFFF", "FF9A55AFFF", "FFFA99AFFF",
		 "ABAA99AABA", "FAAA99AAAF", "FFFFAAF9FF", "FFFFF99FFF"},
		// Level 15 : Commando
		{"FFFF33FFFF", "FFF3333F9F", "FFFB33B9FF", "FF33BB33FF",
		 "FFB3333BFF", "FFF3333FFF", "FFFBB33FFF", "FFFFFBBFFF"},
		// Level 16 : Umbrella
		{"FFF0236FFF", "F00223366F", "0002233666", "0002233666",
		 "FFFFAAFFFF", "FFFFAAFFFF", "FFBFBBFFFF", "FFFBBFFFFF"},
		// Level 17 : Classic 5 (labyrinth)
		{"BBBBBBBBBB", "B1FB1FF1FB", "B2FB2FF2FB", "B3FB3FB3FB", 
		 "B4FB4FB4FB", "B5FF5FB5FB", "B6FF6FB6FB", "BBBBBBBFFB"},
		// Level 18 : Tie-fighter
		{"FFBFFFFBFF", "FBFFAAFFBF", "FBFA99AFBF", "FBAA99AABF",
		 "FBAA99AABF", "FBFA99AFBF", "FBFFAAFFBF", "FFBFFFFBFF",},
		// Level 19 : Centipede
		{"F22F22FFFF", "233244222F", "233B44B552", "F2BF22B552",
		 "FFFFBBF22F", "FFFB772662", "FFFB772662", "FFFFBBFBBF",},
		// Level 20 : Black box
		{"B2B2B2B2BB", "299999999B", "B92B2B2B92", "29B999929B", 
		 "B929999B92", "29B2B2B29B", "B999999992", "2B2B2B2B2B",}
		};

	// how many blocks still here ??	
	protected int blocksLeft;	
	// the current level & its map
	protected int number;
	protected jnblock blockMap[][] = new jnblock[nbCol][nbRow];
	
	jnimageserver imageSrv;
	jnsoundserver soundSrv;
	jngame game;
	jnstatus status;
	
	// constructor
	public jnlevel (jnimageserver is, jnsoundserver ss, jngame g, jnstatus s) {
		imageSrv = is; soundSrv = ss;
		game = g; status = s;
		number = 0; 
		clear(); compute();
		}

	// next level method (clear the old one & compute) 
	public void next() { clear(); number++; status.addLevel(); compute(); }

	// Level clear & compute
	void clear() { 
	  game.clearBackground();
		for (int y=0;y<nbRow;y++) { for (int x=0;x<nbCol;x++) { blockMap[x][y] = null; } }
		}
	void compute() {
		char ch;
		char blockRow[] = new char[nbCol];
		blocksLeft = 0;
		number = number % nbLevel;
		for (int r=0;r<nbRow;r++) {
			blockRow = blockLevel[number][r].toCharArray();
			for (int c=0;c<nbCol;c++) {
				ch = blockRow[c];
				switch(ch) {
					case 'F': blockMap[c][r] = null; 
						break;
				  case 'B':	blockMap[c][r] = new jnblock(imageSrv, soundSrv, game, 11, c, r); 
						break; 
					case 'A': blockMap[c][r] = new jnblock(imageSrv, soundSrv, game, 10, c, r); 
						blocksLeft++; break;
					default : blockMap[c][r] = new jnblock(imageSrv, soundSrv, game, ch - '0', c, r); 
						blocksLeft++; break;
					}
				}		
			}
		}

	// Collision detection & effects for blocks
	public jnblock block(int x, int y) {
		int c = x / colWidth; int r = y / rowHeight; 
		if ((c<nbCol) && (r<nbRow)) return blockMap[c][r];
		else return null;
		}
	public boolean hitBlock(int x, int y, boolean kill) { 
		int c = x / colWidth; int r = y / rowHeight;
		boolean found = ((c<nbCol) && (r<nbRow) && (blockMap[c][r]!=null));
		if (found) {
			if (kill) {
				if (blockMap[c][r].kill()) {
					status.addScore(); 
					blocksLeft--; 
					if (Math.random()<0.3) game.throwPill(x, y);
					}
				blockMap[c][r] = null;
				}
			else if (blockMap[c][r].hit()) { 
				status.addScore(); 
				blocksLeft--; 
				blockMap[c][r] = null;
				if (Math.random()<0.3) game.throwPill(x, y);
				}
			}
		return ((found) && (!kill));
		}		

	// Requests methods (level number & name, empty or not)
	public boolean isEmpty() { return (blocksLeft == 0); }
	public int getNumber() { return number; }
	public String getName() { return names[number]; }
	}
		
// ## JAVANOID BALL CLASS ###############################################
// This class represents the balls in the game : they are moving object 
// that have a really hard life (paddle & block collisions)

final class jnball extends jnmovingobject {

	final static int defaultSpeed = 6;		// default attributes
	final static int defaultWidth = 12;
	final static int defaultHeight = 12;
	final static int defaultImage = 0;
	
	protected int speed;									// ball speed (speed^2 = dx^2 + dy^2)
	protected boolean launched = false;		// when not launched, follow the paddle
	protected boolean glueMode = false;		// glue mode : wait for user for launch
	protected boolean killMode = false;		// kill mode : go through all blocks
	protected int defaultDX = 3; 					// Default direction for launch
	protected int posX = 0, posY = 0;			// position on the paddle when not launched

	jnsoundserver soundSrv;
	jnimageserver imageSrv;
	jnlevel level;
	jnpaddle paddle;
	
	// Constructors (normal + for multiball mode)
	public jnball(jnimageserver i, jnsoundserver s, jngame c, jnlevel l, jnpaddle p) {
		super(c, i.ballImage(0), defaultWidth, defaultHeight, p.getX() + p.getWidth() / 2, 
			p.getY() - defaultHeight, 0, 0);
		imageSrv = i; soundSrv = s;
		level = l; paddle = p;
		speed = defaultSpeed;
		posX = (paddle.getWidth() - width) / 2; 
		posY = - height;
		}
	public jnball(jnimageserver i, jnsoundserver s, jngame c, jnlevel l, jnpaddle p, jnball b, int n) {
		super(c, i.ballImage(0), defaultWidth, defaultHeight, b.getX(), b.getY(), 0, 0);
		imageSrv = i; soundSrv = s;
		level = l; paddle = p;
		speed = defaultSpeed;
		posX = (paddle.getWidth() - width) / 2; 
		posY = - height;
		if (n==1) setBallDX(b.getDX() + 1, (b.getDY()<0));
		else setBallDX(b.getDX() - 1, (b.getDY()<0)); 
		launched = true;
		}

	// ball launch & live methods
	public void launch() { 
		if (!glueMode) { soundSrv.playStart(); setBallDX(defaultDX, true); }
		launched = true; 
		}
		
	// ball life (paddle & block detection)
	public void live() {
		int oldX = X; int oldY = Y;

		// follow paddle when not launched
		if (!launched) { X = paddle.getX() + posX; Y = paddle.getY() + posY; }
		
		super.live();																						// Ball movement

		if (launched) {
			if (dY > 0) {
				if (paddle.isHit(X + width / 2, Y + height)) {   						// Paddle hit 
					if (glueMode) { 
						launched = false; posX = X - paddle.getX(); posY = Y - paddle.getY(); 
						}
					setBallDX(paddle.hit(X + width / 2, dX, speed), true); 
					}
				else if (level.hitBlock(X + width / 2, Y + height, killMode)) invertDY();
				}
			else if (level.hitBlock(X + width / 2, Y, killMode)) invertDY(); 
			if (dX < 0) { 
				if (level.hitBlock(X, Y + height / 2, killMode)) invertDX();	 
				}
			else if (level.hitBlock(X + width, Y + height / 2, killMode)) invertDX(); 
			}
		}
	
	// Ball settings
	public void setBallDX (int d, boolean b) { 
		dX = d; dY = (int)(Math.max(Math.sqrt((double)(speed * speed - dX * dX)), 1));
		if (b) dY = - dY; 
		}
	public void setSpeed (int s) { speed = s; }
	public void setGlue (boolean g) { glueMode = g; }
	public void setKiller (boolean g) { 
		killMode = g; 
		if (killMode) change(imageSrv.ballImage(1), defaultWidth, defaultHeight);
		else change(imageSrv.ballImage(0), defaultWidth, defaultHeight);
		}
	public void setRandomDX() { 
		setBallDX((int)((speed - 1) * (2 * Math.random() - 1)), false);
		}
	// Ball requests
	public int getSpeed() { return speed; }
	public boolean isLaunched() { return launched; }
	}

// ## JAVANOID PILL CLASS ###############################################
// This class represents the pills in the game : They are moving objects 
// with a value that gives their effects on the game when they're catched 
// by the paddle

final class jnpill extends jnmovingobject {

	final static int defaultSpeed = 3;		// default attributes
	final static int defaultWidth = 16;
	final static int defaultHeight = 8;
	
	protected int pillValue;						// Determines the effect

	jnsoundserver soundSrv;
	jngame game;
	jnpaddle paddle;
	
	// Constructor
	public jnpill(jnimageserver i, jnsoundserver s, jngame c, int v, int bx, int by, jnpaddle p) {
		super(c, i.pillImage(v), defaultWidth, defaultHeight, bx, by, 0, defaultSpeed);
		soundSrv = s; paddle = p; game = c;
		pillValue = v;
		}

	// Pill life (paddle detection + dies when at the top of the screen)
	public void live() {
		super.live();																									// Pill movement
		if (paddle.isHit(X + width / 2, Y + height)) { 								// Paddle hit 
			soundSrv.playHit(); game.pillEvent(pillValue); die(); 
			}
		}
	}
	
// ## JAVANOID BULLET CLASS #############################################
// This class represents the paddle bullets : They are very similar to 
// pills except they move from bottom to top and hit the blocks.

final class jnbullet extends jnmovingobject {

	final static int defaultSpeed = 6;
	final static int defaultWidth = 4;
	final static int defaultHeight = 6;
	jnsoundserver soundSrv;
	jnlevel level;
	
	// Constructor
	public jnbullet(jnimageserver i, jnsoundserver s, jngame c, int px, int py, jnlevel l) {
		super(c, i.bulletImage(0), defaultWidth, defaultHeight, px, py, 0, - defaultSpeed);
		soundSrv = s; level = l;
		}

	public void live() {
		super.live();
		if ((dY > 0) || (level.hitBlock(X + width / 2, Y, false))) { die(); }
		}
	}

// ## JAVANOID PADDLE CLASS #############################################
// This class represents the paddle in the game : It a 'static' object 
// that can be moved to a position (ex : mouse position). It gives the 
// direction of the ball it hits, and has different aspects and attitudes 
// (small, large, firing)

final class jnpaddle extends jnobject {

	final static int defaultWidth = 40;			// default attributes
	final static int defaultWidthBig = 48;
	final static int defaultWidthSmall = 32;
	final static int defaultHeight = 12;
	final static int defaultImage = 0;

	protected int minX, maxX;	
	protected int newX;									// Mouse position save 
	protected boolean demo;
	
	jnsoundserver soundSrv;
	jnimageserver imageSrv;

	// Constructor
	public jnpaddle (jnimageserver i, jnsoundserver s, jngame c, int alt, boolean d) { 
		super(c, i.paddleImage(0), defaultWidth, defaultHeight, (c.getWidth() - defaultWidth) / 2, 
			c.getHeight() - alt);
		imageSrv = i; soundSrv = s;
		minX = 0; maxX = c.getWidth() - defaultWidth;
		newX = X;
		demo = d;
		}

	// Paddle life (move to the saved position)
	public void live() { setX(newX); super.live();	}
	
	// Paddle settings
	public int hit(int bx, int bdx, int s) {
		int ndx = 2 * s * (bx - X - width / 2) / width; 
		soundSrv.playTouch(); 
		return (ndx==0) ? bdx : ndx;
		}

	// methods of controls
	public void followBall (int bx) { newX = bx - width / 2; }
	public void followMouse (int mx) { newX = mx - width / 2; }
	public void followArrows (int dx) { newX = newX + dx; }
	
	// paddle settings
	public void setNormal() { change(imageSrv.paddleImage(0), defaultWidth, defaultHeight); }
	public void setSmall () { change(imageSrv.paddleImage(1), defaultWidthSmall, defaultHeight); }
	public void setBig () { change(imageSrv.paddleImage(2), defaultWidthBig, defaultHeight); }
	public void setFire () { change(imageSrv.paddleImage(3), defaultWidth, defaultHeight); }
	}
	
// ## JAVANOID BLOCK CLASS ##############################################
// Blocks are basic 'static object', except they die after a certain 
// number of hits. As they don't move at all, they are drawn or erased on 
// the third buffer

final class jnblock extends jnobject {

	final static int defaultWidth = 32;
	final static int defaultHeight = 20;
	final static int defaultImage = 0;
	// i.e. nb hits before it dies
	protected int resistance;	
	// position in the level	
	protected int column, row;
	
	jnsoundserver soundSrv;
	jnimageserver imageSrv;
	
	// Constructor
	public jnblock (jnimageserver i, jnsoundserver s, jngame c, int color, int col, int row) {
		super(c, i.blockImage(color), defaultWidth, defaultHeight, col * defaultWidth, row * defaultHeight);
		imageSrv = i; soundSrv = s;
		if (color==11) { resistance = -1; }					// The resistance is linked to the color
		else if (color==10) { resistance = 2; }
		else { resistance = 0; }
		}

	// Life : no drawing there !!!
	public void live() {}	
	
	// Blocks are "permanent" images --> draw on the background & erase
	public void draw() { buffer.drawPermanentImage(image, X, Y); }
	public void clear() { buffer.clearPermanentImage(X, Y, width, height); }

	// death depends on resistance
	public void die() { 
		if (resistance==0) { clear(); super.die(); } 
		else { resistance--;} 
		}
	
	// hit method (tells if it dies or not)
	public boolean hit() { 
		die(); 
		if (alive) { soundSrv.playTouch(); } else { soundSrv.playHit(); } 
		return alive ? false : true;
		}
	// kill method (dies & tells if it's a gold one)
	public boolean kill() { 
		clear(); 
		super.die(); 
		return (resistance >= 0); 
		}
	}
	
// ## JAVANOID BUFFER CLASS #############################################
// this class implements a sort of triple buffer : 1 for the background 
// image & the objects that you draw for a long time, 1 where the moving 
// objects are drawn, and 1 for display (see update method).

abstract class jnbuffer extends Canvas {

	// Width & height of the game canvas
	protected int width;
	protected int height;
	
	Applet applet;
	// On & off graphics for triple (!) buffering
	Graphics offGraphics, offBackGraphics;
	// Fontmetrics object
	FontMetrics fontMetrics;
	// Buffer & background images
	Image offImage, offBackImage, backImage;
	Dimension minSize;
	// Color for texts & background
	Color textColor = new Color (255, 223, 0);
	Color backColor = new Color (0, 0, 0);
	
	// Constructor
	public jnbuffer (Applet a, int w, int h) { 
		applet = a; 
		width = w; height = h;

		// Off images & graphics
		offImage = applet.createImage(width, height);
		offBackImage = applet.createImage(width, height);
		offGraphics = offImage.getGraphics();
		offBackGraphics = offBackImage.getGraphics();
		minSize = new Dimension(width, height);
		resize(width, height);

		fontMetrics = offGraphics.getFontMetrics();

		computeBackground(); clearBackground();
		}

	// Compute background image
	void computeBackground() {
		int[] pix = new int[width * height];
		int index = 0;
		for (int j=0;j<height;j++) {
			int blue = 255 * j / (height - 1);
			for (int i=0;i<width;i++) {
				int red = 255 * i / (width - 1);
				pix[index++] = (255 << 24) | (red << 16) | blue;
				}
			}
		backImage = applet.createImage(new MemoryImageSource(width, height, pix, 0, width));
		}

	public void drawImage(Image i, int x, int y) {
		offGraphics.drawImage(i, x, y, this);
		}
	public void drawString(String s, int x, int y) {
		offGraphics.setColor(textColor);
		offGraphics.drawString(s, x, y);
		}
	public void drawPermanentString(String s, int x, int y) {
		offBackGraphics.setColor(textColor);
		offBackGraphics.drawString(s, x, y);
		}
	public void drawPermanentImage (Image i, int x, int y) {
		offBackGraphics.drawImage(i, x, y, this);
		}
	public void clearPermanentImage (int x, int y, int w, int h) {
		// With JDK1.1, it should be 
		// offBackGraphics.drawImage(backImage, x, y, x + w, y + h, x, y, x + w, y + h, this);
		Graphics tempGraphics = offBackImage.getGraphics();
		tempGraphics.clipRect(x, y, w, h);
		tempGraphics.drawImage(backImage, 0, 0, this);
		}
	public void clearBackground() {
		if (offBackGraphics==null) offBackGraphics = offBackImage.getGraphics();
		offBackGraphics.drawImage(backImage, 0, 0, this);
		}		

	// Update & paint methods
	public void paint(Graphics g) { update(g); }
	public void update(Graphics g) {
		if (g==null) g = this.getGraphics();
		g.drawImage(offImage, 0, 0, this);
		if (offGraphics==null) offGraphics = offImage.getGraphics(); 
		offGraphics.drawImage(offBackImage, 0, 0, this);
		}

	// Dimension functions
	public int getStringWidth(String s) { return fontMetrics.stringWidth(s); }
	public int getStringHeight() { return fontMetrics.getHeight(); }
	public int getStringAscent() { return fontMetrics.getAscent(); }
	public int getWidth() { return width; }
	public int getHeight() { return height; }
	// Canvas resizing methods
	public Dimension preferredSize() { return minimumSize(); }
	public synchronized Dimension minimumSize() { return minSize; }
	}
	
// ## JAVANOID MOVING OBJECT ############################################
// A javanoid moving object is an object that moves by itself. It has dX 
// & dY values that give its movement in relative coordinates

abstract class jnmovingobject extends jnobject {

	// Initial & current movement of the object
	protected int dX0, dY0;
	protected int dX, dY;

	// Constructor
	public jnmovingobject(jnbuffer c, Image i, int w, int h, int x, int y, int dx, int dy) {
		super(c, i, w, h, x, y);
		dX0 = dx; dY0 = dy;
		dX = dx; dY = dy;
		}
	public void die() { dX = 0; dY = 0; super.die(); }

	// Object movement settings
	public void setX(int x) {
		if (x > maxX) { X = maxX; invertDX(); } 
		else if (x < minX) {X = minX; invertDX(); }
		else X = x;
		}
	public void setY(int y) {
		if (y > maxY) die();  
		else if (y < minY) { Y = minY; invertDY(); }
		else Y = y;
		}
	public void setDXDY(int dx, int dy) { dX = dx; dY = dy; }
	public void setDX(int dx) { dX = dx; }
	public void setDY(int dy) { dY = dy; }
	public void invertDXDY() { dX = - dX; dY = - dY; } 
	public void invertDX() { dX = - dX; }
	public void invertDY() { dY = - dY; }
	public void reset() { dX = dX0; dY = dY0; super.reset(); }

	// Object life : move + drawing (dies when at the bottom of the screen) 
	public void live() { 
		if (alive) {
			setX(X + dX); 
			setY(Y + dY); 
			draw();
			}
		}

	// Object requests
	public int getDX() { return dX; }
	public int getDY() { return dY; }
	}

// ## JAVANOID OBJECT ###################################################
// It's the basic object of javanoid. Though it doesn't move by itself, 
// it can be moved to absolute coordinates (ex: the paddle, which moves 
// to the position of the mouse pointer). A javanoid object lives (i.e. 
// is on the screen) & dies when it touches the bottom

abstract class jnobject extends Object {

	// Width & height of the object
	protected int width, height;
	// Initial & current position of the object
	protected int X0, Y0;	
	protected int X, Y;
	// X & Y limits for the canvas
	protected int minX, maxX;
	protected int minY, maxY;
	// Tells if the object is still alive
	protected boolean alive;

	// The buffer where the object is drawn
	jnbuffer buffer;
	// The bitmap image of the object	
	Image image;

	// Constructor
	public jnobject(jnbuffer c, Image i, int w, int h, int x, int y) {
		buffer = c;
		image = i; width = w; height = h;
		X0 = x; Y0 = y;
		X = x; Y = y;
		minX = 0; maxX = buffer.getWidth() - width;
		minY = 0; maxY = buffer.getHeight() - height;
		alive = true;
		draw();
		}

	// Object position settings
	public void setXY(int x, int y) { setX(x); setY(y); }
	public void setX(int x) {
		if (x > maxX) X = maxX;  
		else if (x < minX) X = minX;
		else X = x;
		}
	public void setY(int y) {
		if (y > maxY) Y = maxY;  
		else if (y < minY) Y = minY;
		else Y = y;
		}
	public void reset() { X = X0; Y = Y0; }

	// Object drawing & erasing
	public void draw() { buffer.drawImage(image, X, Y); }

	// Objet life (what he does until he's dead)
	public void live() { if (alive) draw(); }

	// Object death
	public void die() { alive = false; }

	// Collision detection
	public boolean isHit(int x, int y) { 
		return (alive) && (x > X) && (x < X + width) && (y > Y) && (y < Y + height); 
		}
	
	// Object graphic changes
	public void change(Image i, int w, int h) {
		image = i; width = w; height = h;
		minX = 0; maxX = buffer.getWidth() - width;
		minY = 0; maxY = buffer.getHeight() - height;
		}
	
	// Object requests
	public boolean isAlive() { return alive; }
	public int getWidth() { return width; }
	public int getHeight() { return height; }
	public int getX() { return X; }
	public int getY() { return Y; }
	}
		
// ## JANAVOID IMAGE SERVER CLASS #######################################
// This class loads the graphics in a single file to reduce loading time 
// & is used as an image server for all the other objects

final class jnimageserver {

	// Name of the images file
	final static String imageFile = "javanoid.gif";

	// Number of images per object
	final static int nbBallImg = 2;	
	final static int nbPaddleImg = 4;
	final static int nbBlockImg = 12;					
	final static int nbPillImg = 6;
	final static int nbBulletImg = 1;

	// Size & coordinates of the images
	final static int ballCoords[][] = { 
		{0, 88, 12, 12}, {12, 88, 12, 12} };
	final static int blockCoords[][] = { 
		{0, 0, 32, 20}, {0, 20, 32, 20}, {0, 40, 32, 20}, {0, 60, 32, 20}, 
		{32, 0, 32, 20}, {32, 20, 32, 20}, {32, 40, 32, 20}, {32, 60, 32, 20},
		{64, 0, 32, 20}, {64, 20, 32, 20}, {64, 40, 32, 20}, {64, 60, 32, 20} };
	final static int paddleCoords[][] = { 
		{24, 88, 40, 12}, {64, 88, 32, 12}, {0, 108, 48, 12}, {48, 108, 40, 12} };
	final static int pillCoords[][] = {
		{0, 122, 16, 8}, {16, 122, 16, 8}, {32, 122, 16, 8}, {48, 122, 16, 8}, 
		{64, 122, 16, 8}, {80, 122, 16, 8} };
	final static int bulletCoords[][] = {
		{88, 114, 4, 6} };

	// Arrays for images
	protected Image ballImg[] = new Image[nbBallImg];
	protected Image paddleImg[] = new Image[nbPaddleImg];
	protected Image blockImg[] = new Image[nbBlockImg];
	protected Image pillImg[] = new Image[nbPillImg];	
	protected Image bulletImg[] = new Image[nbBulletImg];

	Applet applet;
	MediaTracker tracker;
	String imageRep;
	
	// Constructor
	public jnimageserver (Applet a) { applet = a; }
	
	// ImageServer initialization
	public void init() {
		tracker = new MediaTracker(applet);
		URL url = applet.getCodeBase();
		
		// All graphics are loaded in a single file
		Image imageTmp = applet.getImage(url, imageFile);
		tracker.addImage(imageTmp, 0);

		// Extraction for images
		extractImages(ballImg, imageTmp, nbBallImg, ballCoords);
		extractImages(paddleImg, imageTmp, nbPaddleImg, paddleCoords);
		extractImages(blockImg, imageTmp, nbBlockImg, blockCoords);
		extractImages(pillImg, imageTmp, nbPillImg, pillCoords);
		extractImages(bulletImg, imageTmp, nbBulletImg, bulletCoords);

		try { tracker.waitForAll(); }
		catch (InterruptedException e) {}
		}


	// Extraction of the images
	public void extractImages(Image[] images, Image tmp, int n, int[][] coords) {
		ImageFilter filter;
		ImageProducer producer;
		for (int i=0;i<n;i++) {
			filter = new CropImageFilter(coords[i][0], coords[i][1], coords[i][2], coords[i][3]);
			producer = new FilteredImageSource(tmp.getSource(), filter);
			images[i] = applet.createImage(producer);
			tracker.addImage(images[i], 0);
			}
		}

	// ImageServer functions
	public Image paddleImage(int i) { if (i >= nbPaddleImg) i = 0; return paddleImg[i]; }
	public Image ballImage(int i) { if (i >= nbBallImg) i = 0; return ballImg[i]; }
	public Image blockImage(int i) { if (i >= nbBlockImg) i = 0; return blockImg[i]; } 
	public Image pillImage(int i) { if (i >= nbPillImg) i = 0; return pillImg[i]; } 
	public Image bulletImage(int i) { if (i >= nbBulletImg) i = 0; return bulletImg[i]; } 
	}

// ## JAVANOID SOUND SERVER CLASS #######################################
// This class loads and plays the sounds of javanoid

final class jnsoundserver {

	// Static strings for sounds filenames
	protected static String soundFiles[] = {"start.au", "wall.au", "shoot.au"};
	protected static int nbSounds = 3;

	protected boolean soundOn = false;
	protected int soundPlay;
	protected String soundRep;

	Applet applet;
	AudioClip sounds[] = new AudioClip[nbSounds];
	
	// Constructor
	public jnsoundserver(Applet a) { applet = a; }

	// SoundServer initialization (i.e. sounds loading)
	public void init() {
		URL url = applet.getCodeBase();
		for (int i=0;i<soundFiles.length;i++) {
			sounds[i] = applet.getAudioClip(url, soundFiles[i]);
			try { Thread.sleep(1000); } 
			catch (InterruptedException e) { }
			}
		}

	// Make SoundServer silent 
	public void silent() { for (int i=0;i<soundFiles.length;i++) sounds[i].stop(); }

	// Main soundServer method
	public void iterate() {
		if ((soundOn) && (soundPlay>=0)) {
			for (int i=0;i<nbSounds;i++) { sounds[i].stop(); }
			sounds[soundPlay].play();
			soundPlay = -1;
			}
		}
		
	// SoundServer On / Off
	public void on() {soundOn = true;}
	public void off() {if (soundOn) {soundOn = false; silent();} }
	public void toggle() { if (soundOn) off(); else on(); }
	
	// Asking for a sound
	public void playStart() { soundPlay = 0; }
	public void playTouch() { soundPlay = 1; }
	public void playHit() { soundPlay = 2; }
	}



