{$M 22000,0,655360}
{$DEFINE __COMPRESS_SCRIPT}
{$DEFINE _OVERLAY}

{$IFNDEF __OVERLAY}
program Dejavu;
{$ELSE}
unit Dejavu;
   {$O+,F+}
INTERFACE
   procedure dejavu_main;

IMPLEMENTATION
{$ENDIF}

uses
   dos, graph, DVComprs,
   DVHan20, DVTitle, DVSubpro, DVPerson, DVDecode, DVWorld;

 procedure loadImageData; forward;
 procedure loadMap(map_name :string); forward;
 procedure loadMapData(map_name : string); forward;
 procedure runScript(map_name : string); forward;
 procedure removeImageData; forward;
 procedure removeMapData; forward;
 procedure loadGame(game_number : byte); forward;
 function  setUp : boolean; forward;
 procedure startAction; forward;


procedure startAction;
var
   remember_memory : longint;
   window : ^window_O;
   file_name : string[12];
   s1, s2 : string[8];
begin
{
   game_system._NEXT_EXCUTE_FILE := 'p1-2';
   game_system._NEXT_START_X := 0;
   game_system._NEXT_START_Y := 0;
   MUST_LOAD_GAME := FALSE;
}
   remember_memory := MEMAVAIL;
   repeat
      if remember_memory <> MEMAVAIL then begin
         str(remember_memory,s1);
         str(MEMAVAIL,s2);
         printErrorMessage(4,s1+' bytes -> '+s2+' bytes');
      end;
      fadeOut(palette_data,1);
      clearPage(1);
      file_name := game_system._NEXT_EXCUTE_FILE;
      if Copy(file_name,1,5) = 'World' then begin
         {$IFDEF __COMPRESS_SCRIPT}
         decodeFile(file_name+'.MVC',file_name+'.MV');
         {$ENDIF}
         loadMap(file_name);
         loadImageData;
         runScript(file_name);
         {$IFDEF __COMPRESS_SCRIPT}
         deleteFile(file_name+'.MV');
         {$ENDIF}
         actJourney(game_system._NEXT_START_X,game_system._NEXT_START_Y);
         removeImageData;
         removeMapData;
      end else if Copy(file_name,1,7) = '_Battle' then begin
         {$IFDEF __COMPRESS_SCRIPT}
         decodeFile(file_name+'.MVC',file_name+'.MV');
         {$ENDIF}
         loadMap(file_name);
         loadImageData;
         loadScript(file_name);
         {$IFDEF __COMPRESS_SCRIPT}
         deleteFile(file_name+'.MV');
         {$ENDIF}
         game_system._NEXT_EXCUTE_FILE := '';
         actDecode;
         removeScript;
         removeImageData;
         removeMapData;
         if (game_system._NEXT_EXCUTE_FILE <> '') and
            (game_system._RETURN_EXCUTE_FILE <> '') then begin
            with game_system do begin
               _NEXT_EXCUTE_FILE := _RETURN_EXCUTE_FILE;
               _NEXT_START_X := _RETURN_START_X;
               _NEXT_START_Y := _RETURN_START_Y;
            end;
         end;
      end else begin
         printString(30,10,' Aai e .. ',15,TRUE,1);
         if not MUST_LOAD_GAME then begin
            {$IFDEF __COMPRESS_SCRIPT}
            decodeFile(file_name+'.MVC',file_name+'.MV');
            {$ENDIF}
            loadMap(file_name);
            loadImageData;
            loadScript(file_name);
            {$IFDEF __COMPRESS_SCRIPT}
            deleteFile(file_name+'.MV');
            {$ENDIF}
         end else begin
            loadGame(game_system._NEXT_START_X);
         end;
         game_system._NEXT_EXCUTE_FILE := '';
         actDecode;
         removeScript;
         removeImageData;
         removeMapData;
      end;
      with person[_MAIN_CHARACTER]^ do begin
         setInternal(_love,0);
         setInternal(_hostile,0);
         setInternal(_hostile1,0);
         setInternal(_hostile2,0);
         setInternal(_hostile3,0);
         setInternal(_hostile4,0);
      end;
      game_system.setEventTime(0,0,0,0,0);
      if game_system._NEXT_EXCUTE_FILE <> '' then user_key := 0;
   until (user_key = EXIT_CODE);

end;

procedure loadImageData;
var
   i : integer;
   font_name : string[8];
   f1, f2 : file;
   temp_image : original_sprite_T;
begin

    font_name := map_header.tile_data_file;
    if font_name <> '' then begin

       assign(f1,font_name+'.img');
       {$I-}
       reset(f1,1);
       {$I+}
       if IOResult <> 0 then printErrorMessage(1,font_name+'.img');

       for i := 0 to MAX_TILE-1 do begin
          new(tile_data[i]);
          BlockRead(f1,temp_image,IMAGE_SIZE+6);
          convertImage(temp_image,tile_data[i]^);
       end;
       close(f1);
    end;

    if map_header.tile_data_file = 'tile' then
       FOREGROUND_TILE := FOREGROUND_IN_TILE_IMAGE
    else
       FOREGROUND_TILE := FOREGROUND_IN_DEN_IMAGE;

    font_name := map_header.object_data_file;
    if font_name <> '' then begin

       assign(f1,font_name+'.spr');
       {$I-}
       reset(f1,1);
       {$I+}
       if IOResult <> 0 then printErrorMessage(1,font_name+'.spr');

       assign(f2,font_name+'.bsp');
       {$I-}
       reset(f2,1);
       {$I+}
       if IOResult <> 0 then printErrorMessage(1,font_name+'.bsp');

       for i := 0 to MAX_OBJECT_TILE-1 do begin
          new(object_tile_data[i]);
          BlockRead(f1,temp_image,IMAGE_SIZE+6);
          BlockRead(f2,temp_image[IMAGE_SIZE+6],IMAGE_SIZE+6);
          convertSprite(temp_image,object_tile_data[i]^);
       end;
       close(f1);
       close(f2);
    end;

    font_name := map_header.equipment_data_file;
    if font_name <> '' then begin

       assign(f1,font_name+'.spr');
       {$I-}
       reset(f1,1);
       {$I+}
       if IOResult <> 0 then printErrorMessage(1,font_name+'.spr');

       assign(f2,font_name+'.bsp');
       {$I-}
       reset(f2,1);
       {$I+}
       if IOResult <> 0 then printErrorMessage(1,font_name+'.bsp');

       for i := 1 to MAX_EQUIPMENT_TILE do begin
          new(equipment_tile_data[i]);
          BlockRead(f1,temp_image,IMAGE_SIZE+6);
          BlockRead(f2,temp_image[IMAGE_SIZE+6],IMAGE_SIZE+6);
          convertSprite(temp_image,equipment_tile_data[i]^);
       end;
       close(f1);
       close(f2);
    end;

    font_name := map_header.field_data_file;
    if font_name <> '' then begin

       assign(f1,font_name+'.spr');
       {$I-}
       reset(f1,1);
       {$I+}
       if IOResult <> 0 then printErrorMessage(1,font_name+'.spr');

       assign(f2,font_name+'.bsp');
       {$I-}
       reset(f2,1);
       {$I+}
       if IOResult <> 0 then printErrorMessage(1,font_name+'.bsp');

       for i := 0 to MAX_FIELD_TILE-1 do begin
          new(field_tile_data[i]);
          BlockRead(f1,temp_image,IMAGE_SIZE+6);
          BlockRead(f2,temp_image[IMAGE_SIZE+6],IMAGE_SIZE+6);
          convertSprite(temp_image,field_tile_data[i]^);
       end;
       close(f1);
       close(f2);
    end;

    font_name := map_header.character_data_file;
    if font_name <> '' then begin

       assign(f1,font_name+'.spr');
       {$I-}
       reset(f1,1);
       {$I+}
       if IOResult <> 0 then printErrorMessage(1,font_name+'.spr');

       assign(f2,font_name+'.bsp');
       {$I-}
       reset(f2,1);
       {$I+}
       if IOResult <> 0 then printErrorMessage(1,font_name+'.bsp');

       for i := 0 to MAX_CHARACTER_TILE-1 do begin
          new(character_tile_data[i]);
          BlockRead(f1,temp_image,IMAGE_SIZE+6);
          BlockRead(f2,temp_image[IMAGE_SIZE+6],IMAGE_SIZE+6);
          convertSprite(temp_image,character_tile_data[i]^);
       end;
       close(f1);
       close(f2);
    end;

end;

procedure loadMap(map_name :string);
const
   MAX_MAP_KEY_WORD = 21;
   map_key_word : array[1..MAX_MAP_KEY_WORD] of string[20] = (
      'mapname', 'mapxmax', 'mapymax', 'exitpoint', 'startpoint',
      'boundaryexit', 'handicap','ifexitpoint', 'endif', 'true',
      'none', 'tiledatafile', 'objectdatafile', 'equipmentdatafile',
      'fielddatafile', 'characterdatafile', 'musicdatafile', 'friendshiplevel',
      'maprecording', 'personrecording', 'mapcode'
   );
var
   i :integer;
   s, operand, temp_s : longString;
   selected_script, operand_parameter : integer;
   f : text;
begin
   fillChar(map_header,sizeof(map_header),#0);
   for i := 1 to MAX_MAP_EXIT_POINT do begin
      map_exit_data[i] := nil;
   end;

   assign(f,map_name+'.MV');
   {$I-}
   reset(f);
   {$I+}
   if IOResult <> 0 then printErrorMessage(1,map_name+'.MV');

   temp_s := '';
   while (not eof(f)) and (temp_s <> 'MAP HEADER DEFINITION') do readLn(f,temp_s);

   readLn(f,temp_s);
   while (not eof(f)) and (temp_s <> 'END DEFINITION') do begin
      if (temp_s <> '') and (temp_s[1] <> '/') then begin
         shrinkCharacters(temp_s,s,' ');
         pulloutWord(s,operand,':');
         selected_script := 0;
         for i := 1 to MAX_MAP_KEY_WORD do begin
            if operand = map_key_word[i] then selected_script := i;
         end;
         if selected_script = 0 then
            printCompileErrorMessage(2,temp_s);
         case selected_script of
            1 : map_header.map_data.file_name := s;
            2 : toInteger(s,map_header.map_x_max);
            3 : toInteger(s,map_header.map_y_max);
            4 :
            begin
               removeCharacters(s,s,'(');
               seperateWord(s,s,operand,',',')');
               toInteger(s,map_header.map_data.map_x_exit);
               toInteger(operand,map_header.map_data.map_y_exit);
            end;
            5 :
            begin
               removeCharacters(s,s,'(');
               seperateWord(s,s,operand,',',')');
               toInteger(s,map_header.map_data.map_x_start);
               toInteger(operand,map_header.map_data.map_y_start);
            end;
            6 : if s = map_key_word[10] then map_header.enable_boundary_exit := TRUE
                                   else map_header.enable_boundary_exit := FALSE;
            7 :
            begin
               if s <> 'none' then
                  toByte(s,map_header.handicap_bit)
               else
                  map_header.handicap_bit := 0;
            end;
            8 :
            begin
               inc(map_header.count_of_exit_point);
               new(map_exit_data[map_header.count_of_exit_point]);
               with map_exit_data[map_header.count_of_exit_point]^ do begin
                  removeCharacters(s,s,'(');
                  seperateWord(s,s,operand,',',')');
                  toInteger(s,map_x_exit);
                  toInteger(operand,map_y_exit);
                  readLn(f,temp_s);
                  shrinkCharacters(temp_s,s,' ');
                  while (not eof(f)) and (s <> map_key_word[9]) do begin
                     if (temp_s <> '') and (temp_s[1] <> '/') then begin
                        pulloutWord(s,operand,':');
                        selected_script := 0;
                        for i := 1 to MAX_MAP_KEY_WORD do begin
                           if operand = map_key_word[i] then selected_script := i;
                        end;
                        if selected_script = 0 then printCompileErrorMessage(2,temp_s);
                        case selected_script of
                           1 : file_name := s;
                           5 :
                           begin
                              removeCharacters(s,s,'(');
                              seperateWord(s,s,operand,',',')');
                              toInteger(s,map_x_start);
                              toInteger(operand,map_y_start);
                           end
                           else printCompileErrorMessage(1,temp_s);
                        end;
                     end;
                     readLn(f,temp_s);
                     shrinkCharacters(temp_s,s,' ');
                  end;
               end;
            end;
            12: map_header.tile_data_file := s;
            13: map_header.object_data_file := s;
            14: map_header.equipment_data_file := s;
            15: map_header.field_data_file := s;
            16: map_header.character_data_file := s;
            17: map_header.music_data_file := s;
            18: toByte(s,map_header.friendship_level);
            19: if s = map_key_word[10] then map_header.enable_map_recording := TRUE
                                   else map_header.enable_map_recording := FALSE;
            20: if s = map_key_word[10] then map_header.enable_person_recording := TRUE
                                   else map_header.enable_person_recording := FALSE;
            21: map_header.map_code := s
            else printCompileErrorMessage(1,temp_s);
         end;
      end;
      readLn(f,temp_s);
   end;
   close(f);

   game_system.setMapMaxSize(map_header.map_x_max,map_header.map_y_max);
   loadMapData(map_header.map_data.file_name);

end;

procedure loadMapData(map_name : string);
var
   f : file;
   file_name : string;
   i,j : integer;
   MA : map_attribute_T;
   in_small_map : boolean;
   buffer : ^byte;
begin

   in_small_map := (Copy(map_name,1,5) <> 'World');

   if in_small_map then begin
      assign(f,map_name+'.MAF');
      {$I-}
      reset(f,1);
      {$I+}
      if IOResult <> 0 then printErrorMessage(1,map_name+'.MAF');

      BlockRead(f,i,2);
      BlockRead(f,i,2);
      BlockRead(f,i,2);
      BlockRead(f,j,2);
      game_system.setMapMaxSize(i,j);
      for MA := succ(START_OF_MAP_ATTRIBUTE) to pred(MA_PERSON) do begin
         getMem(map[MA],game_system.returnMapXMax * game_system.returnMapYMax);
         BlockRead(f,map[MA]^,game_system.returnMapXMax * game_system.returnMapYMax);
      end;
      close(f);

      if map_header.enable_map_recording then begin
         chDir(SUB_DIRECTORY);
         file_name := OBJ_SAVE_FILE+'0.'+map_header.map_code;
         assign(f,file_name);
         {$I-}
         reset(f,1);
         {$I+}
         if IOResult = 0 then begin
            getMem(buffer,(MAX_PERSON_ARRAY-1)*5);
            BlockRead(f,buffer^,(MAX_PERSON_ARRAY-1)*5);
            freeMem(buffer,(MAX_PERSON_ARRAY-1)*5);
            BlockRead(f,map[MA_OBJECT]^,game_system.returnMapXMax * game_system.returnMapYMax);
            BlockRead(f,item_map,sizeof(item_map));
            for i := 1 to item_map.number_of_data do begin
               new(item_map.data[i].item_data);
               BlockRead(f,item_map.data[i].item_data^,sizeof(item_map.data[i].item_data^));
            end;
            close(f);
         end;
         chDir('..');
      end;

      getMem(map[MA_PERSON],game_system.returnMapXMax * game_system.returnMapYMax);
      fillChar(map[MA_PERSON]^,game_system.returnMapXMax * game_system.returnMapYMax,#0);
      if (byte(game_system._NEXT_START_X) in [1..game_system.returnMapXMax-1]) and
         (byte(game_system._NEXT_START_Y) in [1..game_system.returnMapYMax-1]) then begin
         person[1]^.setX(game_system._NEXT_START_X);
         person[1]^.setY(game_system._NEXT_START_Y);
      end
      else if (game_system._NEXT_START_X = 0) and (game_system._NEXT_START_Y = 0) then begin
         person[1]^.setX(map_header.map_data.map_x_start);
         person[1]^.setY(map_header.map_data.map_y_start);
      end
      else begin
         if game_system._NEXT_DIRECTION_X > 0 then person[1]^.setX(0)
         else if game_system._NEXT_DIRECTION_X < 0 then person[1]^.setX(game_system.returnMapXMax-1)
         else person[1]^.setX((game_system.returnMapXMax-1) div 2);
         if game_system._NEXT_DIRECTION_Y > 0 then person[1]^.setY(0)
         else if game_system._NEXT_DIRECTION_Y < 0 then person[1]^.setY(game_system.returnMapYMax-1)
         else person[1]^.setY((game_system.returnMapYMax-1) div 2);
      end;
      writeMap(MA_PERSON,person[1]^.returnX,person[1]^.returnY,1);
   end else begin
      assign(f,map_name+'.MAF');
      {$I-}
      reset(f,1);
      {$I+}
      if IOResult <> 0 then printErrorMessage(1,map_name+'.MAF');

      BlockRead(f,i,2);
      BlockRead(f,i,2);
      BlockRead(f,i,2);
      BlockRead(f,j,2);
      game_system.setMapMaxSize(i,j);
      getMem(map[MA_NORMAL],game_system.returnMapXMax * game_system.returnMapYMax);
      BlockRead(f,map[MA_NORMAL]^,game_system.returnMapXMax * game_system.returnMapYMax);
      close(f);
   end;
end;

procedure runScript(map_name : string);
var
   f : text;
   temp_s : longString;
begin
   assign(f,map_name+'.MV');
   {$I-}
   reset(f);
   {$I+}
   if IOResult <> 0 then printErrorMessage(1,map_name+'.MV');

   temp_s := '';
   while (not eof(f)) and (temp_s <> 'BEGIN SCRIPT') do readLn(f,temp_s);

   readLn(f,temp_s);
   while (not eof(f)) and (temp_s <> 'END SCRIPT') do begin
      if (temp_s <> '') and (temp_s[1] <> '/') then begin
         removeCharacters(temp_s,temp_s,' ');
         excuteCommand(temp_s,0);
      end;
      readLn(f,temp_s);
   end;
   close(f);
end;

procedure removeImageData;
var
   i : integer;
begin
    if map_header.tile_data_file <> '' then
       for i := 0 to MAX_TILE-1 do dispose(tile_data[i]);
    if map_header.object_data_file <> '' then
       for i := 0 to MAX_OBJECT_TILE-1 do dispose(object_tile_data[i]);
    if map_header.equipment_data_file <> '' then
       for i := 1 to MAX_EQUIPMENT_TILE do dispose(equipment_tile_data[i]);
    if map_header.field_data_file <> '' then
       for i := 0 to MAX_FIELD_TILE-1 do dispose(field_tile_data[i]);
    if map_header.character_data_file <> '' then
       for i := 0 to MAX_CHARACTER_TILE-1 do dispose(character_tile_data[i]);
end;

procedure removeMapData;
var
   MA : map_attribute_T;
   i, ptr : integer;
   datum, count : byte;
   in_small_map : boolean;
   buffer : ^byte;
   size : longint;
   file_name : string[12];
   write_f : file;
begin

   in_small_map := (Copy(map_header.map_data.file_name,1,5) <> 'World');

   if in_small_map then begin

      if map_header.enable_map_recording then begin
         chDir(SUB_DIRECTORY);
         file_name := OBJ_SAVE_FILE+'0.'+map_header.map_code;
         assign(write_f,file_name);
         reset(write_f,1);
         size := FileSize(write_f);
         getMem(buffer,size);
         BlockRead(write_f,buffer^,size);
         close(write_f);
         assign(write_f,file_name);
         rewrite(write_f,1);
         BlockWrite(write_f,buffer^,size);
         freeMem(buffer,size);
         BlockWrite(write_f,map[MA_OBJECT]^,game_system.returnMapXMax * game_system.returnMapYMax);
         BlockWrite(write_f,item_map,sizeof(item_map));
         for i := 1 to item_map.number_of_data do begin
            BlockWrite(write_f,item_map.data[i].item_data^,sizeof(item_map.data[i].item_data^));
         end;
         close(write_f);
         chDir('..');
      end;

{      assign(write_f,map_header.map_data.file_name+'.

      for ptr := 0 to game_system.returnMapXMax * game_system.returnMapYMax - 1 do begin

         inc(count_meter);
         if counter = 0 then begin
            datum := buffer^[buffer_count];
            inc(counter);
         end
         else begin
            if (buffer^[buffer_count] = datum) and (counter < 255) then begin
               inc(counter);
            end
            else begin
               blockwrite(write_f,datum,1);
               blockwrite(write_f,counter,1);
               datum := buffer^[buffer_count];
               counter := 1;
            end;
         end;

         inc(buffer_count);
      end;
}
      for MA := succ(START_OF_MAP_ATTRIBUTE) to pred(END_OF_MAP_ATTRIBUTE) do begin
         freeMem(map[MA],game_system.returnMapXMax * game_system.returnMapYMax);
         map[MA] := nil;
      end;
   end else begin
      freeMem(map[MA_NORMAL],game_system.returnMapXMax * game_system.returnMapYMax);
      map[MA_NORMAL] := nil;
   end;

   while map_header.count_of_exit_point > 0 do begin
      dispose(map_exit_data[map_header.count_of_exit_point]);
      map_exit_data[map_header.count_of_exit_point] := nil;
      dec(map_header.count_of_exit_point);
   end;
   while item_map.number_of_data > 0 do begin
      dispose(item_map.data[item_map.number_of_data].item_data);
      item_map.data[item_map.number_of_data].item_data := nil;
      dec(item_map.number_of_data);
   end;
end;

procedure loadItem(file_name : string);
const
   MAX_ITEM_SCRIPT_STRING = 20;
   item_script_string : array[1..MAX_ITEM_SCRIPT_STRING] of string[16] = (
      'number','name','price','shape','shaperevolution',
      'type','weapontype','attribute','weight','attackpower',
      'attackrange','defenselevel','defensepower','throwpower','throwrange',
      'prefix','magictype','magic','magicremain','maintainlevel'
   );
   item_type_string : array[succ(START_OF_EQUIPMENT)..pred(END_OF_EQUIPMENT)] of string[16] = (
      'weapon','shield','armor','shoes','helmet',
      'gauntlet','lefthand','finger','neck','money',
      'food','useless'
   );
   item_weapon_type_string : array[succ(START_OF_WEAPON)..pred(END_OF_WEAPON)] of string[8] = (
      'fist','sword','axe','spear','throw',
      'bow','fist4MU','etc'
   );
   item_attribute_string : array[_normal.._vice] of string[16] = (
      'normal','virtue','vice'
   );
   magic_type_string : array[mgc_none..mgc_environment] of string[12] = (
      'none','attack','defense','summon','cure','environment'
   );
var
   item_data_ptr : integer;
   i,j : integer;
   ET : equipment_T;
   WT : weapon_T;
   AT : item_attribute_T;
   MT : magic_type_T;
   s, operand, temp_s : longString;
   selected_script, operand_parameter : integer;
   f : text;
begin
   for i := 0 to MAX_ITEM_DATA do item_data[i] := nil;
   assign(f,file_name+'.IDS');
   {$I-}
   reset(f);
   {$I+}
   if IOResult <> 0 then printErrorMessage(1,file_name+'.IDS');

   item_data_ptr := 1;
   temp_s := '';
   while (not eof(f)) and (temp_s <> 'ITEM DEFINITION') do readLn(f,temp_s);

   readLn(f,temp_s);
   while (not eof(f)) and (temp_s <> 'END DEFINITION') do begin
    if (temp_s <> '') and (temp_s[1] <> '/') then begin
      shrinkCharacters(temp_s,s,' ');
      pulloutWord(s,operand,':');
      selected_script := 0;
      for i := 1 to MAX_ITEM_SCRIPT_STRING do begin
         if item_script_string[i] = operand then begin
            selected_script := i;
         end;
      end;
      if selected_script = 0 then printCompileErrorMessage(2,temp_s);
      val(s,operand_parameter,i);
      if (i <> 0) then begin
         operand_parameter := 0;
         if not (selected_script in [2,6,7,17]) then printCompileErrorMessage(1,temp_s);
      end;
      with item_data[item_data_ptr]^ do begin
         case selected_script of
            1 :
            begin
               item_data_ptr := operand_parameter;
               if operand_parameter = 75 then begin
                  i := i;
               end;
               new(item_data[item_data_ptr]);
               fillChar(item_data[item_data_ptr]^,sizeof(item_data[item_data_ptr]^),#0);
               item_data[item_data_ptr]^.data._item_number := operand_parameter;
               item_data[item_data_ptr]^.data._item_contain := 1;
            end;
            2 :
            begin
               pulloutWord(temp_s,s,':');
               removeCharacters(temp_s,s,' ');
               name := s;
            end;
            3 : price := operand_parameter;
            4 : data._item_shape := operand_parameter;
            5 : data._item_shape_revolution := operand_parameter;
            6 :
            begin
               j := -1;
               for ET := succ(START_OF_EQUIPMENT) to pred(END_OF_EQUIPMENT) do begin
                  if item_type_string[ET] = s then begin
                     data._item_type := ET;
                     j := ord(ET);
                  end;
               end;
               if j < 0 then printCompileErrorMessage(2,temp_s);
            end;
            7 :
            begin
               j := -1;
               for WT := succ(START_OF_WEAPON) to pred(END_OF_WEAPON) do begin
                  if item_weapon_type_string[WT] = s then begin
                     data._item_weapon_type := WT;
                     j := ord(WT);
                  end;
               end;
               if j < 0 then printCompileErrorMessage(2,temp_s);
            end;
            8 :
            begin
               j := -1;
               for AT := _normal to _vice do begin
                  if item_attribute_string[AT] = s then begin
                     data._item_attribute := AT;
                     j := ord(AT);
                  end;
               end;
               if j < 0 then printCompileErrorMessage(2,temp_s);
            end;
            9 : data._item_weight := operand_parameter;
            10: data._item_attack_power := operand_parameter;
            11: data._item_attack_range := operand_parameter;
            12: data._item_defense_level := operand_parameter;
            13: data._item_defense_power := operand_parameter;
            14: data._item_throw_power := operand_parameter;
            15: data._item_throw_range := operand_parameter;
            16: data._item_suffix := operand_parameter;
            17:
            begin
               j := -1;
               for MT := mgc_none to mgc_environment do begin
                  if magic_type_string[MT] = s then begin
                     data._item_magic_type := MT;
                     j := ord(MT);
                  end;
               end;
               if j < 0 then printCompileErrorMessage(2,temp_s);
            end;
            18: data._item_magic := operand_parameter;
            19: data._item_magic_remain := operand_parameter;
            20: data._item_maintain_level := operand_parameter;
         end;
      end;
    end;
    readLn(f,temp_s);
   end;
   close(f);
end;

procedure loadMagic(file_name : string);
const
   attack_type_string : array[_normal_attack.._spread] of string[16] = (
      'normalattack','notshown','shoot','pierce','spread'
   );
   attack_attribute_string : array[_physical.._poisonous] of string[12] = (
      'physical','magical','fiery','watery','airy',
      'earthy','electrical','poisonous'
   );
   MAX_MAGIC_SCRIPT_STRING = 13;
   magic_script_string : array[1..MAX_MAGIC_SCRIPT_STRING] of string[16] = (
      'magictype','number','name','shape','shaperevolution',
      'destination','method','need','magicattribute','attackpower',
      'attackrange','MPconsumtion','trailingcount'
   );
   magic_type_string : array[mgc_none..mgc_environment] of string[12] = (
      'none','attack','defense','summon','cure','environment'
   );
   magic_destination_string : array[mgc_one..mgc_party] of string[8] = (
      'one','all','random','ground','party'
   );
   magic_need_string : array[mgc_not_need..mgc_player] of string[8] = (
      'notneed','fire','water','air','earth',
      'poison','thing','corpse','weapon','shield',
      'armor','player'
   );

var
   magic_type_ptr : magic_type_T;
   magic_number_ptr : integer;
   i,j : integer;
   MT : magic_type_T;
   MD : magic_destination_T;
   AT : attack_type_T;
   MN : magic_need_T;
   AA : attack_attribute_T;
   s, operand, temp_s : longString;
   selected_script, operand_parameter : integer;
   f : text;
begin
   for MT := mgc_attack to mgc_environment do begin
      for i := 1 to MAX_MAGIC_DATA do magic_data[MT,i] := nil;
      MAX_MAGIC_EA[MT] := 0;
   end;
   assign(f,file_name+'.MDS');
   {$I-}
   reset(f);
   {$I+}
   if IOResult <> 0 then printErrorMessage(1,file_name+'.MDS');

   magic_number_ptr := 1;
   temp_s := '';
   while (not eof(f)) and (temp_s <> 'MAGIC DEFINITION') do readLn(f,temp_s);

   readLn(f,temp_s);
   while (not eof(f)) and (temp_s <> 'END DEFINITION') do begin
    if (temp_s <> '') and (temp_s[1] <> '/') then begin
      shrinkCharacters(temp_s,s,' ');
      pulloutWord(s,operand,':');
      selected_script := 0;
      for i := 1 to MAX_MAGIC_SCRIPT_STRING do begin
         if magic_script_string[i] = operand then begin
            selected_script := i;
         end;
      end;
      if selected_script = 0 then printCompileErrorMessage(2,temp_s);
      val(s,operand_parameter,i);
      if (i <> 0) then begin
         operand_parameter := 0;
         if not (selected_script in [1,3,6..9]) then printCompileErrorMessage(1,temp_s);
      end;
      with magic_data[magic_type_ptr,magic_number_ptr]^ do begin
         case selected_script of
            1 :
            begin
               j := -1;
               for MT := mgc_attack to mgc_environment do begin
                  if magic_type_string[MT] = s then begin
                     magic_type_ptr := MT;
                     if MT = mgc_defense then begin
                        MT := MT;
                     end;
                     j := ord(MT);
                  end;
               end;
               if j < 0 then printCompileErrorMessage(2,temp_s);
            end;
            2 :
            begin
               magic_number_ptr := operand_parameter;
               if MAX_MAGIC_EA[magic_type_ptr] < magic_number_ptr then begin
                  MAX_MAGIC_EA[magic_type_ptr] := magic_number_ptr;
               end;
               new(magic_data[magic_type_ptr,magic_number_ptr]);
               fillChar(magic_data[magic_type_ptr,magic_number_ptr]^,
                        sizeof(magic_data[magic_type_ptr,magic_number_ptr]^),#0);
               magic_data[magic_type_ptr,magic_number_ptr]^.data._magic_type := magic_type_ptr;
               magic_data[magic_type_ptr,magic_number_ptr]^.data._magic_number := operand_parameter;
               magic_data[magic_type_ptr,magic_number_ptr]^.data._magic_trailing_count := 1;
            end;
            3 :
            begin
               pulloutWord(temp_s,s,':');
               removeCharacters(temp_s,s,' ');
               name := s;
            end;
            4 : data._magic_shape := operand_parameter;
            5 : data._magic_shape_revolution := operand_parameter;
            6 :
            begin
               j := -1;
               for MD := mgc_one to mgc_party do begin
                  if magic_destination_string[MD] = s then begin
                     data._magic_destination := MD;
                     j := ord(MD);
                  end;
               end;
               if j < 0 then printCompileErrorMessage(2,temp_s);
            end;
            7 :
            begin
               j := -1;
               for AT := _NORMAL_ATTACK to _SPREAD do begin
                  if attack_type_string[AT] = s then begin
                     data._magic_method := AT;
                     j := ord(AT);
                  end;
               end;
               if j < 0 then printCompileErrorMessage(2,temp_s);
            end;
            8 :
            begin
               j := -1;
               data._magic_need_set := [];
               while s <> '' do begin
                  pulloutWord(s,operand,',');
                  for MN := mgc_not_need to mgc_player do begin
                     if magic_need_string[MN] = operand then begin
                        data._magic_need_set := data._magic_need_set + [MN];
                        j := ord(MN);
                     end;
                  end;
               end;
               if j < 0 then printCompileErrorMessage(2,temp_s);
            end;
            9 :
            begin
               j := -1;
               for AA := _physical to _poisonous do begin
                  if attack_attribute_string[AA] = s then begin
                     data._magic_attribute := AA;
                     j := ord(AA);
                  end;
               end;
               if j < 0 then printCompileErrorMessage(2,temp_s);
            end;
            10: data._magic_attack_power := operand_parameter;
            11: data._magic_attack_range := operand_parameter;
            12: data._magic_MP_consumtion := operand_parameter;
            13: data._magic_trailing_count := operand_parameter;
         end;
      end;
    end;
    readLn(f,temp_s);
   end;
   close(f);
end;

procedure loadGame(game_number : byte);
var
   f,f1 : file;
   file_name : string[16];
   MA : map_attribute_T;
   i : integer;
   temp_b : byte;
   temp_s : string[2];
   size : longint;
   buffer, pb : ^byte;
   DirInfo: SearchRec;
   NumRead, NumWritten : word;
   D: DirStr; N: NameStr; E: ExtStr;
   save_information : array[1..9] of save_data_T;
   s : string;
   temp_long : longint;
   complete_person : ^complete_person_O;
   simple_person : ^simple_person_O;

begin

   if not (game_number in [1..9]) then exit;

   chDir(SUB_DIRECTORY);

   assign(f,SAVE_INFORMATION_FILE);
   {$I-}
   reset(f,sizeof(save_data_T));
   {$I+}
   if IOResult <> 0 then printErrorMessage(1,SAVE_INFORMATION_FILE);
   for i := 1 to 9 do BlockRead(f,save_information[i],1);
   close(f);

   str(game_number,file_name);
   file_name := 'Save'+file_name;
   temp_long := returnCheckSum(file_name);
   if game_system.getEventBit(91) then
      temp_long := save_information[game_number].check_sum;
   if temp_long = save_information[game_number].check_sum then begin
      with save_information[game_number] do begin
         pb := addr(check_sum);
         temp_b := pb^;
         for i := 1 to 3 do begin
            inc(pb);
            temp_b := temp_b + pb^;
         end;
         if game_system.getEventBit(191) then
            temp_b := check_sum_byte;
         if temp_b <> check_sum_byte then begin
            chDir('..');
            printErrorMessage(3,'Don''t allow modification');
         end;
      end;
   end else begin
      chDir('..');
      printErrorMessage(3,'Don''t allow modification');
   end;

   dispose(person[1],done);
   person[1] := nil;

   str(game_number,file_name);
   file_name := 'Save'+file_name;

   assign(f,file_name);
   {$I-}
   reset(f,1);
   {$I+}
   if IOResult <> 0 then printErrorMessage(1,file_name);

   BlockRead(f,file_name[1],length(SAVE_ID));
   file_name[0] := chr(length(SAVE_ID));
   if file_name <> SAVE_ID then begin
      str(game_number,file_name);
      printErrorMessage(2,'Save'+file_name);
   end;

   BlockRead(f,game_system.m_proceeding_level,sizeof(game_system.m_proceeding_level));

   BlockRead(f,map_header,sizeof(map_header));
   for i := 1 to map_header.count_of_exit_point do begin
      new(map_exit_data[i]);
      BlockRead(f,map_exit_data[i]^,sizeof(map_exit_data[i]^));
   end;

    if map_header.tile_data_file = 'tile' then
       FOREGROUND_TILE := FOREGROUND_IN_TILE_IMAGE
    else
       FOREGROUND_TILE := FOREGROUND_IN_DEN_IMAGE;

   BlockRead(f,game_system,sizeof(system_O)-2);
   BlockRead(f,temp_b,1);
   BlockRead(f,temp_b,1);

   BlockRead(f,person_movement_data,sizeof(person_movement_data));
   BlockRead(f,invoid_person_movement_data,sizeof(invoid_person_movement_data));
   BlockRead(f,talkable_person,sizeof(talkable_person));
   BlockRead(f,recognizable_person,sizeof(recognizable_person));
   BlockRead(f,temp1_person,sizeof(temp1_person));
   BlockRead(f,temp2_person,sizeof(temp2_person));
   BlockRead(f,temp3_person,sizeof(temp3_person));
   BlockRead(f,max_person,sizeof(max_person));

   for MA := succ(START_OF_MAP_ATTRIBUTE) to pred(END_OF_MAP_ATTRIBUTE) do begin
      getMem(map[MA],game_system.returnMapXMax * game_system.returnMapYMax);
      BlockRead(f,map[MA]^,game_system.returnMapXMax * game_system.returnMapYMax);
   end;

   BlockRead(f,item_map,sizeof(item_map));
   for i := 1 to item_map.number_of_data do begin
      new(item_map.data[i].item_data);
      BlockRead(f,item_map.data[i].item_data^,sizeof(item_map.data[i].item_data^));
   end;

   if map_header.tile_data_file <> '' then begin
      for i := 0 to MAX_TILE-1 do begin
         new(tile_data[i]);
         BlockRead(f,tile_data[i]^,sizeof(tile_data[i]^));
      end;
   end;
   if map_header.object_data_file <> '' then begin
      for i := 0 to MAX_OBJECT_TILE-1 do begin
         new(object_tile_data[i]);
         BlockRead(f,object_tile_data[i]^,sizeof(object_tile_data[i]^));
      end;
   end;
   if map_header.equipment_data_file <> '' then begin
      for i := 1 to MAX_EQUIPMENT_TILE do begin
         new(equipment_tile_data[i]);
         BlockRead(f,equipment_tile_data[i]^,sizeof(equipment_tile_data[i]^));
      end;
   end;
   if map_header.field_data_file <> '' then begin
      for i := 0 to MAX_FIELD_TILE-1 do begin
         new(field_tile_data[i]);
         BlockRead(f,field_tile_data[i]^,sizeof(field_tile_data[i]^));
      end;
   end;
   if map_header.character_data_file <> '' then begin
      for i := 0 to MAX_CHARACTER_TILE-1 do begin
         new(character_tile_data[i]);
         BlockRead(f,character_tile_data[i]^,sizeof(character_tile_data[i]^));
      end;
   end;

   BlockRead(f,_MAIN_CHARACTER,sizeof(_MAIN_CHARACTER));
   BlockRead(f,MAX_EVENT_DATA,sizeof(MAX_EVENT_DATA));
   BlockRead(f,MAX_TIME_EVENT_DATA,sizeof(MAX_TIME_EVENT_DATA));
   BlockRead(f,MAX_TALK_DATA,sizeof(MAX_TALK_DATA));
   BlockRead(f,MAX_LABEL,sizeof(MAX_LABEL));
   BlockRead(f,MAX_SUBJECT_DATA,sizeof(MAX_SUBJECT_DATA));

   for i := 1 to MAX_RGS_DATA do begin
      BlockRead(f,temp_b,1);
      if temp_b = FULL_CODE then begin
         new(RGS_data[i]);
         BlockRead(f,RGS_data[i]^,sizeof(RGS_data[i]^));
      end else if temp_b = NULL_CODE then begin
         RGS_data[i] := nil;
      end else begin
         printErrorMessage(5,'RGS DATA reading');
      end;
   end;

   for i := 1 to MAX_SUBJECT_DATA do begin
      BlockRead(f,temp_b,1);
      if temp_b = FULL_CODE then begin
         new(subject_data[i]);
         BlockRead(f,subject_data[i]^,sizeof(subject_data[i]^));
      end else if temp_b = NULL_CODE then begin
         subject_data[i] := nil;
      end else begin
         printErrorMessage(5,'Subject DATA reading');
      end;
   end;

   BlockRead(f,label_address,sizeof(label_address));

   for i := 1 to MAX_MESSAGE_ARRAY do begin
      BlockRead(f,temp_b,1);
      if temp_b = FULL_CODE then begin
         new(message[i]);
         BlockRead(f,message[i]^,sizeof(message[i]^));
      end else if temp_b = NULL_CODE then begin
         message[i] := nil;
      end else begin
         printErrorMessage(5,'Message reading');
      end;
   end;

   chDir('..');
   assign(f1,TEMPLET_FILE);
   rewrite(f1,1);
   chDir(SUB_DIRECTORY);

   BlockRead(f,size,sizeof(size));
   getMem(buffer,10000);
   while size >= 10000 do begin
      BlockRead(f,buffer^,10000);
      BlockWrite(f1,buffer^,10000);
      size := size - 10000;
   end;
   if size > 0 then begin
      BlockRead(f,buffer^,size);
      BlockWrite(f1,buffer^,size);
   end;
   FreeMem(buffer,10000);
   close(f1);

   for i := 1 to MAX_PERSON_ARRAY do begin
      BlockRead(f,temp_b,1);
      if temp_b = FULL_CODE then begin
         if i = 1 then begin
            complete_person := new(complete_person_type,init(i,1,mgc_player,MA_PERSON,'',8,FALSE));
            BlockRead(f,complete_person^,sizeof(complete_person_O));
            if sizeof(complete_person^) <> sizeof(complete_person_O) then begin
               chDir('..');
               printCompileErrorMessage(13,'complete person object');
            end;
            person[i] := complete_person;
         end else begin
            person[i] := new(simple_person_type,init(i,0,mgc_player,MA_PERSON,'',8,FALSE));
            BlockRead(f,person[i]^,sizeof(simple_person_O));
            if sizeof(person[i]^) <> sizeof(simple_person_O) then begin
               chDir('..');
               printCompileErrorMessage(13,'simple person object');
            end;
         end;
      end else begin
         person[i] := nil;
      end;
   end;

{
   for i := 1 to MAX_PERSON_ARRAY do begin
      BlockRead(f,temp_b,1);
      if temp_b = FULL_CODE then begin
         if i = 1 then begin
            complete_person := new(complete_person_type,init(i,1,mgc_player,MA_PERSON,'',8,FALSE));
            BlockRead(f,complete_person^,sizeof(complete_person_O));
            BlockRead(f,complete_person^.m_name,17);
            BlockRead(f,complete_person^.m_person_attribute,sizeof(magic_need_T));
            BlockRead(f,complete_person^.m_number,sizeof(integer));
            BlockRead(f,complete_person^.m_x,sizeof(integer));
            BlockRead(f,complete_person^.m_y,sizeof(integer));
            BlockRead(f,complete_person^.m_face,sizeof(integer));
            BlockRead(f,complete_person^.m_face_count,sizeof(integer));
            BlockRead(f,complete_person^.m_face_attribute,sizeof(map_attribute_T));
            BlockRead(f,complete_person^.m_max_frame,sizeof(byte));
            BlockRead(f,complete_person^.aux_byte,16);
            BlockRead(f,complete_person^.m_ability,
                        sizeof(integer)*(succ(ord(pred(END_OF_ABILITY))-ord(succ(START_OF_ABILITY)))));
            BlockRead(f,complete_person^.m_internal,
                        sizeof(integer)*(succ(ord(pred(END_OF_INTERNAL))-ord(succ(START_OF_INTERNAL)))));
            BlockRead(f,complete_person^.m_skill,sizeof(integer)*(succ(ord(pred(END_OF_SKILL))-ord(succ(START_OF_SKILL)))));
            BlockRead(f,complete_person^.m_equipment,
                        sizeof(item_T)*(succ(ord(pred(END_OF_EQUIPMENT))-ord(succ(START_OF_EQUIPMENT)))));
            BlockRead(f,complete_person^.m_known_magic,sizeof(setBYTE)*(succ(ord(mgc_environment)-ord(succ(mgc_none)))));
            BlockRead(f,complete_person^.m_inventory_stack_ptr,sizeof(byte));
            BlockRead(f,complete_person^.m_inventory_stack,sizeof(item_T)*MAX_BACK_PACK);
            person[i] := complete_person;
         end else begin
            simple_person := new(simple_person_type,init(i,0,mgc_player,MA_PERSON,'',8,FALSE));
            BlockRead(f,simple_person^,sizeof(simple_person_O));
            BlockRead(f,simple_person^.m_name,17);
            BlockRead(f,simple_person^.m_person_attribute,sizeof(magic_need_T));
            BlockRead(f,simple_person^.m_number,sizeof(integer));
            BlockRead(f,simple_person^.m_x,sizeof(integer));
            BlockRead(f,simple_person^.m_y,sizeof(integer));
            BlockRead(f,simple_person^.m_face,sizeof(integer));
            BlockRead(f,simple_person^.m_face_count,sizeof(integer));
            BlockRead(f,simple_person^.m_face_attribute,sizeof(map_attribute_T));
            BlockRead(f,simple_person^.m_max_frame,sizeof(byte));
            BlockRead(f,simple_person^.aux_byte,16);
            BlockRead(f,simple_person^.m_ability,
                        sizeof(integer)*(succ(ord(pred(END_OF_ABILITY))-ord(succ(START_OF_ABILITY)))));
            BlockRead(f,simple_person^.m_internal,
                        sizeof(integer)*(succ(ord(pred(END_OF_INTERNAL))-ord(succ(START_OF_INTERNAL)))));
            BlockRead(f,simple_person^.m_skill,sizeof(integer)*(succ(ord(pred(END_OF_SKILL))-ord(succ(START_OF_SKILL)))));
            BlockRead(f,simple_person^.m_equipment,
                        sizeof(item_T)*(succ(ord(pred(END_OF_EQUIPMENT))-ord(succ(START_OF_EQUIPMENT)))));
            BlockRead(f,simple_person^.m_known_magic,sizeof(setBYTE)*(succ(ord(mgc_environment)-ord(succ(mgc_none)))));
            BlockRead(f,simple_person^.m_inventory_stack_ptr,sizeof(byte));
            BlockRead(f,simple_person^.m_inventory_stack,sizeof(item_T)*(MAX_BACK_PACK div 10));
            person[i] := simple_person;
         end;
      end else begin
         person[i] := nil;
      end;
   end;
}
   close(f);

   str(game_number,temp_s);
   getMem(buffer,10000);
   findFirst(OBJ_SAVE_FILE+'0.*', Archive, DirInfo);
   while DosError = 0 do begin
      deleteFile(DirInfo.Name);
      findNext(DirInfo);
   end;
   findFirst(OBJ_SAVE_FILE+temp_s+'.*', Archive, DirInfo);
   while DosError = 0 do begin
      assign(f,DirInfo.Name);
      reset(f,1);
      file_name := DirInfo.Name;
      FSplit(file_name, D, N, E);
      dec(N[0]);
      file_name := N + '0' + E;
      assign(f1,file_name);
      rewrite(f1,1);
      repeat
         BlockRead(f,buffer^,10000,NumRead);
         BlockWrite(f1,buffer^,NumRead,NumWritten);
      until (NumRead = 0) or (NumWritten <> NumRead);
      close(f1);
      close(f);
      findNext(DirInfo);
   end;
   freeMem(buffer,10000);

   chDir('..');

end;

{$IFNDEF __OVERLAY}
   {$I DVGrDrv}
{$ENDIF}

function setUp : boolean;
var
   i,j : integer;
   f : file;
   temp_b : byte;
   window : ^window_O;
   MT : magic_type_T;
   s : longString;
   DirInfo: SearchRec;
   save_data : save_data_T;
begin

   {$I-}
   chDir(SUB_DIRECTORY);
   if IOResult <> 0 then begin
      mkDir(SUB_DIRECTORY);
      chDir(SUB_DIRECTORY);
   end;
   {$I+}

   findFirst(OBJ_SAVE_FILE+'0.*', Archive, DirInfo);
   while DosError = 0 do begin
      deleteFile(DirInfo.Name);
      findNext(DirInfo);
   end;

   findFirst(SAVE_INFORMATION_FILE, Archive, DirInfo);
   if DosError <> 0 then begin
      fillChar(save_data,sizeof(save_data_T),#0);
      assign(f,SAVE_INFORMATION_FILE);
      rewrite(f,sizeof(save_data_T));
      for i := 1 to 9 do BlockWrite(f,save_data,1);
      close(f);
   end;

   chDir('..');

   {$IFDEF __COMPRESS_SCRIPT}
   decodeFile('comment.cmc',COMMENT_FILE);
   {$ENDIF}

   if paramcount > 0 then begin
      s := paramstr(1);
      if (length(s) <> 2) or (s[1] <> '@') or not(s[2] in ['1'..'9']) then begin
         s := '';
      end;
      if paramcount > 1 then begin
         if paramstr(2) = 'ZeniuS' then ENABLE_CHEATING := TRUE;
      end;
   end else s := '';
   if s = '' then s := displayTitle;
   shrinkCharacters(s,s,' ');

   key_code := 0;
   user_key := 0;
   max_person := 0;

   excuteCommand('set graphic mode("350")',0);

(* *** THE FOLLOW ROUTINES READ ORIGINAL DATA (palette,item data,magic data..)

   assign(f,'dejavu.pal');
   {$I-}
   reset(f,1);
   {$I+}
   if IOResult <> 0 then printErrorMessage(1,'test.pal');

   BlockRead(f,palette_data,48);
   close(f);

   new(window,init(26,9,54,13,5,TRUE));

   window^.printHangul('@@ aQ Aa  ....');
   loadItem('items');
   window^.printHangul('@@ a  Aa   ....');
   loadMagic('magics');

   dispose(window,done);

   ***  THE FOLLOW ROUTINES SAVE DATA MAKED PREVIOUS

   assign(f,'Dejavu.Dat');
   rewrite(f,1);
   for i := 0 to MAX_ITEM_DATA do begin
      if item_data[i] <> nil then begin
         BlockWrite(f,FULL_CODE,1);
         BlockWrite(f,item_data[i]^,sizeof(item_data[i]^));
      end else begin
         BlockWrite(f,NULL_CODE,1);
      end;
   end;
   for MT := mgc_attack to mgc_environment do begin
      BlockWrite(f,MAX_MAGIC_EA[MT],sizeof(MAX_MAGIC_EA[MT]));
      for i := 1 to MAX_MAGIC_DATA do begin
         if magic_data[MT,i] <> nil then begin
            BlockWrite(f,FULL_CODE,1);
            BlockWrite(f,magic_data[MT,i]^,sizeof(magic_data[MT,i]^));
      end else begin
            BlockWrite(f,NULL_CODE,1);
         end;
      end;
   end;
   BlockWrite(f,palette_data,48);
   close(f);
   halt;
*)
   assign(f,'Dejavu.Dat');
   {$I-}
   reset(f,1);
   {$I+}
   if IOResult <> 0 then printErrorMessage(1,'Dejavu.Dat');

   for i := 0 to MAX_ITEM_DATA do begin
      BlockRead(f,temp_b,1);
      if temp_b = FULL_CODE then begin
         new(item_data[i]);
         BlockRead(f,item_data[i]^,sizeof(item_data[i]^));
      end else begin
         item_data[i] := nil;
      end;
   end;
   for MT := mgc_attack to mgc_environment do begin
      BlockRead(f,MAX_MAGIC_EA[MT],sizeof(MAX_MAGIC_EA[MT]));
      for i := 1 to MAX_MAGIC_DATA do begin
         BlockRead(f,temp_b,1);
         if temp_b = FULL_CODE then begin
            new(magic_data[MT,i]);
            BlockRead(f,magic_data[MT,i]^,sizeof(magic_data[MT,i]^));
         end else begin
            magic_data[MT,i] := nil;
         end;
      end;
   end;
   BlockRead(f,palette_data,48);
   close(f);

   assign(f,SPRITE_FILE);
   {$I-}
   reset(f,1);
   {$I+}
   if IOResult <> 0 then printErrorMessage(1,SPRITE_FILE);
   for j := 1 to 2 do begin
      BlockRead(f,sprite_data[j].size,2);
      getMem(sprite_data[j].data,sprite_data[j].size);
      BlockRead(f,sprite_data[j].data^,sprite_data[j].size);
   end;
   close(f);

   for i := 0 to 15 do begin
      setPalette(i);
      setRGB(i,palette_data[i,1],palette_data[i,2],palette_data[i,3]);
   end;

   modifyScreenWide(0);

   game_system.init;

   setUp := TRUE;
   temp_b := NULL_CODE;
   if (length(s) = 2) and (s[1] = '@') and (s[2] in ['1'..'9']) then begin
      MUST_LOAD_GAME := TRUE;
      game_system._NEXT_START_X := ord(s[2]) - ord('0');
   end else if (length(s) > 2) and (s[1] = '@') and (s[2] = '0') then begin
      MUST_LOAD_GAME := FALSE;
      game_system._NEXT_EXCUTE_FILE := 'Abellis1';
      removeCharacters(s,s,'@');
      removeCharacters(s,s,'0');
      temp_b := FULL_CODE;
   end else if s <> '' then begin
      MUST_LOAD_GAME := FALSE;
      game_system._NEXT_EXCUTE_FILE := 'Abellis0';
   end else begin
      setUp := FALSE;
   end;

   if s <> '' then begin
      person[1] := new(complete_person_type,init(1,1,mgc_player,MA_PERSON,s,8,TRUE));
      with person[1]^ do begin
         setAbilityALL('2000,1000,5000,3000,5000,3000,1000,1000,50,2000');
         setSkillALL('10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10');
         setEquipmentALL('12,0,0,0,0,0,0,0,0,0,0,0');
{         setMagicAll('(1,2,3,4,5,6,17,23,27):(2,5,8):(1,2,5,8):(2,5):(1,2,3,4,5,20,21,22,23)');}
{         setItemALL('75,76-4,77-2,94:101-1,100-30027,38-50,99');}
{         addItemALL('81:101,81:102,81:124,81:105,81-5');}

{         setMagicAll('::(1,2,3,4,5,6,7,8,9)::(2,10,24,25)');}

         if temp_b = FULL_CODE then begin { FULL_CODE -> Start to Main Game }
            addAbilityALL('48,50,55,48,44,60,46,0,0,0');
            setItemALL('100-1000')
         end;

         modifyInternalValue;
         recognizable_person := [2..MAX_PERSON_ARRAY];
      end;
   end;
end;

{$IFDEF __OVERLAY}
procedure dejavu_main;
{$ENDIF}
begin

{$IFNDEF __OVERLAY}
   registerBGIDriver(@GraphicDriver);
{$ENDIF}

   DVTitle.verifyInitialCondition;

   if Dejavu.setUp = TRUE then
      Dejavu.startAction;

{$IFDEF __OVERLAY}
end;
{$ENDIF}
end.
