Unit DVComprs;

INTERFACE

 function decodeFile(source_s, destination_s : string) : boolean;

IMPLEMENTATION

const
   ID_STRING : string[20] = 'Deja vu Script File'+^Z;

   MINMUN      = 4096;
   TAG         = 18;
   THRESHOLD   = 2;
   NUL         = MINMUN * 2;

   BUFSIZE = 1024;
   INPUT_BUFFER_PTR  : word = BUFSIZE;
   INPUT_BUFFER_SIZE : word = BUFSIZE;
   OUT_BUFFER_PTR : word = 0;

type
   text_buffer_T = array [0.. MINMUN + TAG - 2] of byte;
   IO_buffer_T = array [0..PRED(BUFSIZE)] of byte;
var
   input_file, output_file : file;
   text_buffer : text_buffer_T;
   input_buffer, out_buffer : IO_buffer_T;
   current_process : (_ENCODING,_DECODING);


function readChunk: word;
var
   actual : word;
   _segment, _offset : word;
begin
   BlockRead(input_file,input_buffer,BUFSIZE,actual);
   if actual < BUFSIZE then begin
      actual := actual;
   end;
   if (current_process = _DECODING) and (actual > 0) then begin
      _segment := seg(input_buffer);
      _offset := ofs(input_buffer);
      asm
         push es
         mov es, _segment
         mov di, _offset
         mov cx, actual
      @LOOP:
         mov al, es:[di]
         sub al,57
         ror al,2
         not al
         mov es:[di], al
         inc di
         dec cx
         jnz @LOOP
         pop es
      end;
   end;
   readChunk := actual;
end;

procedure getC; assembler;
asm

   push    bx
   mov     bx, INPUT_BUFFER_PTR
   cmp     bx, INPUT_BUFFER_SIZE
   jb      @GET_C1
   push    cx
   push    dx
   push    di
   push    si
   call    readChunk
   pop     si
   pop     di
   pop     dx
   pop     cx
   mov     INPUT_BUFFER_SIZE, ax
   or      ax, ax
   jz      @GET_C2
   xor     bx, bx

@GET_C1:
   mov     al, [offset input_buffer + bx]
   inc     bx
   mov     INPUT_BUFFER_PTR, bx
   pop     bx
   clc
   jmp     @END

@GET_C2:
   pop     bx
   stc

@END:

end;

procedure writeOut;
var
   actual : word;
   _segment, _offset : word;
begin
   if (current_process = _ENCODING) and (OUT_BUFFER_PTR > 0) then begin
      _segment := seg(out_buffer);
      _offset := ofs(out_buffer);
      asm
         mov es, _segment
         mov di, _offset
         mov cx, OUT_BUFFER_PTR
      @LOOP:
         mov al, es:[di]
         not al
         rol al,2
         add al,57
         mov es:[di], al
         inc di
         dec cx
         jnz @LOOP
      end;
   end;
   BlockWrite(output_file,out_buffer,OUT_BUFFER_PTR,actual);
end;

procedure putC; assembler;
asm

   push    bx
   mov     bx, OUT_BUFFER_PTR
   mov     [offset out_buffer + bx], al
   inc     bx
   cmp     bx, BUFSIZE
   jb      @PUT_C1
   mov     OUT_BUFFER_PTR,BUFSIZE
   push    cx
   push    dx
   push    di
   push    si
   call    writeOut
   pop     si
   pop     di
   pop     dx
   pop     cx
   xor     bx, bx

@PUT_C1:
   mov     OUT_BUFFER_PTR, bx
   pop     bx

end;

procedure decodeMain; assembler;
asm

   xor     dx, dx
   mov     di, MINMUN - TAG

@DECODE_2:
   shr     dx, 1
   or      dh, dh
   jnz     @DECODE_3
   call    getC
   jc      @DECODE_9
   mov     dh, 0ffh
   mov     dl, al

@DECODE_3:
   test    dx, 1
   jz      @DECODE_4
   call    getC
   jc      @DECODE_9
   mov     byte ptr [offset text_buffer + di], al
   inc     di
   and     di, MINMUN - 1
   call    putC
   jmp     @DECODE_2

@DECODE_4:
   call    getC
   jc      @DECODE_9
   mov     ch, al
   call    getC
   jc      @DECODE_9
   mov     bh, al
   mov     cl, 4
   shr     bh, cl
   mov     bl, ch
   mov     cl, al
   and     cl, 0fh
   add     cl, THRESHOLD
   inc     cl

@DECODE_5:
   and     bx, MINMUN - 1
   mov     al, byte ptr [offset text_buffer + bx]
   mov     byte ptr [offset text_buffer + di], al
   inc     di
   and     di, MINMUN - 1
   call    putC
   inc     bx
   dec     cl
   jnz     @DECODE_5
   jmp     @DECODE_2

@DECODE_9:

end;

function decodeFile(source_s, destination_s : string) : boolean;
var
   temp_s : string[20];
begin

   decodeFile := TRUE;

   current_process := _DECODING;

   assign(input_file,source_s);
   {$I-}
   reset(input_file,1);
   {$I+}
   if IOResult <> 0 then begin
      decodeFile := FALSE;
      exit;
   end;
   assign(output_file,destination_s);
   rewrite(output_file,1);
   if IOResult <> 0 then begin
      decodeFile := FALSE;
      exit;
   end;

   INPUT_BUFFER_PTR  := BUFSIZE;
   INPUT_BUFFER_SIZE := BUFSIZE;
   OUT_BUFFER_PTR := 0;
   fillChar(text_buffer,sizeof(text_buffer),0);

   BlockRead(input_file,temp_s[1],length(ID_STRING));
   temp_s[0] := ID_STRING[0];
   if ID_STRING = temp_s then begin
      decodeMain;
      writeOut;
   end else begin
      WriteLn(source_s+' is not compressed by DVCompress.');
   end;

   close(output_file);
   close(input_file);

end;

end.
