{$DEFINE _OVERLAY}

unit DVDecode;
{$IFDEF __OVERLAY}
   {$O+,F+}
{$ENDIF}

{$DEFINE __COMPILE_DEBUG}
{$X+}

INTERFACE

uses
   dos, graph, DVTMF,
   DVHan20, DVSubpro, DVPerson, DVPersn1, DVSpScpt;

 procedure convertImage(var source : original_sprite_T; var destination : image_T);
 procedure convertSprite(var source : original_sprite_T; var destination : sprite_T);
 procedure printCompileErrorMessage(error : integer; s : string);
 procedure printMessageWindow(message : string);
 procedure loadScript(file_name : longString);
 procedure removeScript;
 function  verifyExitMap(x,y : integer) : boolean;
 procedure printScriptTalk(s : longString);
 procedure talkSomeone(person_number : byte; is_full_talking : boolean);
 procedure actDecode;
 procedure toByte(s : longString; var v : byte);
 procedure toInteger(s : longString; var v : integer);
 function  returnMessage(s : longString) : longString;
 function  findCharInString(var s : longString; ch : char; ptr : integer) : byte;
 procedure removeCharacters(var source, destination : longString; ch : char);
 procedure shrinkCharacters(var source, destination : longString; ch : char);
 procedure seperateWord(var source, op_code, param_s : longString; from_ch, to_ch : char);
 procedure pulloutWord(var sour, return_s : longString; ch : char);
 function  excuteCommand(s : longString; param_value : integer) : boolean;

const
   MAX_RGS_DATA = 1000;
type
   string_data_T = array[1..MAX_RGS_DATA] of ^longString;
var
   MAX_EVENT_DATA, MAX_TIME_EVENT_DATA, MAX_TALK_DATA, MAX_LABEL : integer;
   MAX_SUBJECT_DATA : byte;
   SCROLL_RATE : real;
   RGS_data : string_data_T;
   subject_data : array[1..100] of ^shortString;
   label_address : array[-1..MAX_PERSON_ARRAY] of integer;
   talk_order : shortint;
   talk_selected_menu : integer;
   talk_trans_s : string;
   talk_person_x1, talk_person_y1 : shortint;
   talk_question_s : string;
   talk_trans_boolean, not_occur_NOT_operator : boolean;
   talk_select : ^select_O;
   talk_force_end, talk_press_any_key, talk_success_magic : boolean;
   EXIT_CONDITION : boolean;

IMPLEMENTATION

uses
   DVError;

const
   MAX_TALK_BUFFER = 10;
var
   talk_buffer : array[1..MAX_TALK_BUFFER] of byte;
   talk_buffer_ptr : byte;


procedure pushTalkBuffer(value : byte); forward;
function  popTalkBuffer(value : byte) : byte; forward;
procedure decodeString(var s : longString); forward;


procedure convertImage(var source : original_sprite_T; var destination : image_T);
var
   i,j,k,plane : integer;
begin
   i := 4;
   j := 0;
   k := 0;
   plane := 0;
   while j < IMAGE_SIZE do begin
      destination[j] := source[i];
      inc(j);
      inc(k);
      if k < 3 then begin
         inc(i);
      end
      else begin
         inc(i,10);
         k := 0;
      end;
      if i >= IMAGE_SIZE+4 then begin
         inc(plane);
         i := 4 + plane * 3;
      end;
   end;
end;

procedure convertSprite(var source : original_sprite_T; var destination : sprite_T);
var
   i,j,k,plane : integer;
begin
   i := 4;
   j := 0;
   k := 0;
   plane := 0;
   while j <= IMAGE_SIZE do begin
      destination[j] := source[i];
      inc(j);
      inc(k);
      if k < 3 then begin
         inc(i);
      end
      else begin
         inc(i,10);
         k := 0;
      end;
      if i >= IMAGE_SIZE+4 then begin
         inc(plane);
         i := 4 + plane * 3;
      end;
   end;

   i := 4;
   j := 0;
   k := 0;
   plane := 0;
   while j < IMAGE_SIZE/4 do begin
      destination[IMAGE_SIZE+j] := source[IMAGE_SIZE+6+i];
      inc(j);
      inc(k);
      if k < 3 then begin
         inc(i);
      end
      else begin
         inc(i,10);
         k := 0;
      end;
   end;
end;

procedure printCompileErrorMessage(error : integer; s : string);
begin
{$IFDEF __COMPILE_DEBUG}
   _ERROR_MESSAGE := s;
   _ERROR_NUMBER := error + 100;
   halt;
{$ENDIF}
end;

procedure toByte(s : longString; var v : byte);
var
   error_code : integer;
begin
   val(s,v,error_code);
   if error_code <> 0 then printCompileErrorMessage(3,s);
end;

procedure toInteger(s : longString; var v : integer);
var
   error_code : integer;
begin
   val(s,v,error_code);
   if error_code <> 0 then printCompileErrorMessage(4,s);
end;

function findCharInString(var s : longString; ch : char; ptr : integer) : byte;
var
   number_of_brace, genius_count : integer;
   ok : boolean;
begin
   if ch <> ']' then begin
      genius_count := 0;
      while (ptr <= ord(s[0])) and
            ((ch <> s[ptr]) or (genius_count <> 0)) do begin
         if s[ptr] = '"' then begin
            if genius_count = 0 then genius_count := 1
            else genius_count := 0;
         end;
         inc(ptr);
      end;
      if (ch = s[ptr]) then findCharInString := ptr
                       else findCharInString := ord(s[0])+1;
   end else begin
      if s[ptr] <> '[' then number_of_brace := 0
                       else number_of_brace := -1;
      ok := FALSE;
      while (ptr <= ord(s[0])) and (not ok) do begin
         if ch = s[ptr] then begin
            if number_of_brace <= 0 then ok := TRUE
            else begin
               dec(number_of_brace);
               inc(ptr);
            end;
         end
         else begin
            if s[ptr] = '[' then inc(number_of_brace);
            inc(ptr);
         end;
      end;
      if (ch = s[ptr]) then findCharInString := ptr
                       else findCharInString := ord(s[0])+1;
   end;
end;

procedure removeCharacters(var source, destination : longString; ch : char);
var
   temp_ptr, b : byte;
begin
   temp_ptr := 1;
   while source[temp_ptr] = ch do inc(temp_ptr);
   for b := temp_ptr to ord(source[0]) do begin
      destination[b-temp_ptr+1] := source[b];
   end;
   destination[0] := chr(ord(source[0]) - temp_ptr + 1);
end;

procedure shrinkCharacters(var source, destination : longString; ch : char);
var
   temp_ptr, b : byte;
   s : longString;
begin
   temp_ptr := 0;
   s := '';
   for b := 1 to ord(source[0]) do begin
      if source[b] <> ch then begin
         inc(temp_ptr);
         s[temp_ptr] := source[b];
      end;
   end;
   s[0] := chr(temp_ptr);
   destination := s;
end;

function divideOperand(var source : longString; var match_condition : boolean; param_value : integer) : boolean;
var
   s, temp_s, aux_s : longString;

begin
   s := source;
   pulloutWord(s,aux_s,' ');
   if aux_s = 'if' then begin
      removeCharacters(s,s,' ');
      temp_s := s;
      pulloutWord(s,aux_s,' ');
      if aux_s = 'not' then begin
         not_occur_NOT_operator := FALSE;
         removeCharacters(s,s,' ');
      end else begin
         not_occur_NOT_operator := TRUE;
         s := temp_s;
      end;
      match_condition := excuteCommand(s,param_value);
      match_condition := not(not_occur_NOT_operator xor match_condition);
      divideOperand := TRUE;
   end else begin
      divideOperand := FALSE;
   end;
end;

procedure seperateWord(var source, op_code, param_s : longString; from_ch, to_ch : char);
var
   i, s_ptr, temp_ptr : integer;
   temp_op_code, temp_param_s : longString;
begin
   s_ptr := findCharInString(source,from_ch,1);
   if s_ptr > ord(source[0]) then begin
      temp_op_code := source;
      temp_param_s := '';
   end else begin
      for i := 1 to s_ptr-1 do begin
         temp_op_code[i] := source[i];
      end;
      temp_op_code[0] := chr(s_ptr - 1);
      inc(s_ptr);
      temp_ptr := findCharInString(source,to_ch,s_ptr);
      for i := s_ptr to temp_ptr-1 do begin
         temp_param_s[i-s_ptr+1] := source[i];
      end;
      temp_param_s[0] := chr(temp_ptr - s_ptr);
   end;
   op_code := temp_op_code;
   param_s := temp_param_s;
end;

procedure pulloutWord(var sour, return_s : longString; ch : char);
var
   op_code, param_s : longString;
begin
   seperateWord(sour,op_code,param_s,ch,#0);
   sour := param_s;
   return_s := op_code;
end;

procedure printMessageWindow(message : string);
begin
   DVSubPro.printMessageWindow(message);
   scrollMap;
end;

function returnMessage(s : longString) : longString;
const
   MAX_RESERVED_WORD = 3;
   reserved_word : array[1..MAX_RESERVED_WORD] of longString = (
      'my name', 'your name', 'string valuable'
   );
   MAX_APPENDIX_WORD = 6;
   appendix_word : array[1..MAX_APPENDIX_WORD] of char = (
      'S', 'O', 'B', 'C', 'Z', 'W'
   );
var
   i, j : integer;
   exist_third : boolean;
   temp_s : longString;
   appendix_char : char;
   temp_name : string;
begin
   seperateWord(s,s,temp_s,'+',#0);
   if temp_s <> '' then begin
      appendix_char := temp_s[1];
      if appendix_char in ['a'..'z'] then
         appendix_char := chr(ord(appendix_char) - ord('a') + ord('A'));
   end else begin
      appendix_char := #0;
   end;
   for i := 1 to MAX_RESERVED_WORD do begin
      if reserved_word[i] = s then begin
         case i of
            1 : temp_s := person[_TALK_PERSON]^.returnName;
            2 : temp_s := person[_MAIN_CHARACTER]^.returnName;
            3 : temp_s := talk_trans_s;
         end;
         if appendix_char <> #0 then begin
            for j := 1 to MAX_APPENDIX_WORD do begin
               if appendix_char = appendix_word[j] then begin
                  if length(temp_s) > 0 then
                     exist_third := (ord(temp_s[length(temp_s)]) and $1F) > 1;
                  case j of
                     1 : if exist_third then temp_s := temp_s + 'e'
                                        else temp_s := temp_s + 'e';
                     2 : if exist_third then temp_s := temp_s + 'i'
                                        else temp_s := temp_s + 'i';
                     3 : if exist_third then temp_s := temp_s + ''
                                        else temp_s := temp_s + 'a';
                     4 : if exist_third then temp_s := temp_s + 'a'
                                        else temp_s := temp_s + '';
                     5 : if exist_third then temp_s := temp_s + '';
                     6 : if exist_third then temp_s := temp_s + ''
                                        else temp_s := temp_s + '';
                  end;
               end;
            end;
         end;
         returnMessage := temp_s;
         exit;
      end;
   end;
   returnMessage := '';
end;

procedure decodeString(var s : longString);
var
   complete_code, temp_s, remember_s : longString;
   s_ptr, complete_code_ptr, temp_ptr : byte;
   i : integer;
begin
   if s = '' then exit;
   s_ptr := 0;
   complete_code := '';
   complete_code_ptr := 0;
   while (s_ptr < ord(s[0])) do begin
      inc(s_ptr);
      temp_ptr := findCharInString(s,'[',s_ptr);
      if not (temp_ptr in [0..ord(s[0])]) then begin
         for i := s_ptr to ord(s[0]) do begin
            inc(complete_code_ptr);
            complete_code[complete_code_ptr] := s[i];
         end;
         complete_code[0] := chr(ord(complete_code[0])+ord(s[0])-s_ptr+1);
         s_ptr := ord(s[0]);
      end
      else begin
         for i := s_ptr to temp_ptr - 1 do begin
            inc(complete_code_ptr);
            complete_code[complete_code_ptr] := s[i];
         end;
         complete_code[0] := chr(ord(complete_code[0])+temp_ptr-s_ptr);
         s_ptr := temp_ptr;
         temp_ptr := findCharInString(s,']',s_ptr);
         if temp_ptr > ord(s[0]) then begin
            printCompileErrorMessage(5,s);
         end
         else begin
            temp_s := '';
            for i := s_ptr + 1 to temp_ptr - 1 do begin
               temp_s[i-s_ptr] := s[i];
            end;
            temp_s[0] := chr(temp_ptr-1-s_ptr);
            s_ptr := temp_ptr;
            complete_code := complete_code + returnMessage(temp_s);
            complete_code_ptr := ord(complete_code[0]);
         end;
      end;
   end;
   s := complete_code;
end;

procedure printScriptTalk(s : longString);
var
   talk_x_pos, talk_y_pos : integer;
begin
   inc(talk_order);
   decodeString(s);
   talk_x_pos := SCROLL_X_GAP + (TILE_X_SIZE div 2) +
                 SCROLL_X_WIDE * TILE_X_SIZE - length(s) div 2;
   talk_y_pos := (SCROLL_Y_GAP+8) div 16 + (SCROLL_Y_WIDE + talk_person_y1) * TILE_Y_SIZE div 26;
   printTalkHangul(talk_x_pos,talk_order+talk_y_pos,s,0);
end;

function excuteCommand(s : longString; param_value : integer) : boolean;
label
   VIVA_YK;
const
   MAX_COMMAND = 76;
   commands : array[1..MAX_COMMAND] of string[25] = (
{ 1}  'talk', 'remove talk', 'add talk', 'set flag', 'reset flag',
      'write map', 'set event time', 'press any key', 'delay', 'register message',
{11}  'clear talk', 'set color', 'talk from', 'exit', 'break',
      'initialize menu', 'remove menu', 'set menu', 'select menu', 'you drop item',
{21}  'you give item', 'I cast cure magic', 'scroll map', 'flip page', 'excute special script',
      'modify internal value', 'create person', 'dismiss person', 'fade out', 'fade in',
{31}  'print fading message', 'map boundary exit', 'run script', 'modify time', 'move person',
      'repeat', 'turn person', 'warp person', 'no code', 'add ability',
{41}  'add skill', 'add equipment', 'add magic', 'add item', 'append tile data',
      'append object data', 'append equipment data', 'append field data', 'append character data', 'pass time',
{51}  'run module', 'clear page', 'set selected parameter', 'set bool parameter', 'game over',
      'run start module', 'change main character', 'update game level', 'set item suffix', 'restore palette',
{61}  'initialize gradation', 'print gradation', 'set gradation type', 'set graphic mode', 'fade out color',
      'play music', 'end music', 'fill map', 'set recognition', 'reset recognition',
{71}  'fade in ALL', 'fade out ALL', 'skip key pressing', 'set gray palette', 'write object',
      'write crystal'
   );
   MAX_FUNCTION = 18;
   functions : array[1..MAX_FUNCTION] of string[30] = (
{ 1}   'you talked', 'flag is set', 'system time is', 'event map is', 'event is',
{ 6}   'event time is', 'you asked', 'you selected', 'you have item', 'I succeeded magic',
{11}   'system transfered TRUE', 'person exist', 'person is alive','person is active','person isn''t alive',
{16}   'detect person', 'you recognized', 'system minute is'
    );
   MAX_PARAMETER = 10;
var
   complete_code, temp_s, aux_s, remember_s, repeat_s : longString;
   aux_shortS : array[1..3] of longString;
   aux_byte : array[1..2] of integer;
   i, j, command_number : integer;
   param_i : array[1..MAX_PARAMETER] of integer;
   param_s : array[1..MAX_PARAMETER] of longString;
   param_b : array[1..MAX_PARAMETER] of boolean;
   match_condition, test_boolean : boolean;
   set_parameter : setBYTE;
   MA : map_attribute_T;
   temp_item : item_T;
   window : ^window_O;
   repeat_counter : integer;
   f1, f2 : file;
   temp_image : original_sprite_T;

begin
   repeat_counter := 1;
   repeat_s := '';

VIVA_YK:
   seperateWord(s,s,remember_s,';',#0);

   seperateWord(s,complete_code,temp_s,'(',')');
   set_parameter := [];
   while temp_s <> '' do begin
      pulloutWord(temp_s,aux_shortS[1],',');
      if findCharInString(aux_shortS[1],'.',1) < length(aux_shortS[1]) then begin
         seperateWord(aux_shortS[1],aux_shortS[2],aux_shortS[3],'.',#0);
         shrinkCharacters(aux_shortS[3],aux_shortS[3],'.');
         val(aux_shortS[2],aux_byte[1],i);
         if i = 0 then begin
            val(aux_shortS[3],aux_byte[2],i);
            if i = 0 then begin
               if aux_byte[1] < aux_byte[2] then
                  set_parameter := set_parameter + [aux_byte[1]..aux_byte[2]]
               else
                  set_parameter := set_parameter + [aux_byte[2]..aux_byte[1]];
            end;
         end;
      end
      else begin
         val(aux_shortS[1],aux_byte[1],i);
         if (i = 0) and (aux_byte[1] >= 0) and (aux_byte[1] < 256) then begin
            set_parameter := set_parameter + [aux_byte[1]];
         end;
      end;
   end;

   seperateWord(s,complete_code,temp_s,'(',')');
   for i := 1 to MAX_PARAMETER do begin
      param_i[i] := 0;
      param_s[i] := '';
      param_b[i] := FALSE;
   end;
   j := 0;
   while (temp_s <> '') and (j < MAX_PARAMETER) do begin
      pulloutWord(temp_s,aux_s,',');
      inc(j);
      val(aux_s,param_i[j],i);
      if i <> 0 then begin
         if aux_s = 'TRUE' then begin
            param_b[j] := TRUE;
         end
         else if aux_s = 'FALSE' then begin
            param_b[j] := FALSE;
         end
         else if (aux_s[1] = '"') and (aux_s[length(aux_s)] = '"') then begin
            removeCharacters(aux_s,param_s[j],'"');
            if param_s[j][0] <> #0 then dec(param_s[j][0]);
            decodeString(param_s[j]);
         end
         else begin
            if set_parameter = [] then printCompileErrorMessage(10,s);
         end;
      end;
   end;

   for command_number := 1 to MAX_COMMAND do begin
      if commands[command_number] = complete_code then begin
         case command_number of
            1 :
            begin
               setHanType(MYUNGJO);
               printScriptTalk(param_s[1]);
            end;
            2 : popTalkBuffer(param_i[1]);
            3 : pushTalkBuffer(param_i[1]);
            4 : game_system.setEventBit(param_i[1]);
            5 : game_system.resetEventBit(param_i[1]);
            6 :
            begin
               if not (param_i[1] in [0..4]) then begin
                  if param_b[4] = TRUE then param_i[4] := 1 else param_i[4] := 0;
               end;
               writeMapEXPAND(param_i[1],param_i[2],param_i[3],param_i[4]);
            end;
            7 : game_system.setEventTime(param_i[1],param_i[2],param_i[3],param_i[4],param_i[5]);
            8 :
            begin
               pressAnyKey;
               talk_order := 0;
            end;
            9 : waitVerticalRetrace(param_i[1]);
            10:
            begin
               if param_i[1] = 0 then param_i[1] := _MAIN_CHARACTER;
               registerMessage(param_i[1],param_s[2],param_i[3]);
            end;
            11:
            begin
               pressAnyKey;
               flipPageEASY;
               talk_order := 0;
            end;
            12: setHanColor(param_i[1]);
            13:
            begin
               if param_i[1] = 0 then param_i[1] := _MAIN_CHARACTER;
               person[param_i[1]]^.talkSentence(param_s[2]);
            end;
            14: talk_force_end := TRUE;
            15: EXIT_CONDITION := TRUE;
            16: new(talk_select,init);
            17: dispose(talk_select,done);
            18: talk_select^.setMenu(param_i[1],param_s[2]);
            19:
            begin
               param_i[MAX_PARAMETER] := getHanColor;
               talk_select^.setMenuMode(DELETED_MENU);
               j := 1;
               for i := 1 to param_i[2] do begin
                  if length(talk_select^.m[i]) > length(talk_select^.m[j]) then j := i;
               end;
               j := 40 - length(talk_select^.m[j]) div 2;
               talk_selected_menu := talk_select^.selectMenu(j,14,param_i[1],param_i[2]);
               flipPageEASY;
               setHanColor(param_i[MAX_PARAMETER]);
               setHanType(MYUNGJO);
               talk_order := 0;
            end;
            20: person[_MAIN_CHARACTER]^.dropSomethingEA(param_i[1],param_i[2],param_i[3],temp_item);
            21:
            begin
               person[_MAIN_CHARACTER]^.dropSomethingEA(param_i[1],param_i[2],param_i[3],temp_item);
               person[_TALK_PERSON]^.getSomething(temp_item);
            end;
            22: talk_success_magic := person[_MAIN_CHARACTER]^.carryOutCureMagic(param_i[1],FALSE);
            23:
            begin
               if not (param_i[1] in [1..MAX_PERSON_ARRAY]) then begin
                  scrollMap;
               end else begin
                  if person[param_i[1]] <> nil then begin
                     j := _MAIN_CHARACTER;
                     _MAIN_CHARACTER := param_i[1];
                     scrollMap;
                     _MAIN_CHARACTER := j;
                  end;
               end;
            end;
            24: flipPageEASY;
            25:
            begin
               case param_i[1] of
                  10 : excuteKnightTraining;
                  11 : excuteMagicTraining;
                  12 : excuteItemShop;
                  13 : excuteGrocery;
                  14 : excuteFixShop;
                  15 : excuteWeaponShop;
                  16 : excuteWeaponSell;
                  17 : excuteD2Jump;
                  18 : excuteAppraisal;
                  19 : appearAlbireo;
                  20 : disappearAlbireo;
                  21 : excuteGoldChanging;
                  22 : excuteJewelChanging;
                  23 : excuteDispatch;
                  24 : determineFin1;
                  25 : createFieldBattle(param_i[2]);
                  100: displayFin1Title;
               end;
               talk_press_any_key := FALSE;
            end;
            26:
            begin
               if param_i[1] = 0 then param_i[1] := _MAIN_CHARACTER;
               if person[param_i[1]] <> nil then
                  person[param_i[1]]^.setInternal(internal_T(param_i[2]),param_i[3]);
            end;
            27:
            begin
               if param_i[1] = 0 then begin
                  inc(param_i[1]);
                  while (param_i[1] <= MAX_PERSON_ARRAY) and (person[param_i[1]] <> nil) do inc(param_i[1]);
               end;
               if param_i[1] > MAX_PERSON_ARRAY then printCompileErrorMessage(9,'No sources');
               if max_person < param_i[1] then max_person := param_i[1];
               if person[param_i[1]] = nil then begin
                  person[param_i[1]] := new(simple_person_type,
                     init(param_i[1],param_i[2],magic_need_T(param_i[3]),MA_PERSON,param_s[4],param_i[5],TRUE));
               end
               else begin
                  printCompileErrorMessage(12,'No sources');
               end;
            end;
            28:
            begin
               if param_i[1] = 0 then param_i[1] := _MAIN_CHARACTER;
               if person[param_i[1]] <> nil then begin
                  if param_i[1] <> _MAIN_CHARACTER then begin
                     writeMap(MA_PERSON,person[param_i[1]]^.returnX,
                              person[param_i[1]]^.returnY,0);
                     dispose(person[param_i[1]],done);
                     person[param_i[1]] := nil;
                  end;
               end;
            end;
            29 : PlainOut;
            30 : PlainIn;
            31 : printFadingMessage(param_s[1],param_b[2]);
            32 : map_header.enable_boundary_exit := param_b[1];
            33 :
            begin
               game_system._NEXT_EXCUTE_FILE := param_s[1];
               game_system._NEXT_START_X := param_i[2];
               game_system._NEXT_START_Y := param_i[3];
               user_key := EXIT_CODE;
               talk_force_end := TRUE;
            end;
            34 :
            begin
               game_system.m_hour := param_i[1];
               game_system.m_minute := param_i[2];
            end;
            35 :
            begin
               if param_i[1] = 0 then param_i[1] := _MAIN_CHARACTER;
               person[param_i[1]]^.moveTo(param_i[2],param_i[3]);
            end;
            36 :
            begin
               repeat_counter := param_i[1];
               repeat_s := remember_s;
            end;
            37 :
            begin
               if param_i[1] = 0 then param_i[1] := _MAIN_CHARACTER;
               with person[param_i[1]]^ do begin
                  if param_s[2] =    'up' then setFaceCount(6);
                  if param_s[2] =  'down' then setFaceCount(0);
                  if param_s[2] =  'left' then setFaceCount(2);
                  if param_s[2] = 'right' then setFaceCount(4);
               end;
            end;
            38 :
            begin
               if param_i[1] = 0 then param_i[1] := _MAIN_CHARACTER;
               if person[param_i[1]] <> nil then
                  person[param_i[1]]^.warpTo(param_i[2],param_i[3]);
            end;
            39 :
            begin
               pressanykey;
            end;
            40 :
            begin
               if param_i[1] = 0 then param_i[1] := _MAIN_CHARACTER;
               person[param_i[1]]^.addAbilityALL(param_s[2]);
            end;
            41 :
            begin
               if param_i[1] = 0 then param_i[1] := _MAIN_CHARACTER;
               person[param_i[1]]^.addSkillALL(param_s[2]);
            end;
            42 :
            begin
               if param_i[1] = 0 then param_i[1] := _MAIN_CHARACTER;
               person[param_i[1]]^.addEquipmentALL(param_s[2]);
            end;
            43 :
            begin
               if param_i[1] = 0 then param_i[1] := _MAIN_CHARACTER;
               person[param_i[1]]^.addMagicALL(param_s[2]);
            end;
            44 :
            begin
               if param_i[1] = 0 then param_i[1] := _MAIN_CHARACTER;
               person[param_i[1]]^.addItemALL(param_s[2]);
            end;
            45 :
            begin
               assign(f1,param_s[2]+'.img');
               {$I-}
               reset(f1,1);
               {$I+}
               if IOResult <> 0 then exit;

               for i := 1 to param_i[3] do begin
                  BlockRead(f1,temp_image,IMAGE_SIZE+6);
               end;
               for i := param_i[1] to param_i[1] + param_i[4] - 1 do begin
                  BlockRead(f1,temp_image,IMAGE_SIZE+6);
                  convertImage(temp_image,tile_data[i]^);
               end;
               close(f1);
            end;
            46..49 :
            begin
               assign(f1,param_s[2]+'.spr');
               {$I-}
               reset(f1,1);
               {$I+}
               if IOResult <> 0 then exit;
               assign(f2,param_s[2]+'.bsp');
               {$I-}
               reset(f2,1);
               {$I+}
               if IOResult <> 0 then begin
                  close(f1);
                  exit;
               end;

               for i := 1 to param_i[3] do begin
                  BlockRead(f1,temp_image,IMAGE_SIZE+6);
                  BlockRead(f2,temp_image[IMAGE_SIZE+6],IMAGE_SIZE+6);
               end;
               for i := param_i[1] to param_i[1] + param_i[4] - 1 do begin
                  BlockRead(f1,temp_image,IMAGE_SIZE+6);
                  BlockRead(f2,temp_image[IMAGE_SIZE+6],IMAGE_SIZE+6);
                  case command_number of
                     46 : convertSprite(temp_image,object_tile_data[i]^);
                     47 : convertSprite(temp_image,equipment_tile_data[i]^);
                     48 : convertSprite(temp_image,field_tile_data[i]^);
                     49 : convertSprite(temp_image,character_tile_data[i]^);
                  end;
               end;
               close(f1);
               close(f2);
            end;
            50 : game_system.passTime(param_i[1],param_i[2],param_i[3],param_i[4]);
            51 :
            begin
               talkSomeone(param_i[1],FALSE);
               talk_force_end := TRUE;
            end;
            52 : clearPage(param_i[1]);
            53 : talk_selected_menu := param_i[1];
            54 : talk_trans_boolean := param_b[1];
            55 :
            begin
               game_system._NEXT_EXCUTE_FILE := '';
               user_key := EXIT_CODE;
               talk_force_end := TRUE;
            end;
            56 :
            begin
               if param_i[1] = 0 then param_i[1] := _MAIN_CHARACTER;
               _PERSON_CONTROLL_CODE := OCCUR_TALK;
               _TALK_PERSON := param_i[1];
            end;
            57 : if param_i[1] in [1..max_person] then
                 if person[param_i[1]] <> nil then _MAIN_CHARACTER := param_i[1];
            58 :
            begin
               inc(game_system.m_proceeding_level);
               for i := 100 to 399 do game_system.resetEventBit(i);
            end;
            59 :
            if (param_i[1] in [0..game_system.returnMapXMax-1]) and
               (param_i[2] in [0..game_system.returnMapYMax-1]) then begin
               if readMap(MA_OBJECT,param_i[1],param_i[2]) > 0 then begin
                  if not returnItemMap(param_i[1],param_i[2],temp_item) then begin
                     convertObjectToItem(readMap(MA_OBJECT,param_i[1],param_i[2]),temp_item);
                  end;
                  temp_item._item_suffix := param_i[3];
                  writeMap(MA_OBJECT,param_i[1],param_i[2],0);
                  setItemMap(param_i[1],param_i[2],temp_item);
               end;
            end;
            60 :
            for i := 0 to 15 do begin
               setPalette(i);
               setRGB(i,palette_data[i,1],palette_data[i,2],palette_data[i,3]);
            end;
            61 :
            begin
               setGradationColor(param_i[1]);
               talk_order := -6;
            end;
            62 :
            begin
               inc(talk_order);
               decodeString(param_s[1]);
               param_i[1] := SCROLL_X_GAP + (TILE_X_SIZE div 2) +
                             SCROLL_X_WIDE * TILE_X_SIZE - length(param_s[1]) div 2;
               param_i[2] := (SCROLL_Y_GAP+8) div 16 +
                             SCROLL_Y_WIDE * TILE_Y_SIZE div 26;
               printHangulGRADATION(param_i[1]*8,(talk_order+param_i[2])*16,param_s[1],1);
            end;
            63 : setGradationType(han_gradation_T(param_i[1]));
            64 :
            if param_s[1] = '480' then begin
               waitVerticalRetrace(1);
               closeGraph;
               i := VGA;
               j := VGAHi;
               waitVerticalRetrace(1);
               initGraph(i,j,'');
            end else begin
               waitVerticalRetrace(1);
               closeGraph;
               i := VGA;
               j := VGAMed;
               waitVerticalRetrace(1);
               initGraph(i,j,'');

               asm
                  mov dx, $3CC
                  in  al, dx
                  and al, 00111111b
                  or  al, 01000000b
                  mov dx, $3C2
                  out dx, al
               end;
            end;
            65 : fadeOutGradationColor(param_i[1]);
            66 :
            if DETECT_SOUND_CARD then begin
               if param_s[1] = '' then
                  loadTMF(map_header.music_data_file)
               else
                  loadTMF(param_s[1]);
               playTMF;
            end;
            67 :
            if DETECT_SOUND_CARD then begin
               endTMF;
            end;
            68 :
            begin
               if not (param_i[1] in [0..4]) then begin
                  if param_b[6] = TRUE then param_i[6] := 1 else param_i[6] := 0;
               end;
               fillMap(param_i[1],param_i[2],param_i[3],param_i[4],param_i[5],param_i[6]);
            end;
            69,70 :
            begin
               if param_i[1] = 0 then param_i[1] := _TALK_PERSON;
               if command_number = 69 then
                  recognizable_person := recognizable_person + [param_i[1]]
               else
                  recognizable_person := recognizable_person - [param_i[1]];
            end;
            71 : fadeIn(palette_data,1);
            72 : fadeOut(palette_data,1);
            73 : talk_press_any_key := FALSE;
            74 : convertBWScale(palette_data);
            75 :
            if (param_i[1] in [0..game_system.returnMapXMax-1]) and
               (param_i[2] in [0..game_system.returnMapYMax-1]) then begin
                  convertObjectToItem(param_i[3],temp_item);
                  temp_item._item_suffix := param_i[4];
                  setItemMap(param_i[1],param_i[2],temp_item);
            end;
            76 :
            if (param_i[1] in [0..game_system.returnMapXMax-1]) and
               (param_i[2] in [0..game_system.returnMapYMax-1]) then begin
                  convertObjectToItem(__ITEM_CRYSTAL+ADDRESS_OF_WEAPON_IN_OBJECT_TILE,temp_item);
                  temp_item._item_magic_type := magic_type_T(param_i[3]);
                  temp_item._item_magic := param_i[4];
                  setItemMap(param_i[1],param_i[2],temp_item);
            end;
         end;
         if remember_s <> '' then begin
            removeCharacters(remember_s,s,' ');
            goto VIVA_YK;
         end;
         dec(repeat_counter);
         if repeat_counter > 0 then begin
            removeCharacters(repeat_s,s,' ');
            goto VIVA_YK;
         end;
         s := '';
         exit;
      end;
   end;
   for command_number := 1 to MAX_COMMAND do begin
      if functions[command_number] = complete_code then begin
         case command_number of
            1 :
            begin
               match_condition := param_value in set_parameter;
               if (param_value = 0) and
                  (not(not_occur_NOT_operator xor match_condition)) then begin
                  setMaxInputByte(20);
                  new(window,init(30,7,51,8,1,TRUE));
                  setHanType(SAMMUL);
                  setHanColor(WHITE);
                  talk_question_s := inputHangul(30*8,7*16,'',1,TRUE);
                  temp_s := talk_question_s;
                  shrinkCharacters(temp_s,temp_s,' ');
                  talk_question_s := temp_s;
                  setHanType(MYUNGJO);
                  dispose(window,done);
               end;
            end;
            2 :
            begin
               match_condition := TRUE;
               j := 1;
               while (param_i[j] <> 0) and (j <= 10) do begin
                  if not game_system.getEventBit(param_i[j]) then begin
                     match_condition := FALSE;
                  end;
                  inc(j);
               end;
            end;
            3 : match_condition := game_system.returnHour in set_parameter;
            4 : match_condition := ((_EVENT_X_POSITION = param_i[1]) or (param_i[1] < 0)) and
                                   ((_EVENT_Y_POSITION = param_i[2]) or (param_i[2] < 0));
            5 : match_condition :=
                   (readMap(MA_ATTRIBUTE,_EVENT_X_POSITION,_EVENT_Y_POSITION) and EVENT_BIT) = param_i[1];
            6 : match_condition := param_i[1] = param_value;
            7 : match_condition := talk_question_s = param_s[1];
            8 : match_condition := talk_selected_menu in set_parameter;
            9 : match_condition := person[_MAIN_CHARACTER]^.haveEnoughIt(param_i[1],param_i[2],param_i[3]);
            10: match_condition := talk_success_magic;
            11: match_condition := talk_trans_boolean;
            12..15:
            begin
               match_condition := TRUE;
               j := 1;
               while (param_i[j] > 0) and (j <= 10) do begin
                  case command_number of
                     12 : match_condition := match_condition and (person[param_i[j]] <> nil);
                     13,14,15 :
                     if person[param_i[j]] <> nil then begin
                        case command_number of
                           13 : test_boolean := person[param_i[j]]^.returnInternal(_death_depth) <= 0;
                           14 : test_boolean := person[param_i[j]]^.isActiveCondition;
                           15 : test_boolean := person[param_i[j]]^.returnInternal(_death_depth) > 0;
                        end;
                        match_condition := match_condition and test_boolean;
                     end else begin
                        if command_number in [13,14] then begin
                           match_condition := FALSE;
                           j := 10;
                        end;
                     end;
                  end;
                  inc(j);
               end;
            end;
            16:
            begin
               if param_i[1] = 0 then param_i[1] := _MAIN_CHARACTER;
               match_condition := FALSE;
               if (person[param_i[1]] <> nil) and (person[param_i[1]]^.isActiveCondition) and
                  (person[param_i[2]] <> nil) and (person[param_i[2]]^.isActiveCondition) then begin
                  for j := -param_i[3] to param_i[3] do begin
                     for i := -param_i[3] to param_i[3] do begin
                        if readMap(MA_PERSON,person[param_i[1]]^.returnX+i,person[param_i[1]]^.returnY+j)
                           = param_i[2] then match_condition := TRUE;
                     end;
                  end;
               end;
            end;
            17:
            begin
               if set_parameter = [] then set_parameter := [_TALK_PERSON];
               match_condition := (set_parameter * recognizable_person) = set_parameter;
            end;
            18:
            begin
               match_condition := (game_system.returnHour = param_i[1])
                                  and (game_system.returnMinute = param_i[2]);
            end;
         end;
         excuteCommand := match_condition;
         exit;
      end;
   end;
   printCompileErrorMessage(11,s);
end;

function returnTalkSubjectString(number : byte) : longString;
var
   s : longString;
begin
   if number in [1..MAX_SUBJECT_DATA] then begin
      s := subject_data[number]^;
      decodeString(s);
      returnTalkSubjectString := s;
   end
   else if number = 0 then begin
      returnTalkSubjectString := '......i a';
   end
   else
      returnTalkSubjectString := '';
end;

procedure pushTalkBuffer(value : byte);
var
   i,position : integer;
begin
   position := 0;
   for i := 1 to talk_buffer_ptr do begin
      if talk_buffer[i] = value then position := i;
   end;
   if position = 0 then begin
      inc(talk_buffer_ptr);
      if talk_buffer_ptr in [1..MAX_TALK_BUFFER] then
         talk_buffer[talk_buffer_ptr] := value
      else
         dec(talk_buffer_ptr);
   end;
end;

function popTalkBuffer(value : byte) : byte;
var
   i, position : integer;
begin
   position := 0;
   for i := 1 to talk_buffer_ptr do begin
      if talk_buffer[i] = value then position := i;
   end;
   if position in [1..talk_buffer_ptr] then begin
      popTalkBuffer := talk_buffer[position];
      for i := position to (talk_buffer_ptr-1) do
         talk_buffer[i] := talk_buffer[i+1];
      dec(talk_buffer_ptr);
   end else begin
      popTalkBuffer := 0;
   end;
end;

function talkSomeoneSelection(var remember_selected_talk : byte) : byte;
var
   i, selected_talk : integer;
   max_length : byte;
   talk_x_pos, talk_y_pos : byte;
   s : longString;
   select : ^select_O;
begin
   new(select,init);

   if talk_buffer_ptr > 0 then begin
      flipPageEASY;
      with select^ do begin
         max_length := 0;
         for i := 1 to talk_buffer_ptr do begin
            s := returnTalkSubjectString(talk_buffer[i]);
            setMenu(i,s);
            if length(s) > max_length then max_length := length(s);
         end;
         talk_x_pos := SCROLL_X_GAP + (TILE_X_SIZE div 2) + SCROLL_X_WIDE * TILE_X_SIZE - max_length div 2;
         talk_y_pos := (SCROLL_Y_GAP+8) div 16 + (SCROLL_Y_WIDE + 1) * TILE_Y_SIZE div 16;
         setColor(5);
         rectangle(talk_x_pos*8-2,talk_y_pos*16-2,(talk_x_pos+max_length)*8+2,(talk_y_pos+talk_buffer_ptr)*16+1);
         setColor(9);
         rectangle(talk_x_pos*8-3,talk_y_pos*16-3,(talk_x_pos+max_length)*8+3,(talk_y_pos+talk_buffer_ptr)*16+2);
         setMenuMode(BOLD_MENU);
         selected_talk := selectMenu(talk_x_pos,talk_y_pos,remember_selected_talk,talk_buffer_ptr);
         setMenuMode(NORMAL_MENU);
      end;
   end
   else selected_talk := 0;
   if selected_talk = 0 then selected_talk := 1;
   remember_selected_talk := selected_talk;
   talkSomeoneSelection := selected_talk;
   dispose(select,done);
end;

procedure ProcessRoutine1(condition : boolean;var temp_ptr : integer; selected_talk, max_data : integer);
 const
    MAX_IF_CONDITION = 0;
    if_condition : array[-2..MAX_IF_CONDITION] of string[10] = (
       'else', 'end if', 'END SCRIPT'
    );
 var
    i : integer;
    temp_count : integer;
    match_condition, ok : boolean;
 begin
    inc(temp_ptr);
    if condition then begin
       if temp_ptr > max_data then EXIT_CONDITION := TRUE;
       while not (EXIT_CONDITION or talk_force_end) do begin
          if divideOperand(RGS_data[temp_ptr]^,match_condition,selected_talk) then begin
             ProcessRoutine1(match_condition,temp_ptr,selected_talk,max_data);
          end else begin
             for i := -2 to 0 do
             if RGS_data[temp_ptr]^ = if_condition[i] then begin
                case i of
                  -2 :
                   begin
                      temp_count := 0;
                      ok := FALSE;
                      while not ok do begin
                         if (RGS_data[temp_ptr]^[1] = 'i') and
                            (RGS_data[temp_ptr]^[2] = 'f') then inc(temp_count);
                         if (RGS_data[temp_ptr]^ = if_condition[-1]) then begin
                            if temp_count = 0 then ok := TRUE
                            else dec(temp_count);
                         end;
                         inc(temp_ptr);
                      end;
                   end;
                  -1 : inc(temp_ptr);
                   0 : EXIT_CONDITION := TRUE;
                end;
                exit;
             end;
             if not EXIT_CONDITION then begin
                excuteCommand(RGS_data[temp_ptr]^,selected_talk);
                inc(temp_ptr);
             end;
          end;
          if temp_ptr > max_data then EXIT_CONDITION := TRUE;
       end;
    end
    else begin
       temp_count := 0;
       ok := FALSE;
       while not ok do begin
          if (RGS_data[temp_ptr]^[1] = 'i') and
             (RGS_data[temp_ptr]^[2] = 'f') then inc(temp_count);
          if (RGS_data[temp_ptr]^ = if_condition[-1]) then begin
             if temp_count = 0 then ok := TRUE
             else dec(temp_count);
          end;
          if (RGS_data[temp_ptr]^ = if_condition[-2]) then begin
             if temp_count = 0 then begin
                ok := TRUE;
                ProcessRoutine1(TRUE,temp_ptr,selected_talk,max_data);
                dec(temp_ptr);
             end;
          end;
          inc(temp_ptr);
       end;
    end;
end;

procedure talkSomeone(person_number : byte; is_full_talking : boolean);
var
   c : char;
   remember_selected_talk : byte;
   selected_talk, talk_data_ptr, temp_ptr, remember_face_count : integer;
   f : file;
   i, end_talk_address : integer;
   temp_s : longString;
   not_read_all_data : boolean;
begin
   i := 1;
   while i <= MAX_MESSAGE_ARRAY do begin
      if message[i] <> nil then begin
         with message[i]^ do begin
            if message_person in [_MAIN_CHARACTER,person_number] then begin
               removeMessage(i);
            end;
         end;
      end;
      inc(i);
   end;

   if is_full_talking then begin
      if person_number <> 0 then begin
         if label_address[person_number] = 0 then exit;
         if not person[person_number]^.isActiveCondition then exit;
         if not (person_number in invoid_person_movement_data) then exit;
         if not (person_number in talkable_person) then exit;
         if person[person_number]^.returnInternal(_hostile) =
            person[_MAIN_CHARACTER]^.returnNumber then exit;
         if person_movement_data[person[person_number]^.returnNumber].
            which_movement <> 0 then exit;
         talk_person_x1 := person[person_number]^.returnX - person[_MAIN_CHARACTER]^.returnX;
         talk_person_y1 := person[person_number]^.returnY - person[_MAIN_CHARACTER]^.returnY;
         remember_face_count := person[person_number]^.returnFaceCount;
         person[person_number]^.turnFace(-talk_person_x1,-talk_person_y1);
         scrollMap;
         flipPage;
      end;
   end;
   if person_number = 0 then person_number := 1;

   assign(f,TEMPLET_FILE);
   {$I-}
   reset(f,sizeof(longString));
   {$I+}
   if IOResult <> 0 then printErrorMessage(1,TEMPLET_FILE);

   for i := label_address[2] to label_address[person_number]-1 do begin
      BlockRead(f,temp_s,1);
   end;

   not_read_all_data := TRUE;
   i := label_address[2];
   while not_read_all_data do begin
      new(RGS_data[i]);
      BlockRead(f,RGS_data[i]^,1);
      if RGS_data[i]^ = 'END SCRIPT' then
         not_read_all_data := FALSE
      else
         inc(i);
   end;

   end_talk_address := i;
   close(f);

   setHanType(MYUNGJO);
   remember_selected_talk := 2;
   talk_buffer_ptr := 0;
   talk_data_ptr := label_address[2];
   temp_ptr := talk_data_ptr - 1;

   while RGS_data[talk_data_ptr]^ <> 'BEGIN SCRIPT' do inc(talk_data_ptr);
   EXIT_CONDITION := FALSE;
   talk_force_end := FALSE;
   while (temp_ptr <= talk_data_ptr-1) and (not EXIT_CONDITION) do begin
      talk_order := 0;
      ProcessRoutine1(TRUE,temp_ptr,0,talk_data_ptr-1);
   end;
   if is_full_talking then begin

      repeat
         selected_talk := talk_buffer[talkSomeoneSelection(remember_selected_talk)];
         flipPageEASY;
         temp_ptr := talk_data_ptr;
         EXIT_CONDITION := FALSE; talk_order := 0;
         talk_press_any_key := TRUE;
         setHanColor(15);
         ProcessRoutine1(TRUE,temp_ptr,selected_talk,MAX_TALK_DATA);
         setHanColor(15);
         if (not talk_force_end) and talk_press_any_key then c := readKey;
      until (remember_selected_talk = 1) or talk_force_end;

   end else begin
      EXIT_CONDITION := FALSE; talk_order := 0;
      talk_force_end := FALSE;
      ProcessRoutine1(TRUE,temp_ptr,0,MAX_TALK_DATA);
   end;

   for i := label_address[2] to end_talk_address do begin
      dispose(RGS_data[i]);
      RGS_data[i] := nil;
   end;

   if is_full_talking and (not talk_force_end) and (user_key <> EXIT_CODE) then begin
      person[person_number]^.setFaceCount(remember_face_count);
      scrollMap;
      flipPageEASY;
   end;

   setHanType(SAMMUL);

end;

procedure occurEvent(x,y : integer);
var
   event_data_ptr : integer;
begin
   event_data_ptr := label_address[-1]-1;
   EXIT_CONDITION := FALSE; talk_order := 0;
   talk_force_end := FALSE;
   ProcessRoutine1(TRUE,event_data_ptr,0,MAX_EVENT_DATA);
   if (user_key <> EXIT_CODE) then begin
      flipPageEASY;
   end;
   setHanType(SAMMUL);
end;

procedure occurTimeEvent(event_number : integer);
var
   time_event_data_ptr : integer;
begin
   game_system.setEventTime(0,0,0,0,0);
   time_event_data_ptr := label_address[0]-1;
   EXIT_CONDITION := FALSE; talk_order := 0;
   talk_force_end := FALSE;
   ProcessRoutine1(TRUE,time_event_data_ptr,event_number,MAX_TIME_EVENT_DATA);
   if (user_key <> EXIT_CODE) then begin
      flipPageEASY;
   end;
   setHanType(SAMMUL);
end;

procedure loadScript(file_name : longString);
type
   buffer_T = array[2..MAX_PERSON_ARRAY] of byte;
var
   label_name : array[0..MAX_PERSON_ARRAY] of longString;
   i, remember_label : integer;
   b : byte;
   f : text;
   temp_f : file;
   s, op_code, param_s : longString;
   temp_item : item_T;
   AT : ability_T;
   ST : skill_T;
   ET : equipment_T;
   MT : magic_type_T;
   buffer : ^buffer_T;
begin
   MAX_EVENT_DATA := 0;
   MAX_SUBJECT_DATA := 0;
   MAX_TALK_DATA := 0;
   MAX_LABEL := 0;
   fillchar(person_movement_data,sizeof(person_movement_data),#0);
   fillchar(label_name,sizeof(label_name),#0);
   assign(f,file_name+'.MV');
   {$I-}
   reset(f);
   {$I+}
   if IOResult <> 0 then exit;

   assign(temp_f,TEMPLET_FILE);
   rewrite(temp_f,1);
   s := '';
   readLn(f,s);
   while (not eof(f)) and (s <> 'BEGIN EVENT SCRIPT') do readLn(f,s);
   if s = 'BEGIN EVENT SCRIPT' then begin
      label_address[-1] := 1;
      readLn(f,s);
      while (not eof(f)) and (s <> 'END EVENT SCRIPT') do begin
         if (s <> '') and (s[1] <> '/') then begin
            inc(MAX_TALK_DATA);
            new(RGS_data[MAX_TALK_DATA]);
            removeCharacters(s,RGS_data[MAX_TALK_DATA]^,' ');
         end;
         readLn(f,s);
      end;
      MAX_EVENT_DATA := MAX_TALK_DATA;
   end;
   readLn(f,s);
   while (not eof(f)) and ((s = '') or (s[1] = '/')) do readLn(f,s);
   if s = 'BEGIN TIME EVENT SCRIPT' then begin
      label_address[0] := MAX_TALK_DATA + 1;
      readLn(f,s);
      while (not eof(f)) and (s <> 'END TIME EVENT SCRIPT') do begin
         if (s <> '') and (s[1] <> '/') then begin
            inc(MAX_TALK_DATA);
            new(RGS_data[MAX_TALK_DATA]);
            removeCharacters(s,RGS_data[MAX_TALK_DATA]^,' ');
         end;
         readLn(f,s);
      end;
      MAX_TIME_EVENT_DATA := MAX_TALK_DATA;
   end;
   readLn(f,s);
   while (not eof(f)) and ((s = '') or (s[1] = '/')) do readLn(f,s);
   if s = 'TALK SUBJECT DEFINITION' then begin
      readLn(f,s);
      while (not eof(f)) and (s <> 'END DEFINITION') do begin
         if (s <> '') and (s[1] <> '/') then begin
            inc(MAX_SUBJECT_DATA);
            new(subject_data[MAX_SUBJECT_DATA]);
            removeCharacters(s,s,' ');
            seperateWord(s,op_code,param_s,'"','"');
            subject_data[MAX_SUBJECT_DATA]^ := param_s;
         end;
         readLn(f,s);
      end;
   end;
   readLn(f,s);
   while (not eof(f)) and ((s = '') or (s[1] = '/')) do readLn(f,s);
   if s = 'LABEL DEFINITION' then begin
      label_name[0] := 'AutoStart';
      readLn(f,s);
      while (not eof(f)) and (s <> 'END DEFINITION') do begin
         if (s <> '') and (s[1] <> '/') then begin
            inc(MAX_LABEL);
            removeCharacters(s,label_name[MAX_LABEL],' ');
         end;
         readLn(f,s);
      end;
   end;
   max_person := MAX_LABEL+1;
   label_address[1] := 0;
   while not eof(f) do begin
      readLn(f,s);
      if (s <> '') and (s[1] <> '/') then begin
         if s[1] = ':' then begin
            removeCharacters(s,s,':');
            for i := 1 to MAX_LABEL+1 do begin
               if label_name[i-1] = s then begin
                  remember_label := i;
                  label_address[i] := MAX_TALK_DATA+1;
               end;
            end;
         end
         else if s = 'MOVEMENT DEFINITION' then begin
            if remember_label > MAX_PERSON_ARRAY then printCompileErrorMessage(9,'No sources');
            if person[remember_label] <> nil then printCompileErrorMessage(12,'No sources');
            person[remember_label] := new(simple_person_type,init(remember_label,0,mgc_player,MA_PERSON,'',8,TRUE));
            invoid_person_movement_data := invoid_person_movement_data + [remember_label];
            talkable_person := talkable_person + [remember_label];
            readLn(f,s);
           with person_movement_data[remember_label] do begin
            number_of_movement := 0;
            while s <> 'END DEFINITION' do begin
               removeCharacters(s,s,' ');
               if (s <> '') and (s[1] <> '/') then begin
                  seperateWord(s,op_code,param_s,'<','>');
                  if op_code = 'mute' then begin
                     talkable_person := talkable_person - [remember_label];
                  end;
                  if op_code = 'name' then begin
                     person[remember_label]^.setName(param_s);
                     person[remember_label]^.setNumber(remember_label);
                  end;
                  if op_code = 'face' then begin
                     toInteger(param_s,i);
                     person[remember_label]^.setFace(i);
                  end;
                  if op_code = 'ability' then begin
                     person[remember_label]^.setAbilityALL(param_s);
                  end;
                  if op_code = 'skill' then begin
                     person[remember_label]^.setSkillALL(param_s);
                  end;
                  if op_code = 'equipment' then begin
                     person[remember_label]^.setEquipmentALL(param_s);
                  end;
                  if op_code = 'magic' then begin
                     person[remember_label]^.setMagicALL(param_s);
                  end;
                  if op_code = 'item' then begin
                     person[remember_label]^.setItemALL(param_s);
                  end;
                  if op_code = 'time' then begin
                     inc(number_of_movement);
                     final_face[number_of_movement] := 0;
                     seperateWord(param_s,op_code,param_s,'.',#0);
                     toByte(op_code,movement[number_of_movement].from_hour);
                     removeCharacters(param_s,param_s,'.');
                     toByte(param_s,movement[number_of_movement].to_hour);
                     readLn(f,s);
                     removeCharacters(s,s,' ');
                     movement[number_of_movement].number_of_position := 0;
                     while s <> '' do begin
                        seperateWord(s,op_code,s,'-',#0);
                        if op_code[1] = '(' then begin
                           inc(movement[number_of_movement].number_of_position);
                           removeCharacters(op_code,op_code,'(');
                           seperateWord(op_code,op_code,param_s,',',')');
                           toByte(op_code,
                               movement[number_of_movement].position[movement[number_of_movement].number_of_position][1]);
                           toByte(param_s,
                               movement[number_of_movement].position[movement[number_of_movement].number_of_position][2]);
                        end
                        else begin
                           seperateWord(op_code,op_code,param_s,'(',')');
                           if op_code <> 'faced' then begin
                              s := op_code;
                              printCompileErrorMessage(6,s);
                           end;
                           if param_s = 'up' then final_face[number_of_movement] := 7
                           else if param_s = 'down' then final_face[number_of_movement] := 1
                           else if param_s = 'left' then final_face[number_of_movement] := 3
                           else if param_s = 'right' then final_face[number_of_movement] := 5
                           else begin
                              s := op_code + '(' + param_s + ')';
                              printCompileErrorMessage(7,s);
                           end;
                        end;
                     end;
                  end;
               end;
               readLn(f,s);
            end;
           end;
            person[remember_label]^.setInitialPosition;
            person[remember_label]^.modifyInternalValue;
         end
         else begin
            inc(MAX_TALK_DATA);
            if MAX_TALK_DATA = 190 then begin
               MAX_TALK_DATA := 190;
            end;
            removeCharacters(s,s,' ');
            BlockWrite(temp_f,s,sizeof(longString));
         end;
      end;
   end;

   close(temp_f);
   close(f);

   if map_header.enable_map_recording and
      map_header.enable_person_recording then begin
      chDir(SUB_DIRECTORY);
      assign(temp_f,OBJ_SAVE_FILE+'0.'+map_header.map_code);
      {$I-}
      reset(temp_f,1);
      {$I+}
      if IOResult = 0 then begin
         new(buffer);
         BlockRead(temp_f,buffer^,sizeof(buffer^));
         for i := 2 to MAX_PERSON_ARRAY do begin
            if buffer^[i] = NULL_CODE then begin
               if person[i] <> nil then begin
                  dispose(person[i],done);
                  person[i] := nil;
               end;
            end;
         end;
         BlockRead(temp_f,buffer^,sizeof(buffer^));
         for i := 2 to MAX_PERSON_ARRAY do begin
            if buffer^[i] <> NULL_CODE then begin
               recognizable_person := recognizable_person + [i];
            end;
         end;
         if Copy(map_header.map_data.file_name,1,7) = 'Abellis' then
            recognizable_person := [2..MAX_PERSON_ARRAY];
         BlockRead(temp_f,buffer^,sizeof(buffer^));
         BlockRead(temp_f,buffer^,sizeof(buffer^));
         BlockRead(temp_f,buffer^,sizeof(buffer^));
         close(temp_f);

         dispose(buffer);
      end;
      chDir('..');
   end;
end;

procedure removeScript;
var
   i, halt_code : integer;
   file_name : string[12];
   write_f : file;
   size : longint;
   buffer : ^byte;
begin
   i := MAX_RGS_DATA;
   while i > 0 do begin
      if RGS_data[i] <> nil then begin
         dispose(RGS_data[i]);
         RGS_data[i] := nil;
      end;
      dec(i);
   end;
   i := MAX_SUBJECT_DATA;
   while i > 0 do begin
      if subject_data[i] <> nil then begin
         dispose(subject_data[i]);
         subject_data[i] := nil;
      end;
      dec(i);
   end;

   if map_header.enable_map_recording then begin
      chDir(SUB_DIRECTORY);
      file_name := OBJ_SAVE_FILE+'0.'+map_header.map_code;
      assign(write_f,file_name);
      if map_header.enable_person_recording then begin
         rewrite(write_f,1);
         for i := 2 to MAX_PERSON_ARRAY do begin
            if (person[i] = nil) or (person[i]^.returnInternal(_death_depth) > 0) then
               BlockWrite(write_f,NULL_CODE,1)
            else
               BlockWrite(write_f,FULL_CODE,1);
         end;
         for i := 2 to MAX_PERSON_ARRAY do begin
            if i in recognizable_person then
               BlockWrite(write_f,FULL_CODE,1)
            else
               BlockWrite(write_f,NULL_CODE,1);
         end;
         for i := 2 to MAX_PERSON_ARRAY do BlockWrite(write_f,NULL_CODE,1);
         for i := 2 to MAX_PERSON_ARRAY do BlockWrite(write_f,NULL_CODE,1);
         for i := 2 to MAX_PERSON_ARRAY do BlockWrite(write_f,NULL_CODE,1);
         close(write_f);
      end else begin
         size := (MAX_PERSON_ARRAY - 1)*5;
         getMem(buffer,size);
         {$I-}
         reset(write_f,1);
         {$I+}
         if IOResult = 0 then begin
            BlockRead(write_f,buffer^,size);
            close(write_f);
         end else begin
            fillChar(buffer^,size,chr(FULL_CODE));
         end;
         assign(write_f,file_name);
         rewrite(write_f,1);
         BlockWrite(write_f,buffer^,size);
         close(write_f);
         freeMem(buffer,size);
      end;
      chDir('..');
   end;

   halt_code := 0;
   for i := 2 to MAX_PERSON_ARRAY do begin
      if (person[i] = nil) or (person[i]^.returnInternal(_death_depth) > 0) then begin
         if map_header.enable_map_recording then
         if map_header.enable_person_recording then
         if (game_system.m_proceeding_level = 0) and
            (map_header.map_data.file_name = 'Abellis') and
            (i in [2..36]) then begin
            inc(halt_code);
         end;
      end;
      if person[i] <> nil then begin
         dispose(person[i],done);
         person[i] := nil;
      end;
   end;
   invoid_person_movement_data := [];
   talkable_person := [];
   recognizable_person := [];

   for i := 1 to MAX_MESSAGE_ARRAY do begin
      if message[i] <> nil then removeMessage(i);
   end;

   if (halt_code > 0) and (game_system._NEXT_EXCUTE_FILE <> '') then begin
      clearPage(0);
      talk_order := 3;
      excuteCommand('set graphic mode("480")',0);
      setGradationType(UP_TO_DOWN);
      setGradationColor(1);
      excuteCommand('print gradation("qe w i eae sa.")',0);
      excuteCommand('print gradation("A we  aiA aqi vsa.")',0);
      excuteCommand('print gradation("iae  A  ab sa.")',0);
      excuteCommand('print gradation("Aba ea  eii esa.")',0);
      pressAnyKey;
      fadeOutGradationColor(2);
      game_system._NEXT_EXCUTE_FILE := '';
      user_key := EXIT_CODE;
   end;
end;

function verifyExitMap(x,y : integer) : boolean;
var
   i : integer;
begin
   verifyExitMap := FALSE;
   for i := 1 to map_header.count_of_exit_point do begin
      with map_exit_data[i]^ do begin
         if (map_x_exit = x) and (map_y_exit = y) then begin
            game_system._NEXT_EXCUTE_FILE := file_name;
            game_system._NEXT_START_X := map_x_start;
            game_system._NEXT_START_Y := map_y_start;
            user_key := EXIT_CODE;
            verifyExitMap := TRUE;
         end;
      end;
   end;
end;

procedure actDecode;
var
   person_loop : integer;
   scroll_count : word;
   remember_time : longint;
   exist_macro : boolean;
begin

   if DETECT_SOUND_CARD then begin
      loadTMF(map_header.music_data_file);
      playTMF;
   end;

   exist_macro := FALSE;
   _PERSON_CONTROLL_CODE := NO_EVENT;

   if not MUST_LOAD_GAME then begin

      if label_address[1] > 0 then begin
         talkSomeone(0,FALSE);
         exist_macro := TRUE;
      end;

      while _PERSON_CONTROLL_CODE = OCCUR_TALK do begin
         _PERSON_CONTROLL_CODE := NO_EVENT;
         talkSomeone(_TALK_PERSON,FALSE);
      end;

   end;
   MUST_LOAD_GAME := FALSE;

   if not exist_macro then begin
      scrollMap;
      flipPage;
      fadeIn(palette_data,1);
   end;

   scroll_count := 0;
   SCROLL_RATE := 0.0;

   while user_key <> EXIT_CODE do begin

         if person[_MAIN_CHARACTER]^.returnInternal(_unconscious_depth) > 0 then begin
            if ord(_GLOBAL_KEY) = ESCAPE_KEY then begin
               DVPersn1.loadGame(FALSE);
               _GLOBAL_KEY := #0;
            end;
         end;

      for person_loop := 1 to max_person_array do begin
         _PERSON_CONTROLL_CODE := NO_EVENT;
         if person[person_loop] <> nil then begin
            if not person[person_loop]^.doAction then begin
               dispose(person[person_loop],done);
               person[person_loop] := nil;
            end;
         end;
         if _PERSON_CONTROLL_CODE = OCCUR_EVENT then
            occurEvent(_EVENT_X_POSITION, _EVENT_Y_POSITION);
         if _PERSON_CONTROLL_CODE = OCCUR_TALK then
            talkSomeone(_TALK_PERSON,TRUE);
      end;
{      for person_loop := MAX_TALKABLE_PERSON_ARRAY to MAX_PERSON_ARRAY do begin
         if person[person_loop] <> nil then person[person_loop]^.doAction;
      end;
}
      if user_key <> EXIT_CODE then begin

         game_system.updateSystemCount;

         if game_system.enableToMove then game_system.passTime(0,0,0,5)
                                     else game_system.passTime(0,0,0,1);
         scrollMap;
         flipPage;

         if _PERSON_CONTROLL_CODE = OCCUR_TIME_EVENT then begin
            occurTimeEvent(game_system.returnEventTime);
         end;

      end;

      (***  SCROLL CLOCK CHECK ROUTINE  ***)
      inc(scroll_count);
      if abs(remember_time - game_system.getSystemCount) >= 40 then begin
         SCROLL_RATE := scroll_count / 10;
         remember_time := game_system.getSystemCount;
         scroll_count := 0;
      end;

   end;

   if DETECT_SOUND_CARD then begin
      endTMF;
   end;
end;

var
   LA, i : integer;
begin
   for LA := -1 to MAX_PERSON_ARRAY do label_address[LA] := 0;
   for i := 1 to MAX_RGS_DATA do RGS_data[i] := nil;
end.
