{$DEFINE _COMPRESS_SCRIPT}
{$DEFINE _OVERLAY}

Unit DVError;
{$IFDEF __OVERLAY}
   {$O+,F+}
{$ENDIF}

INTERFACE

var
   _ERROR_MESSAGE : string;
   _ERROR_NUMBER  : integer;

IMPLEMENTATION

uses
   dos, graph, DVSubPro, DVTMF, DVHan20;


function Dec2Hex(value : word) : shortString;
const
   hex_data : array[0..$F] of char = (
      '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'
   );
var
   return : string[4];
   i : word;
begin
   return := '';
   for i := 1 to 4 do begin
      return := hex_data[value and $000F] + return;
      value  := value shr 4;
   end;
   Dec2Hex := return;
end;

{$F+}
procedure ErrorHandler;
{$F-}
var
   i : word;
   error_address_segment, error_address_offset : word;
   error_address : longint;
   s : shortString;
   DirInfo: SearchRec;
begin

   asm
      mov ax, $12
      int $10
   end;

   if DETECT_SOUND_CARD then begin
      endTMF;
   end;

   deleteFile(TEMPLET_FILE);
   {$IFDEF __COMPRESS_SCRIPT}
   deleteFile(COMMENT_FILE);
   {$ENDIF}

   {$I-}
   chDir(SUB_DIRECTORY);
   {$I+}
   if IOResult = 0 then begin
      findFirst(OBJ_SAVE_FILE+'0.*', Archive, DirInfo);
      while DosError = 0 do begin
         deleteFile(DirInfo.Name);
         findNext(DirInfo);
      end;
   end;
   chDir('..');

   if _ERROR_NUMBER > 100 then begin

      dec(_ERROR_NUMBER,100);
      clearPage(0);
      setHanColor(15);
      printHangul(0,0,'----  aaa Ё A !!');
      setHanColor(11);
      printHangul(0,16,'A w : '+_ERROR_MESSAGE);
      str(_ERROR_NUMBER,s);
      setHanColor(7);
      printHangul(0,32,'A ša('+s+') : ');
      case _ERROR_NUMBER of
         1 : s := 'aa  sa.';
         2 : s := ' ivsa';
         3 : s := 'bytew aa  sa';
         4 : s := 'integerw aa  sa';
         5 : s := '")" a avsa';
         6 : s := '"faced" a avsa';
         7 : s := '[up,down,left,right] A aaa  sa';
         8 : s := 'item number  a  vsa';
         9 : s := 'ϩaA wE aq ᢁ gsa';
         10: s := 'i a ivsa';
         11: s := 'i  e wwa';
         12: s := ' w aqi w ǩ a sa';
         13: s := 'Aa AaA w sa';
      end;

      printHangul(17*8,32,s);
      pressAnyKey;

   end

   else if _ERROR_NUMBER > 0 then begin

      clearPage(0);
      str(_ERROR_NUMBER,s);
      setHanColor(15);
      printHangul(0,0,'A ša('+s+') : ');
      case _ERROR_NUMBER of
         1 : s := 'ai xi  sa';
         2 : s := 'Aa Aaa Aaa gsa';
         3 :
         begin
            setHanColor(12);
            s := 'Aa Aaa   A vsa';
         end;
         4 : s := 'A ЁAA w sa';
         5 : s := 'Aa Aa ͡ asa.';
      end;
      setHanColor(7);
      printHangul(17*8,0,s);
      setHanColor(10);
      printHangul(17*8,16,'<'+_ERROR_MESSAGE+'>');
      pressAnyKey;

   end

   else if ExitCode > 0 then begin

      case ExitCode of
         1 : s := 'a qa sa';
         2 : s := 'ai ie i  sa';
         3 : s := 'wi xi  sa';
         4 : s := 'eE a ᢁ gsa';
         5 : s := 'aA e aw sa.';
         6 : s := 'e a Ѕia';
        12 : s := 'e a e šaa';
        15 : s := 'aaaa sa';
        16 : s := 'e Bɡi   sa';
        17 : s := 'ae aaae q ewe aw sa';
        18 : s := ' w a sa';
       100 : s := 'aa  Aᷳa';
       101 : s := 'aa a Aᷳa';
       102 : s := 'a A gvsa';
       103 : s := 'a eA gvsa';
       104 : s := 'b a eA gvsa';
       105 : s := 'b a eA gvsa';
       106 : s := 'e awa';
       150 : s := 'aaA aa qA sa ';
       151 : s := 'aaA e a  Aᷳa';
       152 : s := 'aaaa A gvsa';
       154 : s := 'Aa CRC Aᷳa';
       156 : s := 'aa x Aᷳa';
       157 : s := 'aa ai i  sa';
       158 : s := 'aa Bi xi  sa';
       159 : s := 'a᷁ a a vsa';
       160 : s := 'wáA a Aᷳa';
       161 : s := 'wáA  Aᷳa';
       162 : s := 'aa e ́a';
       200 : s := '0 a a iЖsa';
       201 : s := 'aa a vsa';
       202 : s := 'aȂ sa';
       203 : s := 'ӳ Aa sa';
       204 : s := 'e ͡ eea';
       205 : s := '  ee ia ᢁ sa';
       206 : s := '  ee ia ᢁ bsa';
       207 : s := 'e   eea';
       208 : s := 'A a wA gvsa';
       209 : s := 'A ai i  sa';
       210 : s := 'Aa  A gvsa';
       211 : s := 'aw Aai ᴡ sa';
       212 : s := 'aa w Aᷳa';
       213 : s := 'TCollectionA  Aa vsa';
       214 : s := 'TCollectionA ia i Жsa';
       215 : s := ' áA ia i Жsa';
       216 : s := 'aBˡa a Aᷳa'
        else s := 'A AAa sa';
      end;

      setHanColor(12);
      printHangul(0,0,'-- wa aai asa  --');
      setHanColor(15);
      printHangul(0,32,'w : ' + s);
      error_address_segment := longint(ErrorAddr) shr 16;
      error_address_offset  := longint(ErrorAddr) and $FFFF;
      s := Dec2Hex(error_address_segment) + ':' + Dec2Hex(error_address_offset);
      setHanColor(7);
      printHangul(0,48,'廡 : ' + s);

      ExitCode := 0;
      ErrorAddr := nil;
      pressAnyKey;

   end;

   closeGraph;

   for i := 0 to 80*2-1 do begin
      mem[SegB800:i*2+1] := $1F;
   end;

   setRGB(1,0,0,0); setPalette(15); setRGB(15,0,0,0);
{
   writeLn(' Deja vu...     made by  O O   &  Ծ  ');
   writeLn('                            O  |         O  ');
}
   writeLn('              -- -- ڿ|_');
   writeLn('  <<    TEAM  -- -- ٳ     >>     Byulbram, SMgal, NeoTouch');
   writeLn;
   for i := 0 to 42 do begin
      setRGB(1,0,0,i); setRGB(15,0,0,i);
      waitVerticalRetrace(1);
   end;
   for i := 0 to 63 do begin
      setRGB(15,i,i,i * 21 div 63 + 42);
      waitVerticalRetrace(1);
   end;

end;

begin
   ExitProc := @ErrorHandler;
   _ERROR_MESSAGE := '';
   _ERROR_NUMBER := 0;
end.
