{$DEFINE _OVERLAY}

unit DVPersn1;
{$IFDEF __OVERLAY}
   {$O+,F+}
{$ENDIF}

INTERFACE

uses
   dos, graph,
   DVHan20, DVPerson, DVSubpro;

 procedure convertItemToObject(item_number : byte; var return_object : byte);
 procedure convertObjectToItem(object_number : byte; var return_item : item_T);
 procedure returnMapComponent(x,y : integer; var return_magic_need : magic_need_SET);
 function  returnSuffixName(suffix_number : integer) : string;
 function  returnItemName(item : item_T; display_broken : boolean) : string;
 function  decideEA(init_value, max_value : integer; message_s : string) : integer;
 procedure detectObstacle(attribute : attack_attribute_T; x_source,y_source,x_destination,y_destination : integer;
                          var return_x, return_y : integer);
 function  attackObject(params : attack_parameters_T; var result_params : attack_parameters_T) : integer;
 procedure registerMessage(person_number : integer; s : string; stay_second : real);
 procedure removeMessage(message_number : integer);
 procedure removePersonMessage(person_number : integer);
 function  setItemMap(x,y : integer; item : item_T) : boolean;
 function  returnItemMap(x,y : integer; var item : item_T) : boolean;
 function  referenceItemMap(x,y : integer; var item : item_T) : boolean;
 function  testItemMap(x,y : integer; var EA : equipment_T; var init : byte) : byte;
 function  returnObjectName(x,y : integer) : string;
 procedure loadGame(goto_end : boolean);
 procedure saveGame;
 procedure setGameSystem;
 procedure selectShortMenu;
 procedure selectMainMenu;
 procedure sleepHere(var subject : person_O);
 procedure getObject(var subject : person_O);
 procedure lookObject(var subject : person_O);
 procedure dropObject(var subject : person_O);
 procedure moveObject(var subject : person_O);

IMPLEMENTATION

uses
   DVDecode;

procedure convertItemToObject(item_number : byte; var return_object : byte);
var
   i, j : byte;
begin
   return_object := item_number + ADDRESS_OF_WEAPON_IN_OBJECT_TILE;
end;

procedure convertObjectToItem(object_number : byte; var return_item : item_T);
var
   item_kind : byte;
   temp_item : item_T;
begin
   if object_number <= ADDRESS_OF_WEAPON_IN_OBJECT_TILE then begin
      fillChar(temp_item,sizeof(temp_item),#0);
      temp_item._item_number := object_number;
      temp_item._item_contain := 1;
   end else begin
      object_number := object_number - ADDRESS_OF_WEAPON_IN_OBJECT_TILE;
      temp_item := item_data[object_number]^.data;
   end;
   return_item := temp_item;
end;

procedure returnMapComponent(x,y : integer; var return_magic_need : magic_need_SET);
var
   temp_magic_need_set : magic_need_SET;
   i, j : integer;
   temp_b, aux_b : byte;
   ET : equipment_T;
   temp_item : item_T;
begin
   temp_magic_need_set := [];
   if readMap(MA_NORMAL,x,y) in [1..4,7,8,11,13..17,26,47,49] then
      temp_magic_need_set := temp_magic_need_set + [mgc_earth];
   temp_b := 0;
   for j := -2 to 2 do
   for i := -2 to 2 do begin
      if (x in [0..pred(map_header.map_x_max)]) and (y in [0..pred(map_header.map_y_max)]) then begin
         if readMap(MA_NORMAL,x+i,y+j) = __TILE_WATER then
            temp_b := 1;
      end;
   end;
   aux_b := 1;
   for j := -1 to 1 do
   for i := -1 to 1 do begin
      if (i*j = 0) and ((i <> 0) or (j <> 0)) then begin
         if ((readMap(MA_ATTRIBUTE,x+i,y+j) and WALKABLE_BIT) = 0) then
            aux_b := 0;
      end;
   end;
   if (temp_b = 1) and (aux_b = 0) then begin
      temp_magic_need_set := temp_magic_need_set + [mgc_water];
   end;
   if (readMap(MA_FIELD,x,y) and FIELD_BIT) = 1 then
      temp_magic_need_set := temp_magic_need_set + [mgc_fire];
   if (readMap(MA_FIELD,x,y) and FIELD_BIT) <> 2 then
      temp_magic_need_set := temp_magic_need_set + [mgc_air];
   if (readMap(MA_FIELD,x,y) and FIELD_BIT) = 3 then
      temp_magic_need_set := temp_magic_need_set + [mgc_poison];

   if readMap(MA_OBJECT,x,y) > 0 then begin
      aux_b := 0;
      temp_b := testItemMap(x,y,ET,aux_b);
      if temp_b > 0 then begin
         returnItemMap(x,y,temp_item);
         if temp_item._item_type > START_OF_EQUIPMENT then
            convertItemToObject(temp_item._item_number,temp_b)
         else
            temp_b := temp_item._item_number;
         setItemMap(x,y,temp_item);
      end
      else temp_b := readMap(MA_OBJECT,x,y);
      if temp_b in
         [__OBJECT_DEATH_BODY..__OBJECT_DEATH_BODY+MAX_REGISTER_PLAYER_SPRITE] then begin
         temp_magic_need_set := [mgc_corpse]
      end else begin
         temp_magic_need_set := [mgc_thing];
      end;
   end;
   if readMap(MA_PERSON,x,y) > 0 then begin
      if person[readMap(MA_PERSON,x,y)]^.returnInternal(_death_depth) = 0 then begin
         temp_magic_need_set := [mgc_player]
      end;
   end;
   return_magic_need := temp_magic_need_set;
end;

function returnSuffixName(suffix_number : integer) : string;
begin
   if suffix_number < 100 then
      returnSuffixName := ''
   else if suffix_number < 200 then
      returnSuffixName := item_suffix_name_string[suffix_number-100]
   else
      returnSuffixName := item_special_suffix_name_string[suffix_number-200];
end;

function returnItemName(item : item_T; display_broken : boolean) : string;
var
   s : string;
   temp_s : shortString;
begin
   if item._item_type > START_OF_EQUIPMENT then begin
      if item._item_number >= 0 then begin
         s := returnSuffixName(item._item_suffix);
         if s <> '' then s := s + ' ';
         s := s + item_data[item._item_number]^.name;
         if display_broken then begin
            if item._item_maintain_level > 50 then
               s := s + ' (B)';
         end;
         if item._item_contain > 1 then begin
            str(item._item_contain,temp_s);
            s := s + ' x '+temp_s;
         end;
         returnItemName := s;
      end else returnItemName := '· w';
   end else begin
      s := object_data_string[object_data_index[item._item_number]];
      if display_broken then begin
         if item._item_maintain_level > 0 then
            s := s + ' (B)';
      end;
      if item._item_contain > 1 then begin
         str(item._item_contain,temp_s);
         s := s + ' x '+temp_s;
      end;
      returnItemName := s;
   end;
end;

function decideEA(init_value, max_value : integer; message_s : string) : integer;
const
   BACKGROUND_COLOR = 1;
   Y_Y = 7;
var
   window : ^window_O;
   i, key_in : integer;
   left_limit, right_limit : integer;
   temp_s : string[8];
begin
   if init_value < 1 then init_value := 1;
   if init_value > max_value then init_value := max_value;

   if length(message_s) < 6 then message_s := '   '+message_s+'   ';
   i := 40;
   left_limit := i - length(message_s) div 2;
   right_limit := left_limit + length(message_s) - 1 ;
   new(window,init(left_limit-1,Y_Y-1,right_limit+1,Y_Y+1,BACKGROUND_COLOR,TRUE));
   window^.printHangul('@B');
   window^.printHangul(message_s);

   setFillStyle(SOLIDFILL,BACKGROUND_COLOR);
   key_in := 0;
   while not (byte(key_in) in [ACCEPT_KEY,ESCAPE_KEY]) do begin
      str(init_value : 5,temp_s);
      temp_s := '<'+temp_s+'>';
      bar(left_limit*8,Y_Y*16,right_limit*8+7,Y_Y*16+15);
      printString(36,Y_Y,temp_s,14,FALSE,0);
      key_in := ord(readKey);
      if key_in = 0 then key_in := SCAN_CODE + ord(readKey);
      i := 0;
      case key_in of
         UP_KEY    : i := 10;
         DOWN_KEY  : i := -10;
         LEFT_KEY  : i := -1;
         RIGHT_KEY : i := 1;
      end;
      init_value := init_value + i;
      if init_value < 1 then init_value := 1;
      if init_value > max_value then init_value := max_value;
   end;

   if key_in = ACCEPT_KEY then begin
      decideEA := init_value;
   end else begin
      decideEA := 0;
   end;

   dispose(window,done);
end;

procedure detectObstacle(attribute : attack_attribute_T; x_source,y_source,x_destination,y_destination : integer;
                         var return_x, return_y : integer);
var
   x_vector_scale, y_vector_scale : integer;
   x_axis, y_axis : integer;
   x_increase, y_increase, x_vector, y_vector : real;
   increase_param, distance : real;
   exit_loop_condition : boolean;
begin
   if ((abs(x_source-x_destination) <= 1) and (abs(y_source-y_destination) <= 1)) then begin
      if isPassableMap(x_destination,y_destination) then begin
         return_x := 0;
         return_y := 0;
      end else begin
         return_x := x_destination;
         return_y := y_destination;
      end;
      exit;
   end;
   distance := sqrt(sqr(x_destination-x_source)+sqr(y_destination-y_source));
   x_vector_scale := (x_destination-x_source);
   y_vector_scale := (y_destination-y_source);
   x_vector := 0.5;
   y_vector := 0.5;
   if x_vector_scale = 0 then x_increase := 0
   else if x_vector_scale > 0 then x_increase := 1
   else x_increase := -1;
   if y_vector_scale = 0 then y_increase := 0
   else if y_vector_scale > 0 then y_increase := 1
   else y_increase := -1;
   exit_loop_condition := FALSE;
   if abs(x_vector_scale) > abs(y_vector_scale) then begin
      if x_vector_scale <> 0 then
         y_increase := abs(y_vector_scale / x_vector_scale) * y_increase;
      if x_increase > 0 then increase_param := 0.5
                        else increase_param := -0.5;
      while (abs(x_vector) < abs(x_vector_scale)+increase_param) and
            (not exit_loop_condition) do begin
         x_vector := x_vector + x_increase;
         if abs(x_vector) > abs(x_vector_scale)+0.5 then
            x_vector := x_vector_scale;
         y_vector := y_vector + y_increase;
         x_axis := trunc(x_vector+x_source);
         y_axis := trunc(y_vector+y_source);
         if not isPassableMap(x_axis,y_axis) then exit_loop_condition := TRUE;
         if (x_axis >= 0) and (y_axis >= 0) then begin
            if (attribute = _watery) and ((readMap(MA_FIELD,x_axis,y_axis) and FIELD_BIT) = __FIELD_FIRE) then
               exit_loop_condition := TRUE;
         end else exit_loop_condition := TRUE;
      end;
   end
   else begin
      if y_vector_scale <> 0 then
         x_increase := abs(x_vector_scale / y_vector_scale) * x_increase;
      if y_increase > 0 then increase_param := 0.5
                        else increase_param := -0.5;
      while (abs(y_vector) < abs(y_vector_scale)+increase_param) and
            (not exit_loop_condition) do begin
         y_vector := y_vector + y_increase;
         if abs(y_vector) > abs(y_vector_scale)+0.5 then
            y_vector := y_vector_scale;
         x_vector := x_vector + x_increase;
         x_axis := trunc(x_vector+x_source);
         y_axis := trunc(y_vector+y_source);
         if not isPassableMap(x_axis,y_axis) then exit_loop_condition := TRUE;
         if (x_axis >= 0) and (y_axis >= 0) then begin
            if (attribute = _watery) and ((readMap(MA_FIELD,x_axis,y_axis) and FIELD_BIT) = __FIELD_FIRE) then
               exit_loop_condition := TRUE;
         end else exit_loop_condition := TRUE;

      end;
   end;
   if exit_loop_condition then begin
      return_x := x_axis;
      return_y := y_axis;
   end else begin
      return_x := 0;
      return_y := 0;
   end;
end;

function attackObject(params : attack_parameters_T; var result_params : attack_parameters_T) : integer;
var
   x_result, y_result,
   remember_x_destination, remember_y_destination : integer;
   movie : ^movie_O;
   result_int : integer;

 procedure processNormalAttack;
 begin
    with params do begin
       detectObstacle(attack_attribute,x_source,y_source,x_destination,y_destination,x_result,y_result);
       if (x_destination = x_result) and (y_destination = y_result) then begin
          if readMap(MA_PERSON,x_result,y_result) > 0 then begin
             result_int := person[readMap(MA_PERSON,x_result,y_result)]^.doReaction(params);
          end;
       end;
    end;
 end;

 procedure processNotShownAttack;
 var
    window : ^window_O;
    attacking_person, selected_person : byte;
    i : integer;
    temp_long : longint;
    get_skill, get_level, get_effect : longint;
    s : string;
 begin
    attacking_person := readMap(MA_PERSON,params.x_source,params.y_source);
    selected_person := readMap(MA_PERSON,params.x_destination,params.y_destination);
    if (attacking_person = 0) or (selected_person = 0) then exit;
    get_level := person[attacking_person]^.returnAbility(_level);
    get_skill := person[attacking_person]^.returnSkill(_magic_skill);
    get_effect := get_level * get_skill div 100;
    case params.shape_revolution of
       1 :
       with person[selected_person]^ do begin
          new(window,init(27,8,53,12,8,TRUE));
          window^.printHangul('@Fq :@B '+returnName);
          temp_long := returnInternal(_hit_point);
          temp_long := temp_long * 100 div returnMaxAvailHitPoint;
          str(temp_long,s);
          window^.printHangul('@@@FAb :@E '+s+' %');
          temp_long := returnInternal(_spell_point);
          temp_long := temp_long * 100 div returnMaxAvailSpellPoint;
          str(temp_long,s);
          window^.printHangul('@@@Fab :@E '+s+' %');
          if returnInternal(_death_depth) > 0 then s := 'q'
          else if returnInternal(_unconscious_depth) > 0 then s := 'w'
          else if returnInternal(_stonization_depth) > 0 then s := ''
          else if returnInternal(_paralisis_depth) > 0 then s := 'a'
          else if returnInternal(_poison_depth) > 0 then s := ''
          else if returnInternal(_fear_depth) > 0 then s := '͡'
          else if returnInternal(_sleep_depth) > 0 then s := 'e'
          else if returnInternal(_hit_point) < 0 then s := 'w'
          else s := 'w';
          window^.printHangul('@@@Fwȁ :@D '+s);
          pressAnyKey;
          dispose(window,done);
       end;
       2, 7 :
       begin
          if params.shape_revolution = 2 then
             params.attack_attribute := _fiery
          else
             params.attack_attribute := _magical;
          params.trailing_count := 0;
          with params do begin
             if readMap(MA_PERSON,x_destination,y_destination) > 0 then begin
                result_int := person[readMap(MA_PERSON,x_destination,y_destination)]^.doReaction(params);
             end;
          end;
       end;
       3, 4, 5, 6 :
       begin
          params.attack_attribute := _magical;
          params.trailing_count := params.shape_revolution + 98;
          params.power := get_effect div 10;
          with params do begin
             if readMap(MA_PERSON,x_destination,y_destination) > 0 then begin
                result_int := person[readMap(MA_PERSON,x_destination,y_destination)]^.doReaction(params);
             end;
          end;
       end;
    end;
 end;

 procedure processShootAttack;
 begin
    with params do begin
       detectObstacle(attack_attribute,x_source,y_source,x_destination,y_destination,x_result,y_result);
       if (x_result <> 0) or (y_result <> 0) then begin
          with params do begin
             x_destination := x_result;
             y_destination := y_result;
          end;
          if readMap(MA_PERSON,x_result,y_result) > 0 then
             result_int := person[readMap(MA_PERSON,x_result,y_result)]^.doReaction(params)
          else
             result_int := 0;
          new(movie,init);
          movie^.makeMovie(params,result_int);
          movie^.playMovie(1);
          dispose(movie,done);
          if (attack_attribute = _watery) and ((readMap(MA_FIELD,x_result,y_result) and FIELD_BIT) = __FIELD_FIRE) then
             writeMap(MA_FIELD,x_result,y_result,readMap(MA_FIELD,x_result,y_result) and (not FIELD_BIT));
       end
       else begin
          new(movie,init);
          movie^.makeMovie(params,0);
          movie^.playMovie(1);
          dispose(movie,done);
       end;
    end;
 end;

 procedure processPierceAttack;
 label
    _EVENT_OCCURENCE_LABEL;
 begin
    with params do begin
       x_result := x_source;
       y_result := y_source;
       while ((x_result <> 0) or (y_result <> 0)) and
             ((x_destination <> x_result) or (y_destination <> y_result)) do begin
          detectObstacle(attack_attribute,x_source,y_source,x_destination,y_destination,x_result,y_result);

          if (x_result <> 0) or (y_result <> 0) then begin
             with params do begin
                remember_x_destination := x_destination;
                remember_y_destination := y_destination;
                x_destination := x_result;
                y_destination := y_result;
             end;
             if readMap(MA_PERSON,x_result,y_result) > 0 then begin
                result_int := person[readMap(MA_PERSON,x_result,y_result)]^.doReaction(params);
             end;
             new(movie,init);
             movie^.makeMovie(params,0);
             movie^.playMovie(1);
             dispose(movie,done);
             if (attack_attribute = _watery) and ((readMap(MA_FIELD,x_result,y_result) and FIELD_BIT) = __FIELD_FIRE) then
                writeMap(MA_FIELD,x_result,y_result,readMap(MA_FIELD,x_result,y_result) and (not FIELD_BIT));
             x_source := x_result;
             y_source := y_result;
             x_destination := remember_x_destination;
             y_destination := remember_y_destination;
             if (readMap(MA_ATTRIBUTE,x_result,y_result) and EVENT_BIT) = EVENT_BIT then
                goto _EVENT_OCCURENCE_LABEL;
          end
          else begin
             new(movie,init);
             movie^.makeMovie(params,0);
             movie^.playMovie(1);
             dispose(movie,done);
          end;
       end;
    end;
_EVENT_OCCURENCE_LABEL:
 end;

 procedure processSpreadAttack;
 var
    get_x, get_y, aux_x, aux_y, range : integer;
{    x_result, y_result : integer;}
    variable_axis, variable_range, variable_fixed : ^integer;
    variable_range_sign : shortint;
    spread_count : integer;
 begin
    get_x := params.x_destination;
    get_y := params.y_destination;

    if get_y = 0 then begin
       aux_x := get_x;
       range := abs(get_x);
       variable_axis := @aux_y;
       variable_range := @aux_x;
       variable_fixed := @get_x;
    end
    else begin
       aux_y := get_y;
       range := abs(get_y);
       variable_axis := @aux_x;
       variable_range := @aux_y;
       variable_fixed := @get_y;
    end;
    if variable_range^ > 0 then
       variable_range_sign := 1
    else
       variable_range_sign := -1;

    new(movie,init);
    spread_count := 0;
    variable_axis^ := -range;
    while variable_axis^ <= range do begin
       variable_range^ := variable_fixed^
                          - variable_range_sign * return_circle_data[abs(variable_axis^)];
       with params do begin
          detectObstacle(attack_attribute,x_source,y_source,x_source+aux_x,y_source+aux_y,x_result,y_result);
          if (x_result <> 0) or (y_result <> 0) then begin
             x_destination := x_result;
             y_destination := y_result;
          end else begin
             x_destination := x_source+aux_x;
             y_destination := y_source+aux_y;
          end;
          if x_destination < 0 then x_destination := 0;
          if y_destination < 0 then y_destination := 0;
          if x_destination > map_header.map_x_max-1  then x_destination := map_header.map_x_max-1;
          if y_destination > map_header.map_y_max-1  then y_destination := map_header.map_y_max-1;

          if readMap(MA_PERSON,x_destination,y_destination) > 0 then begin
             result_int := person[readMap(MA_PERSON,x_destination,y_destination)]^.doReaction(params);
          end;
          if x_result < 0 then x_result := 0;
          if y_result < 0 then y_result := 0;
          if (attack_attribute = _watery) and ((readMap(MA_FIELD,x_result,y_result) and FIELD_BIT) = __FIELD_FIRE) then
             writeMap(MA_FIELD,x_result,y_result,readMap(MA_FIELD,x_result,y_result) and (not FIELD_BIT));
       end;
       inc(spread_count);
       movie^.makeMovie4Spread(params,spread_count);
       inc(variable_axis^);
    end;
    movie^.arrangeMovie;
    movie^.playMovie(1);
    dispose(movie,done);

 end;

begin
   x_result := 0; y_result := 0;

   case params.attack_type of
      _normal_attack :
      begin
         processNormalAttack;
      end;
      _not_shown :
      begin
         processNotShownAttack;
      end;
      _shoot :
      begin
         processShootAttack;
      end;
      _pierce :
      begin
         processPierceAttack;
      end;
      _spread :
      begin
         processSpreadAttack;
      end;
   end;

   if (x_result <> 0) or (y_result <> 0) then begin
      if (readMap(MA_ATTRIBUTE,x_result,y_result) and EVENT_BIT) = EVENT_BIT then begin
         _PERSON_CONTROLL_CODE := OCCUR_EVENT;
         _EVENT_X_POSITION := x_result;
         _EVENT_Y_POSITION := y_result;
      end;
   end;

   result_params := params;
   attackObject := result_int;

end;

procedure registerMessage(person_number : integer; s : string; stay_second : real);
var
   message_number : integer;
begin
   for message_number := 1 to MAX_MESSAGE_ARRAY do begin
      if message[message_number] <> nil then begin
         with message[message_number]^ do begin
            if message_person = person_number then begin
               message_string := s;
               message_end_time := game_system.setCurrentTime + round(stay_second * 4);
               exit;
            end;
         end;
      end;
   end;
   for message_number := 1 to MAX_MESSAGE_ARRAY do begin
      if message[message_number] = nil then begin
         new(message[message_number]);
         with message[message_number]^ do begin
            message_person := person_number;
            message_string := s;
            message_end_time := game_system.setCurrentTime + round(stay_second * 4);
         end;
         exit;
      end;
   end;
end;

procedure removeMessage(message_number : integer);
var
   movable_message : integer;
begin
   if (message_number in [1..MAX_MESSAGE_ARRAY]) and
      (message[message_number] <> nil) then begin
      dispose(message[message_number]);
      message[message_number] := nil;
      for movable_message := MAX_MESSAGE_ARRAY downto message_number+1 do begin
         if message[movable_message] <> nil then begin
            message[message_number] := message[movable_message];
            message[movable_message] := nil;
            exit;
         end;
      end;
   end;
end;

procedure removePersonMessage(person_number : integer);
var
   message_number : integer;
begin
   for message_number := 1 to MAX_MESSAGE_ARRAY do begin
      if message[message_number] <> nil then begin
         if message[message_number]^.message_person = person_number then begin
            removeMessage(message_number);
            exit;
         end;
      end;
   end;
end;

function setItemMap(x,y : integer; item : item_T) : boolean;
var
   temp_b : byte;
   temp_item : item_T;

 procedure setItemMapSub(item : item_T);
 begin
    with item_map do begin
       if number_of_data < MAX_ITEM_MAP then begin
          if MAXAVAIL > sizeof(item_T) then begin
             inc(number_of_data);
             new(data[number_of_data].item_data);
             data[number_of_data].x := x;
             data[number_of_data].y := y;
             data[number_of_data].item_data^ := item;
             setItemMap := TRUE;
          end else setItemMap := FALSE;
       end else setItemMap := FALSE;
    end;
 end;

begin
   if readMap(MA_OBJECT,x,y) = 0 then begin
      if item._item_type > START_OF_EQUIPMENT then
         convertItemToObject(item._item_number,temp_b)
      else
         temp_b := item._item_number;
      writeMap(MA_OBJECT,x,y,temp_b);
   end
   else begin
      if not returnItemMap(x,y,temp_item) then begin
         convertObjectToItem(readMap(MA_OBJECT,x,y),temp_item);
      end;
      setItemMapSub(temp_item);
      if item._item_type > START_OF_EQUIPMENT then
         convertItemToObject(item._item_number,temp_b)
      else
         temp_b := item._item_number;
      if temp_b > 0 then begin
         writeMap(MA_OBJECT,x,y,temp_b);
      end;
   end;
   setItemMapSub(item);
end;

function returnItemMap(x,y : integer; var item : item_T) : boolean;
var
   i, data_ptr : integer;
   temp_b : byte;
   exit_condition : boolean;
   temp_item : item_T;
begin
   with item_map do begin
      data_ptr := number_of_data;
      exit_condition := FALSE;
      while (data_ptr > 0) and (not exit_condition) do begin
         if (data[data_ptr].x = x) and (data[data_ptr].y = y) then begin

            item := data[data_ptr].item_data^;
            dispose(data[data_ptr].item_data);
{
            if data[number_of_data].item_data <> nil then begin
               data[data_ptr].item_data := data[number_of_data].item_data;
               data[data_ptr].x := data[number_of_data].x;
               data[data_ptr].y := data[number_of_data].y;
            end;
}
            for i := data_ptr to pred(number_of_data) do begin
               data[i].item_data := data[i+1].item_data;
               data[i].x := data[i+1].x;
               data[i].y := data[i+1].y;
            end;

            dec(number_of_data);
            exit_condition := TRUE;
         end;
         dec(data_ptr);
      end;
      if exit_condition then begin

         data_ptr := number_of_data;
         exit_condition := FALSE;
         while (data_ptr > 0) and (not exit_condition) do begin
            if (data[data_ptr].x = x) and (data[data_ptr].y = y) then begin

               if data[data_ptr].item_data^._item_type > START_OF_EQUIPMENT then
                  convertItemToObject(data[data_ptr].item_data^._item_number,temp_b)
               else
                  temp_b := data[data_ptr].item_data^._item_number;

               if temp_b > 0 then writeMap(MA_OBJECT,x,y,temp_b);
               exit_condition := TRUE;
            end;
            dec(data_ptr);
         end;
         if not exit_condition then
            writeMap(MA_OBJECT,x,y,0);

         returnItemMap := TRUE;
      end
      else returnItemMap := FALSE;
   end;
end;

function referenceItemMap(x,y : integer; var item : item_T) : boolean;
var
   i, data_ptr : integer;
   temp_b : byte;
   exit_condition : boolean;
   temp_item : item_T;
begin
   with item_map do begin
      data_ptr := number_of_data;
      exit_condition := FALSE;
      while (data_ptr > 0) and (not exit_condition) do begin
         if (data[data_ptr].x = x) and (data[data_ptr].y = y) then begin
            item := data[data_ptr].item_data^;
            exit_condition := TRUE;
         end;
         dec(data_ptr);
      end;
      if exit_condition then referenceItemMap := TRUE
      else referenceItemMap := FALSE;
   end;
end;

function testItemMap(x,y : integer; var EA : equipment_T; var init : byte) : byte;
var
   data_ptr : integer;
   exit_condition : boolean;
begin
   with item_map do begin
      data_ptr := init;
      exit_condition := FALSE;
      while (data_ptr < number_of_data) and (not exit_condition) do begin
         inc(data_ptr);
         if (data[data_ptr].x = x) and (data[data_ptr].y = y) then begin
            testItemMap := data[data_ptr].item_data^._item_number;
            EA := data[data_ptr].item_data^._item_type;
            init := data_ptr;
            exit_condition := TRUE;
         end;
      end;
      if not exit_condition then begin
         testItemMap := 0;
         init := number_of_data + 1;
      end;
   end;
end;

function returnObjectName(x,y : integer) : string;
var
   selected_object : byte;
   temp_item : item_T;
   s : string;
begin
   selected_object := readMap(MA_OBJECT,x,y);
   if selected_object > 0 then begin
      if not referenceItemMap(x,y,temp_item) then begin
         convertObjectToItem(selected_object,temp_item);
      end;
      s := returnItemName(temp_item,TRUE);
   end else s := '';
   returnObjectName := s;
end;

procedure loadGame(goto_end : boolean);
label
   START_LABEL;
var
   window : ^window_O;
   select : ^select_O;
   i : integer;
   temp_s : string[2];
   f : file;
   save_information : array[1..9] of save_data_T;
   s : string;
begin

START_LABEL:

   setHanType(MYUNGJO);

   chDir(SUB_DIRECTORY);

   assign(f,SAVE_INFORMATION_FILE);
   {$I-}
   reset(f,sizeof(save_data_T));
   {$I+}
   if IOResult <> 0 then printErrorMessage(1,SAVE_INFORMATION_FILE);
   for i := 1 to 9 do BlockRead(f,save_information[i],1);
   close(f);

   new(window,init(25,6,55,15,0,TRUE));
   new(select,init);
   with select^ do begin
      for i := 1 to 9 do begin
         str(i,temp_s);
         setMenu(i,'A '+temp_s+' : '+save_information[i].data_name);
      end;
      setMenuColor(11,2);
      i := selectMenu(27,6,1,9);
      if i > 0 then begin
         str(i,temp_s);
         assign(f,'Save'+temp_s);
         {$I-}
         reset(f,1);
         {$I+}
         if IOResult = 0 then
            close(f)
         else
            i := -1;
      end;
   end;

   chDir('..');

   setHanType(SAMMUL);

   dispose(window,done);
   dispose(select,done);
   if i in [1..9] then begin
      MUST_LOAD_GAME := TRUE;
      game_system._RETURN_EXCUTE_FILE := '';
      game_system._NEXT_EXCUTE_FILE := '!!LOAD!!';
      game_system._NEXT_START_X := i;
      game_system._NEXT_START_Y := 0;
      user_key := EXIT_CODE;
   end else if i < 0 then begin
      if pos('World',map_header.map_data.file_name) = 0 then begin
         printMessageWindow('@FwEwsa');
         if goto_end then goto START_LABEL;
      end else i := 0;
   end;
   if goto_end and (i = 0) then begin
      MUST_LOAD_GAME := FALSE;
      game_system._NEXT_EXCUTE_FILE := '';
      user_key := EXIT_CODE;
   end;
end;

procedure saveGame;
var
   f,f1 : file;
   file_name : string[16];
   MA : map_attribute_T;
   i, file_number : integer;
   size : longint;
   buffer, pb : ^byte;
   temp_s : string[2];
   window : ^window_O;
   select : ^select_O;
   DirInfo: SearchRec;
   NumRead, NumWritten : word;
   D: DirStr; N: NameStr; E: ExtStr;
   save_information : array[1..9] of save_data_T;
   s : string;
   temp_long : longint;
begin
   if map_header.map_data.file_name[1] = '_' then begin
      printMessageWindow('ae Aaa eSa');
      exit;
   end;

   setHanType(MYUNGJO);

   chDir(SUB_DIRECTORY);

   assign(f,SAVE_INFORMATION_FILE);
   {$I-}
   reset(f,sizeof(save_data_T));
   {$I+}
   if IOResult <> 0 then printErrorMessage(1,SAVE_INFORMATION_FILE);
   for i := 1 to 9 do BlockRead(f,save_information[i],1);
   close(f);

   new(window,init(25,6,55,15,0,TRUE));
   new(select,init);
   with select^ do begin
      for i := 1 to 9 do begin
         str(i,temp_s);
         setMenu(i,'A '+temp_s+' : '+save_information[i].data_name);
      end;
      setMenuColor(14,3);
      file_number := selectMenu(27,6,1,9);
      if file_number in [1..9] then begin
         setMaxInputByte(15);
         s := save_information[file_number].data_name;
         s := inputHangul(36*8,(5+file_number)*16,s,0,TRUE);
         if pos('币',s) > 0 then s := 'we 币a';
         if pos('eȁ',s) > 0 then s := returnMessage('your name+S')+' eȁa';
         save_information[file_number].data_name := s;
      end else s := '';
      if s = '' then begin
         setHanType(SAMMUL);
         chDir('..');
         dispose(select,done);
         dispose(window,done);
         exit;
      end;
   end;
   dispose(select,done);
   dispose(window,done);

   str(file_number,file_name);
   file_name := 'Save'+file_name;

   assign(f,file_name);
   rewrite(f,1);

   BlockWrite(f,SAVE_ID[1],length(SAVE_ID));
   BlockWrite(f,game_system.m_proceeding_level,sizeof(game_system.m_proceeding_level));
   BlockWrite(f,map_header,sizeof(map_header));
   for i := 1 to map_header.count_of_exit_point do begin
      BlockWrite(f,map_exit_data[i]^,sizeof(map_exit_data[i]^));
   end;

   BlockWrite(f,game_system,sizeof(system_O));
   BlockWrite(f,person_movement_data,sizeof(person_movement_data));
   BlockWrite(f,invoid_person_movement_data,sizeof(invoid_person_movement_data));
   BlockWrite(f,talkable_person,sizeof(talkable_person));
   BlockWrite(f,recognizable_person,sizeof(recognizable_person));
   BlockWrite(f,temp1_person,sizeof(temp1_person));
   BlockWrite(f,temp2_person,sizeof(temp2_person));
   BlockWrite(f,temp3_person,sizeof(temp3_person));
   BlockWrite(f,max_person,sizeof(max_person));

   for MA := succ(START_OF_MAP_ATTRIBUTE) to pred(END_OF_MAP_ATTRIBUTE) do begin
      BlockWrite(f,map[MA]^,game_system.returnMapXMax * game_system.returnMapYMax);
   end;

   BlockWrite(f,item_map,sizeof(item_map));
   for i := 1 to item_map.number_of_data do begin
      BlockWrite(f,item_map.data[i].item_data^,sizeof(item_map.data[i].item_data^));
   end;

   if map_header.tile_data_file <> '' then begin
      for i := 0 to MAX_TILE-1 do
       BlockWrite(f,tile_data[i]^,sizeof(tile_data[i]^));
   end;
   if map_header.object_data_file <> '' then begin
      for i := 0 to MAX_OBJECT_TILE-1 do
       BlockWrite(f,object_tile_data[i]^,sizeof(object_tile_data[i]^));
   end;
   if map_header.equipment_data_file <> '' then begin
      for i := 1 to MAX_EQUIPMENT_TILE do
       BlockWrite(f,equipment_tile_data[i]^,sizeof(equipment_tile_data[i]^));
   end;
   if map_header.field_data_file <> '' then begin
      for i := 0 to MAX_FIELD_TILE-1 do
       BlockWrite(f,field_tile_data[i]^,sizeof(field_tile_data[i]^));
   end;
   if map_header.character_data_file <> '' then begin
      for i := 0 to MAX_CHARACTER_TILE-1 do
       BlockWrite(f,character_tile_data[i]^,sizeof(character_tile_data[i]^));
   end;

   BlockWrite(f,_MAIN_CHARACTER,sizeof(_MAIN_CHARACTER));
   BlockWrite(f,MAX_EVENT_DATA,sizeof(MAX_EVENT_DATA));
   BlockWrite(f,MAX_TIME_EVENT_DATA,sizeof(MAX_TIME_EVENT_DATA));
   BlockWrite(f,MAX_TALK_DATA,sizeof(MAX_TALK_DATA));
   BlockWrite(f,MAX_LABEL,sizeof(MAX_LABEL));
   BlockWrite(f,MAX_SUBJECT_DATA,sizeof(MAX_SUBJECT_DATA));

   for i := 1 to MAX_RGS_DATA do begin
      if RGS_data[i] <> nil then begin
         BlockWrite(f,FULL_CODE,1);
         BlockWrite(f,RGS_data[i]^,sizeof(RGS_data[i]^));
      end else begin
         BlockWrite(f,NULL_CODE,1);
      end;
   end;

   for i := 1 to MAX_SUBJECT_DATA do begin
      if subject_data[i] <> nil then begin
         BlockWrite(f,FULL_CODE,1);
         BlockWrite(f,subject_data[i]^,sizeof(subject_data[i]^));
      end else begin
         BlockWrite(f,NULL_CODE,1);
      end;
   end;

   BlockWrite(f,label_address,sizeof(label_address));

   for i := 1 to MAX_MESSAGE_ARRAY do begin
      if message[i] <> nil then begin
         BlockWrite(f,FULL_CODE,1);
         BlockWrite(f,message[i]^,sizeof(message[i]^));
      end else begin
         BlockWrite(f,NULL_CODE,1);
      end;
   end;

   chDir('..');
   assign(f1,TEMPLET_FILE);
   {$I-}
   reset(f1,1);
   {$I+}
   if IOResult = 0 then begin
      size := FileSize(f1);
      chDir(SUB_DIRECTORY);
      BlockWrite(f,size,sizeof(size));
      getMem(buffer,10000);
      while size >= 10000 do begin
         BlockRead(f1,buffer^,10000);
         BlockWrite(f,buffer^,10000);
         size := size - 10000;
      end;
      if size > 0 then begin
         BlockRead(f1,buffer^,size);
         BlockWrite(f,buffer^,size);
      end;
      FreeMem(buffer,10000);
      close(f1);
   end else begin
      size := 0;
      chDir(SUB_DIRECTORY);
      BlockWrite(f,size,sizeof(size));
   end;

   for i := 1 to MAX_PERSON_ARRAY do begin
      if person[i] <> nil then begin
         BlockWrite(f,FULL_CODE,1);
         if i = 1 then
            BlockWrite(f,person[i]^.m_name,sizeof(complete_person_O))
         else
            BlockWrite(f,person[i]^.m_name,sizeof(simple_person_O));
      end else begin
         BlockWrite(f,NULL_CODE,1);
      end;
   end;

   close(f);

   str(file_number,temp_s);
   findFirst(OBJ_SAVE_FILE+temp_s+'.*', Archive, DirInfo);
   while DosError = 0 do begin
      deleteFile(DirInfo.Name);
      findNext(DirInfo);
   end;
   getMem(buffer,10000);
   findFirst(OBJ_SAVE_FILE+'0.*', Archive, DirInfo);
   while DosError = 0 do begin
      assign(f,DirInfo.Name);
      reset(f,1);
      file_name := DirInfo.Name;
      FSplit(file_name, D, N, E);
      dec(N[0]);
      file_name := N + temp_s + E;
      assign(f1,file_name);
      rewrite(f1,1);
      repeat
         BlockRead(f,buffer^,10000,NumRead);
         BlockWrite(f1,buffer^,NumRead,NumWritten);
      until (NumRead = 0) or (NumWritten <> NumRead);
      close(f);
      close(f1);
      findNext(DirInfo);
   end;
   freeMem(buffer,10000);

   str(file_number,file_name);
   file_name := 'Save'+file_name;
   temp_long := returnCheckSum(file_name);
   if temp_long <> save_information[file_number].check_sum then begin
      with save_information[file_number] do begin
         check_sum := temp_long;
         for i := 1 to 5 do gabage_byte1[i] := random(256);
         for i := 1 to 3 do gabage_byte2[i] := random(256);
         for i := 1 to 4 do gabage_byte3[i] := random(256);
         pb := addr(check_sum);
         check_sum_byte := pb^;
         for i := 1 to 3 do begin
            inc(pb);
            check_sum_byte := check_sum_byte + pb^;
         end;
      end;
   end;
   assign(f,SAVE_INFORMATION_FILE);
   {$I-}
   rewrite(f,sizeof(save_data_T));
   {$I+}
   if IOResult <> 0 then printErrorMessage(1,SAVE_INFORMATION_FILE);
   for i := 1 to 9 do BlockWrite(f,save_information[i],1);
   close(f);

   chDir('..');

   setHanType(SAMMUL);
end;

procedure setGameSystem;
var
   select : ^select_O;
   window : ^window_O;
   selected_menu, max_line : integer;
begin
   new(window,init(25,5,55,11,4,TRUE));
   new(select,init);
   with select^ do begin
      setMenu(1,'ei ea      [-]');
      setMenu(2,'ei ea      [+]');
      setMenu(3,' b w ew');
      setMenu(4,'Ai ᵥa');
      setMenu(5,'Ai wea');
      setMenu(6,'Ai {a');
      max_line := 6;
      setMenuColor(15,7);
      arrangeMenu(max_line);
      selected_menu := selectMenu(28,5,1,max_line);
      dispose(select,done);
      dispose(window,done);
      case selected_menu of
         1 : decreaseScreenWide;
         2 : increaseScreenWide;
         3 :
         with game_system do begin
            if getOutlineTalk < NET_IMAGE_OUTLINE then
               setOutlineTalk(succ(getOutlineTalk))
            else
               setOutlineTalk(NORMAL_OUTLINE);
         end;
         4 : loadGame(FALSE);
         5 : saveGame;
         6 : user_key := EXIT_CODE;
      end;
   end;
end;

procedure excuteMemoPad;
type
   TMemoStr = string[59];
const
   MAX_MEMO = 17;
var
   f      : file;
   i, key : integer;
   row    : integer;
   window : ^window_O;
   s      : array[1..MAX_MEMO] of ^TMemoStr;
begin
   for i := 1 to MAX_MEMO do new(s[i]);

   chDir(SUB_DIRECTORY);

   assign(f,'OBJS0.MMF');
   {$I-}
   reset(f,1);
   {$I+}
   if IOResult = 0 then begin
      BlockRead(f,row,sizeof(row));
      for i := 1 to MAX_MEMO do BlockRead(f,s[i]^,sizeof(s[i]^));
      close(f);
   end else begin
      row := 1;
      for i := 1 to MAX_MEMO do s[i]^ := '';
   end;

   new(window,init(10,3,70,20,0,TRUE));
   setMaxInputByte(56);

   for i := 1 to MAX_MEMO do begin
      printString(11,2+i,s[i]^+'   ',11,TRUE,0);
   end;

   key := 0;
   while key <> ESCAPE_KEY do begin
      setHanColor(10);
      s[row]^ := inputHangulEXTENDED(11*8,(2+row)*16,s[row]^,0,FALSE,key);
      printString(11,2+row,s[row]^+'   ',11,TRUE,0);
      setcolor(0);
      line(11*8,(3+row)*16,(11+length(s[row]^)+3)*8,(3+row)*16);
      if key = UP_KEY then begin
         if row > 1 then dec(row);
      end;
      if key = DOWN_KEY then begin
         if row < MAX_MEMO then inc(row);
      end;
   end;
   dispose(window,done);

   rewrite(f,1);
   BlockWrite(f,row,sizeof(row));
   for i := 1 to MAX_MEMO do BlockWrite(f,s[i]^,sizeof(s[i]^));
   close(f);

   chDir('..');

   for i := 1 to MAX_MEMO do dispose(s[i]);
end;

procedure selectShortMenu;
var
   window : ^window_O;
   select : ^select_O;
   selected_menu : integer;
begin
   new(window,init(31,9,49,12,0,TRUE));
   new(select,init);
   with select^ do begin
      setMenu(1,'A          w');
      setMenu(2,'Ai  ᵥa');
      setMenu(3,'Ai  wea');
      setMenuColor(11,1);
      selected_menu := selectMenu(32,9,1,3);
      flipPageEASY;
      dispose(select,done);
      dispose(window,done);
      case selected_menu of
         1 : excuteMemoPad;
         2 : loadGame(FALSE);
         3 : saveGame;
      end;
   end;
end;

procedure selectMainMenu;
var
   select : ^select_O;
   selected_menu : integer;
begin
   new(select,init);
   with select^ do begin
      setMenu(1 ,'i a              [L]');
      setMenu(2 ,'wi wbea          [E]');
      setMenu(3 ,'wi ЁAea          [R]');
      setMenu(4 ,'i aa            [G]');
      setMenu(5 ,'i ea            [D]');
      setMenu(6 ,'Ai a          [M]');
      setMenu(7 ,'wi bea          [A]');
      setMenu(8 ,'a ea              [S]');
      setMenu(9 ,'Αi awea          [U]');
      setMenu(10,'ai awea          [C]');
      setMenu(11,'A Ȃ w              ');
      convertGrayScale;
      setMenuColor(11,2);
      selected_menu := selectMenu(25,5,remember_selected_menu,11);
      flipPageEASY;
      dispose(select,done);
      if selected_menu > 0 then begin
         remember_selected_menu := selected_menu;
         case selected_menu of
            1 : lookObject(person[_MAIN_CHARACTER]^);
            2 : person[_MAIN_CHARACTER]^.equipSomething;
            3 : person[_MAIN_CHARACTER]^.disarmSomething;
            4 : getObject(person[_MAIN_CHARACTER]^);
            5 : dropObject(person[_MAIN_CHARACTER]^);
            6 : moveObject(person[_MAIN_CHARACTER]^);
            7 : person[_MAIN_CHARACTER]^.attackSomething;
            8 : sleepHere(person[_MAIN_CHARACTER]^);
            9 : person[_MAIN_CHARACTER]^.useItem;
            10: person[_MAIN_CHARACTER]^.castMagic;
            11: setGameSystem;
         end;
      end;
   end;
   flipPageEASY;
end;


procedure sleepHere(var subject : person_O);
var
   s : string[3];
   select : ^select_O;
   selected_time : integer;
   i,person_loop : integer;
begin
   new(select,init);
   with subject do begin
      if readMap(MA_OBJECT,returnX,returnY) = 2 then begin
         convertGrayScale;
         setHanColor(11);
         printTalkHangul(23,3,'we y ee aVsa?',2);
         printString(24,4,'e ee '+game_system.returnTimeString(TRUE)+' a',15,FALSE,0);
         for i := 1 to 10 do begin
            str(i : 2,s);
            select^.setMenu(i,'-- '+s+' ee');
         end;
         selected_time := select^.selectMenu(27,6,remember_sleep_time,10);
         if selected_time > 0 then begin
            remember_sleep_time := selected_time;
            clearPage(0);
            key_code := 0;
            while selected_time > 0 do begin
               game_system.passTime(0,1,0,0);
               for i := 1 to max_person do person[i]^.setInitialPosition;
               if readMap(MA_OBJECT,returnX,returnY) <> 2 then
                  selected_time := 0
               else
                  dec(selected_time);
            end;
         end;
         scrollMap;
         flipPage;
      end;
   end;
   dispose(select,done);
end;

procedure getObject(var subject : person_O);
var
   origin_x, origin_y, get_x, get_y : integer;
   temp_b : byte;
   temp_item : item_T;
   i, j : integer;
begin
   origin_x := 0;
   origin_y := 0;
   subject.modifySelectionCenter(origin_x,origin_y);
   get_x := origin_x;
   get_y := origin_y;

   selectObject(get_x,get_y,1,1,0,0,GET_CURSOR);
   get_x := get_x - origin_x;
   get_y := get_y - origin_y;

   if readMap(MA_NORMAL,subject.returnX,subject.returnY) in FOREGROUND_TILE then begin
      if (get_y > 0) and
         not (readMap(MA_NORMAL,subject.returnX+get_x,subject.returnY+get_y) in FOREGROUND_TILE) then begin
         exit;
      end;
   end;

   temp_b := readMap(MA_OBJECT,subject.returnX+get_x,subject.returnY+get_y);
   if ((get_x <> 0) or (get_y <> 0)) and
      (((temp_b in [0..MAX_OBJECT_TILE-1]) and (object_data_index[temp_b] > 0)) or
      (temp_b > ADDRESS_OF_WEAPON_IN_OBJECT_TILE)) then begin
      if not returnItemMap(subject.returnX+get_x,subject.returnY+get_y,temp_item) then begin
         if map_header.friendship_level = 0 then
         if not (readMap(MA_NORMAL,subject.returnX+get_x,subject.returnY+get_y) in (MOVABLE_TILE+FOREGROUND_TILE)) then begin
            for j := -MAX_SCROLL_Y_WIDE to MAX_SCROLL_Y_WIDE do begin
               for i := -MAX_SCROLL_X_WIDE to MAX_SCROLL_X_WIDE do begin
                  temp_b := readMap(MA_PERSON,_MAP_X_CENTER+i,_MAP_Y_CENTER+j);
                  if temp_b > 0 then begin
                     if person[temp_b]^.returnInternal(_love) <> subject.returnNumber then begin
                        person[temp_b]^.setInternal(_hostile,subject.returnNumber);
                     end;
                  end;
               end;
            end;
         end;
         convertObjectToItem(readMap(MA_OBJECT,subject.returnX+get_x,subject.returnY+get_y),temp_item);
         writeMap(MA_OBJECT,subject.returnX+get_x,subject.returnY+get_y,0);
      end;
      if not subject.getSomething(temp_item) then begin
         setItemMap(subject.returnX+get_x,subject.returnY+get_y,temp_item);
      end;
   end;
end;

procedure lookObject(var subject : person_O);
var
   i, origin_x, origin_y, get_x, get_y : integer;
   s : string;
begin
   origin_x := 0;
   origin_y := 0;
   subject.modifySelectionCenter(origin_x,origin_y);
   get_x := origin_x;
   get_y := origin_y;

   selectObject(get_x,get_y,1,1,0,0,LOOK_CURSOR);
   get_x := get_x - origin_x;
   get_y := get_y - origin_y;

   if readMap(MA_NORMAL,subject.returnX,subject.returnY) in FOREGROUND_TILE then begin
      if (get_y > 0) and
         not (readMap(MA_NORMAL,subject.returnX+get_x,subject.returnY+get_y) in FOREGROUND_TILE) then begin
         exit;
      end;
   end;

   origin_x := subject.returnX+get_x;
   origin_y := subject.returnY+get_y;

   s := '';

   if readMap(MA_ATTRIBUTE,origin_x,origin_y) and SEARCHABLE_BIT > 0 then begin
      _PERSON_CONTROLL_CODE := OCCUR_EVENT;
      _EVENT_X_POSITION := origin_x;
      _EVENT_Y_POSITION := origin_y;
      exit;
   end;

   if readMap(MA_FIELD,origin_x,origin_y) and FIELD_BIT > 0 then begin
      i := readMap(MA_FIELD,origin_x,origin_y) and FIELD_BIT;
      if i in [1..MAX_FIELD] then begin
         if not (i in [__FIELD_VACUUM,__FIELD_SLEEP]) then begin
            s := 'e '+field_name_string[i];
         end;
      end;
   end
   else if readMap(MA_PERSON,origin_x,origin_y) > 0 then begin
      i := readMap(MA_PERSON,origin_x,origin_y);
      if i = subject.returnNumber then begin
         subject.viewPerson;
         exit;
      end;
      if (person[i]^.returnInternal(_unconscious_depth) > 0) or
         (person[i]^.returnInternal(_death_depth) > 0) then begin
         person[i]^.extractItems;
         exit;
      end
      else if (i in recognizable_person) or (i >= MAX_TALKABLE_PERSON_ARRAY) then begin
         s := ' aqe '+person[i]^.returnName;
      end
      else begin
         s := 'ae aq..';
      end;
   end
   else if readMap(MA_OBJECT,origin_x,origin_y) > 0 then begin
      s := 'e '+returnObjectName(origin_x,origin_y);
   end;
   if s <> '' then begin
      registerMessage(subject.returnNumber,s+'..',DEFAULT_DELAY);
   end;
end;

procedure dropObject(var subject : person_O);
var
   temp_b : byte;
   i, j, selected_menu, max_menu, origin_x, origin_y, get_x, get_y : integer;
   item_kind, temp_item : item_T;
begin
   with subject do begin

      selected_menu := selectItemADVANCED('៩ i a');

      if selected_menu > 0 then begin
         dropSomething(selected_menu,item_kind);
         if item_kind._item_contain > 1 then begin
            if item_kind._item_type > START_OF_EQUIPMENT then
               j := decideEA(1,item_kind._item_contain,'៩ i a')
            else
               j := 1;
            if j > 0 then begin
               item_kind._item_contain := item_kind._item_contain - j;
               if item_kind._item_contain > 0 then begin
                  getSomething(item_kind);
               end;
               item_kind._item_contain := j;
            end
            else begin
               getSomething(item_kind);
               exit;
            end;
         end;
         origin_x := 0;
         origin_y := 0;
         subject.modifySelectionCenter(origin_x,origin_y);
         get_x := origin_x;
         get_y := origin_y;
         if item_kind._item_type = START_OF_EQUIPMENT then
            selectObject(get_x,get_y,1,1,0,0,item_kind._item_number)
         else
            selectObject(get_x,get_y,1,1,0,0,item_kind._item_number+MAX_EQUIPMENT_TILE);
         get_x := get_x - origin_x;
         get_y := get_y - origin_y;

         if readMap(MA_NORMAL,subject.returnX,subject.returnY) in FOREGROUND_TILE then begin
            if (get_y > 0) and
               not (readMap(MA_NORMAL,subject.returnX+get_x,subject.returnY+get_y) in FOREGROUND_TILE) then begin
               getSomething(item_kind);
               exit;
            end;
         end;

         temp_b := readMap(MA_PERSON,subject.returnX+get_x,subject.returnY+get_y);
         if temp_b > 0 then begin
            if item_kind._item_type > START_OF_EQUIPMENT then begin
               if not person[readMap(MA_PERSON,subject.returnX+get_x,subject.returnY+get_y)]^.
                  getSomething(item_kind) then getSomething(item_kind);
            end else begin
               item_kind._item_number := item_kind._item_number;{ - MAX_EQUIPMENT_TILE;}
               if not person[temp_b]^.getSomething(item_kind) then getSomething(item_kind);
            end;
         end
         else begin
            temp_b := readMap(MA_OBJECT,subject.returnX+get_x,subject.returnY+get_y);
            if temp_b > 0 then begin
               if ((object_data_index[temp_b] > 0) or
                  (temp_b > ADDRESS_OF_WEAPON_IN_OBJECT_TILE)) then begin
                  if readMap(MA_NORMAL,subject.returnX+get_x,subject.returnY+get_y)
                     in MOVABLE_TILE then begin
                     setItemMap(subject.returnX+get_x,subject.returnY+get_y,item_kind);
                  end else begin
                     getSomething(item_kind);
                  end;
               end else begin
                  getSomething(item_kind);
               end;
            end else begin
               if isPassableMap(subject.returnX+get_x,subject.returnY+get_y) then
                  setItemMap(subject.returnX+get_x,subject.returnY+get_y,item_kind)
               else
                  getSomething(item_kind);
            end;
         end;
      end;
   end;
end;

procedure moveObject(var subject : person_O);
var
   origin_x, origin_y, get_x, get_y, x_temp, y_temp : integer;
   temp_b : byte;
   temp_item, aux_item : item_T;
begin

   origin_x := 0;
   origin_y := 0;
   subject.modifySelectionCenter(origin_x,origin_y);
   get_x := origin_x;
   get_y := origin_y;
   selectObject(get_x,get_y,1,1,0,0,MOVE_CURSOR);
   get_x := get_x - origin_x;
   get_y := get_y - origin_y;

   if readMap(MA_NORMAL,subject.returnX,subject.returnY) in FOREGROUND_TILE then begin
      if (get_y > 0) and
         not (readMap(MA_NORMAL,subject.returnX+get_x,subject.returnY+get_y) in FOREGROUND_TILE) then begin
         exit;
      end;
   end;

   if ((get_x <> 0) or (get_y <> 0)) and
      ((object_data_index[readMap(MA_OBJECT,subject.returnX+get_x,subject.returnY+get_y)] > 0) or
       (readMap(MA_OBJECT,subject.returnX+get_x,subject.returnY+get_y) > ADDRESS_OF_WEAPON_IN_OBJECT_TILE)) then begin
      if map_header.friendship_level = 0 then begin
         if not (readMap(MA_NORMAL,subject.returnX+get_x,subject.returnY+get_y) in (MOVABLE_TILE+FOREGROUND_TILE)) then begin
            registerMessage(_MAIN_CHARACTER,'q A e e',DEFAULT_DELAY);
            exit;
         end;
      end;
      x_temp := get_x; y_temp := get_y;
      get_x := get_x + origin_x;
      get_y := get_y + origin_y;
      selectObject(get_x,get_y,1,1,0,0,MOVE_CURSOR);
      get_x := get_x - origin_x;
      get_y := get_y - origin_y;
      if (get_x <> 0) or (get_y <> 0) then begin
         if ((abs(x_temp-get_x)+abs(y_temp-get_y)) = 1) then begin
            if ((readMap(MA_NORMAL,subject.returnX+get_x,subject.returnY+get_y) in (MOVABLE_TILE+FOREGROUND_TILE)) and
                (readMap(MA_OBJECT,subject.returnX+get_x,subject.returnY+get_y) = 0) and
                (readMap(MA_PERSON,subject.returnX+get_x,subject.returnY+get_y) = 0)) then begin
               if returnItemMap(subject.returnX+x_temp,subject.returnY+y_temp,temp_item) then begin
                  setItemMap(subject.returnX+get_x,subject.returnY+get_y,temp_item);
               end else begin
                  writeMap(MA_OBJECT,subject.returnX+get_x,subject.returnY+get_y,
                           readMap(MA_OBJECT,subject.returnX+x_temp,subject.returnY+y_temp));
                  writeMap(MA_OBJECT,subject.returnX+x_temp,subject.returnY+y_temp,0);
               end;
            end
            else if readMap(MA_OBJECT,subject.returnX+get_x,subject.returnY+get_y) > 0 then begin
               temp_b := readMap(MA_OBJECT,subject.returnX+get_x,subject.returnY+get_y);
               if (object_data_index[temp_b] > 0) or (temp_b > ADDRESS_OF_WEAPON_IN_OBJECT_TILE) then begin
                  if not returnItemMap(subject.returnX+x_temp,subject.returnY+y_temp,temp_item) then begin
                     convertObjectToItem(
                        readMap(MA_OBJECT,subject.returnX+x_temp,subject.returnY+y_temp),temp_item);
                     writeMap(MA_OBJECT,subject.returnX+x_temp,subject.returnY+y_temp,0);
                  end;
                  setItemMap(subject.returnX+get_x,subject.returnY+get_y,temp_item);
               end;
            end;
         end;
      end;
   end;
end;

end.
