{$DEFINE _OVERLAY}

unit DVPersn2;
{$IFDEF __OVERLAY}
   {$O+,F+}
{$ENDIF}

INTERFACE

uses
   dos, graph,
   DVHan20, DVSubpro, DVPerson;

procedure cheatGame(var subject : person_O);
procedure lookProfile(var subject : person_O);

IMPLEMENTATION

uses
   DVDecode;

procedure viewGameEnvironment(var subject : person_O);
var
   window : ^window_O;
   s      : string;
begin
   new(window,init(20,8,60,15,1,TRUE));
   str(MEMAVAIL,s);
   window^.printHangul('@FMax Available Heap Memory : '+s);
   str(MAXAVAIL,s);
   window^.printHangul('@@@EMax Heap Memory : '+s);
   str(map_header.handicap_bit,s);
   window^.printHangul('@@@FHandicap BIT    : '+s);
   str(MAX_TALK_DATA+MAX_EVENT_DATA+MAX_TIME_EVENT_DATA,s);
   window^.printHangul('@@@DMax RGS Data : '+s);
   str(subject.returnX,s);
   window^.printHangul('@@@7x  : '+s);
   str(subject.returnY,s);
   window^.printHangul('@@@7y  : '+s);
   str(SCROLL_RATE : 4 : 1,s);
   window^.printHangul('@@@BPresent Scroll Rate : '+s+' scroll / sec');
   pressAnyKey;
   dispose(window,done);
end;

procedure changeFlag;
const
   SECTION : integer = 100;
var
   window  : ^window_O;
   s       : string;
   i, j, k, key : integer;

 procedure changeFlagSub;
 var
    i, j : integer;
 begin
    window^.clearWindow(1);
    window^.setCursor(0,0);
    str(SECTION : 3,s);
    window^.printHangul('@A'+s);
    window^.printHangul('@@ @F      0 1 2 3 4 5 6 7 8 9@@');
    for j := 0 to 9 do begin
      str(j*10:3,s);
      window^.printHangul(' @F '+s+'@B  ');
      for i := 0 to 9 do begin
         if game_system.getEventBit(SECTION+j*10+i) then
            window^.printHangul('O ')
         else
            window^.printHangul('X ');
      end;
      window^.printHangul('@@');
    end;
 end;

begin
   new(window,init(25,5,55,18,1,TRUE));
   changeFlagSub;

   i := 32*8-3; j := 7*16;
   key := 0; k := 0;
   setcolor(10);
   rectangle(i+(k mod 10)*16,j+(k div 10)*16,i+(k mod 10)*16+12,j+(k div 10)*16+14);
   while key <> 27 do begin
      key := ord(readKey);
      setcolor(1);
      rectangle(i+(k mod 10)*16,j+(k div 10)*16,i+(k mod 10)*16+12,j+(k div 10)*16+14);
      if key = 0 then begin
         key := ord(readKey);
         case key + SCAN_CODE of
            UP_KEY    : dec(k,10);
            DOWN_KEY  : inc(k,10);
            LEFT_KEY  : dec(k);
            RIGHT_KEY : inc(k);
         end;
         if k < 0 then k := 0;
         if k > 99 then k := 99;
      end else begin
         case key of
            ord('+')  :
            if SECTION < 300 then begin
               inc(SECTION,100);
               changeFlagSub;
            end;
            ord('-')  :
            if SECTION > 99  then begin
               dec(SECTION,100);
               changeFlagSub;
            end;
        end;
      end;
      if key = ACCEPT_KEY then begin
         setFillStyle(SolidFill,2);
         bar(i+(k mod 10)*16,j+(k div 10)*16,i+(k mod 10)*16+12,j+(k div 10)*16+14);
         setHanColor(11);
         if game_system.getEventBit(SECTION+k) then begin
            s := 'X'; game_system.resetEventBit(SECTION+k);
         end else begin
            s := 'O'; game_system.setEventBit(SECTION+k);
         end;
         printHangul(i+(k mod 10)*16+8,j+(k div 10)*16,s);
      end;
      setcolor(10);
      rectangle(i+(k mod 10)*16,j+(k div 10)*16,i+(k mod 10)*16+12,j+(k div 10)*16+14);
   end;

   dispose(window,done);
end;

procedure changePlayer(var subject : person_O);
var
   origin_x, origin_y, get_x, get_y : integer;
begin
   scrollMap;
   flipPage;

   origin_x := 0;
   origin_y := 0;
   subject.modifySelectionCenter(origin_x,origin_y);
   get_x := origin_x;
   get_y := origin_y;

   selectObject(get_x,get_y,10,10,0,0,NORMAL_CURSOR);
   get_x := get_x - origin_x + subject.returnX;
   get_y := get_y - origin_y + subject.returnY;

   if readMap(MA_PERSON,get_x,get_y) > 0 then begin
      _MAIN_CHARACTER := readMap(MA_PERSON,get_x,get_y);
   end;
end;

procedure TownPortal;
var
   window : ^window_O;
   s      : string;
begin
   new(window,init(33,10,47,11,0,TRUE));
   setMaxInputByte(12);
   s := inputHangul(35*8,10*16,'',0,FALSE);
   dispose(window,done);

   game_system._NEXT_EXCUTE_FILE := s;
   game_system._NEXT_START_X := 0;
   game_system._NEXT_START_Y := 0;
   user_key := EXIT_CODE;
end;

procedure cheatGame(var subject : person_O);
var
   window : ^window_O;
   select : ^select_O;
   selected_menu : integer;
begin
   new(window,init(31,8,49,12,0,TRUE));
   new(select,init);
   with select^ do begin
      setMenu(1,'A  ŉw  ');
      setMenu(2,'ia    a');
      setMenu(3,'iA  a');
      setMenu(4,'ae  a');
      setMenuColor(11,1);
      selected_menu := selectMenu(32,8,1,4);
   end;
   flipPageEASY;
   dispose(select,done);
   dispose(window,done);
   case selected_menu of
      1 : viewGameEnvironment(subject);
      2 : changeFlag;
      3 : changePlayer(subject);
      4 : TownPortal;
   end;
end;

procedure displayPartedProfile(var subject : person_O; select_number : integer; var Twindow : titled_window_O);
const
   NEW_X = 34;
   NEW_Y = 2;

   ability_string : array[succ(START_OF_ABILITY)..pred(END_OF_ABILITY)] of string[20] = (
      'e            b', { _strength      }
      '            b', { _inteligence   }
      '          b', { _concentration }
      '          b', { _endurance     }
      '          ', { _accuracy      }
      '          ', { _agility       }
      '          b', { _will          }
      '     w     ', { _priety        }
      'З            ', { _luck          }
      'A            I'  { _level         }
   );
   internal_string : array[succ(START_OF_INTERNAL).._death_depth] of string[16] = (
      'A  b      ', { _hit_point                      }
      'a        ', { _spell_point                    }
      ' a qb', { _whorl_shien                    }
      'Ab  Ab', { _hit_point_recovering_templet   }
      'a  Ab', { _spell_point_recovering_templet }
      'w        ', { _defense_level                  }
      '',                 { _defense_magic                  }
      '            b', { _disposition                    }
      '      ', { _poison_depth                   }
      ' e     ', { _sleep_depth                    }
      ' ͡     ', { _fear_depth                     }
      'a      ', { _paralisis_depth                }
      '      ', { _stonization_depth              }
      '  w  ', { _unconscious_depth              }
      ' q     '  { _death_depth                    }
   );
   skill_string : array[succ(START_OF_SKILL)..pred(END_OF_SKILL)] of string[16] = (
      'Ae    ', { _sword_skill             }
      'e    ', { _axe_skill               }
      'ae  ', { _spear_skill             }
      '廡e  ', { _throw_skill             }
      ' a w    ', { _bow_skill               }
      '    ', { _fist_skill              }
      'ẃ  aw  ', { _shield_skill            }
      '  s   w b', { _fire_treating           }
      '  s   w b', { _water_treating          }
      's   w b', { _air_treating            }
      'j  s   w b', { _earth_treating          }
      '  s   w b', { _light_treating          }
      '      w  b', { _summon_skill            }
      'a  A  wb', { _dimention_control_skill }
      'á  a    w  b', { _cure_skill              }
      'a  aw  wb'  { _magic_skill             }
   );
   EXTRA_EDGE = 4;
var
   i  : integer;
   s : string;
begin
   case select_number of
      1 : s := 'wb ';
      2 : s := ' ';
      3 : s := ' ';
   end;
   Twindow.setTitle(s);
   Twindow.clearWindow(0);
   Twindow.setCursor(0,0);
   case select_number of
      1 :
      begin
         for i := ord(succ(START_OF_ABILITY)) to ord(pred(END_OF_ABILITY)) do begin
            if ability_string[ability_T(i)] <> '' then begin
               str(subject.returnAbility(ability_T(i)),s);
               s := '@E  '+ability_string[ability_T(i)]+'    @D'+s+'@@';
               Twindow.printHangul(s);
            end;
         end;
         str(subject.returnSkill(pred(END_OF_SKILL)),s);
         s := '@E  '+skill_string[pred(END_OF_SKILL)]+'    @D'+s+'@@';
         Twindow.printHangul(s);
         str(round(subject.returnInternal(_potential_experience)*100.0
             /subject.returnAbility(_level)),s);
         s := '@E  w          á    @D'+s+'%@@';
         Twindow.printHangul(s);
      end;
      2 :
      begin
         for i := ord(succ(START_OF_INTERNAL)) to ord(_death_depth) do begin
            if internal_string[internal_T(i)] <> '' then begin
               str(subject.returnInternal(internal_T(i)),s);
               s := '@E  '+internal_string[internal_T(i)]+'    @D'+s+'@@';
            end else s := '@@';
            Twindow.printHangul(s);
         end;
      end;
      3 :
      begin
         for i := ord(succ(START_OF_SKILL)) to ord(pred(END_OF_SKILL))-1 do begin
            if skill_string[skill_T(i)] <> '' then begin
               str(subject.returnSkill(skill_T(i)),s);
               s := '@E  '+skill_string[skill_T(i)]+'    @D'+s+'@@';
            end else s := '@@';
            Twindow.printHangul(s);
         end;
      end;
   end;
end;

procedure lookProfile(var subject : person_O);
const
   XXX = 10;
   YYY = 6;
   MAX_STRING = 3;
var
   key_in, i : integer;
   selected_part : integer;
   Twindow : ^titled_window_O;

begin
   new(Twindow,init(21,2,60,20,0,TRUE,1,'wb '));

   selected_part := 1;
   displayPartedProfile(subject,selected_part,Twindow^);

   key_in := 0;
   while not (key_in in [ACCEPT_KEY,ESCAPE_KEY]) do begin
      key_in := ord(readKey);
      if key_in = 0 then key_in := SCAN_CODE + ord(readKey);
      i := 0;
      case key_in of
         UP_KEY,   LEFT_KEY  : i := -1;
         DOWN_KEY, RIGHT_KEY : i := 1;
      end;
      selected_part := selected_part + i;
      if selected_part < 1 then selected_part := MAX_STRING;
      if selected_part > MAX_STRING then selected_part := 1;
      if i <> 0 then displayPartedProfile(subject,selected_part,Twindow^);
   end;

   dispose(Twindow,done);
end;

end.
