{$DEFINE _OVERLAY}

unit DVPerson;
{$IFDEF __OVERLAY}
   {$O+,F+}
{$ENDIF}

{$X+}
INTERFACE

uses
   dos, graph,
   DVHan20, DVSubpro;

const
   remember_sleep_time : byte = 5;
   remember_cast_magic : byte = 1;

  {$IFDEF DPMI}
   MAX_BACK_PACK = 49;
   MAX_MOVIE_DATA = 360;
   MAX_ITEM_MAP = 100;
   MAX_HOSTILE = 5;
  {$ELSE}
   MAX_BACK_PACK = 49;
   MAX_MOVIE_DATA = 360;
   MAX_ITEM_MAP = 100;
   MAX_HOSTILE = 5;
  {$ENDIF}

type
   ability_T = (START_OF_ABILITY,
                _strength, _inteligence, _concentration, _endurance, _accuracy,
                _agility, _will, _priety, _luck, _level,
                END_OF_ABILITY);
   internal_T = (START_OF_INTERNAL,
                 _hit_point, _spell_point, _whorl_shien, _hit_point_recovering_templet,
                 _spell_point_recovering_templet, _defense_level, _defense_magic, _disposition,
                 _poison_depth, _sleep_depth, _fear_depth, _paralisis_depth, _stonization_depth,
                 _unconscious_depth, _death_depth, _breath_remain_count, _antodote_body, _levitation,
                 _transparency, _love, _hostile, _hostile1, _hostile2,
                 _hostile3, _hostile4, _experience, _potential_experience,
                 END_OF_INTERNAL);
   skill_T = (START_OF_SKILL,
              _sword_skill, _axe_skill, _spear_skill, _throw_skill, _bow_skill,
              _fist_skill, _shield_skill, _fire_treating, _water_treating, _air_treating,
              _earth_treating, _light_treating, _summon_skill, _dimention_control_skill, _cure_skill,
              _magic_skill,
              END_OF_SKILL);
   equipment_T = (START_OF_EQUIPMENT,
                  _weapon, _shield, _armor, _shoes, _helmet,
                  _gauntlet, _left_hand, _finger, _neck, _money,
                  _food, _useless,
                  END_OF_EQUIPMENT);
   weapon_T = (START_OF_WEAPON,
               _fist, _sword, _axe, _spear, _throw,
               _bow, _fist4MU, _etc,
               END_OF_WEAPON);

   magic_type_T = (mgc_none,mgc_attack,mgc_defense,mgc_summon,mgc_cure,mgc_environment);
   magic_destination_T = (mgc_one,mgc_all,mgc_random,mgc_ground,mgc_party);
   magic_need_T = (mgc_not_need,mgc_fire,mgc_water,mgc_air,mgc_earth,mgc_poison,
                   mgc_thing,mgc_corpse,mgc_weapon,mgc_shield,mgc_armor,mgc_player);
   magic_need_SET = set of magic_need_T;

   magic_T = record
      _magic_type : magic_type_T;
      _magic_number, _magic_shape, _magic_shape_revolution, _magic_trailing_count : integer;
      _magic_destination : magic_destination_T;
      _magic_method : attack_type_T;
      _magic_need_set : magic_need_SET;
      _magic_attribute : attack_attribute_T;
      _magic_attack_power, _magic_attack_range, _magic_MP_consumtion : integer;
   end;

   magic_data_T = record
      name : string[16];
      data : magic_T;
   end;

   item_attribute_T = (_normal, _virtue, _vice);
   item_T = record
      _item_type : equipment_T;
      _item_weapon_type : weapon_T;
      _item_attribute : item_attribute_T;
      _item_number, _item_weight, _item_attack_power, _item_defense_level,
      _item_attack_range, _item_throw_range, _item_throw_power, _item_defense_power,
      _item_suffix, _item_suffix_bonus : integer;
      _item_magic_type : magic_type_T;        { 0.. 100 }
      _item_magic, _item_magic_remain, _item_maintain_level, _item_shape, _item_shape_revolution,
      _item_trailing_count, _item_contain : integer;
   end;
   item_data_T = record
      name : string[16];
      price : integer;
      data : item_T;
   end;

   person_O = object
      m_name : string[16];
      m_person_attribute : magic_need_T;
      m_number,m_x,m_y,m_face,m_face_count : integer;
      m_face_attribute : map_attribute_T;
      m_max_frame : byte;
      aux_byte : array[1..16] of byte;
      m_ability : array[succ(START_OF_ABILITY)..pred(END_OF_ABILITY)] of integer;
      m_internal : array[succ(START_OF_INTERNAL)..pred(END_OF_INTERNAL)] of integer;
      m_skill : array[succ(START_OF_SKILL)..pred(END_OF_SKILL)] of integer;
      m_equipment : array[succ(START_OF_EQUIPMENT)..pred(END_OF_EQUIPMENT)] of item_T;
      m_known_magic : array[succ(mgc_none)..mgc_environment] of setBYTE;
      m_inventory_stack_ptr : byte;

   public
      constructor init(number, face : integer; person_attribute : magic_need_T;
                  face_attribute : map_attribute_T; name : string;
                  max_frame : byte; initialize_position : boolean);
      destructor  done;

      procedure setInitialPosition;
      procedure setName(s : string);
      procedure setPersonAttribute(person_attribute : magic_need_T);
      function  returnPersonAttribute : magic_need_T;
      procedure setNumber(number : integer);
      procedure setX(x : integer);
      procedure setY(y : integer);
      procedure setFace(face : integer);
      procedure setFaceCount(face_count : integer);
      procedure setFaceAttribute(MA : map_attribute_T);
      procedure setMaxFrame(max_frame : byte);
      function  returnName : string;
      function  returnX : integer;
      function  returnY : integer;
      function  returnFaceCount : integer;
      function  returnNumber : integer;
      function  returnFace : integer;
      function  returnFaceAttribute : map_attribute_T;
      function  returnMaxFrame : byte;

      procedure setAbility(ability : ability_T; value : integer);
      function  returnAbility(ability : ability_T) : integer;
      procedure setInternal(internal : internal_T; value : integer);
      function  returnInternal(internal : internal_T) : integer;
      procedure setSkill(skill : skill_T; value : integer);
      function  returnSkill(skill : skill_T) : integer;
      procedure setEquipment(equipment : equipment_T; item : item_T);
      procedure returnEquipment(equipment : equipment_T; var return_item : item_T);
      function  existEquipment(equipment : equipment_T) : boolean;
      function  returnEquipmentNumber(equipment : equipment_T) : integer;
      function  returnEquipmentSuffix(equipment : equipment_T;
                var return_suffix, return_suffix_bonus : integer) : boolean;
      procedure setInventory(inventory : integer; item : item_T); virtual;
      procedure returnInventory(inventory : integer; var return_item : item_T);  virtual;
      function  returnInventoryType(inventory : byte) : equipment_T;  virtual;
      function  returnInventoryNumber(inventory : byte) : integer;  virtual;
      function  returnMaxBackPack : byte; virtual;
      function  haveEnoughIt(number, suffix, contain : integer) : boolean;
      function  findInventory(number, suffix : integer) : integer;
      procedure setMaxInventory(max_inventory : byte);
      function  returnMaxInventory : byte;
      procedure setKnownMagic(MT : magic_type_T; number : byte);
      function  haveKnownMagic(MT : magic_type_T; number : byte) : boolean;
      function  returnMaxAvailHitPoint : integer;
      function  returnMaxAvailSpellPoint : integer;
      procedure reduceHitPoint(point : integer);
      procedure setAbilityALL(param_s : longString);
      procedure setSkillALL(param_s : longString);
      procedure setEquipmentALL(param_s : longString);
      procedure setMagicALL(param_s : longString);
      procedure setItemALL(param_s : longString);
      procedure addAbilityALL(param_s : longString);
      procedure addSkillALL(param_s : longString);
      procedure addEquipmentALL(param_s : longString);
      procedure addMagicALL(param_s : longString);
      procedure addItemALL(param_s : longString);

      function  isActiveCondition : boolean;
      function  returnSpriteNumber(var MA : map_attribute_T) : byte;
      procedure doWalking;
      procedure moveTo(x1, y1 : integer);
      procedure warpTo(x, y : integer);
      procedure turnFace(x1, y1 : integer);
      procedure detectPersonAxes(var x,y : integer);
      procedure talkSentence(s : string);
      procedure modifySelectionCenter(var origin_x, origin_y : integer);
      function  returnAvailableMagicRange : integer;
      function  detectAvailableAttackRange(var x_range, y_range : integer) : attack_type_T;
      function  attackSomething : boolean;
      function  carryOutMagic(MT : magic_type_T; selected_magic : integer) : boolean;
      function  carryOutSummonMagic(selected_magic : integer; need_to_consume_SP : boolean) : boolean;
      function  carryOutEnvironmentMagic(selected_magic : integer; need_to_consume_SP : boolean) : boolean;
      function  carryOutCureMagic(selected_magic : integer; need_to_consume_SP : boolean) : boolean;
      function  carryOutDefenseMagic(selected_magic : integer; need_to_consume_SP : boolean) : boolean;
      function  carryOutAttackMagic(selected_magic : integer; need_to_consume_SP : boolean) : boolean;
      procedure castMagic;
      function  castMagicAUTO(range : byte) : boolean;
      procedure useItem;
      procedure extractItems;
      function  doReaction(params : attack_parameters_T) : integer;
      function  selectItemADVANCED(message : string) : integer;
      procedure equipSomething;
      procedure disarmSomething;
      function  getSomething(identical_item : item_T) : boolean;
      function  dropSomething(stack_ptr : byte; var return_item : item_T) : boolean;
      function  dropSomethingEA(number, suffix, contain : integer; var return_item : item_T) : boolean;
      procedure viewPerson;
      function  getCurrentWeight : word;
      procedure modifyEquipment;
      procedure modifyInternalValue;
      function  doAction : boolean;
   end;

   simple_person_O = object(person_O)
   public
      m_inventory_stack : array[1..MAX_BACK_PACK div 10] of item_T;

      constructor init(number, face : integer; person_attribute : magic_need_T;
                  face_attribute : map_attribute_T; name : string;
                  max_frame : byte; initialize_position : boolean);
      destructor  done;
      procedure setInventory(inventory : integer; item : item_T); virtual;
      procedure returnInventory(inventory : integer; var return_item : item_T); virtual;
      function  returnInventoryType(inventory : byte) : equipment_T;  virtual;
      function  returnInventoryNumber(inventory : byte) : integer; virtual;
      function  returnMaxBackPack : byte; virtual;

   end;

   complete_person_O = object(person_O)
   public
      m_inventory_stack : array[1..MAX_BACK_PACK] of item_T;

      constructor init(number, face : integer; person_attribute : magic_need_T;
                  face_attribute : map_attribute_T; name : string;
                  max_frame : byte; initialize_position : boolean);
      destructor  done;
      procedure setInventory(inventory : integer; item : item_T); virtual;
      procedure returnInventory(inventory : integer; var return_item : item_T); virtual;
      function  returnInventoryType(inventory : byte) : equipment_T;  virtual;
      function  returnInventoryNumber(inventory : byte) : integer; virtual;
      function  returnMaxBackPack : byte; virtual;

   end;

   simple_person_type = ^simple_person_O;
   complete_person_type = ^complete_person_O;

   message_T = record
      message_person : integer;
      message_string : string;
      message_end_time : longint;
   end;

   item_map_data_T = record
      x,y : integer;
      item_data : ^item_T;
   end;
   item_map_T = record
      number_of_data : integer;
      data : array[1..MAX_ITEM_MAP] of item_map_data_T;
   end;

const

   VIRTUE_ATTRIBUTE_BIT = $01;
   NORMAL_ATTRIBUTE_BIT = $02;
   VICE_ATTRIBUTE_BIT = $04;

   object_data_index : array[0..MAX_OBJECT_TILE-1] of byte = (00,
      00,00,00,00,00,00,00,00,02,03,
      00,00,09,00,00,00,04,05,06,07,
      08,09,10,00,00,11,12,13,00,14,
      01,00,00,00,00,00,00,00,00,00,
      00,00,00,00,00,00,00,00,00,00,00);

   MAX_EQUIPABLE_OBJECT = 14;

   object_data_string : array[0..MAX_EQUIPABLE_OBJECT] of string[6] = ('',
      'W','a','A','ᓡ','Ae',
      'wa','','͡a','q','',
      'wa','wa','','aɷ');

   equipment_data_string : array[succ(START_OF_EQUIPMENT)..pred(END_OF_EQUIPMENT)] of string[10] = (
      '','ẃ','s','i','ʁ',
      'ws','aQ','e','鷡','q',
      'q','a');

   MAX_SUFFIX = 24;
   item_suffix_name_string : array[0..MAX_SUFFIX] of string[8] = ('',
      '','ᖑ','','','w',
      'w','ѡ','a','iA','w',
      'ẁ','q','ӱ','','i',
      'Ё','','','','',
      'w','З','勡', ''
   );
   multiply_for_suffix : array[100..100+MAX_SUFFIX] of real = (
      20.0,  1.0,  1.0,  5.0, 10.0,  2.0,  4.0,  3.0,  2.5, 30.0,
       0.5,  0.5,  5.0,  6.0,  8.0,  6.0,  2.5,  1.0,  1.0,  1.0,
       1.0,  1.0,  2.0,  1.0,  0.0
   );
   MAX_SPECIAL_SUFFIX = 8;
   item_special_suffix_name_string : array[0..MAX_SPECIAL_SUFFIX] of string[10] = ('΁a',
      'a','ae','aAa','aa','AaiAa',
      'AaAa','aiaa','AAa'
   );

   MAX_FIELD = 7;
   field_name_string : array[1..MAX_FIELD] of string[10] = (
      'wb','','wb','e','勡wb','Aỡwb','ӱwb');

   MAX_ITEM_DATA = 100;
   MAX_MAGIC_DATA = 30;

   MAX_MESSAGE_ARRAY = 5;
   DEFAULT_DELAY = 3.0;
   MAGIC_DIVISION_RATE = 10.0;

var
   initial_valiable : integer;
   user_key : integer;
   item_data : array[0..MAX_ITEM_DATA] of ^item_data_T;
   item_map : item_map_T;
   MAX_MAGIC_EA, remember_magic_selection : array[mgc_attack..mgc_environment] of byte;
   magic_data : array[mgc_attack..mgc_environment,1..MAX_MAGIC_DATA] of ^magic_data_T;
   person : array[1..MAX_PERSON_ARRAY] of ^person_O;
   message : array[1..MAX_MESSAGE_ARRAY] of ^message_T;

   _EVENT_X_POSITION, _EVENT_Y_POSITION : byte;
   _TALK_PERSON : byte;

 procedure scrollMap;


IMPLEMENTATION

uses
   DVDecode, DVPersn1, DVPersn2;

(*  Insert DVSubPro.pas *)

function readMap(MA : map_attribute_T; x,y : integer) : byte;
         (* because of game speed, near call function *)
begin
   if (x < 0) or (x > pred(game_system.m_map_x_max)) or
      (y < 0) or (y > pred(game_system.m_map_y_max)) then begin
      readMap := 0;
   end else readMap := map[MA]^[game_system.m_map_x_max * y + x]
end;

constructor person_O.init(number, face : integer; person_attribute : magic_need_T;
                          face_attribute : map_attribute_T; name : string;
                          max_frame : byte; initialize_position : boolean);
var
   i,j : integer;
begin
   setName(name);
   setPersonAttribute(person_attribute);
   setNumber(number);
   setFace(face);
   setFaceCount(0);
   setFaceAttribute(face_attribute);
   setMaxFrame(max_frame);
   setX(0);
   setY(0);
   if initialize_position then setInitialPosition;
   setMaxInventory(0);
   fillChar(m_equipment,sizeof(m_equipment),#0);
   setEquipment(_weapon,item_data[0]^.data);
   fillChar(m_ability,sizeof(m_ability),#0);
   fillChar(m_internal,sizeof(m_internal),#0);
   fillChar(m_skill,sizeof(m_skill),#0);
   fillChar(m_known_magic,sizeof(m_known_magic),#0);
   modifyInternalValue;
end;

destructor person_O.done;
begin
   writeMap(MA_PERSON,returnX,returnY,0);
end;

procedure person_O.setInitialPosition;
var
   i : integer;
   x, y : integer;
begin
   if not (returnNumber in invoid_person_movement_data) then exit;
   if returnNumber <= max_person then begin
      with person_movement_data[returnNumber] do begin
         for i := 1 to number_of_movement do begin
            if movement[i].from_hour < movement[i].to_hour then begin
               if game_system.returnHour in [movement[i].from_hour..movement[i].to_hour-1] then begin
                  x := movement[i].position[movement[i].number_of_position,1];
                  y := movement[i].position[movement[i].number_of_position,2];
                  next_movement_hour := movement[i].to_hour;
                  setFaceCount(final_face[i]);
               end;
            end else begin
               if not(game_system.returnHour in [movement[i].to_hour..movement[i].from_hour-1]) then begin
                  x := movement[i].position[movement[i].number_of_position,1];
                  y := movement[i].position[movement[i].number_of_position,2];
                  next_movement_hour := movement[i].to_hour;
                  next_movement_carry := 1;
                  setFaceCount(final_face[i]);
               end;
            end;
         end;
         which_movement := 0;
      end;
   end;
   if (x = 0) and (y = 0) then begin
      setX(0);
      setY(0);
   end else begin
      warpTo(x,y);
   end;
end;

procedure person_O.setName(s : string);
begin
   m_name := s;
end;

procedure person_O.setPersonAttribute(person_attribute : magic_need_T);
begin
   m_person_attribute := person_attribute;
end;

function person_O.returnPersonAttribute : magic_need_T;
begin
   returnPersonAttribute := m_person_attribute;
end;

procedure person_O.setNumber(number : integer);
begin
   m_number := number;
end;

procedure person_O.setX(x : integer);
begin
   m_x := x;
end;

procedure person_O.setY(y : integer);
begin
   m_y := y;
end;

procedure person_O.setFace(face : integer);
begin
   m_face := face;
end;

procedure person_O.setFaceCount(face_count : integer);
begin
   m_face_count := face_count;
end;

procedure person_O.setFaceAttribute(MA : map_attribute_T);
begin
   m_face_attribute := MA;
end;

procedure person_O.setMaxFrame(max_frame : byte);
begin
   m_max_frame := max_frame;
end;

function person_O.returnName : string;
begin
   returnName := m_name;
end;

function person_O.returnNumber : integer;
begin
   returnNumber := m_number;
end;

function person_O.returnX : integer;
begin
   returnX := m_x;
end;

function person_O.returnY : integer;
begin
   returnY := m_y;
end;

function person_O.returnFace : integer;
begin
   returnFace := m_face;
end;

function person_O.returnFaceCount : integer;
begin
   returnFaceCount := m_face_count;
end;

function person_O.returnFaceAttribute : map_attribute_T;
begin
   returnFaceAttribute := m_face_attribute;
end;

function person_O.returnMaxFrame : byte;
begin
   returnMaxFrame := m_max_frame;
end;

procedure person_O.setAbility(ability : ability_T; value : integer);
begin
   m_ability[ability] := value;
end;

function person_O.returnAbility(ability : ability_T) : integer;
var
   result : integer;
   ET   : equipment_T;
   return_item : item_T;
   data : array[200..208] of byte;
begin
   for result := 200 to 208 do data[result] := 0;
   for ET := _weapon to _neck do begin
      returnEquipment(ET,return_item);
      if return_item._item_suffix in [122,200..207] then begin
         if return_item._item_suffix <> 122 then
            inc(data[return_item._item_suffix])
         else
            inc(data[208]);
      end;
   end;

   result := m_ability[ability];
   case ability of
      _strength      : if data[__SUFFIX_TITAN] > 0 then result := result + (result div 10) * data[__SUFFIX_TITAN];
      _inteligence   : if data[__SUFFIX_ATHENA] > 0 then result := result + (result div 10) * data[__SUFFIX_ATHENA];
      _concentration : if data[__SUFFIX_ARCHIMAGE] > 0 then result := result + (result div 10) * data[__SUFFIX_ARCHIMAGE];
      _endurance     : if data[__SUFFIX_HERCULES] > 0 then result := result + (result div 10) * data[__SUFFIX_HERCULES];
      _accuracy      : if data[__SUFFIX_OYDIPUS] > 0 then result := result + (result div 10) * data[__SUFFIX_OYDIPUS];
      _agility       : if data[__SUFFIX_HERMES] > 0 then result := result + (result div 10) * data[__SUFFIX_HERMES];
      _will          : if data[__SUFFIX_ATLAS] > 0 then result := result + (result div 10) * data[__SUFFIX_ATLAS];
      _priety        : if data[__SUFFIX_GODDESS] > 0 then result := result + (result div 10) * data[__SUFFIX_GODDESS];
      _luck          : if data[__SUFFIX_MEDUSA] > 0 then result := result + (result div 10) * data[__SUFFIX_MEDUSA];
{      _level         : if data[] > 0 then result := result + (result div 10) * data[];}
   end;

   returnAbility := result;
end;

procedure person_O.setInternal(internal : internal_T; value : integer);
var
   i, j : integer;
begin
   if internal <> _hostile then begin
      m_internal[internal] := value;
   end else begin
      if value <> 0 then begin
         j := -1;
         for i := 1 to MAX_HOSTILE - 1 do begin
            if m_internal[internal_T(byte(internal)+i)] = value then j := i;
         end;
         if j < 0 then begin
            if m_internal[internal] <> value then begin
               for i := MAX_HOSTILE - 1 downto 1 do
                  m_internal[internal_T(byte(internal)+i)] :=
                     m_internal[internal_T(byte(internal)+i-1)];
               m_internal[internal] := value;
            end;
         end
         else begin
            m_internal[internal_T(byte(internal)+j)] := m_internal[internal];
            m_internal[internal] := value;
         end;
      end else begin
         for i := 0 to MAX_HOSTILE - 2 do
            m_internal[internal_T(byte(internal)+i)] :=
               m_internal[internal_T(byte(internal)+i+1)];
         m_internal[internal_T(byte(internal)+MAX_HOSTILE-1)] := 0;
      end;
   end;
end;

function person_O.returnInternal(internal : internal_T) : integer;
begin
   returnInternal := m_internal[internal];
end;

procedure person_O.setSkill(skill : skill_T; value : integer);
begin
   m_skill[skill] := value;
end;

function person_O.returnSkill(skill : skill_T) : integer;
begin
   returnSkill := m_skill[skill];
end;

procedure person_O.setEquipment(equipment : equipment_T; item : item_T);
begin
   m_equipment[equipment] := item;
end;

procedure person_O.returnEquipment(equipment : equipment_T; var return_item : item_T);
begin
   return_item := m_equipment[equipment];
end;

function person_O.existEquipment(equipment : equipment_T) : boolean;
begin
   existEquipment := m_equipment[equipment]._item_number <> 0;
end;

function person_O.returnEquipmentNumber(equipment : equipment_T) : integer;
begin
   returnEquipmentNumber := m_equipment[equipment]._item_number;
end;

function person_O.returnEquipmentSuffix(equipment : equipment_T; var return_suffix, return_suffix_bonus : integer) : boolean;
begin
   if m_equipment[equipment]._item_suffix > 0 then begin
      return_suffix := m_equipment[equipment]._item_suffix;
      return_suffix_bonus := m_equipment[equipment]._item_suffix_bonus;
      returnEquipmentSuffix := TRUE;
   end else begin
      return_suffix := 0;
      return_suffix_bonus := 0;
      returnEquipmentSuffix := FALSE;
   end;
end;

procedure person_O.setInventory(inventory : integer; item : item_T);
begin
end;

procedure person_O.returnInventory(inventory : integer; var return_item : item_T);
begin
end;

function person_O.returnInventoryType(inventory : byte) : equipment_T;
begin
end;

function person_O.returnInventoryNumber(inventory : byte) : integer;
begin
end;

function person_O.returnMaxBackPack : byte;
begin
end;

function person_O.haveEnoughIt(number, suffix, contain : integer) : boolean;
var
   i : integer;
   temp_item : item_T;
   result : boolean;
begin
   result := FALSE;
   i := 0;
   while (i < returnMaxInventory) do begin
      inc(i);
      returnInventory(i,temp_item);
      if (temp_item._item_number = number) and
         (temp_item._item_suffix = suffix) then begin
         if temp_item._item_contain >= contain then begin
            result := TRUE;
            i := returnMaxBackPack +1;
         end;
      end;
   end;
   haveEnoughIt := result;
end;

function person_O.findInventory(number, suffix : integer) : integer;
var
   i : integer;
   temp_item : item_T;
   result : integer;
begin
   result := 0;
   i := 0;
   while (i < returnMaxInventory) do begin
      inc(i);
      returnInventory(i,temp_item);
      if (temp_item._item_number = number) and
         (temp_item._item_suffix = suffix) then begin
         result := i;
         i := returnMaxBackPack +1;
      end;
   end;
   findInventory := result;
end;

procedure person_O.setMaxInventory(max_inventory : byte);
begin
   m_inventory_stack_ptr := max_inventory;
end;

function person_O.returnMaxInventory : byte;
begin
   returnMaxInventory := m_inventory_stack_ptr;
end;

procedure person_O.setKnownMagic(MT : magic_type_T; number : byte);
begin
   m_known_magic[MT] := m_known_magic[MT] + [number];
end;

function person_O.haveKnownMagic(MT : magic_type_T; number : byte) : boolean;
begin
   haveKnownMagic := number in m_known_magic[MT];
end;

function person_O.returnMaxAvailHitPoint : integer;
var
   temp_long : longint;
begin
   temp_long := returnAbility(_endurance);
   temp_long := temp_long * returnAbility(_level);
   temp_long := temp_long div 100000;
   if temp_long <= 0 then temp_long := 1;
   returnMaxAvailHitPoint := temp_long;
end;

function person_O.returnMaxAvailSpellPoint : integer;
var
   temp_long : longint;
begin
   temp_long := returnAbility(_inteligence);
   temp_long := temp_long * returnAbility(_level);
   temp_long := temp_long div 1000;
   if temp_long <= 0 then temp_long := 1;
   returnMaxAvailSpellPoint := temp_long;
end;

procedure person_O.reduceHitPoint(point : integer);
var
   i : integer;
   temp_item : item_T;
begin
   if returnInternal(_death_depth) > 0 then begin
      if (returnInternal(_death_depth) + point) < 10000 then
         setInternal(_death_depth,returnInternal(_death_depth)+point)
      else
         setInternal(_death_depth,9999);
   end
   else if returnInternal(_unconscious_depth) > 0 then begin
      if (returnInternal(_unconscious_depth) + point) < returnMaxAvailHitPoint then begin
         setInternal(_unconscious_depth,returnInternal(_unconscious_depth)+point);
      end
      else begin
         if readMap(MA_OBJECT,returnX,returnY) > 0 then begin
            convertObjectToItem(__OBJECT_BLOOD,temp_item);
            setItemMap(returnX,returnY,temp_item);
         end else begin
            writeMap(MA_OBJECT,returnX,returnY,__OBJECT_BLOOD);
         end;
         setInternal(_unconscious_depth,returnMaxAvailHitPoint);
         setInternal(_death_depth,1);
      end;
   end
   else begin
      i := returnInternal(_hit_point) - point;
      setInternal(_hit_point,i);
      if i < 0 then setInternal(_unconscious_depth,1);
   end
end;

procedure person_O.setAbilityALL(param_s : longString);
var
   AT : ability_T;
   s : longString;
   i : integer;
begin
   for AT := succ(START_OF_ABILITY) to pred(END_OF_ABILITY) do begin
      pulloutWord(param_s,s,',');
      if s = '' then exit;
      toInteger(s,i);
      setAbility(AT,i);
   end;
end;

procedure person_O.setSkillALL(param_s : longString);
var
   ST : skill_T;
   s : longString;
   i : integer;
begin
   for ST := succ(START_OF_SKILL) to pred(END_OF_SKILL) do begin
      pulloutWord(param_s,s,',');
      if s = '' then exit;
      toInteger(s,i);
      setSkill(ST,i);
   end;
end;

procedure person_O.setEquipmentALL(param_s : longString);
var
   ET : equipment_T;
   s, op_code : longString;
   i : integer;
   temp_item : item_T;
begin
   for ET := succ(START_OF_EQUIPMENT) to pred(END_OF_EQUIPMENT) do begin
      pulloutWord(param_s,s,',');
      if s = '' then exit;
      seperateWord(s,s,op_code,':',#0);
      tointeger(s,i);
      if i in [0..MAX_ITEM_DATA] then begin
         temp_item := item_data[i]^.data;
         if i = 0 then fillchar(temp_item,sizeof(temp_item),#0);
         if op_code <> '' then begin
            toInteger(op_code,i);
            temp_item._item_suffix := i+100;
         end;
         setEquipment(ET,temp_item);
      end else begin
         printCompileErrorMessage(8,s+','+param_s);
      end;
   end;
end;

procedure person_O.setMagicALL(param_s : longString);
var
   MT : magic_type_T;
   s, op_code : longString;
   b : byte;
begin
   MT := mgc_none;
   while MT < mgc_environment do begin
      inc(MT);
      pulloutWord(param_s,s,':');
      seperateWord(s,s,op_code,'(',')');
      while op_code <> '' do begin
         pulloutWord(op_code,s,',');
         if s = '' then exit;
         toByte(s,b);
         setKnownMagic(MT,b);
      end;
   end;
end;

procedure person_O.setItemALL(param_s : longString);
var
   i, j : integer;
   s, op_code : longString;
   temp_item : item_T;
begin
   while param_s <> '' do begin
      pulloutWord(param_s,s,',');
      seperateWord(s,s,op_code,'-',#0);
      if op_code <> '' then toInteger(op_code,j)  { j <- number of }
      else j := 1;
      seperateWord(s,s,op_code,':',#0);
      toInteger(s,i);
      temp_item := item_data[i]^.data;
      if i <> __ITEM_CRYSTAL then begin
         if op_code <> '' then begin
            toInteger(op_code,i);    { i <- suffix }
            temp_item._item_suffix := i;
            temp_item._item_suffix_bonus := 1;
         end;
         temp_item._item_contain := j;
      end else begin
         if op_code <> '' then begin
            toInteger(op_code,i);    { i <- magic type }
            temp_item._item_magic_type := magic_type_T(i);
            temp_item._item_magic := j;  { j <- magic number }
         end;
      end;
      getSomething(temp_item);
   end;
end;

procedure person_O.addAbilityALL(param_s : longString);
var
   AT : ability_T;
   s : longString;
   i : integer;
begin
   for AT := succ(START_OF_ABILITY) to pred(END_OF_ABILITY) do begin
      pulloutWord(param_s,s,',');
      if s = '' then exit;
      toInteger(s,i);
      setAbility(AT,returnAbility(AT)+i);
   end;
   modifyInternalValue;
end;

procedure person_O.addSkillALL(param_s : longString);
var
   ST : skill_T;
   s : longString;
   i : integer;
begin
   for ST := succ(START_OF_SKILL) to pred(END_OF_SKILL) do begin
      pulloutWord(param_s,s,',');
      if s = '' then exit;
      toInteger(s,i);
      setSkill(ST,returnSkill(ST)+i);
   end;
   modifyInternalValue;
end;

procedure person_O.addEquipmentALL(param_s : longString);
var
   ET : equipment_T;
   s, op_code : longString;
   i : integer;
   temp_item : item_T;
begin
   for ET := succ(START_OF_EQUIPMENT) to pred(END_OF_EQUIPMENT) do begin
      pulloutWord(param_s,s,',');
      seperateWord(s,s,op_code,':',#0);
      if s = '' then exit;
      tointeger(s,i);
      if i > 0 then begin
         if i in [1..MAX_ITEM_DATA] then begin
            temp_item := item_data[i]^.data;
            if i = 0 then fillchar(temp_item,sizeof(temp_item),#0);
            if op_code <> '' then begin
               toInteger(op_code,i);
               temp_item._item_suffix := i+100;
            end;
            setEquipment(ET,temp_item);
         end else begin
            printCompileErrorMessage(8,s+','+param_s);
         end;
      end;
   end;
end;

procedure person_O.addMagicALL(param_s : longString);
begin
   setMagicALL(param_S);
end;

procedure person_O.addItemALL(param_s : longString);
begin
   setItemALL(param_s);
end;


function person_O.isActiveCondition : boolean;
begin
   isActiveCondition := (returnInternal(_hit_point) >= 0) and
                        (returnInternal(_unconscious_depth) = 0) and
                        (returnInternal(_death_depth) = 0) and
                        (returnInternal(_paralisis_depth) = 0) and
                        (returnInternal(_stonization_depth) = 0);
end;

function person_O.returnSpriteNumber(var MA : map_attribute_T) : byte;
begin
   MA := returnFaceAttribute;
   if returnMaxFrame = 8 then
      returnSpriteNumber := (returnFace-1) * 9 + returnFaceCount
   else if returnMaxFrame = 4 then
      returnSpriteNumber := returnFace + returnFaceCount shr 1
   else if returnMaxFrame = 2 then
      returnSpriteNumber := returnFace + returnFaceCount and $01
   else returnSpriteNumber := returnFace;
end;

procedure person_O.doWalking;
const
   RECOVER_MAX_VALUE = 8000;
var
   IT : internal_T;
   i, j : integer;
   s : string;
   temp_real : real;
begin
   setFaceCount(returnFaceCount xor $01);
   if returnInternal(_poison_depth) > 0 then begin
      i := returnInternal(_poison_depth) div 10;
      if i > 0 then reduceHitPoint(i);
   end else begin
      if returnInternal(_hit_point) < returnMaxAvailHitPoint then begin
         temp_real := returnAbility(_agility);
         temp_real := temp_real * returnAbility(_level);
         temp_real := temp_real / 10000;
         temp_real := temp_real + returnInternal(_hit_point_recovering_templet);
         i := 0;
         while temp_real > RECOVER_MAX_VALUE do begin
            inc(i);
            temp_real := temp_real - RECOVER_MAX_VALUE;
         end;
         setInternal(_hit_point_recovering_templet,round(temp_real));
         if i > 0 then begin
            if returnInternal(_unconscious_depth) > 0 then begin
               j := returnInternal(_hit_point);
               while j < 0 do begin
                  inc(j); dec(i);
               end;
               setInternal(_hit_point,j);
               if i > 0 then begin
                  j := returnInternal(_unconscious_depth) - i;
                  if j < 0 then j := 0;
                  setInternal(_unconscious_depth,j);
               end;
            end else begin
               j := returnInternal(_hit_point) + i;
               if j > returnMaxAvailHitPoint then j := returnMaxAvailHitPoint;
               setInternal(_hit_point,j);
            end;
         end;
      end;
      if returnInternal(_spell_point) < returnMaxAvailSpellPoint then begin
         temp_real := returnAbility(_will);
         temp_real := temp_real * returnAbility(_level);
         temp_real := temp_real / 100;
         temp_real := temp_real + returnInternal(_spell_point_recovering_templet);
         i := 0;
         while temp_real > RECOVER_MAX_VALUE do begin
            inc(i);
            temp_real := temp_real - RECOVER_MAX_VALUE;
         end;
         setInternal(_spell_point_recovering_templet,round(temp_real));
         if i > 0 then begin
            j := returnInternal(_spell_point) + i;
            if j > returnMaxAvailSpellPoint then j := returnMaxAvailSpellPoint;
            setInternal(_spell_point,j);
         end;
      end;
   end;
   for IT := _sleep_depth to _stonization_depth do begin
      if returnInternal(IT) > 0 then begin
         i := returnInternal(IT);
         temp_real := returnAbility(_will);
         temp_real := temp_real * returnAbility(_level);
         temp_real := temp_real / 250000;
         i := i - round(temp_real);
         if i <= 0 then begin
            i := 0;
            registerMessage(returnNumber,'',0.1);
         end;
         setInternal(IT,i);
      end;
   end;

         if readMap(MA_FIELD,returnX,returnY) > 0 then begin
            case readMap(MA_FIELD,returnX,returnY) of
             __FIELD_FIRE   : begin
                  if returnSkill(_fire_treating) > 0 then
                     i := 100 div returnSkill(_fire_treating)
                  else
                     i := 100;
                  reduceHitPoint(i);
                  registerMessage(returnNumber,'u a..',DEFAULT_DELAY);
                  if random(100) < returnSkill(_water_treating) then begin
                     writeMap(MA_FIELD,returnX,returnY,0);
                  end;
               end;
             __FIELD_VACUUM : begin
                  if returnInternal(_breath_remain_count) > 0 then begin
                     i := returnInternal(_breath_remain_count)-1;
                     setInternal(_breath_remain_count,i);
                     str(i,s);
                     registerMessage(returnNumber,s+'    a..',DEFAULT_DELAY);
                  end
                  else if returnEquipmentNumber(_helmet) = __ITEM_OXYGEN_MASK then begin
                  end else begin
                     reduceHitPoint(100);
                     registerMessage(returnNumber,'ab, ba..',DEFAULT_DELAY);
                  end;
               end;
             __FIELD_POISON : begin
                  if returnInternal(_antodote_body) > 0 then begin
                     i := returnInternal(_antodote_body)-100;
                     if i < 0 then i := 0;
                     setInternal(_antodote_body,i);
                     if i > 0 then begin
                        i := (i-1) div 100 + 1;
                        str(i,s);
                        registerMessage(returnNumber,'Ёb '+s+' qva..',DEFAULT_DELAY);
                     end else begin
                        registerMessage(returnNumber,'Ёb  aava !',DEFAULT_DELAY);
                     end;
                  end else begin
                     i := returnInternal(_poison_depth);
                     i := i + 100;
                     if i > 10000 then i := 10000;
                     setInternal(_poison_depth,i);
                     registerMessage(returnNumber,', a..',DEFAULT_DELAY);
                  end;
               end;
             __FIELD_SLEEP  : begin
                  i := returnInternal(_sleep_depth);
                  i := i + 100;
                  if i > 10000 then i := 10000;
                  setInternal(_sleep_depth,i);
                  registerMessage(returnNumber,'aq~~ qa..',DEFAULT_DELAY);
               end;
             __FIELD_ELETRIC: begin
                  if returnSkill(_light_treating) > 0 then
                     i := 10000 div returnSkill(_light_treating)
                  else
                     i := 10000;
                  reduceHitPoint(i);
                  registerMessage(returnNumber,',  ..',DEFAULT_DELAY);
               end;
             __FIELD_ENERGY : begin
                  if returnSkill(_light_treating) > 0 then
                     i := 1000 div returnSkill(_light_treating)
                  else
                     i := 1000;
                  reduceHitPoint(i);
                  registerMessage(returnNumber,'aab.. ',DEFAULT_DELAY);
               end;
            end;
         end;

end;

procedure person_O.moveTo(x1, y1 : integer);
begin
   writeMap(MA_PERSON,returnX,returnY,0);
   setX(returnX + x1);
   setY(returnY + y1);
   writeMap(MA_PERSON,returnX,returnY,returnNumber);
   doWalking;
end;

procedure person_O.warpTo(x, y : integer);
var
   temp_person : byte;
   x1, y1 : shortint;
begin
   if (returnX <> 0) or (returnY <> 0) then
      writeMap(MA_PERSON,returnX,returnY,0);
   if (readMap(MA_PERSON,x,y) > 0) and
      (readMap(MA_PERSON,x,y) <> returnNumber) then begin
      temp_person := readMap(MA_PERSON,x,y);
      x1 := 0;
      y1 := 0;
      if isMovableMap(x,y-1) then y1 := -1
      else if isMovableMap(x+1,y) then x1 := 1
      else if isMovableMap(x-1,y+1) then x1 := -1
      else if isMovableMap(x,y+1) then y1 := 1;
      if (x1 <> 0) or (y1 <> 0) then begin
         if temp_person in [1..MAX_PERSON_ARRAY] then begin
            if person[temp_person] <> nil then begin
               with person[temp_person]^ do
                  warpTo(returnX+x1,returnY+y1);
            end;
         end;
      end;
   end;
   setX(x);
   setY(y);
   writeMap(MA_PERSON,returnX,returnY,returnNumber);
   doWalking;
end;

procedure person_O.turnFace(x1, y1 : integer);
begin
   if (x1 <> 0) or (y1 <> 0) then begin
      if abs(x1) > abs(y1) then begin
         if x1 > 0 then setFaceCount(4)
                   else setFaceCount(2);
      end else begin
         if y1 > 0 then setFaceCount(0)
                   else setFaceCount(6);
      end;
   end;
end;

function compareItem(var item1, item2 : item_T) : boolean;
var
   i, number_of_difference : integer;
   item1_ptr, item2_ptr : ^byte;
begin
   number_of_difference := 0;
   item1_ptr := @item1;
   item2_ptr := @item2;
   for i := 0 to sizeof(item1)-3 do begin
      if byte(item1_ptr^) <> byte(item2_ptr^) then inc(number_of_difference);
      inc(item1_ptr);
      inc(item2_ptr);
   end;
   compareItem := (number_of_difference = 0);
end;

function person_O.getSomething(identical_item : item_T) : boolean;
var
   i : integer;
   temp_item : item_T;
begin
   if identical_item._item_contain <= 0 then exit;
   for i := 1 to returnMaxInventory do begin
      if returnInventoryNumber(i) = identical_item._item_number then begin
         returnInventory(i,temp_item);
         if compareItem(identical_item,temp_item) = TRUE then begin
            temp_item._item_contain :=
               temp_item._item_contain + identical_item._item_contain;
            setInventory(i,temp_item);
            getSomething := TRUE;
            exit;
         end;
      end;
   end;
   if returnMaxInventory < returnMaxBackPack then begin
      setMaxInventory(returnMaxInventory+1);
      setInventory(returnMaxInventory,identical_item);
      getSomething := TRUE;
   end else begin
      getSomething := FALSE;
   end;
end;

function person_O.dropSomething(stack_ptr : byte;var return_item : item_T) : boolean;
var
   i : byte;
   temp_item : item_T;
begin
   if stack_ptr in [1..returnMaxInventory] then begin
      returnInventory(stack_ptr,return_item);
      for i := stack_ptr to returnMaxInventory-1 do begin
         returnInventory(i+1,temp_item);
         setInventory(i,temp_item);
      end;
      setMaxInventory(returnMaxInventory-1);
      dropSomething := TRUE;
   end else begin
      convertObjectToItem(0,return_item);
      dropSomething := FALSE;
   end;
end;

function person_O.dropSomethingEA(number, suffix, contain : integer; var return_item : item_T) : boolean;
var
   i : integer;
   temp_item : item_T;
begin
   i := 0;
   while (i < returnMaxInventory) do begin
      inc(i);
      returnInventory(i,temp_item);
      if (temp_item._item_number = number) and
         (temp_item._item_suffix = suffix) then begin
         dropSomething(i,temp_item);
         if temp_item._item_contain >= contain then begin
            temp_item._item_contain := temp_item._item_contain - contain;
            getSomething(temp_item);
            temp_item._item_contain := contain;
            dropSomethingEA := TRUE;
         end else begin
            dropSomethingEA := FALSE;
         end;
         return_item := temp_item;
         exit;
      end;
   end;
   dropSomethingEA := FALSE;
end;

procedure person_O.detectPersonAxes(var x,y : integer);
var
   i,j : integer;
begin
   x := (SCROLL_X_GAP + SCROLL_X_WIDE * TILE_X_SIZE) * 8 + 12;
   y := SCROLL_Y_GAP + SCROLL_Y_WIDE * TILE_Y_SIZE;
   i := (returnX - _MAP_X_CENTER) * TILE_Y_SIZE;
   j := (returnY - _MAP_Y_CENTER) * TILE_Y_SIZE;
   x := x + i;
   y := y + j;
end;

procedure person_O.talkSentence(s : string);
var
   x, y : integer;
begin
   if isActiveCondition then begin
      detectPersonAxes(x,y);
      x := x - (length(s) * 4);
      y := y - 2 * TILE_Y_SIZE;
      setHanType(MYUNGJO);
      printTalkHangul(x div 8,y div 16,s,0);
      setHanType(SAMMUL);
   end;
end;

procedure person_O.modifySelectionCenter(var origin_x, origin_y : integer);
begin
   if returnX < SCROLL_X_WIDE then origin_x := returnX - SCROLL_X_WIDE;
   if returnX > (game_system.returnMapXMax-1) - SCROLL_X_WIDE then
      origin_x := returnX - ((game_system.returnMapXMax-1) - SCROLL_X_WIDE);
   if returnY < SCROLL_Y_WIDE then origin_y := returnY - SCROLL_Y_WIDE;
   if returnY > (game_system.returnMapYMax-1) - SCROLL_Y_WIDE then
      origin_y := returnY - ((game_system.returnMapYMax-1) - SCROLL_Y_WIDE);
end;

function person_O.returnAvailableMagicRange : integer;
begin
   returnAvailableMagicRange := returnAbility(_concentration) div 1000;
end;

function person_O.detectAvailableAttackRange(var x_range, y_range : integer) : attack_type_T;
var
   AT : attack_type_T;
begin
   if m_equipment[_weapon]._item_throw_range > 0 then begin
      x_range := m_equipment[_weapon]._item_throw_range;
      y_range := m_equipment[_weapon]._item_throw_range;
      AT := _shoot;
   end else begin
      x_range := m_equipment[_weapon]._item_attack_range;
      y_range := m_equipment[_weapon]._item_attack_range;
      AT := _normal_attack;
   end;
   if abs(x_range) >= SCROLL_X_WIDE then begin
      if x_range > 0 then x_range := SCROLL_X_WIDE
                     else x_range := - SCROLL_X_WIDE;
   end;
   if abs(y_range) >= SCROLL_Y_WIDE then begin
      if y_range > 0 then y_range := SCROLL_Y_WIDE
                     else y_range := - SCROLL_Y_WIDE;
   end;
   if x_range = 0 then x_range := 1;
   if y_range = 0 then y_range := 1;

   detectAvailableAttackRange := AT;
end;

function person_O.attackSomething : boolean;
var
   origin_x, origin_y, get_x, get_y, temp_x, temp_y : integer;
   i, result : integer;
   weapon_cursor, person_number: byte;
   attack_params, result_params : attack_parameters_T;
   AT : attack_type_T;
   weapon_item, temp_item : item_T;
   x_range, y_range : integer;
   remember_weapon_number : integer;
   movie : ^movie_O;
   temp_real : real;
begin
   attackSomething := TRUE;
   result := 0;

   origin_x := 0;
   origin_y := 0;
   modifySelectionCenter(origin_x,origin_y);
   get_x := origin_x;
   get_y := origin_y;

   AT := detectAvailableAttackRange(x_range,y_range);

   returnEquipment(_weapon,weapon_item);
   remember_weapon_number := weapon_item._item_number;
   if weapon_item._item_shape > 0 then weapon_cursor := weapon_item._item_shape
                                  else weapon_cursor := NORMAL_CURSOR;
   if weapon_cursor > ADDRESS_OF_WEAPON_IN_OBJECT_TILE then begin
      i := weapon_cursor - ADDRESS_OF_WEAPON_IN_OBJECT_TILE;
      if i in [__ITEM_ARROW,__ITEM_BOLT] then begin
         if not haveEnoughIt(i,0,1) then begin
            registerMessage(returnNumber,'i a !',2.0);
            exit;
         end;
      end;
   end;
   if returnNumber = _MAIN_CHARACTER then begin
      temp_x := 0; temp_y := 0;
      person_number := returnInternal(_hostile);
      if person[person_number] <> nil then begin
         if (abs(person[person_number]^.returnX - returnX) <= x_range) and
            (abs(person[person_number]^.returnY - returnY) <= y_range) then begin
            temp_x := person[person_number]^.returnX - returnX;
            temp_y := person[person_number]^.returnY - returnY
         end;
      end;
      if remember_weapon_number <> 0 then
         selectObject(get_x,get_y,x_range,y_range,temp_x,temp_y,weapon_cursor)
      else
         selectObject(get_x,get_y,1,1,0,0,weapon_cursor);
      get_x := get_x - origin_x;
      get_y := get_y - origin_y;
   end
   else begin (* Enemy Attack *)
      if (abs(returnX-person[returnInternal(_hostile)]^.returnX) <= x_range) and
               (abs(returnY-person[returnInternal(_hostile)]^.returnY) <= y_range) then begin
         get_x := person[returnInternal(_hostile)]^.returnX - returnX;
         get_y := person[returnInternal(_hostile)]^.returnY - returnY;
      end;
   end;
   if weapon_item._item_throw_range > 0 then begin
      if (abs(get_x) <= weapon_item._item_attack_range) and
         (abs(get_y) <= weapon_item._item_attack_range) then begin
         AT := _normal_attack;
      end;
   end;
   if (get_x <> 0) or (get_y <> 0) then begin
      with attack_params do begin
         attack_type := AT;
         attack_attribute := _physical;
         shape := weapon_cursor;
         shape_revolution := weapon_item._item_shape_revolution;
         if weapon_item._item_trailing_count > 0 then
            trailing_count := weapon_item._item_trailing_count
         else
            trailing_count := 1;
         case weapon_item._item_weapon_type of
            _fist, _fist4MU, _etc : power := returnSkill(_fist_skill);
            _sword : power := returnSkill(_sword_skill);
            _axe   : power := returnSkill(_axe_skill);
            _spear : power := returnSkill(_spear_skill);
            _throw : power := returnSkill(_throw_skill);
            _bow   : power := returnSkill(_bow_skill);
         end;
         if AT in [_shoot,_pierce,_spread] then
            power := power * weapon_item._item_throw_power
         else
            power := power * weapon_item._item_attack_power;
         temp_real := power;
         temp_real := temp_real * returnAbility(_level);
         temp_real := temp_real * returnAbility(_strength);
         temp_real := temp_real / 100000000;
         temp_real := temp_real * (100-weapon_item._item_maintain_level) / 100;
         power := round(temp_real);
         speed := 10;
         x_original := returnX;
         y_original := returnY;
         x_source := x_original;
         y_source := y_original;
         x_destination := returnX + get_x;
         y_destination := returnY + get_y;
      end;

      if (returnNumber <> _MAIN_CHARACTER) or (AT = _normal_attack) then begin
         with attack_params do begin
            detectObstacle(attack_attribute,x_source,y_source,x_destination,y_destination,temp_x,temp_y);
            if (x_destination <> temp_x) or (y_destination <> temp_y) then exit;
         end;
      end;
      if AT = _normal_attack then begin
         i := readMap(MA_PERSON,attack_params.x_destination,attack_params.y_destination);
         if i > 0 then begin
            scrollMap;
            flipPage;
            new(movie,init);
            person[i]^.detectPersonAxes(temp_x,temp_y);
            temp_x := temp_x - 12;
            temp_y := temp_y - 10;
            movie^.setMovie(MA_FIELD,ADDRESS_OF_WEAPON_IN_OBJECT_TILE*2+16,temp_x,temp_y,1,0);
            movie^.setMovie(MA_FIELD,ADDRESS_OF_WEAPON_IN_OBJECT_TILE*2+17,temp_x,temp_y,1,0);
            movie^.setMovie(MA_FIELD,ADDRESS_OF_WEAPON_IN_OBJECT_TILE*2+18,temp_x,temp_y,1,0);
            movie^.playMovie(3);
            dispose(movie,done);
         end else begin
            i := 0;
         end;

      end
      else if AT = _shoot then begin
         scrollMap;
         flipPage;
         case weapon_item._item_weapon_type of
            _fist, _fist4MU, _sword, _axe, _spear, _throw, _etc :
            if not (weapon_item._item_number in [__ITEM_BOOMERANG]) then begin
               i := 0;
               while (i < returnMaxInventory) do begin
                  inc(i);
                  returnInventory(i,temp_item);
                  if (temp_item._item_type = weapon_item._item_type) and
                     (temp_item._item_number = weapon_item._item_number) then begin
                     dropSomething(i,temp_item);
                     temp_item._item_contain := temp_item._item_contain - 1;
                     if temp_item._item_contain > 0 then begin
                        getSomething(temp_item);
                     end;
                     i := returnMaxBackPack +1;
                  end;
               end;
               if i <= returnMaxBackPack then begin
                  setEquipment(_weapon,item_data[0]^.data);
               end;
            end;
            _bow :
            begin
               i := weapon_cursor - ADDRESS_OF_WEAPON_IN_OBJECT_TILE;
               if haveEnoughIt(i,0,1) then
                  dropSomethingEA(i,0,1,temp_item);
            end;
         end;
      end;
      result := attackObject(attack_params,result_params);
      case remember_weapon_number of
         __ITEM_BOOMERANG :
         begin
            attack_params := result_params;
            with attack_params do begin
               x_source := x_destination;
               y_source := y_destination;
               x_destination := x_original;
               y_destination := y_original;
               power := 0;
            end;
            attackObject(attack_params,result_params);
         end;
         __ITEM_FLAME_BOME :
            writeMap(MA_FIELD,attack_params.x_destination,attack_params.y_destination,1);
      end;
   end
   else attackSomething := FALSE;

   if (returnNumber = _MAIN_CHARACTER) then
   if result = 1 then begin { Attack successfully }
      (* Skill Incresement *)
      if random(100) = 0 then
      if random(100) < (returnAbility(_inteligence) div 30) then begin
         case weapon_item._item_weapon_type of
            _fist, _fist4MU, _etc :
            if returnSkill(_fist_skill) < 100 then
               setSkill(_fist_skill,succ(returnSkill(_fist_skill)));
            _sword :
            if returnSkill(_sword_skill) < 100 then
               setSkill(_sword_skill,succ(returnSkill(_sword_skill)));
            _axe   :
            if returnSkill(_axe_skill) < 100 then
               setSkill(_axe_skill,succ(returnSkill(_axe_skill)));
            _spear :
            if returnSkill(_spear_skill) < 100 then
               setSkill(_spear_skill,succ(returnSkill(_spear_skill)));
            _throw :
            if returnSkill(_throw_skill) < 100 then
               setSkill(_throw_skill,succ(returnSkill(_throw_skill)));
            _bow   :
            if returnSkill(_bow_skill) < 100 then
               setSkill(_bow_skill,succ(returnSkill(_bow_skill)));
         end;
      end;

      (* Weapon Maintain *)
      if (weapon_item._item_weapon_type <> _fist) or (weapon_item._item_number <> 0) then begin
         if random(20) = 0 then
         if random(100) > (returnAbility(_luck)) then begin
            returnEquipment(_weapon,weapon_item);
            if weapon_item._item_maintain_level < 100 then begin
               inc(weapon_item._item_maintain_level);
               setEquipment(_weapon,weapon_item);
            end;
         end;
      end;

      (* Exp. Incresement *)
      i := returnInternal(_potential_experience)+100;
      if i >= returnAbility(_level) then begin
         dec(i,returnAbility(_level));
         setInternal(_experience,succ(returnInternal(_experience)));
         setAbility(_level,succ(returnAbility(_level)));
      end;
      setInternal(_potential_experience,i);
   end;
end;

function person_O.carryOutAttackMagic(selected_magic : integer; need_to_consume_SP : boolean) : boolean;
label
   SPREAD_ROUTINE;
const
   MT : magic_type_T = mgc_attack;
var
   i,j,k : integer;
   magic_cursor : integer;
   origin_x, origin_y, get_x, get_y : integer;
   magic_params, result_params : attack_parameters_T;
   range, aux_x, aux_y : integer;
   variable_axis, variable_range, variable_fixed : ^integer;
   variable_range_sign : shortint;
   temp_real : real;
begin
   carryOutAttackMagic := FALSE;

   if need_to_consume_SP then begin
      if magic_data[MT,selected_magic]^.data._magic_MP_consumtion >
         returnInternal(_spell_point) then begin
         if magic_data[MT,selected_magic]^.data._magic_MP_consumtion >
          returnMaxAvailSpellPoint then
            registerMessage(returnNumber,' a wb c...',DEFAULT_DELAY)
         else
            registerMessage(returnNumber,'b! abi ᢁ Жa...',DEFAULT_DELAY);
         exit;
      end;
   end;

   with magic_data[MT,selected_magic]^.data do begin

         case _magic_destination of
            mgc_one :
            begin
               if _magic_method = _spread then goto SPREAD_ROUTINE;

               if returnNumber = _MAIN_CHARACTER then begin
                  origin_x := 0;
                  origin_y := 0;
                  modifySelectionCenter(origin_x,origin_y);
                  get_x := origin_x;
                  get_y := origin_y;
                  magic_cursor := _magic_shape;
                  selectObject(get_x,get_y,_magic_attack_range,_magic_attack_range,0,0,magic_cursor);
                  get_x := get_x - origin_x;
                  get_y := get_y - origin_y;
               end else begin
                  magic_cursor := _magic_shape;
                  get_x := person[returnInternal(_hostile)]^.returnX - returnX;
                  get_y := person[returnInternal(_hostile)]^.returnY - returnY;
               end;

               if (get_x <> 0) or (get_y <> 0) then begin
                  magic_params.attack_type := _magic_method;
                  magic_params.attack_attribute := _magic_attribute;
                  magic_params.shape := magic_cursor;
                  magic_params.shape_revolution := _magic_shape_revolution;
                  magic_params.trailing_count := _magic_trailing_count;
                  case _magic_attribute of
                     _physical : temp_real := returnSkill(_fist_skill);
                     _magical : temp_real := returnSkill(_magic_skill);
                     _fiery : temp_real := returnSkill(_fire_treating);
                     _watery : temp_real := returnSkill(_water_treating);
                     _airy : temp_real := returnSkill(_air_treating);
                     _earthy : temp_real := returnSkill(_earth_treating);
                     _electrical : temp_real := returnSkill(_light_treating);
                     _poisonous : temp_real := returnSkill(_cure_skill)
                     else temp_real := 0;
                  end;
                  temp_real := temp_real * returnAbility(_level) / 1000;
                  temp_real := temp_real * _magic_attack_power / 100;
                  temp_real := temp_real / MAGIC_DIVISION_RATE;
                  magic_params.power := round(temp_real);
                  magic_params.speed := 10;
                  magic_params.x_original := returnX;
                  magic_params.y_original := returnY;
                  magic_params.x_source := magic_params.x_original;
                  magic_params.y_source := magic_params.y_original;
                  magic_params.x_destination := returnX + get_x;
                  magic_params.y_destination := returnY + get_y;
                  attackObject(magic_params,result_params);
               end;
            end;
            mgc_all :
            case _magic_method of
               _shoot :
               begin
                  magic_params.attack_type := _magic_method;
                  magic_params.attack_attribute := _magic_attribute;
                  magic_params.shape := _magic_shape;
                  magic_params.shape_revolution := _magic_shape_revolution;
                  magic_params.trailing_count := _magic_trailing_count;
                  case _magic_attribute of
                     _physical : temp_real := returnSkill(_fist_skill);
                     _magical : temp_real := returnSkill(_magic_skill);
                     _fiery : temp_real := returnSkill(_fire_treating);
                     _watery : temp_real := returnSkill(_water_treating);
                     _airy : temp_real := returnSkill(_air_treating);
                     _earthy : temp_real := returnSkill(_earth_treating);
                     _electrical : temp_real := returnSkill(_light_treating);
                     _poisonous : temp_real := returnSkill(_cure_skill)
                     else temp_real := 0;
                  end;
                  temp_real := temp_real * returnAbility(_level) / 1000;
                  temp_real := temp_real * _magic_attack_power / 100;
                  temp_real := temp_real / MAGIC_DIVISION_RATE;
                  magic_params.power := round(temp_real);
                  magic_params.speed := 10;
                  magic_params.x_original := returnX;
                  magic_params.y_original := returnY;
                  magic_params.x_source := magic_params.x_original;
                  magic_params.y_source := magic_params.y_original;
                  for j := - _magic_attack_range to _magic_attack_range do
                   for i := - _magic_attack_range to _magic_attack_range do begin
                     k := readMap(MA_PERSON,returnX+i,returnY+j);
                     if (k > 0) and (k <> _MAIN_CHARACTER) then begin
                        magic_params.x_destination := person[k]^.returnX;
                        magic_params.y_destination := person[k]^.returnY;
                        attackObject(magic_params,result_params);
                     end;
                  end;
               end;
               _pierce :
               begin
SPREAD_ROUTINE:
                  if _magic_method = _spread then
                     magic_params.attack_type := _shoot
                  else
                     magic_params.attack_type := _pierce;
                  magic_params.attack_attribute := _magic_attribute;
                  magic_params.shape := _magic_shape;;
                  magic_params.shape_revolution := _magic_shape_revolution;
                  magic_params.trailing_count := _magic_trailing_count;
                  case _magic_attribute of
                     _physical : temp_real := returnSkill(_fist_skill);
                     _magical : temp_real := returnSkill(_magic_skill);
                     _fiery : temp_real := returnSkill(_fire_treating);
                     _watery : temp_real := returnSkill(_water_treating);
                     _airy : temp_real := returnSkill(_air_treating);
                     _earthy : temp_real := returnSkill(_earth_treating);
                     _electrical : temp_real := returnSkill(_light_treating);
                     _poisonous : temp_real := returnSkill(_cure_skill)
                     else temp_real := 0;
                  end;
                  temp_real := temp_real * returnAbility(_level) / 1000;
                  temp_real := temp_real * _magic_attack_power / 100;
                  temp_real := temp_real / MAGIC_DIVISION_RATE;
                  magic_params.power := round(temp_real);
                  magic_params.speed := 10;
                  magic_params.x_original := returnX;
                  magic_params.y_original := returnY;
                  magic_params.x_source := magic_params.x_original;
                  magic_params.y_source := magic_params.y_original;
                  get_x := 0; get_y := 0;
                  case returnFaceCount shr 1 of
                     0 : get_y := _magic_attack_range;
                     1 : get_x := -_magic_attack_range;
                     2 : get_x := _magic_attack_range;
                     3 : get_y := -_magic_attack_range;
                  end;
                  magic_params.x_destination := returnX + get_x;
                  magic_params.y_destination := returnY + get_y;

                  if get_y = 0 then begin
                     aux_x := get_x;
                     range := abs(get_x);
                     variable_axis := @aux_y;
                     variable_range := @aux_x;
                     variable_fixed := @get_x;
                  end
                  else begin
                     aux_y := get_y;
                     range := abs(get_y);
                     variable_axis := @aux_x;
                     variable_range := @aux_y;
                     variable_fixed := @get_y;
                  end;
                  if variable_range^ > 0 then
                     variable_range_sign := 1
                  else
                     variable_range_sign := -1;

                  variable_axis^ := -range;
                  while variable_axis^ <= range do begin
                     variable_range^ := variable_fixed^
                                        - variable_range_sign * return_circle_data[abs(variable_axis^)];
                     magic_params.x_destination := magic_params.x_source+aux_x;
                     magic_params.y_destination := magic_params.y_source+aux_y;
                     attackObject(magic_params,result_params);
                     inc(variable_axis^);
                  end;
               end;
               _spread :
               begin
                  magic_params.attack_type := _magic_method;
                  magic_params.attack_attribute := _magic_attribute;
                  magic_params.shape := _magic_shape;
                  magic_params.shape_revolution := _magic_shape_revolution;
                  magic_params.trailing_count := _magic_trailing_count;
                  case _magic_attribute of
                     _physical : temp_real := returnSkill(_fist_skill);
                     _magical : temp_real := returnSkill(_magic_skill);
                     _fiery : temp_real := returnSkill(_fire_treating);
                     _watery : temp_real := returnSkill(_water_treating);
                     _airy : temp_real := returnSkill(_air_treating);
                     _earthy : temp_real := returnSkill(_earth_treating);
                     _electrical : temp_real := returnSkill(_light_treating);
                     _poisonous : temp_real := returnSkill(_cure_skill)
                     else temp_real := 0;
                  end;
                  temp_real := temp_real * returnAbility(_level) / 1000;
                  temp_real := temp_real * _magic_attack_power / 100;
                  temp_real := temp_real / MAGIC_DIVISION_RATE;
                  magic_params.power := round(temp_real);
                  magic_params.speed := 10;
                  magic_params.x_original := returnX;
                  magic_params.y_original := returnY;
                  magic_params.x_source := magic_params.x_original;
                  magic_params.y_source := magic_params.y_original;
                  get_x := 0; get_y := 0;
                  case returnFaceCount shr 1 of
                     0 : get_y := _magic_attack_range;
                     1 : get_x := -_magic_attack_range;
                     2 : get_x := _magic_attack_range;
                     3 : get_y := -_magic_attack_range;
                  end;
                  magic_params.x_destination := get_x;
                  magic_params.y_destination := get_y;
                  attackObject(magic_params,result_params);
               end;
            end;
         end;
   end;

   if need_to_consume_SP then begin
      setInternal(_spell_point,returnInternal(_spell_point)-magic_data[MT,selected_magic]^.data._magic_MP_consumtion);
   end;

   carryOutAttackMagic := TRUE;
end;

function person_O.carryOutDefenseMagic(selected_magic : integer; need_to_consume_SP : boolean) : boolean;
const
   MT : magic_type_T = mgc_defense;
begin
   carryOutDefenseMagic := FALSE;

   if need_to_consume_SP then begin
      if magic_data[MT,selected_magic]^.data._magic_MP_consumtion >
         returnInternal(_spell_point) then begin
         if magic_data[MT,selected_magic]^.data._magic_MP_consumtion >
          returnMaxAvailSpellPoint then
            registerMessage(returnNumber,' a wb c...',DEFAULT_DELAY)
         else
            registerMessage(returnNumber,'b! abi ᢁ Жa...',DEFAULT_DELAY);
         exit;
      end;
   end;

   with magic_data[MT,selected_magic]^.data do begin
   end;

   if need_to_consume_SP then begin
      setInternal(_spell_point,returnInternal(_spell_point)-magic_data[MT,selected_magic]^.data._magic_MP_consumtion);
   end;

   carryOutDefenseMagic := TRUE;
end;

function person_O.carryOutCureMagic(selected_magic : integer; need_to_consume_SP : boolean) : boolean;
const
   MT : magic_type_T = mgc_cure;
var
   origin_x, origin_y, get_x, get_y, range : integer;
   i, j, selected_person, restore_HP: integer;
   get_skill, get_level, get_effect : longint;
   temp_magic_need_set, get_magic_need_set : magic_need_SET;
   detect_successfully : boolean;
   temp_s : string;

begin
   carryOutCureMagic := FALSE;

   if need_to_consume_SP then begin
      if magic_data[MT,selected_magic]^.data._magic_MP_consumtion >
         returnInternal(_spell_point) then begin
         if magic_data[MT,selected_magic]^.data._magic_MP_consumtion >
          returnMaxAvailSpellPoint then
            registerMessage(returnNumber,' a wb c...',DEFAULT_DELAY)
         else
            registerMessage(returnNumber,'b! abi ᢁ Жa...',DEFAULT_DELAY);
         exit;
      end;
   end;

   with magic_data[MT,selected_magic]^.data do begin
      case _magic_destination of
         mgc_one : range := returnAvailableMagicRange
         else range := 0;
      end;
      if range > 0 then begin
         if need_to_consume_SP and (_magic_need_set <> []) then begin
            temp_magic_need_set := _magic_need_set *
                                   [mgc_fire,mgc_water,mgc_air,mgc_earth];
            range := returnAvailableMagicRange;
            detect_successfully := FALSE;
            for j := -range to range do begin
               for i := -range to range do begin
                  returnMapComponent(returnX+i,returnY+j,get_magic_need_set);
                  if (temp_magic_need_set * get_magic_need_set) = temp_magic_need_set then
                     detect_successfully := TRUE;
               end;
            end;
            if not detect_successfully then begin
               if mgc_fire  in temp_magic_need_set then temp_s := '';
               if mgc_water in temp_magic_need_set then temp_s := '';
               if mgc_air   in temp_magic_need_set then temp_s := '';
               if mgc_earth in temp_magic_need_set then temp_s := 'w';
               if length(temp_s) > 0 then begin
                  if (ord(temp_s[length(temp_s)]) and $1F) > 1 then
                     temp_s := temp_s + ''
                  else
                     temp_s := temp_s + 'a';
               end;
               registerMessage(returnNumber,' ? '+temp_s+' ga..',DEFAULT_DELAY);
               exit;
            end;
         end;
         origin_x := 0;
         origin_y := 0;
         modifySelectionCenter(origin_x,origin_y);
         get_x := origin_x;
         get_y := origin_y;
         if not selectObject(get_x,get_y,range,range,0,0,NORMAL_CURSOR) then exit;
         get_x := get_x - origin_x + returnX;
         get_y := get_y - origin_y + returnY;
         selected_person := readMap(MA_PERSON,get_x,get_y);
         if _magic_destination = mgc_one then begin
            if selected_person = 0 then begin
               registerMessage(returnNumber,'aq ..',DEFAULT_DELAY);
               exit;
            end;
         end;
      end;
   end;

   get_level := returnAbility(_level);
   if need_to_consume_SP then
      get_skill := returnSkill(_cure_skill)
   else
      get_skill := 20;
   get_effect := get_level * get_skill div 100;
   with magic_data[MT,selected_magic]^.data do begin
      case selected_magic of
         1 :
         begin
            restore_HP := get_effect div 10;
            j := person[selected_person]^.returnInternal(_hit_point);
            j := j + restore_HP;
            if j > person[selected_person]^.returnMaxAvailHitPoint then
               j := person[selected_person]^.returnMaxAvailHitPoint;
            person[selected_person]^.setInternal(_hit_point,j);
         end;
         2 :
         begin
            restore_HP := get_effect div 10;
            j := person[selected_person]^.returnInternal(_poison_depth);
            j := j - restore_HP;
            if j < 0 then begin
               j := 0;
               registerMessage(person[selected_person]^.returnNumber,'Ё Aa !',DEFAULT_DELAY);
            end;
            person[selected_person]^.setInternal(_poison_depth,j);
         end;
         3 :
         begin
            if need_to_consume_SP then
               get_skill := returnSkill(_water_treating)
            else
               get_skill := 20;
            get_effect := get_level * get_skill;
            restore_HP := get_effect div 10;
            j := person[selected_person]^.returnInternal(_hit_point);
            j := j + restore_HP;
            if j > person[selected_person]^.returnMaxAvailHitPoint then
               j := person[selected_person]^.returnMaxAvailHitPoint;
            person[selected_person]^.setInternal(_hit_point,j);
         end;
         4 :
         begin
            if need_to_consume_SP then
               get_skill := returnSkill(_water_treating)
            else
               get_skill := 20;
            get_effect := get_level * get_skill;
            restore_HP := get_effect div 10;
            j := person[selected_person]^.returnInternal(_poison_depth);
            j := j - restore_HP;
            if j < 0 then begin
               j := 0;
               registerMessage(person[selected_person]^.returnNumber,'Ё Aa !',DEFAULT_DELAY);
            end;
            person[selected_person]^.setInternal(_poison_depth,j);
         end;
         5 :
         begin
            if need_to_consume_SP then
               get_skill := returnSkill(_earth_treating)
            else
               get_skill := 20;
            get_effect := get_level * get_skill;
            restore_HP := get_effect div 10;
            j := person[selected_person]^.returnInternal(_hit_point);
            j := j + restore_HP;
            if j > person[selected_person]^.returnMaxAvailHitPoint then
               j := person[selected_person]^.returnMaxAvailHitPoint;
            person[selected_person]^.setInternal(_hit_point,j);
         end;
         6 :
         begin
            restore_HP := get_effect div 5;
            j := returnInternal(_hit_point);
            j := j + restore_HP;
            if j > returnMaxAvailHitPoint then
               j := returnMaxAvailHitPoint;
            setInternal(_hit_point,j);
         end;
         7 :
         begin
            restore_HP := get_effect div 10;
            j := person[selected_person]^.returnInternal(_fear_depth);
            j := j - restore_HP;
            if j < 0 then begin
               j := 0;
               registerMessage(person[selected_person]^.returnNumber,'E aA  !',DEFAULT_DELAY);
            end;
            person[selected_person]^.setInternal(_fear_depth,j);
         end;
         8 :
         begin
            restore_HP := get_effect div 10;
            j := person[selected_person]^.returnInternal(_sleep_depth);
            j := j - restore_HP;
            if j < 0 then begin
               j := 0;
               registerMessage(person[selected_person]^.returnNumber,'១a java !',DEFAULT_DELAY);
            end;
            person[selected_person]^.setInternal(_sleep_depth,j);
         end;
         9 :
         begin
            restore_HP := get_effect div 10;
            j := person[selected_person]^.returnInternal(_paralisis_depth);
            j := j - restore_HP;
            if j < 0 then begin
               j := 0;
               registerMessage(person[selected_person]^.returnNumber,'aa Ήva !',DEFAULT_DELAY);
            end;
            person[selected_person]^.setInternal(_paralisis_depth,j);
         end;
         10:
         begin
            restore_HP := get_effect div 10;
            j := person[selected_person]^.returnInternal(_stonization_depth);
            j := j - restore_HP;
            if j < 0 then begin
               j := 0;
               registerMessage(person[selected_person]^.returnNumber,'i  a a !',DEFAULT_DELAY);
            end;
            person[selected_person]^.setInternal(_stonization_depth,j);
         end;
         11:
         begin
            restore_HP := get_effect div 30;
            j := person[selected_person]^.returnInternal(_unconscious_depth);
            j := j - restore_HP;
            if j < 0 then begin
               j := 0;
               if person[selected_person]^.returnInternal(_hit_point) < 0 then
                  person[selected_person]^.setInternal(_hit_point,0);
               registerMessage(person[selected_person]^.returnNumber,'i ava !',DEFAULT_DELAY);
            end;
            person[selected_person]^.setInternal(_unconscious_depth,j);
         end;
         12:
         begin
            restore_HP := get_effect div 10;
            if person[selected_person]^.returnInternal(_stonization_depth) > 0 then begin
               j := person[selected_person]^.returnInternal(_stonization_depth);
               j := j - restore_HP;
               if j < 0 then begin
                  j := 0;
                  registerMessage(person[selected_person]^.returnNumber,'i  a a ! ',DEFAULT_DELAY);
               end;
               person[selected_person]^.setInternal(_stonization_depth,j);
            end
            else if person[selected_person]^.returnInternal(_paralisis_depth) > 0 then begin
               j := person[selected_person]^.returnInternal(_paralisis_depth);
               j := j - restore_HP;
               if j < 0 then begin
                  j := 0;
                  registerMessage(person[selected_person]^.returnNumber,'aa Ήva !',DEFAULT_DELAY);
               end;
               person[selected_person]^.setInternal(_paralisis_depth,j);
            end
            else if person[selected_person]^.returnInternal(_sleep_depth) > 0 then begin
               j := person[selected_person]^.returnInternal(_sleep_depth);
               j := j - restore_HP;
               if j < 0 then begin
                  j := 0;
                  registerMessage(person[selected_person]^.returnNumber,'១a java !',DEFAULT_DELAY);
               end;
               person[selected_person]^.setInternal(_sleep_depth,j);
            end
            else if person[selected_person]^.returnInternal(_fear_depth) > 0 then begin
               j := person[selected_person]^.returnInternal(_fear_depth);
               j := j - restore_HP;
               if j < 0 then begin
                  j := 0;
                  registerMessage(person[selected_person]^.returnNumber,'E aA  !',DEFAULT_DELAY);
               end;
               person[selected_person]^.setInternal(_fear_depth,j);
            end
            else if person[selected_person]^.returnInternal(_poison_depth) > 0 then begin
               j := person[selected_person]^.returnInternal(_poison_depth);
               j := j - restore_HP;
               if j < 0 then begin
                  j := 0;
                  registerMessage(person[selected_person]^.returnNumber,'Ё Aa !',DEFAULT_DELAY);
               end;
               person[selected_person]^.setInternal(_poison_depth,j);
            end
         end;
         13,14:
         begin
            j := person[selected_person]^.returnInternal(_death_depth);
            if selected_magic = 14 then begin
               restore_HP := get_effect div 50;
               j := j - restore_HP;
            end else begin
               i := j div 10;
               if returnAbility(_endurance) - 1000 > i then begin
                  i := returnAbility(_endurance) - i;
                  setAbility(_endurance,i);
                  j := 0;
               end
               else begin
                  registerMessage(returnNumber,'e, aa Ё',DEFAULT_DELAY);
                  exit;
               end;
            end;
            if j <= 0 then begin
               j := 0;
               if person[selected_person]^.returnInternal(_unconscious_depth) >= returnMaxAvailHitPoint then
                  person[selected_person]^.setInternal(_unconscious_depth,returnMaxAvailHitPoint-1);
               registerMessage(person[selected_person]^.returnNumber,'a~~~',DEFAULT_DELAY);
            end;
            person[selected_person]^.setInternal(_death_depth,j);
         end;
      end;
   end;

   if need_to_consume_SP then begin
      setInternal(_spell_point,returnInternal(_spell_point)-magic_data[MT,selected_magic]^.data._magic_MP_consumtion);
   end;

   carryOutCureMagic := TRUE;
end;

function person_O.carryOutEnvironmentMagic(selected_magic : integer; need_to_consume_SP : boolean) : boolean;
const
   MT : magic_type_T = mgc_environment;
   DETECT_S : string[8] = '@5q@F';
   REP_STR  : string[10] = '  : ';
var
   origin_x, origin_y, get_x, get_y, range : integer;
   i, j, selected_person : integer;
   temp_b : byte;
   temp_magic_need_set, get_magic_need_set : magic_need_SET;
   temp_equipment : item_T;
   window : ^window_O;
   temp_s : string;
   ps     : ^string;
begin
   carryOutEnvironmentMagic := FALSE;

   if need_to_consume_SP then begin
      if magic_data[MT,selected_magic]^.data._magic_MP_consumtion >
         returnInternal(_spell_point) then begin
         if magic_data[MT,selected_magic]^.data._magic_MP_consumtion >
          returnMaxAvailSpellPoint then
            registerMessage(returnNumber,' a wb c...',DEFAULT_DELAY)
         else
         registerMessage(returnNumber,'b! abi ᢁ Жa...',DEFAULT_DELAY);
         exit;
      end;
   end;

   with magic_data[MT,selected_magic]^.data do begin
      case _magic_destination of
         mgc_one : range := 3;
         mgc_ground : begin
            if need_to_consume_SP then
               range := returnAvailableMagicRange
            else range := 5;
         end;
         mgc_party : range := 0
         else range := 0;
      end;
      if selected_magic = 24 then begin
         if range < 8 then range := 2 else range := 3;
      end;
      if (selected_magic = 25) and (not need_to_consume_SP) then range := 10;

      if range > 0 then begin
         origin_x := 0;
         origin_y := 0;
         modifySelectionCenter(origin_x,origin_y);
         get_x := origin_x;
         get_y := origin_y;
         if not selectObject(get_x,get_y,range,range,0,0,NORMAL_CURSOR) then exit;
         get_x := get_x - origin_x + returnX;
         get_y := get_y - origin_y + returnY;
         selected_person := readMap(MA_PERSON,get_x,get_y);
         if _magic_destination = mgc_one then begin
            if selected_person = 0 then exit;
         end;
         if need_to_consume_SP and (_magic_destination = mgc_ground) then begin
            temp_magic_need_set := _magic_need_set *
                                   [mgc_fire,mgc_water,mgc_air,mgc_earth];
            returnMapComponent(get_x,get_y,get_magic_need_set);
            if (temp_magic_need_set * get_magic_need_set) <> temp_magic_need_set then exit;
         end;
      end;

      case selected_magic of
         1 :
         begin
            if existEquipment(_left_hand) then begin
               returnEquipment(_left_hand,temp_equipment);
               if not getSomething(temp_equipment) then begin
                  setEquipment(_left_hand,temp_equipment);
                  exit;
               end;
            end;
            temp_equipment := item_data[__ITEM_TORCH]^.data;
            setEquipment(_left_hand,temp_equipment);
            if (map_header.tile_data_file[1] in ['d','D']) or
               (not game_system.returnHour in [6..18]) then
               registerMessage(returnNumber,'b  j..',DEFAULT_DELAY);
         end;
         2 :
         begin
            new(window,init(20,7,60,13,8,TRUE));
            temp_s := '@Eq@F';
            if mgc_fire   in get_magic_need_set then ps := @DETECT_S else ps := @temp_s;
            window^.printHangul('  '+REP_STR+ps^);
            if mgc_water  in get_magic_need_set then ps := @DETECT_S else ps := @temp_s;
            window^.printHangul('@@  '+REP_STR+ps^);
            if mgc_air    in get_magic_need_set then ps := @DETECT_S else ps := @temp_s;
            window^.printHangul('@@'+REP_STR+ps^);
            if mgc_earth  in get_magic_need_set then ps := @DETECT_S else ps := @temp_s;
            window^.printHangul('@@j  '+REP_STR+ps^);
            if mgc_poison in get_magic_need_set then ps := @DETECT_S else ps := @temp_s;
            window^.printHangul('@@  '+REP_STR+ps^);
            pressAnyKey;
            dispose(window,done);
         end;
         3 :
         begin
            i := (readMap(MA_ATTRIBUTE,get_x,get_y) and (not FIXED_AIR_BIT)) or FIXED_AIR_BIT;
            writeMap(MA_ATTRIBUTE,get_x,get_y,i);
         end;
         4 :
         begin
            if not person[selected_person]^.existEquipment(_weapon) then exit;
            if person[selected_person]^.returnEquipmentSuffix(_weapon,i,i) then exit;
            person[selected_person]^.returnEquipment(_weapon,temp_equipment);
            temp_equipment._item_suffix := __SUFFIX_FIRE;
            if need_to_consume_SP then
               temp_equipment._item_suffix_bonus := returnAbility(_concentration) div 100 + 1
            else
               temp_equipment._item_suffix_bonus := 30;
            person[selected_person]^.setEquipment(_weapon,temp_equipment);
            registerMessage(selected_person,' ..',DEFAULT_DELAY);
         end;
         5 :
         begin
            if person[selected_person]^.returnEquipmentSuffix(_shield,i,i) then begin
               if person[selected_person]^.returnEquipmentSuffix(_armor,i,i) then exit;
               if not person[selected_person]^.existEquipment(_armor) then exit;
               person[selected_person]^.returnEquipment(_armor,temp_equipment);
               temp_equipment._item_suffix := __SUFFIX_WATER;
               if need_to_consume_SP then
                  temp_equipment._item_suffix_bonus := returnAbility(_concentration) div 100 + 1
               else
                  temp_equipment._item_suffix_bonus := 30;
               person[selected_person]^.setEquipment(_armor,temp_equipment);
               registerMessage(selected_person,' sa..',DEFAULT_DELAY);
            end else begin
               if not person[selected_person]^.existEquipment(_shield) then exit;
               person[selected_person]^.returnEquipment(_shield,temp_equipment);
               temp_equipment._item_suffix := __SUFFIX_WATER;
               if need_to_consume_SP then
                  temp_equipment._item_suffix_bonus := returnAbility(_concentration) div 100 + 1
               else
                  temp_equipment._item_suffix_bonus := 30;
               person[selected_person]^.setEquipment(_shield,temp_equipment);
               registerMessage(selected_person,' ẃ..',DEFAULT_DELAY);
            end;
         end;
         6 :
         begin
            if not person[selected_person]^.existEquipment(_weapon) then exit;
            if person[selected_person]^.returnEquipmentSuffix(_weapon,i,i) then exit;
            person[selected_person]^.returnEquipment(_weapon,temp_equipment);
            temp_equipment._item_suffix := __SUFFIX_AIR;
            if need_to_consume_SP then
               temp_equipment._item_suffix_bonus := returnAbility(_concentration) div 100 + 1
            else
               temp_equipment._item_suffix_bonus := 30;
            person[selected_person]^.setEquipment(_weapon,temp_equipment);
            registerMessage(selected_person,' ..',DEFAULT_DELAY);
         end;
         7 :
         begin
            if person[selected_person]^.returnEquipmentSuffix(_shield,i,i) then begin
               if person[selected_person]^.returnEquipmentSuffix(_weapon,i,i) then exit;
               if not person[selected_person]^.existEquipment(_weapon) then exit;
               person[selected_person]^.returnEquipment(_weapon,temp_equipment);
               temp_equipment._item_suffix := __SUFFIX_EARTH;
               if need_to_consume_SP then
                  temp_equipment._item_suffix_bonus := returnAbility(_concentration) div 100 + 1
               else
                  temp_equipment._item_suffix_bonus := 30;
               person[selected_person]^.setEquipment(_weapon,temp_equipment);
               registerMessage(selected_person,'w ..',DEFAULT_DELAY);
            end else begin
               if not person[selected_person]^.existEquipment(_shield) then exit;
               person[selected_person]^.returnEquipment(_shield,temp_equipment);
               temp_equipment._item_suffix := __SUFFIX_EARTH;
               if need_to_consume_SP then
                  temp_equipment._item_suffix_bonus := returnAbility(_concentration) div 100 + 1
               else
                  temp_equipment._item_suffix_bonus := 30;
               person[selected_person]^.setEquipment(_shield,temp_equipment);
               registerMessage(selected_person,'w ẃ..',DEFAULT_DELAY);
            end;
         end;
         8 :
         begin
            if need_to_consume_SP then begin
               j := 0;
               for i := 1 to returnMaxInventory do begin
                  if returnInventoryNumber(i) = __ITEM_POISON then j := i;
               end;
               if j = 0 then begin
                  registerMessage(selected_person,' aa ..',DEFAULT_DELAY);
                  exit;
               end;
            end;
            if not person[selected_person]^.existEquipment(_weapon) then exit;
            if person[selected_person]^.returnEquipmentSuffix(_weapon,range,range) then exit;
            person[selected_person]^.returnEquipment(_weapon,temp_equipment);
            temp_equipment._item_suffix := __SUFFIX_POISON;
            if need_to_consume_SP then
               temp_equipment._item_suffix_bonus := returnAbility(_concentration) div 100 + 1
            else
               temp_equipment._item_suffix_bonus := 30;
            person[selected_person]^.setEquipment(_weapon,temp_equipment);
            registerMessage(selected_person,' ..',DEFAULT_DELAY);
            if need_to_consume_SP then begin
               dropSomething(j,temp_equipment);
            end;
         end;
         9 :
         begin
            if not person[selected_person]^.existEquipment(_weapon) then exit;
            if person[selected_person]^.returnEquipmentSuffix(_weapon,i,i) then exit;
            person[selected_person]^.returnEquipment(_weapon,temp_equipment);
            temp_equipment._item_suffix := __SUFFIX_ELECTRITY;
            if need_to_consume_SP then
               temp_equipment._item_suffix_bonus := returnAbility(_concentration) div 100 + 1
            else
               temp_equipment._item_suffix_bonus := 30;
            person[selected_person]^.setEquipment(_weapon,temp_equipment);
            registerMessage(selected_person,'勡 ..',DEFAULT_DELAY);
         end;
         10:
         if (map_header.handicap_bit and __HANDICAP_GROUNDING) = 0 then begin
            temp_b := readMap(MA_FIELD,get_x,get_y) and FIELD_BIT;
            if not (temp_b in [__FIELD_ELETRIC,__FIELD_ENERGY]) then exit;
            writeMap(MA_FIELD,get_x,get_y,readMap(MA_FIELD,get_x,get_y) and (not FIELD_BIT));
         end else begin
            registerMessage(returnNumber,'a wЁ h a..',DEFAULT_DELAY)
         end;
         11:
         begin
            temp_b := readMap(MA_NORMAL,get_x,get_y);
            if temp_b <> __TILE_VALLEY then exit;
            writeMap(MA_NORMAL,get_x,get_y,__TILE_SAND);
         end;
         12:
         begin
            temp_b := readMap(MA_FIELD,get_x,get_y);
            if (temp_b and FIELD_BIT) > 0 then exit;
            writeMap(MA_FIELD,get_x,get_y,(temp_b and (not FIELD_BIT)) or __FIELD_FIRE);
         end;
         13:
         begin
            temp_b := readMap(MA_FIELD,get_x,get_y);
            if (temp_b and FIELD_BIT) > 0 then exit;
            writeMap(MA_FIELD,get_x,get_y,(temp_b and (not FIELD_BIT)) or __FIELD_VACUUM);
         end;
         14:
         begin
            temp_b := readMap(MA_ATTRIBUTE,get_x,get_y);
            temp_b := temp_b and (not WALKABLE_BIT);
            writeMap(MA_ATTRIBUTE,get_x,get_y,temp_b);
         end;
         15:
         begin
            i := returnInternal(_breath_remain_count);
            if need_to_consume_SP then
               j := returnAbility(_concentration) div 300
            else
               j := 10;
            if i + j < 0 then exit;
            setInternal(_breath_remain_count,i+j);
            registerMessage(returnNumber,'a ..',DEFAULT_DELAY);
         end;
         16:
         if (map_header.handicap_bit and __HANDICAP_WIZARD_EYE) = 0 then begin
            new(window,init(5,2,38,19,8,TRUE));
            origin_x := returnX - 25;
            if origin_x < 0 then origin_x := 0
            else if origin_x > game_system.returnMapXMax-1-50 then
               origin_x := game_system.returnMapXMax - 51;
            origin_y := returnY - 25;
            if origin_y < 0 then origin_y := 0
            else if origin_y > game_system.returnMapYMax-1-50 then
               origin_y := game_system.returnMapYMax - 51;
            if game_system.returnMapXMax < 50 then begin
               get_x := game_system.returnMapXMax-1;
               origin_x := 0;
            end else get_x := 50;
            if game_system.returnMapYMax < 50 then begin
               get_y := game_system.returnMapYMax-1;
               origin_y := 0;
            end else get_y := 50;

         for j := 0 to get_y do begin
            for i := 0 to get_x do begin
               temp_b := readMap(MA_NORMAL,i+origin_x,j+origin_y);
               if map_header.tile_data_file[1] in ['d','D'] then begin
                  case temp_b of
                     53..66 : temp_b := 1;
                     50..52 : temp_b := 2;
                     79 : temp_b := 3;
                     88,92..95 : temp_b := 4;
                     1..3,12,22..24,49 : temp_b := 6;
                     91,96..99,120..139 : temp_b := 7;
                     5,6,9,10,18..21,25,27..46,48 : temp_b := 8;
                     78 : temp_b := 9;
                     47 : temp_b := 10;
                     118 : temp_b := 11;
                     140,141 : temp_b := 12;
                     4,7,8,11,13..17,26 : temp_b := 13;
                     89,90,100..117,119 : temp_b := 14;
                     else temp_b := 0;
                  end;
               end else begin
                  case temp_b of
                     53..66,75..77 : temp_b := 1;
                     1..3,49,52 : temp_b := 2;
                     79 : temp_b := 3;
                     80,90..95 : temp_b := 4;
                     5,6,9,10,18..25,27..46,48,50,51,67..69 : temp_b := 6;
                     74,96..139 : temp_b := 7;
                     140,141 : temp_b := 8;
                     78 : temp_b := 9;
                     47 : temp_b := 10;
                     70..73,81..89 : temp_b := 13;
                     4,7,8,11..17,26 : temp_b := 14;
                     else temp_b := 0;
                  end;
               end;
               setFillStyle(SOLIDFILL,temp_b);
               temp_b := readMap(MA_OBJECT,i+origin_x,j+origin_y);
               if temp_b > 0 then setFillStyle(SOLIDFILL,4);
               temp_b := readMap(MA_PERSON,i+origin_x,j+origin_y);
               if temp_b > 0 then begin
                  if temp_b = _MAIN_CHARACTER then setFillStyle(SOLIDFILL,5)
                  else setFillStyle(SOLIDFILL,11);
               end;
               bar(46+i*5,40+j*5,46+i*5+4,40+j*5+4);
            end;
         end;

            pressAnyKey;
            dispose(window,done);
         end else begin
            registerMessage(returnNumber,'.. e ɷЁ!',DEFAULT_DELAY)
         end;
         17:
         begin
            j := 0;
            for i := 1 to returnMaxInventory do begin
               if returnInventoryNumber(i) = __ITEM_POISON then j := i;
            end;
            if j = 0 then begin
               registerMessage(returnNumber,' aa ..',DEFAULT_DELAY);
               exit;
            end;
            temp_b := readMap(MA_FIELD,get_x,get_y);
            if (temp_b and FIELD_BIT) > 0 then exit;
            writeMap(MA_FIELD,get_x,get_y,(temp_b and (not FIELD_BIT)) or __FIELD_POISON);
            dropSomething(j,temp_equipment);
         end;
         18:
         begin
            temp_b := readMap(MA_FIELD,get_x,get_y);
            if (temp_b and FIELD_BIT) <> __FIELD_POISON then exit;
            writeMap(MA_FIELD,get_x,get_y,temp_b and (not FIELD_BIT));
         end;
         19:
         begin
            i := returnInternal(_antodote_body);
            if need_to_consume_SP then
               j := returnAbility(_concentration) div 20
            else
               j := 100;
            if i + j < 0 then exit;
            setInternal(_antodote_body,i+j);
            registerMessage(selected_person,'ae A e sa..',DEFAULT_DELAY);
         end;
         20:
         begin
            i := returnInternal(_levitation);
            if need_to_consume_SP then
               j := returnAbility(_concentration) div 200
            else
               j := 15;
            if i + j < 0 then exit;
            setInternal(_levitation,i+j);
         end;
         21:
         if (map_header.handicap_bit and __HANDICAP_TRASPARENCY) = 0 then begin
            i := returnInternal(_transparency);
            if need_to_consume_SP then
               j := returnAbility(_concentration) div 50
            else
               j := 100;
            if i + j < 0 then exit;
            setInternal(_transparency,i+j);
         end else begin
            registerMessage(returnNumber,'a ʁi sae',DEFAULT_DELAY)
         end;
         22:
         begin
            temp_b := readMap(MA_NORMAL,get_x,get_y);
            if not (temp_b in MOVABLE_TILE) then exit;
            if map_header.tile_data_file[1] in ['d','D'] then begin
               writeMap(MA_NORMAL,get_x,get_y,__TILE_DEN_SAND);
            end else begin
               writeMap(MA_NORMAL,get_x,get_y,__TILE_SAND);
            end;
         end;
         23:
         if (map_header.handicap_bit and __HANDICAP_METAMORPHOSE) = 0 then begin
            writeMap(MA_NORMAL,get_x,get_y,__TILE_SAND);
            temp_b := readMap(MA_NORMAL,get_x,get_y-1);
            if temp_b in FOREGROUND_TILE then writeMap(MA_NORMAL,get_x,get_y-1,__TILE_SAND);
         end else begin
            registerMessage(returnNumber,' e a eɷЁ',DEFAULT_DELAY)
         end;
         24,25:
         if (selected_magic = 24) and ((map_header.handicap_bit and __HANDICAP_ETHERIZATION) <> 0) then begin
            registerMessage(returnNumber,' ỡb aaa',DEFAULT_DELAY)
         end else
         if (selected_magic = 25) and ((map_header.handicap_bit and __HANDICAP_TELEPORT) <> 0) then begin
            registerMessage(returnNumber,'e ỡb aaa',DEFAULT_DELAY)
         end else begin
            if not isMovableMap(get_x,get_y) then exit;
            writeMap(MA_PERSON,returnX,returnY,0);
            setX(get_x);
            setY(get_y);
            writeMap(MA_PERSON,returnX,returnY,returnNumber);
         end;
      end;
   end;

   if need_to_consume_SP then begin
      setInternal(_spell_point,returnInternal(_spell_point)-magic_data[MT,selected_magic]^.data._magic_MP_consumtion);
   end;

   carryOutEnvironmentMagic := TRUE;
end;

function person_O.carryOutSummonMagic(selected_magic : integer; need_to_consume_SP : boolean) : boolean;
const
   MT : magic_type_T = mgc_summon;
var
   origin_x, origin_y, get_x, get_y, range : integer;
   i, j, selected_person : integer;
   temp_b, aux_b : byte;
   ET : equipment_T;
   temp_magic_need_set, get_magic_need_set : magic_need_SET;
   temp_equipment : item_T;
   temp_s : string;
begin
   carryOutSummonMagic := FALSE;

   if need_to_consume_SP then begin
      if magic_data[MT,selected_magic]^.data._magic_MP_consumtion >
         returnInternal(_spell_point) then begin
         if magic_data[MT,selected_magic]^.data._magic_MP_consumtion >
          returnMaxAvailSpellPoint then
            registerMessage(returnNumber,' a wb c...',DEFAULT_DELAY)
         else
            registerMessage(returnNumber,'b! abi ᢁ Жa...',DEFAULT_DELAY);
         exit;
      end;
   end;

   if max_person >= MAX_PERSON_ARRAY then begin
      registerMessage(returnNumber,'ŷi wЁh e  {eA..',DEFAULT_DELAY);
      exit;
   end;

   with magic_data[MT,selected_magic]^.data do begin
      range := returnAvailableMagicRange;
      if range > 0 then begin
         origin_x := 0;
         origin_y := 0;
         modifySelectionCenter(origin_x,origin_y);
         get_x := origin_x;
         get_y := origin_y;
         if not selectObject(get_x,get_y,range,range,0,0,NORMAL_CURSOR) then exit;
         get_x := get_x - origin_x + returnX;
         get_y := get_y - origin_y + returnY;

         temp_magic_need_set := _magic_need_set *
                                [mgc_fire,mgc_water,mgc_air,mgc_earth,mgc_corpse,mgc_thing];
         returnMapComponent(get_x,get_y,get_magic_need_set);
         if (temp_magic_need_set * get_magic_need_set) <> temp_magic_need_set then exit;
      end;

      selected_person := 0;
      for i := MAX_TALKABLE_PERSON_ARRAY to MAX_PERSON_ARRAY do begin
         if person[i] = nil then begin
            selected_person := i;
            break;
         end;
      end;
      if selected_person = 0 then begin
         registerMessage(returnNumber,'ŷi wЁh e  {eA..',DEFAULT_DELAY);
         exit;
      end;

      if ((_magic_need_set * [mgc_corpse,mgc_thing]) <> []) and
         (selected_magic in [1..MAX_MAGIC_DATA]) and
         (magic_data[MT,selected_magic] <> nil) then begin
         aux_b := 0;
         temp_b := testItemMap(get_x,get_y,ET,aux_b);
         if temp_b > 0 then begin
            returnItemMap(get_x,get_y,temp_equipment);
            if temp_equipment._item_type > START_OF_EQUIPMENT then
               convertItemToObject(temp_equipment._item_number,temp_b)
            else
               temp_b := temp_equipment._item_number;
         end
         else begin
            temp_b := readMap(MA_OBJECT,get_x,get_y);
            writeMap(MA_OBJECT,get_x,get_y,0);
            convertObjectToItem(temp_b,temp_equipment);
         end;
      end;

      case selected_magic of
         1 :
         begin
            person[selected_person] :=
               new(simple_person_type,init(selected_person,__PERSON_FIRE_ELEMENTAL,mgc_fire,MA_PERSON,' w',2,TRUE));
            temp_b := readMap(MA_FIELD,get_x,get_y) and ($FF xor FIELD_BIT);
            writeMap(MA_FIELD,get_x,get_y,temp_b);
            with person[selected_person]^ do begin
               str(self.returnSkill(_fire_treating)*100,temp_s);
               setAbilityALL('2000,1000,5000,3000,5000,3000,1000,1000,50,'+temp_s);
               setSkillALL('10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10');
               setX(get_x);
               setY(get_y);
               writeMap(MA_PERSON,get_x,get_y,selected_person);
               setInternal(_love,_MAIN_CHARACTER);
               temp_equipment := item_data[__ITEM_SLING]^.data;
               case random(4) of
                  0 : begin
                     temp_equipment._item_shape := __FIELD_FLAME;
                     temp_equipment._item_shape_revolution := 3;
                  end;
                  1 : begin
                     temp_equipment._item_shape := __FIELD_FIRE_BALL;
                     temp_equipment._item_shape_revolution := 2;
                  end;
                  2 : begin
                     temp_equipment._item_shape := __FIELD_FIRE_WHIRL;
                     temp_equipment._item_shape_revolution := 2;
                  end;
                  3 : begin
                     temp_equipment._item_shape := __FIELD_ATOM_FIRE;
                     temp_equipment._item_shape_revolution := 2;
                  end;
               end;
               temp_equipment._item_number := -1;
               setEquipment(_weapon,temp_equipment);
               modifyInternalValue;
            end;
         end;
         2 :
         begin
            person[selected_person] :=
               new(simple_person_type,init(selected_person,__PERSON_WATER_ELEMENTAL,mgc_water,MA_PERSON,' w',2,TRUE));
            with person[selected_person]^ do begin
               str(self.returnSkill(_water_treating)*100,temp_s);
               setAbilityALL('2000,1000,5000,3000,5000,3000,1000,1000,50,'+temp_s);
               setSkillALL('10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10');
               setX(get_x);
               setY(get_y);
               writeMap(MA_PERSON,get_x,get_y,selected_person);
               setInternal(_love,_MAIN_CHARACTER);
               setInternal(_levitation,9999);
               temp_equipment := item_data[__ITEM_SLING]^.data;
               temp_equipment._item_shape := __FIELD_WATER;
               temp_equipment._item_shape_revolution := 2;
               temp_equipment._item_trailing_count := 255;
               temp_equipment._item_number := -1;
               setEquipment(_weapon,temp_equipment);
               modifyInternalValue;
            end;
         end;
         3 :
         begin
            person[selected_person] :=
               new(simple_person_type,init(selected_person,__PERSON_AIR_ELEMENTAL,mgc_air,MA_PERSON,' w',2,TRUE));
            with person[selected_person]^ do begin
               str(self.returnSkill(_air_treating)*100,temp_s);
               setAbilityALL('2000,1000,5000,1000,5000,3000,1000,1000,50,'+temp_s);
               setSkillALL('10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10');
               setX(get_x);
               setY(get_y);
               writeMap(MA_PERSON,get_x,get_y,selected_person);
               setInternal(_love,_MAIN_CHARACTER);
               temp_equipment := item_data[__ITEM_CUTLASS]^.data;
               temp_equipment._item_number := -1;
               setEquipment(_weapon,temp_equipment);
               modifyInternalValue;
            end;
         end;
         4 :
         begin
            person[selected_person] :=
               new(simple_person_type,init(selected_person,__PERSON_EARTH_ELEMENTAL,mgc_earth,MA_PERSON,' w',2,TRUE));
            with person[selected_person]^ do begin
               i := self.returnSkill(_earth_treating)*100;
               str(i,temp_s);
               setAbilityALL('2000,1000,5000,1000,5000,3000,1000,1000,50,'+temp_s);
               setSkillALL('10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10');
               setX(get_x);
               setY(get_y);
               writeMap(MA_PERSON,get_x,get_y,selected_person);
               setInternal(_love,_MAIN_CHARACTER);
               temp_equipment := item_data[__ITEM_SWORD]^.data;
               temp_equipment._item_number := -1;
               setEquipment(_weapon,temp_equipment);
               modifyInternalValue;
            end;
         end;
         5 :
         begin
            person[selected_person] := new(simple_person_type,
                   init(selected_person,temp_b-__OBJECT_DEATH_BODY+1,mgc_player,MA_PERSON,'A',8,TRUE));
            with person[selected_person]^ do begin
               str(self.returnSkill(_summon_skill)*100,temp_s);
               setAbilityALL('2000,1000,5000,3000,5000,3000,1000,1000,50,'+temp_s);
               setSkillALL('10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10');
               setX(get_x);
               setY(get_y);
               writeMap(MA_PERSON,get_x,get_y,selected_person);
               setInternal(_love,_MAIN_CHARACTER);
               temp_equipment := item_data[__ITEM_AXE]^.data;
               temp_equipment._item_number := -1;
               setEquipment(_weapon,temp_equipment);
               modifyInternalValue;
            end;
         end;
         6 :
         begin
            person[selected_person] :=
               new(simple_person_type,init(selected_person,__PERSON_MONSTER,mgc_not_need,MA_PERSON,'A',4,TRUE));
            with person[selected_person]^ do begin
               if need_to_consume_SP then
                  str(self.returnSkill(_summon_skill)*100,temp_s)
               else
                  str(30*100,temp_s);
               setAbilityALL('2000,1000,5000,3000,5000,3000,1000,1000,50,'+temp_s);
               setSkillALL('10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10');
               setX(get_x);
               setY(get_y);
               writeMap(MA_PERSON,get_x,get_y,selected_person);
               setInternal(_love,_MAIN_CHARACTER);
               temp_equipment := item_data[__ITEM_SWORD]^.data;
               temp_equipment._item_number := -1;
               setEquipment(_weapon,temp_equipment);
               modifyInternalValue;
            end;
         end;
         7 :
         begin
            j := random(6);
            case j of
               0 : temp_s := '3w';
               1 : temp_s := 'Aw';
               2 : temp_s := 'e';
               3 : temp_s := 'e(?)';
               4 : temp_s := 'ea';
               5 : temp_s := 'ᣡe';
            end;
            i := __PERSON_OTHER_DIMENTION + j;
            person[selected_person] :=
               new(simple_person_type,init(selected_person,i,mgc_not_need,MA_PERSON,temp_s,1,TRUE));
            with person[selected_person]^ do begin
               str(self.returnSkill(_dimention_control_skill)*100,temp_s);
               case j of
                  0 : setAbilityALL('2000,1000,5000,3000,5000,3000,1000,1000,50,'+temp_s);
                  1 : setAbilityALL('2000,1000,5000,3000,5000,3000,1000,1000,50,'+temp_s);
                  2 : setAbilityALL('2000,1000,5000,3000,5000,3000,1000,1000,50,'+temp_s);
                  3 : setAbilityALL('2000,1000,5000,3000,5000,3000,1000,1000,50,'+temp_s);
                  4 : setAbilityALL('2000,1000,5000,3000,5000,3000,1000,1000,50,'+temp_s);
                  5 : setAbilityALL('2000,1000,5000,3000,5000,3000,1000,1000,50,'+temp_s);
               end;
               setSkillALL('10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10');
               setX(get_x);
               setY(get_y);
               writeMap(MA_PERSON,get_x,get_y,selected_person);
               setInternal(_love,_MAIN_CHARACTER);
               temp_equipment := item_data[__ITEM_SWORD]^.data;
               temp_equipment._item_number := -1;
               setEquipment(_weapon,temp_equipment);
               modifyInternalValue;
            end;
         end;
         8 :
         begin
            if not ((object_data_index[temp_b] > 0) or
               (temp_b > ADDRESS_OF_WEAPON_IN_OBJECT_TILE)) then begin
               setItemMap(get_x,get_y,temp_equipment);
               exit;
            end;
            person[selected_person] := new(simple_person_type,
                   init(selected_person,temp_b,mgc_thing,MA_OBJECT,returnItemName(temp_equipment,TRUE),1,TRUE));
            with person[selected_person]^ do begin
               str(self.returnSkill(_summon_skill)*100,temp_s);
               setAbilityALL('2000,1000,5000,3000,5000,3000,1000,1000,50,'+temp_s);
               setAbilityALL('1500,1000,2000,400,5000,1000,1000,1000,50,200');
               setSkillALL('10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10');
               setX(get_x);
               setY(get_y);
               writeMap(MA_PERSON,get_x,get_y,selected_person);
               setInternal(_love,_MAIN_CHARACTER);
               temp_equipment := item_data[__ITEM_AXE]^.data;
               temp_equipment._item_number := -1;
               setEquipment(_weapon,temp_equipment);
               modifyInternalValue;
            end;
         end;
         9 :
         begin
            person[selected_person] :=
               new(simple_person_type,init(selected_person,__PERSON_DRAGON,mgc_not_need,MA_PERSON,'w',4,TRUE));
            with person[selected_person]^ do begin
               if need_to_consume_SP then
                  str(self.returnSkill(_summon_skill)*100,temp_s)
               else
                  str(30*100,temp_s);
               setAbilityALL('2000,1000,5000,6000,5000,3000,1000,1000,100,'+temp_s);
               setSkillALL('10,10,10,10,100,10,10,10,10,10,10,10,10,10,10,10');
               setX(get_x);
               setY(get_y);
               writeMap(MA_PERSON,get_x,get_y,selected_person);
               setInternal(_love,_MAIN_CHARACTER);
               temp_equipment := item_data[__ITEM_SLING]^.data;
               temp_equipment._item_shape := __FIELD_FLAME;
               temp_equipment._item_shape_revolution := 3;
               temp_equipment._item_number := -1;
               setEquipment(_weapon,temp_equipment);
               modifyInternalValue;
            end;
         end;
      end;

   end;

   if need_to_consume_SP then begin
      setInternal(_spell_point,returnInternal(_spell_point)-magic_data[MT,selected_magic]^.data._magic_MP_consumtion);
   end;

   carryOutSummonMagic := TRUE;
end;

function person_O.carryOutMagic(MT : magic_type_T; selected_magic : integer) : boolean;
var
   s : string;
   _carryOutMagic : boolean;
   AAT : attack_attribute_T;
begin
   case MT of
      mgc_attack : _carryOutMagic := carryOutAttackMagic(selected_magic,TRUE);
      mgc_defense : begin
         _carryOutMagic := TRUE;
         s := magic_data[MT,selected_magic]^.name;
         if length(s) > 0 then begin
            if (ord(s[length(s)]) and $1F) > 1 then
               s := s + 'i'
            else
               s := s + 'i';
            registerMessage(returnNumber,s+' w aa..',DEFAULT_DELAY);
            setInternal(_defense_magic,selected_magic);
         end;
      end;
      mgc_cure : _carryOutMagic := carryOutCureMagic(selected_magic,TRUE);
      mgc_environment : _carryOutMagic := carryOutEnvironmentMagic(selected_magic,TRUE);
      mgc_summon : _carryOutMagic := carryOutSummonMagic(selected_magic,TRUE);
   end;

   if _carryOutMagic then begin
      if random(20) = 0 then
      if random(100) < (returnAbility(_inteligence) div 30) then begin
         AAT := magic_data[MT,selected_magic]^.data._magic_attribute;
         if _magical in [AAT] then begin
            if returnSkill(_magic_skill) < 100 then
               setSkill(_magic_skill,succ(returnSkill(_magic_skill)));
         end;
         if _fiery in [AAT] then begin
            if returnSkill(_fire_treating) < 100 then
               setSkill(_fire_treating,succ(returnSkill(_fire_treating)));
         end;
         if _watery in [AAT] then begin
            if returnSkill(_water_treating) < 100 then
               setSkill(_water_treating,succ(returnSkill(_water_treating)));
         end;
         if _airy in [AAT] then begin
            if returnSkill(_air_treating) < 100 then
               setSkill(_air_treating,succ(returnSkill(_air_treating)));
         end;
         if _earthy in [AAT] then begin
            if returnSkill(_earth_treating) < 100 then
               setSkill(_earth_treating,succ(returnSkill(_earth_treating)));
         end;
         if _electrical in [AAT] then begin
            if returnSkill(_light_treating) < 100 then
               setSkill(_light_treating,succ(returnSkill(_light_treating)));
         end;
         case magic_data[MT,selected_magic]^.data._magic_type of
            mgc_summon :
            begin
               if random(3) = 0 then
               if returnSkill(_summon_skill) < 100 then
                  setSkill(_summon_skill,succ(returnSkill(_summon_skill)));
               if magic_data[MT,selected_magic]^.data._magic_number in [6,7,9] then
               if returnSkill(_dimention_control_skill) < 100 then
                  setSkill(_dimention_control_skill,succ(returnSkill(_dimention_control_skill)));
            end;
            mgc_cure :
            if returnSkill(_cure_skill) < 100 then
               setSkill(_cure_skill,succ(returnSkill(_cure_skill)));
         end;
      end;
   end;

   carryOutMagic := _carryOutMagic;
end;

procedure person_O.castMagic;
var
   select : ^select_O;
   MT : magic_type_T;
   i, j, k, selected_menu, selected_magic : integer;
   number_of_magic : integer;
begin

   new(select,init);
   with select^ do begin
      setMenu(1,'b a');
      setMenu(2,'w a');
      setMenu(3,'áa a');
      setMenu(4,'e a');
      setMenu(5,' a');
      setHanColor(WHITE);
      printTalkHangul(23,3,'w aaae a Ai a',0);
      setMenuMode(EXTENDED_MENU);
      selected_menu := select^.selectMenu(32,5,remember_cast_magic,5);
      setMenuMode(NORMAL_MENU);
      flipPageEASY;
      if selected_menu > 0 then begin
         remember_cast_magic := selected_menu;
         case selected_menu of
            1 : MT := mgc_attack;
            2 : MT := mgc_defense;
            3 : MT := mgc_cure;
            4 : MT := mgc_environment;
            5 : MT := mgc_summon;
         end;
         number_of_magic := 0;
         selected_magic := 0;
         for i := 1 to MAX_MAGIC_EA[MT] do begin
            if i in m_known_magic[MT] then begin
               inc(number_of_magic);
               setMenu(number_of_magic,magic_data[MT,i]^.name);
               if (selected_magic = 0) or (remember_magic_selection[MT] = i) then selected_magic := number_of_magic;
            end;
         end;
         if number_of_magic > 0 then begin
            setHanColor(WHITE);
            printTalkHangul(32,3,'ai a',0);
            setMenuMode(EXTENDED_MENU);
            selected_menu := select^.selectMenu(32,5,selected_magic,number_of_magic);
            setMenuMode(NORMAL_MENU);
            flipPageEASY;
            if selected_menu > 0 then begin
               j := 0;
               selected_magic := 0;
               for i := 1 to MAX_MAGIC_EA[MT] do begin
                  if i in m_known_magic[MT] then begin
                     inc(j);
                     if j = selected_menu then begin
                        selected_magic := i;
                        remember_magic_selection[MT] := i;
                     end;
                  end;
               end;

               carryOutMagic(MT,selected_magic);

            end;
         end;
      end;
   end;
   dispose(select,done);

end;

function person_O.castMagicAUTO(range : byte) : boolean;
var
   MT : magic_type_T;
   i, j, k, selected_menu, selected_magic : integer;
   number_of_magic : integer;
   available_magic : array[1..30] of byte;
begin
   castMagicAUTO := FALSE;

   MT := mgc_attack;
   number_of_magic := 0;
   for i := 1 to MAX_MAGIC_EA[MT] do begin
      if i in m_known_magic[MT] then begin
         if (returnInternal(_spell_point) >= magic_data[MT,i]^.data._magic_MP_consumtion) and
            (magic_data[MT,i]^.data._magic_attack_range >= range) then begin
            inc(number_of_magic);
            available_magic[number_of_magic] := i;
         end;
      end;
   end;

   if number_of_magic > 0 then begin
      number_of_magic := succ(random(number_of_magic));
      carryOutAttackMagic(available_magic[number_of_magic],TRUE);
      castMagicAUTO := TRUE;
   end;

end;

procedure person_O.useItem;
label
   _EXIT_LOOP;
var
   i, j, selected_menu, max_menu : integer;
   item_kind, remember_item, templet_item : item_T;
   s          : shortString;
   use_result : boolean;
begin
   use_result := FALSE;

   selected_menu := selectItemADVANCED('aw i i a');

   if selected_menu > 0 then begin
      dropSomething(selected_menu,item_kind);
      if item_kind._item_contain > 1 then begin
         dec(item_kind._item_contain);
         getSomething(item_kind);
      end;
      item_kind._item_contain := 1;
      templet_item := item_kind;

      if item_kind._item_type > START_OF_EQUIPMENT then begin
         case item_kind._item_number of
            75 : use_result := carryOutEnvironmentMagic(1,FALSE);
            76 :
            begin
               returnEquipment(_weapon,remember_item);
               item_kind := item_data[__ITEM_FLAME_BOME]^.data;
               item_kind._item_shape := 176;
               setEquipment(_weapon,item_kind);
               use_result := attackSomething;
               setEquipment(_weapon,remember_item);
            end;
            77 : use_result := carryOutCureMagic(1,FALSE);
            79 : use_result := carryOutCureMagic(2,FALSE);
            80 : use_result := carryOutEnvironmentMagic(20,FALSE);
            81 :
            if item_kind._item_suffix = 0 then begin
               use_result := carryOutEnvironmentMagic(16,FALSE);
            end;
            82 : use_result := carryOutSummonMagic(6,FALSE);
            83 : use_result := carryOutCureMagic(12,FALSE);
            84 : use_result := carryOutCureMagic(11,FALSE);
            85 : use_result := carryOutCureMagic(14,FALSE);
            86 : use_result := carryOutEnvironmentMagic(8,FALSE);
            87 : use_result := carryOutEnvironmentMagic(18,FALSE);
            88 : use_result := carryOutEnvironmentMagic(25,FALSE);
            95 :
            begin
               if (item_kind._item_magic_type in [mgc_attack..mgc_environment]) and
                  (item_kind._item_magic in [1..MAX_MAGIC_DATA]) then begin
                  m_known_magic[item_kind._item_magic_type] :=
                     m_known_magic[item_kind._item_magic_type] + [item_kind._item_magic];
                  s := magic_data[item_kind._item_magic_type,item_kind._item_magic]^.name;
                  s := 'we <'+s+'> ai va';
                  printMessageWindowSub(s,1);
               end else begin
                  registerMessage(returnNumber,'a.. E a ',DEFAULT_DELAY);
               end;
               use_result := TRUE;
            end;
{
            begin
               if item_kind._item_magic_remain > 0 then begin
                  dec(item_kind._item_magic_remain);
                  case item_kind._item_magic_type of
                     mgc_none : registerMessage(returnNumber,'not include magic..',DEFAULT_DELAY);
                     mgc_attack : carryOutAttackMagic(item_kind._item_magic,FALSE);
                     mgc_defense : carryOutDefenseMagic(item_kind._item_magic,FALSE);
                     mgc_summon : carryOutSummonMagic(item_kind._item_magic,FALSE);
                     mgc_cure : carryOutCureMagic(item_kind._item_magic,FALSE);
                     mgc_environment : carryOutEnvironmentMagic(item_kind._item_magic,FALSE);
                  end;
               end else begin
                  registerMessage(returnNumber,'MaHo-ga NaI..',DEFAULT_DELAY);
               end;
               getSomething(item_kind);
               use_result := TRUE;
            end;
}
            97 :
            begin
               returnEquipment(_weapon,remember_item);
               item_kind := item_data[__ITEM_SLING]^.data;
               item_kind._item_throw_power := item_kind._item_throw_power * 5;
               item_kind._item_shape := 197;
               setEquipment(_weapon,item_kind);
               use_result := attackSomething;
               setEquipment(_weapon,remember_item);
            end;
            98 : use_result := carryOutAttackMagic(20,FALSE)
            else begin
               registerMessage(returnNumber,' aw ae 巡 a.',DEFAULT_DELAY);
            end;
         end;
      end
      else begin
         registerMessage(returnNumber,' A aw a ?',DEFAULT_DELAY);
      end;
      if use_result = FALSE then getSomething(templet_item);
   end;
end;

procedure person_O.extractItems;
var
   temp_item : item_T;
   ET : equipment_T;

 procedure extractItemsSub;
 var
    temp_b : byte;
 begin
    if temp_item._item_number > 0 then begin
       convertItemToObject(temp_item._item_number,temp_b);
       setItemMap(returnX,returnY,temp_item);
    end;
 end;

begin

   for ET := succ(START_OF_EQUIPMENT) to pred(END_OF_EQUIPMENT) do begin
      if existEquipment(ET) then begin
         returnEquipment(ET,temp_item);
         extractItemsSub;
         fillchar(temp_item,sizeof(temp_item),#0);
         setEquipment(ET,temp_item);
      end;
   end;
   temp_item := item_data[0]^.data;
   setEquipment(_weapon,temp_item);

   while dropSomething(1,temp_item) do extractItemsSub;
end;

function person_O.doReaction(params : attack_parameters_T) : integer;
var
   i, j : integer;
   IT : internal_T;
   attacking_person, temp_b : byte;
   temp_item : item_T;
   temp_long : longint;
   s : string;
begin
   attacking_person := readMap(MA_PERSON,params.x_original,params.y_original);
   if attacking_person = returnInternal(_love) then exit;
   if person[attacking_person]^.returnInternal(_love) = returnNumber then exit;
   if attacking_person = returnNumber then exit;

   if attacking_person > 0 then begin
      if readMap(MA_PERSON,params.x_original,params.y_original) <> returnNumber then
         setInternal(_hostile,attacking_person);
      for j := -SCROLL_Y_WIDE to SCROLL_Y_WIDE do begin
         for i := -SCROLL_X_WIDE to SCROLL_X_WIDE do begin
            temp_b := readMap(MA_PERSON,_MAP_X_CENTER+i,_MAP_Y_CENTER+j);
            if temp_b > 0 then begin
               if person[temp_b]^.returnInternal(_love) = returnNumber then begin
                  person[temp_b]^.setInternal(_hostile,attacking_person);
               end
               else if person[temp_b]^.returnInternal(_love) = attacking_person then begin
                  person[temp_b]^.setInternal(_hostile,returnNumber);
               end else
               if (attacking_person = _MAIN_CHARACTER) and
                  (map_header.friendship_level = 0) then begin
                  person[temp_b]^.setInternal(_hostile,attacking_person);
               end;
            end;
         end;
      end;
   end;
   if (params.attack_type = _not_shown) and (params.trailing_count > 100) then begin
      case params.trailing_count of
         101 : begin
            IT := _fear_depth;
            s := 'A eA ava..';
         end;
         102 : begin
            IT := _paralisis_depth;
            s := ',  ii e heu !';
         end;
         103 : begin
            IT := _sleep_depth;
            s := 'aa~~  sa  ?..';
         end;
         104 : begin
            IT := _stonization_depth;
            s := ',   va..';
         end;
      end;
      j := returnInternal(IT) + params.power;
      if j > 10000 then j := 10000;
      if j < 0 then j := 0;
      setInternal(IT,j);
      if j > 0 then registerMessage(returnNumber,s,30);
      exit;
   end;
   if params.attack_attribute = _poisonous then begin
      if returnInternal(_antodote_body) > 0 then begin
         i := returnInternal(_antodote_body)-params.power;
         if i < 0 then i := 0;
         setInternal(_antodote_body,i);
      end else begin
         i := returnInternal(_poison_depth);
         i := i + params.power;
         if i > 10000 then i := 10000;
         setInternal(_poison_depth,i);
      end;
   end else begin
      if existEquipment(_shield) then begin
         returnEquipment(_shield,temp_item);
         i := temp_item._item_defense_power;
         if i > 0 then begin
            j := i * returnSkill(_shield_skill);
            j := round(j / 130); { 130 <== SHIELD CONSTANT }
            if random(100) < j then begin
               if random(10) = 0 then
               if random(100) > (returnAbility(_luck)) then begin
                  if returnSkill(_shield_skill) < 100 then
                     setSkill(_shield_skill,succ(returnSkill(_shield_skill)));
               end;
               doReaction := -1; { -1  <== INTERRUPTED BY SHIELD }
               exit;
            end;
         end;
      end;
      if existEquipment(_armor) then begin
         returnEquipment(_armor,temp_item);
         i := temp_item._item_defense_power;
         if i > 0 then begin
            temp_long := longint(i);
            temp_long := temp_long * longint(returnAbility(_level));
            j := round(temp_long / 10000);
            if j < 0 then j := 0;
            if j > 99 then j := 99;
            j := 100 - j;
            temp_long := longint(params.power);
            temp_long := temp_long * longint(j);
            params.power := round(temp_long / 100);
         end;
      end;
      if params.power > 0 then begin
         reduceHitPoint(params.power);
         doReaction := 1; { 1 <== Attack Successfully }
      end
      else
         doReaction := -2; { -2  <== INTERRUPTED BY ARMOR }
   end;
end;

function person_O.selectItemADVANCED(message : string) : integer;
const
   EXTRA_EDGE = 4;
   ASDF = 7;
   START_X = 46 * 8;
var
   Twindow : ^titled_window_O;
   i, key_in : integer;
   item_kind : item_T;
   cursor : byte;
   absolute_cursor : byte;
   x1, y1 : integer;
   START_Y, window_y : integer;

 procedure drawCursor(is_visible : boolean);
 begin
    if is_visible then
       setColor(YELLOW)
    else
       setColor(BLACK);
    Rectangle(START_X+(cursor mod ASDF)*32-1,START_Y+(cursor div ASDF)*32-1,
              START_X+(cursor mod ASDF)*32+25,START_Y+(cursor div ASDF)*32+25);
 end;

begin
   window_y := 9 - ((returnMaxInventory - 1) div ASDF);

   START_Y := (window_y + 2) * 16;

   if returnMaxInventory > 0 then begin
      new(Twindow,init(45,window_y,73,window_y+4+((returnMaxInventory - 1) div ASDF) * 2,0,TRUE,1,''));

      setHanColor(0);
      setHanMode(PIXEL_UNIT_MODE);
      printHangul(59*8-EXTRA_EDGE- (length(message)-1) * 4 +4,window_y * 16 - 34,message);
      setHanColor(11);
      setHanMode(QUICK_MODE);
      printHangulOUTLINE(59*8-EXTRA_EDGE- (length(message)-1) * 4,window_y * 16 - 38,message,8);

      cursor := 0;
      i := 0;
      while (i < returnMaxInventory) do begin
         returnInventory(i+1,item_kind);
         if item_kind._item_type > START_OF_EQUIPMENT then
            printImageDIRECT(START_X+(i mod ASDF)*32,START_Y+(i div ASDF)*32,
                             equipment_tile_data[item_kind._item_number]^)
         else
            printImageDIRECT(START_X+(i mod ASDF)*32,START_Y+(i div ASDF)*32,
                             object_tile_data[item_kind._item_number]^);
         inc(i);
      end;
      returnInventory(cursor+1,item_kind);
      Twindow^.setTitle(returnItemName(item_kind,TRUE));
      Twindow^.drawAuxWindow;
      drawCursor(TRUE);
      key_in := 0;
      while not (byte(key_in) in [ACCEPT_KEY,ESCAPE_KEY]) do begin
         key_in := getKey;
         x1 := 0; y1 := 0;
         case key_in of
            UP_KEY    : y1 := -1;
            DOWN_KEY  : y1 := 1;
            LEFT_KEY  : x1 := -1;
            RIGHT_KEY : x1 := 1;
         end;
         if (x1 <> 0) or (y1 <> 0) then begin
            drawCursor(FALSE);
            if ((cursor + ASDF * y1 + x1) >= 0) and
               ((cursor + ASDF * y1 + x1) <= returnMaxInventory-1) then
               cursor := cursor + ASDF * y1 + x1;
            drawCursor(TRUE);
            returnInventory(cursor+1,item_kind);
            Twindow^.setTitle(returnItemName(item_kind,TRUE));
            Twindow^.drawAuxWindow;
         end;
      end;
      if key_in = ACCEPT_KEY then begin
         selectItemADVANCED := cursor + 1;
      end else
         selectItemADVANCED := 0;
      dispose(Twindow,done);
   end else
      selectItemADVANCED := 0;
end;

procedure person_O.equipSomething;
var
   i, j   : integer;
   weight : word;
   s      : string;
   success: boolean;
   selected_menu, max_menu : integer;
   item_kind, equipment    : item_T;
begin
   success := TRUE;
   selected_menu := selectItemADVANCED('wb i i a');

   if selected_menu > 0 then begin
      dropSomething(selected_menu,item_kind);
      if item_kind._item_contain > 1 then begin
         item_kind._item_contain := item_kind._item_contain - 1;
         getSomething(item_kind);
         item_kind._item_contain := 1;
      end;
      if item_kind._item_type > START_OF_EQUIPMENT then begin
         weight := getCurrentWeight + item_kind._item_weight;
         if existEquipment(item_kind._item_type) then begin
            returnEquipment(item_kind._item_type,equipment);
            dec(weight,equipment._item_weight);
            if weight * 10 <= returnAbility(_strength) then begin
               getSomething(equipment);
               setEquipment(item_kind._item_type,item_kind);
            end else begin
               getSomething(item_kind);
               success := FALSE;
            end;
         end else begin
            if weight * 10 <= returnAbility(_strength) then begin
               setEquipment(item_kind._item_type,item_kind);
            end else begin
               getSomething(item_kind);
               success := FALSE;
            end;
         end;
      end else begin
         getSomething(item_kind);
      end;
      if not success then begin
         printMessageWindow('A w Aa ᢁ g asa');
      end;
   end;
end;

procedure person_O.disarmSomething;
const
   START_X = 272;
   START_Y = 115;
   ASDF = 3;
   ZXCV = 4;
   arrange_data : array[1..ASDF,1..ZXCV] of equipment_T = (
      (_money, _weapon, _gauntlet, _food),
      (_helmet, _neck, _armor, _shoes),
      (_left_hand, _shield, _finger, _useless));
var
   ET : equipment_T;
   temp_item : item_T;
   i, j, cursor, key_in : integer;
   x1, y1 : integer;

 procedure drawCursor(is_visible : boolean);
 begin
    if is_visible then
       setColor(LightCyan)
    else
       setColor(BLACK);

    Rectangle(START_X+(cursor mod ASDF)*32,
              START_Y+(cursor div ASDF)*32,
              START_X+(cursor mod ASDF)*32+23,
              START_Y+(cursor div ASDF)*32+23);
 end;

 procedure displayItemName;
 const
    DRAW_X = START_X-60;
    DRAW_Y = START_Y-30;
 var
    s : string;
 begin
    drawBox(DRAW_X,DRAW_Y,DRAW_X+210,DRAW_Y+20,1,FALSE,FALSE);
    setHanColor(YELLOW);
    s := returnItemName(temp_item,TRUE);
    printHangul(320 - (length(s)+1) * 4,DRAW_Y+2,s);
    setHanColor(WHITE);
 end;

 procedure displayWeight;
 const
    DRAW_X = START_X-60;
    DRAW_Y = START_Y+ZXCV*32;
 var
    s : string;
 begin
    drawBox(DRAW_X+50,DRAW_Y,DRAW_X+160,DRAW_Y+20,2,FALSE,FALSE);
    str((getCurrentWeight / 10) : 3:1,s);
    s := s + ' KG';
    setHanColor(WHITE);
    printHangul(320 - (length(s)+1) * 4,DRAW_Y+2,s);
 end;

 procedure displayAll(init_cursor : integer);
 var
    i,j : integer;
 begin
     drawBox(START_X-60,START_Y-55,START_X+150,START_Y-35,2,FALSE,FALSE);
     setHanColor(WHITE);
     printHangul(START_X-60+10,START_Y-55+2,' ЁA i wi a');
     for j := 1 to ZXCV do
     for i := 1 to ASDF do begin
       cursor := (j-1) * ASDF + (i-1);
       returnEquipment(arrange_data[i,j],temp_item);
       if (temp_item._item_type > START_OF_EQUIPMENT) and
          (temp_item._item_number > 0) then
          printImageDIRECT(START_X+(i-1)*32,START_Y+(j-1)*32,
                           equipment_tile_data[temp_item._item_number]^)
       else
          drawCursor(FALSE);
    end;
    cursor := init_cursor;
    drawCursor(TRUE);
    returnEquipment(arrange_data[cursor mod ASDF+1,cursor div ASDF+1],temp_item);
    displayItemName;
 end;

begin
   displayAll(4);
   key_in := 0;
   while key_in <> ESCAPE_KEY do begin
      displayWeight;
      key_in := getKey;
      x1 := 0; y1 := 0;
      case key_in of
         UP_KEY    : y1 := -1;
         DOWN_KEY  : y1 := 1;
         LEFT_KEY  : x1 := -1;
         RIGHT_KEY : x1 := 1;
      end;
      if (x1 <> 0) or (y1 <> 0) then begin
         drawCursor(FALSE);
         cursor := cursor + ASDF * y1 + x1;
         if not (cursor in [0..ASDF*ZXCV-1]) then
            cursor := cursor - ASDF * y1 - x1;
         drawCursor(TRUE);
         returnEquipment(arrange_data[cursor mod ASDF+1,cursor div ASDF+1],temp_item);
         displayItemName;
      end;
      if key_in = ACCEPT_KEY then begin
         ET := arrange_data[cursor mod ASDF+1,cursor div ASDF+1];
         returnEquipment(ET,temp_item);
         if (temp_item._item_type > START_OF_EQUIPMENT) and
            (temp_item._item_number > 0) then begin
            if getSomething(temp_item) then begin
               if ET = _weapon then
                  temp_item := item_data[0]^.data
               else
                  fillchar(temp_item,sizeof(temp_item),#0);
               setEquipment(ET,temp_item);
               flipPageEASY;
               displayAll(cursor);
            end;
         end;
      end;
   end;
   flipPageEASY;
end;

procedure person_O.viewPerson;
var
   params : attack_parameters_T;
begin
   with params do begin
      attack_type := _not_shown;
      x_source := returnX;
      y_source := returnY;
      x_destination := returnX;
      y_destination := returnY;
      shape_revolution := 1;
   end;
   attackObject(params,params);
end;

function  person_O.getCurrentWeight : word;
var
   ET : equipment_T;
   return_item : item_T;
   weight : word;
begin
   weight := 0;
   for ET := succ(START_OF_EQUIPMENT) to pred(END_OF_EQUIPMENT) do begin
      if existEquipment(ET) then begin
         returnEquipment(ET,return_item);
         if return_item._item_suffix <> __SUFFIX_ALBIREO then begin
            if return_item._item_suffix <> __SUFFIX_FEATHER then
               inc(weight,return_item._item_weight)
            else
               inc(weight,return_item._item_weight div 2);
         end;
      end;
   end;
   getCurrentWeight := weight;
end;

procedure person_O.modifyEquipment;
begin
end;

procedure person_O.modifyInternalValue;
begin
   setInternal(_hit_point,returnMaxAvailHitPoint);
   setInternal(_spell_point,returnMaxAvailSpellPoint);
end;

constructor simple_person_O.init;
begin
   inherited init(number,face,person_attribute,face_attribute,name,max_frame,initialize_position);
   fillChar(m_inventory_stack,sizeof(m_inventory_stack),#0);
end;

destructor simple_person_O.done;
begin
   inherited done;
end;

procedure simple_person_O.setInventory(inventory : integer; item : item_T);
begin
   m_inventory_stack[inventory] := item;
end;

procedure simple_person_O.returnInventory(inventory : integer; var return_item : item_T);
begin
   return_item := m_inventory_stack[inventory];
end;

function simple_person_O.returnInventoryType(inventory : byte) : equipment_T;
begin
   returnInventoryType := m_inventory_stack[inventory]._item_type;
end;

function simple_person_O.returnInventoryNumber(inventory : byte) : integer;
begin
   returnInventoryNumber := m_inventory_stack[inventory]._item_number;
end;

function simple_person_O.returnMaxBackPack : byte;
begin
   returnMaxBackPack := MAX_BACK_PACK div 10;
end;

constructor complete_person_O.init;
begin
   inherited init(number,face,person_attribute,face_attribute,name,max_frame,initialize_position);
   fillChar(m_inventory_stack,sizeof(m_inventory_stack),#0);
end;

destructor complete_person_O.done;
begin
   inherited done;
end;

procedure complete_person_O.setInventory(inventory : integer; item : item_T);
begin
   m_inventory_stack[inventory] := item;
end;

procedure complete_person_O.returnInventory(inventory : integer; var return_item : item_T);
begin
   return_item := m_inventory_stack[inventory];
end;

function complete_person_O.returnInventoryType(inventory : byte) : equipment_T;
begin
   returnInventoryType := m_inventory_stack[inventory]._item_type;
end;

function complete_person_O.returnInventoryNumber(inventory : byte) : integer;
begin
   returnInventoryNumber := m_inventory_stack[inventory]._item_number;
end;

function complete_person_O.returnMaxBackPack : byte;
begin
   returnMaxBackPack := MAX_BACK_PACK;
end;

function person_O.doAction : boolean;

 function returnSign(obj : integer) : integer;
 begin
    if obj = 0 then returnSign := 0
    else if obj > 0 then returnSign := 1
    else returnSign := -1;
 end;

var
   i, j, k : integer;
   s : string;
   x_vector, y_vector, x_event, y_event : integer;
   x_range, y_range, turn_face : integer;
   window : ^window_O;
   temp_longint : longint;
   temp_walk_var, temp_b : byte;
   temp_item : item_T;
begin

   doAction := TRUE;

   if returnNumber = _MAIN_CHARACTER then begin

      with game_system do begin
         temp_longint := setCurrentTime;
         if (abs(getPreviousTime - temp_longint) > 20) then begin
            unlockMovement;
            setPreviousTime(temp_longint);
         end
         else lockMovement;
         if (getSystemCount mod 10) = 0 then begin
            if (not canWalkAll) and (temp_walk_var = 0) then begin
               temp_walk_var := 1;
               setWalkAll(TRUE);
            end else begin
               setWalkAll(FALSE);
            end;
         end else begin
            setWalkAll(FALSE);
            temp_walk_var := 0;
         end;
      end;

   end;

   key_code := 0;
   if returnNumber > MAX_PERSON_ARRAY then exit;
{
   if game_system.canWalkAll then doWalking;
}
   if returnInternal(_sleep_depth) > 0 then begin
      if random(5) = 0 then exit;
   end;

   if returnInternal(_paralisis_depth) > 0 then begin
      if random(2) = 0 then exit;
   end;

   if returnInternal(_stonization_depth) > 0 then begin
      if random(20) <> 0 then exit;
   end;

   if (returnInternal(_hit_point) < 0) or
      (returnInternal(_unconscious_depth) > 0) or
      (returnInternal(_death_depth) > 0) then begin
      if (returnNumber = _MAIN_CHARACTER) then begin
         if returnInternal(_death_depth) > 0 then begin
            DVPersn1.loadGame(TRUE);
            {
            cheatGame(SELF);
            }
         end else begin
            with game_system do begin
               unlockMovement;
               setPreviousTime(setCurrentTime);
            end;
         end;
      end;
      if (returnInternal(_death_depth) > returnMaxAvailHitPoint) or
         not (returnPersonAttribute in [mgc_player]) then begin
         for i := 1 to max_person do begin
            if person[i] <> nil then begin
               if person[i]^.returnInternal(_hostile) = returnNumber then
                  person[i]^.setInternal(_hostile,0);
               if person[i]^.returnInternal(_love) = returnNumber then
                  person[i]^.setInternal(_love,0);
            end;
         end;
         invoid_person_movement_data := invoid_person_movement_data - [returnNumber];
         talkable_person := talkable_person - [returnNumber];
         if returnPersonAttribute = mgc_thing then begin
            temp_b := returnFace;
         end
         else if returnPersonAttribute = mgc_player then begin
            temp_b := returnFace-1+__OBJECT_DEATH_BODY;
         end
         else
            temp_b := 0;
         if readMap(MA_OBJECT,returnX,returnY) > 0 then begin
            convertObjectToItem(temp_b,temp_item);
            setItemMap(returnX,returnY,temp_item);
         end else begin
            writeMap(MA_OBJECT,returnX,returnY,temp_b);
         end;
         extractItems;
         i := returnNumber;
         removePersonMessage(i);
         doAction := FALSE;
      end else doWalking;

      exit;
   end;

   if returnInternal(_hostile) > 0 then begin
      if person[returnInternal(_hostile)] = nil then begin
         setInternal(_hostile,0);
      end else if person[returnInternal(_hostile)]^.returnInternal(_death_depth) > 0 then begin
         setInternal(_hostile,0);
      end;
      if returnInternal(_hostile) = returnNumber then begin
         setInternal(_hostile,0);
      end;
      if returnInternal(_hostile) = returnInternal(_love) then begin
         setInternal(_hostile,0);
      end;
   end;

   if (returnNumber = _MAIN_CHARACTER) then begin

      if KeyPressed then begin
         key_code := ord(readKey);
         if chr(key_code) in ['A'..'Z'] then key_code := key_code + (ord('a')-ord('A'));
         if key_code = 0 then key_code := SCAN_CODE + ord(readKey);
         if key_code =MOVE_KEY then begin
            i := i;
         end;
         user_key := key_code;
      end else exit;
      if (returnInternal(_fear_depth) > 0) and (random(4) = 0) then begin
         x_vector := returnSign(person[returnInternal(_hostile)]^.returnX - returnX);
         y_vector := returnSign(person[returnInternal(_hostile)]^.returnY - returnY);
         if random(2) = 0 then begin
            if isMovableMap(returnX+x_vector,returnY) then begin
               if x_vector > 0 then key_code := LEFT_KEY
                               else key_code := RIGHT_KEY;
            end else begin
               if isMovableMap(returnX,returnY+y_vector) then begin
                  if y_vector > 0 then key_code := UP_KEY
                                  else key_code := DOWN_KEY;
               end;
            end;
         end else begin
            if isMovableMap(returnX,returnY+y_vector) then begin
               if y_vector > 0 then key_code := UP_KEY
                               else key_code := DOWN_KEY;
            end else begin
               if isMovableMap(returnX+x_vector,returnY) then begin
                  if x_vector > 0 then key_code := LEFT_KEY
                                  else key_code := RIGHT_KEY;
               end;
            end;
         end;
      end;

   end

   else if not game_system.enableToMove then begin
      (*  AHN YOUNG-KIE IS A GENIUS.
          YOUNG-KIE GA I TSI BAN I I YO *)
      exit;
   end

   else if (returnInternal(_fear_depth) > 0) and
           (abs(person[returnInternal(_hostile)]^.returnX-returnX) < 2*SCROLL_X_WIDE) and
           (abs(person[returnInternal(_hostile)]^.returnY-returnY) < 2*SCROLL_Y_WIDE) then begin

         x_vector := returnSign(person[returnInternal(_hostile)]^.returnX - returnX);
         y_vector := returnSign(person[returnInternal(_hostile)]^.returnY - returnY);
         if random(2) = 0 then begin
            if isMovableMap(returnX+x_vector,returnY) then begin
               if x_vector > 0 then key_code := LEFT_KEY
                               else key_code := RIGHT_KEY;
            end else begin
               if isMovableMap(returnX,returnY+y_vector) then begin
                  if y_vector > 0 then key_code := UP_KEY
                                  else key_code := DOWN_KEY;
               end;
            end;
         end else begin
            if isMovableMap(returnX,returnY+y_vector) then begin
               if y_vector > 0 then key_code := UP_KEY
                               else key_code := DOWN_KEY;
            end else begin
               if isMovableMap(returnX+x_vector,returnY) then begin
                  if x_vector > 0 then key_code := LEFT_KEY
                                  else key_code := RIGHT_KEY;
               end;
            end;
         end;
   end

   else if (returnInternal(_hostile) > 0) and
      (abs(person[returnInternal(_hostile)]^.returnX-returnX) < 2*SCROLL_X_WIDE) and
      (abs(person[returnInternal(_hostile)]^.returnY-returnY) < 2*SCROLL_Y_WIDE) then begin

      detectAvailableAttackRange(x_range,y_range);
      if (abs(person[returnInternal(_hostile)]^.returnX-returnX) <= x_range) and
         (abs(person[returnInternal(_hostile)]^.returnY-returnY) <= y_range) then begin
         if ((abs(_MAP_X_CENTER - returnX) <= SCROLL_X_WIDE) and
            (abs(_MAP_Y_CENTER - returnY) <= SCROLL_Y_WIDE)) or
            ((abs(_MAP_X_CENTER - person[returnInternal(_hostile)]^.returnX) <= SCROLL_X_WIDE) and
            (abs(_MAP_Y_CENTER - person[returnInternal(_hostile)]^.returnY) <= SCROLL_Y_WIDE)) then begin
            key_code := ATTACK_KEY;
         end;
      end else begin

       j := abs(returnX-person[returnInternal(_hostile)]^.returnX);
       if j < abs(returnY-person[returnInternal(_hostile)]^.returnY) then
          j := abs(returnY-person[returnInternal(_hostile)]^.returnY);

       i := 0;
       if (returnMaxAvailSpellPoint > 1000) then begin
          if castMagicAUTO(j) then i := 1;
       end;

       if i = 0 then begin
         x_vector := returnSign(person[returnInternal(_hostile)]^.returnX - returnX);
         y_vector := returnSign(person[returnInternal(_hostile)]^.returnY - returnY);
         i := abs(person[returnInternal(_hostile)]^.returnX - returnX);
         j := abs(person[returnInternal(_hostile)]^.returnY - returnY);
         if random(i+j) < i then begin
            if isSafeMovableMap(returnX+x_vector,returnY) then begin
               if x_vector > 0 then key_code := RIGHT_KEY
                               else key_code := LEFT_KEY;
            end else begin
               if y_vector = 0 then y_vector := random(2)*2-1;
               if isSafeMovableMap(returnX,returnY+y_vector) then begin
                  if y_vector > 0 then key_code := DOWN_KEY
                                  else key_code := UP_KEY;
               end;
            end;
         end else begin
            if isSafeMovableMap(returnX,returnY+y_vector) then begin
               if y_vector > 0 then key_code := DOWN_KEY
                               else key_code := UP_KEY;
            end else begin
               if x_vector = 0 then x_vector := random(2)*2-1;
               if isSafeMovableMap(returnX+x_vector,returnY) then begin
                  if x_vector > 0 then key_code := RIGHT_KEY
                                  else key_code := LEFT_KEY;
               end;
            end;
         end;
       end;
      end;
   end

   else if (returnInternal(_love) > 0) and (abs(person[returnInternal(_love)]^.returnX-returnX) < 2*SCROLL_X_WIDE) and
           (abs(person[returnInternal(_love)]^.returnY-returnY) < 2*SCROLL_Y_WIDE) then begin

      if person[returnInternal(_love)]^.returnInternal(_death_depth) > 0 then begin
         setInternal(_love,0);
         exit;
      end;

      if (abs(person[returnInternal(_love)]^.returnX-returnX) <= 1) and
         (abs(person[returnInternal(_love)]^.returnY-returnY) <= 1) then exit;

      x_vector := returnSign(person[returnInternal(_love)]^.returnX - returnX);
      y_vector := returnSign(person[returnInternal(_love)]^.returnY - returnY);
      i := abs(person[returnInternal(_love)]^.returnX - returnX);
      j := abs(person[returnInternal(_love)]^.returnY - returnY);
      if random(i+j) <= i then begin
         if isSafeMovableMap(returnX+x_vector,returnY) then begin
            if x_vector > 0 then key_code := RIGHT_KEY
                            else key_code := LEFT_KEY;
         end else begin
            if isSafeMovableMap(returnX,returnY+y_vector) then begin
               if y_vector > 0 then key_code := DOWN_KEY
                               else key_code := UP_KEY;
            end;
         end;
      end else begin
         if isSafeMovableMap(returnX,returnY+y_vector) then begin
            if y_vector > 0 then key_code := DOWN_KEY
                            else key_code := UP_KEY;
         end else begin
            if isSafeMovableMap(returnX+x_vector,returnY) then begin
               if x_vector > 0 then key_code := RIGHT_KEY
                               else key_code := LEFT_KEY;
            end;
         end;
      end;
   end

   else if (person_movement_data[returnNumber].number_of_movement > 0) and
           (returnNumber in invoid_person_movement_data) then begin
      with person_movement_data[returnNumber] do begin
         x_vector := 0;
         y_vector := 0;
         turn_face := 0;
         if which_movement = 0 then begin
            if (next_movement_carry > 0) then begin
               if (next_movement_hour > game_system.returnHour) then begin
                  next_movement_carry := 0;
               end;
            end else if (next_movement_hour <= game_system.returnHour) then begin
               j := 0;
               for i := 1 to number_of_movement do begin
                  if movement[i].from_hour < movement[i].to_hour then begin
                     if game_system.returnHour in [movement[i].from_hour..movement[i].to_hour-1] then begin
                        j := i;
                     end;
                  end else begin
                     if not(game_system.returnHour in [movement[i].to_hour..movement[i].from_hour-1]) then begin
                        j := i;
                     end;
                  end;
               end;
               if j > 0 then
                  which_movement := j;
               movement[which_movement].which_position := 1;
            end;
         end;
         if which_movement > 0 then begin
            x_vector := movement[which_movement].position[movement[which_movement].which_position][1];
            y_vector := movement[which_movement].position[movement[which_movement].which_position][2];
            if (returnX = x_vector) and (returnY = y_vector) then begin
               if movement[which_movement].which_position >=
                  movement[which_movement].number_of_position then begin
                  if final_face[which_movement] > 0 then begin
                     setFaceCount(final_face[which_movement]);
                  end;
                  if which_movement >= number_of_movement then begin
                     which_movement := 1;
                     next_movement_hour := movement[which_movement].from_hour;
                     next_movement_carry := 0;
                  end else begin
                     if which_movement = 1 then
                        next_movement_carry := 1
                     else
                        next_movement_carry := 0;
                     inc(which_movement);
                     next_movement_hour := movement[which_movement].from_hour;
                  end;
                  which_movement := 0;
                  x_vector := 0;
                  y_vector := 0;
               end else begin
                  inc(movement[which_movement].which_position);
                  x_vector := movement[which_movement].position[movement[which_movement].which_position][1];
                  y_vector := movement[which_movement].position[movement[which_movement].which_position][2];
                  if movement[which_movement].which_position =
                     movement[which_movement].number_of_position then begin
                     turn_face := final_face[which_movement];
                  end;
               end;
            end;
         end;
      end;
      if (x_vector <> 0) or (y_vector <> 0) then begin
         if ((abs(returnX - person[_MAIN_CHARACTER]^.returnX) in [0..SCROLL_X_WIDE]) and
            (abs(returnY - person[_MAIN_CHARACTER]^.returnY) in [0..SCROLL_Y_WIDE])) or
            ((abs(x_vector - person[_MAIN_CHARACTER]^.returnX) in [0..SCROLL_X_WIDE]) and
            (abs(y_vector - person[_MAIN_CHARACTER]^.returnY) in [0..SCROLL_Y_WIDE])) then begin
            x_vector := x_vector - returnX;
            y_vector := y_vector - returnY;
            if abs(x_vector) > abs(y_vector) then begin
               if isSafeMovableMap(returnX+returnSign(x_vector),returnY) then begin
                  if returnSign(x_vector) > 0 then key_code := RIGHT_KEY;
                  if returnSign(x_vector) < 0 then key_code := LEFT_KEY;
               end else begin
                  if returnSign(y_vector) = 0 then begin
                     if random(2) = 0 then y_vector := 1
                                      else y_vector := -1;
                  end;
                  if isSafeMovableMap(returnX,returnY+returnSign(y_vector)) then begin
                     if returnSign(y_vector) > 0 then key_code := DOWN_KEY;
                     if returnSign(y_vector) < 0 then key_code := UP_KEY;
                  end;
               end;
            end else begin
               if isSafeMovableMap(returnX,returnY+returnSign(y_vector)) then begin
                  if returnSign(y_vector) > 0 then key_code := DOWN_KEY;
                  if returnSign(y_vector) < 0 then key_code := UP_KEY;
               end else begin
                  if returnSign(x_vector) = 0 then begin
                     if random(2) = 0 then x_vector := 1
                                      else x_vector := -1;
                  end;
                  if isSafeMovableMap(returnX+returnSign(x_vector),returnY) then begin
                     if returnSign(x_vector) > 0 then key_code := RIGHT_KEY;
                     if returnSign(x_vector) < 0 then key_code := LEFT_KEY;
                  end;
               end;
            end;
         end else begin
            writeMap(MA_PERSON,returnX,returnY,0);
            setX(x_vector);
            setY(y_vector);
            writeMap(MA_PERSON,returnX,returnY,returnNumber);
            if turn_face > 0 then setFaceCount(turn_face);
         end;
      end;
   end;

   x_vector := 0;
   y_vector := 0;

   case key_code of
      UP_KEY : begin
         y_vector := -1;
         if returnFaceCount = 6 then setFaceCount(6) else setFaceCount(7);
      end;
      DOWN_KEY : begin
         y_vector := 1;
         if returnFaceCount = 0 then setFaceCount(0) else setFaceCount(1);
      end;
      LEFT_KEY : begin
         x_vector := -1;
         if returnFaceCount = 2 then setFaceCount(2) else setFaceCount(3);
      end;
      RIGHT_KEY : begin
         x_vector := 1;
         if returnFaceCount = 4 then setFaceCount(4) else setFaceCount(5);
      end;
      CHEAT_KEY  : if ENABLE_CHEATING then cheatGame(person[returnNumber]^);
      ord('?')   : if ENABLE_CHEATING then game_system.passTime(0,0,30,0);
      ord('<') : if ENABLE_CHEATING then begin
         addMagicAll('(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27)::::');
         addMagicAll(':(1,2,3,4,5,6,7,8,9):(1,2,3,4,5,6,7,8,9):(1,2,3,4,5,6,7,8,9,10,11,12,13,14):');
         addMagicAll('::::(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25)');
      end;
      ord('>') : if ENABLE_CHEATING then begin
         person[_MAIN_CHARACTER]^.setAbility(_level,returnAbility(_level)+1000);
      end;
      MENU_KEY   : selectMainMenu;
      ESCAPE_KEY : selectShortMenu;
      HELP_KEY   : displayHelpWindow;
      VIEW_ALL_CONDITION_KEY :
         if game_system.enableHPGauge then game_system.setHPGause(FALSE)
                                      else game_system.setHPGause(TRUE);
      MOVE_KEY : moveObject(person[returnNumber]^);
      GET_KEY : getObject(person[returnNumber]^);
      DROP_KEY : dropObject(person[returnNumber]^);
      EQUIP_KEY : equipSomething;
      DISARM_KEY : disarmSomething;
      LOOK_KEY : lookObject(person[returnNumber]^);
      VIEW_KEY : lookProfile(Self);
      ATTACK_KEY : attackSomething;
      SLEEP_KEY : sleepHere(person[returnNumber]^);
      CAST_MAGIC_KEY : castMagic;
      USE_KEY : useItem;
      BATTLE_KEY :
      begin
         for y_vector := -SCROLL_Y_WIDE to SCROLL_Y_WIDE do
          for x_vector := -SCROLL_X_WIDE to SCROLL_X_WIDE do begin
            k := readMap(MA_PERSON,_MAP_X_CENTER+x_vector,_MAP_Y_CENTER+y_vector);
            if k > 0 then
             if person[k]^.returnInternal(_love) = returnNumber then begin
               for j := -SCROLL_Y_WIDE to SCROLL_Y_WIDE do
                for i := -SCROLL_X_WIDE to SCROLL_X_WIDE do begin
                  if test_map[i,j] <> 0 then begin
                     temp_b := readMap(MA_PERSON,_MAP_X_CENTER+i,_MAP_Y_CENTER+j);
                     if temp_b > 0 then begin
                        if person[temp_b]^.returnInternal(_hostile) = _MAIN_CHARACTER then
                           person[k]^.setInternal(_hostile,temp_b);
                     end;
                  end;
               end;
            end;
         end;
         x_vector := 0; y_vector := 0;
         registerMessage(_MAIN_CHARACTER,'aa !',DEFAULT_DELAY);
      end;
      ord('+') : increaseScreenWide;
      ord('-') : decreaseScreenWide;
   end;

   if (x_vector <> 0) or (y_vector <> 0) then begin
      writeMap(MA_PERSON,returnX,returnY,0);
      setX(returnX + x_vector);
      setY(returnY + y_vector);

      if not (returnX in [0..game_system.returnMapXMax-1]) or
         not (returnY in [0..game_system.returnMapYMax-1]) then begin
         if returnNumber = _MAIN_CHARACTER then begin
            if map_header.enable_boundary_exit then begin
               if verifyExitMap(0,0) then exit;
            end;
         end;
         setX(returnX - x_vector);
         setY(returnY - y_vector);
         writeMap(MA_PERSON,returnX,returnY,returnNumber);
         exit;
      end;
      if readMap(MA_NORMAL,returnX,returnY) in STAIRS_TILE then begin
         if returnNumber = _MAIN_CHARACTER then begin
            if verifyExitMap(returnX,returnY) then begin
               writeMap(MA_PERSON,returnX,returnY,returnNumber);
               scrollMap; flipPage;
               exit;
            end;
         end;
      end;

      if isMovableMap(returnX,returnY) or
         ((returnInternal(_levitation) > 0) and (isPassableMap(returnX,returnY))) then begin

         doWalking;

         if not isMovableMap(returnX,returnY) then begin
            k := returnInternal(_levitation) - 1;
            setInternal(_levitation,k);
            str(k,s);
            registerMessage(returnNumber,'w '+s+' qv.',DEFAULT_DELAY);
         end;

         if ((readMap(MA_ATTRIBUTE,returnX,returnY) and EVENT_BIT) in [1..2]) then begin
            if returnNumber = _MAIN_CHARACTER then begin
               x_event := returnX;
               y_event := returnY;
               if (readMap(MA_ATTRIBUTE,returnX,returnY) and $02) > 0 then begin
                  setX(returnX - x_vector);
                  setY(returnY - y_vector);
               end;
               writeMap(MA_PERSON,returnX,returnY,returnNumber);
               scrollMap;
               flipPage;
               _PERSON_CONTROLL_CODE := OCCUR_EVENT;
               _EVENT_X_POSITION := x_event;
               _EVENT_Y_POSITION := y_event;
            end else begin
               if (readMap(MA_ATTRIBUTE,returnX,returnY) and $02) > 0 then begin
                  if returnNumber = _MAIN_CHARACTER then begin
                     setX(returnX - x_vector);
                     setY(returnY - y_vector);
                  end;
               end;
            end;
         end;

      end else begin
         if readMap(MA_PERSON,returnX,returnY) > 0 then begin
            if person[readMap(MA_PERSON,returnX,returnY)]^.returnInternal(_love) = returnNumber then begin
               person[readMap(MA_PERSON,returnX,returnY)]^.setX(returnX - x_vector);
               person[readMap(MA_PERSON,returnX,returnY)]^.setY(returnY - y_vector);
               with person[readMap(MA_PERSON,returnX,returnY)]^ do
                  writeMap(MA_PERSON,returnX,returnY,returnNumber);
               writeMap(MA_PERSON,returnX,returnY,returnNumber);
               exit;
            end;
         end;
         setX(returnX - x_vector);
         setY(returnY - y_vector);

         doWalking;

         if (readMap(MA_PERSON,returnX+x_vector,returnY+y_vector) > 0) and
            (readMap(MA_OBJECT,returnX+x_vector,returnY+y_vector) <> 2) and
            (returnNumber = _MAIN_CHARACTER) then begin
            writeMap(MA_PERSON,returnX,returnY,returnNumber);
            _PERSON_CONTROLL_CODE := OCCUR_TALK;
            _TALK_PERSON := readMap(MA_PERSON,returnX+x_vector,returnY+y_vector);
         end;
      end;
      writeMap(MA_PERSON,returnX,returnY,returnNumber);
   end else begin
      doWalking;
   end;

   if returnNumber = _MAIN_CHARACTER then begin
      with game_system do begin
         unlockMovement;
         setPreviousTime(setCurrentTime);
      end;
   end;
end;

procedure scrollMap;
label
   END_LIGHT_EFFECT, SCROLL_MAIN;
const
   test_map_data : array[0..7,0..1] of integer = (
            (1,-1),(-1,-1),(0,-1),(1,0),
            (1,1),(-1,1),(-1,0),(0,1));
   TAG_WIDTH = 8;
var
   X_CENTER, Y_CENTER : byte;
   i, j, k, x_temp, y_temp, x_new, y_new : integer;
   map_index, temp_b, aux_b : byte;
   MA : map_attribute_T;
   ET : equipment_T;
   return_face : integer;
   c : char;
   tested : boolean;
   PASSABLE_TILE : setBYTE;
   x_light_range, y_light_range : byte;
   dark_effect : boolean;
   message_x, message_y : integer;
   HP_rate : longint;
   color : word;
   remember_HT : han_type_T;

begin

   while KeyPressed do c := readkey;

   X_CENTER := SCROLL_X_WIDE;
   Y_CENTER := SCROLL_Y_WIDE;

(*  Boundary Test  *)

   x_new := person[_MAIN_CHARACTER]^.returnX;
   y_new := person[_MAIN_CHARACTER]^.returnY;
   if x_new < SCROLL_X_WIDE then x_new := SCROLL_X_WIDE;
   if x_new > (game_system.returnMapXMax-1) - SCROLL_X_WIDE then
      x_new := (game_system.returnMapXMax-1) - SCROLL_X_WIDE;
   if y_new < SCROLL_Y_WIDE then y_new := SCROLL_Y_WIDE;
   if y_new > (game_system.returnMapYMax-1) - SCROLL_Y_WIDE then
      y_new := (game_system.returnMapYMax-1) - SCROLL_Y_WIDE;
   _MAP_X_CENTER := x_new;
   _MAP_Y_CENTER := y_new;

   if person[_MAIN_CHARACTER]^.returnInternal(_transparency) > 0 then begin
      person[_MAIN_CHARACTER]^.setInternal(_transparency,
                               person[_MAIN_CHARACTER]^.returnInternal(_transparency)-1);
      fillChar(test_map,sizeof(test_map),#2);
      goto SCROLL_MAIN;
   end;

(*  View Effect Test  *)

   fillChar(test_map,sizeof(test_map),0);

 if map_header.tile_data_file = 'tile' then begin

   PASSABLE_TILE := MOVABLE_TILE + FOREGROUND_TILE + [92..95] - [105,107,125,127]; { 105,125 NORMAL TILE IS A SPECIAL CASE }

   test_map[person[_MAIN_CHARACTER]^.returnX-x_new,person[_MAIN_CHARACTER]^.returnY-y_new] := 255;
   repeat
      tested := FALSE;
      for j := -SCROLL_Y_WIDE-1 to SCROLL_Y_WIDE+1 do
       for i := -SCROLL_X_WIDE-1 to SCROLL_X_WIDE+1 do begin
         if test_map[i,j] = 255 then begin
            tested := TRUE;
            test_map[i,j] := 1;
            for k := 0 to 7 do begin
               x_temp := i+test_map_data[k][0];
               y_temp := j+test_map_data[k][1];
               if test_map[x_temp,y_temp] = 0 then begin
                  if (readMap(MA_NORMAL,x_new+x_temp,y_new+y_temp) in PASSABLE_TILE) or
                     ((readMap(MA_NORMAL,x_new+x_temp,y_new+y_temp) in [105,125]) and
                      ((readMap(MA_ATTRIBUTE,x_new+x_temp,y_new+y_temp) and WALKABLE_BIT) = 0)) then begin
                     test_map[x_temp,y_temp] := 255;
                  end else begin
                     test_map[x_temp,y_temp] := 1;
                  end;
               end;
            end;
         end;
      end;
   until not tested;
 end
 else begin

   PASSABLE_TILE := MOVABLE_TILE + FOREGROUND_TILE;

   test_map[person[_MAIN_CHARACTER]^.returnX-x_new,person[_MAIN_CHARACTER]^.returnY-y_new] := 255;
   repeat
      tested := FALSE;
      for j := -SCROLL_Y_WIDE-1 to SCROLL_Y_WIDE+1 do
       for i := -SCROLL_X_WIDE-1 to SCROLL_X_WIDE+1 do begin
         if test_map[i,j] = 255 then begin
            tested := TRUE;
            test_map[i,j] := 1;
            for k := 0 to 7 do begin
               x_temp := i+test_map_data[k][0];
               y_temp := j+test_map_data[k][1];
               if test_map[x_temp,y_temp] = 0 then begin
                  if (readMap(MA_NORMAL,x_new+x_temp,y_new+y_temp-1) in PASSABLE_TILE) then begin
                     test_map[x_temp,y_temp] := 255;
                  end else begin
                     test_map[x_temp,y_temp] := 1;
                  end;
               end;
            end;
         end;
      end;
   until not tested;
 end;

(*  Light Effect Test  *)

   if map_header.tile_data_file[1] in ['d','D'] then begin
      x_light_range := 3;
      y_light_range := 2;
      goto END_LIGHT_EFFECT;
   end;

   case game_system.returnHour of
      0..5, 19..24 : begin
         x_light_range := 3;
         y_light_range := 2;
      end;
      6 : begin
         case game_system.returnMinute of
            0..19  : begin
               x_light_range := 5;
               y_light_range := 3;
            end;
            20..39 : begin
               x_light_range := 7;
               y_light_range := 4;
            end;
            40..59 : begin
               x_light_range := 10;
               y_light_range := 6;
            end;
         end;
      end;
      18 : begin
         case game_system.returnMinute of
            40..59 : begin
               x_light_range := 5;
               y_light_range := 3;
            end;
            20..39 : begin
               x_light_range := 7;
               y_light_range := 4;
            end;
            0..19 : begin
               x_light_range := 10;
               y_light_range := 6;
            end;
         end;
      end
      else begin
         x_light_range := SCROLL_X_WIDE*2;
         y_light_range := SCROLL_Y_WIDE*2;
      end;
   end;
END_LIGHT_EFFECT:
                            (* EXCEPTION : because of game speed *)
   if person[_MAIN_CHARACTER]^.m_equipment[_left_hand]._item_number = __ITEM_TORCH then begin
      if x_light_range < 9 then x_light_range := 9;
      if y_light_range < 5 then y_light_range := 5;
      i := person[_MAIN_CHARACTER]^.m_equipment[_left_hand]._item_trailing_count + 1;
      if i > 10000 then begin
         with person[_MAIN_CHARACTER]^.m_equipment[_left_hand] do begin
            _item_number := 0;
            _item_type := START_OF_EQUIPMENT;
         end;
      end else begin
         person[_MAIN_CHARACTER]^.m_equipment[_left_hand]._item_trailing_count := i;
      end;
   end;

   for j := -y_light_range to y_light_range+1 do
    for i := -x_light_range to x_light_range do begin
      x_temp := i+person[_MAIN_CHARACTER]^.returnX-x_new;
      y_temp := j+person[_MAIN_CHARACTER]^.returnY-y_new;
      if (abs(x_temp) <= SCROLL_X_WIDE) and (abs(y_temp) <= SCROLL_Y_WIDE+1) then
         if test_map[x_temp,y_temp] = 1 then test_map[x_temp,y_temp] := 2;
   end;

   for j := -SCROLL_Y_WIDE-1 to SCROLL_Y_WIDE+1 do
    for i := -SCROLL_X_WIDE-1 to SCROLL_X_WIDE+1 do begin
      if (test_map[i,j] = 1) and ((readMap(MA_ATTRIBUTE,x_new+i,y_new+j-1) and BLIGHT_BIT) > 0) then
         test_map[i,j] := 2;
   end;

(*
   test_map ==>   0 : value is initialized or not displayed.
                255 : value is tested.
                  1 : value represents a dark effect.
                  2 : value represents a blight effect.
*)

SCROLL_MAIN:
(*   Print Scroll Image  *)

   setActivePage(1);
   for j := -SCROLL_Y_WIDE to SCROLL_Y_WIDE do
    for i := -SCROLL_X_WIDE to SCROLL_X_WIDE do begin
      if test_map[i,j+1] > 0 then begin
         dark_effect := (test_map[i,j+1] = 1);
         printImage(X_CENTER+i,Y_CENTER+j,
                    tile_data[readMap(MA_NORMAL,x_new+i,y_new+j)]^,dark_effect);
         if readMap(MA_OBJECT,x_new+i,y_new+j) > 0 then begin
            aux_b := 0;
            temp_b := testItemMap(x_new+i,y_new+j,ET,aux_b);
            if temp_b = 0 then begin
               temp_b := readMap(MA_OBJECT,x_new+i,y_new+j);
               if temp_b <= ADDRESS_OF_WEAPON_IN_OBJECT_TILE then begin
                  printSprite(X_CENTER+i,Y_CENTER+j,
                              object_tile_data[temp_b]^,dark_effect,FALSE);
               end else begin
                  printSprite(X_CENTER+i,Y_CENTER+j,
                              equipment_tile_data[temp_b-ADDRESS_OF_WEAPON_IN_OBJECT_TILE]^,dark_effect,FALSE);
               end;
            end;
            if readMap(MA_NORMAL,x_new+i,y_new+j) in FOREGROUND_TILE then
               printImage(X_CENTER+i,Y_CENTER+j,
                          tile_data[readMap(MA_NORMAL,x_new+i,y_new+j)]^,dark_effect);
            if readMap(MA_OBJECT,x_new+i,y_new+j) in FOREGROUND_OBJECT_TILE then
               printSprite(X_CENTER+i,Y_CENTER+j,
                          object_tile_data[readMap(MA_OBJECT,x_new+i,y_new+j)]^,dark_effect,FALSE);
         end;
         map_index := readMap(MA_PERSON,x_new+i,y_new+j);
         if map_index > 0 then begin
            with person[map_index]^ do begin
               if (returnInternal(_hit_point) < 0) or
                  (returnInternal(_unconscious_depth) > 0) or
                  (returnInternal(_death_depth) > 0) then begin
                  if returnPersonAttribute = mgc_player then begin
                     printSprite(X_CENTER+i,Y_CENTER+j,
                        character_tile_data[returnFace*9-1]^,dark_effect,FALSE);
                  end;
               end;
            end;
         end;
         if readMap(MA_OBJECT,x_new+i,y_new+j) > 0 then begin
            aux_b := 0;
            temp_b := testItemMap(x_new+i,y_new+j,ET,aux_b);
            if temp_b > 0 then begin
               while temp_b > 0 do begin
                  if ET > START_OF_EQUIPMENT then
                     convertItemToObject(temp_b,temp_b);
                  if temp_b <= ADDRESS_OF_WEAPON_IN_OBJECT_TILE then begin
                     printSprite(X_CENTER+i,Y_CENTER+j,
                                 object_tile_data[temp_b]^,dark_effect,FALSE);
                  end else begin
                     printSprite(X_CENTER+i,Y_CENTER+j,
                                 equipment_tile_data[temp_b-ADDRESS_OF_WEAPON_IN_OBJECT_TILE]^,dark_effect,FALSE);
                  end;
                  temp_b := testItemMap(x_new+i,y_new+j,ET,aux_b);
               end;
            end;
            if readMap(MA_NORMAL,x_new+i,y_new+j) in FOREGROUND_TILE then
               printImage(X_CENTER+i,Y_CENTER+j,
                          tile_data[readMap(MA_NORMAL,x_new+i,y_new+j)]^,dark_effect);
         end;
         map_index := readMap(MA_PERSON,x_new+i,y_new+j);
         if map_index > 0 then begin
            if readMap(MA_OBJECT,x_new+i,y_new+j) <> 2 then begin

               with person[map_index]^ do begin
                  if (returnInternal(_hit_point) >= 0) and
                     (returnInternal(_unconscious_depth) = 0) and
                     (returnInternal(_death_depth) = 0) then begin
                     return_face := returnSpriteNumber(MA);
                     case MA of
                      MA_NORMAL : printImage(X_CENTER+i,Y_CENTER+j,tile_data[return_face]^,dark_effect);
                      MA_OBJECT : begin
                       if return_face <= ADDRESS_OF_WEAPON_IN_OBJECT_TILE then
                         printSprite(X_CENTER+i,Y_CENTER+j,object_tile_data[return_face]^,dark_effect,TRUE)
                       else
                         printSprite(X_CENTER+i,Y_CENTER+j,
                           equipment_tile_data[return_face-ADDRESS_OF_WEAPON_IN_OBJECT_TILE]^,dark_effect,TRUE)
                      end;
                      MA_FIELD  : printSprite(X_CENTER+i,Y_CENTER+j,field_tile_data[return_face]^,dark_effect,TRUE);
                      MA_ATTRIBUTE : printSprite(X_CENTER+i,Y_CENTER+j,equipment_tile_data[return_face]^,dark_effect,TRUE);
                      MA_PERSON : printSprite(X_CENTER+i,Y_CENTER+j,character_tile_data[return_face]^,dark_effect,TRUE);
                     end;
                  end;

                  if game_system.enableHPGauge then begin
                     HP_rate := returnInternal(_hit_point);
                     if returnMaxAvailHitPoint > 0 then
                        HP_rate := (HP_rate * 100) div returnMaxAvailHitPoint
                     else
                        HP_rate := 0;
                     case HP_rate of
                        100     : color := 15;
                        51.. 99 : color := 11;
                        41.. 50 : color := 10;
                        31.. 40 : color := 2;
                        21.. 30 : color := 14;
                        11.. 20 : color := 5;
                        0.. 10 : color := 3
                        else color := 3;
                     end;
                     if returnInternal(_unconscious_depth) > 0 then color := 8;
                     if returnInternal(_death_depth) > 0 then color := 0;
                     x_temp := SCROLL_X_GAP*8 + (X_CENTER + i) * TILE_Y_SIZE;
                     y_temp := SCROLL_Y_GAP + (Y_CENTER + j) * TILE_Y_SIZE - 10;
                     if (color = 8) or (color = 0) then y_temp := y_temp + 10;
                     setColor(color);
                     for k := 1 to TAG_WIDTH do begin
                        line(x_temp,y_temp+k,x_temp+(TAG_WIDTH-k),y_temp+k);
                     end;
                     if returnInternal(_poison_depth) = 0 then
                        setColor(0)
                     else
                        setColor(5);
                     graph.moveTo(x_temp+TAG_WIDTH,y_temp);
                     graph.lineTo(x_temp,y_temp);
                     graph.lineTo(x_temp,y_temp+TAG_WIDTH);
                     graph.lineTo(x_temp+TAG_WIDTH,y_temp);
                  end;
               end;
               if readMap(MA_NORMAL,x_new+i,y_new+j) in FOREGROUND_TILE then
                  printImage(X_CENTER+i,Y_CENTER+j,
                             tile_data[readMap(MA_NORMAL,x_new+i,y_new+j)]^,dark_effect);
               if readMap(MA_NORMAL,x_new+i,y_new+j-1) in FOREGROUND_TILE then
                  printImage(X_CENTER+i,Y_CENTER+j-1,
                             tile_data[readMap(MA_NORMAL,x_new+i,y_new+j-1)]^,(test_map[i,j] = 1));
               if readMap(MA_OBJECT,x_new+i,y_new+j) in FOREGROUND_OBJECT_TILE then
                  printSprite(X_CENTER+i,Y_CENTER+j,
                             object_tile_data[readMap(MA_OBJECT,x_new+i,y_new+j)]^,dark_effect,FALSE);
               if readMap(MA_OBJECT,x_new+i,y_new+j-1) in FOREGROUND_OBJECT_TILE then
                  printSprite(X_CENTER+i,Y_CENTER+j-1,
                             object_tile_data[readMap(MA_OBJECT,x_new+i,y_new+j-1)]^,(test_map[i,j] = 1),FALSE);
            end else begin
               if (test_map[i,j] > 0) and (j > -SCROLL_Y_WIDE) then begin
                  printSprite(X_CENTER+i,Y_CENTER+j-1,
                              object_tile_data[29]^,(test_map[i,j] = 1),FALSE);
               end;
            end;
         end;
         map_index := readMap(MA_FIELD,x_new+i,y_new+j) and $07;
         if not (map_index in [__FIELD_EMPTY,__FIELD_VACUUM,__FIELD_SLEEP]) then
            printSprite(X_CENTER+i,Y_CENTER+j,
            field_tile_data[map_index+8*(game_system.getSystemCount and $01)]^,dark_effect,TRUE);
            if readMap(MA_NORMAL,x_new+i,y_new+j) in FOREGROUND_TILE then
               printImage(X_CENTER+i,Y_CENTER+j,
                          tile_data[readMap(MA_NORMAL,x_new+i,y_new+j)]^,dark_effect);
      end
      else begin
         printImage(X_CENTER+i,Y_CENTER+j,tile_data[0]^,TRUE);
      end;
   end;
   setActivePage(0);

   setHanActivePage(1);
   setHanColor(White);
   if SCROLL_X_GAP = 2 then begin
      putSpriteSHIT(16, 0,sprite_data[1].data^,TRUE);
      putSpriteSHIT(16,30,sprite_data[2].data^,TRUE);
      printHangulOUTLINE(124,8,game_system.returnTimeString(FALSE),8);
   end else begin
      printHangulOUTLINE(SCROLL_X_GAP*(TILE_Y_SIZE div TILE_X_SIZE),SCROLL_Y_GAP,game_system.returnTimeString(TRUE),8);
   end;

   remember_HT := getHanType;
   setHanType(GOTHIC);
   i := 1;
   while i <= MAX_MESSAGE_ARRAY do begin
      if message[i] <> nil then begin
         with message[i]^ do
         if person[message_person]^.returnInternal(_hit_point) > 0 then begin
            person[message_person]^.detectPersonAxes(message_x,message_y);
            if person[message_person]^.returnNumber = _MAIN_CHARACTER then
               setHanColor(5)
            else
               setHanColor(7);
            printHangulOUTLINE_CLIPPING(message_x+24,message_y-24,message_string,0);
            if (game_system.getSystemCount >= message_end_time) or
               (abs(game_system.getSystemCount - message_end_time) > 1000) then begin
               removeMessage(i);
               dec(i);
            end;
         end;
      end;
      inc(i);
   end;
   setHanType(remember_HT);
   setHanActivePage(0);

end;

var
   MT : magic_type_T;
   i : integer;
begin
   for initial_valiable := 1 to MAX_PERSON_ARRAY do
      person[initial_valiable] := nil;
   for initial_valiable := 1 to MAX_MESSAGE_ARRAY do
      message[initial_valiable] := nil;
   for MT := mgc_attack to mgc_environment do
      remember_magic_selection[MT] := 1;
   item_map.number_of_data := 0;
   for i := 1 to MAX_ITEM_MAP do
      item_map.data[i].item_data := nil;
end.
