{$DEFINE _OVERLAY}

unit DVSpScpt;
{$IFDEF __OVERLAY}
   {$O+,F+}
{$ENDIF}

INTERFACE

uses
   graph, DVHan20, DVSubPro, DVPerson;

 procedure excuteKnightTraining;
 procedure excuteMagicTraining;
 procedure excuteItemShop;
 procedure excuteGrocery;
 procedure excuteFixShop;
 procedure excuteWeaponShop;
 procedure excuteWeaponSell;
 procedure excuteD2Jump;
 procedure excuteAppraisal;
 procedure excuteGoldChanging;
 procedure excuteJewelChanging;
 procedure createFieldBattle(number : integer);
 procedure excuteDispatch;
 procedure appearAlbireo;
 procedure disappearAlbireo;
 procedure determineFin1;
 procedure displayFin1Title;

IMPLEMENTATION

uses
   DVDecode, DVPersn1, DVTitle;

const
   fade_data : array[0..24*3-1] of byte = (
             $00, $00, $00, $00, $00, $00, $00, $00, $00, $00,
             $00, $00, $00, $00, $00, $00, $00, $00, $00, $00,
             $00, $00, $00, $00,
             $00, $04, $10, $40, $22, $88, $11, $92, $49, $92,
             $AA, $55, $AA, $AB, $B5, $5B, $BB, $DD, $EE, $BF,
             $FB, $EF, $FE, $FF,
             $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF,
             $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF,
             $FF, $FF, $FF, $FF
          );

procedure excuteKnightTraining;
type
   training_method = (START_OF_TRAINING_METHOD,
      body_building,running,throwing,military_arts,crashing,
   END_OF_TRAINING_METHOD);
const
   training_method_string :
   array[succ(START_OF_TRAINING_METHOD)..pred(END_OF_TRAINING_METHOD)] of string[12] = (
   'Abee','b ҅e','e 廡','sea','ba ҅e');
var
   training_value : training_method;
   select : ^select_O;
   i, selected_menu : integer;
begin
   new(select,init);
   for training_value := succ(START_OF_TRAINING_METHOD) to pred(END_OF_TRAINING_METHOD) do
      select^.setMenu(ord(training_value),training_method_string[training_value]);
   convertGrayScale;
   setHanColor(11);
   printTalkHangul(27,3,' ҅ei h a ?',2);
   select^.arrangeMenu(ord(pred(END_OF_TRAINING_METHOD)));
   selected_menu := select^.selectMenu(33,6,1,ord(pred(END_OF_TRAINING_METHOD)));
   dispose(select,done);
   if selected_menu > 0 then begin
      case selected_menu of
         1 : person[_MAIN_CHARACTER]^.addAbilityALL('100,0,0,50,10,30,0,0,0,0');
         2 : person[_MAIN_CHARACTER]^.addAbilityALL('50,0,0,100,10,20,0,0,0,0');
         3 : person[_MAIN_CHARACTER]^.addAbilityALL('10,0,0,30,100,50,0,0,0,0');
         4 : person[_MAIN_CHARACTER]^.addAbilityALL('30,0,0,10,50,150,0,0,0,0');
         5 : person[_MAIN_CHARACTER]^.addAbilityALL('50,0,0,50,50,50,0,0,0,0');
      end;
      PlainOut;
      with game_system do begin
         setEventDump(0,getEventDump(0)+1);
         if (getEventDump(0) mod 5) <> 0 then
            setTime(0,16,59,59)
         else
            setTime(0,16,29,59);
         for i := 1 to max_person do person[i]^.setInitialPosition;
         passTime(0,0,0,1);
      end;
      scrollMap;
      PlainIn;
   end else exit;
   if game_system.getEventDump(0) > 0 then
   if (game_system.getEventDump(0) mod 5) = 0 then begin
      talk_selected_menu := game_system.getEventDump(0) div 5;
      excuteCommand('turn person(0,"left")',0);
      excuteCommand('run script("PROLOG",0,0)',0);
   end;
end;

procedure excuteMagicTraining;
type
   training_magic = (START_OF_TRAINING_MAGIC,
      magic_training,science_study,concenrate_mind,mind_control,
   END_OF_TRAINING_MAGIC);
const
   training_magic_string :
   array[succ(START_OF_TRAINING_MAGIC)..pred(END_OF_TRAINING_MAGIC)] of string[12] = (
   'a҅e','bbbs','҅e','aaťa');
var
   training_value : training_magic;
   select : ^select_O;
   i, selected_menu : integer;
begin
   new(select,init);
   for training_value := succ(START_OF_TRAINING_MAGIC) to pred(END_OF_TRAINING_MAGIC) do
      select^.setMenu(ord(training_value),training_magic_string[training_value]);
   convertGrayScale;
   setHanColor(11);
   printTalkHangul(27,3,' ҅ei h a ?',2);
   select^.arrangeMenu(ord(pred(END_OF_TRAINING_MAGIC)));
   selected_menu := select^.selectMenu(33,6,1,ord(pred(END_OF_TRAINING_MAGIC)));
   dispose(select,done);
   if selected_menu > 0 then begin
      case selected_menu of
         1 : person[_MAIN_CHARACTER]^.addAbilityALL('0,50,50,0,0,0,50,0,0,0');
         2 : person[_MAIN_CHARACTER]^.addAbilityALL('0,100,30,0,0,0,30,0,0,0');
         3 : person[_MAIN_CHARACTER]^.addAbilityALL('0,20,100,0,0,0,50,0,0,0');
         4 : person[_MAIN_CHARACTER]^.addAbilityALL('0,40,40,0,0,0,100,0,0,0');
      end;
      PlainOut;
      with game_system do begin
         setEventDump(0,getEventDump(0)+1);
         if (getEventDump(0) mod 5) <> 0 then
            setTime(0,16,59,59)
         else
            setTime(0,16,29,59);
         for i := 1 to max_person do person[i]^.setInitialPosition;
         passTime(0,0,0,1);
      end;
      scrollMap;
      PlainIn;
   end else exit;
   if game_system.getEventDump(0) > 0 then
   if (game_system.getEventDump(0) mod 5) = 0 then begin
      talk_selected_menu := game_system.getEventDump(0) div 5;
      excuteCommand('turn person(0,"left")',0);
      excuteCommand('run script("PROLOG",0,0)',0);
   end;
end;

procedure excuteItemShop;
const
   XXX = 12;
   YYY = 5;
   START_ITEM = 75;
   END_ITEM = 90;
   ITEM_DIVISION = 10;
var
   key_in, x1, y1 : integer;
   i, selected_item : integer;
   money : item_T;
   s : string;
   cf : text;
   comment_string : array[0..END_ITEM - START_ITEM] of ^string;
   window : ^window_O;

 procedure drawSampleItems;
 var
    i : integer;
 begin
      setHanType(SAMMUL);
      setActivePage(0);
      setFillStyle(SOLIDFILL,7);
      Bar(250,25,575,325);
      setHanColor(10);
      for i := 0 to END_ITEM - START_ITEM do begin
         x1 := i div ITEM_DIVISION;
         y1 := i mod ITEM_DIVISION;
         printSpriteDIRECT(280+x1*150,50+y1*25,equipment_tile_data[START_ITEM+i]^);
         s := item_data[START_ITEM+i]^.name;
         PrintHangul(315+x1*150,50+y1*25,s);
      end;
      setHanType(GOTHIC);
 end;

 procedure drawRectangleCursor(HiLight : boolean);
 var
    x1, y1 : integer;
 begin
    if HiLight then setColor(14)
    else setColor(7);
    x1 := selected_item div ITEM_DIVISION;
    y1 := selected_item mod ITEM_DIVISION;
    rectangle(278+x1*145,50+y1*25-1,415+x1*145,50+y1*25+24);
 end;

 procedure displayMoney;
 begin
    setFillStyle(SOLIDFILL,7);
    bar(XXX*8,(YYY+12)*16,(XXX+14)*8,(YYY+14)*16);
    setHanType(MYUNGJO);
    printString(XXX,YYY+12,'qae q',15,TRUE,7);
    str(money._item_contain : 5, s);
    printString(XXX,YYY+13,' : '+s,14,TRUE,7);
    setHanType(GOTHIC);
 end;

 procedure displayComment;
 begin
    drawBox(80,50,245,250, 8, FALSE, FALSE);
    new(window);
    with window^ do begin
       m_x1 := 11; m_y1 := 4; m_x2 := 30; m_y2 := 14;
       setCursor(0,0);
       printHangul('@F '+item_data[START_ITEM+selected_item]^.name);
       str(item_data[START_ITEM+selected_item]^.price : 3,s);
       printHangul('@@@Aq : @Eq '+s+' ');
       printHangul('@@@@@B '+comment_string[selected_item]^);
    end;
    dispose(window);
 end;

begin
   with person[_MAIN_CHARACTER]^ do begin
      if haveEnoughIt(__ITEM_MONEY,0,1) then
         dropSomething(findInventory(__ITEM_MONEY,0),money)
      else
         exit;
   end;

   assign(cf,COMMENT_FILE);
   {$I-}
   reset(cf);
   {$I+}
   if IOResult <> 0 then printErrorMessage(1,COMMENT_FILE);

   s := '';
   while (s <> ':EXPLAIN ITEMS') and (not eof(cf)) do readLn(cf,s);
   if eof(cf) then begin
      close(cf);
      exit;
   end;

   for i := 0 to END_ITEM - START_ITEM do begin
      new(comment_string[i]);
      readLn(cf,comment_string[i]^);
   end;
   close(cf);

   drawBox(50,10,590,340, 7, TRUE, FALSE);
   setHanType(GOTHIC);
   displayMoney;
   selected_item := 0;
   drawSampleItems;
   displayComment;
   drawRectangleCursor(TRUE);

   key_in := 0;
   while key_in <> ESCAPE_KEY do begin
      key_in := getKey;
      x1 := 0; y1 := 0;
      case key_in of
         UP_KEY    : y1 := -1;
         DOWN_KEY  : y1 := 1;
         LEFT_KEY  : x1 := -1;
         RIGHT_KEY : x1 := 1;
      end;
      i := selected_item;
      drawRectangleCursor(FALSE);
      selected_item := selected_item + x1 * ITEM_DIVISION + y1;
      if selected_item in [0..END_ITEM - START_ITEM] then begin
         drawRectangleCursor(TRUE);
         displayComment;
      end else begin
         selected_item := i;
         drawRectangleCursor(TRUE);
      end;
      if key_in = ACCEPT_KEY then begin
         if money._item_contain >= item_data[START_ITEM+selected_item]^.price then begin
            i := money._item_contain - item_data[START_ITEM+selected_item]^.price;
            money._item_contain := item_data[START_ITEM+selected_item]^.price;
            person[_TALK_PERSON]^.getSomething(money);
            person[_MAIN_CHARACTER]^.getSomething(item_data[START_ITEM+selected_item]^.data);
            money._item_contain := i;
            displayMoney;
         end
         else begin
            printMessageWindow('@Fe  sa');
         end;
      end;
   end;

   flipPageEASY;
   setHanType(MYUNGJO);
   person[_MAIN_CHARACTER]^.getSomething(money);

   for i := 0 to END_ITEM - START_ITEM do begin
      dispose(comment_string[i]);
   end;
end;

procedure excuteGrocery;
const
   PRICE : array[0..5] of byte = (10,11,8,10,12,14);
var
   i, MAP_CODE : integer;
   s : string[3];
   temp_item : item_T;
begin

   s := map_header.map_code;
   MAP_CODE := 0;
   if (s[1] = 'T') and (s[2] in ['1'..'5']) then begin
      MAP_CODE := ord(s[2]) - ord('0');
   end;

   i := decideEA(0,100,'i a');
   if i > 0 then begin
      str(i,talk_trans_s);
      if person[_MAIN_CHARACTER]^.haveEnoughIt(__ITEM_MONEY,0,i*PRICE[MAP_CODE]) then begin
         talk_trans_boolean := TRUE;
         with person[_MAIN_CHARACTER]^ do
            dropSomethingEA(__ITEM_MONEY,0,i*PRICE[MAP_CODE],temp_item);
         person[_TALK_PERSON]^.getSomething(temp_item);
         temp_item := item_data[__ITEM_FOOD]^.data;
         temp_item._item_contain := i;
         person[_MAIN_CHARACTER]^.getSomething(temp_item);
      end else begin
         talk_trans_boolean := FALSE;
      end;
   end else begin
      EXIT_CONDITION := TRUE;
   end;
end;

procedure excuteFixShop;
var
   select : ^select_O;
   i, j, remember_menu, selected_menu, max_menu : integer;
   price : integer;
   item_kind : item_T;
   s : longString;
begin
   new(select,init);
   selected_menu := 1;
   remember_menu := selected_menu;
   while selected_menu > 0 do begin
      with person[_MAIN_CHARACTER]^ do begin
         j := 0;
         for i := 1 to returnMaxInventory do begin
            if (returnInventoryType(i) > START_OF_EQUIPMENT) and
               (returnInventoryNumber(i) < 75) then begin
               inc(j);
               returnInventory(i,item_kind);
               select^.setMenu(j,returnItemName(item_kind,TRUE));
            end;
         end;
         max_menu := j;
         if max_menu > 0 then begin
            select^.setMenuMode(EXTENDED_MENU);
            selected_menu := select^.selectMenu(43,10,remember_menu,max_menu);
            remember_menu := selected_menu;
            select^.setMenuMode(NORMAL_MENU);
            flipPageEASY;
         end else selected_menu := 0;

         if selected_menu > 0 then begin
            j := 0;
            i := 0;
            while (i < returnMaxInventory) do begin
               inc(i);
               if (returnInventoryType(i) > START_OF_EQUIPMENT) and
                  (returnInventoryNumber(i) < 75) then begin
                  inc(j);
                  if j = selected_menu then begin
                     selected_menu := i;
                     i := returnMaxInventory;
                  end;
               end;
            end;
            if item_kind._item_type > START_OF_EQUIPMENT then begin
               returnInventory(selected_menu,item_kind);
               price := item_data[item_kind._item_number]^.price;
               i := item_kind._item_suffix;
               if i > 0 then begin
                  if (i-100) in [0..MAX_SUFFIX] then begin
                     price := round(price * multiply_for_suffix[i] / 2);
                  end else begin
                     price := 0;
                  end;
               end else begin
                  price := price div 2;
               end;
               if item_kind._item_maintain_level > 100 then item_kind._item_maintain_level := 100;
               if item_kind._item_maintain_level < 100 then begin
                  price := price - longint(price) * (100 - item_kind._item_maintain_level) div 100;
               end;
               setHanColor(15);
               talk_order := 0;
               item_kind._item_contain := 1;
               talk_trans_s := returnItemName(item_kind,FALSE);
               printScriptTalk('a, e [string valuable+Z]a.');
               if price > 0 then begin
                  printScriptTalk('q~~ wa   .');
                  str(price,s);
                  printScriptTalk(' áeAe q '+s+'a ϩa aVeA..');
                  printScriptTalk('wa i é ᐡ ?');
                  select^.setMenu(1,'áVsa');
                  select^.setMenu(2,'á gVsa');
                  select^.setMenuMode(DELETED_MENU);
                  select^.setMenuColor(9,1);
                  i := select^.selectMenu(33,12,1,2);
                  select^.setMenuMode(NORMAL_MENU);
                  flipPageEASY;
                  if i = 1 then begin
                     returnInventory(findInventory(__ITEM_MONEY,0),item_kind);
                     if item_kind._item_contain > price then begin
                        dropSomething(selected_menu,item_kind);
                        if item_kind._item_contain > 1 then begin
                           dec(item_kind._item_contain);
                           getSomething(item_kind);
                           item_kind._item_contain := 1;
                        end;
                        item_kind._item_maintain_level := 0;
                        getSomething(item_kind);
                        dropSomething(findInventory(__ITEM_MONEY,0),item_kind);
                        item_kind._item_contain := item_kind._item_contain - price;
                        getSomething(item_kind);
                        setHanColor(15);
                        talk_order := 0;
                        printScriptTalk('a, A a ava.');
                     end else begin
                        setHanColor(5);
                        talk_order := 0;
                        printScriptTalk('AЁa, a᳡. qe  a.');
                     end;
                     pressAnyKey;
                  end;
               end else begin
                  printScriptTalk('q~~ a w e e 􊁐a.');
                  pressAnyKey;
               end;
               flipPageEASY;
            end
            else begin
               setHanColor(15);
               talk_order := 0;
               printScriptTalk(' a a  e wa aa.');
               pressAnyKey;
            end;
         end;
      end;
   end;
   dispose(select,done);
   flipPageEASY;
end;

procedure excuteWeaponShop;
const
   XXX = 10;
   YYY = 5;
   MAX_MENU_STRING = 10;
   menu_enabale : array[0..4,0..MAX_MENU_STRING+1] of boolean = (
      (TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE ,TRUE),
      (TRUE ,TRUE ,TRUE ,FALSE,FALSE,TRUE ,FALSE,FALSE,FALSE,TRUE ,FALSE,TRUE),
      (TRUE ,TRUE ,FALSE,TRUE ,FALSE,FALSE,TRUE ,FALSE,TRUE ,FALSE,FALSE,TRUE),
      (TRUE ,TRUE ,FALSE,FALSE,TRUE ,FALSE,FALSE,TRUE ,FALSE,FALSE,TRUE ,TRUE),
      (TRUE ,TRUE ,FALSE,FALSE,FALSE,FALSE,FALSE,TRUE ,FALSE,FALSE,TRUE ,TRUE)
   );
   menu_string  : array[1..MAX_MENU_STRING] of string[12] = (
      '    ',' Ae   ',' e   ',' ae ',' 廡e ',
      ' e   ',' w  A ',' w  ́  A ',' s    A ','     A '
   );
   menu_reference : array[0..MAX_MENU_STRING] of byte = (
      0,10,20,32,37,40,46,52,58,68,74);
   menu_y_add : array[1..MAX_MENU_STRING] of byte = (
      1,1,0,3,4,3,3,3,1,3);
var
   MAP_CODE  : integer;
   key_in, i : integer;
   selected_part, selected_detail, price : integer;
   start_item, end_item : byte;
   money : item_T;
   s : string;
   weapon_sprite : original_sprite_T;

 procedure drawSampleWeapons;
 var
    i,j : integer;
 begin
      setHanType(SAMMUL);
      setActivePage(0);
      setFillStyle(SOLIDFILL,7);
      Bar(245,25,575,325);
      start_item := menu_reference[selected_part-1]+1;
      end_item := menu_reference[selected_part];
      setHanColor(10);
      for i := 0 to end_item - start_item do begin
         printSpriteDIRECT(250,(i+menu_y_add[selected_part])*25+25,equipment_tile_data[start_item+i]^);
         s := item_data[start_item+i]^.name;
         PrintHangul(280,(i+menu_y_add[selected_part])*25+25,s);
         if item_data[start_item+i]^.price > 0 then
            j := item_data[start_item+i]^.price
         else
            j := 1;
         str(j : 4,s);
         PrintHangul(440,(i+menu_y_add[selected_part])*25+25,'q '+s+ '');
      end;
      setHanType(GOTHIC);
      while KeyPressed do readKey;
 end;

 procedure drawRectangleCursor(HiLight : boolean);
 begin
    if HiLight then setColor(14)
    else setColor(7);
    rectangle(240,(selected_detail+menu_y_add[selected_part])*25+25-1,
              550,(selected_detail+menu_y_add[selected_part])*25+25+24);
 end;

 procedure displayMoney;
 begin
    setFillStyle(SOLIDFILL,7);
    bar(XXX*8,(YYY+MAX_MENU_STRING+2)*16,
        (XXX+14)*8,(YYY+MAX_MENU_STRING+4)*16);
    setHanType(MYUNGJO);
    printString(XXX,YYY+(MAX_MENU_STRING+2),'qae q',15,TRUE,7);
    str(money._item_contain : 5, s);
    printString(XXX,YYY+(MAX_MENU_STRING+3),' : '+s,14,TRUE,7);
    setHanType(GOTHIC);
 end;

begin

   with person[_MAIN_CHARACTER]^ do begin
      if haveEnoughIt(__ITEM_MONEY,0,1) then
         dropSomething(findInventory(__ITEM_MONEY,0),money)
      else
         exit;
   end;

   s := map_header.map_code;
   MAP_CODE := 0;
   if s = 'T1' then MAP_CODE := 1;
   if s = 'T2' then MAP_CODE := 2;
   if s = 'T3' then MAP_CODE := 3;
   if s = 'T5' then MAP_CODE := 4;

   drawBox(50,10,590,340, 7, TRUE, FALSE);
   setHanType(GOTHIC);
   selected_part := 1;
   while not menu_enabale[MAP_CODE,selected_part] do inc(selected_part);
   for i := 1 to MAX_MENU_STRING do begin
      if i = selected_part then begin
         printString(XXX,YYY+i,menu_string[i],15,TRUE,1);
      end else begin
         if menu_enabale[MAP_CODE,i] then
            printString(XXX,YYY+i,menu_string[i],1,TRUE,7)
         else
            printString(XXX,YYY+i,menu_string[i],8,TRUE,7)
      end;
   end;
   displayMoney;
   drawSampleWeapons;

   key_in := 0;
   while key_in <> ESCAPE_KEY do begin
      key_in := ord(readKey);
      if key_in = 0 then key_in := SCAN_CODE + ord(readKey);
      i := 0;
      case key_in of
         UP_KEY   : i := -1;
         DOWN_KEY : i := 1;
      end;
      printString(XXX,YYY+selected_part,menu_string[selected_part],1,TRUE,7);
      selected_part := selected_part + i;
      while not menu_enabale[MAP_CODE,selected_part] do inc(selected_part,i);
      if selected_part < 1 then begin
         selected_part := MAX_MENU_STRING;
         while not menu_enabale[MAP_CODE,selected_part] do dec(selected_part);
      end;
      if selected_part > MAX_MENU_STRING then begin
         selected_part := 1;
         while not menu_enabale[MAP_CODE,selected_part] do inc(selected_part);
      end;
      printString(XXX,YYY+selected_part,menu_string[selected_part],15,TRUE,1);
      if i <> 0 then drawSampleWeapons;

      if key_in = ACCEPT_KEY then begin
        printString(XXX,YYY+selected_part,menu_string[selected_part],1,TRUE,7);
        selected_detail := 0;
        drawRectangleCursor(TRUE);

         key_in := 0;
         while key_in <> ESCAPE_KEY do begin
            key_in := ord(readKey);
            if key_in = 0 then key_in := SCAN_CODE + ord(readKey);
            i := 0;
            case key_in of
               UP_KEY   : i := -1;
               DOWN_KEY : i := 1;
            end;
            drawRectangleCursor(FALSE);
            selected_detail := selected_detail + i;
            if selected_detail < 0 then selected_detail := end_item - start_item;
            if selected_detail > end_item - start_item then selected_detail := 0;
            drawRectangleCursor(TRUE);

            if key_in = ACCEPT_KEY then begin
               price := item_data[start_item+selected_detail]^.price;
               if price < 1 then price := 1;
               if money._item_contain >= price then begin
                  i := money._item_contain - price;
                  money._item_contain := price;
                  person[_TALK_PERSON]^.getSomething(money);
                  person[_MAIN_CHARACTER]^.getSomething(item_data[start_item+selected_detail]^.data);
                  money._item_contain := i;
                  displayMoney;
               end
               else begin
                  printMessageWindow('@Fe  sa');
               end;
            end;
         end;

        drawRectangleCursor(FALSE);
        key_in := 0;
        printString(XXX,YYY+selected_part,menu_string[selected_part],15,TRUE,1);
      end;
   end;

   flipPageEASY;
   setHanType(MYUNGJO);
   person[_MAIN_CHARACTER]^.getSomething(money)
end;

procedure excuteWeaponSell;
var
   money, item_kind : item_T;
   i, j, price : integer;
   remember_menu, selected_menu, max_menu : integer;
   select : ^select_O;
   s : longString;
begin
   new(select,init);
   selected_menu := 1;
   remember_menu := selected_menu;
   while selected_menu > 0 do begin
      with person[_MAIN_CHARACTER]^ do begin
         j := 0;
         for i := 1 to returnMaxInventory do begin
            if (returnInventoryType(i) > START_OF_EQUIPMENT) and
               (returnInventoryNumber(i) < 75) then begin
               inc(j);
               returnInventory(i,item_kind);
               select^.setMenu(j,returnItemName(item_kind,TRUE));
            end;
         end;
         max_menu := j;
         if max_menu > 0 then begin
            select^.setMenuMode(EXTENDED_MENU);
            selected_menu := select^.selectMenu(43,10,remember_menu,max_menu);
            remember_menu := selected_menu;
            select^.setMenuMode(NORMAL_MENU);
            flipPageEASY;
         end else selected_menu := 0;

         if selected_menu > 0 then begin
            j := 0;
            i := 0;
            while (i < returnMaxInventory) do begin
               inc(i);
               if (returnInventoryType(i) > START_OF_EQUIPMENT) and
                  (returnInventoryNumber(i) < 75) then begin
                  inc(j);
                  if j = selected_menu then begin
                     selected_menu := i;
                     i := returnMaxInventory;
                  end;
               end;
            end;
            if item_kind._item_type > START_OF_EQUIPMENT then begin
               dropSomething(selected_menu,item_kind);
               if item_kind._item_contain > 1 then begin
                  item_kind._item_contain := item_kind._item_contain - 1;
                  getSomething(item_kind);
                  item_kind._item_contain := 1;
               end;
               price := item_data[item_kind._item_number]^.price;
               i := item_kind._item_suffix;
               if i > 0 then begin
                  if (i-100) in [0..MAX_SUFFIX] then begin
                     price := round(price * multiply_for_suffix[i] / 2);
                  end else begin
                     price := 0;
                  end;
               end else begin
                  price := price div 2;
               end;
               if item_kind._item_maintain_level > 100 then item_kind._item_maintain_level := 100;
               if item_kind._item_maintain_level > 0 then begin
                  price := price - longint(price) * (item_kind._item_maintain_level) div 100;
               end;
               if price > 0 then begin
                  str(price,s);
                  s := 'e q '+s+'A a.';
                  setHanColor(15);
                  talk_order := 0;
                  printScriptTalk(s);
                  printScriptTalk('ᘁ, iᓡ ?');
                  select^.setMenu(1,'iVsa');
                  select^.setMenu(2,'i gVsa');
                  select^.setMenuMode(DELETED_MENU);
                  select^.setMenuColor(9,1);
                  i := select^.selectMenu(33,12,1,2);
                  select^.setMenuMode(NORMAL_MENU);
                  flipPageEASY;
                  if i = 1 then begin
                     item_kind := item_data[__ITEM_MONEY]^.data;
                     item_kind._item_contain := price;
                  end;
               end else begin
                  setHanColor(15);
                  talk_order := 0;
                  printScriptTalk('eaa, ae iee aáa ea.');
                  pressAnyKey;
               end;
               getSomething(item_kind);
            end
            else begin
               printMessageWindow('@Fieaa');
            end;
         end;
      end;
   end;
   flipPageEASY;
   dispose(select,done);
end;

procedure excuteD2Jump;
var
   x1, y1 : shortint;
begin
   case person[_MAIN_CHARACTER]^.returnFaceCount div 2 of
      0 : begin x1 :=  0; y1 := +3 end;
      1 : begin x1 := -3; y1 :=  0 end;
      2 : begin x1 := +3; y1 :=  0 end;
      3 : begin x1 :=  0; y1 := -3 end;
   end;
   person[_MAIN_CHARACTER]^.moveTo(x1,y1);
end;

procedure excuteAppraisal;
var
   money, item_kind : item_T;
   i, j, price : integer;
   remember_menu, selected_menu, max_menu : integer;
   select : ^select_O;
   s : longString; aux_s : string[5];
begin
   new(select,init);
   selected_menu := 1;
   remember_menu := selected_menu;
   while selected_menu > 0 do begin
      with person[_MAIN_CHARACTER]^ do begin
         j := 0;
         for i := 1 to returnMaxInventory do begin
            if (returnInventoryType(i) > START_OF_EQUIPMENT) and
               (returnInventoryNumber(i) < 75) then begin
               inc(j);
               returnInventory(i,item_kind);
               select^.setMenu(j,returnItemName(item_kind,TRUE));
            end;
         end;
         max_menu := j;
         if max_menu > 0 then begin
            select^.setMenuMode(EXTENDED_MENU);
            selected_menu := select^.selectMenu(43,10,remember_menu,max_menu);
            remember_menu := selected_menu;
            select^.setMenuMode(NORMAL_MENU);
            flipPageEASY;
         end else selected_menu := 0;

         if selected_menu > 0 then begin
            j := 0;
            i := 0;
            while (i < returnMaxInventory) do begin
               inc(i);
               if (returnInventoryType(i) > START_OF_EQUIPMENT) and
                  (returnInventoryNumber(i) < 75) then begin
                  inc(j);
                  if j = selected_menu then begin
                     selected_menu := i;
                     i := returnMaxInventory;
                  end;
               end;
            end;
            if item_kind._item_type > START_OF_EQUIPMENT then begin
               dropSomething(selected_menu,item_kind);
               getSomething(item_kind);
               item_kind._item_contain := 1;
               price := item_data[item_kind._item_number]^.price;
               i := item_kind._item_suffix;
               if i > 0 then begin
                  if (i-100) in [0..MAX_SUFFIX] then begin
                     price := round(price * multiply_for_suffix[i] / 10);
                  end else begin
                     price := 0;
                  end;
               end else begin
                  price := price div 10;
               end;
               str(price,s);
               s := 'q..  q '+s+'A qЁ.';
               setHanColor(15);
               talk_order := 0;
               printScriptTalk(s);
               printScriptTalk('ᐡ, iᓡ ?');
               select^.setMenu(1,'qЁ Vsa');
               select^.setMenu(2,'qa gVsa');
               select^.setMenuMode(DELETED_MENU);
               select^.setMenuColor(9,1);
               i := select^.selectMenu(33,12,1,2);
               select^.setMenuMode(NORMAL_MENU);
               flipPageEASY;
               if i = 1 then begin
                  if haveEnoughIt(__ITEM_MONEY,0,price) then begin

      setHanColor(15);
      talk_order := 0;
      case item_kind._item_type of
         _weapon    : s := 'bw ';
         _shield    : s := 'ẃ';
         _armor     : s := 's';
         _shoes     : s := 'i';
         _helmet    : s := 'ʁ';
         _gauntlet  : s := 'ws'
         else         s := '';
      end;
      printScriptTalk('a.. e '+s+'Aa.');
      printScriptTalk(' w÷e '+returnItemName(item_kind,FALSE)+'.');
      case item_kind._item_weapon_type of
         _fist    : s := '';
         _sword   : s := 'Ae';
         _axe     : s := 'e';
         _spear   : s := 'ae';
         _throw   : s := '廡e';
         _bow     : s := '';
         _fist4MU : s := 'aaw '
         else       s := '';
      end;
      if s <> '' then
         printScriptTalk('we '+s+' awa.');
      case item_kind._item_attribute of
         _normal  : s := '';
         _virtue  : s := '';
         _vice    : s := 'b';
      end;
      printScriptTalk('e.... '+s+'.');
      excuteCommand('clear talk',0);
      str(item_kind._item_weight / 10 : 4 : 2,s);
      printScriptTalk('q... Ae '+s+'Kg  aa...');
      if item_kind._item_attack_power > 0 then begin
         str(item_kind._item_attack_power,s);
         str(item_kind._item_attack_range,aux_s);
         printScriptTalk('bbe '+s+', e A '+aux_s+'.');
      end;
      if (item_kind._item_defense_level <> 0) or
         (item_kind._item_defense_power <> 0) then begin
         str(item_kind._item_defense_level,s);
         str(item_kind._item_defense_power,aux_s);
         printScriptTalk('w e '+s+' wbe '+aux_s+'a..');
      end;
      if item_kind._item_throw_power > 0 then begin
         str(item_kind._item_throw_power,s);
         str(item_kind._item_throw_range,aux_s);
         printScriptTalk('iaae ១e '+aux_s+', ӱe '+s+'aA.');
      end else begin
         printScriptTalk(' 廩  ae  i  ?');
      end;
      excuteCommand('clear talk',0);
      if item_kind._item_magic_type = mgc_none then
         s := 'a 韥 e a... '
      else
         s := ' A a iaa eA...';
      printScriptTalk(s);
      case item_kind._item_maintain_level of
         0 :    s := 'Ÿ  .';
         1..50 : s := 'e aa .'
         else   s := 'Aa g w AaA.'
      end;
      printScriptTalk('a '+s);

      dropSomethingEA(__ITEM_MONEY,0,price,item_kind);
      pressAnyKey;

                  end
                  else begin
                     setHanColor(5);
                     talk_order := 0;
                     printScriptTalk('b.! eЁa, a᳡..  a.');
                     pressAnyKey;
                  end;
                  flipPageEASY;
               end;
            end
            else begin
               printMessageWindow('@Fqi  e aa');
            end;
         end;
      end;
   end;
   flipPageEASY;
   dispose(select,done);
end;

procedure exchangeMoney(exchange : byte);
var
   i, ITEM_CODE, PRICE : integer;
   temp_item           : item_T;
begin

   case exchange of
      1 :
      begin
         i := decideEA(0,100,'i a');
         ITEM_CODE := 91; PRICE := 10;
      end;
      2 :
      begin
         i := decideEA(0,100,'i a');
         ITEM_CODE := 92; PRICE := 50;
      end;
   end;

   if i > 0 then begin
      str(i,talk_trans_s);
      if person[_MAIN_CHARACTER]^.haveEnoughIt(ITEM_CODE,0,i) then begin
         talk_trans_boolean := TRUE;
         with person[_MAIN_CHARACTER]^ do
            dropSomethingEA(ITEM_CODE,0,i,temp_item);
         person[_TALK_PERSON]^.getSomething(temp_item);
         temp_item := item_data[__ITEM_MONEY]^.data;
         temp_item._item_contain := i * PRICE;
         person[_MAIN_CHARACTER]^.getSomething(temp_item);
      end else begin
         talk_trans_boolean := FALSE;
      end;
   end else begin
      EXIT_CONDITION := TRUE;
   end;
end;

procedure excuteGoldChanging;
begin
   exchangeMoney(1);
end;

procedure excuteJewelChanging;
begin
   exchangeMoney(2);
end;

(*
          1,2            3           4         5           6
   2   Green Orc     Blue Orc    Blue Orc     Eva      Green Orc
   3  Yellow Ogre   Green Ogre  Green Ogre  Dragon    Yellow Ogre
   4    Knight        Knight      Knight                Knight
   5  Super Frog      Spider      Slime                 Slime
   6   Magician      Magician    Magician              Magician
   7    Bandit1       Bandit1     Bandit1               Bandit1
   8    Nalrmi        Nalrmi       Eva                  Nalrmi
   9    Bandit2       Bandit2     Bandit2               Bandit2
  10    Mad Ox        Dragon      Dragon                Spider

   1.Knight     2.Magician      3.Bandit1     4.Bandit2       5.Green Orc
   6.Blue Orc   7.Yellow Ogre   8.Green Ogre  9.Super Frog   10.Nalrmi
  11.Mad Ox    12.Spider       13.Slime      14.Eva          15.Dragon
*)
procedure createFieldBattle(number : integer);
const
   enemy_order : array[1..6,2..10] of byte = (
      (5,7,1,9,2,3,10,4,11),
      (5,7,1,9,2,3,10,4,11),
      (6,8,1,13,2,3,10,4,15),
      (6,8,1,13,2,3,14,4,15),
      (14,15,0,0,0,0,0,0,0),
      (5,7,1,13,2,3,10,4,12)
   );
var
   i, j, suffix, k, max_person, main_person : integer;
   MAX_SORT : byte;
   s : shortString;
   s1, s2 : string[5];
begin
   MAX_SORT := 9;
   if number = 5 then MAX_SORT := 2;
   main_person := random(MAX_SORT)+2;
   if enemy_order[number,main_person] = 2 then main_person := random(MAX_SORT)+2;
   max_person := random(8) + 1;

   for i := 3 to max_person+3 do begin
      if random(6) <> 0 then k := main_person else k := random(MAX_SORT)+2;
      person[i] := new(simple_person_type,
         init(i,k,mgc_player,MA_PERSON,'?',8,TRUE));
      with person[i]^ do begin
         warpTo(random(13)+1,random(13)+1);
         setInternal(_hostile,_MAIN_CHARACTER);
         setAbilityALL('2000,1000,5000,3000,5000,3000,3000,1000,50,1000');
         setAbility(_level,person[_MAIN_CHARACTER]^.returnAbility(_level) * 3 div 4);
         setSkillALL('10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10');
         case enemy_order[number,k] of
            1 :
            begin
               j := random(3)+12;
               if random(10) = 0 then begin
                  j := random(5)+12;
                  if random(10) = 0 then j := random(7)+12;
               end;
               if random(100) = 0 then begin
                  suffix := random(24)+100;
                  if random(10) = 0 then suffix := random(9)+200;
                  str(suffix,s1);
                  s1 := ':'+s1;
               end else s1 := '';
               str(j,s);
               s := s + s1;
               addEquipmentALL(s);
            end;
            2 :
            begin
               j := random(4)+5;
               if j = 8 then j := random(5)+17;
               str(j,s);
               addMagicALL('('+s+')::::');
               setAbility(_inteligence,returnAbility(_inteligence)*2);
            end;
            3,4 :
            begin
               j := random(9)+2;
               str(j,s);
               addEquipmentALL(s);
            end;
            5..8 :
            begin
               addEquipmentALL('2');
               setAbility(_level,returnAbility(_level) div 2 * (enemy_order[number,k]-4));
            end;
            9 :
            begin
               setAbility(_endurance,5000);
               if random(10) = 0 then begin
                  addMagicALL('(6)::::');
               end;
            end;
            10:
            begin
               addEquipmentALL('41');
               if random(10) = 0 then begin
                  addMagicALL('(5)::::');
               end;
            end;
            11:
            begin
               setAbility(_endurance,7000);
               setAbility(_strength,4000);
            end;
            12:
            begin
               setAbility(_endurance,4000);
               setAbility(_strength,1500);
               if random(10) = 0 then begin
                  addMagicALL('(9)::::');
               end;
            end;
            14:
            begin
               setAbility(_endurance,4000);
               setAbility(_strength,3000);
               addEquipmentALL('43');
               addItemALL('89-30');
            end;
            15:
            begin
               setAbility(_endurance,6000);
               setAbility(_strength,3000);
               case random(10) of
                  0 : addMagicALL('(5)::::');
                  1 : addMagicALL('(6)::::');
                  2 : addMagicALL('(9)::::');
                  3 : addMagicALL('(17)::::');
                  4 : addMagicALL('(19)::::');
               end;
            end;
         end;
         if random(50) = 0 then begin
            j := random(74)+1;
            str(j,s);
            if random(10) = 0 then begin
               j := random(24)+100;
               str(j,s1);
               s := s + ':' + s1;
            end;
            addItemALL(s);
         end;
         modifyInternalValue;
      end;
   end;

end;

procedure excuteDispatch;
const
   DISPACH_DUMP = 0;
var
   dispath_number : byte;
   f              : file;
   script_file    : string;
begin
   with game_system do begin
      dispath_number := getEventDump(DISPACH_DUMP);
      if dispath_number = 0 then _NEXT_DISPATCH_TIME := m_month * 30 + m_day;
      if _NEXT_DISPATCH_TIME <= m_month * 30 + m_day then begin
         inc(dispath_number);
         str(dispath_number,script_file);
         script_file := 'DSPTCH'+script_file;
         assign(f,script_file+'.MVC');
         {$I-}
         reset(f,1);
         {$I+}
         if IOResult = 0 then begin
            close(f);
            setEventDump(DISPACH_DUMP,dispath_number);
            _NEXT_DISPATCH_TIME := (m_month * 30 + m_day + 3) mod (12 * 30);
            excuteCommand('run script("'+script_file+'",0,0)',0);
         end else begin
            printScriptTalk(' w  a 􊁐a...');
            readKey;
         end;
      end else begin
         printScriptTalk('a  a i  gvea.');
         readKey;
      end;
   end;
end;

procedure appearAlbireo;
const
   NUMBER = 46;
var
   i, j, k : integer;
   temp : sprite_T;
begin
   temp := character_tile_data[NUMBER]^;
   for i := 24 to 24*2-1 do begin
      for k := 0 to 3 do
      for j := 24*3-1 downto 0 do begin
         character_tile_data[NUMBER]^[k*24*3+j] := temp[k*24*3+j] and fade_data[i+(j mod 3)];
      end;
      for j := 24*3-1 downto 0 do begin
         character_tile_data[NUMBER]^[IMAGE_SIZE+j] := temp[IMAGE_SIZE+j] or not fade_data[i+(j mod 3)];
      end;
      scrollMap;
      waitVerticalRetrace(1);
      flipPage;
   end;
   character_tile_data[NUMBER]^ := temp;
end;

procedure disappearAlbireo;
const
   NUMBER = 46;
var
   i, j, k : integer;
   temp : sprite_T;
begin
   temp := character_tile_data[NUMBER]^;
   for i := 24*2-1 downto 0 do begin
      for k := 0 to 3 do
      for j := 0 to 24*3-1 do begin
         character_tile_data[NUMBER]^[k*24*3+j] := temp[k*24*3+j] and fade_data[i+(j div 3)];
      end;
      for j := 0 to 24*3-1 do begin
         character_tile_data[NUMBER]^[IMAGE_SIZE+j] := temp[IMAGE_SIZE+j] or not fade_data[i+(j div 3)];
      end;
      scrollMap;
      waitVerticalRetrace(1);
      flipPage;
   end;
   character_tile_data[NUMBER]^ := temp;
end;

procedure determineFin1;
const
   X_AXIS = 31;
   Y_AXIS = 39;
var
   temp_item : array[1..3] of item_T;
begin
   talk_trans_boolean := FALSE;
   if returnItemMap(X_AXIS,Y_AXIS,temp_item[1]) then begin
      if returnItemMap(X_AXIS,Y_AXIS,temp_item[2]) then begin
         if returnItemMap(X_AXIS,Y_AXIS,temp_item[3]) then begin
            if (temp_item[1]._item_number = __ITEM_MAGIC_MIRROR) and
               (temp_item[1]._item_suffix = __SUFFIX_VIRTUE) and
               (temp_item[2]._item_number = __ITEM_MAGIC_MIRROR) and
               (temp_item[2]._item_suffix = __SUFFIX_NEUTRAL) and
               (temp_item[3]._item_number = __ITEM_MAGIC_MIRROR) and
               (temp_item[3]._item_suffix = __SUFFIX_VICE) then begin
               talk_trans_boolean := TRUE;
            end;
            setItemMap(X_AXIS,Y_AXIS,temp_item[3]);
            setItemMap(X_AXIS,Y_AXIS,temp_item[2]);
            setItemMap(X_AXIS,Y_AXIS,temp_item[1]);
         end else begin
            setItemMap(X_AXIS,Y_AXIS,temp_item[2]);
            setItemMap(X_AXIS,Y_AXIS,temp_item[1]);
         end;
      end else begin
         setItemMap(X_AXIS,Y_AXIS,temp_item[1]);
      end;
   end;
end;

procedure displayFin1Title;
begin
   DVTitle.displayFin1Title;
end;

end.
