{$DEFINE _OVERLAY}

unit DVSubpro;
{$IFDEF __OVERLAY}
   {$O+,F+}
{$ENDIF}

{$DEFINE _VERTICAL_RETRACE}

INTERFACE

uses
   dos, graph,
   DVHan20, DVTMF;

const
   SCROLL_X_GAP : byte = 2;      (* aa b X,Y *)
   SCROLL_Y_GAP : byte = 0;

   MIN_SCROLL_X_WIDE = 5;        (* aa A t *)
   MIN_SCROLL_Y_WIDE = 4;
   MAX_SCROLL_X_WIDE = 12;       (* aa A t *)
   MAX_SCROLL_Y_WIDE = 7;

   SCROLL_X_WIDE : byte = 12;    (* e aa t *)
   SCROLL_Y_WIDE : byte = 7;

   TILE_X_SIZE = 3;              (* a a, A a *)
   TILE_Y_SIZE = 24;

   MAP_X_ABSOLUTE_MAX = 130;     (*  A a *)
   MAP_Y_ABSOLUTE_MAX = 180;

   MAX_SYSTEM_COUNT = 20;        (* ā b  e *)

   IMAGE_SIZE = 288;             (* a ai BYTE Ŭe *)
   MAX_TILE = 144;               (* w a  *)
   MAX_OBJECT_TILE = 52;         (* A a  *)
   MIN_ITEM_TILE = 75;
   MAX_EQUIPMENT_TILE = 100;     (* w a  *)
   MAX_FIELD_TILE = 48;          (* ϩa a  *)
   MAX_CHARACTER_TILE = 112;      (* ā a  *)
   MAX_SPRITE_TILE = 9;
   ADDRESS_OF_WEAPON_IN_OBJECT_TILE = 100;
                                 (* w a aá *)
   ADDRESS_OF_MIRAGE_IN_FIELD_TILE = 20;
   MAX_REGISTER_PLAYER_SPRITE = 11;
   MAX_MOVIE_DATA = 300;

   FULL_CODE : byte = $FF;
   NULL_CODE : byte = $00;

   _MAIN_CHARACTER : byte = 1; (* A  ѡ *)

type

   shortString = string[50];
   longString = string[110];
   setBYTE = set of byte;
   buffer_T = array[0..9999] of byte;

   original_image_T = array[0..IMAGE_SIZE+6-1] of byte;

   image_T = array[0..IMAGE_SIZE-1] of byte;
                                 (*  a *)
   original_sprite_T = array[0..2*(IMAGE_SIZE+6)-1] of byte;

   sprite_T = array[0..IMAGE_SIZE+IMAGE_SIZE div 4-1] of byte;
                                 (* aaaa a *)
   tile_data_T = array[0..MAX_TILE-1] of ^image_T;
                                 (* w a a *)
   object_tile_data_T = array[0..MAX_OBJECT_TILE-1] of ^sprite_T;
                                 (* A a a *)
   equipment_tile_data_T = array[1..MAX_EQUIPMENT_TILE] of ^sprite_T;
                                 (* w a a *)
   field_tile_data_T = array[0..MAX_FIELD_TILE-1] of ^sprite_T;
                                 (* ϩa a a *)
   character_tile_data_T = array[0..MAX_CHARACTER_TILE-1] of ^sprite_T;
                                 (* ā a a *)
   palette_T = array[0..15,1..3] of byte;

   map_attribute_T = (START_OF_MAP_ATTRIBUTE,
                      MA_NORMAL,MA_OBJECT,MA_FIELD,MA_ATTRIBUTE,MA_PERSON,
                      END_OF_MAP_ATTRIBUTE);
                                 (*   a *)

   map_T = array[0..MAP_Y_ABSOLUTE_MAX * MAP_X_ABSOLUTE_MAX -1] of byte;
                                 (*  Aa a *)

   window_O = object
      m_x1, m_x2, m_y1, m_y2 : integer;
      m_x_cursor, m_y_cursor : integer;
      m_color, m_back_color : integer;

      constructor init(x1,y1,x2,y2,color : integer; is_normal_mode : boolean);
      destructor  done; virtual;
      procedure drawWindow; virtual;
      procedure drawNetImage;
      procedure setCursor(x,y : integer);
      procedure clearWindow(color : byte); virtual;
      procedure scrollUp(line : byte);
      procedure scrollDown(line : byte);
      procedure printHangul(s : string);
   end;

   titled_window_O = object(window_O)
      m_title : string[80];
      EXTRA_EDGE : byte;

      constructor init(x1,y1,x2,y2,color : integer; is_normal_mode : boolean; title_color : integer; title : string);
      procedure drawWindow; virtual;
      procedure clearWindow(color : byte); virtual;
      procedure setTitle(title : string);
      procedure drawAuxWindow;
   end;

   menu_mode_T = (NORMAL_MENU,DELETED_MENU,BOLD_MENU,EXTENDED_MENU);
                                 (* AA a a *)
   select_O = object
      m_menu_mode : menu_mode_T;          (* AA a *)
      LIGHT, DARK : byte;                 (* ia w *)
      m : array[1..50] of string[50];     (* AAi w *)

      constructor init;
      destructor  done;
      procedure setMenu(num : integer; s : string);
                                 (* num  AAi s   *)
      procedure setMenuColor(_LIGHT,_DARK : byte);
      procedure setMenuMode(mode : menu_mode_T);
                                 (* AA ai mode   *)
      procedure arrangeMenu(max_line : integer);

      function  selectMenu(x,y,line,max_line : integer) : integer;
                                 (* (x,y)A max_line eq AAi line  baa Ȃ
                                    ESC ǡa w i e 0i A *)
      function  selectMenu4ExtendedMenu(x,y,line,max_line : integer) : integer;
                                 (* AA a gi aw *)
   end;

   out_line_talk_T = (NORMAL_OUTLINE,SLASH_OUTLINE,NET_IMAGE_OUTLINE);

   system_O = object

   public
      m_proceeding_level : byte;
      m_year,m_month,m_day,m_hour,m_minute,m_second : integer;
                                                (* A  e,,,e *)
      m_event_time : integer;                   (* aq Ea ѡ, i e 0 *)
      m_remain_event_time : longint;            (* Eaa aa qe  *)
      m_remember_previous_time : longint;       (* Ae āa  ei  Ŭe *)
      m_system_count : longint;
      m_enable_to_move : boolean;               (* āa   e wȁa ? *)
      m_can_walk : boolean;
      m_event_bit_data : array[0..49] of byte;  (* Ea qw sw e *)
      m_event_dump_data : array[0..49] of byte;
      m_outline_talk_method : out_line_talk_T;     (*  A¬ ei b i a ? *)
      m_enable_HP_gauge : boolean;
      m_map_x_max, m_map_y_max : integer;
      _NEXT_DISPATCH_TIME : longint;
      _NEXT_EXCUTE_FILE : string[10];
      _NEXT_START_X, _NEXT_START_Y : integer;
      _NEXT_DIRECTION_X, _NEXT_DIRECTION_Y : shortint;
      _RETURN_EXCUTE_FILE : string[10];
      _RETURN_START_X, _RETURN_START_Y : integer;

      constructor init;
      destructor  done;

      function  returnHour : integer;
      function  returnMinute : integer;
      function  setCurrentTime : longint;
                                 (* e ei  eᝡ q *)
      procedure updateSystemCount;
      function  getSystemCount : longint;
      procedure lockMovement;    (* ā᷁ i Ae *)
      procedure unlockMovement;  (* ā᷁  Aei ЁA *)
      function  enableToMove : boolean;
                                 (* āa   e wȁa ? *)
      procedure setWalkAll(how : boolean);
      function  canWalkAll : boolean;
      function  getPreviousTime : longint;
                                 (* Ae āa  ei  Ŭeaa A *)
      procedure setPreviousTime(previous_time : longint);
                                 (* Ae āa  ei  *)
      procedure setOutlineTalk(how : out_line_talk_T);
                                 (*  A¬ ei b ai howA  i *)
      function  getOutlineTalk : out_line_talk_T;
                                 (*  A¬ ei b awea ? *)
      procedure setHPGause(how : boolean);
      function  enableHPGauge : boolean;
      procedure passTime(day,hour,minute,second : integer);
                                 (* A w aei wa Ǳ *)
      procedure setTime(day,hour,minute,second : integer);
      procedure setEventTime(event_number,day,hour,minute,second : integer);
                                 (* aq Eaa i ei event_numberA Ea ѡi   *)
      function  returnEventTime : integer;
      function  returnTimeString(paren : boolean) : string;
                                 (* A w ei ai A *)
      procedure setEventBit(bytes : integer);
                                 (* Ea q e bit弁i SET Ǳ *)
      procedure resetEventBit(bytes : integer);
                                 (* Ea q e bit弁i RESET Ǳ *)
      function  getEventBit(bytes : integer) : boolean;
                                 (* Ea q e bit弁a SET wȁa ? *)
      procedure setEventDump(dump, value : byte);
      function  getEventDump(dump : byte) : byte;
      procedure setMapMaxSize(x,y : integer);
      function  returnMapXMax : integer;
      function  returnMapYMax : integer;

   end;

   movement_T = record
      from_hour, to_hour : byte; (* Ёw ee from_time  to_time a *)
      which_position,            (* e ai i ѡ w *)
      number_of_position : byte; (* ⻡a   *)
      position : array[1..10,1..2] of byte;
                                 (* e  (x,y) *)
   end;
   person_movement_T = record
      next_movement_carry : byte;(* aqA  awe e y qvei w *)
      next_movement_hour : integer;
                                 (* aqA  awe e *)
      which_movement,            (* e ai ⻡i ѡ w *)
      number_of_movement : byte; (* a e ⻡  *)
      movement : array[1..10] of movement_T;
                                 (* a e ⻡ (x,y) *)
      final_face : array[1..10] of byte;
                                 (* ⻡A be ҁ aae wз *)
   end;

   map_data_T = record
      file_name : string[8];
      map_x_exit, map_y_exit : integer;
      map_x_start, map_y_start : integer;
   end;

   map_header_T = record
      map_x_max, map_y_max : integer;
      friendship_level : byte;
      map_data : map_data_T;
      music_data_file, tile_data_file, object_data_file,
      equipment_data_file, field_data_file, character_data_file : string[8];
      enable_boundary_exit : boolean;
      handicap_bit : byte;
      enable_map_recording : boolean;
      enable_person_recording : boolean;
      map_code : string[3];
      count_of_exit_point : byte;
   end;

   attack_type_T = (_normal_attack,_not_shown,_shoot,_pierce,_spread);
   attack_attribute_T = (_physical,_magical,_fiery,_watery,_airy,_earthy,_electrical,_poisonous);
   attack_parameters_T = record
      attack_type : attack_type_T;
      attack_attribute : attack_attribute_T;
      shape, shape_revolution, trailing_count : integer;
      power, speed : integer;
      x_original, y_original : integer;
      x_source, y_source, x_destination, y_destination : integer;
   end;

   movie_data_T = record
      MD_plane : map_attribute_T;
      MD_image_number : byte;
      MD_x, MD_y : integer;
      MD_restore_count : integer;
   end;
   saved_image_data_T = record
      SI_data : original_image_T;
      SI_x, SI_y : integer;
      SI_restore_count : integer;
   end;

   movie_O = object
      m_movie_data : array[1..MAX_MOVIE_DATA] of movie_data_T;
      m_data_storage_ptr : integer;
      m_saved_image_data : array[1..MAX_MOVIE_DATA div 10] of saved_image_data_T;

      constructor init;
      destructor  done;
      procedure printMirage(x,y : integer;bit_map : integer);
      procedure restoreBackGround;
      procedure setMovie(plane : map_attribute_T; image_number : byte; x,y, restore_count, spread_space : integer);
      procedure makeMovieSub(params : attack_parameters_T; spread_space, defense_magic : integer);
      procedure makeMovie(var params : attack_parameters_T; defense_magic : integer);
      procedure makeMovie4Spread(var params : attack_parameters_T; space : integer);
      procedure arrangeMovie;
      procedure playMovie(wait_clock : integer);
   end;

   save_data_T = record
      data_name : string[16];
      gabage_byte1 : array[1..5] of byte;
      check_sum : longint;
      gabage_byte2 : array[1..3] of byte;
      check_sum_byte : byte;
      gabage_byte3 : array[1..4] of byte;
   end;

const

   __TILE_VALLEY = 0;
   __TILE_DEN_SAND = 1;
   __TILE_SAND = 4;
   __TILE_WATER = 78;
   __FIELD_EMPTY = 0;
   __FIELD_FIRE = 1;
   __FIELD_VACUUM = 2;
   __FIELD_POISON = 3;
   __FIELD_SLEEP = 4;
   __FIELD_ELETRIC = 5;
   __FIELD_ENERGY = 6;
   __FIELD_FORCE = 7;
   __FIELD_FIRE_BALL = 205;
   __FIELD_FLAME = 211;
   __FIELD_WATER = 220;
   __FIELD_FIRE_WHIRL = 214;
   __FIELD_ATOM_FIRE = 226;
   __OBJECT_DEATH_BODY = 32;
   __OBJECT_BLOOD = 51;
   __PERSON_MONSTER = 90;
   __PERSON_DRAGON = 94;
   __PERSON_OTHER_DIMENTION = 98;
   __PERSON_FIRE_ELEMENTAL = 104;
   __PERSON_WATER_ELEMENTAL = 106;
   __PERSON_AIR_ELEMENTAL = 108;
   __PERSON_EARTH_ELEMENTAL = 110;
   __ITEM_SWORD = 11;
   __ITEM_CUTLASS = 12;
   __ITEM_AXE = 21;
   __ITEM_SLING = 41;
   __ITEM_BOOMERANG = 39;
   __ITEM_FLAME_BOME = 40;
   __ITEM_TORCH = 75;
   __ITEM_OXYGEN_MASK = 78;
   __ITEM_MAGIC_MIRROR = 81;
   __ITEM_POISON = 86;
   __ITEM_ARROW = 89;
   __ITEM_BOLT = 90;
   __ITEM_FOOD = 93;
   __ITEM_CRYSTAL = 95;
   __ITEM_MONEY = 100;
   __SUFFIX_VIRTUE = 101;
   __SUFFIX_VICE = 102;
   __SUFFIX_ALBIREO = 109;
   __SUFFIX_FEATHER = 114;
   __SUFFIX_POISON = 117;
   __SUFFIX_FIRE = 118;
   __SUFFIX_WATER = 119;
   __SUFFIX_AIR = 120;
   __SUFFIX_EARTH = 121;
   __SUFFIX_LUCK = 122;
   __SUFFIX_ELECTRITY = 123;
   __SUFFIX_NEUTRAL   = 124;
   __SUFFIX_OYDIPUS   = 200;
   __SUFFIX_GODDESS   = 201;
   __SUFFIX_TITAN     = 202;
   __SUFFIX_ATHENA    = 203;
   __SUFFIX_ARCHIMAGE = 204;
   __SUFFIX_HERCULES  = 205;
   __SUFFIX_HERMES    = 206;
   __SUFFIX_ATLAS     = 207;
   __SUFFIX_MEDUSA    = 208;
   __HANDICAP_TELEPORT     = 1;
   __HANDICAP_GROUNDING    = 2;
   __HANDICAP_METAMORPHOSE = 4;
   __HANDICAP_ETHERIZATION = 8;
   __HANDICAP_TRASPARENCY  = 16;
   __HANDICAP_WIZARD_EYE   = 32;

   SCAN_CODE              = 256;
   SLEEP_KEY              = ord('s');
   ATTACK_KEY             = ord('a');
   CAST_MAGIC_KEY         = ord('c');
   DISARM_KEY             = ord('r');
   EQUIP_KEY              = ord('e');
   DROP_KEY               = ord('d');
   GET_KEY                = ord('g');
   MOVE_KEY               = ord('m');
   LOOK_KEY               = ord('l');
   VIEW_KEY               = ord('v');
   USE_KEY                = ord('u');
   BATTLE_KEY             = ord('b');
   CHEAT_KEY              = ord('`');
   HELP_KEY               = 59 + SCAN_CODE;
   VIEW_ALL_CONDITION_KEY = 9;
   UP_KEY                 = 72 + SCAN_CODE;
   DOWN_KEY               = 80 + SCAN_CODE;
   LEFT_KEY               = 75 + SCAN_CODE;
   RIGHT_KEY              = 77 + SCAN_CODE;
   ACCEPT_KEY             = 13;
   MENU_KEY               = 32;
   ESCAPE_KEY             = 27;
   EXIT_CODE              = 254;

   STAIRS_TILE : set of byte = [140..143];
   MOVABLE_TILE : set of byte = [1..89,140,143];
   FOREGROUND_IN_TILE_IMAGE : set of byte =
      [100,102,104..108,110,112,114,118,120,122,124..128,130,132,134,138];
   FOREGROUND_IN_DEN_IMAGE : set of byte =
      [120,122,124..126,128,130,132,134,138];

   FOREGROUND_OBJECT_TILE : set of byte = [5,11,24,42..45];
   MOVABLE_OBJECT_TILE : set of byte = [0..3,5,7,9,11,24,31..45,51,100..255];
   MOVABLE_FIELD_TILE : set of byte =
      [__FIELD_EMPTY,__FIELD_FIRE,__FIELD_VACUUM,__FIELD_POISON,__FIELD_SLEEP,__FIELD_ENERGY];
   PASSABLE_OBJECT_TILE : set of byte = [0..2,7,9,31,42..45,100..255];
   PASSABLE_FIELD_TILE : set of byte = [0..5];

   FIELD_BIT = $07;
   EVENT_BIT = $03;
   SEARCHABLE_BIT = $10;
   FIXED_AIR_BIT = $20;
   WALKABLE_BIT = $40;
   BLIGHT_BIT = $80;

   NORMAL_CURSOR = 0;
   MOVE_CURSOR   = 47;
   LOOK_CURSOR   = 48;
   GET_CURSOR    = 49;
   WALK_CURSOR   = 50;

   remember_selected_menu : byte = 1;

   MAX_PERSON_ARRAY = 80;
   MAX_TALKABLE_PERSON_ARRAY = 70;

   MAX_MAP_EXIT_POINT = 50;

   SAVE_ID  :  string[5] = 'SMgal';
   SPRITE_FILE           = 'dejavu.spr';
   COMMENT_FILE          = 'comment.cmt';
   TEMPLET_FILE          = 'mov.dat';
   OBJ_SAVE_FILE         = 'objs';
   SUB_DIRECTORY         = 'SAVEDATA';
   SAVE_INFORMATION_FILE = 'SaveInfo';

   MIN_REQURED_MEMORY = 25000;

   return_circle_data : array[0..10] of byte = (
                        0,0,0,1,1,1,2,2,2,3,3);
var

   tile_data : tile_data_T;
   object_tile_data : object_tile_data_T;
   equipment_tile_data : equipment_tile_data_T;
   field_tile_data : field_tile_data_T;
   character_tile_data : character_tile_data_T;
   palette_data : palette_T;
   sprite_data : array[1..MAX_SPRITE_TILE] of record
      size : word;
      data : ^byte;
   end;

   key_code : integer;
   map : array[succ(START_OF_MAP_ATTRIBUTE)..pred(END_OF_MAP_ATTRIBUTE)] of ^map_T;
   test_map : array[-MAX_SCROLL_X_WIDE-2..MAX_SCROLL_X_WIDE+2,-MAX_SCROLL_Y_WIDE-2..MAX_SCROLL_Y_WIDE+2] of byte;
   person_movement_data : array[1..MAX_TALKABLE_PERSON_ARRAY] of person_movement_T;
   invoid_person_movement_data, talkable_person, recognizable_person : set of 1..MAX_TALKABLE_PERSON_ARRAY;
   temp1_person, temp2_person, temp3_person : set of 1..MAX_TALKABLE_PERSON_ARRAY;
   max_person : integer;
   map_header : map_header_T;
   map_exit_data : array[1..MAX_MAP_EXIT_POINT] of ^map_data_T;
   game_system : system_O;
   timer : longint;
   FOREGROUND_TILE : set of byte;
   MUST_LOAD_GAME, DETECT_SOUND_CARD : boolean;

   _PERSON_CONTROLL_CODE : (NO_EVENT,OCCUR_EVENT,OCCUR_TALK,OCCUR_TIME_EVENT);
   _MAP_X_CENTER, _MAP_Y_CENTER : byte;

   _GLOBAL_LONG : longint;
   _GLOBAL_WORD1, _GLOBAL_WORD2 : word;
   _GLOBAL_KEY  : char;


 function  KeyPressed : boolean;
 function  readKey : char;
 procedure pressAnyKey;
 function  getKey : integer;
 procedure setPalette(palette_number : byte);
 procedure setRGB(Color, Red, Green, Blue : byte);
 procedure waitVerticalRetrace(count : integer);
 procedure printImage(X, Y: Integer; var BitMap; Darkness : boolean);
 procedure printImageDIRECT(X, Y: Integer; var BitMap);
 procedure printSprite(X, Y: Integer; var BitMap; Darkness : boolean; is_person_sprite : boolean);
 procedure printSpriteDIRECT(X, Y: Integer; var BitMap);
 procedure printImageOLD(X, Y: Integer; var BitMap; Darkness : boolean);
 procedure printSpriteOLD(X, Y: Integer; var BitMap; Darkness : boolean; is_person_sprite : boolean);
 procedure putSpriteSHIT(x,y : word; var BitMap; full_color : boolean);
 procedure convertGrayScale;
 procedure clearPage(p : byte);
 procedure PlainOut;
 procedure PlainIn;
 procedure convertBWScale(var temp_palette : palette_T);
 procedure convertVioletScale(var temp_palette : palette_T; max_color : byte; delay : byte);
 procedure convertOriginalScale(var temp_palette : palette_T; max_color : byte; delay : byte);
 procedure fadeOut(var palette_data : palette_T; delay : byte);
 procedure fadeIn(var palette_data : palette_T; delay : byte);
 procedure copyPage;
 procedure flipPageEASY;
 procedure flipPage;
 procedure flipGrayScalePage;
 procedure printString(x,y : integer; s : string; color : word; FILL : boolean; fill_color : word);
(*
 function  revertFile(source_file_name, destination_file_name : string) : boolean;
*)
 function  deleteFile(file_name : string) : boolean;
 function  returnCheckSum(file_name : string) : longint;
 procedure printErrorMessage(error_number : byte; s : string);
 procedure printFadingMessage(s : string; restore : boolean);
 procedure printMessageWindowSub(message : string; back_color : integer);
 procedure printMessageWindow(message : string);
 procedure printTalkHangul(x,y : integer; s : string; back_color : byte);
 procedure drawBox(x1, y1, x2, y2 : integer; color : integer; is_shadow, is_bold : boolean);
 function  readMap(MA : map_attribute_T; x,y : integer) : byte;
 function  isMovableMap(x,y : integer) : boolean;
 function  isSafeMovableMap(x,y : integer) : boolean;
 function  isPassableMap(x, y : integer) : boolean;
 procedure writeMap(MA : map_attribute_T; x,y,value : byte);
 procedure writeMapEXPAND(map_number, x, y, value : byte);
 procedure fillMap(map_number, x1, y1, x2, y2, value : byte);
 procedure convertNew2OldImage(var source : image_T; var destination : original_image_T);
 procedure convertNew2OldSprite(var source : sprite_T; var destination : original_sprite_T);

 procedure printWeaponCursor(x,y : integer;bit_map : integer);
 function  selectObject(var return_x, return_y : integer; x_range, y_range, x_delta, y_delta : integer; cursor_type : byte)
           : boolean;
           (*    bi cursor_type  A ᝡ Ȃ,
               ae (return_x,return_y) a e (x_range,y_range)
              ȂE ae (return_x,return_y)  Aaa ́Ae (0,0) i Aa *)
 procedure modifyScreenWide(increase : integer);
 procedure increaseScreenWide;
 procedure decreaseScreenWide;
 procedure displayHelpWindow;

const
   __SCAN_CODE : char = #0;
   ENABLE_CHEATING : boolean = FALSE;

IMPLEMENTATION

uses
   DVError;

function KeyPressed : boolean; assembler;
asm
      cmp  __SCAN_CODE, 0
      jne  @JUMP00
      mov  ah, 1
      int  $16
      mov  al, FALSE
      je   @JUMP01
@JUMP00:
      mov  al, TRUE
@JUMP01:
end;

function readKey : char; assembler;
asm
      mov  al, __SCAN_CODE
      mov  __SCAN_CODE, 0
      or   al, al
      jne  @JUMP00
      xor  ah, ah
      int  $16
      or   al, al
      jne  @JUMP00
      mov  __SCAN_CODE, ah
      or   ah, ah
      jne  @JUMP00
      mov  al, 'C'-64
@JUMP00:
      mov  _GLOBAL_KEY, al
end;

function getKey : integer;
var
   c : char;
begin
   c := readKey;
   if c = #0 then
      getKey := SCAN_CODE + ord(readKey)
   else
      getKey := ord(c);
end;

procedure pressAnyKey;
var
   temp_key : integer;
begin
   repeat
      temp_key := getKey;
   until temp_key < SCAN_CODE;
end;

procedure setPalette(palette_number : byte); assembler;
asm
   mov ah,$10
   mov al, 0
   mov bh, palette_number
   mov bl, palette_number
   int $10
end;

procedure setRGB(Color, Red, Green, Blue : byte); assembler;
asm
   mov dx,$3c8;
   mov al,Color;
   out dx,al;
   inc dx;
   mov al,Red;
   out dx,al;
   mov al,Green;
   out dx,al;
   mov al,Blue;
   out dx,al;
end;

procedure waitVerticalRetrace(count : integer);
var
   c : char;
begin
   while count > 0 do begin
      while (port[$03DA] and 8) > 0 do while KeyPressed do c := readKey;
      while (port[$03DA] and 8) = 0 do;
      dec(count);
   end;
end;

procedure printImage(X, Y: Integer; var BitMap; Darkness : boolean);
const
   Font_X_Size = 3;  { 8 * 3 = 24 }
   Font_Y_Size = 24;
var
   sour_seg, sour_off, dest_seg, dest_off : word;
   plane : byte;
   i : integer;
begin

   if Darkness then plane := 1 else plane := 8;
   sour_seg := seg(BitMap);
   sour_off := ofs(BitMap);

   dest_seg := SegA000;
   dest_off := $8000 + (y * (Font_Y_Size) + SCROLL_Y_GAP) * 80 +
               x * (Font_X_Size) + SCROLL_X_GAP;

   asm
      push ds
      push es

      mov ax, sour_seg
      mov ds, ax
      mov ax, dest_seg
      mov es, ax
      mov dx, $3C4
      mov si, sour_off

      cmp plane, 1
      jne @MAIN_LOOP

      mov ax, $0E02
      out dx, ax
      mov cx, Font_Y_Size
      mov ax, $0000
      mov di, dest_off

@JUMP1:
      cld
      stosw
      stosb
      add di, 80 - Font_X_Size
      loop @JUMP1
      add si, IMAGE_SIZE / 4 * 3;

@MAIN_LOOP:
      mov di, dest_off

@JUMP3:
      mov al, $02
      mov ah, plane
      out dx, ax
      mov cx, Font_Y_Size

@JUMP4:

      movsw
      movsb

      add di, 80 - Font_X_Size
      loop @JUMP4

      shr plane, 1
      cmp plane, 0
      jne @MAIN_LOOP

      mov dx, $3C4
      mov ax, $0F02
      out dx, ax

      pop es
      pop ds
   end;

end;

procedure printImageDIRECT(X, Y: Integer; var BitMap);
const
   Font_X_Size = 3;  { 8 * 3 = 24 }
   Font_Y_Size = 24;
var
   sour_seg, sour_off, dest_seg, dest_off : word;
   plane : byte;
   i : integer;
begin

   x := x div 8;
   plane := 8;
   sour_seg := seg(BitMap);
   sour_off := ofs(BitMap);

   dest_seg := SegA000;
   dest_off := y * 80 + x;

   asm
      push ds
      push es

      mov ax, sour_seg
      mov ds, ax
      mov ax, dest_seg
      mov es, ax
      mov dx, $3C4
      mov si, sour_off

@MAIN_LOOP:
      mov di, dest_off

@JUMP3:
      mov al, $02
      mov ah, plane
      out dx, ax
      mov cx, Font_Y_Size

@JUMP4:

      movsw
      movsb

      add di, 80 - Font_X_Size
      loop @JUMP4

      shr plane, 1
      cmp plane, 0
      jne @MAIN_LOOP

      mov dx, $3C4
      mov ax, $0F02
      out dx, ax

      pop es
      pop ds
   end;

end;

procedure printSprite(X, Y: Integer; var BitMap; Darkness : boolean; is_person_sprite : boolean);
const
   Font_X_Size = 3;  { 8 * 3 = 24 }
   Font_Y_Size = 24;
var
   sour_seg, sour_off, dest_seg, dest_off : word;
   plane, read_plane : byte;
begin
   if Darkness then begin
      plane := 1;
      read_plane := 0;
   end
   else begin
      plane := 8;
      read_plane := 3;
   end;
   sour_seg := seg(BitMap);
   sour_off := ofs(BitMap);

   dest_seg := SegA000;
   dest_off := $8000 + x * (Font_X_Size) + SCROLL_X_GAP;
   if is_person_sprite then
      inc(dest_off,(y * (Font_Y_Size) + SCROLL_Y_GAP - 10) * 80)
   else
      inc(dest_off,(y * (Font_Y_Size) + SCROLL_Y_GAP) * 80);

   asm
      push ds
      push es

      mov ax, sour_seg
      mov ds, ax
      mov ax, dest_seg
      mov es, ax
      mov dx, $3C4
      mov si, sour_off
      mov bx, IMAGE_SIZE

      cmp plane, 1
      jne @MAIN_LOOP

      mov ax, $0E02
      out dx, ax
      mov cx, Font_Y_Size
      mov ax, $0000
      mov di, dest_off

@JUMP1:
      cld
      stosw
      stosb
      add di, 80 - Font_X_Size
      loop @JUMP1
      add si, IMAGE_SIZE / 4 * 3
      mov bx, IMAGE_SIZE / 4

@MAIN_LOOP:
      mov di, dest_off

@JUMP3:
      mov dx, $3C4
      mov al, $02
      mov ah, plane
      out dx, ax

      mov dx, $3CE
      mov al, $04
      mov ah, read_plane
      out dx, ax

      mov cx, Font_Y_Size

@JUMP4:

      mov ax,es:[di]
      and ax,ds:[si+bx]
      or  ax,ds:[si]
      mov es:[di],ax
      inc si
      inc di
      inc si
      inc di

      mov al,es:[di]
      and al,ds:[si+bx]
      or  al,ds:[si]
      mov es:[di],al
      inc si
      inc di

      add di, 80 - Font_X_Size
      loop @JUMP4

      shr plane, 1
      dec read_plane
      sub bx, IMAGE_SIZE / 4
      cmp plane, 0
      jne @MAIN_LOOP

      mov dx, $3C4
      mov ax, $0F02
      out dx, ax

      pop es
      pop ds
   end;

end;

procedure printSpriteDIRECT(X, Y: Integer; var BitMap);
const
   Font_X_Size = 3;  { 8 * 3 = 24 }
   Font_Y_Size = 24;
var
   sour_seg, sour_off, dest_seg, dest_off : word;
   plane, read_plane : byte;
begin
   x := x div 8;

   plane := 8;
   read_plane := 3;

   sour_seg := seg(BitMap);
   sour_off := ofs(BitMap);

   dest_seg := SegA000;
   dest_off := y * 80 + x;

   asm
      push ds
      push es

      mov ax, sour_seg
      mov ds, ax
      mov ax, dest_seg
      mov es, ax
      mov dx, $3C4
      mov si, sour_off
      mov bx, IMAGE_SIZE

@MAIN_LOOP:
      mov di, dest_off

@JUMP3:
      mov dx, $3C4
      mov al, $02
      mov ah, plane
      out dx, ax

      mov dx, $3CE
      mov al, $04
      mov ah, read_plane
      out dx, ax

      mov cx, Font_Y_Size

@JUMP4:

      mov ax,es:[di]
      and ax,ds:[si+bx]
      or  ax,ds:[si]
      mov es:[di],ax
      inc si
      inc di
      inc si
      inc di

      mov al,es:[di]
      and al,ds:[si+bx]
      or  al,ds:[si]
      mov es:[di],al
      inc si
      inc di

      add di, 80 - Font_X_Size
      loop @JUMP4

      shr plane, 1
      dec read_plane
      sub bx, IMAGE_SIZE / 4
      cmp plane, 0
      jne @MAIN_LOOP

      mov dx, $3C4
      mov ax, $0F02
      out dx, ax

      pop es
      pop ds
   end;

end;

procedure printImageOLD(X, Y: Integer; var BitMap; Darkness : boolean);
const
   IMAGE_SIZE = 294;
   Font_X_Size = 3;  { 8 * 3 = 24 }
   Font_Y_Size = 24;
var
   sour_seg, sour_off, dest_seg, dest_off : word;
   plane : byte;
   i : integer;
begin
   if Darkness then plane := 1 else plane := 8;
   sour_seg := seg(BitMap);
   sour_off := ofs(BitMap) + 4;

   dest_seg := SegA000;
   dest_off := $8000 + (y * (Font_Y_Size) + SCROLL_Y_GAP) * 80 +
               x * (Font_X_Size) + SCROLL_X_GAP;

   asm
      push ds
      push es

      mov ax, sour_seg
      mov ds, ax
      mov ax, dest_seg
      mov es, ax
      mov dx, $3C4

      cmp plane, 1
      jne @MAIN_LOOP

      mov ax, $0E02
      out dx, ax
      mov cx, Font_Y_Size
      mov ax, $0000
      mov di, dest_off

@JUMP1:
      cld
      stosw
      stosb
      add di, 80 - Font_X_Size
      loop @JUMP1

@MAIN_LOOP:
      mov si, sour_off
      mov di, dest_off
      mov al, plane

@JUMP2:
      cmp al, 8
      je @JUMP3
      shl al, 1
      add si, 3
      jmp @JUMP2

@JUMP3:
      mov al, $02
      mov ah, plane
      out dx, ax
      mov cx, Font_Y_Size

@JUMP4:

      movsw
      movsb

      add si, 9
      add di, 80 - Font_X_Size
      loop @JUMP4

      shr plane, 1
      cmp plane, 0
      jne @MAIN_LOOP

      mov dx, $3C4
      mov ax, $0F02
      out dx, ax

      pop es
      pop ds
   end;

end;

procedure printSpriteOLD(X, Y: Integer; var BitMap; Darkness : boolean; is_person_sprite : boolean);
const
   IMAGE_SIZE = 294;
   Font_X_Size = 3;  { 8 * 3 = 24 }
   Font_Y_Size = 24;
var
   sour_seg, sour_off, dest_seg, dest_off : word;
   plane, read_plane : byte;
begin
   if Darkness then begin
      plane := 1;
      read_plane := 0;
   end
   else begin
      plane := 8;
      read_plane := 3;
   end;
   sour_seg := seg(BitMap);
   sour_off := ofs(BitMap) + 4;

   dest_seg := SegA000;
   dest_off := $8000 + x * (Font_X_Size) + SCROLL_X_GAP;
   if is_person_sprite then
      inc(dest_seg,(y * (Font_Y_Size) + SCROLL_Y_GAP - 10) * 80)
   else
      inc(dest_seg,(y * (Font_Y_Size) + SCROLL_Y_GAP) * 80);

   asm
      push ds
      push es

      mov ax, sour_seg
      mov ds, ax
      mov ax, dest_seg
      mov es, ax
      mov dx, $3C4
      mov bx, 294

      cmp plane, 1
      jne @MAIN_LOOP

      mov ax, $0E02
      out dx, ax
      mov cx, Font_Y_Size
      mov ax, $0000
      mov di, dest_off

@JUMP1:
      cld
      stosw
      stosb
      add di, 80 - Font_X_Size
      loop @JUMP1

@MAIN_LOOP:
      mov si, sour_off
      mov di, dest_off
      mov al, plane

@JUMP2:
      cmp al, 8
      je @JUMP3
      shl al, 1
      add si, 3
      jmp @JUMP2

@JUMP3:
      mov dx, $3C4
      mov al, $02
      mov ah, plane
      out dx, ax

      mov dx, $3CE
      mov al, $04
      mov ah, read_plane
      out dx, ax

      mov cx, Font_Y_Size

@JUMP4:

      mov ax,es:[di]
      and ax,ds:[si+bx]
      or  ax,ds:[si]
      mov es:[di],ax
      inc si
      inc di
      inc si
      inc di

      mov al,es:[di]
      and al,ds:[si+bx]
      or  al,ds:[si]
      mov es:[di],al
      inc si
      inc di

      add si, 9
      add di, 80 - Font_X_Size
      loop @JUMP4

      shr plane, 1
      dec read_plane
      cmp plane, 0
      jne @MAIN_LOOP

      mov dx, $3C4
      mov ax, $0F02
      out dx, ax

      pop es
      pop ds
   end;

end;

procedure putSpriteSubSHIT(x,y,SPRITE_X_SIZE,SPRITE_Y_SIZE : word; var BitMap; full_color : boolean); assembler;
var
   plane : byte;
   read_plane : integer;
   _VIDEO_SEGMENT : word;
asm
      push ds

      mov  _VIDEO_SEGMENT, 8000h

      mov  plane, 8
      mov  read_plane, 3

      mov  dx, $3C4
      mov  al, $02
      out  dx, al

      mov  dx, $3CE
      mov  al, $04
      out  dx, al

      mov  es, SegA000

      mov  dx, $3C4

@MAIN_LOOP:

      lds  si, BitMap
      mov  di, x
      shr  di, 3
      mov  ax, y
      shl  ax, 4
      add  di, ax
      shl  ax, 2
      add  di, ax
      add  di, _VIDEO_SEGMENT
      mov  al, plane

@JUMP2:
      cmp  al, 8
      je   @JUMP3
      shl  al, 1
      add  si, SPRITE_X_SIZE
      jmp  @JUMP2

@JUMP3:
      mov  dx, $3C5
      mov  al, plane
      out  dx, al

      mov  dx, $3CF
      mov  al, byte ptr read_plane
      out  dx, al

      mov  cx, SPRITE_Y_SIZE

@JUMP4:

      push cx

      mov  cx, SPRITE_X_SIZE

@JUMP5:

      mov  bx, si
      mov  ax, 3
      sub  ax, word ptr read_plane
      mul  SPRITE_X_SIZE
      sub  bx, ax

      mov  ah, ds:[bx]
      add  bx, SPRITE_X_SIZE
      and  ah, ds:[bx]
      add  bx, SPRITE_X_SIZE
      mov  al, ds:[bx]
      not  al
      and  ah, al
      add  bx, SPRITE_X_SIZE
      mov  al, ds:[bx]
      not  al
      and  ah, al
      not  ah

      test byte ptr full_color, 0FFh
      jz   @@1
      mov  al, ds:[si]
      jmp  @@2
   @@1:
      mov  al, ah
   @@2:
      and  al, ah
      not  ah
      mov  dl, es:[di]
      and  dl, ah
      or   al, dl
      mov  es:[di], al

      inc  si
      inc  di

      loop @JUMP5

      pop  cx

      mov  ax, SPRITE_X_SIZE;
      shl  ax, 1
      add  ax, SPRITE_X_SIZE;
      add  si, ax
      add  di, 80
      sub  di, SPRITE_X_SIZE
      loop @JUMP4

      shr  plane, 1
      dec  read_plane
      cmp  plane, 0
      jne  @MAIN_LOOP

      mov  dx, $3C4
      mov  ax, $0F02
      out  dx, ax

      pop  ds

end;

procedure putSpriteSHIT(x,y : word; var BitMap; full_color : boolean); assembler;
asm
      push ds
      lds  si, BitMap
      cld
      lodsw
      inc  ax
      shr  ax, 3
      mov  bx, ax
      lodsw
      inc  ax
      mov  cx, ax
      mov  dx, ds
      pop  ds

      mov  ax, x
      push ax
      mov  ax, y
      push ax
      push bx
      push cx
      push dx
      push si
      xor  ah, ah
      mov  al, full_color
      push ax
      call putSpriteSubSHIT
end;

procedure convertGrayScale;
var
   gap, count, destination_index : word;
begin
   gap := (2*SCROLL_X_WIDE+1) * TILE_X_SIZE;
   count := (2*SCROLL_Y_WIDE+1) * TILE_Y_SIZE;
   destination_index := $0000 + SCROLL_Y_GAP * 80 + SCROLL_X_GAP;
   asm
      push es

      mov bx, gap
      mov es, SegA000
      mov di, destination_index

      mov dx, $3C4
      mov ax, $0702
      out dx, ax

      mov ax, 0
      mov cx, count

@JUMP0:
      push cx
      mov cx, bx
      cld
      rep stosb

      add di, 80
      sub di, bx
      pop cx
      loop @JUMP0

      pop es
   end;
end;

procedure clearPage(p : byte); assembler;
asm
      push es

      mov es, SegA000
      mov di, 0
      cmp byte ptr p, 0
      je  @@PAGE0
      mov di, $8000
@@PAGE0:
      mov dx, $3C4
      mov ax, $0F02
      out dx, ax

      mov ax, 0
      mov cx, $4000
      cld
      rep stosw

      pop es
end;

procedure PlainOut;
var
   b : byte;
begin
   for b := 0 to 3 do begin
      asm
         push es

         mov es, SegA000
         mov di, 0
         mov dx, $3C4
         mov ah, $01
         mov cl, b
         shl ah, cl
         mov al, $02
         out dx, ax

         mov ax, 0
         mov cx, $4000
         cld
         rep stosw

         mov dx, $3C4
         mov ax, $0F02
         out dx, ax

         pop es
      end;
      waitVerticalRetrace(15);
   end;
end;

procedure PlainIn;
var
   b : byte;
begin
   for b := 0 to 3 do begin
      asm
         push ds
         push es

         mov es, SegA000
         mov di, 0
         mov ds, SegA000
         mov si, $8000

         mov dx, $3C4
         mov ah, $01
         mov cl, b
         shl ah, cl
         mov al, $02
         out dx, ax

         mov dx, $3CE
         mov al, $04
         mov ah, b
         out dx, ax

         mov cx, 80 * 400
         cld
         rep movsb

         mov dx, $3C4
         mov ax, $0F02
         out dx, ax

         pop es
         pop ds
      end;
      waitVerticalRetrace(15);
   end;
end;

procedure convertBWScale(var temp_palette : palette_T);
var
   i : word;
   temp_b : byte;
begin
   port[$3c8] := 0;
   for i := 0 to 15 do begin
      temp_b := round(((temp_palette[i,1]*3+temp_palette[i,2]*5+temp_palette[i,3]*2)/10));
      port[$3c9] := temp_b;
      port[$3c9] := temp_b;
      port[$3c9] := temp_b;
   end;
end;

procedure convertVioletScale(var temp_palette : palette_T; max_color : byte; delay : byte);
const
   INTENSITY = 50;
var
   i,j : word;
   gray_intensity, gray_red, gray_green, gray_blue : array[0..15] of byte;
begin
   for i := 0 to max_color do begin
      gray_intensity[i] := round(((temp_palette[i,1]*3+temp_palette[i,2]*5+temp_palette[i,3]*2)/10)*INTENSITY/100);
      gray_red[i] := temp_palette[i,1];
      gray_green[i] := temp_palette[i,2];
      gray_blue[i] := temp_palette[i,3];
   end;
   if delay > 0 then begin
      for j := 0 to 63 do begin
         waitVerticalRetrace(delay);
         port[$3c8] := 0;
         for i := 0 to max_color do begin
            if (gray_red[i] > gray_intensity[i] div 1) then dec(gray_red[i]);
            if (gray_red[i] < gray_intensity[i] div 1) then inc(gray_red[i]);
            if (gray_green[i] > gray_intensity[i] div 2) then dec(gray_green[i]);
            if (gray_green[i] < gray_intensity[i] div 2) then inc(gray_green[i]);
            if (gray_blue[i] > gray_intensity[i] div 1) then dec(gray_blue[i]);
            if (gray_blue[i] < gray_intensity[i] div 1) then inc(gray_blue[i]);
            port[$3c9] := gray_red[i];
            port[$3c9] := gray_green[i];
            port[$3c9] := gray_blue[i];
         end;
      end;
   end else begin
      port[$3c8] := 0;
      for i := 0 to max_color do begin
         port[$3c9] := gray_intensity[i] div 1;
         port[$3c9] := gray_intensity[i] div 2;
         port[$3c9] := gray_intensity[i] div 1;
      end;
      for i := succ(max_color) to 15 do begin
         port[$3c9] := temp_palette[i,1];
         port[$3c9] := temp_palette[i,2];
         port[$3c9] := temp_palette[i,3];
      end;
   end;
end;

procedure convertOriginalScale(var temp_palette : palette_T; max_color : byte; delay : byte);
const
   INTENSITY = 50;
var
   i,j : word;
   gray_intensity, gray_red, gray_green, gray_blue : array[0..15] of byte;
begin
   for i := 0 to max_color do begin
      gray_intensity[i] := round(((temp_palette[i,1]*3+temp_palette[i,2]*5+temp_palette[i,3]*2)/10)*INTENSITY/100);
      gray_red[i] := gray_intensity[i];
      gray_green[i] := gray_intensity[i] div 2;
      gray_blue[i] := gray_intensity[i];
   end;
   if delay > 0 then begin
      for j := 0 to 63 do begin
         waitVerticalRetrace(1);
         port[$3c8] := 0;
         for i := 0 to max_color do begin
            if (gray_red[i] > temp_palette[i,1]) then dec(gray_red[i]);
            if (gray_red[i] < temp_palette[i,1]) then inc(gray_red[i]);
            if (gray_green[i] > temp_palette[i,2]) then dec(gray_green[i]);
            if (gray_green[i] < temp_palette[i,2]) then inc(gray_green[i]);
            if (gray_blue[i] > temp_palette[i,3]) then dec(gray_blue[i]);
            if (gray_blue[i] < temp_palette[i,3]) then inc(gray_blue[i]);
            port[$3c9] := gray_red[i];
            port[$3c9] := gray_green[i];
            port[$3c9] := gray_blue[i];
         end;
      end;
   end else begin
      port[$3c8] := 0;
      for i := 0 to max_color do begin
         port[$3c9] := temp_palette[i,1];
         port[$3c9] := temp_palette[i,2];
         port[$3c9] := temp_palette[i,3];
      end;
   end;
end;

procedure fadeIn(var palette_data : palette_T; delay : byte);
var
   i,j : word;
   gray_red, gray_green, gray_blue : array[0..15] of byte;
begin
   for i := 0 to 15 do begin
      gray_red[i] := 0;
      gray_green[i] := 0;
      gray_blue[i] := 0;
   end;
   if delay > 0 then begin
      for j := 0 to 63 do begin
         waitVerticalRetrace(1);
         port[$3c8] := 0;
         for i := 0 to 15 do begin
            if (gray_red[i] < palette_data[i,1]) then inc(gray_red[i]);
            if (gray_green[i] < palette_data[i,2]) then inc(gray_green[i]);
            if (gray_blue[i] < palette_data[i,3]) then inc(gray_blue[i]);
            port[$3c9] := gray_red[i];
            port[$3c9] := gray_green[i];
            port[$3c9] := gray_blue[i];
         end;
      end;
   end else begin
      port[$3c8] := 0;
      for i := 0 to 15 do begin
         port[$3c9] := palette_data[i,1];
         port[$3c9] := palette_data[i,2];
         port[$3c9] := palette_data[i,3];
      end;
   end;
end;

procedure fadeOut(var palette_data : palette_T; delay : byte);
var
   i,j : word;
   gray_red, gray_green, gray_blue : array[0..15] of byte;
begin
   for i := 0 to 15 do begin
      gray_red[i] := palette_data[i,1];
      gray_green[i] := palette_data[i,2];
      gray_blue[i] := palette_data[i,3];
   end;
   if delay > 0 then begin
      for j := 63 downto 0 do begin
         waitVerticalRetrace(delay);
         port[$3c8] := 0;
         for i := 0 to 15 do begin
            if (gray_red[i] > j) then gray_red[i] := j;
            if (gray_green[i] > j) then gray_green[i] := j;
            if (gray_blue[i] > j) then gray_blue[i] := j;
            port[$3c9] := gray_red[i];
            port[$3c9] := gray_green[i];
            port[$3c9] := gray_blue[i];
         end;
      end;
   end else begin
      port[$3c8] := 0;
      for i := 0 to 15 do begin
         port[$3c9] := 0;
         port[$3c9] := 0;
         port[$3c9] := 0;
      end;
   end;
end;

procedure copyPage; assembler;
asm
         push ds
         push es

         mov dx, $3CE
         mov al, $05
         out dx, al
         inc dx
         in  al, dx
         and al, $FC
         or  al, $01
         out dx, al

         mov es, SegA000
         mov di, $8000
         mov ds, SegA000
         mov si, $0000

         mov cx, 80 * 400
         cld
         rep movsb

         mov dx, $3CE
         mov al, $05
         out dx, al
         inc dx
         in  al, dx
         and al, $FC
         out dx, al

         pop es
         pop ds

end;

procedure flipPageEASY;
begin
   setActivePage(1);
   setFillStyle(SOLIDFILL,BLACK);
   bar(SCROLL_X_GAP*8,SCROLL_Y_GAP-10,SCROLL_X_GAP*8+(2*SCROLL_X_WIDE+1)*24,SCROLL_Y_GAP-1);
   setActivePage(0);
{$IFDEF __VERTICAL_RETRACE}
   waitVerticalRetrace(1);
{$ENDIF}
   asm
         push ds
         push es

         mov dx, $3CE
         mov al, $05
         out dx, al
         inc dx
         in  al, dx
         and al, $FC
         or  al, $01
         out dx, al

         mov es, SegA000
         mov di, $0000
         mov ds, SegA000
         mov si, $8000

         mov cx, 80 * 400
         cld
         rep movsb

         mov dx, $3CE
         mov al, $05
         out dx, al
         inc dx
         in  al, dx
         and al, $FC
         out dx, al

         pop es
         pop ds

   end;
end;

procedure flipPage;
var
   gap, count : word;
   index : word;
begin
{$IFDEF __VERTICAL_RETRACE}
   waitVerticalRetrace(1);
{$ENDIF}
   gap := (2 * SCROLL_X_WIDE + 1) * TILE_X_SIZE;
   count := (2 * SCROLL_Y_WIDE + 1) * TILE_Y_SIZE;
   index := SCROLL_Y_GAP * 80 + SCROLL_X_GAP;
   asm
         push ds
         push es

         mov bx, gap;
         mov dx, $3CE
         mov al, $05
         out dx, al
         inc dx
         in  al, dx
         and al, $FC
         or  al, $01
         out dx, al

         mov es, SegA000
         mov di, index
         mov ds, SegA000
         mov si, index
         add si, $8000

         mov cx, count
@JUMP0:
         push cx

         mov cx, bx
         cld
         rep movsb

         add si, 80
         sub si, bx
         add di, 80
         sub di, bx

         pop cx

         loop @JUMP0

         mov dx, $3CE
         mov al, $05
         out dx, al
         inc dx
         in  al, dx
         and al, $FC
         out dx, al

         pop es
         pop ds

   end;
end;

procedure flipGrayScalePage;
var
   gap, count : word;
   index : word;
begin
{$IFDEF __VERTICAL_RETRACE}
   waitVerticalRetrace(1);
{$ENDIF}
   gap := (2 * SCROLL_X_WIDE + 1) * TILE_X_SIZE;
   count := (2 * SCROLL_Y_WIDE + 1) * TILE_Y_SIZE;
   index := SCROLL_Y_GAP * 80 + SCROLL_X_GAP;
   asm
         push ds
         push es

         mov bx, gap

         mov dx, $3C4
         mov ax, $0702 { CLEAR EXCEPT INTENSITY PLANE }
         out dx, ax

         mov es, SegA000
         mov di, index
         mov ds, SegA000
         mov si, index
         add si, $8000

         mov ax, $00;
         mov cx, count
@JUMP0:
         push cx

         mov cx, bx
         cld
         rep stosb

         add si, 80
         sub si, bx
         add di, 80
         sub di, bx

         pop cx

         loop @JUMP0

         mov dx, $3C4
         mov ax, $0802 { WRITE INTENSITY PLANE ONLY }
         out dx, ax

         mov dx, $3CE
         mov al, $04
         mov ah, 3     { READ INTENSITY PLANE ONLY }
         out dx, ax

         mov si, index
         mov di, index

         mov cx, count
@JUMP1:
         push cx

         mov cx, gap
         cld
         rep movsb

         add si, 80
         sub si, gap
         add di, 80
         sub di, gap

         pop cx

         loop @JUMP1

         mov dx, $3C4
         mov ax, $0F02
         out dx, ax

         pop es
         pop ds
   end;
end;

procedure scrollScreen(x1,y1,x2,y2,line,back_color : word; is_scroll_up : boolean);
var
   x_start, y_start : word;
   x_length, y_length, x_gap : word;
begin
   x_start := x1;
   y_start := y1 * 16 * 80 + x1;
   x_length := x2 - x1 + 1;
   y_length := (y2 - y1 - 1) * 16;
   x_gap := 80 - x_length;
   line := line * 80;

   asm
      push ds
      push si
      push di

      mov dx, $3CE
      mov al, $05
      out dx, al
      inc dx
      in  al, dx
      and al, $FC
      or  al, $01
      out dx, al

      mov dx, $3C4
      mov ax, $0F02
      out dx, ax

      mov es, SegA000
      mov ds, SegA000
      mov si, y_start
      mov di, y_start
      add si, line

      mov cx, y_length
@JUMP1:
      push cx
      mov cx, x_length
      cld
      rep movsb
      add si, x_gap
      add di, x_gap

      pop cx
      loop @JUMP1

      mov dx, $3CE
      mov al, $05
      out dx, al
      inc dx
      in  al, dx
      and al, $FC
      out dx, al

      pop di
      pop si
      pop ds
   end;

   setFillStyle(SOLIDFILL,back_color);
   bar(x1*8,(y2-1)*16,x2*8,y2*16);

end;

procedure printString(x,y : integer; s : string; color : word; FILL : boolean; fill_color : word);
begin
   if FILL then begin
      setFillStyle(SolidFill,fill_color);
      Bar(x*8,y*16,x*8,y*16);
      Bar(x*8,y*16,(x+length(s))*8,y*16+15);
   end;
   setHanColor(color);
   PrintHangul(x*8,y*16,s);
end;
(*
function revertFile(source_file_name, destination_file_name : string) : boolean;
var
   buffer : ^buffer_T;
   size : longint;
   CX_count : word;
   temp_b : byte;
   read_f, write_f : file;
   _segment, _offset : word;
begin
   assign(read_f,source_file_name);
   {$I-}
   reset(read_f,1);
   {$I+}
   if IOResult <> 0 then begin
      revertFile := FALSE;
      exit;
   end;
   size := FileSize(read_f);
   assign(write_f,destination_file_name);
   rewrite(write_f,1);

   getMem(buffer,10000);
   _segment := seg(buffer^);
   _offset := ofs(buffer^);

   while size > 0 do begin
      if size > 10000 then begin
         BlockRead(read_f,buffer^[0],10000);
         CX_count := 10000;
      end else begin
         BlockRead(read_f,buffer^[0],size);
         CX_count := size;
      end;

      asm
            push es

            mov es, _segment
            mov di, _offset
            mov cx, CX_count

      @LOOP:
            mov al, es:[di]
            sub al,57
            ror al,2
            not al
            mov es:[di], al
            inc di
            dec cx
            jnz @LOOP

            pop es
      end;

      BlockWrite(write_f,buffer^[0],CX_count);
      dec(size,CX_count);
   end;

   freeMem(buffer,10000);
   close(read_f);
   close(write_f);
   revertFile := TRUE;
end;
*)
function deleteFile(file_name : string) : boolean;
var
   f : file;
begin
   assign(f,file_name);
   {$I-}
   reset(f);
   {$I+}
   if IOResult = 0 then begin
      close(f);
      erase(f);
      deleteFile := TRUE;
   end else deleteFile := FALSE;
end;

function returnCheckSum(file_name : string) : longint;
var
   f : file;
   i : integer;
   size, temp_size, temp_long : longint;
   buffer : ^buffer_T;
begin
   getMem(buffer,10000);
   temp_long := 0;
   assign(f,file_name);
   {$I-}
   reset(f,1);
   {$I+}
   if IOResult <> 0 then begin
      chDir('..');
      printErrorMessage(1,file_name);
   end;
   size := FileSize(f);
   while size > 0 do begin
      if size >= 10000 then begin
         BlockRead(f,buffer^,10000);
         temp_size := 10000;
      end else begin
         BlockRead(f,buffer^,size);
         temp_size := size;
      end;
      size := size - temp_size;
      for i := 0 to temp_size - 1 do begin
         temp_long := temp_long + longint(buffer^[i]);
      end;
   end;
   close(f);
   freeMem(buffer,10000);
   returnCheckSum := temp_long;
end;

procedure printErrorMessage(error_number : byte; s : string);
begin
   _ERROR_MESSAGE := s;
   _ERROR_NUMBER := error_number;
   halt;
end;

procedure printFadingMessage(s : string; restore : boolean);
const
   CO_RGSTR = 15;
var
   i : integer;
begin
   setPalette(CO_RGSTR);
   setRGB(CO_RGSTR,0,0,0);
   printString(39 - length(s) div 2,10,s,CO_RGSTR,TRUE,0);
   for i := 1 to 63 do begin
      setRGB(CO_RGSTR,i,i,i);
      waitVerticalRetrace(1);
   end;
   pressAnyKey;
   for i := 63 downto 0 do begin
      setRGB(CO_RGSTR,i,i,i);
      waitVerticalRetrace(1);
   end;
   if restore then begin
      setRGB(CO_RGSTR,palette_data[CO_RGSTR,1],
          palette_data[CO_RGSTR,2],palette_data[CO_RGSTR,3]);
   end;
   printString(39 - length(s) div 2,10,s,0,TRUE,0);
end;

procedure printMessageWindowSub(message : string; back_color : integer);
var
   window : ^window_O;
   remember_han_type : han_type_T;
   window_size : byte;
begin
   remember_han_type := getHanType;
   copyPage;
   window_size := length(message) div 2 + 1;
   if window_size < 10 then window_size := 10;
   new(window,init(40-window_size,10,41+window_size,11,back_color,TRUE));
   setHanType(MYUNGJO);
   window^.printHangul(' '+message);
   pressAnyKey;
   dispose(window,done);
   setHanType(remember_han_type);
end;

procedure printMessageWindow(message : string);
begin
   printMessageWindowSub(message,3);
end;

procedure printTalkHangul(x,y : integer; s : string; back_color : byte);
begin
   if s <> '' then begin
      case game_system.getOutlineTalk of
         SLASH_OUTLINE :
         begin
            setFillStyle(6,1);
            Bar(x*8,y*16,x*8,y*16);
            Bar(x*8,y*16,(x+length(s))*8,y*16+15);
         end;
         NET_IMAGE_OUTLINE :
         begin
            printNetImage(16,y*16,639,y*16+15,0);
         end;
      end;
      printHangulOUTLINE(x*8,y*16,s,back_color);
   end;
end;

procedure drawBox(x1, y1, x2, y2 : integer; color : integer; is_shadow, is_bold : boolean);
const
   BOX_EDGE = 8;
   BOX_EDGE_FOR_BOLD = 9;
begin
   setFillStyle(SOLIDFILL,color);
   Bar(x1,y1,x2,y2);

   moveTo(x1,y2);
   setColor(WHITE);
   lineTo(x1,y1); lineTo(x2,y1);
   setcolor(DARKGRAY);
   lineTo(x2,y2); lineTo(x1,y2);
   if is_bold then begin
      moveTo(x1-1,y2-1);
      setColor(WHITE);
      lineTo(x1-1,y1+1); lineTo(x2-1,y1+1);
      setColor(DARKGRAY);
      lineTo(x2-1,y2-1); lineTo(x1+1,y2-1);
   end;

   if is_shadow then begin
      moveTo(x1+BOX_EDGE,y2-BOX_EDGE);
      setColor(DARKGRAY);
      lineTo(x1+BOX_EDGE,y1+BOX_EDGE); lineTo(x2-BOX_EDGE,y1+BOX_EDGE);
      setColor(WHITE);
      lineTo(x2-BOX_EDGE,y2-BOX_EDGE); lineTo(x1+BOX_EDGE,y2-BOX_EDGE);
      if is_bold then begin
	 moveTo(x1+BOX_EDGE_FOR_BOLD,y2-BOX_EDGE_FOR_BOLD);
	 setColor(DARKGRAY);
	 lineTo(x1+BOX_EDGE_FOR_BOLD,y1+BOX_EDGE_FOR_BOLD); lineTo(x2-BOX_EDGE_FOR_BOLD,y1+BOX_EDGE_FOR_BOLD);
	 setColor(WHITE);
	 lineTo(x2-BOX_EDGE_FOR_BOLD,y2-BOX_EDGE_FOR_BOLD); lineTo(x1+BOX_EDGE_FOR_BOLD,y2-BOX_EDGE_FOR_BOLD);
      end;
   end;
end;

constructor window_O.init(x1,y1,x2,y2,color : integer; is_normal_mode : boolean);
const
   ZOOM_DIVISION = 5;
var
   x_center, y_center : integer;
   i, add_from_center : integer;
begin
   m_color := 15;
   m_back_color := color;
   m_x_cursor := x1;
   m_y_cursor := y1;
   x_center := (x1 + x2) div 2;
   y_center := (y1 + y2) div 2;
   if is_normal_mode then begin
      for i := 1 to ZOOM_DIVISION-1 do begin
         add_from_center := (x2 - x1) * i div (2*ZOOM_DIVISION);
         m_x1 := x_center - add_from_center;
         m_x2 := x_center + add_from_center;
         add_from_center := (y2 - y1) * i div (2*ZOOM_DIVISION);
         m_y1 := y_center - add_from_center;
         m_y2 := y_center + add_from_center;
         drawWindow;
         if not KeyPressed then waitVerticalRetrace(3);
      end;
   end;
   m_x1 := x1;
   m_x2 := x2;
   m_y1 := y1;
   m_y2 := y2;
   if is_normal_mode then
      drawWindow
   else
      drawNetImage;
   while KeyPressed do readKey;
end;

destructor window_O.done;
begin
   flipPageEASY;
end;

procedure window_O.drawWindow;
const
   is_shadow = TRUE;
   is_bold = FALSE;
   BOX_EDGE = 15;
   SHADOW_EDGE = 10;
var
   x1, x2, y1, y2 : integer;
begin
   x1 := m_x1 * 8 - BOX_EDGE;
   x2 := m_x2 * 8 + BOX_EDGE;
   y1 := m_y1 * 16 - BOX_EDGE;
   y2 := m_y2 * 16 + BOX_EDGE;
   if is_shadow then begin
      drawBox(x1,y1,x2,y2,LIGHTGRAY,is_shadow,is_bold);
      drawBox(x1+SHADOW_EDGE,y1+SHADOW_EDGE,x2-SHADOW_EDGE,y2-SHADOW_EDGE,m_back_color,FALSE,is_bold);
   end else begin
      drawBox(x1,y1,x2,y2,m_color,is_shadow,is_bold);
   end;
   setFillStyle(SOLIDFILL,BLACK);
   Bar(x1+SHADOW_EDGE,y2+1,x2,y2+SHADOW_EDGE);
   Bar(x2+1,y1+SHADOW_EDGE,x2+SHADOW_EDGE,y2+SHADOW_EDGE);
end;

procedure window_O.drawNetImage;
begin
   printNetImage(m_x1 * 8,m_x2 * 8,m_y1 * 16,m_y2 * 16,0);
end;

procedure window_O.setCursor(x,y : integer);
begin
   m_x_cursor := m_x1 + x;
   m_y_cursor := m_y1 + y;
end;

procedure window_O.clearWindow(color : byte);
begin
   setFillStyle(SOLIDFILL,color);
   bar(m_x1 * 8,m_y1 * 16,m_x2 * 8,m_y2 * 16);
end;

procedure window_O.scrollUp(line : byte);
begin
end;

procedure window_O.scrollDown(line : byte);
begin
end;

procedure window_O.printHangul(s : string);
var
   temp_s : string;
   s_ptr : integer;
   exit_condition : boolean;

 function processOptions(option : char) : boolean;
 begin
    processOptions := FALSE;
    case option of
       '0'..'9' : m_color := ord(option) - ord('0');
       'A'..'F' : m_color := ord(option) - ord('A') + 10;
       'a'..'f' : m_color := ord(option) - ord('a') + 10
       else processOptions := TRUE;
    end;
 end;

begin

   while s <> '' do begin

      if s[1] <> '@' then begin
         s_ptr := 0;
      end else begin
         if processOptions(s[2]) then begin
            m_x_cursor := m_x1;
            inc(m_y_cursor);
         end;
         s_ptr := 2;
      end;
      if m_x_cursor >= (m_x2 - 1) then begin
         m_x_cursor := m_x1;
         inc(m_y_cursor);
      end;

      temp_s := '';
      if s_ptr < length(s) then
         exit_condition := FALSE
      else
         exit_condition := TRUE;

      while not exit_condition do begin
         if s[s_ptr+1] = '@' then begin
            exit_condition := TRUE;
         end else begin
            inc(s_ptr);
            inc(temp_s[0]);
            temp_s[ord(temp_s[0])] := s[s_ptr];
            if (ord(s[s_ptr]) and $80) > 0 then begin
               inc(s_ptr);
               inc(temp_s[0]);
               temp_s[ord(temp_s[0])] := s[s_ptr];
            end;
         end;
         if ((length(temp_s) + m_x_cursor) >= (m_x2 - 1)) or
            (length(s) <= s_ptr) then begin
            exit_condition := TRUE;
         end;
      end;
      s := copy(s,s_ptr+1,length(s)-s_ptr);
      if m_y_cursor >= m_y2 then begin
         m_y_cursor := m_y2-1;
         pressAnyKey;
         scrollScreen(m_x1,m_y1,m_x2,m_y2,16,m_back_color,TRUE);
      end;
      printString(m_x_cursor,m_y_cursor,temp_s,m_color,FALSE,0);
      m_x_cursor := m_x_cursor + length(temp_s);
   end;
end;

constructor titled_window_O.init;
begin
   EXTRA_EDGE := 0;
   m_title := title;
   inherited init(x1,y1,x2,y2,color,is_normal_mode);
   inc(m_y1,2);
   EXTRA_EDGE := 4;
end;

procedure titled_window_O.drawAuxWindow;
begin
   drawBox(m_x1*8-EXTRA_EDGE,(m_y1-2)*16-EXTRA_EDGE,m_x2*8+EXTRA_EDGE,(m_y1-1)*16+EXTRA_EDGE,1,FALSE,TRUE);
   setHanColor(WHITE);
   DVHan20.printHangul((m_x1+m_x2)*4-EXTRA_EDGE-(length(m_title)-1)*4,(m_y1-2)*16-EXTRA_EDGE+4,m_title);
end;

procedure titled_window_O.drawWindow;
begin
   inherited drawWindow;
   if EXTRA_EDGE = 0 then inc(m_y1,2);
   drawAuxWindow;
   if EXTRA_EDGE = 0 then dec(m_y1,2);
end;

procedure titled_window_O.clearWindow(color : byte);
begin
   inherited clearWindow(color);
   drawAuxWindow;
end;

procedure titled_window_O.setTitle(title : string);
begin
   m_title := title;
end;

constructor select_O.init;
begin
   setMenuMode(NORMAL_MENU);
end;

destructor select_O.done;
begin
end;

procedure select_O.setMenu(num : integer; s : string);
begin
   if (length(s) < 50) and (num in [1..50]) then
      m[num] := s
   else
      m[num] := '';
end;

procedure select_O.setMenuColor(_LIGHT,_DARK : byte);
begin
   LIGHT := _LIGHT;
   DARK := _DARK;
end;

procedure select_O.setMenuMode(mode : menu_mode_T);
type
   menu_color_T = record
      LIGHT, DARK : byte;
   end;
const
   mode_data : array[NORMAL_MENU..EXTENDED_MENU] of menu_color_T = (
      (LIGHT : $0A; DARK : $02),
      (LIGHT : $0F; DARK : $07),
      (LIGHT : $0F; DARK : $07),
      (LIGHT : $0E; DARK : $0D)
   );
begin
   m_menu_mode := mode;
   LIGHT := mode_data[mode].LIGHT;
   DARK := mode_data[mode].DARK;
end;

procedure select_O.arrangeMenu(max_line : integer);
var
   i,j : integer;
   max_length, rest_length : integer;
begin
   max_length := 0;
   for i := 1 to max_line do begin
      if length(m[i]) > max_length then max_length := length(m[i]);
   end;
   for i := 1 to max_line do begin
      for j := length(m[i])+1 to max_length do begin
         m[i][j] := #32;
      end;
      rest_length := (max_length - length(m[i])) div 2;
      m[i][0] := chr(max_length);
      for j := max_length downto 1 do begin
         if j > rest_length then
            m[i][j] := m[i][j-rest_length]
         else
            m[i][j] := #32;
      end;
   end;
end;

function select_O.selectMenu(x,y,line,max_line : integer) : integer;
var
   i, j, color : integer;
   y_vector : integer;
   c : integer;
   is_delete : boolean;
begin
   if m_menu_mode = EXTENDED_MENU then begin
      selectMenu := selectMenu4ExtendedMenu(x,y,line,max_line);
      exit;
   end;
   if max_line in [1..50] then begin
      is_delete := (m_menu_mode <> NORMAL_MENU);
      if m_menu_mode in [DELETED_MENU,BOLD_MENU] then begin
         arrangeMenu(max_line);
      end;
      if not(line in [1..max_line]) then line := 1;
      for i := 1 to max_line do begin
         if i = line then color := LIGHT else color := DARK;
         if (m_menu_mode = BOLD_MENU) and (i = line) then begin
            printString(x,y+(i-1),m[i],color,is_delete,0);
            setHanColor(color);
            printHangulOUTLINE(x*8,(y+(i-1))*16,m[i],DARK);
         end
         else
            printString(x,y+(i-1),m[i],color,is_delete,0);
      end;
      if m_menu_mode = DELETED_MENU then begin
         setColor(LIGHTGRAY);
         moveTo(x*8-1,(y+max_line)*16);
         lineTo(x*8-1,y*16-1);
         lineTo((x+length(m[1]))*8+1,y*16-1);
         setColor(WHITE);
         lineTo((x+length(m[1]))*8+1,(y+max_line)*16);
         lineTo(x*8-1,(y+max_line)*16);
      end;
      repeat
         y_vector := 0;
         c := ord(readKey);
         if c = 0 then c := SCAN_CODE + ord(readKey);
         case c of
            UP_KEY : y_vector := -1;
            DOWN_KEY : y_vector := 1;
         end;
         if y_vector <> 0 then begin
            printString(x,y+(line-1),m[line],DARK,is_delete,0);
            line := line + y_vector;
            if line < 1 then line := max_line;
            if line > max_line then line := 1;
            if (m_menu_mode = BOLD_MENU) then begin
               setHanColor(LIGHT);
               printHangulOUTLINE(x*8,(y+(line-1))*16,m[line],DARK);
            end
            else
               printString(x,y+(line-1),m[line],LIGHT,is_delete,0);
         end;
      until byte(c) in [ACCEPT_KEY,ESCAPE_KEY];
      if c = ACCEPT_KEY then selectMenu := line
                        else selectMenu := 0;
   end
   else selectMenu := 0;
end;

Function Select_O.selectMenu4ExtendedMenu(x,y,line,max_line : integer) : integer;
var
   i, y_absolute, y_line, y_vector : integer;
   key_code : integer;
   max_length, MAX_VISUAL_LINE : byte;

 procedure displayMenu4ExtendedMenu(x, y, y_absolute, y_line :integer);
 var
    i, color : integer;
 begin
    for i := 1 to MAX_VISUAL_LINE do begin
       if i = y_line then color := LIGHT else color := DARK;
       setFillStyle(SOLIDFILL,1);
       Bar((x-1)*8,(y+(i-1))*16,(x+1)*8,(y+(i-1))*16);
       Bar((x-1)*8,(y+(i-1))*16,((x+1)+max_length)*8,(y+(i-1))*16+15);
       printString(x,y+(i-1),m[y_absolute+i-1],color,FALSE,0);
    end;
 end;

begin
   arrangeMenu(max_line);
   if max_line >= 5 then MAX_VISUAL_LINE := 5
                    else MAX_VISUAL_LINE := max_line;
   if line > max_line then line := max_line;
   if max_line in [1..50] then begin
      max_length := 0;
      for i := 1 to max_line do begin
         if length(m[i]) > max_length then max_length := length(m[i]);
      end;
      setColor(5);
      Rectangle((x-1)*8-2,y*16-2,((x+1)+max_length)*8+2,(y+MAX_VISUAL_LINE)*16+2);
      setColor(9);
      Rectangle((x-1)*8-3,y*16-3,((x+1)+max_length)*8+3,(y+MAX_VISUAL_LINE)*16+3);
      y_absolute := 1;
      y_line := line;
      while y_line > MAX_VISUAL_LINE do begin
         inc(y_absolute);
         dec(y_line);
      end;
      if y_line = MAX_VISUAL_LINE then begin
         if (y_absolute + y_line -1 + MAX_VISUAL_LINE div 2) <= max_line then begin
            y_absolute := y_absolute + MAX_VISUAL_LINE div 2;
            y_line := y_line - MAX_VISUAL_LINE div 2;
         end;
      end;
      displayMenu4ExtendedMenu(x, y, y_absolute, y_line);
      repeat
         y_vector := 0;
         key_code := ord(readKey);
         if key_code = 0 then begin
            key_code := ord(readKey);
            key_code := SCAN_CODE + key_code;
         end;
         case key_code of
            72 + SCAN_CODE : y_vector := -1;
            80 + SCAN_CODE : y_vector := 1;
         end;
         if y_vector <> 0 then begin
            y_line := y_line + y_vector;
            if y_line < 1 then begin
               if y_absolute > 1 then begin
                  dec(y_absolute);
               end;
               y_line := y_line - y_vector;
            end;
            if y_line > MAX_VISUAL_LINE then begin
               if y_absolute <= max_line - MAX_VISUAL_LINE then begin
                  inc(y_absolute);
               end;
               y_line := y_line - y_vector;
            end;
            displayMenu4ExtendedMenu(x, y, y_absolute, y_line);
         end;
      until byte(key_code) in [ACCEPT_KEY,ESCAPE_KEY];
      if key_code = ACCEPT_KEY then selectMenu4ExtendedMenu := y_absolute + y_line - 1
                               else selectMenu4ExtendedMenu := 0;
   end
   else selectMenu4ExtendedMenu := 0;
end;

constructor system_O.init;
var
   i : integer;
begin
   m_year := 1996;
   m_month := 6;
   m_day := 7;
   m_hour := 7;
   m_minute := 10;
   m_second := 0;
   m_event_time := 0;
   m_remember_previous_time := setCurrentTime;
   updateSystemCount;
   lockMovement;
   setOutlineTalk(NORMAL_OUTLINE);
   setHPGause(FALSE);
   fillchar(m_event_bit_data,sizeof(m_event_bit_data),#0);
   fillchar(m_event_dump_data,sizeof(m_event_dump_data),#0);
end;

destructor system_O.done;
begin
end;

function system_O.returnHour : integer;
begin
   returnHour := m_hour;
end;

function system_O.returnMinute : integer;
begin
   returnMinute := m_minute;
end;

function system_O.setCurrentTime : longint;
var
   temp_longint : longint;
   hour, minute, second, sec100 : word;
begin
   getTime(hour,minute,second,sec100);
   temp_longint := (hour * (60*60) + minute * 60 + second) * 4 + sec100 div 25;
   setCurrentTime := temp_longint;
end;

procedure system_O.updateSystemCount;
begin
   m_system_count := setCurrentTime;
end;

function system_O.getSystemCount : longint;
begin
   getSystemCount := m_system_count;
end;

procedure system_O.lockMovement;
begin
   m_enable_to_move := FALSE;
end;

procedure system_O.unlockMovement;
begin
   m_enable_to_move := TRUE;
end;

function system_O.enableToMove : boolean;
begin
   enableToMove := m_enable_to_move;
end;

procedure system_O.setWalkAll(how : boolean);
begin
   m_can_walk := how;
end;

function system_O.canWalkAll : boolean;
begin
   canWalkAll := m_can_walk;
end;

function system_O.getPreviousTime : longint;
begin
   getPreviousTime := m_remember_previous_time;
end;

procedure system_O.setPreviousTime(previous_time : longint);
begin
   m_remember_previous_time := previous_time;
end;

procedure system_O.setOutlineTalk(how : out_line_talk_T);
begin
   m_outline_talk_method := how;
end;

function system_O.getOutlineTalk : out_line_talk_T;
begin
   getOutlineTalk := m_outline_talk_method;
end;

procedure system_O.setHPGause(how : boolean);
begin
   m_enable_HP_gauge := how;
end;

function system_O.enableHPGauge : boolean;
begin
   enableHPGauge := m_enable_HP_gauge;
end;

procedure system_O.passTime(day,hour,minute,second : integer);
begin
   m_day := m_day + day;
   m_hour := m_hour + hour;
   m_minute := m_minute + minute;
   m_second := m_second + second;
   while (m_second >= 60) do begin
      dec(m_second,60);
      inc(m_minute);
   end;
   while (m_minute >= 60) do begin
      dec(m_minute,60);
      inc(m_hour);
   end;
   while (m_hour >= 24) do begin
      dec(m_hour,24);
      inc(m_day);
   end;
   while (m_day > 30) do begin
      dec(m_day,30);
      inc(m_month);
   end;
   while (m_month > 12) do begin
      dec(m_month,12);
      inc(m_year);
   end;
   if m_event_time > 0 then begin
      m_remain_event_time := m_remain_event_time - (day*3600*24+hour*3600+minute*60+second);
      if m_remain_event_time <= 0 then begin
         _PERSON_CONTROLL_CODE := OCCUR_TIME_EVENT;
      end;
   end;
end;

procedure system_O.setTime(day,hour,minute,second : integer);
begin
   if day > 0 then
      m_day := day;
   m_hour := hour;
   m_minute := minute;
   m_second := second;
   passTime(0,0,0,0);
end;

procedure system_O.setEventTime(event_number,day,hour,minute,second : integer);
begin
   m_event_time := event_number;
   if event_number > 0 then
      m_remain_event_time := (day*3600*24+hour*3600+minute*60+second);
end;

function system_O.returnEventTime : integer;
begin
   returnEventTime := m_event_time;
end;

function system_O.returnTimeString(paren : boolean) : string;
var
   s,temp_s : string;
begin
   str(m_hour:2,temp_s);
   if paren then s := '< '+temp_s else s := temp_s;
   str(m_minute:2,temp_s);
   if paren then s := s+':'+temp_s+' >' else s := s+':'+temp_s;

   returnTimeString := s;
end;

procedure system_O.setEventBit(bytes : integer);
var
   _byte,_bit : integer;
begin
   _byte := (bytes div 8);
   _bit := bytes mod 8;
   m_event_bit_data[_byte] := m_event_bit_data[_byte] or (1 shl _bit);
end;

procedure system_O.resetEventBit(bytes : integer);
var
   _byte,_bit : integer;
begin
   _byte := (bytes div 8);
   _bit := bytes mod 8;
   m_event_bit_data[_byte] := m_event_bit_data[_byte] and (not(1 shl _bit));
end;

function system_O.getEventBit(bytes : integer) : boolean;
var
   _byte,_bit : integer;
begin
   _byte := (bytes div 8);
   _bit := bytes mod 8;
   getEventBit := (m_event_bit_data[_byte] and (1 shl _bit)) > 0;
end;

procedure system_O.setEventDump(dump, value : byte);
begin
   if dump in [0..49] then
      m_event_dump_data[dump] := value;
end;

function system_O.getEventDump(dump : byte) : byte;
begin
   if dump in [0..49] then
      getEventDump := m_event_dump_data[dump];
end;

procedure system_O.setMapMaxSize(x,y : integer);
begin
   m_map_x_max := x;
   m_map_y_max := y;
end;

function system_O.returnMapXMax : integer;
begin
   returnMapXMax := m_map_x_max;
end;

function system_O.returnMapYMax : integer;
begin
   returnMapYMax := m_map_y_max;
end;

constructor movie_O.init;
var
   i : integer;
begin
   m_data_storage_ptr := 0;
   fillchar(m_movie_data,sizeof(m_movie_data),#0);
   for i := 1 to MAX_MOVIE_DATA div 10 do begin
      m_saved_image_data[i].SI_restore_count := 0;
   end;
end;

destructor movie_O.done;
begin
end;

procedure movie_O.setMovie(plane : map_attribute_T; image_number : byte; x,y, restore_count, spread_space : integer);
var
   variable_movie_data : ^movie_data_T;
begin
   if m_data_storage_ptr + 1 <= MAX_MOVIE_DATA then inc(m_data_storage_ptr);
   if spread_space = 0 then
      variable_movie_data := @m_movie_data[m_data_storage_ptr]
   else begin
      if spread_space <= MAX_MOVIE_DATA then
         variable_movie_data := @m_movie_data[spread_space]
      else
         exit; (* It's a bug !!! *)
   end;

   with variable_movie_data^ do begin
      MD_plane := plane;
      MD_image_number := image_number;
      MD_x := x;
      MD_y := y;
      MD_restore_count := restore_count;
   end;
end;

procedure movie_O.printMirage(x,y : integer;bit_map : integer);
label
   LOOP_EXIT;
var
   saved_image_ptr : integer;
   temp_sprite : ^original_sprite_T;
begin
   if (x > SCROLL_X_GAP*8) and (y > SCROLL_Y_GAP) and
      (x < (SCROLL_X_GAP + 2*SCROLL_X_WIDE*TILE_X_SIZE) * 8) and
      (y < (SCROLL_Y_GAP + 2*SCROLL_Y_WIDE*TILE_Y_SIZE)) then begin

      setActivePage(1);
      if m_movie_data[m_data_storage_ptr].MD_restore_count < 255 then begin
         saved_image_ptr := 0;
         while saved_image_ptr < MAX_MOVIE_DATA do begin
            inc(saved_image_ptr);
            if m_saved_image_data[saved_image_ptr].SI_restore_count = 0 then begin
               getImage(x,y,x+23,y+23,m_saved_image_data[saved_image_ptr].SI_data);
               m_saved_image_data[saved_image_ptr].SI_x := x;
               m_saved_image_data[saved_image_ptr].SI_y := y;
               m_saved_image_data[saved_image_ptr].SI_restore_count
                  := m_movie_data[m_data_storage_ptr].MD_restore_count;
               goto LOOP_EXIT;
            end;
         end;
      end;
      LOOP_EXIT:
      setActivePage(0);

      new(temp_sprite);
      if bit_map <= ADDRESS_OF_WEAPON_IN_OBJECT_TILE then begin
         convertNew2OldSprite(object_tile_data[bit_map]^,temp_sprite^);
         putImage(x,y,temp_sprite^[294],AndPut);
         putImage(x,y,temp_sprite^,OrPut);
      end
      else if bit_map <= ADDRESS_OF_WEAPON_IN_OBJECT_TILE*2 then begin
         bit_map := bit_map - ADDRESS_OF_WEAPON_IN_OBJECT_TILE;
         convertNew2OldSprite(equipment_tile_data[bit_map]^,temp_sprite^);
         putImage(x,y,temp_sprite^[294],AndPut);
         putImage(x,y,temp_sprite^,OrPut);
      end
      else begin
         bit_map := bit_map - ADDRESS_OF_WEAPON_IN_OBJECT_TILE*2;
         convertNew2OldSprite(field_tile_data[bit_map]^,temp_sprite^);
         putImage(x,y,temp_sprite^[294],AndPut);
         putImage(x,y,temp_sprite^,OrPut);
      end;
      dispose(temp_sprite);
   end;
end;

procedure movie_O.restoreBackGround;
var
   saved_image_ptr : integer;
begin
   for saved_image_ptr := 1 to MAX_MOVIE_DATA div 10 do begin
      if m_saved_image_data[saved_image_ptr].SI_restore_count > 0 then begin
         dec(m_saved_image_data[saved_image_ptr].SI_restore_count);
         if m_saved_image_data[saved_image_ptr].SI_restore_count = 0 then begin
            with m_saved_image_data[saved_image_ptr] do begin
               putImage(SI_x,SI_y,SI_data,COPYPUT);
            end;
         end;
      end;
   end;
end;

procedure movie_O.makeMovieSub(params : attack_parameters_T; spread_space, defense_magic : integer);
const
   SHOOT_DETAIL = 10;
   QWERTY = 20;
var
   center_x, center_y, origin_x, origin_y, target_x, target_y : integer;
   i, j, add_information : integer;
   delta_x, delta_y, count : real;
   count_of_movement, revolution : integer;
   spread_count : integer;
begin
   center_x := (SCROLL_X_GAP + SCROLL_X_WIDE * TILE_X_SIZE) * 8 + 12;
   center_y := SCROLL_Y_GAP + SCROLL_Y_WIDE * TILE_Y_SIZE;
   i := (params.x_source - _MAP_X_CENTER) * TILE_Y_SIZE;
   j := (params.y_source - _MAP_Y_CENTER) * TILE_Y_SIZE;
   origin_x := center_x + i;
   origin_y := center_y + j;
   i := (params.x_destination - _MAP_X_CENTER) * TILE_Y_SIZE;
   j := (params.y_destination - _MAP_Y_CENTER) * TILE_Y_SIZE;
   target_x := center_x + i;
   target_y := center_y + j;
   i := target_x - origin_x;
   j := target_y - origin_y;
   if abs(i) >= abs(j) then
      count_of_movement := round(abs(i / SHOOT_DETAIL))
   else
      count_of_movement := round(abs(j / SHOOT_DETAIL));
   if count_of_movement > 0 then begin
      delta_x := i / count_of_movement;
      delta_y := j / count_of_movement;
   end else exit;

   count := 0.0; revolution := 1; spread_count := 0;
   while round(count) < longint(count_of_movement) do begin
      if (count < 5) and (params.attack_type = _pierce) then begin
         count := count + 0.25;
         i := origin_x + round(delta_x * count);
         j := origin_y + round(delta_y * count);
      end else begin
         count := count + 1;
         i := origin_x + round(delta_x * count);
         j := origin_y + round(delta_y * count);
      end;
      if params.shape <= ADDRESS_OF_WEAPON_IN_OBJECT_TILE*2 then
         add_information := 0
      else
         add_information := ADDRESS_OF_MIRAGE_IN_FIELD_TILE;
      if spread_space = 0 then begin
         setMovie(MA_OBJECT,params.shape+pred(revolution)+add_information,
                  i-12,j-12,params.trailing_count,0);
      end
      else begin
         setMovie(MA_OBJECT,params.shape+pred(revolution)+add_information,
                  i-12,j-12,params.trailing_count,QWERTY*spread_count+spread_space);
      end;
      inc(revolution);
      inc(spread_count);
      if revolution > params.shape_revolution then revolution := 1;
   end;

end;

procedure movie_O.makeMovie(var params : attack_parameters_T; defense_magic : integer);
begin
   makeMovieSub(params,0,defense_magic);
end;

procedure movie_O.makeMovie4Spread(var params : attack_parameters_T; space : integer);
begin
   makeMovieSub(params,space,0);
end;

procedure movie_O.arrangeMovie;
var
   i,j,k : integer;
begin
   for i := 1 to MAX_MOVIE_DATA do begin
      if m_movie_data[i].MD_x = 0 then begin
         k := 1;
         while (k+i <= MAX_MOVIE_DATA) and
               (m_movie_data[k+i].MD_x = 0) do inc(k);
         if k+i <= MAX_MOVIE_DATA then begin
            for j := i to MAX_MOVIE_DATA do begin
               if j+k <= MAX_MOVIE_DATA then begin
                  m_movie_data[j] := m_movie_data[j+k];
               end;
            end;
         end;
      end;
   end;
   m_data_storage_ptr := 0;
   while m_movie_data[m_data_storage_ptr+1].MD_x <> 0 do inc(m_data_storage_ptr);
end;

procedure movie_O.playMovie(wait_clock : integer);
var
   c : char;
   i : integer;
begin
   for i := 1 to m_data_storage_ptr do begin
      with m_movie_data[i] do begin
         restoreBackGround;
         printMirage(MD_x, MD_y, MD_image_number);
         waitVerticalRetrace(wait_clock);
      end;
   end;
   flipPageEASY;
end;

function readMap(MA : map_attribute_T; x,y : integer) : byte;
begin
   readMap := map[MA]^[game_system.m_map_x_max * y + x]
end;

function isMovableMap(x,y : integer) : boolean;
begin
   if (x in [0..pred(map_header.map_x_max)]) and (y in [0..pred(map_header.map_y_max)]) then begin
      isMovableMap := (((readMap(MA_ATTRIBUTE,x,y) and WALKABLE_BIT) = 0) and
          (readMap(MA_OBJECT,x,y) in MOVABLE_OBJECT_TILE) and
          (readMap(MA_FIELD,x,y) in MOVABLE_FIELD_TILE) and (readMap(MA_PERSON,x,y) = 0));
   end else begin
      isMovableMap := FALSE;
   end;
end;

function isSafeMovableMap(x,y : integer) : boolean;
begin
   if (x in [0..pred(map_header.map_x_max)]) and (y in [0..pred(map_header.map_y_max)]) then begin
      isSafeMovableMap := (((readMap(MA_ATTRIBUTE,x,y) and WALKABLE_BIT) = 0) and
          (readMap(MA_OBJECT,x,y) in MOVABLE_OBJECT_TILE) and
          (readMap(MA_FIELD,x,y) = 0) and (readMap(MA_PERSON,x,y) = 0));
   end else begin
      isSafeMovableMap := FALSE;
   end;
end;

function isPassableMap(x, y : integer) : boolean;
const
   DISABLE_FLYING_TILE : set of byte = [90,91,96..144];
begin
   if (x in [0..pred(map_header.map_x_max)]) and (y in [0..pred(map_header.map_y_max)]) then begin
      isPassableMap := (
         (
         ((readMap(MA_ATTRIBUTE,x,y) and WALKABLE_BIT) = 0) or
          (not (readMap(MA_NORMAL,x,y) in DISABLE_FLYING_TILE))
         ) and
         (readMap(MA_OBJECT,x,y) in PASSABLE_OBJECT_TILE) and
         (readMap(MA_FIELD,x,y) in PASSABLE_FIELD_TILE) and
         ((readMap(MA_ATTRIBUTE,x,y) and EVENT_BIT) <> EVENT_BIT) and
         (readMap(MA_PERSON,x,y) = 0)
      );
   end else begin
      isPassableMap := FALSE;
   end;
end;

procedure writeMap(MA : map_attribute_T; x,y,value : byte);
begin
   if not assigned(map[MA]) then exit;
   if (x in [0..game_system.returnMapXMax-1]) and (y in [0..game_system.returnMapYMax-1]) then begin
      if MA in [succ(START_OF_MAP_ATTRIBUTE)..pred(END_OF_MAP_ATTRIBUTE)] then begin
         map[MA]^[game_system.returnMapXMax * y + x] := value;
         if MA = MA_NORMAL then begin
            if value in (MOVABLE_TILE + FOREGROUND_TILE) then
               map[MA_ATTRIBUTE]^[game_system.returnMapXMax * y + x] :=
                  map[MA_ATTRIBUTE]^[game_system.returnMapXMax * y + x] and (not WALKABLE_BIT)
            else
               map[MA_ATTRIBUTE]^[game_system.returnMapXMax * y + x] :=
                  map[MA_ATTRIBUTE]^[game_system.returnMapXMax * y + x] or WALKABLE_BIT;
         end;
      end;
   end;
end;

procedure writeMapEXPAND(map_number, x, y, value : byte);
var
   MA : map_attribute_T;
   attribute_byte, new_byte : byte;
begin
   if map_number in [0..4] then begin
      for MA := succ(START_OF_MAP_ATTRIBUTE) to pred(END_OF_MAP_ATTRIBUTE) do begin
         if (ord(MA)-1) = map_number then begin
            if MA <> MA_ATTRIBUTE then begin
               writeMap(MA,x,y,value);
            end else begin
               writeMap(MA,x,y,readMap(MA,x,y) and (not EVENT_BIT) or value);
            end;
         end;
      end;
   end else begin
      case map_number of
         5 : attribute_byte := SEARCHABLE_BIT;
         6 : attribute_byte := FIXED_AIR_BIT;
         7 : attribute_byte := WALKABLE_BIT;
         8 : attribute_byte := BLIGHT_BIT;
      end;
      if value > 0 then new_byte := attribute_byte else new_byte := 0;
      writeMap(MA_ATTRIBUTE,x,y,
              (readMap(MA_ATTRIBUTE,x,y) and (not byte(attribute_byte))) or byte(new_byte));
   end;
end;

procedure fillMap(map_number, x1, y1, x2, y2, value : byte);
var
   temp_x, temp_y : byte;
begin
   for temp_y := y1 to y2 do begin
      for temp_x := x1 to x2 do begin
         writeMapEXPAND(map_number,temp_x,temp_y,value);
      end;
   end;
end;

procedure convertNew2OldImage(var source : image_T; var destination : original_image_T);
var
   i,j,k,plane : integer;
begin

   destination[0] := 23;
   destination[1] := 0;
   destination[2] := 23;
   destination[3] := 0;
   i := 0;
   j := 4;
   k := 0;
   plane := 0;
   while plane < 4 do begin
      destination[j] := source[i];
      inc(i);
      inc(k);
      if k < 3 then begin
         inc(j);
      end
      else begin
         inc(j,10);
         k := 0;
      end;
      if j >= IMAGE_SIZE+4 then begin
         inc(plane);
         j := 4 + plane * 3;
      end;
   end;

end;

procedure convertNew2OldSprite(var source : sprite_T; var destination : original_sprite_T);
var
   i,j,k,plane : integer;
begin

   destination[0] := 23;
   destination[1] := 0;
   destination[2] := 23;
   destination[3] := 0;
   i := 0;
   j := 4;
   k := 0;
   plane := 0;
   while plane < 4 do begin
      destination[j] := source[i];
      inc(i);
      inc(k);
      if k < 3 then begin
         inc(j);
      end
      else begin
         inc(j,10);
         k := 0;
      end;
      if j >= IMAGE_SIZE+4 then begin
         inc(plane);
         j := 4 + plane * 3;
      end;
   end;

   destination[IMAGE_SIZE+6+0] := 23;
   destination[IMAGE_SIZE+6+1] := 0;
   destination[IMAGE_SIZE+6+2] := 23;
   destination[IMAGE_SIZE+6+3] := 0;
   i := IMAGE_SIZE;
   j := IMAGE_SIZE+6+4;
   k := 0;
   plane := 0;
   while plane < 4 do begin
      destination[j] := source[i];
      inc(i);
      inc(k);
      if k < 3 then begin
         inc(j);
      end
      else begin
         inc(j,10);
         k := 0;
      end;
      if j >= IMAGE_SIZE + 6 + IMAGE_SIZE+4 then begin
         inc(plane);
         i := IMAGE_SIZE;
         j := 4 + plane * 3 + IMAGE_SIZE+6;
      end;
   end;

end;

procedure printWeaponCursor(x,y : integer;bit_map : integer);
var
   x_axis, y_axis : integer;
   temp_sprite : ^original_sprite_T;
begin
   new(temp_sprite);
   x_axis := SCROLL_X_GAP*8+x*24;
   y_axis := SCROLL_Y_GAP+y*24-5;
   if x_axis < 0 then x_axis := 0;
   if y_axis < 0 then y_axis := 0;
   if bit_map <= ADDRESS_OF_WEAPON_IN_OBJECT_TILE then begin
      convertNew2OldSprite(object_tile_data[bit_map]^,temp_sprite^);
      putImage(x_axis,y_axis,temp_sprite^[294],AndPut);
      putImage(x_axis,y_axis,temp_sprite^,OrPut);
   end
   else if bit_map <= ADDRESS_OF_WEAPON_IN_OBJECT_TILE*2 then begin
      bit_map := bit_map - ADDRESS_OF_WEAPON_IN_OBJECT_TILE;
      convertNew2OldSprite(equipment_tile_data[bit_map]^,temp_sprite^);
      putImage(x_axis,y_axis,temp_sprite^[294],AndPut);
      putImage(x_axis,y_axis,temp_sprite^,OrPut);
   end
   else begin
      bit_map := bit_map - ADDRESS_OF_WEAPON_IN_OBJECT_TILE*2 + ADDRESS_OF_MIRAGE_IN_FIELD_TILE;
      convertNew2OldSprite(field_tile_data[bit_map]^,temp_sprite^);
      putImage(x_axis,y_axis,temp_sprite^[294],AndPut);
      putImage(x_axis,y_axis,temp_sprite^,OrPut);
   end;
   dispose(temp_sprite);
end;

function selectObject(var return_x, return_y : integer; x_range, y_range, x_delta, y_delta : integer; cursor_type : byte)
        : boolean;
var
   x_origin, y_origin, x_cursor, y_cursor, x1, y1, cursor : integer;
   c : integer;
   ENABLE_KEY : setByte;
begin
   cursor := cursor_type;
   c := 0;
   x_origin := return_x;
   y_origin := return_y;
   x_cursor := 0; y_cursor := 0;
   ENABLE_KEY := [ACCEPT_KEY,ESCAPE_KEY];
   if (x_delta <> 0) or (y_delta <> 0) then
      ENABLE_KEY := ENABLE_KEY + [ATTACK_KEY]+ [ATTACK_KEY+32];
   if (x_delta <= x_range) and (y_delta <= y_range) then begin
      x_cursor := x_delta;
      y_cursor := y_delta;
   end;
   printWeaponCursor(SCROLL_X_WIDE+x_origin+x_cursor,SCROLL_Y_WIDE+y_origin+y_cursor,cursor);
   repeat
      c := ord(readKey);
      if c = 0 then c := SCAN_CODE + ord(readKey);
      x1 := 0; y1 := 0;
      case c of
         LEFT_KEY  : x1 := -1;
         RIGHT_KEY : x1 := 1;
         UP_KEY    : y1 := -1;
         DOWN_KEY  : y1 := 1;
      end;
      if (x1 <> 0) or (y1 <> 0) then begin
         x_cursor := x_cursor + x1;
         y_cursor := y_cursor + y1;
         if ((abs(x_cursor) <= x_range) and (abs(y_cursor) <= y_range)) and
            ((abs(x_origin+x_cursor) <= SCROLL_X_WIDE) and
             (abs(y_origin+y_cursor) <= SCROLL_Y_WIDE)) then begin
            flipPageEASY;
            printWeaponCursor(SCROLL_X_WIDE+x_origin+x_cursor,SCROLL_Y_WIDE+y_origin+y_cursor,cursor);
         end
         else begin
            x_cursor := x_cursor - x1;
            y_cursor := y_cursor - y1;
         end;
      end;
   until (byte(c) in ENABLE_KEY);
   flipPageEASY;
   if c <> ESCAPE_KEY then begin
      return_x := x_origin+x_cursor;
      return_y := y_origin+y_cursor;
      selectObject := TRUE;
   end
   else begin
      return_x := 0;
      return_y := 0;
      selectObject := FALSE;
   end
end;

procedure modifyScreenWide(increase : integer);
const
   screen_wide_data : array[MIN_SCROLL_X_WIDE..MAX_SCROLL_X_WIDE] of byte =
                      (MIN_SCROLL_Y_WIDE,4,5,5,6,6,7,MAX_SCROLL_Y_WIDE);
begin
   if (SCROLL_X_WIDE + increase) in [MIN_SCROLL_X_WIDE..MAX_SCROLL_X_WIDE] then begin
      SCROLL_X_WIDE := SCROLL_X_WIDE + increase;
      SCROLL_Y_WIDE := screen_wide_data[SCROLL_X_WIDE];
      SCROLL_X_GAP := SCROLL_X_GAP - increase * TILE_X_SIZE;
      if ((increase < 0) and (not odd(SCROLL_X_WIDE))) or
         ((increase > 0) and (odd(SCROLL_X_WIDE))) then begin
         SCROLL_Y_GAP := SCROLL_Y_GAP - increase * TILE_Y_SIZE
      end;
      clearPage(0);
      clearPage(1);
      setHanBoundary(SCROLL_X_GAP*8,SCROLL_Y_GAP,
                     SCROLL_X_GAP*8+(2*SCROLL_X_WIDE+1)*TILE_Y_SIZE-1,
                     SCROLL_Y_GAP+(2*SCROLL_Y_WIDE+1)*TILE_Y_SIZE-1);
   end;
end;

procedure increaseScreenWide;
begin
   modifyScreenWide(1);
end;

procedure decreaseScreenWide;
begin
   modifyScreenWide(-1);
end;

procedure displayHelpWindow;
const
   MAX_COMMENT = 16;
var
   window : ^window_O;
   i : integer;
   f : text;
   comment_string : array[0..MAX_COMMENT-1] of ^string;
begin
   assign(f,COMMENT_FILE);
   {$I-}
   reset(f);
   {$I+}
   if IOResult <> 0 then exit;

   new(comment_string[0]);
   comment_string[0]^ := '';
   while (comment_string[0]^ <> ':EXPLAIN KEY WORDS') and (not eof(f)) do
      readLn(f,comment_string[0]^);
   dispose(comment_string[0]);
   if eof(f) then begin
      close(f);
      exit;
   end;

   for i := 0 to MAX_COMMENT-1 do begin
      new(comment_string[i]);
      readLn(f,comment_string[i]^);
   end;
   close(f);

   new(window,init(15,3,65,20,8,TRUE));
   setHanType(GOTHIC);
   window^.setCursor(14,0);
   for i := 0 to MAX_COMMENT-1 do begin
      window^.printHangul(comment_string[i]^);
   end;
   setHanType(SAMMUL);
   pressAnyKey;
   dispose(window,done);

   for i := 0 to MAX_COMMENT-1 do begin
      dispose(comment_string[i]);
   end;
end;

begin
   invoid_person_movement_data := [];
   talkable_person := [];
   recognizable_person := [];
   temp1_person := [];
   temp2_person := [];
   temp3_person := [];
end.
