{$DEFINE _OVERLAY}

unit DVTitle;
{$IFDEF __OVERLAY}
   {$O+,F+}
{$ENDIF}

INTERFACE

uses
   graph,
   DVHan20, DVSubPro, DVTMF;

 procedure verifyInitialCondition;
 function  displayTitle : string;
 procedure displayFin1Title;

IMPLEMENTATION

uses
   DVDecode;

const
   Y_SHIFTED_AXIS : byte = 0;
type
   Twindow_O = object(window_O)
      destructor  done; virtual;
   end;

var
   palette_data : palette_T;

procedure saveBuffer; assembler;
asm
         mov ax, 24
         shl ax, 4
         mov bx, 7
         shl bx, 4
         sub ax, bx
         inc ax
         shl ax, 4
         mov cx, ax
         shl ax, 2
         add cx, ax
         mov ax, bx
         shl ax, 4
         mov si, ax
         shl ax, 2
         add si, ax

         push ds
         push es

         mov dx, $3C4
         mov ax, $0F02
         out dx, ax

         mov dx, $3CE
         mov al, $05
         out dx, al
         inc dx
         in  al, dx
         and al, $FC
         or  al, $01
         out dx, al

         mov es, SegA000
         mov di, $9600
         mov ds, SegA000

         cld
         rep movsb

         mov dx, $3CE
         mov al, $05
         out dx, al
         inc dx
         in  al, dx
         and al, $FC
         out dx, al

         pop es
         pop ds

end;

procedure loadBuffer; assembler;
asm
         mov ax, 24
         shl ax, 4
         mov bx, 7
         shl bx, 4
         sub ax, bx
         inc ax
         shl ax, 4
         mov cx, ax
         shl ax, 2
         add cx, ax
         mov ax, bx
         shl ax, 4
         mov di, ax
         shl ax, 2
         add di, ax

         push ds
         push es

         mov dx, $3C4
         mov ax, $0F02
         out dx, ax

         mov dx, $3CE
         mov al, $05
         out dx, al
         inc dx
         in  al, dx
         and al, $FC
         or  al, $01
         out dx, al

         mov es, SegA000
         mov ds, SegA000
         mov si, $9600

         cld
         rep movsb

         mov dx, $3CE
         mov al, $05
         out dx, al
         inc dx
         in  al, dx
         and al, $FC
         out dx, al

         pop es
         pop ds

end;

destructor Twindow_O.done;
begin
   loadBuffer;
end;

function testAdLib(echo_on : boolean) : boolean;
 var
    b, test_b : byte;
    temp_b388, temp_b389: byte;
 begin
    temp_b388 := port[$388];

    port[$388] := $BD;
    test_b := port[$388];
    test_b := port[$388];
    test_b := port[$388];
    test_b := port[$388];

    temp_b389 := port[$389];
    port[$389] := 0;

    for b := 1 to 36 do
       test_b := port[$388];

    test_b := test_b and 7;

    port[$388] := temp_b388;
    port[$389] := temp_b389;

    if echo_on then write('AdLib card ');
    if (test_b = 6) then begin
       if echo_on then writeLn('detected.');
       testAdLib := TRUE;
    end else begin
       if echo_on then writeLn('not detected.');
       testAdLib := FALSE;
    end;
end;

function testSoundBlaster(echo_on : boolean) : boolean;
 var
    count, remember_port, temp_b : byte;
    w : word;
    temp_w : word;
    SB_port : word;
    foundSB : boolean;
    found_port : boolean;
    EQUIP : byte absolute $40:$10;
 begin

    foundSB := FALSE;
    count := 1;
    while (count < 7) and (not foundSB) do begin

       SB_port := $200 + ($10 * count);

       w := 0;
       found_port := FALSE;
       temp_w := SB_port + $0C;
       while (w < $201) and (not found_port) do begin
          if (port[temp_w] and $80) = 0 then found_port:=true;
          Inc(w)
       end;

       if found_port then begin

          remember_port := port[temp_w];
          port[temp_w] := $D3;
          for temp_w := 1 to $1000 do; { don't work }
          temp_w := SB_port + 6;
          port[temp_w] := 1;
          temp_b := port[temp_w];
          temp_b := port[temp_w];
          temp_b := port[temp_w];
          temp_b := port[temp_w];
          port[temp_w] := 0;
          temp_w := SB_port + $0E;
          temp_b := 0;

          repeat
             w := 0;
             found_port := FALSE;
             while (w < $201) and (not found_port) do begin
                if (port[temp_w] and $80) = $80 then found_port := TRUE;
                Inc(w)
             end;
             if found_port then begin
                if port[SB_port + $0A] = $AA then foundSB := TRUE;
             end;
             inc(temp_b)
          until (temp_b = $10) or (found_port);

          port[temp_w]:=remember_port;

       end;

       if foundSB and echo_on then writeln('Sound Blaster detected.')
       else Inc(count);

    end;
    testSoundBlaster := foundSB;

end;
(*
procedure putPCX16(fn : string);
type
   head_T = record
      manufacture : byte;
      version : byte;
      encording : byte;
      bit_per_pixel : byte;
      x1,y1,x2,y2 : integer;
      h_dpi,v_dpi : integer;
      pal : palette_T;
      reserved : byte;
      planes : byte;
      bytes_per_line : integer;
      palette_info : integer;
      h_screensize : integer;
      v_screensize : integer;
      filler : array[0..53] of byte;
   end;
   buffer_T = array[0..9999] of byte;
const
   cirnum : array[0..15] of byte = (0,1,2,3,4,5,20,7,56,57,58,59,60,61,62,63);

var
   data,plane,len : byte;
   ch : byte;
   i,j,x,y,mx : integer;
   fp : file;
   head : head_T;
   size : longint;
   buffer : ^buffer_T;
   buffer_ptr : word;
   is_last_read : boolean;
   screen_buf : array[0..64000] of byte absolute $A000:$0000;

 procedure readBuffer(var ch : byte);
 begin
    ch := buffer^[buffer_ptr];
    inc(buffer_ptr);
    if buffer_ptr > 9999 then begin
       if size > 10000 then begin
          BlockRead(fp,buffer^,10000);
          size := size - 10000;
          buffer_ptr := 0;
       end else begin
          BlockRead(fp,buffer^,size);
          buffer_ptr := 0;
          is_last_read := TRUE;
       end;
    end;
 end;

begin
   is_last_read := FALSE;
   assign(fp,fn);
   {$I-}
   reset(fp,1);
   {$I+}
   if IOResult <> 0 then begin
      write(^G);
      exit;
   end;

   size := FileSize(fp);
   blockread(fp,head,128);
   size := size - 128;

{   port[$3c8] := 0;}
   for i := 0 to 15 do begin
      head.pal[i,1] := head.pal[i,1] shr 2;
      head.pal[i,2] := head.pal[i,2] shr 2;
      head.pal[i,3] := head.pal[i,3] shr 2;
{      port[$3c9] := head.pal[i,1];
      port[$3c9] := head.pal[i,2];
      port[$3c9] := head.pal[i,3];}
   end;

   temp_palette := head.pal;

   x := 0; y := 0;
   plane := 1;
   mx := head.bytes_per_line;

   port[$03C4] := 2;
   port[$03C5] := plane;

   getMem(buffer,10000);
   buffer_ptr := 9999;
   readBuffer(ch);

   while (not is_last_read) or (buffer_ptr <= size) do begin
      readBuffer(ch);
      if ((ch and $C0) = $C0) then begin
         len := ch and $3F;
         readBuffer(data);
      end
      else begin
         len := 1;
         data := ch;
      end;
      while (len > 0) do begin
         dec(len);
         if x >= mx then begin
            plane := plane shl 1;
            if plane = $10 then begin
               inc(y);
               plane := 1;
            end;
            x := 0;
         end;
         port[$03C5] := plane;
         screen_buf[(y+Y_SHIFTED_AXIS)*80+x] := data;
         inc(x);
      end;
   end;
   close(fp);
   freeMem(buffer,size);
end;
*)
procedure putPcx16(file_name: string; RAW_MODE : boolean);
var
   scratch : pointer;
   RGB_palette : palette_T;
   page_addr: word;
   bytes_per_line: word;
   repeat_count: byte;
   data_length: word;
   column_count, plane, video_index: word;

const
   BUFFER_SIZE = 65521;

var
   i, entry, gun, PCX_code, mask, color_ID: byte;
   palette_buffer: array[0..66] of byte;
   f: file;
begin

   page_addr := SegA000;

   assign(f,file_name);
   {$I-}
   reset(f,1);
   {$I+}
   if IOresult <> 0 then exit;

   getmem(scratch,BUFFER_SIZE);
   if RAW_MODE then
      BlockRead(f,scratch^,67)
   else
      BlockRead(f,scratch^,128);

   move(scratch^,palette_buffer,67);
   bytes_per_line := palette_buffer[66];

   video_index := Y_SHIFTED_AXIS * 80;

   port[$3C4] := 2;
   plane := 1;
   port[$3C5] := plane;

   for entry := 0 to 15 do begin
      RGB_palette[entry][1] := palette_buffer[16 + entry * 3 + 0] shr 2;
      RGB_palette[entry][2] := palette_buffer[16 + entry * 3 + 1] shr 2;
      RGB_palette[entry][3] := palette_buffer[16 + entry * 3 + 2] shr 2;
   end;

   repeat_count := 0;
   column_count := 0;

   repeat
      BlockRead(f,scratch^,BUFFER_SIZE,data_length);
    asm

      mov     es, page_addr
      mov     di, video_index
      mov     ah, byte ptr bytes_per_line
      mov     dx, column_count
      mov     bx, data_length
      xor     cx, cx
      mov     cl, repeat_count
      push    ds
      lds     si, scratch
      add     bx, si
      cld

@GET_BYTE:
      cmp     si, bx
      je      @EXIT
      lodsb
      cmp     cl, 0
      jg      @WRITE_BYTE
      cmp     al, 192
      jb      @ONE_DATA

      xor     al, 192
      mov     cl, al
      jmp     @GET_BYTE

@ONE_DATA:
      mov     cl, 1

@WRITE_BYTE:
      stosb
      inc     dl
      cmp     dl, ah
      je      @DONE_LINE
      loop    @WRITE_BYTE
      jmp     @GET_BYTE

@DONE_LINE:

      shl     byte ptr plane, 1
      cmp     byte ptr plane, 8
      jle     @SET_INDEX
      mov     plane, 1
      add     di, 80
      mov     dx, dx
      mov     dl, ah
      sub     di, dx
      jmp     @SET_PLANE

@SET_INDEX:
      sub     di, dx

@SET_PLANE:
      push    ax
      cli
      mov     ax, plane
      mov     dx, 3C5h
      out     dx, al
      sti
      pop     ax
      xor     dx, dx
      loop    @WRITE_BYTE

      jmp     @GET_BYTE

@EXIT:
      pop     ds
      mov     bx, plane
      mov     repeat_count, cl
      mov     column_count, dx
      mov     video_index, di

    end;

   until eof(f);

   close(f);
   port[$3C5] := $0F;

   palette_data := RGB_palette;
{
      asm
         mov dx, $3C8
         mov al, 0
         out dx, al
         mov si, offset palette_data
         mov cx, 16 * 3
         inc dx
      @LOOP:
         mov al, ds:[si]
         out dx, al
         inc si
         loop @LOOP
      end;
}
   freeMem(scratch,BUFFER_SIZE);

end;

procedure verifyInitialCondition;
const
   REQUIRED_HEAP = 360000;
   MIN_REQUIRED_HEAP = 210000;
var
   i, j : integer;
   s : string;
begin

   Randomize;

   asm
      cli
      in  al, $21
      push ax
      mov al, $11
      out $20, al
      mov al, $08
      out $21, al
      mov al, $04
      out $21, al
      mov al, $01
      out $21, al
      mov al, $FF
      out $21, al
      pop ax
      out $21, al
      sti
   end;

   writeLn('Available heap : ',round(MEMAVAIL/1024),' KB');
   DETECT_SOUND_CARD := testSoundBlaster(TRUE);
   if not DETECT_SOUND_CARD then DETECT_SOUND_CARD := testAdLib(TRUE);
   writeLn('press any key ..');
   pressAnyKey;

   if (MEMAVAIL < MIN_REQUIRED_HEAP) or
      ((MEMAVAIL < REQUIRED_HEAP) and DETECT_SOUND_CARD) then begin
      i := VGA;
      j := VGAHi;
      initGraph(i,j,'');
      setFillStyle(SOLIDFILL,BLUE);
      Bar(0,0,639,479);
      setColor(15);
      Rectangle(0,0,639,479);
      setColor(7);
      Rectangle(2,2,637,477);
      setHanMode(EXPAND_MODE);
      setHanType(SAMMUL);
      setHanExpandRate(3);
      printString(7,4,'AaA',13,FALSE,0);
      setHanExpandRate(1.5);
      printString(28,5,'( Ŭe )',5,FALSE,0);
      setHanExpandRate(10);
      setHanType(GOTHIC);
      setHanMode(QUICK_MODE);
      talk_order := 6;
      setHanColor(15);
      printScriptTalk(' Ai w  З ǡ Ёe');
      str(round((REQUIRED_HEAP-MEMAVAIL)/1024),s);
      printScriptTalk(s+' KB eq  Aa  ϩasa.');
      inc(talk_order,6);
      setHanColor(6);
      if MEMAVAIL > MIN_REQUIRED_HEAP then begin
         printScriptTalk('qb AeE wȁ Ai Зaae ''Enter''i a.');
         i := getKey;
         if i = ACCEPT_KEY then begin
            closegraph;
            setHanType(SAMMUL);
            exit;
         end;
      end else begin
         printScriptTalk('aǡa a.');
         getKey;
      end;
      halt;
   end;

end;

const
   TITLE_X_GAP = 20;
   TITLE_Y_WIDE = 16;
   MAX_TITLE_DATA = 23;
var
   title_data_string : array[1..MAX_TITLE_DATA] of ^string;

procedure scrollDown(y_start, count : word);
var
   y_end : word;
begin
   y_end := (count + y_start) * 80;
   asm
      push ds
      push si
      push di

      mov dx, $3CE
      mov al, $05
      out dx, al
      inc dx
      in  al, dx
      and al, $FC
      or  al, $01
      out dx, al

      mov dx, $3C4
      mov ax, $0F02
      out dx, ax

      mov es, SegA000
      mov ds, SegA000
      mov cx, count
      mov si, y_end
      mov di, y_end

      add di, 80
      std
@JUMP1:
      push cx
      mov cx, 80
      rep movsb
      pop cx
      loop @JUMP1
      cld

      mov dx, $3CE
      mov al, $05
      out dx, al
      inc dx
      in  al, dx
      and al, $FC
      out dx, al

      pop di
      pop si
      pop ds
   end;
end;

function loadGame : string;
var
   window : ^Twindow_O;
   select : ^select_O;
   i : integer;
   temp_s : string[10];
   temp_b : array[1..9] of byte;
   f : file;
   save_information : array[1..9] of save_data_T;
begin

   chDir(SUB_DIRECTORY);

   assign(f,SAVE_INFORMATION_FILE);
   {$I-}
   reset(f,sizeof(save_data_T));
   {$I+}
   if IOResult <> 0 then printErrorMessage(1,SAVE_INFORMATION_FILE);
   for i := 1 to 9 do BlockRead(f,save_information[i],1);
   close(f);

   setHanType(MYUNGJO);

   new(window,init(18,10,63,19,2,TRUE));
   new(select,init);
   with select^ do begin
      fillChar(temp_b,sizeof(temp_b),#255);
      for i := 1 to 9 do begin
         str(i,temp_s);
         assign(f,'Save'+temp_s);
         {$I-}
         reset(f,1);
         {$I+}
         if IOResult = 0 then begin
            BlockRead(f,temp_s[1],length(SAVE_ID));
            BlockRead(f,temp_b[i],sizeof(temp_b[i]));
            close(f);
         end;
         str(i,temp_s);
         setMenu(i,'A '+temp_s+' : '+save_information[i].data_name);
      end;
      for i := 1 to 9 do begin
         with window^ do begin
            setCursor(30,i-1);
            case temp_b[i] of
               0 : printHangul('@7');
               1 : printHangul('@FAe');
               2 : printHangul('@FAҁe')
               else printHangul('@0A q');
            end;
         end;
      end;
      setMenuColor(15,14);
      i := selectMenu(20,10,1,9);
      if i > 0 then begin
         if not (temp_b[i] in [0..2]) then i := -1;
      end;
   end;
   dispose(window,done);
   dispose(select,done);
   setHanType(SAMMUL);

   if i in [1..9] then begin
      str(i,temp_s);
      loadGame := '@'+temp_s;
   end else if i <= 0 then begin
      loadGame := '';
   end;

   chDir('..');

end;

function createNewCharacter : string;
var
   window : ^Twindow_O;
   temp_s : string;
begin
   setHanColor(YELLOW);
   printHangulOUTLINE(26*8,12*16,' a qi a ',0);
   setMaxInputByte(16);
   new(window,init(28,15,49,16,1,TRUE));
   setHanColor(WHITE);
   printHangulOUTLINE(22*8,18*16,' A e i wsa ',0);
   printHangulOUTLINE(22*8,19*16,'  ( A З  ѡ÷ ŉ  )  ',0);
   setHanType(SAMMUL);
   temp_s := inputHangul(28*8,15*16,'',1,TRUE);
   createNewCharacter := temp_s;
   dispose(window,done);
end;

procedure displayStaffs;
var
   window : ^Twindow_O;
begin
   new(window,init(15,10,65,20,0,TRUE));
   with window^ do begin
      setHanType(MYUNGJO);
      printHangul('@@@FAb˱        : @E˱ a ( TEAM gogma )');
      setHanType(GOTHIC);
      printHangul('@@@@@FB,a');
      setHanType(SAMMUL);
      printHangul(' : @Eew(SMgal)');
      setHanType(GOTHIC);
      printHangul('@@@FaϢ       ');
      setHanType(SAMMUL);
      printHangul(' : @Eb(NeoTouch), ׬q');
      setHanType(GOTHIC);
      printHangul('@@@Fw qb    ');
      setHanType(SAMMUL);
      printHangul(' : @E׬q(Byulbram)');
      setHanType(GOTHIC);
      printHangul('@@@Fbiӡ qa  ');
      setHanType(SAMMUL);
      printHangul(' : @Dew҅ ( A B e A )');
      setHanType(GOTHIC);
      printHangul('@@@FAa Aa  ');
      printHangul(' : @Adogrice gk37ksw HighELF MANToMAN@@');
      printHangul('                PJH0605 Rcomet  RPGLAND Snowdrop@@');

      setCursor(41,9);
      printHangul('@F1996.9.1');
      setHanType(SAMMUL);
      pressAnyKey;
   end;
   dispose(window,done);
end;

procedure printHangulExtended(x,y : integer; s : string);
var
   temp_s : string;
   s_ptr : integer;
   x_cursor, y_cursor, color : integer;
   exit_condition : boolean;

 function processOptions(option : char) : boolean;
 begin
    processOptions := FALSE;
    case option of
       '0'..'9' : color := ord(option) - ord('0');
       'A'..'F' : color := ord(option) - ord('A') + 10;
       'a'..'f' : color := ord(option) - ord('a') + 10
       else processOptions := TRUE;
    end;
 end;

begin

   x_cursor := x;
   y_cursor := y;
   color := 15;

   while s <> '' do begin

      if s[1] <> '@' then begin
         s_ptr := 0;
      end else begin
         if processOptions(s[2]) then begin
            x_cursor := x;
            inc(y_cursor);
         end;
         s_ptr := 2;
      end;

      temp_s := '';
      if s_ptr < length(s) then
         exit_condition := FALSE
      else
         exit_condition := TRUE;

      while not exit_condition do begin
         if s[s_ptr+1] = '@' then begin
            exit_condition := TRUE;
         end else begin
            inc(s_ptr);
            inc(temp_s[0]);
            temp_s[ord(temp_s[0])] := s[s_ptr];
            if (ord(s[s_ptr]) and $80) > 0 then begin
               inc(s_ptr);
               inc(temp_s[0]);
               temp_s[ord(temp_s[0])] := s[s_ptr];
            end;
         end;
         if length(s) <= s_ptr then begin
            exit_condition := TRUE;
         end;
      end;
      s := copy(s,s_ptr+1,length(s)-s_ptr);
      printString(x_cursor,y_cursor,temp_s,color,FALSE,0);
      x_cursor := x_cursor + length(temp_s);
   end;
end;

procedure displayManual;

var
   i,j : integer;
   f : text;
   window : ^Twindow_O;
   temp_s : string;
   manual_string : array[1..999] of ^string;
   MAX_MANUAL_STRING : integer;
begin

   new(window,init(10,8,70,22,0,TRUE));

   MAX_MANUAL_STRING := 0;
   assign(f,COMMENT_FILE);
   {$I-}
   reset(f);
   {$I+}
   if IOResult = 0 then begin

      while not eof(f) do begin
         readLn(f,temp_s);
         if temp_s = ':MANUAL' then begin
            if not eof(f) then readLn(f,temp_s);
            while (not eof(f)) and (temp_s[1] <> '!') and (MAX_MANUAL_STRING < 999) do begin
               inc(MAX_MANUAL_STRING);
               new(manual_string[MAX_MANUAL_STRING]);
               manual_string[MAX_MANUAL_STRING]^ := temp_s;
               if not eof(f) then readLn(f,temp_s);
            end;
         end;
      end;
      close(f);

      window^.setCursor(0,-1);
      for i := 1 to MAX_MANUAL_STRING do begin
         window^.printHangul(manual_string[i]^);
      end;
      pressAnyKey;

      for i := 1 to MAX_MANUAL_STRING do begin
         dispose(manual_string[i]);
      end;

   end;

   dispose(window,done);

end;

procedure toggleMusic;
begin
   if DETECT_SOUND_CARD then begin
      endTMF;
      DETECT_SOUND_CARD := FALSE;
   end else begin
      DETECT_SOUND_CARD := testSoundBlaster(FALSE);
      if not DETECT_SOUND_CARD then DETECT_SOUND_CARD := testAdLib(FALSE);
      if DETECT_SOUND_CARD then begin
         loadTMF('Title');
         playTMF;
      end;
   end;
end;

function startTitle : string;
label
   RESTART_LABEL;
const
   MAX_MENU = 7;
   remember_menu : integer = 1;
   palette_data_13 : array[1..7,1..3] of byte = (
      (50, 3,63), (63,52,13), (63,11,25), (26, 9,63),
      (26,63,11), (63,56,43), ( 0,13, 5)
   );
var
   i, j, k, title_mode : integer;
   f : text;
   select : ^select_O;
   s : string;
begin

   if random(4) = 0 then begin
      title_mode := 0;
      s := ':PREDICTION STRING';
      setGradationColor(1);
      setGradationType(DOWN_SLASH);
   end else begin
      title_mode := 1;
      s := ':TITLE STRING';
      setGradationColor(0);
      setGradationType(ROUND_SPREAD);
   end;

   assign(f,COMMENT_FILE);
   {$I-}
   reset(f);
   {$I+}
   new(title_data_string[1]);
   while not eof(f) do begin
      readLn(f,title_data_string[1]^);
      if title_data_string[1]^ = s then begin
         dispose(title_data_string[1]);
         for i := 1 to MAX_TITLE_DATA do begin
            new(title_data_string[i]);
            readLn(f,title_data_string[i]^);
         end;
         break;
      end;
   end;
   close(f);

   k := 1;
   repeat
      if title_data_string[k]^ <> '' then begin
         printHangulGRADATION(TITLE_X_GAP,k*TITLE_Y_WIDE+TITLE_X_GAP,title_data_string[k]^,1);
      end;
      inc(k);
   until (k > MAX_TITLE_DATA) or KeyPressed;

   while KeyPressed do readKey;
   setPalette(10);
   if title_mode = 0 then begin
      for i := 1 to 16 do begin
         scrollDown(0,430);
         setRGB(10,63 * (16-i) div 16,21 * (16-i) div 16,42 * (16-i) div 16);
         if not KeyPressed then waitVerticalRetrace(5);
      end;
   end else begin
      for i := 1 to 16 do begin
         scrollDown(0,430);
         setRGB(10,63 * (16-i) div 16,42 * (16-i) div 16,21 * (16-i) div 16);
         if not KeyPressed then waitVerticalRetrace(5);
      end;
   end;

   for i := 1 to MAX_TITLE_DATA do begin
      if title_data_string[i] <> nil then begin
         dispose(title_data_string[i]);
         title_data_string[i] := nil;
      end;
   end;

   new(select,init);

   clearDevice;

   while KeyPressed do readKey;

   for i := 0 to 15 do begin
      setPalette(i);
      setRGB(i,0,0,0);
   end;

   putPCX16('title.pcx',FALSE);
   saveBuffer;
   setFillStyle(SOLIDFILL,BLACK);
   bar(0,0,0,0);

   if random(20) = 0 then begin
      k := random(7)+1;
      for i := 1 to 3 do begin
         palette_data[13,i] := palette_data_13[k,i];
      end;
   end;

   convertVioletScale(palette_data,11,0);

RESTART_LABEL:

   while KeyPressed do readKey;
   with select^ do begin
      setHanMode(QUICK_MODE);
      setMenuMode(NORMAL_MENU);
      setMenuColor(15,14);
      setMenu(1,       '巁 Ai  ea');
      setMenu(2,       ' Ai  bea');
      setMenu(3,       '  A   bea');
      setMenu(4,       ' A  ai  a');
      setMenu(5,       ' b  A  i  a');
      setMenu(6,       'w qbi aa ea');
      setMenu(MAX_MENU,'A    i   {    a');
      repeat
         i := selectMenu(27,13,remember_menu,MAX_MENU);
      until i > 0;
      if i in [1..MAX_MENU] then remember_menu := i;
      if i in [1..6] then convertOriginalScale(palette_data,11,1);
      if i in [1..5] then loadBuffer;
      s := '';
      case i of
         1 : s := loadGame;
         2 : s := createNewCharacter;
         3 : s := '@0' + createNewCharacter;
         4 : displayStaffs;
         5 : displayManual;
         6 : toggleMusic;
         MAX_MENU : s := '';
      end;
      if ((s = '') or (s = '@0')) and (i <> MAX_MENU) then begin
         convertVioletScale(palette_data,11,1);
         goto RESTART_LABEL;
      end;
   end;

   dispose(select,done);

   startTitle := s;
end;

function displayTitle : string;
begin

   excuteCommand('set graphic mode("480")',0);

   if DETECT_SOUND_CARD then begin
      loadTMF('Title');
      playTMF;
   end;

   displayTitle := startTitle;

   if DETECT_SOUND_CARD then begin
      endTMF;
   end;

end;

procedure _saveBuffer; assembler;
asm
         push ds

         mov si, 80 * 37
         mov cx, 80 * 320

         mov dx, $3C4
         mov ax, $0F02
         out dx, ax

         mov dx, $3CE
         mov al, $05
         out dx, al
         inc dx
         in  al, dx
         and al, $FC
         or  al, $01
         out dx, al

         mov es, SegA000
         mov di, $9600
         mov ds, SegA000

         cld
         rep movsb

         mov dx, $3CE
         mov al, $05
         out dx, al
         inc dx
         in  al, dx
         and al, $FC
         out dx, al

         pop ds

end;

procedure _loadBuffer; assembler;
const
   data : array[1..24] of byte = (
             $00, $04, $10, $40, $22, $88, $11, $92, $49, $92,
             $AA, $55, $AA, $AB, $B5, $5B, $BB, $DD, $EE, $BF,
             $FB, $EF, $FE, $FF
   );
asm
         push ds

         mov ax, SegA000
         mov ds, ax
         mov es, ax

         mov bx, 0
@@LOOP:
         mov dx, $3C4
         mov al, $02
         mov ah, 1
         mov cl, bl
         shl ah, cl
         out dx, ax

         mov dx, $3CE
         mov al, $04
         mov ah, bl
         out dx, ax

         mov si, $9600
         mov di, 80 * 37
         mov cx, 80 * 320

         mov al, ds:[si]
         mov al, ss:[bp+20]

         inc bx
         cmp bx, $4
         jne @@LOOP

         pop ds

end;

procedure startFinTitle;
var
   i : integer;
begin
   clearDevice;

   while KeyPressed do readKey;

   for i := 0 to 15 do begin
      setPalette(i);
      setRGB(i,0,0,0);
   end;

   putPcx16('1FIN.BG',TRUE);
{   _saveBuffer;}
   fadeIn(palette_data,1);
{   _loadBuffer;}
   readKey;
   fadeOut(palette_data,1);
end;

procedure displayFin1Title;
begin

   excuteCommand('set graphic mode("480")',0);

   if DETECT_SOUND_CARD then begin
      loadTMF('Ending1');
      playTMF;
   end;

   startFinTitle;

   if DETECT_SOUND_CARD then begin
      endTMF;
   end;

   halt;
end;

end.
