{$DEFINE _OVERLAY}

Unit DVWorld;
{$IFDEF __OVERLAY}
   {$O+,F+}
{$ENDIF}

INTERFACE

uses
   graph, DVHan20, DVTMF, DVSubPro, DVPerson;

 procedure actJourney(var x,y : integer);

IMPLEMENTATION

uses
   DVDecode;

type
   ground_T = record
      name : string[8];
      time, color, encounter : byte;
      field : char;
   end;
   cloud_T = record
      x, y, count, speed : integer;
   end;

const
   X_WIDE = 7;
   Y_WIDE = 6;
   tile_set : set of byte = [1..30];
   tile_table : array[0..143] of byte = (0,
         1,  1,  1,  1,  1,  1,  1,  1,  1,  2,
         2,  2,  2,  2,  2,  2,  2,  2,  3,  4,
         5,  5,  5,  6,  6,  6,  6,  6,  6,  6,
         6,  6,  6,  6,  6,  6,  6,  7,  7,  7,
         7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
         7,  7,  7,  7,  8,  8,  8,  8,  8,  8,
         8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
         8,  9, 10,  0,  0,  0,  0,  0,  0,  0,
         0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
         0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
         0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
         0, 12, 13, 14, 15, 16, 17, 18, 19, 20,
        21, 22, 23, 24, 25, 26,  0,  0,  0,  0,
         0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
         0,  0,  0);

   ground_tile : array[0..26] of ground_T = (
      (name : '¯'    ; time :   5; color : 14; encounter :  0; field : '0'),
      (name : 'aa'      ; time :   0; color :  9; encounter :  0; field : '0'),
      (name : ''      ; time :  20; color :  2; encounter :  6; field : '1'),
      (name : ''    ; time :  35; color : 10; encounter : 10; field : '2'),
      (name : ''    ; time :  40; color : 10; encounter : 15; field : '2'),
      (name : ''    ; time :  45; color : 10; encounter : 20; field : '2'),
      (name : ''      ; time :  55; color :  4; encounter : 15; field : '3'),
      (name : 'e'  ; time :  60; color :  8; encounter : 15; field : '4'),
      (name : 'ee'    ; time : 130; color : 15; encounter :  3; field : '5'),
      (name : 'ab'      ; time :  40; color : 14; encounter : 10; field : '6'),
      (name : 'ab'      ; time :  50; color : 14; encounter :  8; field : '6'),
      (name : 'Ёe'      ; time :  35; color :  6; encounter : 10; field : '7'),
      (name : 'aIa'  ; time :  35; color : 11; encounter :  0; field : '0'),
      (name : 'a'  ; time :  35; color : 11; encounter :  0; field : '0'),
      (name : 'Aa'    ; time :  35; color : 11; encounter :  0; field : '0'),
      (name : 'eaaa'; time :  30; color : 11; encounter :  0; field : '0'),
      (name : 'AaaI'  ; time :  35; color : 11; encounter :  0; field : '0'),
      (name : 'ɡaa'    ; time :  60; color : 11; encounter :  0; field : '0'),
      (name : 'b'    ; time :  80; color :  5; encounter :  0; field : '0'),
      (name : 'b'    ; time :  45; color :  5; encounter :  0; field : '0'),
      (name : 'aAe'    ; time :  30; color : 11; encounter :  0; field : '0'),
      (name : 'IAa'  ; time :  35; color : 11; encounter :  0; field : '0'),
      (name : 'a'      ; time :  80; color : 11; encounter :  0; field : '0'),
      (name : 'a'  ; time : 100; color :  3; encounter :  0; field : '0'),
      (name : 'a'  ; time :  80; color :  3; encounter :  0; field : '0'),
      (name : 'ϡaa'  ; time :  35; color :  3; encounter :  0; field : '0'),
      (name : 'a'      ; time :  35; color :  3; encounter :  0; field : '0')
   );
   MAP_CHEATING_KEY = 159;
   MAX_CLOUD = 50;

var
   cloud : array[1..MAX_CLOUD] of cloud_T;
   current_time : longint;

function returnWasteTime(x,y : byte; x_cursor,y_cursor : integer) : integer;
var
   i : integer;
begin
   i := ground_tile[tile_table[readMap(MA_NORMAL,x,y)]].time +
        ground_tile[tile_table[readMap(MA_NORMAL,x+x_cursor,y+y_cursor)]].time;
   if (x_cursor <> 0) and (y_cursor <> 0) then begin
      i := round(i * 1.444444 / 2);
   end else i := i div 2;
   returnWasteTime := i;
end;

procedure scrollMap4World(x,y : byte;x_cursor,y_cursor : integer; display_person : boolean);
var
   i, j, mx, my : integer;
   data : byte;
   s : string[50];
   aux_s : string[10];
   is_dark_time, is_dark : boolean;
   return_item : item_T;
   sort_data : array[1..MAX_CLOUD] of byte;
begin
   clearPage(1);
{   while KeyPressed do readKey;}

   fillChar(test_map,sizeof(test_map),#1); (*  0 : Dark
                                               1 : Moon Light
                                               2 : Sun Light  *)

   if game_system.returnHour in [6..18] then begin
      data := X_WIDE;
   end
   else if game_system.returnHour = 5 then begin
      data := (game_system.returnMinute div 10) + 1;
   end
   else if game_system.returnHour = 19 then begin
      data := 6 - (game_system.returnMinute div 10);
   end
   else
      data := 0;
   if data > 0 then begin
      for j := -data to data do
       for i := -data to data do begin
         test_map[i,j] := 2;
      end;
   end;

   for j := -Y_WIDE to Y_WIDE do begin
      for i := -X_WIDE to X_WIDE do begin
         data := readMap(MA_NORMAL,x+i,y+j);
         if test_map[i,j] = 1 then
            printImage(i+X_WIDE,j+Y_WIDE+1,tile_data[data]^,TRUE)
         else
            printImage(i+X_WIDE,j+Y_WIDE+1,tile_data[data]^,FALSE)
      end;
   end;

   printSprite((X_WIDE+x_cursor),
               (Y_WIDE+y_cursor+1)+SCROLL_Y_GAP div 24,object_tile_data[8]^,FALSE,FALSE);

   if display_person then begin
      printSprite(X_WIDE,Y_WIDE+1,object_tile_data[person[_MAIN_CHARACTER]^.returnFaceCount]^,FALSE,TRUE);
   end;

   for i := 1 to MAX_CLOUD do begin
      sort_data[i] := i;
   end;
   for j := 1 to MAX_CLOUD-1 do begin
      for i := 1 to MAX_CLOUD-j do begin
         if cloud[sort_data[i]].y > cloud[sort_data[i+1]].y then begin
            data := sort_data[i+1];
            sort_data[i+1] := sort_data[i];
            sort_data[i] := data;
         end;
      end;
   end;

   for j := 1 to MAX_CLOUD do begin
      i := sort_data[j];
      if (cloud[i].x > (x-X_WIDE)*24-128) and (cloud[i].x <= (x+X_WIDE)*24) and
         (cloud[i].y > (y-Y_WIDE)*24-53)  and (cloud[i].y <= (y+Y_WIDE)*24)  then begin
         putSpriteSHIT((cloud[i].x - (x-X_WIDE)*24)+SCROLL_X_GAP*8+16,
                       (cloud[i].y - (y-Y_WIDE)*24)+16,sprite_data[4].data^,TRUE);
         putSpriteSHIT((cloud[i].x - (x-X_WIDE)*24)+SCROLL_X_GAP*8,
                       (cloud[i].y - (y-Y_WIDE)*24)+0,sprite_data[3].data^,TRUE);
      end;
   end;

   if abs(game_system.setCurrentTime - current_time) >= 4 then begin
      current_time := game_system.setCurrentTime;
      for i := 1 to MAX_CLOUD do begin
         inc(cloud[i].count);
         if cloud[i].count = cloud[i].speed then begin
            cloud[i].count := 0;
            inc(cloud[i].x,8);
            if x > map_header.map_x_max * 24 then x := 0;
            inc(cloud[i].y,4);
            if y > map_header.map_y_max * 24 then y := 0;
         end;
      end;
   end;

   setColor(15);
   setActivePage(1);
   setHanActivePage(1);
   setFillStyle(SOLIDFILL,0);
   bar(0,0,SCROLL_X_GAP * 8-1,349);
   bar(((2 * X_WIDE + 1) * TILE_X_SIZE + SCROLL_X_GAP) * 8 + 1,0,639,349);
   bar(SCROLL_X_GAP * 8,0,((2 * X_WIDE + 1) * TILE_X_SIZE + SCROLL_X_GAP) * 8,SCROLL_Y_GAP+24);
   bar(SCROLL_X_GAP * 8,(2 * Y_WIDE + 1 + 1) * TILE_Y_SIZE + SCROLL_Y_GAP,
       ((2 * X_WIDE + 1) * TILE_X_SIZE + SCROLL_X_GAP) * 8,349);
{   rectangle(SCROLL_X_GAP * 8,SCROLL_Y_GAP+24,
      ((2 * X_WIDE + 1) * TILE_X_SIZE + SCROLL_X_GAP) * 8,
      (2 * Y_WIDE + 1 + 1) * TILE_Y_SIZE + SCROLL_Y_GAP);
}
   putSpriteSHIT((SCROLL_X_GAP-3) * 8,7    ,sprite_data[5].data^,TRUE);
   putSpriteSHIT((SCROLL_X_GAP-2) * 8,7+96 ,sprite_data[6].data^,TRUE);
   putSpriteSHIT((SCROLL_X_GAP-2) * 8,7+297,sprite_data[7].data^,TRUE);
   putSpriteSHIT(((2*X_WIDE+1)*TILE_X_SIZE+SCROLL_X_GAP-3)*8,7,sprite_data[8].data^,TRUE);
   putSpriteSHIT((SCROLL_X_GAP+ 4) * 8,7+266,sprite_data[9].data^,TRUE);
   putSpriteSHIT((SCROLL_X_GAP+13) * 8,7+266,sprite_data[9].data^,TRUE);
   putSpriteSHIT((SCROLL_X_GAP+22) * 8,7+266,sprite_data[9].data^,TRUE);
   putSpriteSHIT((SCROLL_X_GAP+31) * 8,7+266,sprite_data[9].data^,TRUE);
   putSpriteSHIT((SCROLL_X_GAP+34) * 8,7+266,sprite_data[9].data^,TRUE);

   with game_system do begin
      str(m_year : 4,s);
      s := s + 'e ';
      str(m_month : 2,aux_s);
      s := s + aux_s + ' ';
      str(m_day : 2,aux_s);
      s := s + aux_s + ' ';
      str(m_hour : 2,aux_s);
      s := s + aux_s + ' ';
      str(m_minute : 2,aux_s);
      s := s + aux_s + '';
      setHanColor(14);
      printHangulOUTLINE(31*8,6,s,4);

      data := tile_table[readMap(MA_NORMAL,x+x_cursor,y+y_cursor)];
      if data in tile_set then begin
         mx := (X_WIDE+x_cursor+1)*24+SCROLL_X_GAP*8;
         my := (Y_WIDE+y_cursor+1)*24+SCROLL_Y_GAP*8;
         setHanColor(10);
         printHangulOUTLINE(mx,my,ground_tile[data].name,0);
         i := ground_tile[data].time;
         if (i > 0) and ((x_cursor <> 0) or (y_cursor <> 0)) then begin
            i := returnWasteTime(x,y,x_cursor,y_cursor);
            str(i,s);
         end else s := '0';
         setHanColor(9); inc(my,16);
         printHangulOUTLINE(mx,my,s+'',0);
      end;

      with person[_MAIN_CHARACTER]^ do begin
         i := findInventory(93,0);
         if i > 0 then begin
            returnInventory(i,return_item);
            i := return_item._item_contain;
         end else i := 0;
         str(i : 3,s);

         setHanColor(10);
         printSprite(X_WIDE-1,1,object_tile_data[9]^,FALSE,FALSE);
         printHangulOUTLINE(X_WIDE*24+SCROLL_X_GAP*8,28,s+'',0);

         i := round(returnInternal(_hit_point) * 100 / returnMaxAvailHitPoint);
         str(i : 3,s);
         setHanColor(11);
         printSprite(X_WIDE+2,1,object_tile_data[10]^,FALSE,FALSE);
         printHangulOUTLINE(380,28,s+'%',0);

      end;

   end;
   setHanActivePage(0);
   setActivePage(0);

end;

procedure displayAllMap(view_all : boolean);
var
   i ,j : integer;
   data : byte;
begin
   setActivePage(1);
   setFillStyle(SolidFill,Black);
   bar(SCROLL_X_GAP * 8,SCROLL_Y_GAP+24+1,
      ((2 * X_WIDE + 1) * TILE_X_SIZE + SCROLL_X_GAP) * 8 - 1,
      (2 * Y_WIDE + 1 + 1) * TILE_Y_SIZE + SCROLL_Y_GAP - 1);

   for j := 0 to game_system.returnMapYMax - 1 do begin
      for i := 0 to game_system.returnMapXMax - 1 do begin
         data := tile_table[readMap(MA_NORMAL,i,j)];
         putPixel(SCROLL_X_GAP*8+3*i+24,3*j+40,ground_tile[data].color);
         putPixel(SCROLL_X_GAP*8+3*i+25,3*j+40,ground_tile[data].color);
         putPixel(SCROLL_X_GAP*8+3*i+24,3*j+41,ground_tile[data].color);
         putPixel(SCROLL_X_GAP*8+3*i+25,3*j+41,ground_tile[data].color);
      end;
   end;
   putSpriteSHIT((SCROLL_X_GAP-3) * 8,7    ,sprite_data[5].data^,TRUE);
   putSpriteSHIT((SCROLL_X_GAP-2) * 8,7+297,sprite_data[7].data^,TRUE);
   setActivePage(0);
   flipPageEASY;

   while KeyPressed do readKey;
   readKey;
end;

procedure actJourney(var x,y : integer);
label
   EXIT_POINT;
const
   MOVIE_DIVISION = 5;
var
   f                       : file;
   i, key_in, control_code : integer;
   x_cursor, y_cursor, x1, y1, x0, y0 : shortint;
   data, j                 : byte;
   movie                   : ^movie_O;
   attack_params           : attack_parameters_T;
   passed_time, temp_long  : longint;
   return_item             : item_T;
   saved_x_gap, saved_y_gap: byte;
   c                       : char;
begin

   saved_x_gap := SCROLL_X_GAP;
   saved_y_gap := SCROLL_Y_GAP;

   SCROLL_X_GAP := 16;
   SCROLL_Y_GAP := 0;

   for i := 1 to MAX_CLOUD do begin
      with cloud[i] do begin
         x := random(map_header.map_x_max) * 24;
         y := random(map_header.map_y_max) * 24;
         count := 0;
         speed := random(5)+1;
      end;
   end;

   if DETECT_SOUND_CARD then begin
      loadTMF(map_header.music_data_file);
      playTMF;
   end;

   assign(f,SPRITE_FILE);
   {$I-}
   reset(f,1);
   {$I+}
   if IOResult <> 0 then printErrorMessage(1,SPRITE_FILE);
   for j := 1 to (3-1) do begin
      BlockRead(f,sprite_data[3].size,2);
      getMem(sprite_data[3].data,sprite_data[3].size);
      BlockRead(f,sprite_data[3].data^,sprite_data[3].size);
      freeMem(sprite_data[3].data,sprite_data[3].size);
   end;
   for j := 3 to 9 do begin
      BlockRead(f,sprite_data[j].size,2);
      getMem(sprite_data[j].data,sprite_data[j].size);
      BlockRead(f,sprite_data[j].data^,sprite_data[j].size);
   end;
   close(f);

   control_code := 0;
   x_cursor := 0;
   y_cursor := 0;
   scrollMap4World(x,y,x_cursor,y_cursor,TRUE);
   flipPageEASY;
   fadeIn(palette_data,1);

   with game_system do begin
      passed_time := ((m_month*30) + m_day)*24 + m_hour;
   end;

   current_time := game_system.setCurrentTime;
   while control_code <> EXIT_CODE do begin
      if not KeyPressed then begin
         scrollMap4World(x,y,x_cursor,y_cursor,TRUE);
         flipPageEASY;
         continue;
      end;
      key_in := getKey;
      x1 := 0; y1 := 0;
      case key_in of
         UP_KEY    : y1 := -1;
         DOWN_KEY  : y1 := 1;
         LEFT_KEY  : x1 := -1;
         RIGHT_KEY : x1 := 1;
         ACCEPT_KEY :
         if (x_cursor <> 0) or (y_cursor <> 0) then begin
            data := tile_table[readMap(MA_NORMAL,x+x_cursor,y+y_cursor)];
            if (data in tile_set) and (ground_tile[data].time > 0) then begin
               j := person[_MAIN_CHARACTER]^.returnFaceCount and $01;
               j := j xor $01;
               if x_cursor = 0 then begin
                  if y_cursor > 0 then person[_MAIN_CHARACTER]^.setFaceCount(0+j);
                  if y_cursor < 0 then person[_MAIN_CHARACTER]^.setFaceCount(6+j);
               end else begin
                  if x_cursor > 0 then person[_MAIN_CHARACTER]^.setFaceCount(4+j);
                  if x_cursor < 0 then person[_MAIN_CHARACTER]^.setFaceCount(2+j);
               end;
{
               new(movie,init);
               for i := 1 to MOVIE_DIVISION do begin
                  x0 := round(24 * i * x_cursor / MOVIE_DIVISION);
                  y0 := round(24 * i * y_cursor / MOVIE_DIVISION);
                  movie^.setMovie(MA_PERSON,person[_MAIN_CHARACTER]^.returnFaceCount,
                     X_WIDE*24+x0+SCROLL_X_GAP*8,(Y_WIDE+1)*24+y0-10+SCROLL_Y_GAP,1,0);
               end;
               scrollMap4World(x,y,x_cursor,y_cursor,FALSE);
               flipPageEASY;
               movie^.playMovie(7);
               dispose(movie,done);
}
               i := returnWasteTime(x,y,x_cursor,y_cursor);
               x := x + x_cursor;
               y := y + y_cursor;

               game_system.passTime(0,0,i,0);
               game_system._NEXT_DIRECTION_X := x_cursor;
               game_system._NEXT_DIRECTION_Y := y_cursor;
               x_cursor := 0;
               y_cursor := 0;

               with game_system do begin
                  temp_long := ((m_month*30) + m_day)*24 + m_hour;
                  temp_long := temp_long - passed_time;
               end;

               while temp_long >= 8 do begin
                  inc(passed_time,8);
                  dec(temp_long,8);
                  with person[_MAIN_CHARACTER]^ do begin
                     if haveEnoughIt(93,0,1) then begin
                        dropSomethingEA(93,0,1,return_item);
                     end else begin
                        reduceHitPoint(returnAbility(_endurance) div 100);
                     end;
                  end;
               end;

               scrollMap4World(x,y,x_cursor,y_cursor,TRUE);
               flipPageEASY;

               with person[_MAIN_CHARACTER]^ do begin
                  if returnInternal(_unconscious_depth) > 0 then begin
                     DVPersn1.loadGame(TRUE);
                     goto EXIT_POINT;
                  end;
               end;

               j := tile_table[readMap(MA_NORMAL,x,y)];
               if ground_tile[j].encounter > random(100) then begin
                  printMessageWindow('      e !!     ');
                  with game_system do begin
                     if not getEventBit(92) then begin
                        _RETURN_EXCUTE_FILE := map_header.map_data.file_name;
                        _RETURN_START_X := x;
                        _RETURN_START_Y := y;
                        _NEXT_EXCUTE_FILE := '_Battle'+ground_tile[j].field;
                        _NEXT_START_X := 0;
                        _NEXT_START_Y := 0;
                        control_code := EXIT_CODE;
                        user_key := EXIT_CODE;
                     end;
                  end;
               end;
            end;
            if data >= 12 then begin
               if verifyExitMap(x,y) then begin
                  control_code := EXIT_CODE;
               end;
            end;
         end;
         MENU_KEY, MAP_CHEATING_KEY :
         begin
            if key_in = MENU_KEY then
               displayAllMap(TRUE)
            else
               displayAllMap(FALSE);
            scrollMap4World(x,y,x_cursor,y_cursor,TRUE);
            flipPageEASY;
         end;
         255 :
         begin
            control_code := EXIT_CODE;
            user_key := EXIT_CODE;
            game_system._NEXT_EXCUTE_FILE := '';
         end;
      end;
      if (x1 <> 0) or (y1 <> 0) then begin
         x_cursor := x_cursor + x1;
         y_cursor := y_cursor + y1;
         if abs(x_cursor) > 1 then x_cursor := x_cursor - x1;
         if abs(y_cursor) > 1 then y_cursor := y_cursor - y1;
         scrollMap4World(x,y,x_cursor,y_cursor,TRUE);
         flipPageEASY;
      end;
   end;

EXIT_POINT:

   for j := 3 to 9 do begin
      freeMem(sprite_data[j].data,sprite_data[j].size);
   end;

   if DETECT_SOUND_CARD then begin
      endTMF;
   end;

   SCROLL_X_GAP := saved_x_gap;
   SCROLL_Y_GAP := saved_y_gap;
end;

end.
