UNIT KeyBoard;

INTERFACE

const
   _ESC_KEY   = 1;
   _UP_KEY    = 72;
   _LEFT_KEY  = 75;
   _RIGHT_KEY = 77;
   _DOWN_KEY  = 80;
   _CONTROL_KEY = 29;
   _MINUS_KEY = 74;
   _PLUS_KEY = 78;

var
   scan_code ,ascii_code : set of 0..$7F;
   KeyboardInterruptOLD : procedure;

procedure setKeyboardInterrupt;
procedure resetKeyboardInterrupt;


IMPLEMENTATION

uses
   dos;

{$F+}
procedure KeyboardInterrupt; interrupt;
{$F-}
var
   _code, _port : byte;
begin

    asm cli end;

    _port := port[$60];
    _code := _port and $7F;

    if (_port < $80) and not (_code in scan_code) then begin
        scan_code := scan_code + [_code];
        ascii_code := ascii_code + [_code];
    end else if _port > $7F then begin
        scan_code := scan_code - [_code];
    end;

    port[$20] := $20;

    asm sti end;

end;

procedure setKeyboardInterrupt;
begin
    scan_code := [];
    ascii_code := [];

    getIntVec($09,@KeyboardInterruptOLD);
    setIntVec($09,@KeyboardInterrupt);
end;

procedure resetKeyboardInterrupt;
begin
    setIntVec($09,@KeyboardInterruptOLD);
end;

end.