Program Nanpa;
{ Oremo Koithumitai nanpa sitainoni ... }
uses
   KeyBoard, SubPro;

procedure _READY_;
var
   f : file;
   i, j : integer;
begin

   assign(f,'mati1.img');
   reset(f,IMAGE_SIZE);
   for i := 0 to MAX_TILE-1 do begin
      new(tile_data[i]);
      BlockRead(f,tile_data[i]^,1);
   end;
   close(f);

   assign(f,'yui.img');
   reset(f,CHARACTER_SIZE);
   for i := 0 to MAX_CHARACTER-1 do begin
      new(character_data[i]);
      BlockRead(f,character_data[i]^,1);
   end;
   close(f);

   assign(f,'mati1.map');
   reset(f,1);
   BlockRead(f,x_max,2);
   BlockRead(f,y_max,2);
   getMem(map_data,x_max * y_max * 2);
   BlockRead(f,map_data^,x_max * y_max * 2);
   close(f);

   assign(f,'mati1.pal');
   reset(f,1);
   BlockRead(f,palette_data,PALETTE_SIZE);
   close(f);

   initGraph;

   for i := 0 to 15 do begin
      setPalette(i);
      setRGB(i,palette_data[i,1],palette_data[i,2],palette_data[i,3]);
   end;

   putPCX16('waku.pcx');

   setKeyboardInterrupt;

end;

procedure _ACTION_;
var
   i , j : integer;
   x , y : integer;
   x1, y1 : integer;
   yui_face : integer;
begin
   x := 99; y := 25;
   yui_face := 3;

   while TRUE do begin

      for j := -SCROLL_Y_WIDE to SCROLL_Y_WIDE+1 do begin
         for i := -SCROLL_X_WIDE to SCROLL_X_WIDE+1 do begin
            printImage(i+SCROLL_X_WIDE,j+SCROLL_Y_WIDE,tile_data[readMap(i+x,j+y)]^);
         end;
      end;
      yui_face := yui_face xor $01;
      printSprite32(SCROLL_X_WIDE,SCROLL_Y_WIDE,character_data[yui_face]^);
      printSprite16(SCROLL_X_WIDE,SCROLL_Y_WIDE,tile_data[readMap(x,y)]^);
      printSprite16(SCROLL_X_WIDE+1,SCROLL_Y_WIDE,tile_data[readMap(x+1,y)]^);
      printSprite16(SCROLL_X_WIDE,SCROLL_Y_WIDE+1,tile_data[readMap(x,y+1)]^);
      printSprite16(SCROLL_X_WIDE+1,SCROLL_Y_WIDE+1,tile_data[readMap(x+1,y+1)]^);
      flipPage;

      x1 := 0; y1 := 0;
      if _LEFT_KEY  in scan_code then begin
         dec(x1); yui_face := 4 or (yui_face and $01)
      end;
      if _RIGHT_KEY in scan_code then begin
         inc(x1); yui_face := 6 or (yui_face and $01)
      end;
      if _UP_KEY    in scan_code then begin
         dec(y1); yui_face := 0 or (yui_face and $01)
      end;
      if _DOWN_KEY  in scan_code then begin
         inc(y1); yui_face := 2 or (yui_face and $01)
      end;

      if _ESC_KEY   in ascii_code then break;

      if not (_CONTROL_KEY in scan_code) then waitVerticalRetrace(3);

      if isWalkableMap(x+x1,y+y1+1) and isWalkableMap(x+x1+1,y+y1+1) then begin
         inc(x,x1); inc(y,y1);
      end;

      if not (x in [0..x_max-1]) then begin
         if x < 0 then x := 0
         else x := x_max-1;
      end;
      if not (y in [0..y_max-1]) then begin
         if y < 0 then y := 0
         else y := y_max-1;
      end;

   end;

end;

procedure _CUT_;
begin

   resetKeyboardInterrupt;
   closeGraph;

end;

begin

   _READY_; _ACTION_; _CUT_

end.