#include "Mesh.H"


// Id Chunk
#define MAIN3DS                  0x4D4D

// Main Chunks
#define EDIT3DS                  0x3D3D  // this is the start of the editor config
#define KEYF3DS                  0xB000  // this is the start of the keyframer config

// sub defines of EDIT3DS
#define EDIT_MATERIAL            0xAFFF
#define EDIT_CONFIG1             0x0100
#define EDIT_CONFIG2             0x3E3D

#define EDIT_BITMAP              0x1100
#define EDIT_BACKGR              0x1200
#define EDIT_USE_SOLID_BGND      0x1201
#define EDIT_V_GRADIENT          0x1300
#define EDIT_LO_SHADOW_BIAS      0x1400
#define EDIT_HI_SHADOW_BIAS      0x1410
#define EDIT_SHADOW_MAP_SIZE     0x1420
#define EDIT_SHADOW_SAMPLE       0x1430
#define EDIT_SHADOW_RANGE        0x1440
#define EDIT_SHADOW_FILTER       0x1450
#define EDIT_RAY_BIAS            0x1460
#define EDIT_O_CONSTS            0x1500

#define EDIT_AMBIENT_LIGHT       0x2100
#define EDIT_FOG                 0x2200
#define EDIT_USE_FOG             0x2201
#define EDIT_FOG_BGND            0x2210
#define EDIT_DISTANCE_CUE        0x2300
#define EDIT_LAYER_FOG           0x2302
#define EDIT_USE_LAYER_FOG       0x2303
#define EDIT_DCUE_BGND           0x2301
#define EDIT_SMAGIC              0x2d2d
#define EDIT_LMAGIC              0x2d3d

#define EDIT_DEFAULT_VIEW        0x3000
#define EDIT_VIEW_TOP            0x3010
#define EDIT_VIEW_BOTTOM         0x3020
#define EDIT_VIEW_LEFT           0x3030
#define EDIT_VIEW_RIGHT          0x3040
#define EDIT_VIEW_FRONT          0x3050
#define EDIT_VIEW_BACK           0x3060
#define EDIT_VIEW_USER           0x3070
#define EDIT_VIEW_CAMERA         0x3080
#define EDIT_VIEW_WINDOW         0x3090

#define EDIT_MESH_VERSION        0x3d3e
#define EDIT_MLIB_MAGIC          0x3daa
#define EDIT_PRJ_MAGIC           0x3dc2
#define EDIT_MAT_MAGIC           0x3dff

#define EDIT_UNKNW14             0xAFFF

// sub defines of EDIT_MATERIAL
#define MAT_NAME01               0xA000

// sub defines of EDIT_OBJECT
#define EDIT_OBJECT              0x4000
#define OBJ_HIDDEN               0x4010
#define OBJ_VIS_LOFTER           0x4011
#define OBJ_DOESNT_CAST          0x4012
#define OBJ_MATTE                0x4013
#define OBJ_FAST                 0x4014
#define OBJ_PROCEDURAL           0x4015
#define OBJ_FROZEN               0x4016
#define OBJ_DONT_RCVSHADOW       0x4017

#define OBJ_TRIMESH              0x4100

// sub defines of OBJ_TRIMESH
#define TRI_VERTEXL              0x4110
#define TRI_FACEL2               0x4111 // face flag array
#define TRI_FACEL1               0x4120 // face array
#define TRI_MSH_MAT_GROUP        0x4130 // mesh material group
#define TRI_OLD_MAT_GROUP        0x4131 // old  material group
#define TRI_TEXTURE_VERTS        0x4140 // Texture vertex
#define TRI_SMOOTH               0x4150
#define TRI_LOCAL_AXIS           0x4160
#define TRI_MESH_COLOR           0x4165
#define TRI_MESH_TEXTURE_INFO    0x4170

#define OBJ_PROC_NAME            0x4181
#define OBJ_PROC_DATA            0x4182
#define OBJ_MSH_BOXMAP           0x4190

#define OBJ_N_D_L_OLD            0x4400
#define OBJ_N_CAM_OLD            0x4500

#define OBJ_DIRECT_LIGHT         0x4600
#define OBJ_DL_SPOTLIGHT         0x4610
#define OBJ_DL_OFF               0x4620
#define OBJ_DL_ATTENUATE         0x4625
#define OBJ_DL_RAYSHAD           0x4627
#define OBJ_DL_SHADOWED          0x4630
#define OBJ_DL_LOCAL_SHADOW      0x4640
#define OBJ_DL_LOCAL_SHADOW2     0x4641
#define OBJ_DL_SEE_CONE          0x4650
#define OBJ_DL_SPOT_RECTANGULAR  0x4651
#define OBJ_DL_SPOT_OVERSHOOT    0x4652
#define OBJ_DL_SPOT_PROJECTOR    0x4653
#define OBJ_DL_EXCLUDE           0x4654
#define OBJ_DL_RANGE             0x4655
#define OBJ_DL_SPOT_ROLL         0x4656
#define OBJ_DL_SPOT_ASPECT       0x4657
#define OBJ_DL_RAY_BIAS          0x4658
#define OBJ_DL_INNER_RANGE       0x4659
#define OBJ_DL_OUTER_RANGE       0x465a
#define OBJ_DL_MULTIPLIER        0x465b
#define OBJ_N_AMBIENT_LIGHT      0x4680

#define OBJ_CAMERA               0x4700
#define OBJ_CAM_SEE_CONE         0x4710
#define OBJ_CAM_RANGES           0x4720

#define OBJ_HIERARCHY            0x4f00
#define OBJ_PARENT_OBJECT        0x4f10
#define OBJ_PIVOT_OBJECT         0x4f30
#define OBJ_PIVOT_LIMITS         0x4f40
#define OBJ_XLATE_RANGE          0x4f50

#define VIEWPORT_LAYOUT_OLD      0x7000
#define VIEWPORT_LAYOUT          0x7001
#define VIEWPORT_DATA_OLD        0x7010
#define VIEWPORT_DATA            0x7011
#define VIEWPORT_DATA_3          0x7012
#define VIEWPORT_SIZE            0x7020
#define VIEWPORT_NETWORK_VIEW    0x7030

#define MAT_NAME                 0xa000
#define MAT_AMBIENT              0xa010
#define MAT_DIFFUSE              0xa020
#define MAT_SPECULAR             0xa030
#define MAT_SHINESS              0xa040
#define MAT_SHIN2PCT             0xa041
#define MAT_SHIN3PCT             0xa042
#define MAT_TRANSPARENCY         0xa050
#define MAT_XPFALL               0xa052
#define MAT_REFBLUR              0xa053
#define MAT_SELF_ILLUM           0xa080
#define MAT_TWO_SIDE             0xa081
#define MAT_DECAL                0xa082
#define MAT_ADDITIVE             0xa083
#define MAT_SELF_ILPCT           0xa084
#define MAT_WIRE                 0xa085
#define MAT_SUPERSMP             0xa086
#define MAT_WIRESIZE             0xa087
#define MAT_FACEMAP              0xa088
#define MAT_XPFALLIN             0xa08a
#define MAT_PHONGSOFT            0xa08c
#define MAT_WIREABS              0xa08e
#define MAT_SHADING              0xa100
#define MAT_TEXMAP               0xa200
#define MAT_SPECMAP              0xa204
#define MAT_OPACMAP              0xa210
#define MAT_REFLMAP              0xa220
#define MAT_BUMPMAP              0xa230
#define MAT_USE_XPFALL           0xa240
#define MAT_USE_REFBLUR          0xa250
#define MAT_BUMP_PERCENT         0xa252

#define MAT_MAPNAME              0xa300
#define MAT_ACUBIC               0xa310
#define MAT_SXP_TEXT_DATA        0xa320
#define MAT_SXP_TEXT2_DATA       0xa321

// sub defs of KEYF3DS
#define KEYF_UNKNWN01           0xB009
#define KEYF_UNKNWN02           0xB00A
#define KEYF_FRAMES             0xB008
#define KEYF_OBJDES             0xB002

// these define the different color chunk types
#define COL_RGB                 0x0010
#define COL_TRUE                0x0011
#define COL_LINE_TRUE           0x0012
#define COL_LINE_RGB            0x0013

// defines for viewport chunks
#define TOP                     0x0001
#define BOTTOM                  0x0002
#define LEFT                    0x0003
#define RIGHT                   0x0004
#define FRONT                   0x0005
#define BACK                    0x0006
#define USER                    0x0007
#define CAMERA                  0x0008
#define LIGHT                   0x0009
#define DISABLED                0x0010
#define BOGUS                   0x0011

// Percentage
#define INT_PERCENTAGE          0x0030
#define FLOAT_PERCENTAGE        0x0031


FILE *bin3ds;
char temp_name[100];

BYTE ReadChar()
{
    BYTE temp_char;

    fread( &temp_char, sizeof(BYTE), 1, bin3ds );
    return temp_char;
}

WORD ReadShort()
{
    WORD temp_short;

    fread( &temp_short, sizeof(WORD), 1, bin3ds );
    return temp_short;
}

DWORD ReadLong()
{
    DWORD temp_long;

	fread( &temp_long, sizeof(DWORD), 1, bin3ds );
    return temp_long;
}

DWORD ReadChunkPointer()
{
	return ReadLong();
}

DWORD GetChunkPointer()
{
    // compensate for the already read Marker
    return ( ftell( bin3ds ) - 2 );
}

void ChangeChunkPointer( DWORD temp_pointer )
{
	fseek( bin3ds, temp_pointer, SEEK_SET );
}

BOOL ReadName()
{
    strcpy( temp_name, "Default name" );

    BYTE letter = ReadChar();
    if ( letter == 0 )
        return FALSE; // dummy object

	int teller = 0;
    temp_name[teller] = letter;
    teller++;

    do
    {
        letter = ReadChar();
        temp_name[teller] = letter;
        teller++;
	}
    while ( (letter!=0) && (teller<12) );

	temp_name[teller-1] = 0;

    return TRUE;
}

BOOL ReadLongName()
{
    strcpy( temp_name, "Default name" );

    BYTE letter = ReadChar();
    if ( letter == 0 )
        return FALSE; // dummy object

	int teller=0;
    temp_name[teller] = letter;
    teller++;

	do
    {
        letter = ReadChar();
		temp_name[teller] = letter;
        teller++;
    }
    while ( letter != 0 );

    temp_name[teller-1] = 0;

    return TRUE;
}

DWORD ReadUnknownChunk( WORD chunk_id )
{
	// compiler warnig depressor *>:)
    chunk_id = chunk_id;

    DWORD current_pointer = GetChunkPointer();
    DWORD temp_pointer    = ReadChunkPointer();

    // move to the new chunk dvPosition
    ChangeChunkPointer( current_pointer + temp_pointer );
    return temp_pointer;
}

DWORD ReadRGBColor( float *r, float *g, float *b, float *a )
{
	GetChunkPointer();
	DWORD temp_pointer = ReadChunkPointer();


	fread( r, sizeof(float), 1, bin3ds );
	fread( g, sizeof(float), 1, bin3ds );
	fread( b, sizeof(float), 1, bin3ds );
	*a = 1.0f;

	return temp_pointer;
}

DWORD ReadTrueColor( float *r, float *g, float *b, float *a )
{
	GetChunkPointer();
	DWORD temp_pointer = ReadChunkPointer();


	*r = ((float)ReadChar()) / 255.0f;
	*g = ((float)ReadChar()) / 255.0f;
	*b = ((float)ReadChar()) / 255.0f;
	*a = 1.0f;

	return temp_pointer;
}

DWORD ReadShortPercentage( float *percent )
{
	GetChunkPointer();
	DWORD temp_pointer = ReadChunkPointer();


	*percent = ((float)ReadShort())/100.0f;

	return temp_pointer;
}

DWORD ReadFloatPercentage( float *percent )
{
	GetChunkPointer();
	DWORD temp_pointer = ReadChunkPointer();


	fread( percent, sizeof(float), 1, bin3ds );

	return temp_pointer;
}

DWORD ReadSpotChunk( LPLIGHT lpLight )
{
	DWORD current_pointer = GetChunkPointer();
	DWORD temp_pointer    = ReadChunkPointer();

	// Spot light
	lpLight->Light.dltType = D3DLIGHT_SPOT;

	fread( &lpLight->Light.dvDirection.x, sizeof(float), 1, bin3ds );
	fread( &lpLight->Light.dvDirection.z, sizeof(float), 1, bin3ds );
	fread( &lpLight->Light.dvDirection.y, sizeof(float), 1, bin3ds );

//	fread( &lpLight->Light.dvRange, sizeof(float), 1, bin3ds );
	fread( &lpLight->Light.dvFalloff, sizeof(float), 1, bin3ds );
	fread( &lpLight->Light.dvFalloff, sizeof(float), 1, bin3ds );

	// move to the new chunk dvPosition
	ChangeChunkPointer( current_pointer + temp_pointer );
	return temp_pointer;
}

DWORD ReadLightChunk( LPLIGHT *lpLight )
{
	DWORD tellertje=6L; // 2 id + 4 pointer

	DWORD current_pointer = GetChunkPointer();
	DWORD temp_pointer    = ReadChunkPointer();


	LPLIGHT light;
	if ( !*lpLight )
		light = *lpLight = CreateLight( temp_name );
	else
		light = CreateLight( *lpLight, temp_name );


	light->Light.dltType = D3DLIGHT_POINT;

	fread( &light->Light.dvPosition.x, sizeof(float), 1, bin3ds );
	fread( &light->Light.dvPosition.z, sizeof(float), 1, bin3ds );
	fread( &light->Light.dvPosition.y, sizeof(float), 1, bin3ds );

	tellertje += 12L;

	BYTE end_found = FALSE;
	while ( end_found == FALSE )
	{
		WORD temp_short = ReadShort();
		switch ( temp_short )
		{
/*
			case OBJ_DL_MULTIPLIER:
				tellertje += ReadFloatPercentage( &light->Light.dvRange );
				break;

			case OBJ_DL_INNER_RANGE:
				tellertje += ReadFloatPercentage( &light->Light.dvTheta );
				break;

			case OBJ_DL_OUTER_RANGE:
				tellertje += ReadFloatPercentage( &light->Light.dvPhi );
				break;
*/
			case OBJ_DL_SPOTLIGHT:
				tellertje += ReadSpotChunk( light );
				break;

			case COL_RGB:
				tellertje += ReadRGBColor( &light->Light.dcvColor.r,
										   &light->Light.dcvColor.g,
										   &light->Light.dcvColor.b,
										   &light->Light.dcvColor.a );
				break;

			case COL_TRUE:
				tellertje += ReadTrueColor( &light->Light.dcvColor.r,
											&light->Light.dcvColor.g,
										    &light->Light.dcvColor.b,
											&light->Light.dcvColor.a );
				break;

			default:
				tellertje += ReadUnknownChunk( temp_short );
				break;
		}

		tellertje += 2;
		if ( tellertje >= temp_pointer )
			end_found = TRUE;
	}

	// move to the new chunk dvPosition
	ChangeChunkPointer( current_pointer + temp_pointer );
	return temp_pointer;
}

DWORD ReadCamRangeChunk( float *near_plane, float *far_plane )
{
	DWORD current_pointer = GetChunkPointer();
	DWORD temp_pointer    = ReadChunkPointer();


	fread( near_plane, sizeof(float), 1, bin3ds );
	fread( far_plane, sizeof(float), 1, bin3ds );

	// move to the new chunk dvPosition
	ChangeChunkPointer( current_pointer + temp_pointer );
	return temp_pointer;
}

DWORD ReadCameraChunk( LPCAMERA *lpCamera )
{
	DWORD tellertje = 6L;

	DWORD current_pointer = GetChunkPointer();
	DWORD temp_pointer    = ReadChunkPointer();

	LPCAMERA camera;
	if ( !*lpCamera )
		camera = *lpCamera = CreateCamera( temp_name );
	else
		camera = CreateCamera( *lpCamera, temp_name );

	fread( &camera->dvPosition.x, sizeof(float), 1, bin3ds );
	fread( &camera->dvPosition.z, sizeof(float), 1, bin3ds );
	fread( &camera->dvPosition.y, sizeof(float), 1, bin3ds );

	tellertje += 12L;

	fread( &camera->dvDirection.x, sizeof(float), 1, bin3ds );
	fread( &camera->dvDirection.z, sizeof(float), 1, bin3ds );
	fread( &camera->dvDirection.y, sizeof(float), 1, bin3ds );

	tellertje += 12L;

	fread( &camera->bank, sizeof(float), 1, bin3ds );
	fread( &camera->lens, sizeof(float), 1, bin3ds );

	tellertje += 8L;


	BYTE  end_found = FALSE;
	while ( end_found == FALSE && (temp_pointer-38) > 0 )
	{
		WORD temp_short = ReadShort();
		switch ( temp_short )
		{
			case OBJ_CAM_RANGES:
				tellertje += ReadCamRangeChunk( &camera->nearPlane, &camera->farPlane );
				break;

			default:
				tellertje += ReadUnknownChunk( temp_short );
				break;
		}

		tellertje += 2;
		if ( tellertje >= temp_pointer )
			end_found = TRUE;
	}

	// move to the new chunk dvPosition
	ChangeChunkPointer( current_pointer + temp_pointer );
	return temp_pointer;
}


DWORD ReadVerticesChunk( LPOBJECT lpObject )
{
	DWORD current_pointer = GetChunkPointer();
	DWORD temp_pointer    = ReadChunkPointer();


	WORD  num_vertices = ReadShort();

	// object   vertex  Ѵ.
	lpObject->NumVertices = num_vertices;
	lpObject->lpVertices = new VECTOR [ num_vertices ];

	for ( int i=0; i<num_vertices; i++ )
	{
		// vertex ǥ Ѵ.
		// 3ds  ǥ 迭 open gl  ǥ 迭  ٸ 
		fread( &lpObject->lpVertices[i].x, sizeof(float), 1, bin3ds );
		fread( &lpObject->lpVertices[i].z, sizeof(float), 1, bin3ds );
		fread( &lpObject->lpVertices[i].y, sizeof(float), 1, bin3ds );
	}


	// move to the new chunk dvPosition
	ChangeChunkPointer( current_pointer + temp_pointer );
	return temp_pointer;
}

DWORD ReadTextureVerticesChunk( LPOBJECT lpObject )
{
	DWORD current_pointer = GetChunkPointer();
	DWORD temp_pointer    = ReadChunkPointer();


	WORD  num_vertices = ReadShort();
	lpObject->lpTVertices = new TVERTEX [ num_vertices ];

	for ( int i=0; i<num_vertices; i++ )
	{
		// vertex ǥ Ѵ.
        fread( &lpObject->lpTVertices[i].tu, sizeof(float), 1, bin3ds );
        fread( &lpObject->lpTVertices[i].tv, sizeof(float), 1, bin3ds );
	}

	// move to the new chunk dvPosition
	ChangeChunkPointer( current_pointer + temp_pointer );
	return temp_pointer;
}

DWORD ReadTriMeshMatGroupChunk( LPTRIMESHMATGROUP *lpTriMeshMatGroup )
{
	DWORD current_pointer = GetChunkPointer();
	DWORD temp_pointer    = ReadChunkPointer();

	char  mat_name[100];
	for ( int i=0; i<100; i++ )
	{
		fread( &mat_name[i], sizeof(char), 1, bin3ds );
		if ( mat_name[i] == 0x00 )
			break;
	}

	WORD face_num, face;
	fread( &face_num, sizeof(WORD), 1, bin3ds );


    LPTRIMESHMATGROUP group;
    if ( !*lpTriMeshMatGroup )
		group = *lpTriMeshMatGroup = CreateTriMeshMatGroup( mat_name );
    else
        group = CreateTriMeshMatGroup( *lpTriMeshMatGroup, mat_name );

    group->NumTriangles = face_num;
    group->lpTriangles  = new WORD [face_num];

	for ( i=0; i<face_num; i++ )
	{
        fread( &face, sizeof(WORD), 1, bin3ds );
        group->lpTriangles[i] = face;
	}

	// move to the new chunk dvPosition
	ChangeChunkPointer( current_pointer + temp_pointer );
	return temp_pointer;
}

DWORD ReadTriChunk( LPOBJECT lpObject )
{
	DWORD  tellertje=6L; // 2 id + 4 pointer

	DWORD current_pointer = GetChunkPointer();
	DWORD temp_pointer    = ReadChunkPointer();


	WORD  num_triangle = ReadShort();

	//    Ѵ.
	lpObject->NumTriangles = num_triangle;
	lpObject->lpTriangles = new TRIANGLE [ num_triangle ];

	for ( int i=0; i<num_triangle; i++ )
	{
		//   ϴ vertex index  Ѵ.
		lpObject->lpTriangles[i].vindices[2] = ReadShort();
		lpObject->lpTriangles[i].vindices[1] = ReadShort();
		lpObject->lpTriangles[i].vindices[0] = ReadShort();

		ReadShort();
	}

	tellertje += (DWORD)(num_triangle * 8 );

	BYTE  end_found = FALSE;
	while ( end_found == FALSE )
	{
		WORD temp_short = ReadShort();
		switch ( temp_short )
		{
			case TRI_SMOOTH:
				tellertje += ReadUnknownChunk( temp_short );
				break;

			case TRI_MSH_MAT_GROUP:
				tellertje += ReadTriMeshMatGroupChunk( &lpObject->lpTriMeshMatGroup );
				break;

			default:
				break;
		}

		tellertje += 2;
		if ( tellertje >= temp_pointer )
			end_found = TRUE;
	}

	// move to the new chunk dvPosition
	ChangeChunkPointer( current_pointer + temp_pointer );
	return temp_pointer;
}

DWORD ReadObjChunk( LPOBJECT *lpObject, LPMATERIAL lpMaterial )
{
	DWORD tellertje = 6L; // 2 id + 4 pointer

	DWORD current_pointer = GetChunkPointer();
	DWORD temp_pointer    = ReadChunkPointer();

	LPOBJECT object;
	if ( !*lpObject )
		object = *lpObject = CreateObject( temp_name );
	else
		object = CreateObject( *lpObject, temp_name );

	BYTE end_found = FALSE;
	while ( end_found == FALSE )
	{
		WORD temp_short = ReadShort();
		switch ( temp_short )
		{
			case TRI_VERTEXL:
				// object  vertex  оδ.
				tellertje += ReadVerticesChunk( object );
				break;

			case TRI_TEXTURE_VERTS:
				tellertje += ReadTextureVerticesChunk( object );
				break;

			case TRI_FACEL1:
				// object    оδ.
				tellertje += ReadTriChunk( object );
				break;

			default:
				tellertje += ReadUnknownChunk( temp_short );
				break;
		}

		tellertje += 2;
		if ( tellertje >= temp_pointer )
			end_found = TRUE;
	}

	CalcObject( object, lpMaterial );

	// move to the new chunk dvPosition
	ChangeChunkPointer( current_pointer + temp_pointer );
	return temp_pointer;
}

DWORD ReadObjectChunk( LPMESH lpMesh )
{
	DWORD tellertje=6L; // 2 id + 4 pointer

	DWORD current_pointer = GetChunkPointer();
	DWORD temp_pointer    = ReadChunkPointer();


	ReadName();

	BYTE end_found = FALSE;
	while ( end_found == FALSE )
	{
		WORD temp_short = ReadShort();
		switch ( temp_short )
		{
			case OBJ_TRIMESH:
				tellertje += ReadObjChunk( &lpMesh->lpObject, lpMesh->lpMaterial );
                break;

			case OBJ_DIRECT_LIGHT:
				tellertje += ReadLightChunk( &lpMesh->lpLight );
				break;

			case OBJ_CAMERA:
				tellertje += ReadCameraChunk( &lpMesh->lpCamera );
				break;

			default:
				tellertje += ReadUnknownChunk( temp_short );
				break;
		}

		tellertje += 2;
		if ( tellertje >= temp_pointer )
			end_found = TRUE;
	}

	// move to the new chunk dvPosition
	ChangeChunkPointer( current_pointer + temp_pointer );
	return temp_pointer;
}

DWORD ReadAmbientChunk( float *r, float *g, float *b, float *a )
{
	DWORD tellertje=6L; // 2 id + 4 pointer

    DWORD current_pointer = GetChunkPointer();
    DWORD temp_pointer    = ReadChunkPointer();


    BYTE end_found = FALSE;
	while ( end_found == FALSE )
    {
        WORD temp_short = ReadShort();
        switch ( temp_short )
        {
            case COL_RGB:
				tellertje += ReadRGBColor( r, g, b, a );
				break;

			case COL_TRUE:
				tellertje += ReadTrueColor( r, g, b, a );
				break;

			default:
                break;
        }

        tellertje += 2;
        if ( tellertje >= temp_pointer )
            end_found = TRUE;
	}

    // move to the new chunk dvPosition
    ChangeChunkPointer( current_pointer + temp_pointer );
    return temp_pointer;
}

DWORD ReadSpecularChunk( float *r, float *g, float *b, float *a )
{
	DWORD tellertje=6L; // 2 id + 4 pointer

	DWORD current_pointer = GetChunkPointer();
	DWORD temp_pointer    = ReadChunkPointer();


	BYTE end_found = FALSE;
	while ( end_found == FALSE )
	{
		WORD temp_short = ReadShort();
		switch ( temp_short )
		{
			case COL_RGB:
				tellertje += ReadRGBColor( r, g, b, a );
				break;

			case COL_TRUE:
				tellertje += ReadTrueColor( r, g, b, a );
				break;

			default:
				break;
		}

		tellertje += 2;
        if ( tellertje >= temp_pointer )
            end_found = TRUE;
    }

    // move to the new chunk dvPosition
    ChangeChunkPointer( current_pointer + temp_pointer );
	return temp_pointer;
}

DWORD ReadDiffuseChunk( float *r, float *g, float *b, float *a )
{
	DWORD tellertje = 6L; // 2 id + 4 pointer

	DWORD current_pointer = GetChunkPointer();
	DWORD temp_pointer    = ReadChunkPointer();


	BYTE end_found=FALSE;
	while ( end_found == FALSE )
	{
		WORD temp_short = ReadShort();
		switch ( temp_short )
		{
			case COL_RGB:
				tellertje += ReadRGBColor( r, g, b, a );
				break;

			case COL_TRUE:
				tellertje += ReadTrueColor( r, g, b, a );
				break;

			default:
				break;
	   }

		tellertje += 2;
		if ( tellertje >= temp_pointer )
			end_found = TRUE;
	}

	// move to the new chunk dvPosition
	ChangeChunkPointer( current_pointer + temp_pointer );
	return temp_pointer;
}

DWORD ReadShinessChunk( float *shiness )
{
	DWORD tellertje = 6L; // 2 id + 4 pointer

	DWORD current_pointer = GetChunkPointer();
	DWORD temp_pointer    = ReadChunkPointer();


	BYTE end_found = FALSE;
	while ( end_found == FALSE )
	{
		WORD temp_short = ReadShort();
		switch ( temp_short )
		{
			case INT_PERCENTAGE:
				tellertje += ReadShortPercentage( shiness );
				break;

			case FLOAT_PERCENTAGE:
				tellertje += ReadFloatPercentage( shiness );
				break;

            default:
                break;
        }

        tellertje += 2;
        if ( tellertje >= temp_pointer )
            end_found = TRUE;
    }

    // move to the new chunk dvPosition
    ChangeChunkPointer( current_pointer + temp_pointer );
	return temp_pointer;
}

DWORD ReadMatShadingChunk( WORD *shading )
{
	DWORD current_pointer = GetChunkPointer();
    DWORD temp_pointer    = ReadChunkPointer();


    fread( shading, sizeof(WORD), 1, bin3ds );

    // move to the new chunk dvPosition
    ChangeChunkPointer( current_pointer + temp_pointer );
    return temp_pointer;
}

DWORD ReadMatDefChunk( char *name )
{
	DWORD current_pointer = GetChunkPointer();
	DWORD temp_pointer    = ReadChunkPointer();

	if ( !ReadLongName() )
		strcpy( name, "DEFULAT" );
	else
		strcpy( name, temp_name );

	// move to the new chunk dvPosition
	ChangeChunkPointer( current_pointer + temp_pointer );
	return temp_pointer;
}

DWORD ReadMapNameChunk( char *name )
{
	DWORD current_pointer = GetChunkPointer();
	DWORD temp_pointer    = ReadChunkPointer();

	for ( int i=0; i<100; i++ )
	{
		fread( &name[i], sizeof(char), 1, bin3ds );
		if ( name[i] == 0x00 )
			break;
	}

	// move to the new chunk dvPosition
	ChangeChunkPointer( current_pointer + temp_pointer );
	return temp_pointer;
}

DWORD ReadTextureMapChunk( char *name )
{
	DWORD tellertje = 6L;

	DWORD current_pointer = GetChunkPointer();
	DWORD temp_pointer    = ReadChunkPointer();


	BYTE end_found = FALSE;
	while ( end_found == FALSE )
	{
		WORD temp_int = ReadShort();
		switch ( temp_int )
		{
			case MAT_MAPNAME:
				tellertje += ReadMapNameChunk( name );
				break;

			default:
				break;
		}

		tellertje += 2;
		if ( tellertje >= temp_pointer )
			end_found = TRUE;
	}

	// move to the new chunk dvPosition
	ChangeChunkPointer( current_pointer + temp_pointer );
	return temp_pointer;
}

DWORD ReadMaterialChunk( LPMATERIAL *lpMaterial )
{
	DWORD tellertje = 6L;

	DWORD current_pointer = GetChunkPointer();
	DWORD temp_pointer    = ReadChunkPointer();


	LPMATERIAL material;
	if ( !*lpMaterial )
		material = *lpMaterial = CreateMaterial( "DEFAULT" );
	else
		material = CreateMaterial( *lpMaterial, "DEFAULT"  );

	BYTE end_found = FALSE;
	while ( end_found == FALSE )
	{
		WORD temp_int = ReadShort();
		switch ( temp_int )
		{
			case MAT_NAME:
				tellertje += ReadMatDefChunk( material->szName );
				break;

			case MAT_AMBIENT:
				tellertje += ReadAmbientChunk( &material->Material.dcvAmbient.r,
											   &material->Material.dcvAmbient.g,
											   &material->Material.dcvAmbient.b,
											   &material->Material.dcvAmbient.a );
				break;

			case MAT_DIFFUSE:
				tellertje += ReadDiffuseChunk( &material->Material.dcvDiffuse.r,
											   &material->Material.dcvDiffuse.g,
											   &material->Material.dcvDiffuse.b,
											   &material->Material.dcvDiffuse.a );
				break;

			case MAT_SPECULAR:
				tellertje += ReadSpecularChunk( &material->Material.dcvSpecular.r,
												&material->Material.dcvSpecular.g,
												&material->Material.dcvSpecular.b,
												&material->Material.dcvSpecular.a );
				break;

			case MAT_SHINESS:
				tellertje += ReadShinessChunk( &material->Material.dvPower );
				break;

			case MAT_SHADING:
				tellertje += ReadMatShadingChunk( &material->shadeType );
				break;

			case MAT_TEXMAP:
				tellertje += ReadTextureMapChunk( material->szTextureName );
				break;

			default:
				tellertje += ReadUnknownChunk( temp_int );
				break;
		}

		tellertje += 2;
		if ( tellertje >= temp_pointer )
			end_found = TRUE;
    }

	// move to the new chunk dvPosition
	ChangeChunkPointer( current_pointer + temp_pointer );
	return temp_pointer;
}

DWORD ReadEditChunk( LPMESH lpMesh )
{
	DWORD tellertje = 6L;

    DWORD current_pointer = GetChunkPointer();
    DWORD temp_pointer    = ReadChunkPointer();


    BYTE end_found = FALSE;
    while ( end_found == FALSE )
    {
        WORD temp_int = ReadShort();
		switch ( temp_int )
        {
            case EDIT_MATERIAL:
				tellertje += ReadMaterialChunk( &lpMesh->lpMaterial );
				break;

			case EDIT_AMBIENT_LIGHT:
				tellertje += ReadAmbientChunk( &lpMesh->ambient.r,
											   &lpMesh->ambient.g,
											   &lpMesh->ambient.b,
											   &lpMesh->ambient.a );
				break;

			case EDIT_OBJECT:
				tellertje += ReadObjectChunk( lpMesh );
				break;

			default:
				tellertje += ReadUnknownChunk( temp_int );
				break;
		}

        tellertje += 2;
        if ( tellertje >= temp_pointer )
            end_found = TRUE;
    }

    // move to the new chunk dvPosition
    ChangeChunkPointer( current_pointer + temp_pointer );
    return temp_pointer;
}

DWORD ReadKeyfChunk()
{
    DWORD tellertje = 6L;

    DWORD current_pointer = GetChunkPointer();
    DWORD temp_pointer    = ReadChunkPointer();


	BYTE end_found = FALSE;
    while ( end_found == FALSE )
    {
        WORD temp_int = ReadShort();
        switch ( temp_int )
        {
            case KEYF_FRAMES:
                tellertje += ReadUnknownChunk( temp_int );
                break;

            case KEYF_OBJDES:
                tellertje += ReadUnknownChunk( temp_int );
                break;

            default:
                tellertje += ReadUnknownChunk( temp_int );
                break;
        }

        tellertje += 2;
		if ( tellertje >= temp_pointer )
            end_found = TRUE;
    }

    // move to the new chunk dvPosition
    ChangeChunkPointer( current_pointer + temp_pointer );
    return temp_pointer;
}

DWORD ReadMainChunk( LPMESH lpMesh )
{
    DWORD tellertje = 6L;

	DWORD current_pointer = GetChunkPointer();
	DWORD temp_pointer    = ReadChunkPointer();


	BYTE end_found = FALSE;
    while ( end_found == FALSE )
    {
		WORD temp_int = ReadShort();
        switch ( temp_int )
        {
            case KEYF3DS:
                tellertje += ReadKeyfChunk();
                break;

            case EDIT3DS:
                tellertje += ReadEditChunk( lpMesh );
                break;

            default:
                break;
        }

        tellertje+=2;
        if ( tellertje >= temp_pointer )
			end_found=TRUE;
    }

	// move to the new chunk dvPosition
    ChangeChunkPointer( current_pointer + temp_pointer );
    return temp_pointer;
}

BOOL ReadPrimaryChunk( LPMESH lpMesh )
{
    if ( ReadShort() == MAIN3DS )
    {
        fseek( bin3ds, 2, SEEK_SET );
        ReadMainChunk( lpMesh );
	}
    else
        return FALSE;

    return TRUE;
}

LPMESH Load3DS( char *FileName )
{
	bin3ds = fopen( FileName, "rb" );
    if ( bin3ds == NULL )
        return NULL;

	long current_pos = ftell( bin3ds );

    //  Ȯ
    fseek( bin3ds, 12L, SEEK_SET );

    WORD version;
	fread( &version, sizeof(WORD), 1, bin3ds );
	if ( version < 3 )
    {
		fclose( bin3ds );
        return NULL;
    }

    fseek( bin3ds, current_pos, SEEK_SET );

	LPMESH lpMesh = CreateMesh();
	if ( !lpMesh )
        return NULL;

    while ( ReadPrimaryChunk( lpMesh ) == TRUE );

	fclose( bin3ds );

	return lpMesh;
}


