#include "Camera.H"

#include "Matrix.H"

// Camera List
///////////////////////////////////////////////////////////////////////////////
LPCAMERA FindCamera( LPCAMERA lpCamera, char* lpszName )
{
	LPCAMERA camera = lpCamera;

	while ( camera )
	{
		if ( !strcmp( lpszName, camera->szName ) )
			break;

		camera = camera->lpNext;
	}

	return camera;
}

LPCAMERA CreateCamera( char* lpszName )
{
	LPCAMERA camera = new CAMERA;
	if ( !camera )
		return NULL;

	ZeroMemory( camera, sizeof(CAMERA) );
	strcpy( camera->szName, lpszName );

	return camera;
}

LPCAMERA CreateCamera( LPCAMERA lpCamera, char* lpszName )
{
	if ( !lpCamera )
		return CreateCamera( lpszName );

	LPCAMERA camera = FindCamera( lpCamera, lpszName );
	if ( !camera )
	{
		camera = new CAMERA;
		if ( !camera )
			return NULL;

		ZeroMemory( camera, sizeof(CAMERA) );
		strcpy( camera->szName, lpszName );

		LPCAMERA lastCamera = lpCamera;
		while ( lastCamera->lpNext )
			lastCamera = lastCamera->lpNext;

		lastCamera->lpNext = camera;
	}

	return camera;
}

void DestroyCamera( LPCAMERA lpCamera )
{
	LPCAMERA camera;

	while ( lpCamera->lpNext )
	{
		camera = lpCamera->lpNext;
		lpCamera->lpNext = lpCamera->lpNext->lpNext;

		delete [] camera;
	}

	delete [] lpCamera;
}


void AddCamera( LPCAMERA lpCamera, LPCAMERA lpChildCamera )
{
	LPCAMERA camera = FindCamera( lpCamera, lpChildCamera->szName );
	if ( !camera )
	{
		camera = lpCamera;
		while ( camera->lpNext )
			camera = camera->lpNext;

		camera->lpNext = lpChildCamera;
	}
}


// Direct3D Camera Func
///////////////////////////////////////////////////////////////////////////////
void SetCamera( LPDIRECT3DDEVICE2 lpDev, LPCAMERA lpCamera )
{
    if ( lpCamera )
    {
		D3DVECTOR position( lpCamera->dvPosition.x, lpCamera->dvPosition.y, lpCamera->dvPosition.z );
		D3DVECTOR direction( lpCamera->dvDirection.x, lpCamera->dvDirection.y, lpCamera->dvDirection.z );
		D3DVECTOR up = CrossProduct( position, direction );

        viewMatrix = ViewMatrix( position,
		                         direction,
                                 up,
                                 lpCamera->bank );

		projectionMatrix = ProjectionMatrix( 0.01f, 
			                                 2000000.0f, 
											 (float)(lpCamera->lens*pi/180) );

		lpDev->SetTransform( D3DTRANSFORMSTATE_VIEW, &viewMatrix );
		lpDev->SetTransform( D3DTRANSFORMSTATE_PROJECTION, &projectionMatrix );
    }
}

void SetCamera( LPDIRECT3DDEVICE2 lpDev, LPCAMERA lpCamera, char *lpszName )
{
	LPCAMERA camera = FindCamera( lpCamera, lpszName );
	if ( camera )
	{
		D3DVECTOR position( lpCamera->dvPosition.x, lpCamera->dvPosition.y, lpCamera->dvPosition.z );
		D3DVECTOR direction( lpCamera->dvDirection.x, lpCamera->dvDirection.y, lpCamera->dvDirection.z );
		D3DVECTOR up = CrossProduct( position, direction );

        viewMatrix = ViewMatrix( position,
		                         direction,
                                 up,
                                 lpCamera->bank );

		projectionMatrix = ProjectionMatrix( 0.01f, 
			                                 2000000.0f, 
											 (float)(camera->lens*pi/180) );

		lpDev->SetTransform( D3DTRANSFORMSTATE_VIEW, &viewMatrix );
		lpDev->SetTransform( D3DTRANSFORMSTATE_PROJECTION, &projectionMatrix );
    }
}

