#ifndef __Camera_H__
#define __Camera_H__

#include "D3DIM.H"

typedef struct _CAMERA {
	VECTOR		dvPosition;       	// Position in world space 
	VECTOR		dvDirection;    	// Direction in world space 

    float		bank;				// Camera bank ( rotation angle )
    float		lens;				// Camera lens

	float		nearPlane;			// Camera near plane
	float		farPlane;			// Camera far plane

	char    	szName[100];
	_CAMERA     *lpNext;
} CAMERA, *LPCAMERA;


// Camera List
///////////////////////////////////////////////////////////////////////////////
LPCAMERA FindCamera( LPCAMERA lpCamera, char* lpszName );

LPCAMERA CreateCamera( char* lpszName );
LPCAMERA CreateCamera( LPCAMERA lpCamera, char* lpszName );

void DestroyCamera( LPCAMERA lpCamera );

void AddCamera( LPCAMERA lpCamera, LPCAMERA lpChildCamera );


// Direct3D Camera Func
///////////////////////////////////////////////////////////////////////////////
void SetCamera( LPDIRECT3DDEVICE2 lpDev, LPCAMERA lpCamera );
void SetCamera( LPDIRECT3DDEVICE2 lpDev, LPCAMERA lpCamera, char *lpszName );

#endif
