#include "Texture.H"

#pragma pack(1)
struct CELHEADER {
    WORD        ID;                 // 1991h
    WORD        Width, Height;
    DWORD       Unknown;
    WORD        BitsPerPixel;
    DWORD       dwSize;
    BYTE        Reserved[16];
};
#pragma pack()


LPIMAGE LoadCEL( char *lpszFileName )
{
    // Open CEL File
    FILE *fp = fopen( lpszFileName, "rb" );
	if ( !fp )
		return NULL;

    CELHEADER Header;
    fread( &Header, sizeof(CELHEADER), 1, fp );
    if ( Header.ID != 0x9119 )
    {
        fclose( fp );
        return NULL;
    }


	int i;
    LPIMAGE lpImage = CreateImage( Header.Width, Header.Height, Header.BitsPerPixel );
    if ( !lpImage )
        goto __error;

    // Read 256 Color Palette Entry
    for ( i=0; i<256; i++ )
    {
        lpImage->rgbEntry[i].Red   = (BYTE)fgetc( fp );
        lpImage->rgbEntry[i].Green = (BYTE)fgetc( fp );
        lpImage->rgbEntry[i].Blue  = (BYTE)fgetc( fp );
    }

    fread( lpImage->lpData, Header.dwSize, 1, fp );
    fclose( fp );

    return lpImage;

__error:
    fclose( fp );

    if ( lpImage )
    {
        if ( lpImage->lpData )
            delete [] lpImage->lpData;

        delete [] lpImage;
    }

    return NULL;
}
