/******************************************************************************
* D3D.CPP
* ( Direct 3D  ʱȭ )
******************************************************************************/

#include "D3DIM.H"

#include "Matrix.H"

/***************************************
*  
***************************************/

D3DRECT                 d3dRect;
LPDEVICEDESC            lpD3DDeviceDesc = NULL;

// DirectDraw
LPDIRECTDRAW2           lpDD2        = NULL;
LPDIRECTDRAWSURFACE     lpDDSPrimary = NULL;
LPDIRECTDRAWSURFACE     lpDDSBack    = NULL;

// Direct3D
LPDIRECT3D2             lpD3D2          = NULL;
LPDIRECT3DDEVICE2       lpD3DDevice2    = NULL;
LPDIRECT3DVIEWPORT2     lpD3DViewport2  = NULL;
LPDIRECTDRAWSURFACE     lpDDSZBuffer    = NULL;

// Camera Matrix
D3DMATRIX	worldMatrix;
D3DMATRIX	viewMatrix;
D3DMATRIX	projectionMatrix;


static LPDEVICEDESC lpDeviceDesc = NULL;


/***************************************
* Direct3D  ʱȭ ϱ
***************************************/


// Face Material Group List
///////////////////////////////////////////////////////////////////////////////

LPDEVICEDESC FindDevice( LPDEVICEDESC lpDesc, LPGUID lpGuid )
{
	LPDEVICEDESC desc = lpDesc;

	while ( desc )
	{
		if ( !memcmp( lpGuid, &desc->guid, sizeof(GUID) ) )
			break;

		desc = desc->lpNext;
	}

	return desc;
}

LPDEVICEDESC FindBestDevice( LPDEVICEDESC lpDesc )
{
	LPDEVICEDESC desc;

	desc = FindDevice( lpDesc, (LPGUID)&IID_IDirect3DHALDevice );
	if ( !desc )
		desc = FindDevice( lpDesc, (LPGUID)&IID_IDirect3DMMXDevice );

	if ( !desc )
		desc = FindDevice( lpDesc, (LPGUID)&IID_IDirect3DRGBDevice );

	//desc = FindDevice( lpDesc, (LPGUID)&IID_IDirect3DMMXDevice );

	return desc;
}

LPDEVICEDESC CreateDevice()
{
    LPDEVICEDESC desc = new DEVICEDESC;
    if ( !desc )
		return NULL;

    ZeroMemory( desc, sizeof(DEVICEDESC) );

    return desc;
}

LPDEVICEDESC CreateDevice( LPDEVICEDESC lpDesc )
{
    if ( !lpDesc )
        return CreateDevice();

    LPDEVICEDESC desc = new DEVICEDESC;
    if ( !desc )
        return NULL;

	ZeroMemory( desc, sizeof(DEVICEDESC) );

    LPDEVICEDESC lastDesc = lpDesc;
    while ( lastDesc->lpNext )
        lastDesc = lastDesc->lpNext;

    lastDesc->lpNext = desc;

    return desc;
}

void DestroyDevice( LPDEVICEDESC lpDesc )
{
    LPDEVICEDESC desc;

    while ( lpDesc->lpNext )
	{
        desc = lpDesc->lpNext;
        lpDesc->lpNext = lpDesc->lpNext->lpNext;

        delete [] desc;
	}

    delete [] lpDesc;
}


static DWORD FlagsToBitDepth( DWORD dwFlags )
{
    if ( dwFlags & DDBD_1 )
        return 1L;
    else if ( dwFlags & DDBD_2 )
        return 2L;
    else if ( dwFlags & DDBD_4 )
        return 4L;
    else if ( dwFlags & DDBD_8 )
        return 8L;
    else if ( dwFlags & DDBD_16 )
        return 16L;
    else if ( dwFlags & DDBD_24 )
        return 24L;
    else if ( dwFlags & DDBD_32 )
        return 32L;
    else
        return 0L; 
}


// Direct3D Device EnumCallback Լ
HRESULT WINAPI DeviceEnumCallback( LPGUID          lpGuid,
                                   LPSTR           lpDeviceDescription,
                                   LPSTR           lpDeviceName,
                                   LPD3DDEVICEDESC lpD3DHWDeviceDesc,
                                   LPD3DDEVICEDESC lpD3DHELDeviceDesc,
                                   LPVOID          lpUserArg )
{
    if ( !lpUserArg )
        return DDENUMRET_OK;


    // Direct3D Device Ʈ ߰
	LPDEVICEDESC desc, *lpDesc = (LPDEVICEDESC *)lpUserArg;
    if ( !*lpDesc )
		desc = *lpDesc = CreateDevice();
	else
		desc = CreateDevice( *lpDesc );

	// Guid 
	memcpy( &desc->guid, lpGuid, sizeof(GUID) );

	// ̽  
	strcpy( desc->szName, lpDeviceName );
	strcpy( desc->szDesc, lpDeviceDescription );


	// ϵ ̺  ˻ ϰ ̺  
	if ( lpD3DHWDeviceDesc->dcmColorModel )
	{
		desc->bIsHardware = TRUE;
		memcpy( &desc->Desc, lpD3DHWDeviceDesc, sizeof(D3DDEVICEDESC) );
	}
	else
	{
		desc->bIsHardware = FALSE;
		memcpy( &desc->Desc, lpD3DHELDeviceDesc, sizeof(D3DDEVICEDESC) );
	}

    return DDENUMRET_OK;
}


// Direct3D 
BOOL CreateD3D()
{
    // DirectDraw ̽ 
    LPDIRECTDRAW lpdd;

    //  DirectDraw Device
    HRESULT hresult = DirectDrawCreate( NULL, &lpdd, NULL );
    if ( hresult != DD_OK )
	{
		MESSAGE( "DirectDrawCreate" );
        return FALSE;
	}

    // DirectDraw2 ̽ 
    hresult = lpdd->QueryInterface( IID_IDirectDraw2, (LPVOID*)&lpDD2 );
    if ( hresult != DD_OK )
	{
		MESSAGE( "lpdd->QueryInterface" );
        return FALSE;
	}

    // DirectDraw ̽ 
    lpdd->Release();


    // Direct3D ̽ 
    hresult = lpDD2->QueryInterface( IID_IDirect3D2, (LPVOID*)&lpD3D2 );
    if ( hresult != DD_OK )
	{
		MESSAGE( "lpDD2->QueryInterface" );
        return FALSE;
	}

    // Direct3D Device ̽ 
	hresult = lpD3D2->EnumDevices( DeviceEnumCallback, (LPVOID)&lpDeviceDesc );
    if ( hresult != DD_OK )
	{
		MESSAGE( "lpD3D2->EnumDevices" );
        return FALSE;
	}

	lpD3DDeviceDesc = FindBestDevice( lpDeviceDesc );
	if ( !lpD3DDeviceDesc )
		return FALSE;

    return TRUE;
}

// Direct3D 
void ReleaseD3D()
{
    // Viewport 
    if ( lpD3DViewport2 )
    {
        // Direct3D Device  Viewport 
        lpD3DDevice2->DeleteViewport( lpD3DViewport2 );
		
        lpD3DViewport2->Release();
        lpD3DViewport2 = NULL;
    }

    // Direct3D Device 
    if ( lpD3DDevice2 )
    {
        lpD3DDevice2->Release();
        lpD3DDevice2 = NULL;
    }


    // Z-Buffer Surface 
    if ( lpDDSZBuffer )
    {
        // Back Surface  Z-Buffer Surface 
        if ( lpDDSBack )
            lpDDSBack->DeleteAttachedSurface( 0L, lpDDSZBuffer );

        lpDDSZBuffer->Release();
        lpDDSZBuffer = NULL;
    }

    // Direct3D Interface 
    if ( lpD3D2 )
    {
        lpD3D2->Release();
        lpD3D2 = NULL;
    }

    // Primary Surface 
    if ( lpDDSPrimary )
    {
        lpDDSPrimary->Release();
        lpDDSPrimary = NULL;
    }

    // DirectDraw2 Interface 
    if ( lpDD2 )
    {
        //   
        lpDD2->RestoreDisplayMode();

        lpDD2->Release();
        lpDD2 = NULL;
    }
}


//   ȯ
BOOL SetDisplayMode( HWND hWnd, DWORD Width, DWORD Height, DWORD BPP )
{
    // Set Cooperative Level
    HRESULT hresult = lpDD2->SetCooperativeLevel( hWnd,
                                                  DDSCL_EXCLUSIVE |
                                                  DDSCL_FULLSCREEN );
    if ( hresult != DD_OK )
	{
		MESSAGE( "lpDD2->SetCooperativeLevel" );
        return FALSE;
	}


    // Ǯȭ  ȯ
    hresult = lpDD2->SetDisplayMode( Width, Height, BPP, 0, 0 );
    if ( hresult != DD_OK )
	{
		MESSAGE( "lpDD2->SetDisplayMode" );
        return FALSE;
	}


    // Primary Surface 
    DDSURFACEDESC ddsd;
    ZeroMemory( &ddsd, sizeof(DDSURFACEDESC) );

    ddsd.dwSize             = sizeof(ddsd);
    ddsd.dwBackBufferCount  = 1;
    ddsd.dwFlags            = DDSD_CAPS |
                              DDSD_BACKBUFFERCOUNT;
    ddsd.ddsCaps.dwCaps     = DDSCAPS_PRIMARYSURFACE |
                              DDSCAPS_FLIP |
                              DDSCAPS_COMPLEX |
                              DDSCAPS_VIDEOMEMORY |
                              DDSCAPS_3DDEVICE;

    // Primary surface 
    hresult = lpDD2->CreateSurface( &ddsd, &lpDDSPrimary, NULL );
    if ( hresult != DD_OK )
	{
		MESSAGE( "lpDD2->CreateSurface(lpDDSPrimary)" );
        return FALSE;
	}

    // Back Surface (?)
    DDSCAPS ddscaps;
    ddscaps.dwCaps = DDSCAPS_BACKBUFFER;
    hresult = lpDDSPrimary->GetAttachedSurface( &ddscaps, &lpDDSBack );
    if ( hresult != DD_OK )
	{
		MESSAGE( "lpDDSPrimary->GetAttachedSurface" );
        return FALSE;
	}


    // z-buffer Surface 
    ZeroMemory( &ddsd, sizeof(ddsd) );
    ddsd.dwSize            = sizeof(ddsd);
    ddsd.dwFlags           = DDSD_CAPS |
                             DDSD_WIDTH |
                             DDSD_HEIGHT |
                             DDSD_ZBUFFERBITDEPTH;
    ddsd.dwWidth           = Width;
    ddsd.dwHeight          = Height;
    ddsd.dwZBufferBitDepth = FlagsToBitDepth( lpD3DDeviceDesc->Desc.dwDeviceZBufferBitDepth );


    // ϵ ̸ z-buffer  ޸𸮿 .
    if ( lpD3DDeviceDesc->bIsHardware )
        ddsd.ddsCaps.dwCaps = DDSCAPS_ZBUFFER | DDSCAPS_VIDEOMEMORY;
    else
        ddsd.ddsCaps.dwCaps = DDSCAPS_ZBUFFER | DDSCAPS_SYSTEMMEMORY;

    // Create the ZBuffer surface.
    hresult = lpDD2->CreateSurface( &ddsd, &lpDDSZBuffer, NULL );
    if ( hresult != DD_OK )
	{
		MESSAGE( "lpDD2->CreateSurface(lpDDSZBuffer)" );
        return FALSE;
	}

    // Back Surface Z-buffer δ.
    hresult = lpDDSBack->AddAttachedSurface( lpDDSZBuffer );
    if ( hresult != DD_OK )
	{
		MESSAGE( "lpDDSBack->AddAttachedSurface" );
        return FALSE;
	}

    // Direct3D Device 
    hresult = lpD3D2->CreateDevice( lpD3DDeviceDesc->guid,
                                    lpDDSBack,
                                    &lpD3DDevice2 );
    if ( hresult != D3D_OK )
	{
		MESSAGE( "lpD3D2->CreateDevice" );
        return FALSE;
	}

    // Viewport ũ 
    d3dRect.x1 = 0;
    d3dRect.y1 = 0;
    d3dRect.x2 = Width;
    d3dRect.y2 = Height;

    return TRUE;
}

// Back Surface  DC
HDC GetDC()
{
    HDC hDC;

    if ( lpDDSBack->GetDC( &hDC ) != DD_OK )
        return NULL;

    return hDC;
}

// DC 
void ReleaseDC( HDC hDC )
{
    lpDDSBack->ReleaseDC( hDC );
}

// Primary Surface Lost ˻
void IsLost()
{
    if ( lpDDSPrimary->IsLost() == DDERR_SURFACELOST )
        lpDDSPrimary->Restore();
}

//  ø
void Flip()
{
    HRESULT hresult = lpDDSPrimary->Flip( NULL, DDFLIP_WAIT );
    if ( hresult == DDERR_SURFACELOST )
        lpDDSPrimary->Restore();
}

// Viewport 
BOOL CreateViewport()
{
    // Viewport 
    HRESULT hresult = lpD3D2->CreateViewport( &lpD3DViewport2, NULL );
    if ( hresult != D3D_OK )
        return FALSE;

    // Direct3D Device  Viewport ߰
    hresult = lpD3DDevice2->AddViewport( lpD3DViewport2 );
    if ( hresult != D3D_OK )
        return FALSE;


    D3DVIEWPORT2 viewport;
    ZeroMemory( &viewport, sizeof(D3DVIEWPORT2) );

    viewport.dwSize         = sizeof(D3DVIEWPORT2);
    viewport.dwX            = 0;
    viewport.dwY            = 0;
    viewport.dwWidth        = d3dRect.x2;
    viewport.dwHeight       = d3dRect.y2;
    viewport.dvClipWidth    = 2.0f;
    viewport.dvClipHeight   = (D3DVALUE)(d3dRect.y2 * 2.0 / d3dRect.x2);
    viewport.dvClipX        = -1.0f;
    viewport.dvClipY        = viewport.dvClipHeight / 2.0f;
    viewport.dvMinZ         = 0.0f;
    viewport.dvMaxZ         = 1.0f;

    // lpD3DViewport2 
    hresult = lpD3DViewport2->SetViewport2( &viewport );
    if ( hresult != D3D_OK )
        return FALSE;

    //  Viewport lpD3DViewport2 
    hresult = lpD3DDevice2->SetCurrentViewport( lpD3DViewport2 );
    if ( hresult != D3D_OK )
        return FALSE;

    return TRUE;
}

// Back Surface 
void Clear( DWORD dwColor )
{
    DDBLTFX bltFx;
    ZeroMemory( &bltFx, sizeof(DDBLTFX) );

    bltFx.dwSize        = sizeof(DDBLTFX);
    bltFx.dwFillColor   = dwColor;

    lpDDSBack->Blt( NULL, NULL, NULL, DDBLT_WAIT | DDBLT_COLORFILL, &bltFx );
}

// 帵 ʱȭ
void InitRender()
{
    // Turn off specular highlights
    lpD3DDevice2->SetRenderState( D3DRENDERSTATE_SPECULARENABLE, FALSE );

    // Turn on Z-buffering
	lpD3DDevice2->SetRenderState( D3DRENDERSTATE_ZENABLE, TRUE );
	lpD3DDevice2->SetRenderState( D3DRENDERSTATE_ZWRITEENABLE, TRUE );

    // null out the texture handle
    lpD3DDevice2->SetRenderState( D3DRENDERSTATE_TEXTUREHANDLE, 0 );

    // turn on dithering
    lpD3DDevice2->SetRenderState( D3DRENDERSTATE_DITHERENABLE, TRUE );

	// make sure the texture wraps correctly
	lpD3DDevice2->SetRenderState( D3DRENDERSTATE_WRAPU, TRUE );
	lpD3DDevice2->SetRenderState( D3DRENDERSTATE_WRAPV, TRUE );

	lpD3DDevice2->SetRenderState( D3DRENDERSTATE_TEXTUREADDRESS, D3DTADDRESS_WRAP );
	lpD3DDevice2->SetRenderState( D3DRENDERSTATE_TEXTUREPERSPECTIVE, TRUE ); 

	// D3DFILTER_LINEAR
	// D3DFILTER_NEAREST
	lpD3DDevice2->SetRenderState( D3DRENDERSTATE_TEXTUREMAG, D3DFILTER_LINEAR );
	lpD3DDevice2->SetRenderState( D3DRENDERSTATE_TEXTUREMIN, D3DFILTER_LINEAR );

	// ̵  
    //lpD3DDevice2->SetRenderState( D3DRENDERSTATE_SHADEMODE, D3DSHADE_FLAT );
	//lpD3DDevice2->SetRenderState( D3DRENDERSTATE_SHADEMODE, D3DSHADE_PHONG );

    // turn on some ambient light
    lpD3DDevice2->SetLightState( D3DLIGHTSTATE_AMBIENT, RGBA_MAKE(255, 255, 255, 255) );


	worldMatrix      = IdentityMatrix();
	viewMatrix       = ViewMatrix( D3DVECTOR(0,0,-50), D3DVECTOR(0,0,1), D3DVECTOR(0,1,0), 0 );
	projectionMatrix = ProjectionMatrix( 0.01f, 2000000.0f, (float)(61.75*pi/180) );

	lpD3DDevice2->SetTransform( D3DTRANSFORMSTATE_WORLD, &worldMatrix );
	lpD3DDevice2->SetTransform( D3DTRANSFORMSTATE_VIEW, &viewMatrix );
	lpD3DDevice2->SetTransform( D3DTRANSFORMSTATE_PROJECTION, &projectionMatrix );
}


// 帵 
void BeginRender()
{
    // Primary Surface LostǾ ˻
    if ( lpDDSPrimary->IsLost() == DDERR_SURFACELOST )
        lpDDSPrimary->Restore();

    // Back Surface 
    DDBLTFX bltFx;
    ZeroMemory( &bltFx, sizeof(DDBLTFX) );

    bltFx.dwSize        = sizeof(DDBLTFX);
    bltFx.dwFillColor   = 0;
    lpDDSBack->Blt( NULL, NULL, NULL, DDBLT_WAIT | DDBLT_COLORFILL, &bltFx );

    // Viewport 
    lpD3DViewport2->Clear( 1UL, &d3dRect, D3DCLEAR_TARGET | D3DCLEAR_ZBUFFER );

    lpD3DDevice2->BeginScene();
}

// 帵 
void EndRender()
{
    lpD3DDevice2->EndScene();
}




HWND hMainWnd;
BOOL bIsActive = TRUE;

// Message output for error notification.
void __cdecl MESSAGE( LPSTR fmt, ... )
{
    char buff[256];
    va_list args;
    
    va_start( args, fmt );
    wvsprintf( buff, fmt, args );
    va_end( args );
    
    lstrcat( buff, "\r\n" );

    MessageBox( hMainWnd, buff, "ERROR", MB_OK );
}

long PASCAL WindowProc( HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam )
{
    switch ( message )
    {
        case WM_ACTIVATEAPP:
            bIsActive = wParam;
            break;

        case WM_CREATE:
            break;

        // Ŀ ߱
        case WM_SETCURSOR:
            SetCursor( NULL );
            return TRUE;

        case WM_KEYDOWN:
            switch ( wParam )
            {
                // ESC Ű  
                case VK_ESCAPE:
                    PostMessage( hWnd, WM_CLOSE, 0, 0 );
                    break;
            }
            break;

        case WM_DESTROY:
            PostQuitMessage( 0 );
            break;
    }

    return DefWindowProc( hWnd, message, wParam, lParam );
}

// Direct3D,  
BOOL Create3DWindow( HINSTANCE hInstance, int nCmdShow )
{
    //  
    WNDCLASS wc;

    wc.style            = CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc      = WindowProc;
    wc.cbClsExtra       = 0;
    wc.cbWndExtra       = 0;
    wc.hInstance        = hInstance;
    wc.hIcon            = LoadIcon( hInstance, IDI_APPLICATION );
    wc.hCursor          = LoadCursor( NULL, IDC_ARROW );
    wc.hbrBackground    = NULL;
    wc.lpszMenuName     = NULL;
    wc.lpszClassName    = "D3DIM";
    if ( !RegisterClass( &wc ) )
        return FALSE;


    //  
    hMainWnd = CreateWindowEx( WS_EX_TOPMOST,
                               "D3DIM",
                               "Direct3D Immediate-Mode Example",
                               WS_POPUP,
                               0,
                               0,
                               GetSystemMetrics(SM_CXSCREEN),
                               GetSystemMetrics(SM_CYSCREEN),
                               NULL,
                               NULL,
                               hInstance,
                               NULL );
    if ( !hMainWnd )
        return FALSE;

    ShowWindow( hMainWnd, nCmdShow );
    UpdateWindow( hMainWnd );


    // Direct3D 
    if ( !CreateD3D() )
        return FALSE;


    //  带 640x480 16Ʈ  
    if ( !SetDisplayMode( hMainWnd, 640, 480, 16 ) )
        return FALSE;

    // Viewport 
    if ( !CreateViewport() )
        return FALSE;

    //  ʱȭ
    InitRender();

    return TRUE;
}

// ̷Ʈ 3D,  
void Destroy3DWindow()
{
	if ( lpDeviceDesc )
		DestroyDevice( lpDeviceDesc );

    ReleaseD3D();
}

