/******************************************************************************
* D3DIM.H
* ( Direct 3D  ʱȭ )
******************************************************************************/

#ifndef __D3DIM_H__
#define __D3DIM_H__

#include <math.h>

#include "TypeDEF.H"

#pragma warning (disable : 4244)
#define D3D_OVERLOADS
#include <d3d.h>


/***************************************
* Direct3D ʱȭ ü
***************************************/

// Direct3D Device 
//  ̿Ͽ IDirect3DDevice2 մϴ.
typedef struct _DEVICEDESC
{
    // Device Info
    GUID  guid;                 // GUID
    char  szName[256];          // ̸
    char  szDesc[256];          // 
    BOOL  bIsHardware;          // ϵ ̺ ΰ?

    // Device Caps
    D3DDEVICEDESC   Desc;
	_DEVICEDESC		*lpNext;
} DEVICEDESC, *LPDEVICEDESC;


/***************************************
*  
***************************************/

extern D3DRECT                 d3dRect;
extern LPDEVICEDESC            lpD3DDeviceDesc;

extern LPDIRECTDRAW2           lpDD2;
extern LPDIRECTDRAWSURFACE     lpDDSPrimary;
extern LPDIRECTDRAWSURFACE     lpDDSBack;

extern LPDIRECT3D2             lpD3D2;
extern LPDIRECT3DDEVICE2       lpD3DDevice2;
extern LPDIRECT3DVIEWPORT2     lpD3DViewport2;
extern LPDIRECTDRAWSURFACE     lpDDSZBuffer;

// Camera Matrix
extern D3DMATRIX	worldMatrix;
extern D3DMATRIX	viewMatrix;
extern D3DMATRIX	projectionMatrix;


/***************************************
* Direct3D  ʱȭ ϱ
***************************************/


// Direct3D 
BOOL CreateD3D();

// Direct3D 
void ReleaseD3D();


//   ȯ
BOOL SetDisplayMode( HWND hWnd, DWORD Width, DWORD Height, DWORD BPP );

// Back Surface  DC
HDC GetDC();

// DC 
void ReleaseDC( HDC hDC );



// Primary Surface Lost ˻
void IsLost();

//  ø
void Flip();

// Viewport 
BOOL CreateViewport();

// Back Surface 
void Clear( DWORD dwColor );


// 帵 ʱȭ
void InitRender();

// 帵 
void BeginRender();

// 帵 
void EndRender();



extern HWND hMainWnd;
extern BOOL bIsActive;



void __cdecl MESSAGE( LPSTR fmt, ... );

// Direct3D,  
BOOL Create3DWindow( HINSTANCE hInstance, int nCmdShow );

// ̷Ʈ 3D,  
void Destroy3DWindow();




typedef struct {
	float r, g, b, a;
} COLORVALUE, *LPCOLORVALUE;

typedef struct {
	float	x, y, z;
} VECTOR, *LPVECTOR;

typedef struct {
    float   tu, tv;
} TVERTEX, *LPTVERTEX;


#pragma comment( lib, "ddraw.lib" )
#pragma comment( lib, "dxguid.lib" )

#endif
