#include "D3DIM.H"

#include "Mesh.H"
//#include "Model.H"

HFONT hFont;
DWORD timeTaken;
DWORD beginTime, endTime;

LPMESH lpMesh;
//LPMODEL lpModel;


float rot_x1 = 0.0f, rot_x2 = 0.0f;
float rot_y1 = 0.0f, rot_y2 = 0.0f;
int frame = 0;
DWORD tick = 0;

void Render()
{
    if ( isKeyDOWN( VK_UP ) )
	    rot_x1-= 0.5f;
    if ( isKeyDOWN( VK_DOWN ) )
	    rot_x1 += 0.5f;
    if ( isKeyDOWN( VK_LEFT ) )
	    rot_y1 -= 0.5f;
    if ( isKeyDOWN( VK_RIGHT ) )
	    rot_y1 += 0.5f;

    if ( isKeyDOWN( VK_NUMPAD8 ) )
	    rot_x2-= 0.5f;
    if ( isKeyDOWN( VK_NUMPAD2 ) )
	    rot_x2 += 0.5f;
    if ( isKeyDOWN( VK_NUMPAD4 ) )
	    rot_y2 -= 0.5f;
    if ( isKeyDOWN( VK_NUMPAD6 ) )
	    rot_y2 += 0.5f;


	lpMesh->Matrix = MatrixMult( RotateXMatrix( rot_x2 ), RotateZMatrix( rot_y2 ) );

	//lpModel->Matrix = MatrixMult( RotateYMatrix( rot_y1 ), RotateXMatrix( rot_x1 ) );

	// grab timestamp
	beginTime = timeGetTime();

    BeginRender();

	RenderMesh( lpD3DDevice2, lpMesh );
	//RenderModel( lpD3DDevice2, lpModel, frame );

    EndRender();

	// grab another timestamp
	endTime = timeGetTime();
	timeTaken = endTime - beginTime;

/*
	tick+=timeTaken;
	if ( tick>100 )
	{
		tick = 0;
		frame = (frame+1)%lpModel->NumFrames;
	}
*/

    // draw throughput stats
    HDC hDC = GetDC();

    SetBkMode( hDC, TRANSPARENT );
    SelectObject( hDC, hFont );

    char stats[128];
    int len = wsprintf( stats, "%s ( %d ms )", lpD3DDeviceDesc->szName, timeTaken );

    SetTextColor( hDC, RGB(255, 255, 255) );
    TextOut( hDC, 0, 0, stats, len );

    ReleaseDC( hDC );

    Flip();
}


BOOL Create( HINSTANCE hInstance, int nCmdShow )
{
	lpMesh = Load3DS( "SAMPLE.3DS" );
	if ( !lpMesh )
	{
		MESSAGE( "Load3DS" );
		return FALSE;
	}

/*	lpModel = LoadBIN( "SAMPLE.BIN", "PALETTE.LMP" );
	if ( !lpModel )
	{
		MESSAGE( "LoadBIN" );
		return FALSE;
	}
*/
	if ( !Create3DWindow( hInstance, nCmdShow ) )
	{
		MESSAGE( "Create3DWindow" );
		return FALSE;
	}

/*	if ( SetupModel( lpDD2, lpD3D2, lpD3DDevice2, lpModel ) != D3D_OK )
		return FALSE;
*/
	if ( SetupMesh( lpDD2, lpD3D2, lpD3DDevice2, lpD3DViewport2, lpMesh ) != D3D_OK )
		return FALSE;

	DebugMesh( lpMesh );

	hFont = CreateFont( 24,
                        0,
                        0,
                        0,
						FW_NORMAL,
                        FALSE,
                        FALSE,
                        FALSE,
                        ANSI_CHARSET,
                        OUT_DEFAULT_PRECIS,
                        CLIP_DEFAULT_PRECIS,
                        NONANTIALIASED_QUALITY,
                        VARIABLE_PITCH,
                        "Comic Sans MS" );

	return TRUE;
}

void Destroy()
{
/*	if ( lpModel )
		DestroyModel( lpModel );
*/
	if ( lpMesh )
		DestroyMesh( lpD3DViewport2, lpMesh );

	if ( hFont )
		DeleteObject( hFont );

	Destroy3DWindow();
}



int PASCAL WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow )
{
	if ( !Create( hInstance, nCmdShow ) ) 
		goto __error;


	MSG msg;

	while ( 1 )
	{
		if ( PeekMessage( &msg, NULL, 0, 0, PM_NOREMOVE ) )
		{
			if ( !GetMessage( &msg, NULL, 0, 0 ) ) 
				break;

			TranslateMessage( &msg ); 
			DispatchMessage( &msg );
		}
		else if ( bIsActive )
		{
			Render();
		}
		else 
			WaitMessage();
	}

__error:
	Destroy();

	return msg.wParam;
}

