#include "Light.H"


// Light List
///////////////////////////////////////////////////////////////////////////////

LPLIGHT FindLight( LPLIGHT lpLight, char* lpszName )
{
	LPLIGHT light = lpLight;

	while ( light )
	{
		if ( !strcmp( lpszName, light->szName ) )
			break;

		light = light->lpNext;
	}

	return light;
}

LPLIGHT CreateLight( char* lpszName )
{
	LPLIGHT light = new LIGHT;
	if ( !light )
		return NULL;

	ZeroMemory( light, sizeof(LIGHT) );
	strcpy( light->szName, lpszName );


	light->Light.dwSize = sizeof(D3DLIGHT2);

    // default to light source
    light->Light.dltType = D3DLIGHT_POINT;

    // default to no attenuation with distance
	light->Light.dvAttenuation0 = 1.0f;
	light->Light.dvAttenuation1 = 0.0f;
	light->Light.dvAttenuation2 = 0.0f;

	// default to no max distance
	light->Light.dvRange = D3DLIGHT_RANGE_MAX;

	// default to linear ramp from inner to outer cone
	light->Light.dvFalloff = 1.0f;

	// default to on
	light->Light.dwFlags = D3DLIGHT_ACTIVE;

	return light;
}

LPLIGHT CreateLight( LPLIGHT lpLight, char* lpszName )
{
	if ( !lpLight )
		return CreateLight( lpszName );

	LPLIGHT light = FindLight( lpLight, lpszName );
	if ( !light )
	{
		light = new LIGHT;
		if ( !light )
			return NULL;

		ZeroMemory( light, sizeof(LIGHT) );
		strcpy( light->szName, lpszName );

	
		light->Light.dwSize = sizeof(D3DLIGHT2);

        // default to light source
        light->Light.dltType = D3DLIGHT_POINT;

		// default to no attenuation with distance
		light->Light.dvAttenuation0 = 1.0f;
		light->Light.dvAttenuation1 = 0.0f;
		light->Light.dvAttenuation2 = 0.0f;

		// default to no max distance
		light->Light.dvRange = D3DLIGHT_RANGE_MAX;

		// default to linear ramp from inner to outer cone
		light->Light.dvFalloff = 1.0f;

		// default to on
		light->Light.dwFlags = D3DLIGHT_ACTIVE;

		LPLIGHT lastLight = lpLight;
		while ( lastLight->lpNext )
			lastLight = lastLight->lpNext;

		lastLight->lpNext = light;
	}

	return light;
}

void DestroyLight( LPLIGHT lpLight )
{
	LPLIGHT light;

	while ( lpLight->lpNext )
	{
		light = lpLight->lpNext;
		lpLight->lpNext = lpLight->lpNext->lpNext;

		if ( light->lpD3DLight )
		{
			light->lpD3DLight->Release();
			light->lpD3DLight = NULL;
		}

		delete [] light;
	}

	delete [] lpLight;
}

void AddLight( LPLIGHT lpLight, LPLIGHT lpChildLight )
{
	LPLIGHT light = FindLight( lpLight, lpChildLight->szName );
	if ( !light )
	{
		light = lpLight;
		while ( light->lpNext )
			light = light->lpNext;

		light->lpNext = lpChildLight;
	}
}


// Direct3D Func
///////////////////////////////////////////////////////////////////////////////
HRESULT SetLight( LPLIGHT lpLight )
{
    return lpLight->lpD3DLight->SetLight( (LPD3DLIGHT)&lpLight->Light );
}

HRESULT AddToViewport( LPDIRECT3DVIEWPORT2 lpViewport, LPLIGHT lpLight )
{
	return lpViewport->AddLight( lpLight->lpD3DLight );
}

HRESULT RemoveFromViewport( LPDIRECT3DVIEWPORT2 lpViewport, LPLIGHT lpLight )
{
	return lpViewport->DeleteLight( lpLight->lpD3DLight );
}


HRESULT SetupLight( LPDIRECT3D2 lpD3D, LPDIRECT3DVIEWPORT2 lpViewport, LPLIGHT lpLight )
{
	LPLIGHT light = lpLight;

	HRESULT hresult;
	while ( light )
	{
		hresult = lpD3D->CreateLight( &light->lpD3DLight, NULL );
		if ( hresult != D3D_OK )
		{
			MESSAGE( "lpD3D->CreateLight(%s)", light->szName );
			return hresult;
		}

		hresult = light->lpD3DLight->SetLight( (LPD3DLIGHT)&light->Light );
		if ( hresult != D3D_OK )
		{
			MESSAGE( "light->lpD3DLight->SetLight(%s)", light->szName );
			return hresult;
		}

		hresult = lpViewport->AddLight( light->lpD3DLight );
		if ( hresult != D3D_OK )
		{
			MESSAGE( "lpViewport->AddLight(%s)", light->szName );
			return hresult;
		}


		light = light->lpNext;
	}

	return D3D_OK;
}

HRESULT DeleteLight( LPDIRECT3DVIEWPORT2 lpViewport, LPLIGHT lpLight )
{
	LPLIGHT light = lpLight;

	HRESULT hresult;
	while ( light )
	{
		hresult = lpViewport->DeleteLight( light->lpD3DLight );
		if ( hresult != D3D_OK )
		{
			MESSAGE( "lpViewport->DeleteLight(%s)", light->szName );
			return hresult;
		}

		light = light->lpNext;
	}

	return D3D_OK;
}


// Etc Light
///////////////////////////////////////////////////////////////////////////////
void SetupPointLight( LPLIGHT lpLight,
					  const D3DVECTOR& color,
					  const D3DVECTOR& position )
{
	lpLight->Light.dltType = D3DLIGHT_POINT;

	lpLight->Light.dcvColor.r = color[0];
	lpLight->Light.dcvColor.g = color[1];
	lpLight->Light.dcvColor.b = color[2];

	lpLight->Light.dvPosition.x = position[0];
	lpLight->Light.dvPosition.y = position[1];
	lpLight->Light.dvPosition.z = position[2];
}

void SetupSpotLight( LPLIGHT lpLight,
                     const D3DVECTOR&   color,
                     const D3DVECTOR&   position,
                     const D3DVECTOR&   direction,
                     const float        umbra_angle,
                     const float        penumbra_angle )
{
	lpLight->Light.dltType = D3DLIGHT_SPOT;

	lpLight->Light.dcvColor.r = color[0];
	lpLight->Light.dcvColor.g = color[1];
	lpLight->Light.dcvColor.b = color[2];

	lpLight->Light.dvPosition.x = position[0];
	lpLight->Light.dvPosition.y = position[1];
	lpLight->Light.dvPosition.z = position[2];

	lpLight->Light.dvDirection.x = direction[0];
	lpLight->Light.dvDirection.y = direction[1];
	lpLight->Light.dvDirection.z = direction[2];

	lpLight->Light.dvTheta = umbra_angle;
	lpLight->Light.dvPhi   = penumbra_angle;
}

void SetupDirectionalLight( LPLIGHT lpLight,
                            const D3DVECTOR& color,
                            const D3DVECTOR& direction )
{
	lpLight->Light.dltType = D3DLIGHT_DIRECTIONAL;

	lpLight->Light.dcvColor.r = color[0];
	lpLight->Light.dcvColor.g = color[1];
	lpLight->Light.dcvColor.b = color[2];

	lpLight->Light.dvDirection.x = direction[0];
	lpLight->Light.dvDirection.y = direction[1];
	lpLight->Light.dvDirection.z = direction[2];
}

void SetupParallelPointLight( LPLIGHT lpLight,
                              const D3DVECTOR& color,
                              const D3DVECTOR& position )
{
	lpLight->Light.dltType = D3DLIGHT_PARALLELPOINT;

	lpLight->Light.dcvColor.r = color[0];
	lpLight->Light.dcvColor.g = color[1];
	lpLight->Light.dcvColor.b = color[2];

	lpLight->Light.dvPosition.x = position[0];
	lpLight->Light.dvPosition.y = position[1];
	lpLight->Light.dvPosition.z = position[2];
}
