#ifndef __Light_H__
#define __Light_H__

#include "D3DIM.H"

typedef struct _LIGHT {
	D3DLIGHT2		Light;
	LPDIRECT3DLIGHT lpD3DLight; // object pointer for the light

	char    		szName[100];
    _LIGHT          *lpNext;
} LIGHT, *LPLIGHT;



// Light List
///////////////////////////////////////////////////////////////////////////////

LPLIGHT FindLight( LPLIGHT lpLight, char* lpszName );

LPLIGHT CreateLight( char* lpszName );
LPLIGHT CreateLight( LPLIGHT lpLight, char* lpszName );

void DestroyLight( LPLIGHT lpLight );

void AddLight( LPLIGHT lpLight, LPLIGHT lpChildLight );


// Direct3D Func
///////////////////////////////////////////////////////////////////////////////
HRESULT SetLight( LPLIGHT lpLight );

HRESULT AddToViewport( LPDIRECT3DVIEWPORT2 lpViewport, LPLIGHT lpLight );
HRESULT RemoveFromViewport( LPDIRECT3DVIEWPORT2 lpViewport, LPLIGHT lpLight );

HRESULT SetupLight( LPDIRECT3D2 lpD3D, LPDIRECT3DVIEWPORT2 lpViewport, LPLIGHT lpLight );
HRESULT DeleteLight( LPDIRECT3DVIEWPORT2 lpViewport, LPLIGHT lpLight );


// Etc Light
///////////////////////////////////////////////////////////////////////////////
void SetupPointLight( LPLIGHT lpLight,
                      const D3DVECTOR& color,
                      const D3DVECTOR& position );

void SetupSpotLight( LPLIGHT lpLight,
                     const D3DVECTOR&   color,
                     const D3DVECTOR&   position,
                     const D3DVECTOR&   direction,
                     const float        umbra_angle,
                     const float        penumbra_angle );

void SetupDirectionalLight( LPLIGHT lpLight,
                            const D3DVECTOR& color,
                            const D3DVECTOR& direction );

void SetupParallelPointLight( LPLIGHT lpLight,
                              const D3DVECTOR& color,
                              const D3DVECTOR& position );

#endif
