#include "Material.H"

// Material List
///////////////////////////////////////////////////////////////////////////////
LPMATERIAL FindMaterial( LPMATERIAL lpMaterial, char* lpszName )
{
	LPMATERIAL material = lpMaterial;

	while ( material )
	{
		if ( !strcmp( lpszName, material->szName ) )
			break;

		material = material->lpNext;
	}

	return material;
}

LPMATERIAL CreateMaterial( char* lpszName )
{
	LPMATERIAL material = new MATERIAL;
	if ( !material )
		return NULL;

	ZeroMemory( material, sizeof(MATERIAL) );
	strcpy( material->szTextureName, "NOTEXTURE" );


	material->Material.dwSize = sizeof(D3DMATERIAL);

	// leave the default material black
	material->Material.dwRampSize = 16;

	//material->Material.dcvDiffuse.r = (D3DVALUE)0.7f;
	//material->Material.dcvDiffuse.g = (D3DVALUE)0.7f;
	//material->Material.dcvDiffuse.b = (D3DVALUE)0.7f;
	material->Material.dcvDiffuse.a = (D3DVALUE)1.0f;

	//material->Material.dcvAmbient.r = (D3DVALUE)0.1f;
	//material->Material.dcvAmbient.g = (D3DVALUE)0.1f;
	//material->Material.dcvAmbient.b = (D3DVALUE)0.1f;
	//material->Material.dcvAmbient.a = (D3DVALUE)1.0f;

	//material->Material.dcvSpecular.r = (D3DVALUE)0.1f;
	//material->Material.dcvSpecular.g = (D3DVALUE)0.1f;
	//material->Material.dcvSpecular.b = (D3DVALUE)0.1f;
	//material->Material.dcvSpecular.a = (D3DVALUE)1.0f;

	//material->Material.dvPower = (D3DVALUE)40.0;

	strcpy( material->szName, lpszName );

	return material;
}

LPMATERIAL CreateMaterial( LPMATERIAL lpMaterial, char* lpszName )
{
	if ( !lpMaterial )
		return CreateMaterial( lpszName );

	LPMATERIAL material = FindMaterial( lpMaterial, lpszName );
	if ( !material )
	{
		material = new MATERIAL;
		if ( !material )
			return NULL;

		ZeroMemory( material, sizeof(MATERIAL) );
		strcpy( material->szTextureName, "NOTEXTURE" );


		material->Material.dwSize = sizeof(D3DMATERIAL);

		// leave the default material black
		material->Material.dwRampSize = 16;

		material->Material.dcvDiffuse.r = (D3DVALUE)0.7f;
		material->Material.dcvDiffuse.g = (D3DVALUE)0.7f;
		material->Material.dcvDiffuse.b = (D3DVALUE)0.7f;
		material->Material.dcvDiffuse.a = (D3DVALUE)1.0f;

		material->Material.dcvAmbient.r = (D3DVALUE)0.1f;
		material->Material.dcvAmbient.g = (D3DVALUE)0.1f;
		material->Material.dcvAmbient.b = (D3DVALUE)0.1f;
		material->Material.dcvAmbient.a = (D3DVALUE)1.0f;

		material->Material.dcvSpecular.r = (D3DVALUE)0.1f;
		material->Material.dcvSpecular.g = (D3DVALUE)0.1f;
		material->Material.dcvSpecular.b = (D3DVALUE)0.1f;
		material->Material.dcvSpecular.a = (D3DVALUE)1.0f;

		material->Material.dvPower = (D3DVALUE)40.0;

		strcpy( material->szName, lpszName );


		LPMATERIAL lastMaterial = lpMaterial;
		while ( lastMaterial->lpNext )
			lastMaterial = lastMaterial->lpNext;

		lastMaterial->lpNext = material;
	}

	return material;
}

void DestroyMaterial( LPMATERIAL lpMaterial )
{
	LPMATERIAL material;

	while ( lpMaterial->lpNext )
	{
		material = lpMaterial->lpNext;
		lpMaterial->lpNext = lpMaterial->lpNext->lpNext;

		if ( material->lpD3DMaterial )
		{
			material->lpD3DMaterial->Release();
			material->lpD3DMaterial = NULL;
		}

		delete [] material;
	}

	delete [] lpMaterial;
}

void AddMaterial( LPMATERIAL lpMaterial, LPMATERIAL lpChildMaterial )
{
	LPMATERIAL material = FindMaterial( lpMaterial, lpChildMaterial->szName );
	if ( !material )
	{
		material = lpMaterial;
		while ( material->lpNext )
			material = material->lpNext;

		material->lpNext = lpChildMaterial;
	}
}



// Direct3D Func
///////////////////////////////////////////////////////////////////////////////
HRESULT SetMaterial( LPDIRECT3DDEVICE2 lpDev, LPMATERIAL lpMaterial )
{
	HRESULT hresult = lpMaterial->lpD3DMaterial->SetMaterial( &lpMaterial->Material );
	if ( hresult != D3D_OK )
		return hresult;

	return lpMaterial->lpD3DMaterial->GetHandle( lpDev, &lpMaterial->Handle );
}

HRESULT SetAsCurrent( LPDIRECT3DDEVICE2 lpDev, LPMATERIAL lpMaterial )
{
	HRESULT hresult = lpDev->SetLightState( D3DLIGHTSTATE_MATERIAL, lpMaterial->Handle );
	if ( hresult != D3D_OK )
		return hresult;

	return lpDev->SetRenderState( D3DRENDERSTATE_TEXTUREHANDLE, lpMaterial->Material.hTexture );
}

HRESULT SetAsBackground( LPDIRECT3D2 lpD3D, LPDIRECT3DDEVICE2 lpDev, LPDIRECT3DVIEWPORT2 lpViewport, LPMATERIAL lpMaterial )
{
	HRESULT hresult;

	if ( !lpMaterial->lpD3DMaterial )
	{
		hresult = lpD3D->CreateMaterial( &lpMaterial->lpD3DMaterial, NULL );
		if ( hresult != D3D_OK )
			return hresult;
	}

	lpMaterial->Material.dwRampSize = 1;

	hresult = lpMaterial->lpD3DMaterial->SetMaterial( &lpMaterial->Material );
	if ( hresult != D3D_OK )
		return hresult;

	hresult = lpMaterial->lpD3DMaterial->GetHandle( lpDev, &lpMaterial->Handle );
	if ( hresult != D3D_OK )
		return hresult;

	return lpViewport->SetBackground( lpMaterial->Handle );
}


HRESULT SetupMaterial( LPDIRECTDRAW2 lpDD, LPDIRECT3D2 lpD3D, LPDIRECT3DDEVICE2 lpDev, LPMATERIAL lpMaterial, LPTEXTURE *lpTexture )
{
	LPMATERIAL material = lpMaterial;

	HRESULT hresult;
	while ( material )
	{
		hresult = lpD3D->CreateMaterial( &material->lpD3DMaterial, NULL );
		if ( hresult != D3D_OK )
		{
			MESSAGE( "lpD3D->CreateMaterial(%s)", material->szName );
			return hresult;
		}

		if ( strcmp( material->szTextureName, "NOTEXTURE" ) )
		{
			LPTEXTURE texture = LoadTexture( lpDD, lpDev, lpTexture, material->szTextureName );
			if ( texture )
				material->Material.hTexture = texture->Handle;
		}

		hresult = material->lpD3DMaterial->SetMaterial( &material->Material );
		if ( hresult != D3D_OK )
		{
			MESSAGE( "material->lpD3DMaterial->SetMaterial(%s)", material->szName );
			return hresult;
		}

		hresult = material->lpD3DMaterial->GetHandle( lpDev, &material->Handle );
		if ( hresult != D3D_OK )
		{
			MESSAGE( "material->lpD3DMaterial->GetHandle(%s)", material->szName );
			return hresult;
		}

		material = material->lpNext;
	}

	return D3D_OK;
}

