#ifndef __Material_H__
#define __Material_H__

#include "D3DIM.H"

#include "Texture.H"

typedef struct _MATERIAL {
	WORD				shadeType;			// Shading type
	                                        // [1=flat 2=gour. 3=phong 4=metal] 
	D3DMATERIAL         Material;
	LPDIRECT3DMATERIAL2 lpD3DMaterial;

	D3DMATERIALHANDLE   Handle;

	char    			szTextureName[100];

	char    			szName[100];
	_MATERIAL         	*lpNext;
} MATERIAL, *LPMATERIAL;


// Material List
///////////////////////////////////////////////////////////////////////////////
LPMATERIAL FindMaterial( LPMATERIAL lpMaterial, char* lpszName );

LPMATERIAL CreateMaterial( char* lpszName );
LPMATERIAL CreateMaterial( LPMATERIAL lpMaterial, char* lpszName );

void DestroyMaterial( LPMATERIAL lpMaterial );

void AddMaterial( LPMATERIAL lpMaterial, LPMATERIAL lpChildMaterial );


// Direct3D Func
///////////////////////////////////////////////////////////////////////////////
HRESULT SetMaterial( LPDIRECT3DDEVICE2 lpDev, LPMATERIAL lpMaterial );

HRESULT SetAsCurrent( LPDIRECT3DDEVICE2 lpDev, LPMATERIAL lpMaterial );
HRESULT SetAsBackground( LPDIRECT3D2 lpD3D, LPDIRECT3DDEVICE2 lpDev, LPDIRECT3DVIEWPORT2 lpViewport, LPMATERIAL lpMaterial );

HRESULT SetupMaterial( LPDIRECTDRAW2 lpDD, LPDIRECT3D2 lpD3D, LPDIRECT3DDEVICE2 lpDev, LPMATERIAL lpMaterial, LPTEXTURE *lpTexture );


#endif

