#ifndef __Matrix_H__
#define __Matrix_H__

#include "D3DIM.H"

extern const float pi;


D3DMATRIX ZeroMatrix();

D3DMATRIX IdentityMatrix();
 
D3DMATRIX ProjectionMatrix( const float near_plane, 
				            const float far_plane, 
				            const float fov );

D3DMATRIX ViewMatrix( const D3DVECTOR& from, 
		              const D3DVECTOR& at, 
		              const D3DVECTOR& world_up, 
		              const float roll=0.0f );

D3DMATRIX RotateXMatrix( const float rads );
D3DMATRIX RotateYMatrix( const float rads );
D3DMATRIX RotateZMatrix( const float rads );


D3DMATRIX TranslateXMatrix( const float dx );
D3DMATRIX TranslateYMatrix( const float dx );
D3DMATRIX TranslateZMatrix( const float dx );

D3DMATRIX TranslateMatrix( const float dx, const float dy, const float dz );
D3DMATRIX TranslateMatrix( const D3DVECTOR& v );


D3DMATRIX ScaleMatrix( const float size );
D3DMATRIX ScaleMatrix( const float a, const float b, const float c );
D3DMATRIX ScaleMatrix( const D3DVECTOR& v );


D3DMATRIX MatrixMult( const D3DMATRIX & a, const D3DMATRIX & b );

D3DVECTOR TransformVector( const D3DVECTOR& v, const D3DMATRIX & m );
D3DVECTOR TransformNormal( const D3DVECTOR& v, const D3DMATRIX & mat );

D3DMATRIX MatrixInverse( const D3DMATRIX & m );
D3DMATRIX MatrixTranspose( const D3DMATRIX & m );

#endif
